/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimException {
    STUDENT,
    DISABLED,
    NULL;


    public static ClaimException fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("student".equals(codeString)) {
            return STUDENT;
        }
        if ("disabled".equals(codeString)) {
            return DISABLED;
        }
        throw new FHIRException("Unknown ClaimException code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case STUDENT: {
                return "student";
            }
            case DISABLED: {
                return "disabled";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/claim-exception";
    }

    public String getDefinition() {
        switch (this) {
            case STUDENT: {
                return "Fulltime Student";
            }
            case DISABLED: {
                return "Disabled";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case STUDENT: {
                return "Student (Fulltime)";
            }
            case DISABLED: {
                return "Disabled";
            }
        }
        return "?";
    }
}

