/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CarePlanActivityStatus {
    NOTSTARTED,
    SCHEDULED,
    INPROGRESS,
    ONHOLD,
    COMPLETED,
    CANCELLED,
    NULL;


    public static CarePlanActivityStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-started".equals(codeString)) {
            return NOTSTARTED;
        }
        if ("scheduled".equals(codeString)) {
            return SCHEDULED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTSTARTED: {
                return "not-started";
            }
            case SCHEDULED: {
                return "scheduled";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case COMPLETED: {
                return "completed";
            }
            case CANCELLED: {
                return "cancelled";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-plan-activity-status";
    }

    public String getDefinition() {
        switch (this) {
            case NOTSTARTED: {
                return "Activity is planned but no action has yet been taken.";
            }
            case SCHEDULED: {
                return "Appointment or other booking has occurred but activity has not yet begun.";
            }
            case INPROGRESS: {
                return "Activity has been started but is not yet complete.";
            }
            case ONHOLD: {
                return "Activity was started but has temporarily ceased with an expectation of resumption at a future time.";
            }
            case COMPLETED: {
                return "The activities have been completed (more or less) as planned.";
            }
            case CANCELLED: {
                return "The activities have been ended prior to completion (perhaps even before they were started).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTSTARTED: {
                return "Not Started";
            }
            case SCHEDULED: {
                return "Scheduled";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case COMPLETED: {
                return "Completed";
            }
            case CANCELLED: {
                return "Cancelled";
            }
        }
        return "?";
    }
}

