/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Observation;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Specimen;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Sequence", profile="http://hl7.org/fhir/Profile/Sequence")
public class Sequence
extends DomainResource {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="AA | DNA | RNA", formalDefinition="Amino acid / cDNA transcript / RNA variation.")
    protected Enumeration<SequenceType> type;
    @Child(name="patient", type={Patient.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what this is about", formalDefinition="The patient, or group of patients whose sequencing results are described by this resource.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="specimen", type={Specimen.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specimen used for sequencing", formalDefinition="Specimen used for sequencing.")
    protected Reference specimen;
    protected Specimen specimenTarget;
    @Child(name="device", type={Device.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The method for sequencing", formalDefinition="The method for sequencing, for example, chip information.")
    protected Reference device;
    protected Device deviceTarget;
    @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Quantity of the sequence", formalDefinition="Quantity of the sequence.")
    protected Quantity quantity;
    @Child(name="species", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting tests of human, viruses, and bacteria", formalDefinition="The organism from which sample of the sequence was extracted. Supporting tests of human, viruses, and bacteria.")
    protected CodeableConcept species;
    @Child(name="referenceSeq", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reference sequence", formalDefinition="Reference Sequence. It can be described in two ways. One is provide the unique identifier of reference sequence submitted to NCBI. The start and end position of window on reference sequence should be defined.  The other way is using  genome build, chromosome number,and also the start, end position of window (this method is specifically for DNA reference sequence) .")
    protected List<SequenceReferenceSeqComponent> referenceSeq;
    @Child(name="variation", type={}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Variation info in this sequence", formalDefinition="Variation info in this sequence.")
    protected SequenceVariationComponent variation;
    @Child(name="quality", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Sequence Quality", formalDefinition="Quality for sequence quality vary by platform reflecting differences in sequencing chemistry and digital processing.")
    protected List<SequenceQualityComponent> quality;
    @Child(name="allelicState", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The level of occurrence of a single DNA Sequence Variation within a set of chromosomes: Heteroplasmic / Homoplasmic / Homozygous / Heterozygous / Hemizygous", formalDefinition="The level of occurrence of a single DNA Sequence Variation within a set of chromosomes. Heterozygous indicates the DNA Sequence Variation is only present in one of the two genes contained in homologous chromosomes. Homozygous indicates the DNA Sequence Variation is present in both genes contained in homologous chromosomes. Hemizygous indicates the DNA Sequence Variation exists in the only single copy of a gene in a non- homologous chromosome (the male X and Y chromosome are non-homologous). Hemiplasmic indicates that the DNA Sequence Variation is present in some but not all of the copies of mitochondrial DNA. Homoplasmic indicates that the DNA Sequence Variation is present in all of the copies of mitochondrial DNA.")
    protected CodeableConcept allelicState;
    @Child(name="allelicFrequency", type={DecimalType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Allele frequencies", formalDefinition="Allele frequencies.")
    protected DecimalType allelicFrequency;
    @Child(name="copyNumberEvent", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Copy Number Event: Values: amplificaiton / deletion / LOH", formalDefinition="Values: amplificaiton / deletion / LOH.")
    protected CodeableConcept copyNumberEvent;
    @Child(name="readCoverage", type={IntegerType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Average number of reads representing a given nucleotide in the reconstructed sequence", formalDefinition="Coverage (read depth or depth) is the average number of reads representing a given nucleotide in the reconstructed sequence.")
    protected IntegerType readCoverage;
    @Child(name="repository", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External repository", formalDefinition="Configurations of the external repository.")
    protected List<SequenceRepositoryComponent> repository;
    @Child(name="pointer", type={Sequence.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Pointer to next atomic sequence", formalDefinition="Pointer to next atomic sequence which at most contains one variation.")
    protected List<Reference> pointer;
    protected List<Sequence> pointerTarget;
    @Child(name="observedSeq", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Observed Sequence", formalDefinition="Observed Sequence.")
    protected StringType observedSeq;
    @Child(name="observation", type={Observation.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Observation-genetics", formalDefinition="Analysis of the sequence.")
    protected Reference observation;
    protected Observation observationTarget;
    @Child(name="structureVariation", type={}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="Structural variant.")
    protected SequenceStructureVariationComponent structureVariation;
    private static final long serialVersionUID = -1153660995L;
    @SearchParamDefinition(name="patient", path="Sequence.patient", description="The subject that the observation is about", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Sequence:patient").toLocked();
    @SearchParamDefinition(name="species", path="Sequence.species", description="The organism from which sample of the sequence was extracted.", type="token")
    public static final String SP_SPECIES = "species";
    public static final TokenClientParam SPECIES = new TokenClientParam("species");
    @SearchParamDefinition(name="coordinate", path="", description="Genomic coordinate of the sequence. For example, a search for sequence in region 1:123-345 can be represented as `coordinate=1$lt345$gt123`", type="composite", compositeOf={"chromosome", "start"})
    public static final String SP_COORDINATE = "coordinate";
    public static final CompositeClientParam<TokenClientParam, NumberClientParam> COORDINATE = new CompositeClientParam("coordinate");
    @SearchParamDefinition(name="start", path="Sequence.variation.start", description="Start position (0-based inclusive) of the sequence", type="number")
    public static final String SP_START = "start";
    public static final NumberClientParam START = new NumberClientParam("start");
    @SearchParamDefinition(name="type", path="Sequence.type", description="The type of the variant: Amino acid / cDNA transcript / RNA variation.", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="chromosome", path="Sequence.referenceSeq.chromosome", description="Chromosome of the sequence", type="token")
    public static final String SP_CHROMOSOME = "chromosome";
    public static final TokenClientParam CHROMOSOME = new TokenClientParam("chromosome");
    @SearchParamDefinition(name="end", path="Sequence.variation.end", description="End position (0-based exclusive) of the sequence", type="number")
    public static final String SP_END = "end";
    public static final NumberClientParam END = new NumberClientParam("end");

    public Sequence() {
    }

    public Sequence(Enumeration<SequenceType> type) {
        this.type = type;
    }

    public Enumeration<SequenceType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<SequenceType>(new SequenceTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Sequence setTypeElement(Enumeration<SequenceType> value) {
        this.type = value;
        return this;
    }

    public SequenceType getType() {
        return this.type == null ? null : (SequenceType)((Object)this.type.getValue());
    }

    public Sequence setType(SequenceType value) {
        if (this.type == null) {
            this.type = new Enumeration<SequenceType>(new SequenceTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Sequence setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Sequence setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getSpecimen() {
        if (this.specimen == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimen = new Reference();
            }
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        return this.specimen != null && !this.specimen.isEmpty();
    }

    public Sequence setSpecimen(Reference value) {
        this.specimen = value;
        return this;
    }

    public Specimen getSpecimenTarget() {
        if (this.specimenTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.specimen");
            }
            if (Configuration.doAutoCreate()) {
                this.specimenTarget = new Specimen();
            }
        }
        return this.specimenTarget;
    }

    public Sequence setSpecimenTarget(Specimen value) {
        this.specimenTarget = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public Sequence setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Device getDeviceTarget() {
        if (this.deviceTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.device");
            }
            if (Configuration.doAutoCreate()) {
                this.deviceTarget = new Device();
            }
        }
        return this.deviceTarget;
    }

    public Sequence setDeviceTarget(Device value) {
        this.deviceTarget = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public Sequence setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public CodeableConcept getSpecies() {
        if (this.species == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.species");
            }
            if (Configuration.doAutoCreate()) {
                this.species = new CodeableConcept();
            }
        }
        return this.species;
    }

    public boolean hasSpecies() {
        return this.species != null && !this.species.isEmpty();
    }

    public Sequence setSpecies(CodeableConcept value) {
        this.species = value;
        return this;
    }

    public List<SequenceReferenceSeqComponent> getReferenceSeq() {
        if (this.referenceSeq == null) {
            this.referenceSeq = new ArrayList<SequenceReferenceSeqComponent>();
        }
        return this.referenceSeq;
    }

    public boolean hasReferenceSeq() {
        if (this.referenceSeq == null) {
            return false;
        }
        for (SequenceReferenceSeqComponent item : this.referenceSeq) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SequenceReferenceSeqComponent addReferenceSeq() {
        SequenceReferenceSeqComponent t = new SequenceReferenceSeqComponent();
        if (this.referenceSeq == null) {
            this.referenceSeq = new ArrayList<SequenceReferenceSeqComponent>();
        }
        this.referenceSeq.add(t);
        return t;
    }

    public Sequence addReferenceSeq(SequenceReferenceSeqComponent t) {
        if (t == null) {
            return this;
        }
        if (this.referenceSeq == null) {
            this.referenceSeq = new ArrayList<SequenceReferenceSeqComponent>();
        }
        this.referenceSeq.add(t);
        return this;
    }

    public SequenceVariationComponent getVariation() {
        if (this.variation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.variation");
            }
            if (Configuration.doAutoCreate()) {
                this.variation = new SequenceVariationComponent();
            }
        }
        return this.variation;
    }

    public boolean hasVariation() {
        return this.variation != null && !this.variation.isEmpty();
    }

    public Sequence setVariation(SequenceVariationComponent value) {
        this.variation = value;
        return this;
    }

    public List<SequenceQualityComponent> getQuality() {
        if (this.quality == null) {
            this.quality = new ArrayList<SequenceQualityComponent>();
        }
        return this.quality;
    }

    public boolean hasQuality() {
        if (this.quality == null) {
            return false;
        }
        for (SequenceQualityComponent item : this.quality) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SequenceQualityComponent addQuality() {
        SequenceQualityComponent t = new SequenceQualityComponent();
        if (this.quality == null) {
            this.quality = new ArrayList<SequenceQualityComponent>();
        }
        this.quality.add(t);
        return t;
    }

    public Sequence addQuality(SequenceQualityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.quality == null) {
            this.quality = new ArrayList<SequenceQualityComponent>();
        }
        this.quality.add(t);
        return this;
    }

    public CodeableConcept getAllelicState() {
        if (this.allelicState == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.allelicState");
            }
            if (Configuration.doAutoCreate()) {
                this.allelicState = new CodeableConcept();
            }
        }
        return this.allelicState;
    }

    public boolean hasAllelicState() {
        return this.allelicState != null && !this.allelicState.isEmpty();
    }

    public Sequence setAllelicState(CodeableConcept value) {
        this.allelicState = value;
        return this;
    }

    public DecimalType getAllelicFrequencyElement() {
        if (this.allelicFrequency == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.allelicFrequency");
            }
            if (Configuration.doAutoCreate()) {
                this.allelicFrequency = new DecimalType();
            }
        }
        return this.allelicFrequency;
    }

    public boolean hasAllelicFrequencyElement() {
        return this.allelicFrequency != null && !this.allelicFrequency.isEmpty();
    }

    public boolean hasAllelicFrequency() {
        return this.allelicFrequency != null && !this.allelicFrequency.isEmpty();
    }

    public Sequence setAllelicFrequencyElement(DecimalType value) {
        this.allelicFrequency = value;
        return this;
    }

    public BigDecimal getAllelicFrequency() {
        return this.allelicFrequency == null ? null : (BigDecimal)this.allelicFrequency.getValue();
    }

    public Sequence setAllelicFrequency(BigDecimal value) {
        if (value == null) {
            this.allelicFrequency = null;
        } else {
            if (this.allelicFrequency == null) {
                this.allelicFrequency = new DecimalType();
            }
            this.allelicFrequency.setValue(value);
        }
        return this;
    }

    public Sequence setAllelicFrequency(long value) {
        this.allelicFrequency = new DecimalType();
        this.allelicFrequency.setValue(value);
        return this;
    }

    public Sequence setAllelicFrequency(double value) {
        this.allelicFrequency = new DecimalType();
        this.allelicFrequency.setValue(value);
        return this;
    }

    public CodeableConcept getCopyNumberEvent() {
        if (this.copyNumberEvent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.copyNumberEvent");
            }
            if (Configuration.doAutoCreate()) {
                this.copyNumberEvent = new CodeableConcept();
            }
        }
        return this.copyNumberEvent;
    }

    public boolean hasCopyNumberEvent() {
        return this.copyNumberEvent != null && !this.copyNumberEvent.isEmpty();
    }

    public Sequence setCopyNumberEvent(CodeableConcept value) {
        this.copyNumberEvent = value;
        return this;
    }

    public IntegerType getReadCoverageElement() {
        if (this.readCoverage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.readCoverage");
            }
            if (Configuration.doAutoCreate()) {
                this.readCoverage = new IntegerType();
            }
        }
        return this.readCoverage;
    }

    public boolean hasReadCoverageElement() {
        return this.readCoverage != null && !this.readCoverage.isEmpty();
    }

    public boolean hasReadCoverage() {
        return this.readCoverage != null && !this.readCoverage.isEmpty();
    }

    public Sequence setReadCoverageElement(IntegerType value) {
        this.readCoverage = value;
        return this;
    }

    public int getReadCoverage() {
        return this.readCoverage == null || this.readCoverage.isEmpty() ? 0 : (Integer)this.readCoverage.getValue();
    }

    public Sequence setReadCoverage(int value) {
        if (this.readCoverage == null) {
            this.readCoverage = new IntegerType();
        }
        this.readCoverage.setValue((Object)value);
        return this;
    }

    public List<SequenceRepositoryComponent> getRepository() {
        if (this.repository == null) {
            this.repository = new ArrayList<SequenceRepositoryComponent>();
        }
        return this.repository;
    }

    public boolean hasRepository() {
        if (this.repository == null) {
            return false;
        }
        for (SequenceRepositoryComponent item : this.repository) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SequenceRepositoryComponent addRepository() {
        SequenceRepositoryComponent t = new SequenceRepositoryComponent();
        if (this.repository == null) {
            this.repository = new ArrayList<SequenceRepositoryComponent>();
        }
        this.repository.add(t);
        return t;
    }

    public Sequence addRepository(SequenceRepositoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.repository == null) {
            this.repository = new ArrayList<SequenceRepositoryComponent>();
        }
        this.repository.add(t);
        return this;
    }

    public List<Reference> getPointer() {
        if (this.pointer == null) {
            this.pointer = new ArrayList<Reference>();
        }
        return this.pointer;
    }

    public boolean hasPointer() {
        if (this.pointer == null) {
            return false;
        }
        for (Reference item : this.pointer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPointer() {
        Reference t = new Reference();
        if (this.pointer == null) {
            this.pointer = new ArrayList<Reference>();
        }
        this.pointer.add(t);
        return t;
    }

    public Sequence addPointer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.pointer == null) {
            this.pointer = new ArrayList<Reference>();
        }
        this.pointer.add(t);
        return this;
    }

    public List<Sequence> getPointerTarget() {
        if (this.pointerTarget == null) {
            this.pointerTarget = new ArrayList<Sequence>();
        }
        return this.pointerTarget;
    }

    public Sequence addPointerTarget() {
        Sequence r = new Sequence();
        if (this.pointerTarget == null) {
            this.pointerTarget = new ArrayList<Sequence>();
        }
        this.pointerTarget.add(r);
        return r;
    }

    public StringType getObservedSeqElement() {
        if (this.observedSeq == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.observedSeq");
            }
            if (Configuration.doAutoCreate()) {
                this.observedSeq = new StringType();
            }
        }
        return this.observedSeq;
    }

    public boolean hasObservedSeqElement() {
        return this.observedSeq != null && !this.observedSeq.isEmpty();
    }

    public boolean hasObservedSeq() {
        return this.observedSeq != null && !this.observedSeq.isEmpty();
    }

    public Sequence setObservedSeqElement(StringType value) {
        this.observedSeq = value;
        return this;
    }

    public String getObservedSeq() {
        return this.observedSeq == null ? null : (String)this.observedSeq.getValue();
    }

    public Sequence setObservedSeq(String value) {
        if (Utilities.noString(value)) {
            this.observedSeq = null;
        } else {
            if (this.observedSeq == null) {
                this.observedSeq = new StringType();
            }
            this.observedSeq.setValue(value);
        }
        return this;
    }

    public Reference getObservation() {
        if (this.observation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.observation");
            }
            if (Configuration.doAutoCreate()) {
                this.observation = new Reference();
            }
        }
        return this.observation;
    }

    public boolean hasObservation() {
        return this.observation != null && !this.observation.isEmpty();
    }

    public Sequence setObservation(Reference value) {
        this.observation = value;
        return this;
    }

    public Observation getObservationTarget() {
        if (this.observationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.observation");
            }
            if (Configuration.doAutoCreate()) {
                this.observationTarget = new Observation();
            }
        }
        return this.observationTarget;
    }

    public Sequence setObservationTarget(Observation value) {
        this.observationTarget = value;
        return this;
    }

    public SequenceStructureVariationComponent getStructureVariation() {
        if (this.structureVariation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Sequence.structureVariation");
            }
            if (Configuration.doAutoCreate()) {
                this.structureVariation = new SequenceStructureVariationComponent();
            }
        }
        return this.structureVariation;
    }

    public boolean hasStructureVariation() {
        return this.structureVariation != null && !this.structureVariation.isEmpty();
    }

    public Sequence setStructureVariation(SequenceStructureVariationComponent value) {
        this.structureVariation = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_TYPE, "code", "Amino acid / cDNA transcript / RNA variation.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient, or group of patients whose sequencing results are described by this resource.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("specimen", "Reference(Specimen)", "Specimen used for sequencing.", 0, Integer.MAX_VALUE, this.specimen));
        childrenList.add(new Property("device", "Reference(Device)", "The method for sequencing, for example, chip information.", 0, Integer.MAX_VALUE, this.device));
        childrenList.add(new Property("quantity", "Quantity", "Quantity of the sequence.", 0, Integer.MAX_VALUE, this.quantity));
        childrenList.add(new Property(SP_SPECIES, "CodeableConcept", "The organism from which sample of the sequence was extracted. Supporting tests of human, viruses, and bacteria.", 0, Integer.MAX_VALUE, this.species));
        childrenList.add(new Property("referenceSeq", "", "Reference Sequence. It can be described in two ways. One is provide the unique identifier of reference sequence submitted to NCBI. The start and end position of window on reference sequence should be defined.  The other way is using  genome build, chromosome number,and also the start, end position of window (this method is specifically for DNA reference sequence) .", 0, Integer.MAX_VALUE, this.referenceSeq));
        childrenList.add(new Property("variation", "", "Variation info in this sequence.", 0, Integer.MAX_VALUE, this.variation));
        childrenList.add(new Property("quality", "", "Quality for sequence quality vary by platform reflecting differences in sequencing chemistry and digital processing.", 0, Integer.MAX_VALUE, this.quality));
        childrenList.add(new Property("allelicState", "CodeableConcept", "The level of occurrence of a single DNA Sequence Variation within a set of chromosomes. Heterozygous indicates the DNA Sequence Variation is only present in one of the two genes contained in homologous chromosomes. Homozygous indicates the DNA Sequence Variation is present in both genes contained in homologous chromosomes. Hemizygous indicates the DNA Sequence Variation exists in the only single copy of a gene in a non- homologous chromosome (the male X and Y chromosome are non-homologous). Hemiplasmic indicates that the DNA Sequence Variation is present in some but not all of the copies of mitochondrial DNA. Homoplasmic indicates that the DNA Sequence Variation is present in all of the copies of mitochondrial DNA.", 0, Integer.MAX_VALUE, this.allelicState));
        childrenList.add(new Property("allelicFrequency", "decimal", "Allele frequencies.", 0, Integer.MAX_VALUE, this.allelicFrequency));
        childrenList.add(new Property("copyNumberEvent", "CodeableConcept", "Values: amplificaiton / deletion / LOH.", 0, Integer.MAX_VALUE, this.copyNumberEvent));
        childrenList.add(new Property("readCoverage", "integer", "Coverage (read depth or depth) is the average number of reads representing a given nucleotide in the reconstructed sequence.", 0, Integer.MAX_VALUE, this.readCoverage));
        childrenList.add(new Property("repository", "", "Configurations of the external repository.", 0, Integer.MAX_VALUE, this.repository));
        childrenList.add(new Property("pointer", "Reference(Sequence)", "Pointer to next atomic sequence which at most contains one variation.", 0, Integer.MAX_VALUE, this.pointer));
        childrenList.add(new Property("observedSeq", "string", "Observed Sequence.", 0, Integer.MAX_VALUE, this.observedSeq));
        childrenList.add(new Property("observation", "Reference(Observation)", "Analysis of the sequence.", 0, Integer.MAX_VALUE, this.observation));
        childrenList.add(new Property("structureVariation", "", "Structural variant.", 0, Integer.MAX_VALUE, this.structureVariation));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -2132868344: {
                Base[] baseArray;
                if (this.specimen == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.specimen;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.device;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.quantity;
                }
                return baseArray;
            }
            case -2008465092: {
                Base[] baseArray;
                if (this.species == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.species;
                }
                return baseArray;
            }
            case -502547180: {
                return this.referenceSeq == null ? new Base[]{} : this.referenceSeq.toArray(new Base[this.referenceSeq.size()]);
            }
            case -81944045: {
                Base[] baseArray;
                if (this.variation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.variation;
                }
                return baseArray;
            }
            case 651215103: {
                return this.quality == null ? new Base[]{} : this.quality.toArray(new Base[this.quality.size()]);
            }
            case 2079026319: {
                Base[] baseArray;
                if (this.allelicState == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.allelicState;
                }
                return baseArray;
            }
            case 8650330: {
                Base[] baseArray;
                if (this.allelicFrequency == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.allelicFrequency;
                }
                return baseArray;
            }
            case 960854556: {
                Base[] baseArray;
                if (this.copyNumberEvent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.copyNumberEvent;
                }
                return baseArray;
            }
            case -1798816354: {
                Base[] baseArray;
                if (this.readCoverage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.readCoverage;
                }
                return baseArray;
            }
            case 1950800714: {
                return this.repository == null ? new Base[]{} : this.repository.toArray(new Base[this.repository.size()]);
            }
            case -400605635: {
                return this.pointer == null ? new Base[]{} : this.pointer.toArray(new Base[this.pointer.size()]);
            }
            case 125541495: {
                Base[] baseArray;
                if (this.observedSeq == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.observedSeq;
                }
                return baseArray;
            }
            case 122345516: {
                Base[] baseArray;
                if (this.observation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.observation;
                }
                return baseArray;
            }
            case 1886586336: {
                Base[] baseArray;
                if (this.structureVariation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.structureVariation;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.type = new SequenceTypeEnumFactory().fromType(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -2132868344: {
                this.specimen = this.castToReference(value);
                break;
            }
            case -1335157162: {
                this.device = this.castToReference(value);
                break;
            }
            case -1285004149: {
                this.quantity = this.castToQuantity(value);
                break;
            }
            case -2008465092: {
                this.species = this.castToCodeableConcept(value);
                break;
            }
            case -502547180: {
                this.getReferenceSeq().add((SequenceReferenceSeqComponent)value);
                break;
            }
            case -81944045: {
                this.variation = (SequenceVariationComponent)value;
                break;
            }
            case 651215103: {
                this.getQuality().add((SequenceQualityComponent)value);
                break;
            }
            case 2079026319: {
                this.allelicState = this.castToCodeableConcept(value);
                break;
            }
            case 8650330: {
                this.allelicFrequency = this.castToDecimal(value);
                break;
            }
            case 960854556: {
                this.copyNumberEvent = this.castToCodeableConcept(value);
                break;
            }
            case -1798816354: {
                this.readCoverage = this.castToInteger(value);
                break;
            }
            case 1950800714: {
                this.getRepository().add((SequenceRepositoryComponent)value);
                break;
            }
            case -400605635: {
                this.getPointer().add(this.castToReference(value));
                break;
            }
            case 125541495: {
                this.observedSeq = this.castToString(value);
                break;
            }
            case 122345516: {
                this.observation = this.castToReference(value);
                break;
            }
            case 1886586336: {
                this.structureVariation = (SequenceStructureVariationComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TYPE)) {
            this.type = new SequenceTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("specimen")) {
            this.specimen = this.castToReference(value);
        } else if (name.equals("device")) {
            this.device = this.castToReference(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToQuantity(value);
        } else if (name.equals(SP_SPECIES)) {
            this.species = this.castToCodeableConcept(value);
        } else if (name.equals("referenceSeq")) {
            this.getReferenceSeq().add((SequenceReferenceSeqComponent)value);
        } else if (name.equals("variation")) {
            this.variation = (SequenceVariationComponent)value;
        } else if (name.equals("quality")) {
            this.getQuality().add((SequenceQualityComponent)value);
        } else if (name.equals("allelicState")) {
            this.allelicState = this.castToCodeableConcept(value);
        } else if (name.equals("allelicFrequency")) {
            this.allelicFrequency = this.castToDecimal(value);
        } else if (name.equals("copyNumberEvent")) {
            this.copyNumberEvent = this.castToCodeableConcept(value);
        } else if (name.equals("readCoverage")) {
            this.readCoverage = this.castToInteger(value);
        } else if (name.equals("repository")) {
            this.getRepository().add((SequenceRepositoryComponent)value);
        } else if (name.equals("pointer")) {
            this.getPointer().add(this.castToReference(value));
        } else if (name.equals("observedSeq")) {
            this.observedSeq = this.castToString(value);
        } else if (name.equals("observation")) {
            this.observation = this.castToReference(value);
        } else if (name.equals("structureVariation")) {
            this.structureVariation = (SequenceStructureVariationComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -791418107: {
                return this.getPatient();
            }
            case -2132868344: {
                return this.getSpecimen();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case -2008465092: {
                return this.getSpecies();
            }
            case -502547180: {
                return this.addReferenceSeq();
            }
            case -81944045: {
                return this.getVariation();
            }
            case 651215103: {
                return this.addQuality();
            }
            case 2079026319: {
                return this.getAllelicState();
            }
            case 8650330: {
                throw new FHIRException("Cannot make property allelicFrequency as it is not a complex type");
            }
            case 960854556: {
                return this.getCopyNumberEvent();
            }
            case -1798816354: {
                throw new FHIRException("Cannot make property readCoverage as it is not a complex type");
            }
            case 1950800714: {
                return this.addRepository();
            }
            case -400605635: {
                return this.addPointer();
            }
            case 125541495: {
                throw new FHIRException("Cannot make property observedSeq as it is not a complex type");
            }
            case 122345516: {
                return this.getObservation();
            }
            case 1886586336: {
                return this.getStructureVariation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Sequence.type");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("specimen")) {
            this.specimen = new Reference();
            return this.specimen;
        }
        if (name.equals("device")) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals(SP_SPECIES)) {
            this.species = new CodeableConcept();
            return this.species;
        }
        if (name.equals("referenceSeq")) {
            return this.addReferenceSeq();
        }
        if (name.equals("variation")) {
            this.variation = new SequenceVariationComponent();
            return this.variation;
        }
        if (name.equals("quality")) {
            return this.addQuality();
        }
        if (name.equals("allelicState")) {
            this.allelicState = new CodeableConcept();
            return this.allelicState;
        }
        if (name.equals("allelicFrequency")) {
            throw new FHIRException("Cannot call addChild on a primitive type Sequence.allelicFrequency");
        }
        if (name.equals("copyNumberEvent")) {
            this.copyNumberEvent = new CodeableConcept();
            return this.copyNumberEvent;
        }
        if (name.equals("readCoverage")) {
            throw new FHIRException("Cannot call addChild on a primitive type Sequence.readCoverage");
        }
        if (name.equals("repository")) {
            return this.addRepository();
        }
        if (name.equals("pointer")) {
            return this.addPointer();
        }
        if (name.equals("observedSeq")) {
            throw new FHIRException("Cannot call addChild on a primitive type Sequence.observedSeq");
        }
        if (name.equals("observation")) {
            this.observation = new Reference();
            return this.observation;
        }
        if (name.equals("structureVariation")) {
            this.structureVariation = new SequenceStructureVariationComponent();
            return this.structureVariation;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Sequence";
    }

    @Override
    public Sequence copy() {
        Sequence dst = new Sequence();
        this.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.specimen = this.specimen == null ? null : this.specimen.copy();
        dst.device = this.device == null ? null : this.device.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        CodeableConcept codeableConcept = dst.species = this.species == null ? null : this.species.copy();
        if (this.referenceSeq != null) {
            dst.referenceSeq = new ArrayList<SequenceReferenceSeqComponent>();
            for (SequenceReferenceSeqComponent sequenceReferenceSeqComponent : this.referenceSeq) {
                dst.referenceSeq.add(sequenceReferenceSeqComponent.copy());
            }
        }
        SequenceVariationComponent sequenceVariationComponent = dst.variation = this.variation == null ? null : this.variation.copy();
        if (this.quality != null) {
            dst.quality = new ArrayList<SequenceQualityComponent>();
            for (SequenceQualityComponent sequenceQualityComponent : this.quality) {
                dst.quality.add(sequenceQualityComponent.copy());
            }
        }
        dst.allelicState = this.allelicState == null ? null : this.allelicState.copy();
        dst.allelicFrequency = this.allelicFrequency == null ? null : this.allelicFrequency.copy();
        dst.copyNumberEvent = this.copyNumberEvent == null ? null : this.copyNumberEvent.copy();
        IntegerType integerType = dst.readCoverage = this.readCoverage == null ? null : this.readCoverage.copy();
        if (this.repository != null) {
            dst.repository = new ArrayList<SequenceRepositoryComponent>();
            for (SequenceRepositoryComponent sequenceRepositoryComponent : this.repository) {
                dst.repository.add(sequenceRepositoryComponent.copy());
            }
        }
        if (this.pointer != null) {
            dst.pointer = new ArrayList<Reference>();
            for (Reference reference : this.pointer) {
                dst.pointer.add(reference.copy());
            }
        }
        dst.observedSeq = this.observedSeq == null ? null : this.observedSeq.copy();
        dst.observation = this.observation == null ? null : this.observation.copy();
        dst.structureVariation = this.structureVariation == null ? null : this.structureVariation.copy();
        return dst;
    }

    protected Sequence typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Sequence)) {
            return false;
        }
        Sequence o = (Sequence)other;
        return Sequence.compareDeep(this.type, o.type, true) && Sequence.compareDeep(this.patient, o.patient, true) && Sequence.compareDeep(this.specimen, o.specimen, true) && Sequence.compareDeep(this.device, o.device, true) && Sequence.compareDeep(this.quantity, o.quantity, true) && Sequence.compareDeep(this.species, o.species, true) && Sequence.compareDeep(this.referenceSeq, o.referenceSeq, true) && Sequence.compareDeep(this.variation, o.variation, true) && Sequence.compareDeep(this.quality, o.quality, true) && Sequence.compareDeep(this.allelicState, o.allelicState, true) && Sequence.compareDeep(this.allelicFrequency, o.allelicFrequency, true) && Sequence.compareDeep(this.copyNumberEvent, o.copyNumberEvent, true) && Sequence.compareDeep(this.readCoverage, o.readCoverage, true) && Sequence.compareDeep(this.repository, o.repository, true) && Sequence.compareDeep(this.pointer, o.pointer, true) && Sequence.compareDeep(this.observedSeq, o.observedSeq, true) && Sequence.compareDeep(this.observation, o.observation, true) && Sequence.compareDeep(this.structureVariation, o.structureVariation, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Sequence)) {
            return false;
        }
        Sequence o = (Sequence)other;
        return Sequence.compareValues(this.type, o.type, true) && Sequence.compareValues(this.allelicFrequency, o.allelicFrequency, true) && Sequence.compareValues(this.readCoverage, o.readCoverage, true) && Sequence.compareValues(this.observedSeq, o.observedSeq, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.specimen != null && !this.specimen.isEmpty() || this.device != null && !this.device.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.species != null && !this.species.isEmpty() || this.referenceSeq != null && !this.referenceSeq.isEmpty() || this.variation != null && !this.variation.isEmpty() || this.quality != null && !this.quality.isEmpty() || this.allelicState != null && !this.allelicState.isEmpty() || this.allelicFrequency != null && !this.allelicFrequency.isEmpty() || this.copyNumberEvent != null && !this.copyNumberEvent.isEmpty() || this.readCoverage != null && !this.readCoverage.isEmpty() || this.repository != null && !this.repository.isEmpty() || this.pointer != null && !this.pointer.isEmpty() || this.observedSeq != null && !this.observedSeq.isEmpty() || this.observation != null && !this.observation.isEmpty() || this.structureVariation != null && !this.structureVariation.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Sequence;
    }

    @Block
    public static class SequenceStructureVariationInnerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural Variant Inner Start-End", formalDefinition="Structural Variant Inner Start-End.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural Variant Inner Start-End", formalDefinition="Structural Variant Inner Start-End.")
        protected IntegerType end;
        private static final long serialVersionUID = -1798864889L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationInnerComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public SequenceStructureVariationInnerComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public SequenceStructureVariationInnerComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationInnerComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public SequenceStructureVariationInnerComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public SequenceStructureVariationInnerComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Sequence.SP_START, "integer", "Structural Variant Inner Start-End.", 0, Integer.MAX_VALUE, this.start));
            childrenList.add(new Property(Sequence.SP_END, "integer", "Structural Variant Inner Start-End.", 0, Integer.MAX_VALUE, this.end));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = this.castToInteger(value);
                    break;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                this.start = this.castToInteger(value);
            } else if (name.equals(Sequence.SP_END)) {
                this.end = this.castToInteger(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    throw new FHIRException("Cannot make property start as it is not a complex type");
                }
                case 100571: {
                    throw new FHIRException("Cannot make property end as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.start");
            }
            if (name.equals(Sequence.SP_END)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.end");
            }
            return super.addChild(name);
        }

        @Override
        public SequenceStructureVariationInnerComponent copy() {
            SequenceStructureVariationInnerComponent dst = new SequenceStructureVariationInnerComponent();
            this.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SequenceStructureVariationInnerComponent)) {
                return false;
            }
            SequenceStructureVariationInnerComponent o = (SequenceStructureVariationInnerComponent)other;
            return SequenceStructureVariationInnerComponent.compareDeep(this.start, o.start, true) && SequenceStructureVariationInnerComponent.compareDeep(this.end, o.end, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SequenceStructureVariationInnerComponent)) {
                return false;
            }
            SequenceStructureVariationInnerComponent o = (SequenceStructureVariationInnerComponent)other;
            return SequenceStructureVariationInnerComponent.compareValues(this.start, o.start, true) && SequenceStructureVariationInnerComponent.compareValues(this.end, o.end, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.start != null && !this.start.isEmpty() || this.end != null && !this.end.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Sequence.structureVariation.inner";
        }
    }

    @Block
    public static class SequenceStructureVariationOuterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural Variant Outer Start-End", formalDefinition="Structural Variant Outer Start-End.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural Variant Outer Start-End", formalDefinition="Structural Variant Outer Start-End.")
        protected IntegerType end;
        private static final long serialVersionUID = -1798864889L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationOuterComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public SequenceStructureVariationOuterComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public SequenceStructureVariationOuterComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationOuterComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public SequenceStructureVariationOuterComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public SequenceStructureVariationOuterComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Sequence.SP_START, "integer", "Structural Variant Outer Start-End.", 0, Integer.MAX_VALUE, this.start));
            childrenList.add(new Property(Sequence.SP_END, "integer", "Structural Variant Outer Start-End.", 0, Integer.MAX_VALUE, this.end));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = this.castToInteger(value);
                    break;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                this.start = this.castToInteger(value);
            } else if (name.equals(Sequence.SP_END)) {
                this.end = this.castToInteger(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    throw new FHIRException("Cannot make property start as it is not a complex type");
                }
                case 100571: {
                    throw new FHIRException("Cannot make property end as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.start");
            }
            if (name.equals(Sequence.SP_END)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.end");
            }
            return super.addChild(name);
        }

        @Override
        public SequenceStructureVariationOuterComponent copy() {
            SequenceStructureVariationOuterComponent dst = new SequenceStructureVariationOuterComponent();
            this.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SequenceStructureVariationOuterComponent)) {
                return false;
            }
            SequenceStructureVariationOuterComponent o = (SequenceStructureVariationOuterComponent)other;
            return SequenceStructureVariationOuterComponent.compareDeep(this.start, o.start, true) && SequenceStructureVariationOuterComponent.compareDeep(this.end, o.end, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SequenceStructureVariationOuterComponent)) {
                return false;
            }
            SequenceStructureVariationOuterComponent o = (SequenceStructureVariationOuterComponent)other;
            return SequenceStructureVariationOuterComponent.compareValues(this.start, o.start, true) && SequenceStructureVariationOuterComponent.compareValues(this.end, o.end, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.start != null && !this.start.isEmpty() || this.end != null && !this.end.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Sequence.structureVariation.outer";
        }
    }

    @Block
    public static class SequenceStructureVariationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="precisionOfBoundaries", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Precision of boundaries", formalDefinition="Precision of boundaries.")
        protected StringType precisionOfBoundaries;
        @Child(name="reportedaCGHRatio", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural Variant reported aCGH ratio", formalDefinition="Structural Variant reported aCGH ratio.")
        protected DecimalType reportedaCGHRatio;
        @Child(name="length", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Structural Variant Length", formalDefinition="Structural Variant Length.")
        protected IntegerType length;
        @Child(name="outer", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="", formalDefinition="Structural variant outer.")
        protected SequenceStructureVariationOuterComponent outer;
        @Child(name="inner", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="", formalDefinition="Structural variant inner.")
        protected SequenceStructureVariationInnerComponent inner;
        private static final long serialVersionUID = -1615654736L;

        public StringType getPrecisionOfBoundariesElement() {
            if (this.precisionOfBoundaries == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationComponent.precisionOfBoundaries");
                }
                if (Configuration.doAutoCreate()) {
                    this.precisionOfBoundaries = new StringType();
                }
            }
            return this.precisionOfBoundaries;
        }

        public boolean hasPrecisionOfBoundariesElement() {
            return this.precisionOfBoundaries != null && !this.precisionOfBoundaries.isEmpty();
        }

        public boolean hasPrecisionOfBoundaries() {
            return this.precisionOfBoundaries != null && !this.precisionOfBoundaries.isEmpty();
        }

        public SequenceStructureVariationComponent setPrecisionOfBoundariesElement(StringType value) {
            this.precisionOfBoundaries = value;
            return this;
        }

        public String getPrecisionOfBoundaries() {
            return this.precisionOfBoundaries == null ? null : (String)this.precisionOfBoundaries.getValue();
        }

        public SequenceStructureVariationComponent setPrecisionOfBoundaries(String value) {
            if (Utilities.noString(value)) {
                this.precisionOfBoundaries = null;
            } else {
                if (this.precisionOfBoundaries == null) {
                    this.precisionOfBoundaries = new StringType();
                }
                this.precisionOfBoundaries.setValue(value);
            }
            return this;
        }

        public DecimalType getReportedaCGHRatioElement() {
            if (this.reportedaCGHRatio == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationComponent.reportedaCGHRatio");
                }
                if (Configuration.doAutoCreate()) {
                    this.reportedaCGHRatio = new DecimalType();
                }
            }
            return this.reportedaCGHRatio;
        }

        public boolean hasReportedaCGHRatioElement() {
            return this.reportedaCGHRatio != null && !this.reportedaCGHRatio.isEmpty();
        }

        public boolean hasReportedaCGHRatio() {
            return this.reportedaCGHRatio != null && !this.reportedaCGHRatio.isEmpty();
        }

        public SequenceStructureVariationComponent setReportedaCGHRatioElement(DecimalType value) {
            this.reportedaCGHRatio = value;
            return this;
        }

        public BigDecimal getReportedaCGHRatio() {
            return this.reportedaCGHRatio == null ? null : (BigDecimal)this.reportedaCGHRatio.getValue();
        }

        public SequenceStructureVariationComponent setReportedaCGHRatio(BigDecimal value) {
            if (value == null) {
                this.reportedaCGHRatio = null;
            } else {
                if (this.reportedaCGHRatio == null) {
                    this.reportedaCGHRatio = new DecimalType();
                }
                this.reportedaCGHRatio.setValue(value);
            }
            return this;
        }

        public SequenceStructureVariationComponent setReportedaCGHRatio(long value) {
            this.reportedaCGHRatio = new DecimalType();
            this.reportedaCGHRatio.setValue(value);
            return this;
        }

        public SequenceStructureVariationComponent setReportedaCGHRatio(double value) {
            this.reportedaCGHRatio = new DecimalType();
            this.reportedaCGHRatio.setValue(value);
            return this;
        }

        public IntegerType getLengthElement() {
            if (this.length == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationComponent.length");
                }
                if (Configuration.doAutoCreate()) {
                    this.length = new IntegerType();
                }
            }
            return this.length;
        }

        public boolean hasLengthElement() {
            return this.length != null && !this.length.isEmpty();
        }

        public boolean hasLength() {
            return this.length != null && !this.length.isEmpty();
        }

        public SequenceStructureVariationComponent setLengthElement(IntegerType value) {
            this.length = value;
            return this;
        }

        public int getLength() {
            return this.length == null || this.length.isEmpty() ? 0 : (Integer)this.length.getValue();
        }

        public SequenceStructureVariationComponent setLength(int value) {
            if (this.length == null) {
                this.length = new IntegerType();
            }
            this.length.setValue((Object)value);
            return this;
        }

        public SequenceStructureVariationOuterComponent getOuter() {
            if (this.outer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationComponent.outer");
                }
                if (Configuration.doAutoCreate()) {
                    this.outer = new SequenceStructureVariationOuterComponent();
                }
            }
            return this.outer;
        }

        public boolean hasOuter() {
            return this.outer != null && !this.outer.isEmpty();
        }

        public SequenceStructureVariationComponent setOuter(SequenceStructureVariationOuterComponent value) {
            this.outer = value;
            return this;
        }

        public SequenceStructureVariationInnerComponent getInner() {
            if (this.inner == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceStructureVariationComponent.inner");
                }
                if (Configuration.doAutoCreate()) {
                    this.inner = new SequenceStructureVariationInnerComponent();
                }
            }
            return this.inner;
        }

        public boolean hasInner() {
            return this.inner != null && !this.inner.isEmpty();
        }

        public SequenceStructureVariationComponent setInner(SequenceStructureVariationInnerComponent value) {
            this.inner = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("precisionOfBoundaries", "string", "Precision of boundaries.", 0, Integer.MAX_VALUE, this.precisionOfBoundaries));
            childrenList.add(new Property("reportedaCGHRatio", "decimal", "Structural Variant reported aCGH ratio.", 0, Integer.MAX_VALUE, this.reportedaCGHRatio));
            childrenList.add(new Property("length", "integer", "Structural Variant Length.", 0, Integer.MAX_VALUE, this.length));
            childrenList.add(new Property("outer", "", "Structural variant outer.", 0, Integer.MAX_VALUE, this.outer));
            childrenList.add(new Property("inner", "", "Structural variant inner.", 0, Integer.MAX_VALUE, this.inner));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1591532317: {
                    Base[] baseArray;
                    if (this.precisionOfBoundaries == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.precisionOfBoundaries;
                    }
                    return baseArray;
                }
                case -1872600587: {
                    Base[] baseArray;
                    if (this.reportedaCGHRatio == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reportedaCGHRatio;
                    }
                    return baseArray;
                }
                case -1106363674: {
                    Base[] baseArray;
                    if (this.length == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.length;
                    }
                    return baseArray;
                }
                case 106111099: {
                    Base[] baseArray;
                    if (this.outer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.outer;
                    }
                    return baseArray;
                }
                case 100355670: {
                    Base[] baseArray;
                    if (this.inner == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.inner;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1591532317: {
                    this.precisionOfBoundaries = this.castToString(value);
                    break;
                }
                case -1872600587: {
                    this.reportedaCGHRatio = this.castToDecimal(value);
                    break;
                }
                case -1106363674: {
                    this.length = this.castToInteger(value);
                    break;
                }
                case 106111099: {
                    this.outer = (SequenceStructureVariationOuterComponent)value;
                    break;
                }
                case 100355670: {
                    this.inner = (SequenceStructureVariationInnerComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("precisionOfBoundaries")) {
                this.precisionOfBoundaries = this.castToString(value);
            } else if (name.equals("reportedaCGHRatio")) {
                this.reportedaCGHRatio = this.castToDecimal(value);
            } else if (name.equals("length")) {
                this.length = this.castToInteger(value);
            } else if (name.equals("outer")) {
                this.outer = (SequenceStructureVariationOuterComponent)value;
            } else if (name.equals("inner")) {
                this.inner = (SequenceStructureVariationInnerComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1591532317: {
                    throw new FHIRException("Cannot make property precisionOfBoundaries as it is not a complex type");
                }
                case -1872600587: {
                    throw new FHIRException("Cannot make property reportedaCGHRatio as it is not a complex type");
                }
                case -1106363674: {
                    throw new FHIRException("Cannot make property length as it is not a complex type");
                }
                case 106111099: {
                    return this.getOuter();
                }
                case 100355670: {
                    return this.getInner();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("precisionOfBoundaries")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.precisionOfBoundaries");
            }
            if (name.equals("reportedaCGHRatio")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.reportedaCGHRatio");
            }
            if (name.equals("length")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.length");
            }
            if (name.equals("outer")) {
                this.outer = new SequenceStructureVariationOuterComponent();
                return this.outer;
            }
            if (name.equals("inner")) {
                this.inner = new SequenceStructureVariationInnerComponent();
                return this.inner;
            }
            return super.addChild(name);
        }

        @Override
        public SequenceStructureVariationComponent copy() {
            SequenceStructureVariationComponent dst = new SequenceStructureVariationComponent();
            this.copyValues(dst);
            dst.precisionOfBoundaries = this.precisionOfBoundaries == null ? null : this.precisionOfBoundaries.copy();
            dst.reportedaCGHRatio = this.reportedaCGHRatio == null ? null : this.reportedaCGHRatio.copy();
            dst.length = this.length == null ? null : this.length.copy();
            dst.outer = this.outer == null ? null : this.outer.copy();
            dst.inner = this.inner == null ? null : this.inner.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SequenceStructureVariationComponent)) {
                return false;
            }
            SequenceStructureVariationComponent o = (SequenceStructureVariationComponent)other;
            return SequenceStructureVariationComponent.compareDeep(this.precisionOfBoundaries, o.precisionOfBoundaries, true) && SequenceStructureVariationComponent.compareDeep(this.reportedaCGHRatio, o.reportedaCGHRatio, true) && SequenceStructureVariationComponent.compareDeep(this.length, o.length, true) && SequenceStructureVariationComponent.compareDeep(this.outer, o.outer, true) && SequenceStructureVariationComponent.compareDeep(this.inner, o.inner, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SequenceStructureVariationComponent)) {
                return false;
            }
            SequenceStructureVariationComponent o = (SequenceStructureVariationComponent)other;
            return SequenceStructureVariationComponent.compareValues(this.precisionOfBoundaries, o.precisionOfBoundaries, true) && SequenceStructureVariationComponent.compareValues(this.reportedaCGHRatio, o.reportedaCGHRatio, true) && SequenceStructureVariationComponent.compareValues(this.length, o.length, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.precisionOfBoundaries != null && !this.precisionOfBoundaries.isEmpty() || this.reportedaCGHRatio != null && !this.reportedaCGHRatio.isEmpty() || this.length != null && !this.length.isEmpty() || this.outer != null && !this.outer.isEmpty() || this.inner != null && !this.inner.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Sequence.structureVariation";
        }
    }

    @Block
    public static class SequenceRepositoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="url", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URI of the repository", formalDefinition="URI of an external repository which contains further details about the genetics data.")
        protected UriType url;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of the repository", formalDefinition="URI of an external repository which contains further details about the genetics data.")
        protected StringType name;
        @Child(name="variantId", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of the variant", formalDefinition="Id of the variation in this external repository.")
        protected StringType variantId;
        @Child(name="readId", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of the read", formalDefinition="Id of the read in this external repository.")
        protected StringType readId;
        private static final long serialVersionUID = 1218159360L;

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceRepositoryComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public SequenceRepositoryComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public SequenceRepositoryComponent setUrl(String value) {
            if (Utilities.noString(value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceRepositoryComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SequenceRepositoryComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SequenceRepositoryComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getVariantIdElement() {
            if (this.variantId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceRepositoryComponent.variantId");
                }
                if (Configuration.doAutoCreate()) {
                    this.variantId = new StringType();
                }
            }
            return this.variantId;
        }

        public boolean hasVariantIdElement() {
            return this.variantId != null && !this.variantId.isEmpty();
        }

        public boolean hasVariantId() {
            return this.variantId != null && !this.variantId.isEmpty();
        }

        public SequenceRepositoryComponent setVariantIdElement(StringType value) {
            this.variantId = value;
            return this;
        }

        public String getVariantId() {
            return this.variantId == null ? null : (String)this.variantId.getValue();
        }

        public SequenceRepositoryComponent setVariantId(String value) {
            if (Utilities.noString(value)) {
                this.variantId = null;
            } else {
                if (this.variantId == null) {
                    this.variantId = new StringType();
                }
                this.variantId.setValue(value);
            }
            return this;
        }

        public StringType getReadIdElement() {
            if (this.readId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceRepositoryComponent.readId");
                }
                if (Configuration.doAutoCreate()) {
                    this.readId = new StringType();
                }
            }
            return this.readId;
        }

        public boolean hasReadIdElement() {
            return this.readId != null && !this.readId.isEmpty();
        }

        public boolean hasReadId() {
            return this.readId != null && !this.readId.isEmpty();
        }

        public SequenceRepositoryComponent setReadIdElement(StringType value) {
            this.readId = value;
            return this;
        }

        public String getReadId() {
            return this.readId == null ? null : (String)this.readId.getValue();
        }

        public SequenceRepositoryComponent setReadId(String value) {
            if (Utilities.noString(value)) {
                this.readId = null;
            } else {
                if (this.readId == null) {
                    this.readId = new StringType();
                }
                this.readId.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("url", "uri", "URI of an external repository which contains further details about the genetics data.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("name", "string", "URI of an external repository which contains further details about the genetics data.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("variantId", "string", "Id of the variation in this external repository.", 0, Integer.MAX_VALUE, this.variantId));
            childrenList.add(new Property("readId", "string", "Id of the read in this external repository.", 0, Integer.MAX_VALUE, this.readId));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.url;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -82113408: {
                    Base[] baseArray;
                    if (this.variantId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.variantId;
                    }
                    return baseArray;
                }
                case -934980271: {
                    Base[] baseArray;
                    if (this.readId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.readId;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -82113408: {
                    this.variantId = this.castToString(value);
                    break;
                }
                case -934980271: {
                    this.readId = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("variantId")) {
                this.variantId = this.castToString(value);
            } else if (name.equals("readId")) {
                this.readId = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -82113408: {
                    throw new FHIRException("Cannot make property variantId as it is not a complex type");
                }
                case -934980271: {
                    throw new FHIRException("Cannot make property readId as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.url");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.name");
            }
            if (name.equals("variantId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.variantId");
            }
            if (name.equals("readId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.readId");
            }
            return super.addChild(name);
        }

        @Override
        public SequenceRepositoryComponent copy() {
            SequenceRepositoryComponent dst = new SequenceRepositoryComponent();
            this.copyValues(dst);
            dst.url = this.url == null ? null : this.url.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.variantId = this.variantId == null ? null : this.variantId.copy();
            dst.readId = this.readId == null ? null : this.readId.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SequenceRepositoryComponent)) {
                return false;
            }
            SequenceRepositoryComponent o = (SequenceRepositoryComponent)other;
            return SequenceRepositoryComponent.compareDeep(this.url, o.url, true) && SequenceRepositoryComponent.compareDeep(this.name, o.name, true) && SequenceRepositoryComponent.compareDeep(this.variantId, o.variantId, true) && SequenceRepositoryComponent.compareDeep(this.readId, o.readId, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SequenceRepositoryComponent)) {
                return false;
            }
            SequenceRepositoryComponent o = (SequenceRepositoryComponent)other;
            return SequenceRepositoryComponent.compareValues(this.url, o.url, true) && SequenceRepositoryComponent.compareValues(this.name, o.name, true) && SequenceRepositoryComponent.compareValues(this.variantId, o.variantId, true) && SequenceRepositoryComponent.compareValues(this.readId, o.readId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.name != null && !this.name.isEmpty() || this.variantId != null && !this.variantId.isEmpty() || this.readId != null && !this.readId.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Sequence.repository";
        }
    }

    @Block
    public static class SequenceQualityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="0-based start position (inclusive) of the sequence", formalDefinition="0-based start position (inclusive) of the sequence.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="0-based end position (exclusive) of the sequence", formalDefinition="0-based end position (exclusive) of the sequence.")
        protected IntegerType end;
        @Child(name="score", type={Quantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quality score", formalDefinition="Quality score.")
        protected Quantity score;
        @Child(name="method", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Method for quality", formalDefinition="Method for quality.")
        protected StringType method;
        private static final long serialVersionUID = -1046665930L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceQualityComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public SequenceQualityComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public SequenceQualityComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceQualityComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public SequenceQualityComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public SequenceQualityComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        public Quantity getScore() {
            if (this.score == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceQualityComponent.score");
                }
                if (Configuration.doAutoCreate()) {
                    this.score = new Quantity();
                }
            }
            return this.score;
        }

        public boolean hasScore() {
            return this.score != null && !this.score.isEmpty();
        }

        public SequenceQualityComponent setScore(Quantity value) {
            this.score = value;
            return this;
        }

        public StringType getMethodElement() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceQualityComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new StringType();
                }
            }
            return this.method;
        }

        public boolean hasMethodElement() {
            return this.method != null && !this.method.isEmpty();
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SequenceQualityComponent setMethodElement(StringType value) {
            this.method = value;
            return this;
        }

        public String getMethod() {
            return this.method == null ? null : (String)this.method.getValue();
        }

        public SequenceQualityComponent setMethod(String value) {
            if (Utilities.noString(value)) {
                this.method = null;
            } else {
                if (this.method == null) {
                    this.method = new StringType();
                }
                this.method.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Sequence.SP_START, "integer", "0-based start position (inclusive) of the sequence.", 0, Integer.MAX_VALUE, this.start));
            childrenList.add(new Property(Sequence.SP_END, "integer", "0-based end position (exclusive) of the sequence.", 0, Integer.MAX_VALUE, this.end));
            childrenList.add(new Property("score", "Quantity", "Quality score.", 0, Integer.MAX_VALUE, this.score));
            childrenList.add(new Property("method", "string", "Method for quality.", 0, Integer.MAX_VALUE, this.method));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
                case 109264530: {
                    Base[] baseArray;
                    if (this.score == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.score;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.method;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = this.castToInteger(value);
                    break;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    break;
                }
                case 109264530: {
                    this.score = this.castToQuantity(value);
                    break;
                }
                case -1077554975: {
                    this.method = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                this.start = this.castToInteger(value);
            } else if (name.equals(Sequence.SP_END)) {
                this.end = this.castToInteger(value);
            } else if (name.equals("score")) {
                this.score = this.castToQuantity(value);
            } else if (name.equals("method")) {
                this.method = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    throw new FHIRException("Cannot make property start as it is not a complex type");
                }
                case 100571: {
                    throw new FHIRException("Cannot make property end as it is not a complex type");
                }
                case 109264530: {
                    return this.getScore();
                }
                case -1077554975: {
                    throw new FHIRException("Cannot make property method as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.start");
            }
            if (name.equals(Sequence.SP_END)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.end");
            }
            if (name.equals("score")) {
                this.score = new Quantity();
                return this.score;
            }
            if (name.equals("method")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.method");
            }
            return super.addChild(name);
        }

        @Override
        public SequenceQualityComponent copy() {
            SequenceQualityComponent dst = new SequenceQualityComponent();
            this.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
            dst.score = this.score == null ? null : this.score.copy();
            dst.method = this.method == null ? null : this.method.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SequenceQualityComponent)) {
                return false;
            }
            SequenceQualityComponent o = (SequenceQualityComponent)other;
            return SequenceQualityComponent.compareDeep(this.start, o.start, true) && SequenceQualityComponent.compareDeep(this.end, o.end, true) && SequenceQualityComponent.compareDeep(this.score, o.score, true) && SequenceQualityComponent.compareDeep(this.method, o.method, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SequenceQualityComponent)) {
                return false;
            }
            SequenceQualityComponent o = (SequenceQualityComponent)other;
            return SequenceQualityComponent.compareValues(this.start, o.start, true) && SequenceQualityComponent.compareValues(this.end, o.end, true) && SequenceQualityComponent.compareValues(this.method, o.method, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.start != null && !this.start.isEmpty() || this.end != null && !this.end.isEmpty() || this.score != null && !this.score.isEmpty() || this.method != null && !this.method.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Sequence.quality";
        }
    }

    @Block
    public static class SequenceVariationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="start", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="0-based start position (inclusive) of the variation on the  reference sequence", formalDefinition="0-based start position (inclusive) of the variation on the  reference sequence.")
        protected IntegerType start;
        @Child(name="end", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="0-based end position (exclusive) of the variation on the reference sequence", formalDefinition="0-based end position (exclusive) of the variation on the reference sequence.")
        protected IntegerType end;
        @Child(name="observedAllele", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Nucleotide(s)/amino acids from start position to stop position of observed variation", formalDefinition="Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand.")
        protected StringType observedAllele;
        @Child(name="referenceAllele", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Nucleotide(s)/amino acids from start position to stop position of reference variation", formalDefinition="Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the reference sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand.")
        protected StringType referenceAllele;
        @Child(name="cigar", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Extended CIGAR string for aligning the sequence with reference bases", formalDefinition="Extended CIGAR string for aligning the sequence with reference bases. See detailed documentation [here](http://support.illumina.com/help/SequencingAnalysisWorkflow/Content/Vault/Informatics/Sequencing_Analysis/CASAVA/swSEQ_mCA_ExtendedCIGARFormat.htm).")
        protected StringType cigar;
        private static final long serialVersionUID = 913298829L;

        public IntegerType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceVariationComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new IntegerType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public SequenceVariationComponent setStartElement(IntegerType value) {
            this.start = value;
            return this;
        }

        public int getStart() {
            return this.start == null || this.start.isEmpty() ? 0 : (Integer)this.start.getValue();
        }

        public SequenceVariationComponent setStart(int value) {
            if (this.start == null) {
                this.start = new IntegerType();
            }
            this.start.setValue((Object)value);
            return this;
        }

        public IntegerType getEndElement() {
            if (this.end == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceVariationComponent.end");
                }
                if (Configuration.doAutoCreate()) {
                    this.end = new IntegerType();
                }
            }
            return this.end;
        }

        public boolean hasEndElement() {
            return this.end != null && !this.end.isEmpty();
        }

        public boolean hasEnd() {
            return this.end != null && !this.end.isEmpty();
        }

        public SequenceVariationComponent setEndElement(IntegerType value) {
            this.end = value;
            return this;
        }

        public int getEnd() {
            return this.end == null || this.end.isEmpty() ? 0 : (Integer)this.end.getValue();
        }

        public SequenceVariationComponent setEnd(int value) {
            if (this.end == null) {
                this.end = new IntegerType();
            }
            this.end.setValue((Object)value);
            return this;
        }

        public StringType getObservedAlleleElement() {
            if (this.observedAllele == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceVariationComponent.observedAllele");
                }
                if (Configuration.doAutoCreate()) {
                    this.observedAllele = new StringType();
                }
            }
            return this.observedAllele;
        }

        public boolean hasObservedAlleleElement() {
            return this.observedAllele != null && !this.observedAllele.isEmpty();
        }

        public boolean hasObservedAllele() {
            return this.observedAllele != null && !this.observedAllele.isEmpty();
        }

        public SequenceVariationComponent setObservedAlleleElement(StringType value) {
            this.observedAllele = value;
            return this;
        }

        public String getObservedAllele() {
            return this.observedAllele == null ? null : (String)this.observedAllele.getValue();
        }

        public SequenceVariationComponent setObservedAllele(String value) {
            if (Utilities.noString(value)) {
                this.observedAllele = null;
            } else {
                if (this.observedAllele == null) {
                    this.observedAllele = new StringType();
                }
                this.observedAllele.setValue(value);
            }
            return this;
        }

        public StringType getReferenceAlleleElement() {
            if (this.referenceAllele == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceVariationComponent.referenceAllele");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceAllele = new StringType();
                }
            }
            return this.referenceAllele;
        }

        public boolean hasReferenceAlleleElement() {
            return this.referenceAllele != null && !this.referenceAllele.isEmpty();
        }

        public boolean hasReferenceAllele() {
            return this.referenceAllele != null && !this.referenceAllele.isEmpty();
        }

        public SequenceVariationComponent setReferenceAlleleElement(StringType value) {
            this.referenceAllele = value;
            return this;
        }

        public String getReferenceAllele() {
            return this.referenceAllele == null ? null : (String)this.referenceAllele.getValue();
        }

        public SequenceVariationComponent setReferenceAllele(String value) {
            if (Utilities.noString(value)) {
                this.referenceAllele = null;
            } else {
                if (this.referenceAllele == null) {
                    this.referenceAllele = new StringType();
                }
                this.referenceAllele.setValue(value);
            }
            return this;
        }

        public StringType getCigarElement() {
            if (this.cigar == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceVariationComponent.cigar");
                }
                if (Configuration.doAutoCreate()) {
                    this.cigar = new StringType();
                }
            }
            return this.cigar;
        }

        public boolean hasCigarElement() {
            return this.cigar != null && !this.cigar.isEmpty();
        }

        public boolean hasCigar() {
            return this.cigar != null && !this.cigar.isEmpty();
        }

        public SequenceVariationComponent setCigarElement(StringType value) {
            this.cigar = value;
            return this;
        }

        public String getCigar() {
            return this.cigar == null ? null : (String)this.cigar.getValue();
        }

        public SequenceVariationComponent setCigar(String value) {
            if (Utilities.noString(value)) {
                this.cigar = null;
            } else {
                if (this.cigar == null) {
                    this.cigar = new StringType();
                }
                this.cigar.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Sequence.SP_START, "integer", "0-based start position (inclusive) of the variation on the  reference sequence.", 0, Integer.MAX_VALUE, this.start));
            childrenList.add(new Property(Sequence.SP_END, "integer", "0-based end position (exclusive) of the variation on the reference sequence.", 0, Integer.MAX_VALUE, this.end));
            childrenList.add(new Property("observedAllele", "string", "Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the observed sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand.", 0, Integer.MAX_VALUE, this.observedAllele));
            childrenList.add(new Property("referenceAllele", "string", "Nucleotide(s)/amino acids from start position of sequence to stop position of sequence on the positive (+) strand of the reference sequence. When the sequence  type is DNA, it should be the sequence on the positive (+) strand.", 0, Integer.MAX_VALUE, this.referenceAllele));
            childrenList.add(new Property("cigar", "string", "Extended CIGAR string for aligning the sequence with reference bases. See detailed documentation [here](http://support.illumina.com/help/SequencingAnalysisWorkflow/Content/Vault/Informatics/Sequencing_Analysis/CASAVA/swSEQ_mCA_ExtendedCIGARFormat.htm).", 0, Integer.MAX_VALUE, this.cigar));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.start;
                    }
                    return baseArray;
                }
                case 100571: {
                    Base[] baseArray;
                    if (this.end == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.end;
                    }
                    return baseArray;
                }
                case -1418745787: {
                    Base[] baseArray;
                    if (this.observedAllele == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.observedAllele;
                    }
                    return baseArray;
                }
                case 364045960: {
                    Base[] baseArray;
                    if (this.referenceAllele == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.referenceAllele;
                    }
                    return baseArray;
                }
                case 94658738: {
                    Base[] baseArray;
                    if (this.cigar == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.cigar;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    this.start = this.castToInteger(value);
                    break;
                }
                case 100571: {
                    this.end = this.castToInteger(value);
                    break;
                }
                case -1418745787: {
                    this.observedAllele = this.castToString(value);
                    break;
                }
                case 364045960: {
                    this.referenceAllele = this.castToString(value);
                    break;
                }
                case 94658738: {
                    this.cigar = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                this.start = this.castToInteger(value);
            } else if (name.equals(Sequence.SP_END)) {
                this.end = this.castToInteger(value);
            } else if (name.equals("observedAllele")) {
                this.observedAllele = this.castToString(value);
            } else if (name.equals("referenceAllele")) {
                this.referenceAllele = this.castToString(value);
            } else if (name.equals("cigar")) {
                this.cigar = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 109757538: {
                    throw new FHIRException("Cannot make property start as it is not a complex type");
                }
                case 100571: {
                    throw new FHIRException("Cannot make property end as it is not a complex type");
                }
                case -1418745787: {
                    throw new FHIRException("Cannot make property observedAllele as it is not a complex type");
                }
                case 364045960: {
                    throw new FHIRException("Cannot make property referenceAllele as it is not a complex type");
                }
                case 94658738: {
                    throw new FHIRException("Cannot make property cigar as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Sequence.SP_START)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.start");
            }
            if (name.equals(Sequence.SP_END)) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.end");
            }
            if (name.equals("observedAllele")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.observedAllele");
            }
            if (name.equals("referenceAllele")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.referenceAllele");
            }
            if (name.equals("cigar")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.cigar");
            }
            return super.addChild(name);
        }

        @Override
        public SequenceVariationComponent copy() {
            SequenceVariationComponent dst = new SequenceVariationComponent();
            this.copyValues(dst);
            dst.start = this.start == null ? null : this.start.copy();
            dst.end = this.end == null ? null : this.end.copy();
            dst.observedAllele = this.observedAllele == null ? null : this.observedAllele.copy();
            dst.referenceAllele = this.referenceAllele == null ? null : this.referenceAllele.copy();
            dst.cigar = this.cigar == null ? null : this.cigar.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SequenceVariationComponent)) {
                return false;
            }
            SequenceVariationComponent o = (SequenceVariationComponent)other;
            return SequenceVariationComponent.compareDeep(this.start, o.start, true) && SequenceVariationComponent.compareDeep(this.end, o.end, true) && SequenceVariationComponent.compareDeep(this.observedAllele, o.observedAllele, true) && SequenceVariationComponent.compareDeep(this.referenceAllele, o.referenceAllele, true) && SequenceVariationComponent.compareDeep(this.cigar, o.cigar, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SequenceVariationComponent)) {
                return false;
            }
            SequenceVariationComponent o = (SequenceVariationComponent)other;
            return SequenceVariationComponent.compareValues(this.start, o.start, true) && SequenceVariationComponent.compareValues(this.end, o.end, true) && SequenceVariationComponent.compareValues(this.observedAllele, o.observedAllele, true) && SequenceVariationComponent.compareValues(this.referenceAllele, o.referenceAllele, true) && SequenceVariationComponent.compareValues(this.cigar, o.cigar, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.start != null && !this.start.isEmpty() || this.end != null && !this.end.isEmpty() || this.observedAllele != null && !this.observedAllele.isEmpty() || this.referenceAllele != null && !this.referenceAllele.isEmpty() || this.cigar != null && !this.cigar.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Sequence.variation";
        }
    }

    @Block
    public static class SequenceReferenceSeqComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="chromosome", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The chromosome containing the genetic finding", formalDefinition="The chromosome containing the genetic finding. The value set will be 1-22, X, Y when the species is human without chromosome abnormality. Otherwise,  NCBI-Gene code system should be used.")
        protected CodeableConcept chromosome;
        @Child(name="genomeBuild", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'", formalDefinition="The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'.  Version number must be included if a versioned release of a primary build was used.")
        protected StringType genomeBuild;
        @Child(name="referenceSeqId", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference identifier", formalDefinition="Reference identifier of reference sequence submitted to NCBI. It must match the type in the Sequence.type field. For example, the prefix, \u201cNG_\u201d identifies reference sequence for genes, \u201cNM_\u201d for messenger RNA transcripts, and \u201cNP_\u201d for amino acid sequences.")
        protected CodeableConcept referenceSeqId;
        @Child(name="referenceSeqPointer", type={Sequence.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A Pointer to another Sequence entity as refence sequence", formalDefinition="A Pointer to another Sequence entity as refence sequence.")
        protected Reference referenceSeqPointer;
        protected Sequence referenceSeqPointerTarget;
        @Child(name="referenceSeqString", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A Reference Sequence string", formalDefinition="A Reference Sequence string.")
        protected StringType referenceSeqString;
        @Child(name="windowStart", type={IntegerType.class}, order=6, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="0-based start position (inclusive) of the window on the  reference sequence", formalDefinition="0-based start position (inclusive) of the window on the reference sequence.")
        protected IntegerType windowStart;
        @Child(name="windowEnd", type={IntegerType.class}, order=7, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="0-based end position (exclusive) of the window on the reference sequence", formalDefinition="0-based end position (exclusive) of the window on the reference sequence.")
        protected IntegerType windowEnd;
        private static final long serialVersionUID = -165922935L;

        public SequenceReferenceSeqComponent() {
        }

        public SequenceReferenceSeqComponent(CodeableConcept referenceSeqId, IntegerType windowStart, IntegerType windowEnd) {
            this.referenceSeqId = referenceSeqId;
            this.windowStart = windowStart;
            this.windowEnd = windowEnd;
        }

        public CodeableConcept getChromosome() {
            if (this.chromosome == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.chromosome");
                }
                if (Configuration.doAutoCreate()) {
                    this.chromosome = new CodeableConcept();
                }
            }
            return this.chromosome;
        }

        public boolean hasChromosome() {
            return this.chromosome != null && !this.chromosome.isEmpty();
        }

        public SequenceReferenceSeqComponent setChromosome(CodeableConcept value) {
            this.chromosome = value;
            return this;
        }

        public StringType getGenomeBuildElement() {
            if (this.genomeBuild == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.genomeBuild");
                }
                if (Configuration.doAutoCreate()) {
                    this.genomeBuild = new StringType();
                }
            }
            return this.genomeBuild;
        }

        public boolean hasGenomeBuildElement() {
            return this.genomeBuild != null && !this.genomeBuild.isEmpty();
        }

        public boolean hasGenomeBuild() {
            return this.genomeBuild != null && !this.genomeBuild.isEmpty();
        }

        public SequenceReferenceSeqComponent setGenomeBuildElement(StringType value) {
            this.genomeBuild = value;
            return this;
        }

        public String getGenomeBuild() {
            return this.genomeBuild == null ? null : (String)this.genomeBuild.getValue();
        }

        public SequenceReferenceSeqComponent setGenomeBuild(String value) {
            if (Utilities.noString(value)) {
                this.genomeBuild = null;
            } else {
                if (this.genomeBuild == null) {
                    this.genomeBuild = new StringType();
                }
                this.genomeBuild.setValue(value);
            }
            return this;
        }

        public CodeableConcept getReferenceSeqId() {
            if (this.referenceSeqId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.referenceSeqId");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceSeqId = new CodeableConcept();
                }
            }
            return this.referenceSeqId;
        }

        public boolean hasReferenceSeqId() {
            return this.referenceSeqId != null && !this.referenceSeqId.isEmpty();
        }

        public SequenceReferenceSeqComponent setReferenceSeqId(CodeableConcept value) {
            this.referenceSeqId = value;
            return this;
        }

        public Reference getReferenceSeqPointer() {
            if (this.referenceSeqPointer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.referenceSeqPointer");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceSeqPointer = new Reference();
                }
            }
            return this.referenceSeqPointer;
        }

        public boolean hasReferenceSeqPointer() {
            return this.referenceSeqPointer != null && !this.referenceSeqPointer.isEmpty();
        }

        public SequenceReferenceSeqComponent setReferenceSeqPointer(Reference value) {
            this.referenceSeqPointer = value;
            return this;
        }

        public Sequence getReferenceSeqPointerTarget() {
            if (this.referenceSeqPointerTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.referenceSeqPointer");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceSeqPointerTarget = new Sequence();
                }
            }
            return this.referenceSeqPointerTarget;
        }

        public SequenceReferenceSeqComponent setReferenceSeqPointerTarget(Sequence value) {
            this.referenceSeqPointerTarget = value;
            return this;
        }

        public StringType getReferenceSeqStringElement() {
            if (this.referenceSeqString == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.referenceSeqString");
                }
                if (Configuration.doAutoCreate()) {
                    this.referenceSeqString = new StringType();
                }
            }
            return this.referenceSeqString;
        }

        public boolean hasReferenceSeqStringElement() {
            return this.referenceSeqString != null && !this.referenceSeqString.isEmpty();
        }

        public boolean hasReferenceSeqString() {
            return this.referenceSeqString != null && !this.referenceSeqString.isEmpty();
        }

        public SequenceReferenceSeqComponent setReferenceSeqStringElement(StringType value) {
            this.referenceSeqString = value;
            return this;
        }

        public String getReferenceSeqString() {
            return this.referenceSeqString == null ? null : (String)this.referenceSeqString.getValue();
        }

        public SequenceReferenceSeqComponent setReferenceSeqString(String value) {
            if (Utilities.noString(value)) {
                this.referenceSeqString = null;
            } else {
                if (this.referenceSeqString == null) {
                    this.referenceSeqString = new StringType();
                }
                this.referenceSeqString.setValue(value);
            }
            return this;
        }

        public IntegerType getWindowStartElement() {
            if (this.windowStart == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.windowStart");
                }
                if (Configuration.doAutoCreate()) {
                    this.windowStart = new IntegerType();
                }
            }
            return this.windowStart;
        }

        public boolean hasWindowStartElement() {
            return this.windowStart != null && !this.windowStart.isEmpty();
        }

        public boolean hasWindowStart() {
            return this.windowStart != null && !this.windowStart.isEmpty();
        }

        public SequenceReferenceSeqComponent setWindowStartElement(IntegerType value) {
            this.windowStart = value;
            return this;
        }

        public int getWindowStart() {
            return this.windowStart == null || this.windowStart.isEmpty() ? 0 : (Integer)this.windowStart.getValue();
        }

        public SequenceReferenceSeqComponent setWindowStart(int value) {
            if (this.windowStart == null) {
                this.windowStart = new IntegerType();
            }
            this.windowStart.setValue((Object)value);
            return this;
        }

        public IntegerType getWindowEndElement() {
            if (this.windowEnd == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SequenceReferenceSeqComponent.windowEnd");
                }
                if (Configuration.doAutoCreate()) {
                    this.windowEnd = new IntegerType();
                }
            }
            return this.windowEnd;
        }

        public boolean hasWindowEndElement() {
            return this.windowEnd != null && !this.windowEnd.isEmpty();
        }

        public boolean hasWindowEnd() {
            return this.windowEnd != null && !this.windowEnd.isEmpty();
        }

        public SequenceReferenceSeqComponent setWindowEndElement(IntegerType value) {
            this.windowEnd = value;
            return this;
        }

        public int getWindowEnd() {
            return this.windowEnd == null || this.windowEnd.isEmpty() ? 0 : (Integer)this.windowEnd.getValue();
        }

        public SequenceReferenceSeqComponent setWindowEnd(int value) {
            if (this.windowEnd == null) {
                this.windowEnd = new IntegerType();
            }
            this.windowEnd.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Sequence.SP_CHROMOSOME, "CodeableConcept", "The chromosome containing the genetic finding. The value set will be 1-22, X, Y when the species is human without chromosome abnormality. Otherwise,  NCBI-Gene code system should be used.", 0, Integer.MAX_VALUE, this.chromosome));
            childrenList.add(new Property("genomeBuild", "string", "The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'.  Version number must be included if a versioned release of a primary build was used.", 0, Integer.MAX_VALUE, this.genomeBuild));
            childrenList.add(new Property("referenceSeqId", "CodeableConcept", "Reference identifier of reference sequence submitted to NCBI. It must match the type in the Sequence.type field. For example, the prefix, \u201cNG_\u201d identifies reference sequence for genes, \u201cNM_\u201d for messenger RNA transcripts, and \u201cNP_\u201d for amino acid sequences.", 0, Integer.MAX_VALUE, this.referenceSeqId));
            childrenList.add(new Property("referenceSeqPointer", "Reference(Sequence)", "A Pointer to another Sequence entity as refence sequence.", 0, Integer.MAX_VALUE, this.referenceSeqPointer));
            childrenList.add(new Property("referenceSeqString", "string", "A Reference Sequence string.", 0, Integer.MAX_VALUE, this.referenceSeqString));
            childrenList.add(new Property("windowStart", "integer", "0-based start position (inclusive) of the window on the reference sequence.", 0, Integer.MAX_VALUE, this.windowStart));
            childrenList.add(new Property("windowEnd", "integer", "0-based end position (exclusive) of the window on the reference sequence.", 0, Integer.MAX_VALUE, this.windowEnd));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1499470472: {
                    Base[] baseArray;
                    if (this.chromosome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.chromosome;
                    }
                    return baseArray;
                }
                case 1061239735: {
                    Base[] baseArray;
                    if (this.genomeBuild == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.genomeBuild;
                    }
                    return baseArray;
                }
                case -1911500465: {
                    Base[] baseArray;
                    if (this.referenceSeqId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.referenceSeqId;
                    }
                    return baseArray;
                }
                case 1923414665: {
                    Base[] baseArray;
                    if (this.referenceSeqPointer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.referenceSeqPointer;
                    }
                    return baseArray;
                }
                case -1648301499: {
                    Base[] baseArray;
                    if (this.referenceSeqString == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.referenceSeqString;
                    }
                    return baseArray;
                }
                case 1903685202: {
                    Base[] baseArray;
                    if (this.windowStart == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.windowStart;
                    }
                    return baseArray;
                }
                case -217026869: {
                    Base[] baseArray;
                    if (this.windowEnd == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.windowEnd;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1499470472: {
                    this.chromosome = this.castToCodeableConcept(value);
                    break;
                }
                case 1061239735: {
                    this.genomeBuild = this.castToString(value);
                    break;
                }
                case -1911500465: {
                    this.referenceSeqId = this.castToCodeableConcept(value);
                    break;
                }
                case 1923414665: {
                    this.referenceSeqPointer = this.castToReference(value);
                    break;
                }
                case -1648301499: {
                    this.referenceSeqString = this.castToString(value);
                    break;
                }
                case 1903685202: {
                    this.windowStart = this.castToInteger(value);
                    break;
                }
                case -217026869: {
                    this.windowEnd = this.castToInteger(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Sequence.SP_CHROMOSOME)) {
                this.chromosome = this.castToCodeableConcept(value);
            } else if (name.equals("genomeBuild")) {
                this.genomeBuild = this.castToString(value);
            } else if (name.equals("referenceSeqId")) {
                this.referenceSeqId = this.castToCodeableConcept(value);
            } else if (name.equals("referenceSeqPointer")) {
                this.referenceSeqPointer = this.castToReference(value);
            } else if (name.equals("referenceSeqString")) {
                this.referenceSeqString = this.castToString(value);
            } else if (name.equals("windowStart")) {
                this.windowStart = this.castToInteger(value);
            } else if (name.equals("windowEnd")) {
                this.windowEnd = this.castToInteger(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1499470472: {
                    return this.getChromosome();
                }
                case 1061239735: {
                    throw new FHIRException("Cannot make property genomeBuild as it is not a complex type");
                }
                case -1911500465: {
                    return this.getReferenceSeqId();
                }
                case 1923414665: {
                    return this.getReferenceSeqPointer();
                }
                case -1648301499: {
                    throw new FHIRException("Cannot make property referenceSeqString as it is not a complex type");
                }
                case 1903685202: {
                    throw new FHIRException("Cannot make property windowStart as it is not a complex type");
                }
                case -217026869: {
                    throw new FHIRException("Cannot make property windowEnd as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Sequence.SP_CHROMOSOME)) {
                this.chromosome = new CodeableConcept();
                return this.chromosome;
            }
            if (name.equals("genomeBuild")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.genomeBuild");
            }
            if (name.equals("referenceSeqId")) {
                this.referenceSeqId = new CodeableConcept();
                return this.referenceSeqId;
            }
            if (name.equals("referenceSeqPointer")) {
                this.referenceSeqPointer = new Reference();
                return this.referenceSeqPointer;
            }
            if (name.equals("referenceSeqString")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.referenceSeqString");
            }
            if (name.equals("windowStart")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.windowStart");
            }
            if (name.equals("windowEnd")) {
                throw new FHIRException("Cannot call addChild on a primitive type Sequence.windowEnd");
            }
            return super.addChild(name);
        }

        @Override
        public SequenceReferenceSeqComponent copy() {
            SequenceReferenceSeqComponent dst = new SequenceReferenceSeqComponent();
            this.copyValues(dst);
            dst.chromosome = this.chromosome == null ? null : this.chromosome.copy();
            dst.genomeBuild = this.genomeBuild == null ? null : this.genomeBuild.copy();
            dst.referenceSeqId = this.referenceSeqId == null ? null : this.referenceSeqId.copy();
            dst.referenceSeqPointer = this.referenceSeqPointer == null ? null : this.referenceSeqPointer.copy();
            dst.referenceSeqString = this.referenceSeqString == null ? null : this.referenceSeqString.copy();
            dst.windowStart = this.windowStart == null ? null : this.windowStart.copy();
            dst.windowEnd = this.windowEnd == null ? null : this.windowEnd.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SequenceReferenceSeqComponent)) {
                return false;
            }
            SequenceReferenceSeqComponent o = (SequenceReferenceSeqComponent)other;
            return SequenceReferenceSeqComponent.compareDeep(this.chromosome, o.chromosome, true) && SequenceReferenceSeqComponent.compareDeep(this.genomeBuild, o.genomeBuild, true) && SequenceReferenceSeqComponent.compareDeep(this.referenceSeqId, o.referenceSeqId, true) && SequenceReferenceSeqComponent.compareDeep(this.referenceSeqPointer, o.referenceSeqPointer, true) && SequenceReferenceSeqComponent.compareDeep(this.referenceSeqString, o.referenceSeqString, true) && SequenceReferenceSeqComponent.compareDeep(this.windowStart, o.windowStart, true) && SequenceReferenceSeqComponent.compareDeep(this.windowEnd, o.windowEnd, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SequenceReferenceSeqComponent)) {
                return false;
            }
            SequenceReferenceSeqComponent o = (SequenceReferenceSeqComponent)other;
            return SequenceReferenceSeqComponent.compareValues(this.genomeBuild, o.genomeBuild, true) && SequenceReferenceSeqComponent.compareValues(this.referenceSeqString, o.referenceSeqString, true) && SequenceReferenceSeqComponent.compareValues(this.windowStart, o.windowStart, true) && SequenceReferenceSeqComponent.compareValues(this.windowEnd, o.windowEnd, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.chromosome != null && !this.chromosome.isEmpty() || this.genomeBuild != null && !this.genomeBuild.isEmpty() || this.referenceSeqId != null && !this.referenceSeqId.isEmpty() || this.referenceSeqPointer != null && !this.referenceSeqPointer.isEmpty() || this.referenceSeqString != null && !this.referenceSeqString.isEmpty() || this.windowStart != null && !this.windowStart.isEmpty() || this.windowEnd != null && !this.windowEnd.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Sequence.referenceSeq";
        }
    }

    public static class SequenceTypeEnumFactory
    implements EnumFactory<SequenceType> {
        @Override
        public SequenceType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("AA".equals(codeString)) {
                return SequenceType.AA;
            }
            if ("DNA".equals(codeString)) {
                return SequenceType.DNA;
            }
            if ("RNA".equals(codeString)) {
                return SequenceType.RNA;
            }
            throw new IllegalArgumentException("Unknown SequenceType code '" + codeString + "'");
        }

        public Enumeration<SequenceType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("AA".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.AA);
            }
            if ("DNA".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.DNA);
            }
            if ("RNA".equals(codeString)) {
                return new Enumeration<SequenceType>(this, SequenceType.RNA);
            }
            throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
        }

        @Override
        public String toCode(SequenceType code) {
            if (code == SequenceType.AA) {
                return "AA";
            }
            if (code == SequenceType.DNA) {
                return "DNA";
            }
            if (code == SequenceType.RNA) {
                return "RNA";
            }
            return "?";
        }

        @Override
        public String toSystem(SequenceType code) {
            return code.getSystem();
        }
    }

    public static enum SequenceType {
        AA,
        DNA,
        RNA,
        NULL;


        public static SequenceType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("AA".equals(codeString)) {
                return AA;
            }
            if ("DNA".equals(codeString)) {
                return DNA;
            }
            if ("RNA".equals(codeString)) {
                return RNA;
            }
            throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AA: {
                    return "AA";
                }
                case DNA: {
                    return "DNA";
                }
                case RNA: {
                    return "RNA";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
                case DNA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
                case RNA: {
                    return "http://hl7.org/fhir/sequence-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AA: {
                    return "Amino acid sequence";
                }
                case DNA: {
                    return "DNA Sequence";
                }
                case RNA: {
                    return "RNA Sequence";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AA: {
                    return "AA Sequence";
                }
                case DNA: {
                    return "DNA Sequence";
                }
                case RNA: {
                    return "RNA Sequence";
                }
            }
            return "?";
        }
    }
}

