/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Signature;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Provenance", profile="http://hl7.org/fhir/Profile/Provenance")
public class Provenance
extends DomainResource {
    @Child(name="target", type={}, order=0, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Target Reference(s) (usually version specific)", formalDefinition="The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.")
    protected List<Reference> target;
    protected List<Resource> targetTarget;
    @Child(name="period", type={Period.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the activity occurred", formalDefinition="The period during which the activity occurred.")
    protected Period period;
    @Child(name="recorded", type={InstantType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the activity was recorded / updated", formalDefinition="The instant of time at which the activity was recorded.")
    protected InstantType recorded;
    @Child(name="reason", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason the activity is occurring", formalDefinition="The reason that the activity was taking place.")
    protected List<Coding> reason;
    @Child(name="activity", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Activity that occurred", formalDefinition="An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.")
    protected Coding activity;
    @Child(name="location", type={Location.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the activity occurred, if relevant", formalDefinition="Where the activity occurred, if relevant.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="policy", type={UriType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Policy or plan the activity was defined by", formalDefinition="Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.")
    protected List<UriType> policy;
    @Child(name="agent", type={}, order=7, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Actor involved", formalDefinition="An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.")
    protected List<ProvenanceAgentComponent> agent;
    @Child(name="entity", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An entity used in this activity", formalDefinition="An entity used in this activity.")
    protected List<ProvenanceEntityComponent> entity;
    @Child(name="signature", type={Signature.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Signature on target", formalDefinition="A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.")
    protected List<Signature> signature;
    private static final long serialVersionUID = -436783145L;
    @SearchParamDefinition(name="patient", path="Provenance.target", description="Target Reference(s) (usually version specific)", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Provenance:patient").toLocked();
    @SearchParamDefinition(name="location", path="Provenance.location", description="Where the activity occurred, if relevant", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Provenance:location").toLocked();
    @SearchParamDefinition(name="start", path="Provenance.period.start", description="Starting time with inclusive boundary", type="date")
    public static final String SP_START = "start";
    public static final DateClientParam START = new DateClientParam("start");
    @SearchParamDefinition(name="entity", path="Provenance.entity.reference", description="Identity of entity", type="uri")
    public static final String SP_ENTITY = "entity";
    public static final UriClientParam ENTITY = new UriClientParam("entity");
    @SearchParamDefinition(name="userid", path="Provenance.agent.userId", description="Authorization-system identifier for the agent", type="token")
    public static final String SP_USERID = "userid";
    public static final TokenClientParam USERID = new TokenClientParam("userid");
    @SearchParamDefinition(name="target", path="Provenance.target", description="Target Reference(s) (usually version specific)", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("Provenance:target").toLocked();
    @SearchParamDefinition(name="entity-type", path="Provenance.entity.type", description="The type of resource in this entity", type="token")
    public static final String SP_ENTITY_TYPE = "entity-type";
    public static final TokenClientParam ENTITY_TYPE = new TokenClientParam("entity-type");
    @SearchParamDefinition(name="agent", path="Provenance.agent.actor", description="Individual, device or organization playing role", type="reference")
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    public static final Include INCLUDE_AGENT = new Include("Provenance:agent").toLocked();
    @SearchParamDefinition(name="end", path="Provenance.period.end", description="End time with inclusive boundary, if not ongoing", type="date")
    public static final String SP_END = "end";
    public static final DateClientParam END = new DateClientParam("end");
    @SearchParamDefinition(name="sig", path="Provenance.signature.type", description="Indication of the reason the entity signed the object(s)", type="token")
    public static final String SP_SIG = "sig";
    public static final TokenClientParam SIG = new TokenClientParam("sig");

    public Provenance() {
    }

    public Provenance(InstantType recorded) {
        this.recorded = recorded;
    }

    public List<Reference> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        return this.target;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (Reference item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTarget() {
        Reference t = new Reference();
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return t;
    }

    public Provenance addTarget(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        this.target.add(t);
        return this;
    }

    public List<Resource> getTargetTarget() {
        if (this.targetTarget == null) {
            this.targetTarget = new ArrayList<Resource>();
        }
        return this.targetTarget;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Provenance setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public InstantType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new InstantType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public Provenance setRecordedElement(InstantType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public Provenance setRecorded(Date value) {
        if (this.recorded == null) {
            this.recorded = new InstantType();
        }
        this.recorded.setValue(value);
        return this;
    }

    public List<Coding> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<Coding>();
        }
        return this.reason;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (Coding item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addReason() {
        Coding t = new Coding();
        if (this.reason == null) {
            this.reason = new ArrayList<Coding>();
        }
        this.reason.add(t);
        return t;
    }

    public Provenance addReason(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<Coding>();
        }
        this.reason.add(t);
        return this;
    }

    public Coding getActivity() {
        if (this.activity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.activity");
            }
            if (Configuration.doAutoCreate()) {
                this.activity = new Coding();
            }
        }
        return this.activity;
    }

    public boolean hasActivity() {
        return this.activity != null && !this.activity.isEmpty();
    }

    public Provenance setActivity(Coding value) {
        this.activity = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Provenance setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Provenance.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Provenance setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public List<UriType> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        return this.policy;
    }

    public boolean hasPolicy() {
        if (this.policy == null) {
            return false;
        }
        for (UriType item : this.policy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addPolicyElement() {
        UriType t = new UriType();
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        this.policy.add(t);
        return t;
    }

    public Provenance addPolicy(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.policy == null) {
            this.policy = new ArrayList<UriType>();
        }
        this.policy.add(t);
        return this;
    }

    public boolean hasPolicy(String value) {
        if (this.policy == null) {
            return false;
        }
        for (UriType v : this.policy) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<ProvenanceAgentComponent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        return this.agent;
    }

    public boolean hasAgent() {
        if (this.agent == null) {
            return false;
        }
        for (ProvenanceAgentComponent item : this.agent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProvenanceAgentComponent addAgent() {
        ProvenanceAgentComponent t = new ProvenanceAgentComponent();
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        this.agent.add(t);
        return t;
    }

    public Provenance addAgent(ProvenanceAgentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgentComponent>();
        }
        this.agent.add(t);
        return this;
    }

    public List<ProvenanceEntityComponent> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        return this.entity;
    }

    public boolean hasEntity() {
        if (this.entity == null) {
            return false;
        }
        for (ProvenanceEntityComponent item : this.entity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProvenanceEntityComponent addEntity() {
        ProvenanceEntityComponent t = new ProvenanceEntityComponent();
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        this.entity.add(t);
        return t;
    }

    public Provenance addEntity(ProvenanceEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntityComponent>();
        }
        this.entity.add(t);
        return this;
    }

    public List<Signature> getSignature() {
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        return this.signature;
    }

    public boolean hasSignature() {
        if (this.signature == null) {
            return false;
        }
        for (Signature item : this.signature) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Signature addSignature() {
        Signature t = new Signature();
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        this.signature.add(t);
        return t;
    }

    public Provenance addSignature(Signature t) {
        if (t == null) {
            return this;
        }
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        this.signature.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_TARGET, "Reference(Any)", "The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property("period", "Period", "The period during which the activity occurred.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("recorded", "instant", "The instant of time at which the activity was recorded.", 0, Integer.MAX_VALUE, this.recorded));
        childrenList.add(new Property("reason", "Coding", "The reason that the activity was taking place.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("activity", "Coding", "An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities.", 0, Integer.MAX_VALUE, this.activity));
        childrenList.add(new Property(SP_LOCATION, "Reference(Location)", "Where the activity occurred, if relevant.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property("policy", "uri", "Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.", 0, Integer.MAX_VALUE, this.policy));
        childrenList.add(new Property(SP_AGENT, "", "An actor taking a role in an activity  for which it can be assigned some degree of responsibility for the activity taking place.", 0, Integer.MAX_VALUE, this.agent));
        childrenList.add(new Property(SP_ENTITY, "", "An entity used in this activity.", 0, Integer.MAX_VALUE, this.entity));
        childrenList.add(new Property("signature", "Signature", "A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.", 0, Integer.MAX_VALUE, this.signature));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.period;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.recorded;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case -1655966961: {
                Base[] baseArray;
                if (this.activity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.activity;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.location;
                }
                return baseArray;
            }
            case -982670030: {
                return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
            }
            case 92750597: {
                return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
            }
            case -1298275357: {
                return this.entity == null ? new Base[]{} : this.entity.toArray(new Base[this.entity.size()]);
            }
            case 1073584312: {
                return this.signature == null ? new Base[]{} : this.signature.toArray(new Base[this.signature.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -880905839: {
                this.getTarget().add(this.castToReference(value));
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case -799233872: {
                this.recorded = this.castToInstant(value);
                break;
            }
            case -934964668: {
                this.getReason().add(this.castToCoding(value));
                break;
            }
            case -1655966961: {
                this.activity = this.castToCoding(value);
                break;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                break;
            }
            case -982670030: {
                this.getPolicy().add(this.castToUri(value));
                break;
            }
            case 92750597: {
                this.getAgent().add((ProvenanceAgentComponent)value);
                break;
            }
            case -1298275357: {
                this.getEntity().add((ProvenanceEntityComponent)value);
                break;
            }
            case 1073584312: {
                this.getSignature().add(this.castToSignature(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            this.getTarget().add(this.castToReference(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("recorded")) {
            this.recorded = this.castToInstant(value);
        } else if (name.equals("reason")) {
            this.getReason().add(this.castToCoding(value));
        } else if (name.equals("activity")) {
            this.activity = this.castToCoding(value);
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals("policy")) {
            this.getPolicy().add(this.castToUri(value));
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().add((ProvenanceAgentComponent)value);
        } else if (name.equals(SP_ENTITY)) {
            this.getEntity().add((ProvenanceEntityComponent)value);
        } else if (name.equals("signature")) {
            this.getSignature().add(this.castToSignature(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -880905839: {
                return this.addTarget();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -799233872: {
                throw new FHIRException("Cannot make property recorded as it is not a complex type");
            }
            case -934964668: {
                return this.addReason();
            }
            case -1655966961: {
                return this.getActivity();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -982670030: {
                throw new FHIRException("Cannot make property policy as it is not a complex type");
            }
            case 92750597: {
                return this.addAgent();
            }
            case -1298275357: {
                return this.addEntity();
            }
            case 1073584312: {
                return this.addSignature();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TARGET)) {
            return this.addTarget();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("recorded")) {
            throw new FHIRException("Cannot call addChild on a primitive type Provenance.recorded");
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("activity")) {
            this.activity = new Coding();
            return this.activity;
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("policy")) {
            throw new FHIRException("Cannot call addChild on a primitive type Provenance.policy");
        }
        if (name.equals(SP_AGENT)) {
            return this.addAgent();
        }
        if (name.equals(SP_ENTITY)) {
            return this.addEntity();
        }
        if (name.equals("signature")) {
            return this.addSignature();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Provenance";
    }

    @Override
    public Provenance copy() {
        Provenance dst = new Provenance();
        this.copyValues(dst);
        if (this.target != null) {
            dst.target = new ArrayList<Reference>();
            for (Reference reference : this.target) {
                dst.target.add(reference.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        InstantType instantType = dst.recorded = this.recorded == null ? null : this.recorded.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<Coding>();
            for (Coding coding : this.reason) {
                dst.reason.add(coding.copy());
            }
        }
        dst.activity = this.activity == null ? null : this.activity.copy();
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.policy != null) {
            dst.policy = new ArrayList<UriType>();
            for (UriType uriType : this.policy) {
                dst.policy.add(uriType.copy());
            }
        }
        if (this.agent != null) {
            dst.agent = new ArrayList<ProvenanceAgentComponent>();
            for (ProvenanceAgentComponent provenanceAgentComponent : this.agent) {
                dst.agent.add(provenanceAgentComponent.copy());
            }
        }
        if (this.entity != null) {
            dst.entity = new ArrayList<ProvenanceEntityComponent>();
            for (ProvenanceEntityComponent provenanceEntityComponent : this.entity) {
                dst.entity.add(provenanceEntityComponent.copy());
            }
        }
        if (this.signature != null) {
            dst.signature = new ArrayList<Signature>();
            for (Signature signature : this.signature) {
                dst.signature.add(signature.copy());
            }
        }
        return dst;
    }

    protected Provenance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Provenance)) {
            return false;
        }
        Provenance o = (Provenance)other;
        return Provenance.compareDeep(this.target, o.target, true) && Provenance.compareDeep(this.period, o.period, true) && Provenance.compareDeep(this.recorded, o.recorded, true) && Provenance.compareDeep(this.reason, o.reason, true) && Provenance.compareDeep(this.activity, o.activity, true) && Provenance.compareDeep(this.location, o.location, true) && Provenance.compareDeep(this.policy, o.policy, true) && Provenance.compareDeep(this.agent, o.agent, true) && Provenance.compareDeep(this.entity, o.entity, true) && Provenance.compareDeep(this.signature, o.signature, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Provenance)) {
            return false;
        }
        Provenance o = (Provenance)other;
        return Provenance.compareValues(this.recorded, o.recorded, true) && Provenance.compareValues(this.policy, o.policy, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.target != null && !this.target.isEmpty() || this.period != null && !this.period.isEmpty() || this.recorded != null && !this.recorded.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.activity != null && !this.activity.isEmpty() || this.location != null && !this.location.isEmpty() || this.policy != null && !this.policy.isEmpty() || this.agent != null && !this.agent.isEmpty() || this.entity != null && !this.entity.isEmpty() || this.signature != null && !this.signature.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Provenance;
    }

    @Block
    public static class ProvenanceEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="derivation | revision | quotation | source | removal", formalDefinition="How the entity was used during the activity.")
        protected Enumeration<ProvenanceEntityRole> role;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of resource in this entity", formalDefinition="The type of the entity. If the entity is a resource, then this is a resource type.")
        protected Coding type;
        @Child(name="reference", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identity of entity", formalDefinition="Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.")
        protected UriType reference;
        @Child(name="display", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human description of entity", formalDefinition="Human-readable description of the entity.")
        protected StringType display;
        @Child(name="agent", type={ProvenanceAgentComponent.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Entity is attributed to this agent", formalDefinition="The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity.")
        protected ProvenanceAgentComponent agent;
        private static final long serialVersionUID = 1533729633L;

        public ProvenanceEntityComponent() {
        }

        public ProvenanceEntityComponent(Enumeration<ProvenanceEntityRole> role, Coding type, UriType reference) {
            this.role = role;
            this.type = type;
            this.reference = reference;
        }

        public Enumeration<ProvenanceEntityRole> getRoleElement() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new Enumeration<ProvenanceEntityRole>(new ProvenanceEntityRoleEnumFactory());
                }
            }
            return this.role;
        }

        public boolean hasRoleElement() {
            return this.role != null && !this.role.isEmpty();
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProvenanceEntityComponent setRoleElement(Enumeration<ProvenanceEntityRole> value) {
            this.role = value;
            return this;
        }

        public ProvenanceEntityRole getRole() {
            return this.role == null ? null : (ProvenanceEntityRole)((Object)this.role.getValue());
        }

        public ProvenanceEntityComponent setRole(ProvenanceEntityRole value) {
            if (this.role == null) {
                this.role = new Enumeration<ProvenanceEntityRole>(new ProvenanceEntityRoleEnumFactory());
            }
            this.role.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProvenanceEntityComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public UriType getReferenceElement() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new UriType();
                }
            }
            return this.reference;
        }

        public boolean hasReferenceElement() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ProvenanceEntityComponent setReferenceElement(UriType value) {
            this.reference = value;
            return this;
        }

        public String getReference() {
            return this.reference == null ? null : (String)this.reference.getValue();
        }

        public ProvenanceEntityComponent setReference(String value) {
            if (this.reference == null) {
                this.reference = new UriType();
            }
            this.reference.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ProvenanceEntityComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ProvenanceEntityComponent setDisplay(String value) {
            if (Utilities.noString(value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public ProvenanceAgentComponent getAgent() {
            if (this.agent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceEntityComponent.agent");
                }
                if (Configuration.doAutoCreate()) {
                    this.agent = new ProvenanceAgentComponent();
                }
            }
            return this.agent;
        }

        public boolean hasAgent() {
            return this.agent != null && !this.agent.isEmpty();
        }

        public ProvenanceEntityComponent setAgent(ProvenanceAgentComponent value) {
            this.agent = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("role", "code", "How the entity was used during the activity.", 0, Integer.MAX_VALUE, this.role));
            childrenList.add(new Property("type", "Coding", "The type of the entity. If the entity is a resource, then this is a resource type.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("reference", "uri", "Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative.", 0, Integer.MAX_VALUE, this.reference));
            childrenList.add(new Property("display", "string", "Human-readable description of the entity.", 0, Integer.MAX_VALUE, this.display));
            childrenList.add(new Property(Provenance.SP_AGENT, "@Provenance.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity.", 0, Integer.MAX_VALUE, this.agent));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.reference;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.display;
                    }
                    return baseArray;
                }
                case 92750597: {
                    Base[] baseArray;
                    if (this.agent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.agent;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = new ProvenanceEntityRoleEnumFactory().fromType(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case -925155509: {
                    this.reference = this.castToUri(value);
                    break;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    break;
                }
                case 92750597: {
                    this.agent = (ProvenanceAgentComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = new ProvenanceEntityRoleEnumFactory().fromType(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToUri(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals(Provenance.SP_AGENT)) {
                this.agent = (ProvenanceAgentComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    throw new FHIRException("Cannot make property role as it is not a complex type");
                }
                case 3575610: {
                    return this.getType();
                }
                case -925155509: {
                    throw new FHIRException("Cannot make property reference as it is not a complex type");
                }
                case 1671764162: {
                    throw new FHIRException("Cannot make property display as it is not a complex type");
                }
                case 92750597: {
                    return this.getAgent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                throw new FHIRException("Cannot call addChild on a primitive type Provenance.role");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("reference")) {
                throw new FHIRException("Cannot call addChild on a primitive type Provenance.reference");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type Provenance.display");
            }
            if (name.equals(Provenance.SP_AGENT)) {
                this.agent = new ProvenanceAgentComponent();
                return this.agent;
            }
            return super.addChild(name);
        }

        @Override
        public ProvenanceEntityComponent copy() {
            ProvenanceEntityComponent dst = new ProvenanceEntityComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.agent = this.agent == null ? null : this.agent.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProvenanceEntityComponent)) {
                return false;
            }
            ProvenanceEntityComponent o = (ProvenanceEntityComponent)other;
            return ProvenanceEntityComponent.compareDeep(this.role, o.role, true) && ProvenanceEntityComponent.compareDeep(this.type, o.type, true) && ProvenanceEntityComponent.compareDeep(this.reference, o.reference, true) && ProvenanceEntityComponent.compareDeep(this.display, o.display, true) && ProvenanceEntityComponent.compareDeep(this.agent, o.agent, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProvenanceEntityComponent)) {
                return false;
            }
            ProvenanceEntityComponent o = (ProvenanceEntityComponent)other;
            return ProvenanceEntityComponent.compareValues(this.role, o.role, true) && ProvenanceEntityComponent.compareValues(this.reference, o.reference, true) && ProvenanceEntityComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.role != null && !this.role.isEmpty() || this.type != null && !this.type.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.display != null && !this.display.isEmpty() || this.agent != null && !this.agent.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Provenance.entity";
        }
    }

    @Block
    public static class ProvenanceAgentRelatedAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of relationship between agents", formalDefinition="The type of relationship between agents.")
        protected CodeableConcept type;
        @Child(name="target", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to other agent in this resource by identifier", formalDefinition="An internal reference to another agent listed in this provenance by its identifier.")
        protected UriType target;
        private static final long serialVersionUID = 794181198L;

        public ProvenanceAgentRelatedAgentComponent() {
        }

        public ProvenanceAgentRelatedAgentComponent(CodeableConcept type, UriType target) {
            this.type = type;
            this.target = target;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentRelatedAgentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProvenanceAgentRelatedAgentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public UriType getTargetElement() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentRelatedAgentComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new UriType();
                }
            }
            return this.target;
        }

        public boolean hasTargetElement() {
            return this.target != null && !this.target.isEmpty();
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public ProvenanceAgentRelatedAgentComponent setTargetElement(UriType value) {
            this.target = value;
            return this;
        }

        public String getTarget() {
            return this.target == null ? null : (String)this.target.getValue();
        }

        public ProvenanceAgentRelatedAgentComponent setTarget(String value) {
            if (this.target == null) {
                this.target = new UriType();
            }
            this.target.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "CodeableConcept", "The type of relationship between agents.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(Provenance.SP_TARGET, "uri", "An internal reference to another agent listed in this provenance by its identifier.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    break;
                }
                case -880905839: {
                    this.target = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals(Provenance.SP_TARGET)) {
                this.target = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -880905839: {
                    throw new FHIRException("Cannot make property target as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(Provenance.SP_TARGET)) {
                throw new FHIRException("Cannot call addChild on a primitive type Provenance.target");
            }
            return super.addChild(name);
        }

        @Override
        public ProvenanceAgentRelatedAgentComponent copy() {
            ProvenanceAgentRelatedAgentComponent dst = new ProvenanceAgentRelatedAgentComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.target = this.target == null ? null : this.target.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProvenanceAgentRelatedAgentComponent)) {
                return false;
            }
            ProvenanceAgentRelatedAgentComponent o = (ProvenanceAgentRelatedAgentComponent)other;
            return ProvenanceAgentRelatedAgentComponent.compareDeep(this.type, o.type, true) && ProvenanceAgentRelatedAgentComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProvenanceAgentRelatedAgentComponent)) {
                return false;
            }
            ProvenanceAgentRelatedAgentComponent o = (ProvenanceAgentRelatedAgentComponent)other;
            return ProvenanceAgentRelatedAgentComponent.compareValues(this.target, o.target, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.target != null && !this.target.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Provenance.agent.relatedAgent";
        }
    }

    @Block
    public static class ProvenanceAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="What the agents involvement was", formalDefinition="The function of the agent with respect to the activity.")
        protected Coding role;
        @Child(name="actor", type={Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual, device or organization playing role", formalDefinition="The individual, device or organization that participated in the event.")
        protected Reference actor;
        protected Resource actorTarget;
        @Child(name="userId", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Authorization-system identifier for the agent", formalDefinition="The identity of the agent as known by the authorization system.")
        protected Identifier userId;
        @Child(name="relatedAgent", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Track delegation between agents", formalDefinition="A relationship between two the agents referenced in this resource. This is defined to allow for explicit description of the delegation between agents.  For example, this human author used this device, or one person acted on another's behest.")
        protected List<ProvenanceAgentRelatedAgentComponent> relatedAgent;
        private static final long serialVersionUID = 1792758952L;

        public ProvenanceAgentComponent() {
        }

        public ProvenanceAgentComponent(Coding role) {
            this.role = role;
        }

        public Coding getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new Coding();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProvenanceAgentComponent setRole(Coding value) {
            this.role = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ProvenanceAgentComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public ProvenanceAgentComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        public Identifier getUserId() {
            if (this.userId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvenanceAgentComponent.userId");
                }
                if (Configuration.doAutoCreate()) {
                    this.userId = new Identifier();
                }
            }
            return this.userId;
        }

        public boolean hasUserId() {
            return this.userId != null && !this.userId.isEmpty();
        }

        public ProvenanceAgentComponent setUserId(Identifier value) {
            this.userId = value;
            return this;
        }

        public List<ProvenanceAgentRelatedAgentComponent> getRelatedAgent() {
            if (this.relatedAgent == null) {
                this.relatedAgent = new ArrayList<ProvenanceAgentRelatedAgentComponent>();
            }
            return this.relatedAgent;
        }

        public boolean hasRelatedAgent() {
            if (this.relatedAgent == null) {
                return false;
            }
            for (ProvenanceAgentRelatedAgentComponent item : this.relatedAgent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvenanceAgentRelatedAgentComponent addRelatedAgent() {
            ProvenanceAgentRelatedAgentComponent t = new ProvenanceAgentRelatedAgentComponent();
            if (this.relatedAgent == null) {
                this.relatedAgent = new ArrayList<ProvenanceAgentRelatedAgentComponent>();
            }
            this.relatedAgent.add(t);
            return t;
        }

        public ProvenanceAgentComponent addRelatedAgent(ProvenanceAgentRelatedAgentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.relatedAgent == null) {
                this.relatedAgent = new ArrayList<ProvenanceAgentRelatedAgentComponent>();
            }
            this.relatedAgent.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("role", "Coding", "The function of the agent with respect to the activity.", 0, Integer.MAX_VALUE, this.role));
            childrenList.add(new Property("actor", "Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "The individual, device or organization that participated in the event.", 0, Integer.MAX_VALUE, this.actor));
            childrenList.add(new Property("userId", "Identifier", "The identity of the agent as known by the authorization system.", 0, Integer.MAX_VALUE, this.userId));
            childrenList.add(new Property("relatedAgent", "", "A relationship between two the agents referenced in this resource. This is defined to allow for explicit description of the delegation between agents.  For example, this human author used this device, or one person acted on another's behest.", 0, Integer.MAX_VALUE, this.relatedAgent));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
                case -836030906: {
                    Base[] baseArray;
                    if (this.userId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.userId;
                    }
                    return baseArray;
                }
                case 126261658: {
                    return this.relatedAgent == null ? new Base[]{} : this.relatedAgent.toArray(new Base[this.relatedAgent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCoding(value);
                    break;
                }
                case 92645877: {
                    this.actor = this.castToReference(value);
                    break;
                }
                case -836030906: {
                    this.userId = this.castToIdentifier(value);
                    break;
                }
                case 126261658: {
                    this.getRelatedAgent().add((ProvenanceAgentRelatedAgentComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCoding(value);
            } else if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else if (name.equals("userId")) {
                this.userId = this.castToIdentifier(value);
            } else if (name.equals("relatedAgent")) {
                this.getRelatedAgent().add((ProvenanceAgentRelatedAgentComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case 92645877: {
                    return this.getActor();
                }
                case -836030906: {
                    return this.getUserId();
                }
                case 126261658: {
                    return this.addRelatedAgent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new Coding();
                return this.role;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("userId")) {
                this.userId = new Identifier();
                return this.userId;
            }
            if (name.equals("relatedAgent")) {
                return this.addRelatedAgent();
            }
            return super.addChild(name);
        }

        @Override
        public ProvenanceAgentComponent copy() {
            ProvenanceAgentComponent dst = new ProvenanceAgentComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            Identifier identifier = dst.userId = this.userId == null ? null : this.userId.copy();
            if (this.relatedAgent != null) {
                dst.relatedAgent = new ArrayList<ProvenanceAgentRelatedAgentComponent>();
                for (ProvenanceAgentRelatedAgentComponent i : this.relatedAgent) {
                    dst.relatedAgent.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ProvenanceAgentComponent)) {
                return false;
            }
            ProvenanceAgentComponent o = (ProvenanceAgentComponent)other;
            return ProvenanceAgentComponent.compareDeep(this.role, o.role, true) && ProvenanceAgentComponent.compareDeep(this.actor, o.actor, true) && ProvenanceAgentComponent.compareDeep(this.userId, o.userId, true) && ProvenanceAgentComponent.compareDeep(this.relatedAgent, o.relatedAgent, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ProvenanceAgentComponent)) {
                return false;
            }
            ProvenanceAgentComponent o = (ProvenanceAgentComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.role != null && !this.role.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.userId != null && !this.userId.isEmpty() || this.relatedAgent != null && !this.relatedAgent.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Provenance.agent";
        }
    }

    public static class ProvenanceEntityRoleEnumFactory
    implements EnumFactory<ProvenanceEntityRole> {
        @Override
        public ProvenanceEntityRole fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("derivation".equals(codeString)) {
                return ProvenanceEntityRole.DERIVATION;
            }
            if ("revision".equals(codeString)) {
                return ProvenanceEntityRole.REVISION;
            }
            if ("quotation".equals(codeString)) {
                return ProvenanceEntityRole.QUOTATION;
            }
            if ("source".equals(codeString)) {
                return ProvenanceEntityRole.SOURCE;
            }
            if ("removal".equals(codeString)) {
                return ProvenanceEntityRole.REMOVAL;
            }
            throw new IllegalArgumentException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        public Enumeration<ProvenanceEntityRole> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("derivation".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.DERIVATION);
            }
            if ("revision".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.REVISION);
            }
            if ("quotation".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.QUOTATION);
            }
            if ("source".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.SOURCE);
            }
            if ("removal".equals(codeString)) {
                return new Enumeration<ProvenanceEntityRole>(this, ProvenanceEntityRole.REMOVAL);
            }
            throw new FHIRException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        @Override
        public String toCode(ProvenanceEntityRole code) {
            if (code == ProvenanceEntityRole.DERIVATION) {
                return "derivation";
            }
            if (code == ProvenanceEntityRole.REVISION) {
                return "revision";
            }
            if (code == ProvenanceEntityRole.QUOTATION) {
                return "quotation";
            }
            if (code == ProvenanceEntityRole.SOURCE) {
                return "source";
            }
            if (code == ProvenanceEntityRole.REMOVAL) {
                return "removal";
            }
            return "?";
        }

        @Override
        public String toSystem(ProvenanceEntityRole code) {
            return code.getSystem();
        }
    }

    public static enum ProvenanceEntityRole {
        DERIVATION,
        REVISION,
        QUOTATION,
        SOURCE,
        REMOVAL,
        NULL;


        public static ProvenanceEntityRole fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("derivation".equals(codeString)) {
                return DERIVATION;
            }
            if ("revision".equals(codeString)) {
                return REVISION;
            }
            if ("quotation".equals(codeString)) {
                return QUOTATION;
            }
            if ("source".equals(codeString)) {
                return SOURCE;
            }
            if ("removal".equals(codeString)) {
                return REMOVAL;
            }
            throw new FHIRException("Unknown ProvenanceEntityRole code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DERIVATION: {
                    return "derivation";
                }
                case REVISION: {
                    return "revision";
                }
                case QUOTATION: {
                    return "quotation";
                }
                case SOURCE: {
                    return "source";
                }
                case REMOVAL: {
                    return "removal";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DERIVATION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case REVISION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case QUOTATION: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case SOURCE: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
                case REMOVAL: {
                    return "http://hl7.org/fhir/provenance-entity-role";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DERIVATION: {
                    return "A transformation of an entity into another, an update of an entity resulting in a new one, or the construction of a new entity based on a preexisting entity.";
                }
                case REVISION: {
                    return "A derivation for which the resulting entity is a revised version of some original.";
                }
                case QUOTATION: {
                    return "The repeat of (some or all of) an entity, such as text or image, by someone who may or may not be its original author.";
                }
                case SOURCE: {
                    return "A primary source for a topic refers to something produced by some agent with direct experience and knowledge about the topic, at the time of the topic's study, without benefit from hindsight.";
                }
                case REMOVAL: {
                    return "A derivation for which the entity is removed from accessibility usually through the use of the Delete operation.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DERIVATION: {
                    return "Derivation";
                }
                case REVISION: {
                    return "Revision";
                }
                case QUOTATION: {
                    return "Quotation";
                }
                case SOURCE: {
                    return "Source";
                }
                case REMOVAL: {
                    return "Removal";
                }
            }
            return "?";
        }
    }
}

