/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BodySite;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.MedicationOrder;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationDispense", profile="http://hl7.org/fhir/Profile/MedicationDispense")
public class MedicationDispense
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier assigned by the dispensing facility - this is an identifier assigned outside FHIR.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | on-hold | completed | entered-in-error | stopped", formalDefinition="A code specifying the state of the set of dispense events.")
    protected Enumeration<MedicationDispenseStatus> status;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What medication was supplied", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    protected Type medication;
    @Child(name="patient", type={Patient.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the dispense is for", formalDefinition="A link to a resource representing the person to whom the medication will be given.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="dispenser", type={Practitioner.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Practitioner responsible for dispensing medication", formalDefinition="The individual responsible for dispensing the medication.")
    protected Reference dispenser;
    protected Practitioner dispenserTarget;
    @Child(name="authorizingPrescription", type={MedicationOrder.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Medication order that authorizes the dispense", formalDefinition="Indicates the medication order that is being dispensed against.")
    protected List<Reference> authorizingPrescription;
    protected List<MedicationOrder> authorizingPrescriptionTarget;
    @Child(name="type", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Trial fill, partial fill, emergency fill, etc.", formalDefinition="Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
    protected CodeableConcept type;
    @Child(name="quantity", type={SimpleQuantity.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount dispensed", formalDefinition="The amount of medication that has been dispensed. Includes unit of measure.")
    protected SimpleQuantity quantity;
    @Child(name="daysSupply", type={SimpleQuantity.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of medication expressed as a timing amount", formalDefinition="The amount of medication expressed as a timing amount.")
    protected SimpleQuantity daysSupply;
    @Child(name="whenPrepared", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dispense processing time", formalDefinition="The time when the dispensed product was packaged and reviewed.")
    protected DateTimeType whenPrepared;
    @Child(name="whenHandedOver", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When product was given out", formalDefinition="The time the dispensed product was provided to the patient or their representative.")
    protected DateTimeType whenHandedOver;
    @Child(name="destination", type={Location.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the medication was sent", formalDefinition="Identification of the facility/location where the medication was shipped to, as part of the dispense event.")
    protected Reference destination;
    protected Location destinationTarget;
    @Child(name="receiver", type={Patient.class, Practitioner.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who collected the medication", formalDefinition="Identifies the person who picked up the medication.  This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional.")
    protected List<Reference> receiver;
    protected List<Resource> receiverTarget;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Information about the dispense", formalDefinition="Extra information about the dispense that could not be conveyed in the other attributes.")
    protected List<Annotation> note;
    @Child(name="dosageInstruction", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Medicine administration instructions to the patient/caregiver", formalDefinition="Indicates how the medication is to be used by the patient.  The pharmacist reviews the medication order prior to dispense and updates the dosageInstruction based on the actual product being dispensed.")
    protected List<MedicationDispenseDosageInstructionComponent> dosageInstruction;
    @Child(name="substitution", type={}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Deals with substitution of one medicine for another", formalDefinition="Indicates whether or not substitution was made as part of the dispense.  In some cases substitution will be expected but does not happen, in other cases substitution is not expected but does happen.  This block explains what substitution did or did not happen and why.")
    protected MedicationDispenseSubstitutionComponent substitution;
    private static final long serialVersionUID = -634238241L;
    @SearchParamDefinition(name="medication", path="MedicationDispense.medication.as(Reference)", description="Return dispenses of this medicine resource", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationDispense:medication").toLocked();
    @SearchParamDefinition(name="patient", path="MedicationDispense.patient", description="The identity of a patient to list dispenses  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationDispense:patient").toLocked();
    @SearchParamDefinition(name="receiver", path="MedicationDispense.receiver", description="Who collected the medication", type="reference")
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_RECEIVER = new Include("MedicationDispense:receiver").toLocked();
    @SearchParamDefinition(name="status", path="MedicationDispense.status", description="Status of the dispense", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="prescription", path="MedicationDispense.authorizingPrescription", description="The identity of a prescription to list dispenses from", type="reference")
    public static final String SP_PRESCRIPTION = "prescription";
    public static final ReferenceClientParam PRESCRIPTION = new ReferenceClientParam("prescription");
    public static final Include INCLUDE_PRESCRIPTION = new Include("MedicationDispense:prescription").toLocked();
    @SearchParamDefinition(name="responsibleparty", path="MedicationDispense.substitution.responsibleParty", description="Return all dispenses with the specified responsible party", type="reference")
    public static final String SP_RESPONSIBLEPARTY = "responsibleparty";
    public static final ReferenceClientParam RESPONSIBLEPARTY = new ReferenceClientParam("responsibleparty");
    public static final Include INCLUDE_RESPONSIBLEPARTY = new Include("MedicationDispense:responsibleparty").toLocked();
    @SearchParamDefinition(name="dispenser", path="MedicationDispense.dispenser", description="Return all dispenses performed by a specific individual", type="reference")
    public static final String SP_DISPENSER = "dispenser";
    public static final ReferenceClientParam DISPENSER = new ReferenceClientParam("dispenser");
    public static final Include INCLUDE_DISPENSER = new Include("MedicationDispense:dispenser").toLocked();
    @SearchParamDefinition(name="code", path="MedicationDispense.medication.as(CodeableConcept)", description="Return dispenses of this medicine code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="type", path="MedicationDispense.type", description="Return all dispenses of a specific type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="identifier", path="MedicationDispense.identifier", description="Return dispenses with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="whenprepared", path="MedicationDispense.whenPrepared", description="Date when medication prepared", type="date")
    public static final String SP_WHENPREPARED = "whenprepared";
    public static final DateClientParam WHENPREPARED = new DateClientParam("whenprepared");
    @SearchParamDefinition(name="whenhandedover", path="MedicationDispense.whenHandedOver", description="Date when medication handed over to patient (outpatient setting), or supplied to ward or clinic (inpatient setting)", type="date")
    public static final String SP_WHENHANDEDOVER = "whenhandedover";
    public static final DateClientParam WHENHANDEDOVER = new DateClientParam("whenhandedover");
    @SearchParamDefinition(name="destination", path="MedicationDispense.destination", description="Return dispenses that should be sent to a specific destination", type="reference")
    public static final String SP_DESTINATION = "destination";
    public static final ReferenceClientParam DESTINATION = new ReferenceClientParam("destination");
    public static final Include INCLUDE_DESTINATION = new Include("MedicationDispense:destination").toLocked();

    public MedicationDispense() {
    }

    public MedicationDispense(Type medication) {
        this.medication = medication;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public MedicationDispense setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<MedicationDispenseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationDispenseStatus>(new MedicationDispenseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationDispense setStatusElement(Enumeration<MedicationDispenseStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationDispenseStatus getStatus() {
        return this.status == null ? null : (MedicationDispenseStatus)((Object)this.status.getValue());
    }

    public MedicationDispense setStatus(MedicationDispenseStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationDispenseStatus>(new MedicationDispenseStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Type getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationDispense setMedication(Type value) {
        this.medication = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public MedicationDispense setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public MedicationDispense setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getDispenser() {
        if (this.dispenser == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.dispenser");
            }
            if (Configuration.doAutoCreate()) {
                this.dispenser = new Reference();
            }
        }
        return this.dispenser;
    }

    public boolean hasDispenser() {
        return this.dispenser != null && !this.dispenser.isEmpty();
    }

    public MedicationDispense setDispenser(Reference value) {
        this.dispenser = value;
        return this;
    }

    public Practitioner getDispenserTarget() {
        if (this.dispenserTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.dispenser");
            }
            if (Configuration.doAutoCreate()) {
                this.dispenserTarget = new Practitioner();
            }
        }
        return this.dispenserTarget;
    }

    public MedicationDispense setDispenserTarget(Practitioner value) {
        this.dispenserTarget = value;
        return this;
    }

    public List<Reference> getAuthorizingPrescription() {
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        return this.authorizingPrescription;
    }

    public boolean hasAuthorizingPrescription() {
        if (this.authorizingPrescription == null) {
            return false;
        }
        for (Reference item : this.authorizingPrescription) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthorizingPrescription() {
        Reference t = new Reference();
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        this.authorizingPrescription.add(t);
        return t;
    }

    public MedicationDispense addAuthorizingPrescription(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        this.authorizingPrescription.add(t);
        return this;
    }

    public List<MedicationOrder> getAuthorizingPrescriptionTarget() {
        if (this.authorizingPrescriptionTarget == null) {
            this.authorizingPrescriptionTarget = new ArrayList<MedicationOrder>();
        }
        return this.authorizingPrescriptionTarget;
    }

    public MedicationOrder addAuthorizingPrescriptionTarget() {
        MedicationOrder r = new MedicationOrder();
        if (this.authorizingPrescriptionTarget == null) {
            this.authorizingPrescriptionTarget = new ArrayList<MedicationOrder>();
        }
        this.authorizingPrescriptionTarget.add(r);
        return r;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MedicationDispense setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public SimpleQuantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new SimpleQuantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public MedicationDispense setQuantity(SimpleQuantity value) {
        this.quantity = value;
        return this;
    }

    public SimpleQuantity getDaysSupply() {
        if (this.daysSupply == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.daysSupply");
            }
            if (Configuration.doAutoCreate()) {
                this.daysSupply = new SimpleQuantity();
            }
        }
        return this.daysSupply;
    }

    public boolean hasDaysSupply() {
        return this.daysSupply != null && !this.daysSupply.isEmpty();
    }

    public MedicationDispense setDaysSupply(SimpleQuantity value) {
        this.daysSupply = value;
        return this;
    }

    public DateTimeType getWhenPreparedElement() {
        if (this.whenPrepared == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.whenPrepared");
            }
            if (Configuration.doAutoCreate()) {
                this.whenPrepared = new DateTimeType();
            }
        }
        return this.whenPrepared;
    }

    public boolean hasWhenPreparedElement() {
        return this.whenPrepared != null && !this.whenPrepared.isEmpty();
    }

    public boolean hasWhenPrepared() {
        return this.whenPrepared != null && !this.whenPrepared.isEmpty();
    }

    public MedicationDispense setWhenPreparedElement(DateTimeType value) {
        this.whenPrepared = value;
        return this;
    }

    public Date getWhenPrepared() {
        return this.whenPrepared == null ? null : (Date)this.whenPrepared.getValue();
    }

    public MedicationDispense setWhenPrepared(Date value) {
        if (value == null) {
            this.whenPrepared = null;
        } else {
            if (this.whenPrepared == null) {
                this.whenPrepared = new DateTimeType();
            }
            this.whenPrepared.setValue(value);
        }
        return this;
    }

    public DateTimeType getWhenHandedOverElement() {
        if (this.whenHandedOver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.whenHandedOver");
            }
            if (Configuration.doAutoCreate()) {
                this.whenHandedOver = new DateTimeType();
            }
        }
        return this.whenHandedOver;
    }

    public boolean hasWhenHandedOverElement() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public boolean hasWhenHandedOver() {
        return this.whenHandedOver != null && !this.whenHandedOver.isEmpty();
    }

    public MedicationDispense setWhenHandedOverElement(DateTimeType value) {
        this.whenHandedOver = value;
        return this;
    }

    public Date getWhenHandedOver() {
        return this.whenHandedOver == null ? null : (Date)this.whenHandedOver.getValue();
    }

    public MedicationDispense setWhenHandedOver(Date value) {
        if (value == null) {
            this.whenHandedOver = null;
        } else {
            if (this.whenHandedOver == null) {
                this.whenHandedOver = new DateTimeType();
            }
            this.whenHandedOver.setValue(value);
        }
        return this;
    }

    public Reference getDestination() {
        if (this.destination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destination = new Reference();
            }
        }
        return this.destination;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public MedicationDispense setDestination(Reference value) {
        this.destination = value;
        return this;
    }

    public Location getDestinationTarget() {
        if (this.destinationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destinationTarget = new Location();
            }
        }
        return this.destinationTarget;
    }

    public MedicationDispense setDestinationTarget(Location value) {
        this.destinationTarget = value;
        return this;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public boolean hasReceiver() {
        if (this.receiver == null) {
            return false;
        }
        for (Reference item : this.receiver) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReceiver() {
        Reference t = new Reference();
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return t;
    }

    public MedicationDispense addReceiver(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return this;
    }

    public List<Resource> getReceiverTarget() {
        if (this.receiverTarget == null) {
            this.receiverTarget = new ArrayList<Resource>();
        }
        return this.receiverTarget;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public MedicationDispense addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public List<MedicationDispenseDosageInstructionComponent> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationDispenseDosageInstructionComponent>();
        }
        return this.dosageInstruction;
    }

    public boolean hasDosageInstruction() {
        if (this.dosageInstruction == null) {
            return false;
        }
        for (MedicationDispenseDosageInstructionComponent item : this.dosageInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationDispenseDosageInstructionComponent addDosageInstruction() {
        MedicationDispenseDosageInstructionComponent t = new MedicationDispenseDosageInstructionComponent();
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationDispenseDosageInstructionComponent>();
        }
        this.dosageInstruction.add(t);
        return t;
    }

    public MedicationDispense addDosageInstruction(MedicationDispenseDosageInstructionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationDispenseDosageInstructionComponent>();
        }
        this.dosageInstruction.add(t);
        return this;
    }

    public MedicationDispenseSubstitutionComponent getSubstitution() {
        if (this.substitution == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationDispense.substitution");
            }
            if (Configuration.doAutoCreate()) {
                this.substitution = new MedicationDispenseSubstitutionComponent();
            }
        }
        return this.substitution;
    }

    public boolean hasSubstitution() {
        return this.substitution != null && !this.substitution.isEmpty();
    }

    public MedicationDispense setSubstitution(MedicationDispenseSubstitutionComponent value) {
        this.substitution = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier assigned by the dispensing facility - this is an identifier assigned outside FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "A code specifying the state of the set of dispense events.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person to whom the medication will be given.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_DISPENSER, "Reference(Practitioner)", "The individual responsible for dispensing the medication.", 0, Integer.MAX_VALUE, this.dispenser));
        childrenList.add(new Property("authorizingPrescription", "Reference(MedicationOrder)", "Indicates the medication order that is being dispensed against.", 0, Integer.MAX_VALUE, this.authorizingPrescription));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("quantity", "SimpleQuantity", "The amount of medication that has been dispensed. Includes unit of measure.", 0, Integer.MAX_VALUE, this.quantity));
        childrenList.add(new Property("daysSupply", "SimpleQuantity", "The amount of medication expressed as a timing amount.", 0, Integer.MAX_VALUE, this.daysSupply));
        childrenList.add(new Property("whenPrepared", "dateTime", "The time when the dispensed product was packaged and reviewed.", 0, Integer.MAX_VALUE, this.whenPrepared));
        childrenList.add(new Property("whenHandedOver", "dateTime", "The time the dispensed product was provided to the patient or their representative.", 0, Integer.MAX_VALUE, this.whenHandedOver));
        childrenList.add(new Property(SP_DESTINATION, "Reference(Location)", "Identification of the facility/location where the medication was shipped to, as part of the dispense event.", 0, Integer.MAX_VALUE, this.destination));
        childrenList.add(new Property(SP_RECEIVER, "Reference(Patient|Practitioner)", "Identifies the person who picked up the medication.  This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional.", 0, Integer.MAX_VALUE, this.receiver));
        childrenList.add(new Property("note", "Annotation", "Extra information about the dispense that could not be conveyed in the other attributes.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("dosageInstruction", "", "Indicates how the medication is to be used by the patient.  The pharmacist reviews the medication order prior to dispense and updates the dosageInstruction based on the actual product being dispensed.", 0, Integer.MAX_VALUE, this.dosageInstruction));
        childrenList.add(new Property("substitution", "", "Indicates whether or not substitution was made as part of the dispense.  In some cases substitution will be expected but does not happen, in other cases substitution is not expected but does happen.  This block explains what substitution did or did not happen and why.", 0, Integer.MAX_VALUE, this.substitution));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 1998965455: {
                Base[] baseArray;
                if (this.medication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.medication;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
            case 241511093: {
                Base[] baseArray;
                if (this.dispenser == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.dispenser;
                }
                return baseArray;
            }
            case -1237557856: {
                return this.authorizingPrescription == null ? new Base[]{} : this.authorizingPrescription.toArray(new Base[this.authorizingPrescription.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.type;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.quantity;
                }
                return baseArray;
            }
            case 197175334: {
                Base[] baseArray;
                if (this.daysSupply == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.daysSupply;
                }
                return baseArray;
            }
            case -562837097: {
                Base[] baseArray;
                if (this.whenPrepared == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.whenPrepared;
                }
                return baseArray;
            }
            case -940241380: {
                Base[] baseArray;
                if (this.whenHandedOver == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.whenHandedOver;
                }
                return baseArray;
            }
            case -1429847026: {
                Base[] baseArray;
                if (this.destination == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.destination;
                }
                return baseArray;
            }
            case -808719889: {
                return this.receiver == null ? new Base[]{} : this.receiver.toArray(new Base[this.receiver.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1201373865: {
                return this.dosageInstruction == null ? new Base[]{} : this.dosageInstruction.toArray(new Base[this.dosageInstruction.size()]);
            }
            case 826147581: {
                Base[] baseArray;
                if (this.substitution == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.substitution;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case -892481550: {
                this.status = new MedicationDispenseStatusEnumFactory().fromType(value);
                break;
            }
            case 1998965455: {
                this.medication = (Type)value;
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case 241511093: {
                this.dispenser = this.castToReference(value);
                break;
            }
            case -1237557856: {
                this.getAuthorizingPrescription().add(this.castToReference(value));
                break;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                break;
            }
            case -1285004149: {
                this.quantity = this.castToSimpleQuantity(value);
                break;
            }
            case 197175334: {
                this.daysSupply = this.castToSimpleQuantity(value);
                break;
            }
            case -562837097: {
                this.whenPrepared = this.castToDateTime(value);
                break;
            }
            case -940241380: {
                this.whenHandedOver = this.castToDateTime(value);
                break;
            }
            case -1429847026: {
                this.destination = this.castToReference(value);
                break;
            }
            case -808719889: {
                this.getReceiver().add(this.castToReference(value));
                break;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                break;
            }
            case -1201373865: {
                this.getDosageInstruction().add((MedicationDispenseDosageInstructionComponent)value);
                break;
            }
            case 826147581: {
                this.substitution = (MedicationDispenseSubstitutionComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new MedicationDispenseStatusEnumFactory().fromType(value);
        } else if (name.equals("medication[x]")) {
            this.medication = (Type)value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_DISPENSER)) {
            this.dispenser = this.castToReference(value);
        } else if (name.equals("authorizingPrescription")) {
            this.getAuthorizingPrescription().add(this.castToReference(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToSimpleQuantity(value);
        } else if (name.equals("daysSupply")) {
            this.daysSupply = this.castToSimpleQuantity(value);
        } else if (name.equals("whenPrepared")) {
            this.whenPrepared = this.castToDateTime(value);
        } else if (name.equals("whenHandedOver")) {
            this.whenHandedOver = this.castToDateTime(value);
        } else if (name.equals(SP_DESTINATION)) {
            this.destination = this.castToReference(value);
        } else if (name.equals(SP_RECEIVER)) {
            this.getReceiver().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("dosageInstruction")) {
            this.getDosageInstruction().add((MedicationDispenseDosageInstructionComponent)value);
        } else if (name.equals("substitution")) {
            this.substitution = (MedicationDispenseSubstitutionComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 1458402129: {
                return this.getMedication();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 241511093: {
                return this.getDispenser();
            }
            case -1237557856: {
                return this.addAuthorizingPrescription();
            }
            case 3575610: {
                return this.getType();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 197175334: {
                return this.getDaysSupply();
            }
            case -562837097: {
                throw new FHIRException("Cannot make property whenPrepared as it is not a complex type");
            }
            case -940241380: {
                throw new FHIRException("Cannot make property whenHandedOver as it is not a complex type");
            }
            case -1429847026: {
                return this.getDestination();
            }
            case -808719889: {
                return this.addReceiver();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1201373865: {
                return this.addDosageInstruction();
            }
            case 826147581: {
                return this.getSubstitution();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationDispense.status");
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_DISPENSER)) {
            this.dispenser = new Reference();
            return this.dispenser;
        }
        if (name.equals("authorizingPrescription")) {
            return this.addAuthorizingPrescription();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("quantity")) {
            this.quantity = new SimpleQuantity();
            return this.quantity;
        }
        if (name.equals("daysSupply")) {
            this.daysSupply = new SimpleQuantity();
            return this.daysSupply;
        }
        if (name.equals("whenPrepared")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationDispense.whenPrepared");
        }
        if (name.equals("whenHandedOver")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationDispense.whenHandedOver");
        }
        if (name.equals(SP_DESTINATION)) {
            this.destination = new Reference();
            return this.destination;
        }
        if (name.equals(SP_RECEIVER)) {
            return this.addReceiver();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("dosageInstruction")) {
            return this.addDosageInstruction();
        }
        if (name.equals("substitution")) {
            this.substitution = new MedicationDispenseSubstitutionComponent();
            return this.substitution;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationDispense";
    }

    @Override
    public MedicationDispense copy() {
        MedicationDispense dst = new MedicationDispense();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.medication = this.medication == null ? null : this.medication.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        Reference reference = dst.dispenser = this.dispenser == null ? null : this.dispenser.copy();
        if (this.authorizingPrescription != null) {
            dst.authorizingPrescription = new ArrayList<Reference>();
            for (Reference reference2 : this.authorizingPrescription) {
                dst.authorizingPrescription.add(reference2.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        dst.daysSupply = this.daysSupply == null ? null : this.daysSupply.copy();
        dst.whenPrepared = this.whenPrepared == null ? null : this.whenPrepared.copy();
        dst.whenHandedOver = this.whenHandedOver == null ? null : this.whenHandedOver.copy();
        Reference reference3 = dst.destination = this.destination == null ? null : this.destination.copy();
        if (this.receiver != null) {
            dst.receiver = new ArrayList<Reference>();
            for (Reference reference4 : this.receiver) {
                dst.receiver.add(reference4.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.dosageInstruction != null) {
            dst.dosageInstruction = new ArrayList<MedicationDispenseDosageInstructionComponent>();
            for (MedicationDispenseDosageInstructionComponent medicationDispenseDosageInstructionComponent : this.dosageInstruction) {
                dst.dosageInstruction.add(medicationDispenseDosageInstructionComponent.copy());
            }
        }
        dst.substitution = this.substitution == null ? null : this.substitution.copy();
        return dst;
    }

    protected MedicationDispense typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof MedicationDispense)) {
            return false;
        }
        MedicationDispense o = (MedicationDispense)other;
        return MedicationDispense.compareDeep(this.identifier, o.identifier, true) && MedicationDispense.compareDeep(this.status, o.status, true) && MedicationDispense.compareDeep(this.medication, o.medication, true) && MedicationDispense.compareDeep(this.patient, o.patient, true) && MedicationDispense.compareDeep(this.dispenser, o.dispenser, true) && MedicationDispense.compareDeep(this.authorizingPrescription, o.authorizingPrescription, true) && MedicationDispense.compareDeep(this.type, o.type, true) && MedicationDispense.compareDeep(this.quantity, o.quantity, true) && MedicationDispense.compareDeep(this.daysSupply, o.daysSupply, true) && MedicationDispense.compareDeep(this.whenPrepared, o.whenPrepared, true) && MedicationDispense.compareDeep(this.whenHandedOver, o.whenHandedOver, true) && MedicationDispense.compareDeep(this.destination, o.destination, true) && MedicationDispense.compareDeep(this.receiver, o.receiver, true) && MedicationDispense.compareDeep(this.note, o.note, true) && MedicationDispense.compareDeep(this.dosageInstruction, o.dosageInstruction, true) && MedicationDispense.compareDeep(this.substitution, o.substitution, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof MedicationDispense)) {
            return false;
        }
        MedicationDispense o = (MedicationDispense)other;
        return MedicationDispense.compareValues(this.status, o.status, true) && MedicationDispense.compareValues(this.whenPrepared, o.whenPrepared, true) && MedicationDispense.compareValues(this.whenHandedOver, o.whenHandedOver, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.medication != null && !this.medication.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.dispenser != null && !this.dispenser.isEmpty() || this.authorizingPrescription != null && !this.authorizingPrescription.isEmpty() || this.type != null && !this.type.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.daysSupply != null && !this.daysSupply.isEmpty() || this.whenPrepared != null && !this.whenPrepared.isEmpty() || this.whenHandedOver != null && !this.whenHandedOver.isEmpty() || this.destination != null && !this.destination.isEmpty() || this.receiver != null && !this.receiver.isEmpty() || this.note != null && !this.note.isEmpty() || this.dosageInstruction != null && !this.dosageInstruction.isEmpty() || this.substitution != null && !this.substitution.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationDispense;
    }

    @Block
    public static class MedicationDispenseSubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code signifying whether a different drug was dispensed from what was prescribed", formalDefinition="A code signifying whether a different drug was dispensed from what was prescribed.")
        protected CodeableConcept type;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Why was substitution made", formalDefinition="Indicates the reason for the substitution of (or lack of substitution) from what was prescribed.")
        protected List<CodeableConcept> reason;
        @Child(name="responsibleParty", type={Practitioner.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Who is responsible for the substitution", formalDefinition="The person or organization that has primary responsibility for the substitution.")
        protected List<Reference> responsibleParty;
        protected List<Practitioner> responsiblePartyTarget;
        private static final long serialVersionUID = 1218245830L;

        public MedicationDispenseSubstitutionComponent() {
        }

        public MedicationDispenseSubstitutionComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseSubstitutionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationDispenseSubstitutionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            return this.reason;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableConcept item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return t;
        }

        public MedicationDispenseSubstitutionComponent addReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return this;
        }

        public List<Reference> getResponsibleParty() {
            if (this.responsibleParty == null) {
                this.responsibleParty = new ArrayList<Reference>();
            }
            return this.responsibleParty;
        }

        public boolean hasResponsibleParty() {
            if (this.responsibleParty == null) {
                return false;
            }
            for (Reference item : this.responsibleParty) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addResponsibleParty() {
            Reference t = new Reference();
            if (this.responsibleParty == null) {
                this.responsibleParty = new ArrayList<Reference>();
            }
            this.responsibleParty.add(t);
            return t;
        }

        public MedicationDispenseSubstitutionComponent addResponsibleParty(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.responsibleParty == null) {
                this.responsibleParty = new ArrayList<Reference>();
            }
            this.responsibleParty.add(t);
            return this;
        }

        public List<Practitioner> getResponsiblePartyTarget() {
            if (this.responsiblePartyTarget == null) {
                this.responsiblePartyTarget = new ArrayList<Practitioner>();
            }
            return this.responsiblePartyTarget;
        }

        public Practitioner addResponsiblePartyTarget() {
            Practitioner r = new Practitioner();
            if (this.responsiblePartyTarget == null) {
                this.responsiblePartyTarget = new ArrayList<Practitioner>();
            }
            this.responsiblePartyTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(MedicationDispense.SP_TYPE, "CodeableConcept", "A code signifying whether a different drug was dispensed from what was prescribed.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("reason", "CodeableConcept", "Indicates the reason for the substitution of (or lack of substitution) from what was prescribed.", 0, Integer.MAX_VALUE, this.reason));
            childrenList.add(new Property("responsibleParty", "Reference(Practitioner)", "The person or organization that has primary responsibility for the substitution.", 0, Integer.MAX_VALUE, this.responsibleParty));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
                case 1511509392: {
                    return this.responsibleParty == null ? new Base[]{} : this.responsibleParty.toArray(new Base[this.responsibleParty.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    break;
                }
                case -934964668: {
                    this.getReason().add(this.castToCodeableConcept(value));
                    break;
                }
                case 1511509392: {
                    this.getResponsibleParty().add(this.castToReference(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicationDispense.SP_TYPE)) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.getReason().add(this.castToCodeableConcept(value));
            } else if (name.equals("responsibleParty")) {
                this.getResponsibleParty().add(this.castToReference(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -934964668: {
                    return this.addReason();
                }
                case 1511509392: {
                    return this.addResponsibleParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicationDispense.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("reason")) {
                return this.addReason();
            }
            if (name.equals("responsibleParty")) {
                return this.addResponsibleParty();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationDispenseSubstitutionComponent copy() {
            MedicationDispenseSubstitutionComponent dst = new MedicationDispenseSubstitutionComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.reason) {
                    dst.reason.add(codeableConcept2.copy());
                }
            }
            if (this.responsibleParty != null) {
                dst.responsibleParty = new ArrayList<Reference>();
                for (Reference reference : this.responsibleParty) {
                    dst.responsibleParty.add(reference.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationDispenseSubstitutionComponent)) {
                return false;
            }
            MedicationDispenseSubstitutionComponent o = (MedicationDispenseSubstitutionComponent)other;
            return MedicationDispenseSubstitutionComponent.compareDeep(this.type, o.type, true) && MedicationDispenseSubstitutionComponent.compareDeep(this.reason, o.reason, true) && MedicationDispenseSubstitutionComponent.compareDeep(this.responsibleParty, o.responsibleParty, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationDispenseSubstitutionComponent)) {
                return false;
            }
            MedicationDispenseSubstitutionComponent o = (MedicationDispenseSubstitutionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.responsibleParty != null && !this.responsibleParty.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MedicationDispense.substitution";
        }
    }

    @Block
    public static class MedicationDispenseDosageInstructionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Free text dosage instructions e.g. SIG", formalDefinition="Free text dosage instructions can be used for cases where the instructions are too complex to code. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication.")
        protected StringType text;
        @Child(name="additionalInstructions", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="E.g. \"Take with food\"", formalDefinition="Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.")
        protected CodeableConcept additionalInstructions;
        @Child(name="timing", type={Timing.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When medication should be administered", formalDefinition="The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions.  For example, \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
        protected Timing timing;
        @Child(name="asNeeded", type={BooleanType.class, CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Take \"as needed\" f(or x)", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).  \n\nSpecifically if 'boolean' datatype is selected, then the following logic applies:  If set to True, this indicates that the medication is only taken when needed, within the specified schedule.")
        protected Type asNeeded;
        @Child(name="site", type={CodeableConcept.class, BodySite.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body site to administer to", formalDefinition="A coded specification of the anatomic site where the medication first enters the body.")
        protected Type site;
        @Child(name="route", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How drug should enter body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.")
        protected CodeableConcept route;
        @Child(name="method", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Technique for administering medication", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.")
        protected CodeableConcept method;
        @Child(name="dose", type={Range.class, SimpleQuantity.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        protected Type dose;
        @Child(name="rate", type={Ratio.class, Range.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of medication per unit of time", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        protected Type rate;
        @Child(name="maxDosePerPeriod", type={Ratio.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Upper limit on medication per unit of time", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time,  e.g. 1000mg in 24 hours.")
        protected Ratio maxDosePerPeriod;
        private static final long serialVersionUID = -1470136646L;

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseDosageInstructionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public MedicationDispenseDosageInstructionComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getAdditionalInstructions() {
            if (this.additionalInstructions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseDosageInstructionComponent.additionalInstructions");
                }
                if (Configuration.doAutoCreate()) {
                    this.additionalInstructions = new CodeableConcept();
                }
            }
            return this.additionalInstructions;
        }

        public boolean hasAdditionalInstructions() {
            return this.additionalInstructions != null && !this.additionalInstructions.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setAdditionalInstructions(CodeableConcept value) {
            this.additionalInstructions = value;
            return this;
        }

        public Timing getTiming() {
            if (this.timing == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseDosageInstructionComponent.timing");
                }
                if (Configuration.doAutoCreate()) {
                    this.timing = new Timing();
                }
            }
            return this.timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setTiming(Timing value) {
            this.timing = value;
            return this;
        }

        public Type getAsNeeded() {
            return this.asNeeded;
        }

        public BooleanType getAsNeededBooleanType() throws FHIRException {
            if (!(this.asNeeded instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.asNeeded;
        }

        public boolean hasAsNeededBooleanType() {
            return this.asNeeded instanceof BooleanType;
        }

        public CodeableConcept getAsNeededCodeableConcept() throws FHIRException {
            if (!(this.asNeeded instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.asNeeded;
        }

        public boolean hasAsNeededCodeableConcept() {
            return this.asNeeded instanceof CodeableConcept;
        }

        public boolean hasAsNeeded() {
            return this.asNeeded != null && !this.asNeeded.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setAsNeeded(Type value) {
            this.asNeeded = value;
            return this;
        }

        public Type getSite() {
            return this.site;
        }

        public CodeableConcept getSiteCodeableConcept() throws FHIRException {
            if (!(this.site instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.site;
        }

        public boolean hasSiteCodeableConcept() {
            return this.site instanceof CodeableConcept;
        }

        public Reference getSiteReference() throws FHIRException {
            if (!(this.site instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (Reference)this.site;
        }

        public boolean hasSiteReference() {
            return this.site instanceof Reference;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setSite(Type value) {
            this.site = value;
            return this;
        }

        public CodeableConcept getRoute() {
            if (this.route == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseDosageInstructionComponent.route");
                }
                if (Configuration.doAutoCreate()) {
                    this.route = new CodeableConcept();
                }
            }
            return this.route;
        }

        public boolean hasRoute() {
            return this.route != null && !this.route.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setRoute(CodeableConcept value) {
            this.route = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseDosageInstructionComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public Type getDose() {
            return this.dose;
        }

        public Range getDoseRange() throws FHIRException {
            if (!(this.dose instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.dose.getClass().getName() + " was encountered");
            }
            return (Range)this.dose;
        }

        public boolean hasDoseRange() {
            return this.dose instanceof Range;
        }

        public SimpleQuantity getDoseSimpleQuantity() throws FHIRException {
            if (!(this.dose instanceof SimpleQuantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.dose.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.dose;
        }

        public boolean hasDoseSimpleQuantity() {
            return this.dose instanceof SimpleQuantity;
        }

        public boolean hasDose() {
            return this.dose != null && !this.dose.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setDose(Type value) {
            this.dose = value;
            return this;
        }

        public Type getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this.rate instanceof Ratio;
        }

        public Range getRateRange() throws FHIRException {
            if (!(this.rate instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Range)this.rate;
        }

        public boolean hasRateRange() {
            return this.rate instanceof Range;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setRate(Type value) {
            this.rate = value;
            return this;
        }

        public Ratio getMaxDosePerPeriod() {
            if (this.maxDosePerPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationDispenseDosageInstructionComponent.maxDosePerPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDosePerPeriod = new Ratio();
                }
            }
            return this.maxDosePerPeriod;
        }

        public boolean hasMaxDosePerPeriod() {
            return this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty();
        }

        public MedicationDispenseDosageInstructionComponent setMaxDosePerPeriod(Ratio value) {
            this.maxDosePerPeriod = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("text", "string", "Free text dosage instructions can be used for cases where the instructions are too complex to code. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("additionalInstructions", "CodeableConcept", "Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.", 0, Integer.MAX_VALUE, this.additionalInstructions));
            childrenList.add(new Property("timing", "Timing", "The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions.  For example, \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, Integer.MAX_VALUE, this.timing));
            childrenList.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).  \n\nSpecifically if 'boolean' datatype is selected, then the following logic applies:  If set to True, this indicates that the medication is only taken when needed, within the specified schedule.", 0, Integer.MAX_VALUE, this.asNeeded));
            childrenList.add(new Property("site[x]", "CodeableConcept|Reference(BodySite)", "A coded specification of the anatomic site where the medication first enters the body.", 0, Integer.MAX_VALUE, this.site));
            childrenList.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.", 0, Integer.MAX_VALUE, this.route));
            childrenList.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.", 0, Integer.MAX_VALUE, this.method));
            childrenList.add(new Property("dose[x]", "Range|SimpleQuantity", "The amount of therapeutic or other substance given at one administration event.", 0, Integer.MAX_VALUE, this.dose));
            childrenList.add(new Property("rate[x]", "Ratio|Range", "Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, Integer.MAX_VALUE, this.rate));
            childrenList.add(new Property("maxDosePerPeriod", "Ratio", "The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time,  e.g. 1000mg in 24 hours.", 0, Integer.MAX_VALUE, this.maxDosePerPeriod));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.text;
                    }
                    return baseArray;
                }
                case -1206718612: {
                    Base[] baseArray;
                    if (this.additionalInstructions == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.additionalInstructions;
                    }
                    return baseArray;
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.timing;
                    }
                    return baseArray;
                }
                case -1432923513: {
                    Base[] baseArray;
                    if (this.asNeeded == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.asNeeded;
                    }
                    return baseArray;
                }
                case 3530567: {
                    Base[] baseArray;
                    if (this.site == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.site;
                    }
                    return baseArray;
                }
                case 108704329: {
                    Base[] baseArray;
                    if (this.route == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.route;
                    }
                    return baseArray;
                }
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.method;
                    }
                    return baseArray;
                }
                case 3089437: {
                    Base[] baseArray;
                    if (this.dose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.dose;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.rate;
                    }
                    return baseArray;
                }
                case 1506263709: {
                    Base[] baseArray;
                    if (this.maxDosePerPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.maxDosePerPeriod;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    this.text = this.castToString(value);
                    break;
                }
                case -1206718612: {
                    this.additionalInstructions = this.castToCodeableConcept(value);
                    break;
                }
                case -873664438: {
                    this.timing = this.castToTiming(value);
                    break;
                }
                case -1432923513: {
                    this.asNeeded = (Type)value;
                    break;
                }
                case 3530567: {
                    this.site = (Type)value;
                    break;
                }
                case 108704329: {
                    this.route = this.castToCodeableConcept(value);
                    break;
                }
                case -1077554975: {
                    this.method = this.castToCodeableConcept(value);
                    break;
                }
                case 3089437: {
                    this.dose = (Type)value;
                    break;
                }
                case 3493088: {
                    this.rate = (Type)value;
                    break;
                }
                case 1506263709: {
                    this.maxDosePerPeriod = this.castToRatio(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("additionalInstructions")) {
                this.additionalInstructions = this.castToCodeableConcept(value);
            } else if (name.equals("timing")) {
                this.timing = this.castToTiming(value);
            } else if (name.equals("asNeeded[x]")) {
                this.asNeeded = (Type)value;
            } else if (name.equals("site[x]")) {
                this.site = (Type)value;
            } else if (name.equals("route")) {
                this.route = this.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("dose[x]")) {
                this.dose = (Type)value;
            } else if (name.equals("rate[x]")) {
                this.rate = (Type)value;
            } else if (name.equals("maxDosePerPeriod")) {
                this.maxDosePerPeriod = this.castToRatio(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3556653: {
                    throw new FHIRException("Cannot make property text as it is not a complex type");
                }
                case -1206718612: {
                    return this.getAdditionalInstructions();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case -544329575: {
                    return this.getAsNeeded();
                }
                case 2099997657: {
                    return this.getSite();
                }
                case 108704329: {
                    return this.getRoute();
                }
                case -1077554975: {
                    return this.getMethod();
                }
                case 1843195715: {
                    return this.getDose();
                }
                case 983460768: {
                    return this.getRate();
                }
                case 1506263709: {
                    return this.getMaxDosePerPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationDispense.text");
            }
            if (name.equals("additionalInstructions")) {
                this.additionalInstructions = new CodeableConcept();
                return this.additionalInstructions;
            }
            if (name.equals("timing")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("asNeededBoolean")) {
                this.asNeeded = new BooleanType();
                return this.asNeeded;
            }
            if (name.equals("asNeededCodeableConcept")) {
                this.asNeeded = new CodeableConcept();
                return this.asNeeded;
            }
            if (name.equals("siteCodeableConcept")) {
                this.site = new CodeableConcept();
                return this.site;
            }
            if (name.equals("siteReference")) {
                this.site = new Reference();
                return this.site;
            }
            if (name.equals("route")) {
                this.route = new CodeableConcept();
                return this.route;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("doseRange")) {
                this.dose = new Range();
                return this.dose;
            }
            if (name.equals("doseSimpleQuantity")) {
                this.dose = new SimpleQuantity();
                return this.dose;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateRange")) {
                this.rate = new Range();
                return this.rate;
            }
            if (name.equals("maxDosePerPeriod")) {
                this.maxDosePerPeriod = new Ratio();
                return this.maxDosePerPeriod;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationDispenseDosageInstructionComponent copy() {
            MedicationDispenseDosageInstructionComponent dst = new MedicationDispenseDosageInstructionComponent();
            this.copyValues(dst);
            dst.text = this.text == null ? null : this.text.copy();
            dst.additionalInstructions = this.additionalInstructions == null ? null : this.additionalInstructions.copy();
            dst.timing = this.timing == null ? null : this.timing.copy();
            dst.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
            dst.site = this.site == null ? null : this.site.copy();
            dst.route = this.route == null ? null : this.route.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.dose = this.dose == null ? null : this.dose.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            dst.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationDispenseDosageInstructionComponent)) {
                return false;
            }
            MedicationDispenseDosageInstructionComponent o = (MedicationDispenseDosageInstructionComponent)other;
            return MedicationDispenseDosageInstructionComponent.compareDeep(this.text, o.text, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.additionalInstructions, o.additionalInstructions, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.timing, o.timing, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.asNeeded, o.asNeeded, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.site, o.site, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.route, o.route, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.method, o.method, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.dose, o.dose, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.rate, o.rate, true) && MedicationDispenseDosageInstructionComponent.compareDeep(this.maxDosePerPeriod, o.maxDosePerPeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationDispenseDosageInstructionComponent)) {
                return false;
            }
            MedicationDispenseDosageInstructionComponent o = (MedicationDispenseDosageInstructionComponent)other;
            return MedicationDispenseDosageInstructionComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.text != null && !this.text.isEmpty() || this.additionalInstructions != null && !this.additionalInstructions.isEmpty() || this.timing != null && !this.timing.isEmpty() || this.asNeeded != null && !this.asNeeded.isEmpty() || this.site != null && !this.site.isEmpty() || this.route != null && !this.route.isEmpty() || this.method != null && !this.method.isEmpty() || this.dose != null && !this.dose.isEmpty() || this.rate != null && !this.rate.isEmpty() || this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MedicationDispense.dosageInstruction";
        }
    }

    public static class MedicationDispenseStatusEnumFactory
    implements EnumFactory<MedicationDispenseStatus> {
        @Override
        public MedicationDispenseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return MedicationDispenseStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationDispenseStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return MedicationDispenseStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationDispenseStatus.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationDispenseStatus.STOPPED;
            }
            throw new IllegalArgumentException("Unknown MedicationDispenseStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationDispenseStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatus>(this, MedicationDispenseStatus.INPROGRESS);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatus>(this, MedicationDispenseStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatus>(this, MedicationDispenseStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatus>(this, MedicationDispenseStatus.ENTEREDINERROR);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationDispenseStatus>(this, MedicationDispenseStatus.STOPPED);
            }
            throw new FHIRException("Unknown MedicationDispenseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationDispenseStatus code) {
            if (code == MedicationDispenseStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == MedicationDispenseStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationDispenseStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationDispenseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationDispenseStatus.STOPPED) {
                return "stopped";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationDispenseStatus code) {
            return code.getSystem();
        }
    }

    public static enum MedicationDispenseStatus {
        INPROGRESS,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        NULL;


        public static MedicationDispenseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            throw new FHIRException("Unknown MedicationDispenseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/medication-dispense-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/medication-dispense-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/medication-dispense-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-dispense-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/medication-dispense-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The dispense has started but has not yet completed.";
                }
                case ONHOLD: {
                    return "Actions implied by the administration have been temporarily halted, but are expected to continue later. May also be called \"suspended\"";
                }
                case COMPLETED: {
                    return "All actions that are implied by the dispense have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The dispense was entered in error and therefore nullified.";
                }
                case STOPPED: {
                    return "Actions implied by the dispense have been permanently halted, before all of them occurred.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in-Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
            }
            return "?";
        }
    }
}

