/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImplementationGuide", profile="http://hl7.org/fhir/Profile/ImplementationGuide")
public class ImplementationGuide
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Absolute URL used to reference this Implementation Guide", formalDefinition="An absolute URL that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this implementation guide is (or will be) published.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id for this version of the Implementation Guide", formalDefinition="The identifier that is used to identify this version of the Implementation Guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Implementation Guide author manually.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this Implementation Guide", formalDefinition="A free text natural language name identifying the Implementation Guide.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the Implementation Guide.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This Implementation Guide was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the implementation guide.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<ImplementationGuideContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for this version of the Implementation Guide", formalDefinition="The date this version of the implementation guide was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the Implementation Guide", formalDefinition="A free text natural language description of the Implementation Guide and its use.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The implementation guide is intended to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of implementation guides. The most common use of this element is to represent the country / jurisdiction for which this implementation guide was defined.")
    protected List<CodeableConcept> useContext;
    @Child(name="copyright", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.")
    protected StringType copyright;
    @Child(name="fhirVersion", type={IdType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version this Implementation Guide targets", formalDefinition="The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 1.4.0 for this version.")
    protected IdType fhirVersion;
    @Child(name="dependency", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Another Implementation guide this depends on", formalDefinition="Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.")
    protected List<ImplementationGuideDependencyComponent> dependency;
    @Child(name="package", type={}, order=13, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Group of resources as used in .page.package", formalDefinition="A logical group of resources. Logical groups can be used when building pages.")
    protected List<ImplementationGuidePackageComponent> package_;
    @Child(name="global", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Profiles that apply globally", formalDefinition="A set of profiles that all resources covered by this implementation guide must conform to.")
    protected List<ImplementationGuideGlobalComponent> global;
    @Child(name="binary", type={UriType.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image, css, script, etc.", formalDefinition="A binary file that is included in the  implementation guide when it is published.")
    protected List<UriType> binary;
    @Child(name="page", type={}, order=16, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Page/Section in the Guide", formalDefinition="A page / section in the implementation guide. The root page is the implementation guide home page.")
    protected ImplementationGuidePageComponent page;
    private static final long serialVersionUID = 1150122415L;
    @SearchParamDefinition(name="dependency", path="ImplementationGuide.dependency.uri", description="Where to find dependency", type="uri")
    public static final String SP_DEPENDENCY = "dependency";
    public static final UriClientParam DEPENDENCY = new UriClientParam("dependency");
    @SearchParamDefinition(name="status", path="ImplementationGuide.status", description="The current status of the implementation guide", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="ImplementationGuide.description", description="Text search in the description of the implementation guide", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="name", path="ImplementationGuide.name", description="Name of the implementation guide", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="resource", path="ImplementationGuide.package.resource.source", description="Location of the resource", type="reference")
    public static final String SP_RESOURCE = "resource";
    public static final ReferenceClientParam RESOURCE = new ReferenceClientParam("resource");
    public static final Include INCLUDE_RESOURCE = new Include("ImplementationGuide:resource").toLocked();
    @SearchParamDefinition(name="context", path="ImplementationGuide.useContext", description="A use context assigned to the structure", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="experimental", path="ImplementationGuide.experimental", description="If for testing purposes, not real usage", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="date", path="ImplementationGuide.date", description="The implementation guide publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="url", path="ImplementationGuide.url", description="Absolute URL used to reference this Implementation Guide", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="publisher", path="ImplementationGuide.publisher", description="Name of the publisher of the implementation guide", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="version", path="ImplementationGuide.version", description="The version identifier of the implementation guide", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ImplementationGuide() {
    }

    public ImplementationGuide(UriType url, StringType name, Enumeration<Enumerations.ConformanceResourceStatus> status, ImplementationGuidePageComponent page) {
        this.url = url;
        this.name = name;
        this.status = status;
        this.page = page;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ImplementationGuide setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ImplementationGuide setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ImplementationGuide setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ImplementationGuide setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ImplementationGuide setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ImplementationGuide setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ImplementationGuide setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public ImplementationGuide setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public ImplementationGuide setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public ImplementationGuide setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public ImplementationGuide setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public ImplementationGuide setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ImplementationGuideContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ImplementationGuideContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ImplementationGuideContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideContactComponent addContact() {
        ImplementationGuideContactComponent t = new ImplementationGuideContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ImplementationGuideContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public ImplementationGuide addContact(ImplementationGuideContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ImplementationGuideContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ImplementationGuide setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ImplementationGuide setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImplementationGuide setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImplementationGuide setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public ImplementationGuide addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ImplementationGuide setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ImplementationGuide setCopyright(String value) {
        if (Utilities.noString(value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public IdType getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new IdType();
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public ImplementationGuide setFhirVersionElement(IdType value) {
        this.fhirVersion = value;
        return this;
    }

    public String getFhirVersion() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public ImplementationGuide setFhirVersion(String value) {
        if (Utilities.noString(value)) {
            this.fhirVersion = null;
        } else {
            if (this.fhirVersion == null) {
                this.fhirVersion = new IdType();
            }
            this.fhirVersion.setValue(value);
        }
        return this;
    }

    public List<ImplementationGuideDependencyComponent> getDependency() {
        if (this.dependency == null) {
            this.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
        }
        return this.dependency;
    }

    public boolean hasDependency() {
        if (this.dependency == null) {
            return false;
        }
        for (ImplementationGuideDependencyComponent item : this.dependency) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideDependencyComponent addDependency() {
        ImplementationGuideDependencyComponent t = new ImplementationGuideDependencyComponent();
        if (this.dependency == null) {
            this.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
        }
        this.dependency.add(t);
        return t;
    }

    public ImplementationGuide addDependency(ImplementationGuideDependencyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dependency == null) {
            this.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
        }
        this.dependency.add(t);
        return this;
    }

    public List<ImplementationGuidePackageComponent> getPackage() {
        if (this.package_ == null) {
            this.package_ = new ArrayList<ImplementationGuidePackageComponent>();
        }
        return this.package_;
    }

    public boolean hasPackage() {
        if (this.package_ == null) {
            return false;
        }
        for (ImplementationGuidePackageComponent item : this.package_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuidePackageComponent addPackage() {
        ImplementationGuidePackageComponent t = new ImplementationGuidePackageComponent();
        if (this.package_ == null) {
            this.package_ = new ArrayList<ImplementationGuidePackageComponent>();
        }
        this.package_.add(t);
        return t;
    }

    public ImplementationGuide addPackage(ImplementationGuidePackageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.package_ == null) {
            this.package_ = new ArrayList<ImplementationGuidePackageComponent>();
        }
        this.package_.add(t);
        return this;
    }

    public List<ImplementationGuideGlobalComponent> getGlobal() {
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        return this.global;
    }

    public boolean hasGlobal() {
        if (this.global == null) {
            return false;
        }
        for (ImplementationGuideGlobalComponent item : this.global) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideGlobalComponent addGlobal() {
        ImplementationGuideGlobalComponent t = new ImplementationGuideGlobalComponent();
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return t;
    }

    public ImplementationGuide addGlobal(ImplementationGuideGlobalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return this;
    }

    public List<UriType> getBinary() {
        if (this.binary == null) {
            this.binary = new ArrayList<UriType>();
        }
        return this.binary;
    }

    public boolean hasBinary() {
        if (this.binary == null) {
            return false;
        }
        for (UriType item : this.binary) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addBinaryElement() {
        UriType t = new UriType();
        if (this.binary == null) {
            this.binary = new ArrayList<UriType>();
        }
        this.binary.add(t);
        return t;
    }

    public ImplementationGuide addBinary(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.binary == null) {
            this.binary = new ArrayList<UriType>();
        }
        this.binary.add(t);
        return this;
    }

    public boolean hasBinary(String value) {
        if (this.binary == null) {
            return false;
        }
        for (UriType v : this.binary) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuidePageComponent getPage() {
        if (this.page == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.page");
            }
            if (Configuration.doAutoCreate()) {
                this.page = new ImplementationGuidePageComponent();
            }
        }
        return this.page;
    }

    public boolean hasPage() {
        return this.page != null && !this.page.isEmpty();
    }

    public ImplementationGuide setPage(ImplementationGuidePageComponent value) {
        this.page = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this implementation guide is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the Implementation Guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Implementation Guide author manually.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name identifying the Implementation Guide.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the Implementation Guide.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_EXPERIMENTAL, "boolean", "This Implementation Guide was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the implementation guide.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date this version of the implementation guide was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the Implementation Guide and its use.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of implementation guides. The most common use of this element is to represent the country / jurisdiction for which this implementation guide was defined.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the details of the constraints and mappings.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 1.4.0 for this version.", 0, Integer.MAX_VALUE, this.fhirVersion));
        childrenList.add(new Property(SP_DEPENDENCY, "", "Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.", 0, Integer.MAX_VALUE, this.dependency));
        childrenList.add(new Property("package", "", "A logical group of resources. Logical groups can be used when building pages.", 0, Integer.MAX_VALUE, this.package_));
        childrenList.add(new Property("global", "", "A set of profiles that all resources covered by this implementation guide must conform to.", 0, Integer.MAX_VALUE, this.global));
        childrenList.add(new Property("binary", "uri", "A binary file that is included in the  implementation guide when it is published.", 0, Integer.MAX_VALUE, this.binary));
        childrenList.add(new Property("page", "", "A page / section in the implementation guide. The root page is the implementation guide home page.", 0, Integer.MAX_VALUE, this.page));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.copyright;
                }
                return baseArray;
            }
            case 461006061: {
                Base[] baseArray;
                if (this.fhirVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.fhirVersion;
                }
                return baseArray;
            }
            case -26291381: {
                return this.dependency == null ? new Base[]{} : this.dependency.toArray(new Base[this.dependency.size()]);
            }
            case -807062458: {
                return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
            }
            case -1243020381: {
                return this.global == null ? new Base[]{} : this.global.toArray(new Base[this.global.size()]);
            }
            case -1388966911: {
                return this.binary == null ? new Base[]{} : this.binary.toArray(new Base[this.binary.size()]);
            }
            case 3433103: {
                Base[] baseArray;
                if (this.page == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.page;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 3373707: {
                this.name = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
                break;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                break;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                break;
            }
            case 951526432: {
                this.getContact().add((ImplementationGuideContactComponent)value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -669707736: {
                this.getUseContext().add(this.castToCodeableConcept(value));
                break;
            }
            case 1522889671: {
                this.copyright = this.castToString(value);
                break;
            }
            case 461006061: {
                this.fhirVersion = this.castToId(value);
                break;
            }
            case -26291381: {
                this.getDependency().add((ImplementationGuideDependencyComponent)value);
                break;
            }
            case -807062458: {
                this.getPackage().add((ImplementationGuidePackageComponent)value);
                break;
            }
            case -1243020381: {
                this.getGlobal().add((ImplementationGuideGlobalComponent)value);
                break;
            }
            case -1388966911: {
                this.getBinary().add(this.castToUri(value));
                break;
            }
            case 3433103: {
                this.page = (ImplementationGuidePageComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((ImplementationGuideContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("fhirVersion")) {
            this.fhirVersion = this.castToId(value);
        } else if (name.equals(SP_DEPENDENCY)) {
            this.getDependency().add((ImplementationGuideDependencyComponent)value);
        } else if (name.equals("package")) {
            this.getPackage().add((ImplementationGuidePackageComponent)value);
        } else if (name.equals("global")) {
            this.getGlobal().add((ImplementationGuideGlobalComponent)value);
        } else if (name.equals("binary")) {
            this.getBinary().add(this.castToUri(value));
        } else if (name.equals("page")) {
            this.page = (ImplementationGuidePageComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -404562712: {
                throw new FHIRException("Cannot make property experimental as it is not a complex type");
            }
            case 1447404028: {
                throw new FHIRException("Cannot make property publisher as it is not a complex type");
            }
            case 951526432: {
                return this.addContact();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -669707736: {
                return this.addUseContext();
            }
            case 1522889671: {
                throw new FHIRException("Cannot make property copyright as it is not a complex type");
            }
            case 461006061: {
                throw new FHIRException("Cannot make property fhirVersion as it is not a complex type");
            }
            case -26291381: {
                return this.addDependency();
            }
            case -807062458: {
                return this.addPackage();
            }
            case -1243020381: {
                return this.addGlobal();
            }
            case -1388966911: {
                throw new FHIRException("Cannot make property binary as it is not a complex type");
            }
            case 3433103: {
                return this.getPage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.copyright");
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.fhirVersion");
        }
        if (name.equals(SP_DEPENDENCY)) {
            return this.addDependency();
        }
        if (name.equals("package")) {
            return this.addPackage();
        }
        if (name.equals("global")) {
            return this.addGlobal();
        }
        if (name.equals("binary")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.binary");
        }
        if (name.equals("page")) {
            this.page = new ImplementationGuidePageComponent();
            return this.page;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImplementationGuide";
    }

    @Override
    public ImplementationGuide copy() {
        ImplementationGuide dst = new ImplementationGuide();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ImplementationGuideContactComponent>();
            for (ImplementationGuideContactComponent implementationGuideContactComponent : this.contact) {
                dst.contact.add(implementationGuideContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        IdType idType = dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        if (this.dependency != null) {
            dst.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
            for (ImplementationGuideDependencyComponent implementationGuideDependencyComponent : this.dependency) {
                dst.dependency.add(implementationGuideDependencyComponent.copy());
            }
        }
        if (this.package_ != null) {
            dst.package_ = new ArrayList<ImplementationGuidePackageComponent>();
            for (ImplementationGuidePackageComponent implementationGuidePackageComponent : this.package_) {
                dst.package_.add(implementationGuidePackageComponent.copy());
            }
        }
        if (this.global != null) {
            dst.global = new ArrayList<ImplementationGuideGlobalComponent>();
            for (ImplementationGuideGlobalComponent implementationGuideGlobalComponent : this.global) {
                dst.global.add(implementationGuideGlobalComponent.copy());
            }
        }
        if (this.binary != null) {
            dst.binary = new ArrayList<UriType>();
            for (UriType uriType : this.binary) {
                dst.binary.add(uriType.copy());
            }
        }
        dst.page = this.page == null ? null : this.page.copy();
        return dst;
    }

    protected ImplementationGuide typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other;
        return ImplementationGuide.compareDeep(this.url, o.url, true) && ImplementationGuide.compareDeep(this.version, o.version, true) && ImplementationGuide.compareDeep(this.name, o.name, true) && ImplementationGuide.compareDeep(this.status, o.status, true) && ImplementationGuide.compareDeep(this.experimental, o.experimental, true) && ImplementationGuide.compareDeep(this.publisher, o.publisher, true) && ImplementationGuide.compareDeep(this.contact, o.contact, true) && ImplementationGuide.compareDeep(this.date, o.date, true) && ImplementationGuide.compareDeep(this.description, o.description, true) && ImplementationGuide.compareDeep(this.useContext, o.useContext, true) && ImplementationGuide.compareDeep(this.copyright, o.copyright, true) && ImplementationGuide.compareDeep(this.fhirVersion, o.fhirVersion, true) && ImplementationGuide.compareDeep(this.dependency, o.dependency, true) && ImplementationGuide.compareDeep(this.package_, o.package_, true) && ImplementationGuide.compareDeep(this.global, o.global, true) && ImplementationGuide.compareDeep(this.binary, o.binary, true) && ImplementationGuide.compareDeep(this.page, o.page, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other;
        return ImplementationGuide.compareValues(this.url, o.url, true) && ImplementationGuide.compareValues(this.version, o.version, true) && ImplementationGuide.compareValues(this.name, o.name, true) && ImplementationGuide.compareValues(this.status, o.status, true) && ImplementationGuide.compareValues(this.experimental, o.experimental, true) && ImplementationGuide.compareValues(this.publisher, o.publisher, true) && ImplementationGuide.compareValues(this.date, o.date, true) && ImplementationGuide.compareValues(this.description, o.description, true) && ImplementationGuide.compareValues(this.copyright, o.copyright, true) && ImplementationGuide.compareValues(this.fhirVersion, o.fhirVersion, true) && ImplementationGuide.compareValues(this.binary, o.binary, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.fhirVersion != null && !this.fhirVersion.isEmpty() || this.dependency != null && !this.dependency.isEmpty() || this.package_ != null && !this.package_.isEmpty() || this.global != null && !this.global.isEmpty() || this.binary != null && !this.binary.isEmpty() || this.page != null && !this.page.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImplementationGuide;
    }

    @Block
    public static class ImplementationGuidePageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where to find that page", formalDefinition="The source address for the page.")
        protected UriType source;
        @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Short name shown for navigational assistance", formalDefinition="A short name used to represent this page in navigational structures such as table of contents, bread crumbs, etc.")
        protected StringType name;
        @Child(name="kind", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="page | example | list | include | directory | dictionary | toc | resource", formalDefinition="The kind of page that this is. Some pages are autogenerated (list, example), and other kinds are of interest so that tools can navigate the user to the page of interest.")
        protected Enumeration<GuidePageKind> kind;
        @Child(name="type", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of resource to include in the list", formalDefinition="For constructed pages, what kind of resources to include in the list.")
        protected List<CodeType> type;
        @Child(name="package", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Name of package to include", formalDefinition="For constructed pages, a list of packages to include in the page (or else empty for everything).")
        protected List<StringType> package_;
        @Child(name="format", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Format of the page (e.g. html, markdown, etc.)", formalDefinition="The format of the page.")
        protected CodeType format;
        @Child(name="page", type={ImplementationGuidePageComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Pages / Sections", formalDefinition="Nested Pages/Sections under this page.")
        protected List<ImplementationGuidePageComponent> page;
        private static final long serialVersionUID = -1620890043L;

        public ImplementationGuidePageComponent() {
        }

        public ImplementationGuidePageComponent(UriType source, StringType name, Enumeration<GuidePageKind> kind) {
            this.source = source;
            this.name = name;
            this.kind = kind;
        }

        public UriType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new UriType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ImplementationGuidePageComponent setSourceElement(UriType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ImplementationGuidePageComponent setSource(String value) {
            if (this.source == null) {
                this.source = new UriType();
            }
            this.source.setValue(value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuidePageComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuidePageComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<GuidePageKind> getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new Enumeration<GuidePageKind>(new GuidePageKindEnumFactory());
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public ImplementationGuidePageComponent setKindElement(Enumeration<GuidePageKind> value) {
            this.kind = value;
            return this;
        }

        public GuidePageKind getKind() {
            return this.kind == null ? null : (GuidePageKind)((Object)this.kind.getValue());
        }

        public ImplementationGuidePageComponent setKind(GuidePageKind value) {
            if (this.kind == null) {
                this.kind = new Enumeration<GuidePageKind>(new GuidePageKindEnumFactory());
            }
            this.kind.setValue((Object)value);
            return this;
        }

        public List<CodeType> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeType>();
            }
            return this.type;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeType item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addTypeElement() {
            CodeType t = new CodeType();
            if (this.type == null) {
                this.type = new ArrayList<CodeType>();
            }
            this.type.add(t);
            return t;
        }

        public ImplementationGuidePageComponent addType(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.type == null) {
                this.type = new ArrayList<CodeType>();
            }
            this.type.add(t);
            return this;
        }

        public boolean hasType(String value) {
            if (this.type == null) {
                return false;
            }
            for (CodeType v : this.type) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getPackage() {
            if (this.package_ == null) {
                this.package_ = new ArrayList<StringType>();
            }
            return this.package_;
        }

        public boolean hasPackage() {
            if (this.package_ == null) {
                return false;
            }
            for (StringType item : this.package_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPackageElement() {
            StringType t = new StringType();
            if (this.package_ == null) {
                this.package_ = new ArrayList<StringType>();
            }
            this.package_.add(t);
            return t;
        }

        public ImplementationGuidePageComponent addPackage(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.package_ == null) {
                this.package_ = new ArrayList<StringType>();
            }
            this.package_.add(t);
            return this;
        }

        public boolean hasPackage(String value) {
            if (this.package_ == null) {
                return false;
            }
            for (StringType v : this.package_) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeType getFormatElement() {
            if (this.format == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.format");
                }
                if (Configuration.doAutoCreate()) {
                    this.format = new CodeType();
                }
            }
            return this.format;
        }

        public boolean hasFormatElement() {
            return this.format != null && !this.format.isEmpty();
        }

        public boolean hasFormat() {
            return this.format != null && !this.format.isEmpty();
        }

        public ImplementationGuidePageComponent setFormatElement(CodeType value) {
            this.format = value;
            return this;
        }

        public String getFormat() {
            return this.format == null ? null : (String)this.format.getValue();
        }

        public ImplementationGuidePageComponent setFormat(String value) {
            if (Utilities.noString(value)) {
                this.format = null;
            } else {
                if (this.format == null) {
                    this.format = new CodeType();
                }
                this.format.setValue(value);
            }
            return this;
        }

        public List<ImplementationGuidePageComponent> getPage() {
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuidePageComponent>();
            }
            return this.page;
        }

        public boolean hasPage() {
            if (this.page == null) {
                return false;
            }
            for (ImplementationGuidePageComponent item : this.page) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuidePageComponent addPage() {
            ImplementationGuidePageComponent t = new ImplementationGuidePageComponent();
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuidePageComponent>();
            }
            this.page.add(t);
            return t;
        }

        public ImplementationGuidePageComponent addPage(ImplementationGuidePageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuidePageComponent>();
            }
            this.page.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("source", "uri", "The source address for the page.", 0, Integer.MAX_VALUE, this.source));
            childrenList.add(new Property(ImplementationGuide.SP_NAME, "string", "A short name used to represent this page in navigational structures such as table of contents, bread crumbs, etc.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("kind", "code", "The kind of page that this is. Some pages are autogenerated (list, example), and other kinds are of interest so that tools can navigate the user to the page of interest.", 0, Integer.MAX_VALUE, this.kind));
            childrenList.add(new Property("type", "code", "For constructed pages, what kind of resources to include in the list.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("package", "string", "For constructed pages, a list of packages to include in the page (or else empty for everything).", 0, Integer.MAX_VALUE, this.package_));
            childrenList.add(new Property("format", "code", "The format of the page.", 0, Integer.MAX_VALUE, this.format));
            childrenList.add(new Property("page", "@ImplementationGuide.page", "Nested Pages/Sections under this page.", 0, Integer.MAX_VALUE, this.page));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.kind;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -807062458: {
                    return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
                }
                case -1268779017: {
                    Base[] baseArray;
                    if (this.format == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.format;
                    }
                    return baseArray;
                }
                case 3433103: {
                    return this.page == null ? new Base[]{} : this.page.toArray(new Base[this.page.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = this.castToUri(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case 3292052: {
                    this.kind = new GuidePageKindEnumFactory().fromType(value);
                    break;
                }
                case 3575610: {
                    this.getType().add(this.castToCode(value));
                    break;
                }
                case -807062458: {
                    this.getPackage().add(this.castToString(value));
                    break;
                }
                case -1268779017: {
                    this.format = this.castToCode(value);
                    break;
                }
                case 3433103: {
                    this.getPage().add((ImplementationGuidePageComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("source")) {
                this.source = this.castToUri(value);
            } else if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("kind")) {
                this.kind = new GuidePageKindEnumFactory().fromType(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCode(value));
            } else if (name.equals("package")) {
                this.getPackage().add(this.castToString(value));
            } else if (name.equals("format")) {
                this.format = this.castToCode(value);
            } else if (name.equals("page")) {
                this.getPage().add((ImplementationGuidePageComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    throw new FHIRException("Cannot make property source as it is not a complex type");
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 3292052: {
                    throw new FHIRException("Cannot make property kind as it is not a complex type");
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case -807062458: {
                    throw new FHIRException("Cannot make property package as it is not a complex type");
                }
                case -1268779017: {
                    throw new FHIRException("Cannot make property format as it is not a complex type");
                }
                case 3433103: {
                    return this.addPage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.source");
            }
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.kind");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.type");
            }
            if (name.equals("package")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.package");
            }
            if (name.equals("format")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.format");
            }
            if (name.equals("page")) {
                return this.addPage();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuidePageComponent copy() {
            ImplementationGuidePageComponent dst = new ImplementationGuidePageComponent();
            this.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            dst.name = this.name == null ? null : this.name.copy();
            Enumeration<GuidePageKind> enumeration = dst.kind = this.kind == null ? null : this.kind.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeType>();
                for (CodeType codeType : this.type) {
                    dst.type.add(codeType.copy());
                }
            }
            if (this.package_ != null) {
                dst.package_ = new ArrayList<StringType>();
                for (StringType stringType : this.package_) {
                    dst.package_.add(stringType.copy());
                }
            }
            CodeType codeType = dst.format = this.format == null ? null : this.format.copy();
            if (this.page != null) {
                dst.page = new ArrayList<ImplementationGuidePageComponent>();
                for (ImplementationGuidePageComponent implementationGuidePageComponent : this.page) {
                    dst.page.add(implementationGuidePageComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuidePageComponent)) {
                return false;
            }
            ImplementationGuidePageComponent o = (ImplementationGuidePageComponent)other;
            return ImplementationGuidePageComponent.compareDeep(this.source, o.source, true) && ImplementationGuidePageComponent.compareDeep(this.name, o.name, true) && ImplementationGuidePageComponent.compareDeep(this.kind, o.kind, true) && ImplementationGuidePageComponent.compareDeep(this.type, o.type, true) && ImplementationGuidePageComponent.compareDeep(this.package_, o.package_, true) && ImplementationGuidePageComponent.compareDeep(this.format, o.format, true) && ImplementationGuidePageComponent.compareDeep(this.page, o.page, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuidePageComponent)) {
                return false;
            }
            ImplementationGuidePageComponent o = (ImplementationGuidePageComponent)other;
            return ImplementationGuidePageComponent.compareValues(this.source, o.source, true) && ImplementationGuidePageComponent.compareValues(this.name, o.name, true) && ImplementationGuidePageComponent.compareValues(this.kind, o.kind, true) && ImplementationGuidePageComponent.compareValues(this.type, o.type, true) && ImplementationGuidePageComponent.compareValues(this.package_, o.package_, true) && ImplementationGuidePageComponent.compareValues(this.format, o.format, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.source != null && !this.source.isEmpty() || this.name != null && !this.name.isEmpty() || this.kind != null && !this.kind.isEmpty() || this.type != null && !this.type.isEmpty() || this.package_ != null && !this.package_.isEmpty() || this.format != null && !this.format.isEmpty() || this.page != null && !this.page.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.page";
        }
    }

    @Block
    public static class ImplementationGuideGlobalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type this profiles applies to", formalDefinition="The type of resource that all instances must conform to.")
        protected CodeType type;
        @Child(name="profile", type={StructureDefinition.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Profile that all resources must conform to", formalDefinition="A reference to the profile that all instances must conform to.")
        protected Reference profile;
        protected StructureDefinition profileTarget;
        private static final long serialVersionUID = 2011731959L;

        public ImplementationGuideGlobalComponent() {
        }

        public ImplementationGuideGlobalComponent(CodeType type, Reference profile) {
            this.type = type;
            this.profile = profile;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ImplementationGuideGlobalComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ImplementationGuideGlobalComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public Reference getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Reference();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ImplementationGuideGlobalComponent setProfile(Reference value) {
            this.profile = value;
            return this;
        }

        public StructureDefinition getProfileTarget() {
            if (this.profileTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profileTarget = new StructureDefinition();
                }
            }
            return this.profileTarget;
        }

        public ImplementationGuideGlobalComponent setProfileTarget(StructureDefinition value) {
            this.profileTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "The type of resource that all instances must conform to.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("profile", "Reference(StructureDefinition)", "A reference to the profile that all instances must conform to.", 0, Integer.MAX_VALUE, this.profile));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    break;
                }
                case -309425751: {
                    this.profile = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case -309425751: {
                    return this.getProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.type");
            }
            if (name.equals("profile")) {
                this.profile = new Reference();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideGlobalComponent copy() {
            ImplementationGuideGlobalComponent dst = new ImplementationGuideGlobalComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other;
            return ImplementationGuideGlobalComponent.compareDeep(this.type, o.type, true) && ImplementationGuideGlobalComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other;
            return ImplementationGuideGlobalComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.profile != null && !this.profile.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.global";
        }
    }

    @Block
    public static class ImplementationGuidePackageResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="example", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If not an example, has it's normal meaning", formalDefinition="Whether a resource is included in the guide as part of the rules defined by the guide, or just as an example of a resource that conforms to the rules and/or help implementers understand the intent of the guide.")
        protected BooleanType example;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human Name for the resource", formalDefinition="A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason why included in guide", formalDefinition="A description of the reason that a resource has been included in the implementation guide.")
        protected StringType description;
        @Child(name="acronym", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short code to identify the resource", formalDefinition="A short code that may be used to identify the resource throughout the implementation guide.")
        protected StringType acronym;
        @Child(name="source", type={UriType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Location of the resource", formalDefinition="Where this resource is found.")
        protected Type source;
        @Child(name="exampleFor", type={StructureDefinition.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource this is an example of (if applicable)", formalDefinition="Another resource that this resource is an example for. This is mostly used for resources that are included as examples of StructureDefinitions.")
        protected Reference exampleFor;
        protected StructureDefinition exampleForTarget;
        private static final long serialVersionUID = 2085404852L;

        public ImplementationGuidePackageResourceComponent() {
        }

        public ImplementationGuidePackageResourceComponent(BooleanType example, Type source) {
            this.example = example;
            this.source = source;
        }

        public BooleanType getExampleElement() {
            if (this.example == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.example");
                }
                if (Configuration.doAutoCreate()) {
                    this.example = new BooleanType();
                }
            }
            return this.example;
        }

        public boolean hasExampleElement() {
            return this.example != null && !this.example.isEmpty();
        }

        public boolean hasExample() {
            return this.example != null && !this.example.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setExampleElement(BooleanType value) {
            this.example = value;
            return this;
        }

        public boolean getExample() {
            return this.example == null || this.example.isEmpty() ? false : (Boolean)this.example.getValue();
        }

        public ImplementationGuidePackageResourceComponent setExample(boolean value) {
            if (this.example == null) {
                this.example = new BooleanType();
            }
            this.example.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuidePackageResourceComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuidePackageResourceComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getAcronymElement() {
            if (this.acronym == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.acronym");
                }
                if (Configuration.doAutoCreate()) {
                    this.acronym = new StringType();
                }
            }
            return this.acronym;
        }

        public boolean hasAcronymElement() {
            return this.acronym != null && !this.acronym.isEmpty();
        }

        public boolean hasAcronym() {
            return this.acronym != null && !this.acronym.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setAcronymElement(StringType value) {
            this.acronym = value;
            return this;
        }

        public String getAcronym() {
            return this.acronym == null ? null : (String)this.acronym.getValue();
        }

        public ImplementationGuidePackageResourceComponent setAcronym(String value) {
            if (Utilities.noString(value)) {
                this.acronym = null;
            } else {
                if (this.acronym == null) {
                    this.acronym = new StringType();
                }
                this.acronym.setValue(value);
            }
            return this;
        }

        public Type getSource() {
            return this.source;
        }

        public UriType getSourceUriType() throws FHIRException {
            if (!(this.source instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (UriType)this.source;
        }

        public boolean hasSourceUriType() {
            return this.source instanceof UriType;
        }

        public Reference getSourceReference() throws FHIRException {
            if (!(this.source instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (Reference)this.source;
        }

        public boolean hasSourceReference() {
            return this.source instanceof Reference;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setSource(Type value) {
            this.source = value;
            return this;
        }

        public Reference getExampleFor() {
            if (this.exampleFor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.exampleFor");
                }
                if (Configuration.doAutoCreate()) {
                    this.exampleFor = new Reference();
                }
            }
            return this.exampleFor;
        }

        public boolean hasExampleFor() {
            return this.exampleFor != null && !this.exampleFor.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setExampleFor(Reference value) {
            this.exampleFor = value;
            return this;
        }

        public StructureDefinition getExampleForTarget() {
            if (this.exampleForTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.exampleFor");
                }
                if (Configuration.doAutoCreate()) {
                    this.exampleForTarget = new StructureDefinition();
                }
            }
            return this.exampleForTarget;
        }

        public ImplementationGuidePackageResourceComponent setExampleForTarget(StructureDefinition value) {
            this.exampleForTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("example", "boolean", "Whether a resource is included in the guide as part of the rules defined by the guide, or just as an example of a resource that conforms to the rules and/or help implementers understand the intent of the guide.", 0, Integer.MAX_VALUE, this.example));
            childrenList.add(new Property(ImplementationGuide.SP_NAME, "string", "A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "A description of the reason that a resource has been included in the implementation guide.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("acronym", "string", "A short code that may be used to identify the resource throughout the implementation guide.", 0, Integer.MAX_VALUE, this.acronym));
            childrenList.add(new Property("source[x]", "uri|Reference(Any)", "Where this resource is found.", 0, Integer.MAX_VALUE, this.source));
            childrenList.add(new Property("exampleFor", "Reference(StructureDefinition)", "Another resource that this resource is an example for. This is mostly used for resources that are included as examples of StructureDefinitions.", 0, Integer.MAX_VALUE, this.exampleFor));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1322970774: {
                    Base[] baseArray;
                    if (this.example == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.example;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -1163472445: {
                    Base[] baseArray;
                    if (this.acronym == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.acronym;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.source;
                    }
                    return baseArray;
                }
                case -2002349313: {
                    Base[] baseArray;
                    if (this.exampleFor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.exampleFor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1322970774: {
                    this.example = this.castToBoolean(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -1163472445: {
                    this.acronym = this.castToString(value);
                    break;
                }
                case -896505829: {
                    this.source = (Type)value;
                    break;
                }
                case -2002349313: {
                    this.exampleFor = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("example")) {
                this.example = this.castToBoolean(value);
            } else if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("acronym")) {
                this.acronym = this.castToString(value);
            } else if (name.equals("source[x]")) {
                this.source = (Type)value;
            } else if (name.equals("exampleFor")) {
                this.exampleFor = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1322970774: {
                    throw new FHIRException("Cannot make property example as it is not a complex type");
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -1163472445: {
                    throw new FHIRException("Cannot make property acronym as it is not a complex type");
                }
                case -1698413947: {
                    return this.getSource();
                }
                case -2002349313: {
                    return this.getExampleFor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("example")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.example");
            }
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
            }
            if (name.equals("acronym")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.acronym");
            }
            if (name.equals("sourceUri")) {
                this.source = new UriType();
                return this.source;
            }
            if (name.equals("sourceReference")) {
                this.source = new Reference();
                return this.source;
            }
            if (name.equals("exampleFor")) {
                this.exampleFor = new Reference();
                return this.exampleFor;
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuidePackageResourceComponent copy() {
            ImplementationGuidePackageResourceComponent dst = new ImplementationGuidePackageResourceComponent();
            this.copyValues(dst);
            dst.example = this.example == null ? null : this.example.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.acronym = this.acronym == null ? null : this.acronym.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.exampleFor = this.exampleFor == null ? null : this.exampleFor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuidePackageResourceComponent)) {
                return false;
            }
            ImplementationGuidePackageResourceComponent o = (ImplementationGuidePackageResourceComponent)other;
            return ImplementationGuidePackageResourceComponent.compareDeep(this.example, o.example, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.name, o.name, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.description, o.description, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.acronym, o.acronym, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.source, o.source, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.exampleFor, o.exampleFor, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuidePackageResourceComponent)) {
                return false;
            }
            ImplementationGuidePackageResourceComponent o = (ImplementationGuidePackageResourceComponent)other;
            return ImplementationGuidePackageResourceComponent.compareValues(this.example, o.example, true) && ImplementationGuidePackageResourceComponent.compareValues(this.name, o.name, true) && ImplementationGuidePackageResourceComponent.compareValues(this.description, o.description, true) && ImplementationGuidePackageResourceComponent.compareValues(this.acronym, o.acronym, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.example != null && !this.example.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.acronym != null && !this.acronym.isEmpty() || this.source != null && !this.source.isEmpty() || this.exampleFor != null && !this.exampleFor.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.package.resource";
        }
    }

    @Block
    public static class ImplementationGuidePackageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name used .page.package", formalDefinition="The name for the group, as used in page.package.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable text describing the package", formalDefinition="Human readable text describing the package.")
        protected StringType description;
        @Child(name="resource", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Resource in the implementation guide", formalDefinition="A resource that is part of the implementation guide. Conformance resources (value set, structure definition, conformance statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.")
        protected List<ImplementationGuidePackageResourceComponent> resource;
        private static final long serialVersionUID = -701846580L;

        public ImplementationGuidePackageComponent() {
        }

        public ImplementationGuidePackageComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuidePackageComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuidePackageComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuidePackageComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuidePackageComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ImplementationGuidePackageResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
            }
            return this.resource;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (ImplementationGuidePackageResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuidePackageResourceComponent addResource() {
            ImplementationGuidePackageResourceComponent t = new ImplementationGuidePackageResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public ImplementationGuidePackageComponent addResource(ImplementationGuidePackageResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ImplementationGuide.SP_NAME, "string", "The name for the group, as used in page.package.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "Human readable text describing the package.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property(ImplementationGuide.SP_RESOURCE, "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, conformance statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -341064690: {
                    this.getResource().add((ImplementationGuidePackageResourceComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                this.getResource().add((ImplementationGuidePackageResourceComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -341064690: {
                    return this.addResource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
            }
            if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                return this.addResource();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuidePackageComponent copy() {
            ImplementationGuidePackageComponent dst = new ImplementationGuidePackageComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.resource != null) {
                dst.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
                for (ImplementationGuidePackageResourceComponent i : this.resource) {
                    dst.resource.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuidePackageComponent)) {
                return false;
            }
            ImplementationGuidePackageComponent o = (ImplementationGuidePackageComponent)other;
            return ImplementationGuidePackageComponent.compareDeep(this.name, o.name, true) && ImplementationGuidePackageComponent.compareDeep(this.description, o.description, true) && ImplementationGuidePackageComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuidePackageComponent)) {
                return false;
            }
            ImplementationGuidePackageComponent o = (ImplementationGuidePackageComponent)other;
            return ImplementationGuidePackageComponent.compareValues(this.name, o.name, true) && ImplementationGuidePackageComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.resource != null && !this.resource.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.package";
        }
    }

    @Block
    public static class ImplementationGuideDependencyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="reference | inclusion", formalDefinition="How the dependency is represented when the guide is published.")
        protected Enumeration<GuideDependencyType> type;
        @Child(name="uri", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where to find dependency", formalDefinition="Where the dependency is located.")
        protected UriType uri;
        private static final long serialVersionUID = 162447098L;

        public ImplementationGuideDependencyComponent() {
        }

        public ImplementationGuideDependencyComponent(Enumeration<GuideDependencyType> type, UriType uri) {
            this.type = type;
            this.uri = uri;
        }

        public Enumeration<GuideDependencyType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependencyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<GuideDependencyType>(new GuideDependencyTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ImplementationGuideDependencyComponent setTypeElement(Enumeration<GuideDependencyType> value) {
            this.type = value;
            return this;
        }

        public GuideDependencyType getType() {
            return this.type == null ? null : (GuideDependencyType)((Object)this.type.getValue());
        }

        public ImplementationGuideDependencyComponent setType(GuideDependencyType value) {
            if (this.type == null) {
                this.type = new Enumeration<GuideDependencyType>(new GuideDependencyTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependencyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ImplementationGuideDependencyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ImplementationGuideDependencyComponent setUri(String value) {
            if (this.uri == null) {
                this.uri = new UriType();
            }
            this.uri.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "How the dependency is represented when the guide is published.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("uri", "uri", "Where the dependency is located.", 0, Integer.MAX_VALUE, this.uri));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new GuideDependencyTypeEnumFactory().fromType(value);
                    break;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new GuideDependencyTypeEnumFactory().fromType(value);
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 116076: {
                    throw new FHIRException("Cannot make property uri as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.type");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.uri");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDependencyComponent copy() {
            ImplementationGuideDependencyComponent dst = new ImplementationGuideDependencyComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuideDependencyComponent)) {
                return false;
            }
            ImplementationGuideDependencyComponent o = (ImplementationGuideDependencyComponent)other;
            return ImplementationGuideDependencyComponent.compareDeep(this.type, o.type, true) && ImplementationGuideDependencyComponent.compareDeep(this.uri, o.uri, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuideDependencyComponent)) {
                return false;
            }
            ImplementationGuideDependencyComponent o = (ImplementationGuideDependencyComponent)other;
            return ImplementationGuideDependencyComponent.compareValues(this.type, o.type, true) && ImplementationGuideDependencyComponent.compareValues(this.uri, o.uri, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.uri != null && !this.uri.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.dependency";
        }
    }

    @Block
    public static class ImplementationGuideContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the implementation guide.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuideContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuideContactComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ImplementationGuideContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ImplementationGuide.SP_NAME, "string", "The name of an individual to contact regarding the implementation guide.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1429363305: {
                    return this.addTelecom();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideContactComponent copy() {
            ImplementationGuideContactComponent dst = new ImplementationGuideContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuideContactComponent)) {
                return false;
            }
            ImplementationGuideContactComponent o = (ImplementationGuideContactComponent)other;
            return ImplementationGuideContactComponent.compareDeep(this.name, o.name, true) && ImplementationGuideContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImplementationGuideContactComponent)) {
                return false;
            }
            ImplementationGuideContactComponent o = (ImplementationGuideContactComponent)other;
            return ImplementationGuideContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.contact";
        }
    }

    public static class GuidePageKindEnumFactory
    implements EnumFactory<GuidePageKind> {
        @Override
        public GuidePageKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("page".equals(codeString)) {
                return GuidePageKind.PAGE;
            }
            if ("example".equals(codeString)) {
                return GuidePageKind.EXAMPLE;
            }
            if ("list".equals(codeString)) {
                return GuidePageKind.LIST;
            }
            if ("include".equals(codeString)) {
                return GuidePageKind.INCLUDE;
            }
            if ("directory".equals(codeString)) {
                return GuidePageKind.DIRECTORY;
            }
            if ("dictionary".equals(codeString)) {
                return GuidePageKind.DICTIONARY;
            }
            if ("toc".equals(codeString)) {
                return GuidePageKind.TOC;
            }
            if (ImplementationGuide.SP_RESOURCE.equals(codeString)) {
                return GuidePageKind.RESOURCE;
            }
            throw new IllegalArgumentException("Unknown GuidePageKind code '" + codeString + "'");
        }

        public Enumeration<GuidePageKind> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("page".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.PAGE);
            }
            if ("example".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.EXAMPLE);
            }
            if ("list".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.LIST);
            }
            if ("include".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.INCLUDE);
            }
            if ("directory".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.DIRECTORY);
            }
            if ("dictionary".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.DICTIONARY);
            }
            if ("toc".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.TOC);
            }
            if (ImplementationGuide.SP_RESOURCE.equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.RESOURCE);
            }
            throw new FHIRException("Unknown GuidePageKind code '" + codeString + "'");
        }

        @Override
        public String toCode(GuidePageKind code) {
            if (code == GuidePageKind.PAGE) {
                return "page";
            }
            if (code == GuidePageKind.EXAMPLE) {
                return "example";
            }
            if (code == GuidePageKind.LIST) {
                return "list";
            }
            if (code == GuidePageKind.INCLUDE) {
                return "include";
            }
            if (code == GuidePageKind.DIRECTORY) {
                return "directory";
            }
            if (code == GuidePageKind.DICTIONARY) {
                return "dictionary";
            }
            if (code == GuidePageKind.TOC) {
                return "toc";
            }
            if (code == GuidePageKind.RESOURCE) {
                return ImplementationGuide.SP_RESOURCE;
            }
            return "?";
        }

        @Override
        public String toSystem(GuidePageKind code) {
            return code.getSystem();
        }
    }

    public static enum GuidePageKind {
        PAGE,
        EXAMPLE,
        LIST,
        INCLUDE,
        DIRECTORY,
        DICTIONARY,
        TOC,
        RESOURCE,
        NULL;


        public static GuidePageKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("page".equals(codeString)) {
                return PAGE;
            }
            if ("example".equals(codeString)) {
                return EXAMPLE;
            }
            if ("list".equals(codeString)) {
                return LIST;
            }
            if ("include".equals(codeString)) {
                return INCLUDE;
            }
            if ("directory".equals(codeString)) {
                return DIRECTORY;
            }
            if ("dictionary".equals(codeString)) {
                return DICTIONARY;
            }
            if ("toc".equals(codeString)) {
                return TOC;
            }
            if (ImplementationGuide.SP_RESOURCE.equals(codeString)) {
                return RESOURCE;
            }
            throw new FHIRException("Unknown GuidePageKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PAGE: {
                    return "page";
                }
                case EXAMPLE: {
                    return "example";
                }
                case LIST: {
                    return "list";
                }
                case INCLUDE: {
                    return "include";
                }
                case DIRECTORY: {
                    return "directory";
                }
                case DICTIONARY: {
                    return "dictionary";
                }
                case TOC: {
                    return "toc";
                }
                case RESOURCE: {
                    return ImplementationGuide.SP_RESOURCE;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PAGE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case EXAMPLE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case LIST: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case INCLUDE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case DIRECTORY: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case DICTIONARY: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case TOC: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PAGE: {
                    return "This is a page of content that is included in the implementation guide. It has no particular function.";
                }
                case EXAMPLE: {
                    return "This is a page that represents a human readable rendering of an example.";
                }
                case LIST: {
                    return "This is a page that represents a list of resources of one or more types.";
                }
                case INCLUDE: {
                    return "This is a page showing where an included guide is injected.";
                }
                case DIRECTORY: {
                    return "This is a page that lists the resources of a given type, and also creates pages for all the listed types as other pages in the section.";
                }
                case DICTIONARY: {
                    return "This is a page that creates the listed resources as a dictionary.";
                }
                case TOC: {
                    return "This is a generated page that contains the table of contents.";
                }
                case RESOURCE: {
                    return "This is a page that represents a presented resource. This is typically used for generated conformance resource presentations.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PAGE: {
                    return "Page";
                }
                case EXAMPLE: {
                    return "Example";
                }
                case LIST: {
                    return "List";
                }
                case INCLUDE: {
                    return "Include";
                }
                case DIRECTORY: {
                    return "Directory";
                }
                case DICTIONARY: {
                    return "Dictionary";
                }
                case TOC: {
                    return "Table Of Contents";
                }
                case RESOURCE: {
                    return "Resource";
                }
            }
            return "?";
        }
    }

    public static class GuideDependencyTypeEnumFactory
    implements EnumFactory<GuideDependencyType> {
        @Override
        public GuideDependencyType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return GuideDependencyType.REFERENCE;
            }
            if ("inclusion".equals(codeString)) {
                return GuideDependencyType.INCLUSION;
            }
            throw new IllegalArgumentException("Unknown GuideDependencyType code '" + codeString + "'");
        }

        public Enumeration<GuideDependencyType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<GuideDependencyType>(this, GuideDependencyType.REFERENCE);
            }
            if ("inclusion".equals(codeString)) {
                return new Enumeration<GuideDependencyType>(this, GuideDependencyType.INCLUSION);
            }
            throw new FHIRException("Unknown GuideDependencyType code '" + codeString + "'");
        }

        @Override
        public String toCode(GuideDependencyType code) {
            if (code == GuideDependencyType.REFERENCE) {
                return "reference";
            }
            if (code == GuideDependencyType.INCLUSION) {
                return "inclusion";
            }
            return "?";
        }

        @Override
        public String toSystem(GuideDependencyType code) {
            return code.getSystem();
        }
    }

    public static enum GuideDependencyType {
        REFERENCE,
        INCLUSION,
        NULL;


        public static GuideDependencyType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("inclusion".equals(codeString)) {
                return INCLUSION;
            }
            throw new FHIRException("Unknown GuideDependencyType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REFERENCE: {
                    return "reference";
                }
                case INCLUSION: {
                    return "inclusion";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REFERENCE: {
                    return "http://hl7.org/fhir/guide-dependency-type";
                }
                case INCLUSION: {
                    return "http://hl7.org/fhir/guide-dependency-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REFERENCE: {
                    return "The guide is referred to by URL.";
                }
                case INCLUSION: {
                    return "The guide is embedded in this guide when published.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REFERENCE: {
                    return "Reference";
                }
                case INCLUSION: {
                    return "Inclusion";
                }
            }
            return "?";
        }
    }
}

