/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Quantity;

@DatatypeDef(name="Duration", profileOf=Quantity.class)
public class Duration
extends Quantity {
    private static final long serialVersionUID = 1069574054L;

    @Override
    public Duration copy() {
        Duration dst = new Duration();
        this.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.comparator = this.comparator == null ? null : this.comparator.copy();
        dst.unit = this.unit == null ? null : this.unit.copy();
        dst.system = this.system == null ? null : this.system.copy();
        dst.code = this.code == null ? null : this.code.copy();
        return dst;
    }

    @Override
    protected Duration typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration o = (Duration)other;
        return Duration.compareDeep(this.value, o.value, true) && Duration.compareDeep(this.comparator, o.comparator, true) && Duration.compareDeep(this.unit, o.unit, true) && Duration.compareDeep(this.system, o.system, true) && Duration.compareDeep(this.code, o.code, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration o = (Duration)other;
        return Duration.compareValues(this.value, o.value, true) && Duration.compareValues(this.comparator, o.comparator, true) && Duration.compareValues(this.unit, o.unit, true) && Duration.compareValues(this.system, o.system, true) && Duration.compareValues(this.code, o.code, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.value != null && !this.value.isEmpty() || this.comparator != null && !this.comparator.isEmpty() || this.unit != null && !this.unit.isEmpty() || this.system != null && !this.system.isEmpty() || this.code != null && !this.code.isEmpty());
    }
}

