/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DetectedIssue", profile="http://hl7.org/fhir/Profile/DetectedIssue")
public class DetectedIssue
extends DomainResource {
    @Child(name="patient", type={Patient.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Associated patient", formalDefinition="Indicates the patient whose record the detected issue is associated with.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Issue Category, e.g. drug-drug, duplicate therapy, etc.", formalDefinition="Identifies the general type of issue identified.")
    protected CodeableConcept category;
    @Child(name="severity", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="high | moderate | low", formalDefinition="Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.")
    protected Enumeration<DetectedIssueSeverity> severity;
    @Child(name="implicated", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Problem resource", formalDefinition="Indicates the resource representing the current activity or proposed activity that is potentially problematic.")
    protected List<Reference> implicated;
    protected List<Resource> implicatedTarget;
    @Child(name="detail", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description and context", formalDefinition="A textual explanation of the detected issue.")
    protected StringType detail;
    @Child(name="date", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When identified", formalDefinition="The date or date-time when the detected issue was initially identified.")
    protected DateTimeType date;
    @Child(name="author", type={Practitioner.class, Device.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The provider or device that identified the issue", formalDefinition="Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="identifier", type={Identifier.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique id for the detected issue", formalDefinition="Business identifier associated with the detected issue record.")
    protected Identifier identifier;
    @Child(name="reference", type={UriType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Authority for issue", formalDefinition="The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.")
    protected UriType reference;
    @Child(name="mitigation", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Step taken to address", formalDefinition="Indicates an action that has been taken or is committed to to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.")
    protected List<DetectedIssueMitigationComponent> mitigation;
    private static final long serialVersionUID = -403732234L;
    @SearchParamDefinition(name="author", path="DetectedIssue.author", description="The provider or device that identified the issue", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DetectedIssue:author").toLocked();
    @SearchParamDefinition(name="category", path="DetectedIssue.category", description="Issue Category, e.g. drug-drug, duplicate therapy, etc.", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="implicated", path="DetectedIssue.implicated", description="Problem resource", type="reference")
    public static final String SP_IMPLICATED = "implicated";
    public static final ReferenceClientParam IMPLICATED = new ReferenceClientParam("implicated");
    public static final Include INCLUDE_IMPLICATED = new Include("DetectedIssue:implicated").toLocked();
    @SearchParamDefinition(name="patient", path="DetectedIssue.patient", description="Associated patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DetectedIssue:patient").toLocked();
    @SearchParamDefinition(name="date", path="DetectedIssue.date", description="When identified", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="DetectedIssue.identifier", description="Unique id for the detected issue", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public DetectedIssue setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public DetectedIssue setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public DetectedIssue setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Enumeration<DetectedIssueSeverity> getSeverityElement() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new Enumeration<DetectedIssueSeverity>(new DetectedIssueSeverityEnumFactory());
            }
        }
        return this.severity;
    }

    public boolean hasSeverityElement() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public DetectedIssue setSeverityElement(Enumeration<DetectedIssueSeverity> value) {
        this.severity = value;
        return this;
    }

    public DetectedIssueSeverity getSeverity() {
        return this.severity == null ? null : (DetectedIssueSeverity)((Object)this.severity.getValue());
    }

    public DetectedIssue setSeverity(DetectedIssueSeverity value) {
        if (value == null) {
            this.severity = null;
        } else {
            if (this.severity == null) {
                this.severity = new Enumeration<DetectedIssueSeverity>(new DetectedIssueSeverityEnumFactory());
            }
            this.severity.setValue((Object)value);
        }
        return this;
    }

    public List<Reference> getImplicated() {
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        return this.implicated;
    }

    public boolean hasImplicated() {
        if (this.implicated == null) {
            return false;
        }
        for (Reference item : this.implicated) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addImplicated() {
        Reference t = new Reference();
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        this.implicated.add(t);
        return t;
    }

    public DetectedIssue addImplicated(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        this.implicated.add(t);
        return this;
    }

    public List<Resource> getImplicatedTarget() {
        if (this.implicatedTarget == null) {
            this.implicatedTarget = new ArrayList<Resource>();
        }
        return this.implicatedTarget;
    }

    public StringType getDetailElement() {
        if (this.detail == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.detail");
            }
            if (Configuration.doAutoCreate()) {
                this.detail = new StringType();
            }
        }
        return this.detail;
    }

    public boolean hasDetailElement() {
        return this.detail != null && !this.detail.isEmpty();
    }

    public boolean hasDetail() {
        return this.detail != null && !this.detail.isEmpty();
    }

    public DetectedIssue setDetailElement(StringType value) {
        this.detail = value;
        return this;
    }

    public String getDetail() {
        return this.detail == null ? null : (String)this.detail.getValue();
    }

    public DetectedIssue setDetail(String value) {
        if (Utilities.noString(value)) {
            this.detail = null;
        } else {
            if (this.detail == null) {
                this.detail = new StringType();
            }
            this.detail.setValue(value);
        }
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public DetectedIssue setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public DetectedIssue setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public DetectedIssue setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public DetectedIssue setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public DetectedIssue setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public UriType getReferenceElement() {
        if (this.reference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DetectedIssue.reference");
            }
            if (Configuration.doAutoCreate()) {
                this.reference = new UriType();
            }
        }
        return this.reference;
    }

    public boolean hasReferenceElement() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public DetectedIssue setReferenceElement(UriType value) {
        this.reference = value;
        return this;
    }

    public String getReference() {
        return this.reference == null ? null : (String)this.reference.getValue();
    }

    public DetectedIssue setReference(String value) {
        if (Utilities.noString(value)) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new UriType();
            }
            this.reference.setValue(value);
        }
        return this;
    }

    public List<DetectedIssueMitigationComponent> getMitigation() {
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        return this.mitigation;
    }

    public boolean hasMitigation() {
        if (this.mitigation == null) {
            return false;
        }
        for (DetectedIssueMitigationComponent item : this.mitigation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetectedIssueMitigationComponent addMitigation() {
        DetectedIssueMitigationComponent t = new DetectedIssueMitigationComponent();
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        this.mitigation.add(t);
        return t;
    }

    public DetectedIssue addMitigation(DetectedIssueMitigationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
        }
        this.mitigation.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "Indicates the patient whose record the detected issue is associated with.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "Identifies the general type of issue identified.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property("severity", "code", "Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.", 0, Integer.MAX_VALUE, this.severity));
        childrenList.add(new Property(SP_IMPLICATED, "Reference(Any)", "Indicates the resource representing the current activity or proposed activity that is potentially problematic.", 0, Integer.MAX_VALUE, this.implicated));
        childrenList.add(new Property("detail", "string", "A textual explanation of the detected issue.", 0, Integer.MAX_VALUE, this.detail));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date or date-time when the detected issue was initially identified.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner|Device)", "Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier associated with the detected issue record.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("reference", "uri", "The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.", 0, Integer.MAX_VALUE, this.reference));
        childrenList.add(new Property("mitigation", "", "Indicates an action that has been taken or is committed to to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.", 0, Integer.MAX_VALUE, this.mitigation));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.patient;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.category;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.severity;
                }
                return baseArray;
            }
            case -810216884: {
                return this.implicated == null ? new Base[]{} : this.implicated.toArray(new Base[this.implicated.size()]);
            }
            case -1335224239: {
                Base[] baseArray;
                if (this.detail == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.detail;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.date;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.author;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.identifier;
                }
                return baseArray;
            }
            case -925155509: {
                Base[] baseArray;
                if (this.reference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.reference;
                }
                return baseArray;
            }
            case 1293793087: {
                return this.mitigation == null ? new Base[]{} : this.mitigation.toArray(new Base[this.mitigation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                break;
            }
            case 1478300413: {
                this.severity = new DetectedIssueSeverityEnumFactory().fromType(value);
                break;
            }
            case -810216884: {
                this.getImplicated().add(this.castToReference(value));
                break;
            }
            case -1335224239: {
                this.detail = this.castToString(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case -925155509: {
                this.reference = this.castToUri(value);
                break;
            }
            case 1293793087: {
                this.getMitigation().add((DetectedIssueMitigationComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("severity")) {
            this.severity = new DetectedIssueSeverityEnumFactory().fromType(value);
        } else if (name.equals(SP_IMPLICATED)) {
            this.getImplicated().add(this.castToReference(value));
        } else if (name.equals("detail")) {
            this.detail = this.castToString(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("reference")) {
            this.reference = this.castToUri(value);
        } else if (name.equals("mitigation")) {
            this.getMitigation().add((DetectedIssueMitigationComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -791418107: {
                return this.getPatient();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 1478300413: {
                throw new FHIRException("Cannot make property severity as it is not a complex type");
            }
            case -810216884: {
                return this.addImplicated();
            }
            case -1335224239: {
                throw new FHIRException("Cannot make property detail as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case -925155509: {
                throw new FHIRException("Cannot make property reference as it is not a complex type");
            }
            case 1293793087: {
                return this.addMitigation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("severity")) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.severity");
        }
        if (name.equals(SP_IMPLICATED)) {
            return this.addImplicated();
        }
        if (name.equals("detail")) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.detail");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.date");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("reference")) {
            throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.reference");
        }
        if (name.equals("mitigation")) {
            return this.addMitigation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DetectedIssue";
    }

    @Override
    public DetectedIssue copy() {
        DetectedIssue dst = new DetectedIssue();
        this.copyValues(dst);
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.category = this.category == null ? null : this.category.copy();
        Enumeration<DetectedIssueSeverity> enumeration = dst.severity = this.severity == null ? null : this.severity.copy();
        if (this.implicated != null) {
            dst.implicated = new ArrayList<Reference>();
            for (Reference reference : this.implicated) {
                dst.implicated.add(reference.copy());
            }
        }
        dst.detail = this.detail == null ? null : this.detail.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        UriType uriType = dst.reference = this.reference == null ? null : this.reference.copy();
        if (this.mitigation != null) {
            dst.mitigation = new ArrayList<DetectedIssueMitigationComponent>();
            for (DetectedIssueMitigationComponent detectedIssueMitigationComponent : this.mitigation) {
                dst.mitigation.add(detectedIssueMitigationComponent.copy());
            }
        }
        return dst;
    }

    protected DetectedIssue typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DetectedIssue)) {
            return false;
        }
        DetectedIssue o = (DetectedIssue)other;
        return DetectedIssue.compareDeep(this.patient, o.patient, true) && DetectedIssue.compareDeep(this.category, o.category, true) && DetectedIssue.compareDeep(this.severity, o.severity, true) && DetectedIssue.compareDeep(this.implicated, o.implicated, true) && DetectedIssue.compareDeep(this.detail, o.detail, true) && DetectedIssue.compareDeep(this.date, o.date, true) && DetectedIssue.compareDeep(this.author, o.author, true) && DetectedIssue.compareDeep(this.identifier, o.identifier, true) && DetectedIssue.compareDeep(this.reference, o.reference, true) && DetectedIssue.compareDeep(this.mitigation, o.mitigation, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DetectedIssue)) {
            return false;
        }
        DetectedIssue o = (DetectedIssue)other;
        return DetectedIssue.compareValues(this.severity, o.severity, true) && DetectedIssue.compareValues(this.detail, o.detail, true) && DetectedIssue.compareValues(this.date, o.date, true) && DetectedIssue.compareValues(this.reference, o.reference, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.category != null && !this.category.isEmpty() || this.severity != null && !this.severity.isEmpty() || this.implicated != null && !this.implicated.isEmpty() || this.detail != null && !this.detail.isEmpty() || this.date != null && !this.date.isEmpty() || this.author != null && !this.author.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.mitigation != null && !this.mitigation.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DetectedIssue;
    }

    @Block
    public static class DetectedIssueMitigationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="action", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What mitigation?", formalDefinition="Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.")
        protected CodeableConcept action;
        @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date committed", formalDefinition="Indicates when the mitigating action was documented.")
        protected DateTimeType date;
        @Child(name="author", type={Practitioner.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is committing?", formalDefinition="Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.")
        protected Reference author;
        protected Practitioner authorTarget;
        private static final long serialVersionUID = -1994768436L;

        public DetectedIssueMitigationComponent() {
        }

        public DetectedIssueMitigationComponent(CodeableConcept action) {
            this.action = action;
        }

        public CodeableConcept getAction() {
            if (this.action == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.action");
                }
                if (Configuration.doAutoCreate()) {
                    this.action = new CodeableConcept();
                }
            }
            return this.action;
        }

        public boolean hasAction() {
            return this.action != null && !this.action.isEmpty();
        }

        public DetectedIssueMitigationComponent setAction(CodeableConcept value) {
            this.action = value;
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public DetectedIssueMitigationComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public DetectedIssueMitigationComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getAuthor() {
            if (this.author == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.author");
                }
                if (Configuration.doAutoCreate()) {
                    this.author = new Reference();
                }
            }
            return this.author;
        }

        public boolean hasAuthor() {
            return this.author != null && !this.author.isEmpty();
        }

        public DetectedIssueMitigationComponent setAuthor(Reference value) {
            this.author = value;
            return this;
        }

        public Practitioner getAuthorTarget() {
            if (this.authorTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetectedIssueMitigationComponent.author");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorTarget = new Practitioner();
                }
            }
            return this.authorTarget;
        }

        public DetectedIssueMitigationComponent setAuthorTarget(Practitioner value) {
            this.authorTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("action", "CodeableConcept", "Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue.", 0, Integer.MAX_VALUE, this.action));
            childrenList.add(new Property(DetectedIssue.SP_DATE, "dateTime", "Indicates when the mitigating action was documented.", 0, Integer.MAX_VALUE, this.date));
            childrenList.add(new Property(DetectedIssue.SP_AUTHOR, "Reference(Practitioner)", "Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring.", 0, Integer.MAX_VALUE, this.author));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    Base[] baseArray;
                    if (this.action == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.action;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    Base[] baseArray;
                    if (this.author == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.author;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    this.action = this.castToCodeableConcept(value);
                    break;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    break;
                }
                case -1406328437: {
                    this.author = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("action")) {
                this.action = this.castToCodeableConcept(value);
            } else if (name.equals(DetectedIssue.SP_DATE)) {
                this.date = this.castToDateTime(value);
            } else if (name.equals(DetectedIssue.SP_AUTHOR)) {
                this.author = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1422950858: {
                    return this.getAction();
                }
                case 3076014: {
                    throw new FHIRException("Cannot make property date as it is not a complex type");
                }
                case -1406328437: {
                    return this.getAuthor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("action")) {
                this.action = new CodeableConcept();
                return this.action;
            }
            if (name.equals(DetectedIssue.SP_DATE)) {
                throw new FHIRException("Cannot call addChild on a primitive type DetectedIssue.date");
            }
            if (name.equals(DetectedIssue.SP_AUTHOR)) {
                this.author = new Reference();
                return this.author;
            }
            return super.addChild(name);
        }

        @Override
        public DetectedIssueMitigationComponent copy() {
            DetectedIssueMitigationComponent dst = new DetectedIssueMitigationComponent();
            this.copyValues(dst);
            dst.action = this.action == null ? null : this.action.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.author = this.author == null ? null : this.author.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DetectedIssueMitigationComponent)) {
                return false;
            }
            DetectedIssueMitigationComponent o = (DetectedIssueMitigationComponent)other;
            return DetectedIssueMitigationComponent.compareDeep(this.action, o.action, true) && DetectedIssueMitigationComponent.compareDeep(this.date, o.date, true) && DetectedIssueMitigationComponent.compareDeep(this.author, o.author, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DetectedIssueMitigationComponent)) {
                return false;
            }
            DetectedIssueMitigationComponent o = (DetectedIssueMitigationComponent)other;
            return DetectedIssueMitigationComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.action != null && !this.action.isEmpty() || this.date != null && !this.date.isEmpty() || this.author != null && !this.author.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DetectedIssue.mitigation";
        }
    }

    public static class DetectedIssueSeverityEnumFactory
    implements EnumFactory<DetectedIssueSeverity> {
        @Override
        public DetectedIssueSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("high".equals(codeString)) {
                return DetectedIssueSeverity.HIGH;
            }
            if ("moderate".equals(codeString)) {
                return DetectedIssueSeverity.MODERATE;
            }
            if ("low".equals(codeString)) {
                return DetectedIssueSeverity.LOW;
            }
            throw new IllegalArgumentException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        public Enumeration<DetectedIssueSeverity> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("high".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.HIGH);
            }
            if ("moderate".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.MODERATE);
            }
            if ("low".equals(codeString)) {
                return new Enumeration<DetectedIssueSeverity>(this, DetectedIssueSeverity.LOW);
            }
            throw new FHIRException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(DetectedIssueSeverity code) {
            if (code == DetectedIssueSeverity.HIGH) {
                return "high";
            }
            if (code == DetectedIssueSeverity.MODERATE) {
                return "moderate";
            }
            if (code == DetectedIssueSeverity.LOW) {
                return "low";
            }
            return "?";
        }

        @Override
        public String toSystem(DetectedIssueSeverity code) {
            return code.getSystem();
        }
    }

    public static enum DetectedIssueSeverity {
        HIGH,
        MODERATE,
        LOW,
        NULL;


        public static DetectedIssueSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            if ("moderate".equals(codeString)) {
                return MODERATE;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            throw new FHIRException("Unknown DetectedIssueSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case HIGH: {
                    return "high";
                }
                case MODERATE: {
                    return "moderate";
                }
                case LOW: {
                    return "low";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case HIGH: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case MODERATE: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
                case LOW: {
                    return "http://hl7.org/fhir/detectedissue-severity";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case HIGH: {
                    return "Indicates the issue may be life-threatening or has the potential to cause permanent injury.";
                }
                case MODERATE: {
                    return "Indicates the issue may result in noticeable adverse consequences but is unlikely to be life-threatening or cause permanent injury.";
                }
                case LOW: {
                    return "Indicates the issue may result in some adverse consequences but is unlikely to substantially affect the situation of the subject.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case HIGH: {
                    return "High";
                }
                case MODERATE: {
                    return "Moderate";
                }
                case LOW: {
                    return "Low";
                }
            }
            return "?";
        }
    }
}

