/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Signature;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Bundle", profile="http://hl7.org/fhir/Profile/Bundle")
public class Bundle
extends Resource
implements IBaseBundle {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection", formalDefinition="Indicates the purpose of this bundle- how it was intended to be used.")
    protected Enumeration<BundleType> type;
    @Child(name="total", type={UnsignedIntType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If search, the total number of matches", formalDefinition="If a set of search matches, this is the total number of matches for the search (as opposed to the number of results in this bundle).")
    protected UnsignedIntType total;
    @Child(name="link", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Links related to this Bundle", formalDefinition="A series of links that provide context to this bundle.")
    protected List<BundleLinkComponent> link;
    @Child(name="entry", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Entry in the bundle - will have a resource, or information", formalDefinition="An entry in a bundle resource - will either contain a resource, or information about a resource (transactions and history only).")
    protected List<BundleEntryComponent> entry;
    @Child(name="signature", type={Signature.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Digital Signature", formalDefinition="Digital Signature - base64 encoded. XML DigSIg or a JWT.")
    protected Signature signature;
    private static final long serialVersionUID = -2041954721L;
    @SearchParamDefinition(name="message", path="Bundle.entry.resource[0]", description="The first resource in the bundle, if the bundle type is \"message\" - this is a message header, and this parameter provides access to search its contents", type="reference")
    public static final String SP_MESSAGE = "message";
    public static final ReferenceClientParam MESSAGE = new ReferenceClientParam("message");
    public static final Include INCLUDE_MESSAGE = new Include("Bundle:message").toLocked();
    @SearchParamDefinition(name="composition", path="Bundle.entry.resource[0]", description="The first resource in the bundle, if the bundle type is \"document\" - this is a composition, and this parameter provides access to searches its contents", type="reference")
    public static final String SP_COMPOSITION = "composition";
    public static final ReferenceClientParam COMPOSITION = new ReferenceClientParam("composition");
    public static final Include INCLUDE_COMPOSITION = new Include("Bundle:composition").toLocked();
    @SearchParamDefinition(name="type", path="Bundle.type", description="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Bundle() {
    }

    public Bundle(Enumeration<BundleType> type) {
        this.type = type;
    }

    public Enumeration<BundleType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Bundle setTypeElement(Enumeration<BundleType> value) {
        this.type = value;
        return this;
    }

    public BundleType getType() {
        return this.type == null ? null : (BundleType)((Object)this.type.getValue());
    }

    public Bundle setType(BundleType value) {
        if (this.type == null) {
            this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getTotalElement() {
        if (this.total == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.total");
            }
            if (Configuration.doAutoCreate()) {
                this.total = new UnsignedIntType();
            }
        }
        return this.total;
    }

    public boolean hasTotalElement() {
        return this.total != null && !this.total.isEmpty();
    }

    public boolean hasTotal() {
        return this.total != null && !this.total.isEmpty();
    }

    public Bundle setTotalElement(UnsignedIntType value) {
        this.total = value;
        return this;
    }

    public int getTotal() {
        return this.total == null || this.total.isEmpty() ? 0 : (Integer)this.total.getValue();
    }

    public Bundle setTotal(int value) {
        if (this.total == null) {
            this.total = new UnsignedIntType();
        }
        this.total.setValue((Object)value);
        return this;
    }

    public List<BundleLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        return this.link;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (BundleLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BundleLinkComponent addLink() {
        BundleLinkComponent t = new BundleLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public Bundle addLink(BundleLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    public List<BundleEntryComponent> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        return this.entry;
    }

    public boolean hasEntry() {
        if (this.entry == null) {
            return false;
        }
        for (BundleEntryComponent item : this.entry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BundleEntryComponent addEntry() {
        BundleEntryComponent t = new BundleEntryComponent();
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        this.entry.add(t);
        return t;
    }

    public Bundle addEntry(BundleEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        this.entry.add(t);
        return this;
    }

    public Signature getSignature() {
        if (this.signature == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.signature");
            }
            if (Configuration.doAutoCreate()) {
                this.signature = new Signature();
            }
        }
        return this.signature;
    }

    public boolean hasSignature() {
        return this.signature != null && !this.signature.isEmpty();
    }

    public Bundle setSignature(Signature value) {
        this.signature = value;
        return this;
    }

    public BundleLinkComponent getLink(String theRelation) {
        Validate.notBlank(theRelation, "theRelation may not be null or empty", new Object[0]);
        for (BundleLinkComponent next : this.getLink()) {
            if (!theRelation.equals(next.getRelation())) continue;
            return next;
        }
        return null;
    }

    public BundleLinkComponent getLinkOrCreate(String theRelation) {
        Validate.notBlank(theRelation, "theRelation may not be null or empty", new Object[0]);
        for (BundleLinkComponent next : this.getLink()) {
            if (!theRelation.equals(next.getRelation())) continue;
            return next;
        }
        BundleLinkComponent retVal = new BundleLinkComponent();
        retVal.setRelation(theRelation);
        this.getLink().add(retVal);
        return retVal;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_TYPE, "code", "Indicates the purpose of this bundle- how it was intended to be used.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("total", "unsignedInt", "If a set of search matches, this is the total number of matches for the search (as opposed to the number of results in this bundle).", 0, Integer.MAX_VALUE, this.total));
        childrenList.add(new Property("link", "", "A series of links that provide context to this bundle.", 0, Integer.MAX_VALUE, this.link));
        childrenList.add(new Property("entry", "", "An entry in a bundle resource - will either contain a resource, or information about a resource (transactions and history only).", 0, Integer.MAX_VALUE, this.entry));
        childrenList.add(new Property("signature", "Signature", "Digital Signature - base64 encoded. XML DigSIg or a JWT.", 0, Integer.MAX_VALUE, this.signature));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 110549828: {
                Base[] baseArray;
                if (this.total == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.total;
                }
                return baseArray;
            }
            case 3321850: {
                return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
            }
            case 96667762: {
                return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
            }
            case 1073584312: {
                Base[] baseArray;
                if (this.signature == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.signature;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.type = new BundleTypeEnumFactory().fromType(value);
                break;
            }
            case 110549828: {
                this.total = this.castToUnsignedInt(value);
                break;
            }
            case 3321850: {
                this.getLink().add((BundleLinkComponent)value);
                break;
            }
            case 96667762: {
                this.getEntry().add((BundleEntryComponent)value);
                break;
            }
            case 1073584312: {
                this.signature = this.castToSignature(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TYPE)) {
            this.type = new BundleTypeEnumFactory().fromType(value);
        } else if (name.equals("total")) {
            this.total = this.castToUnsignedInt(value);
        } else if (name.equals("link")) {
            this.getLink().add((BundleLinkComponent)value);
        } else if (name.equals("entry")) {
            this.getEntry().add((BundleEntryComponent)value);
        } else if (name.equals("signature")) {
            this.signature = this.castToSignature(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case 110549828: {
                throw new FHIRException("Cannot make property total as it is not a complex type");
            }
            case 3321850: {
                return this.addLink();
            }
            case 96667762: {
                return this.addEntry();
            }
            case 1073584312: {
                return this.getSignature();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Bundle.type");
        }
        if (name.equals("total")) {
            throw new FHIRException("Cannot call addChild on a primitive type Bundle.total");
        }
        if (name.equals("link")) {
            return this.addLink();
        }
        if (name.equals("entry")) {
            return this.addEntry();
        }
        if (name.equals("signature")) {
            this.signature = new Signature();
            return this.signature;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Bundle";
    }

    @Override
    public Bundle copy() {
        Bundle dst = new Bundle();
        this.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        UnsignedIntType unsignedIntType = dst.total = this.total == null ? null : this.total.copy();
        if (this.link != null) {
            dst.link = new ArrayList<BundleLinkComponent>();
            for (BundleLinkComponent bundleLinkComponent : this.link) {
                dst.link.add(bundleLinkComponent.copy());
            }
        }
        if (this.entry != null) {
            dst.entry = new ArrayList<BundleEntryComponent>();
            for (BundleEntryComponent bundleEntryComponent : this.entry) {
                dst.entry.add(bundleEntryComponent.copy());
            }
        }
        dst.signature = this.signature == null ? null : this.signature.copy();
        return dst;
    }

    protected Bundle typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Bundle)) {
            return false;
        }
        Bundle o = (Bundle)other;
        return Bundle.compareDeep(this.type, o.type, true) && Bundle.compareDeep(this.total, o.total, true) && Bundle.compareDeep(this.link, o.link, true) && Bundle.compareDeep(this.entry, o.entry, true) && Bundle.compareDeep(this.signature, o.signature, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Bundle)) {
            return false;
        }
        Bundle o = (Bundle)other;
        return Bundle.compareValues(this.type, o.type, true) && Bundle.compareValues(this.total, o.total, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.total != null && !this.total.isEmpty() || this.link != null && !this.link.isEmpty() || this.entry != null && !this.entry.isEmpty() || this.signature != null && !this.signature.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Bundle;
    }

    @Block
    public static class BundleEntryResponseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Status response code (text optional)", formalDefinition="The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.")
        protected StringType status;
        @Child(name="location", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The location, if the operation returns a location", formalDefinition="The location header created by processing this operation.")
        protected UriType location;
        @Child(name="etag", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The etag for the resource (if relevant)", formalDefinition="The etag for the resource, it the operation for the entry produced a versioned resource.")
        protected StringType etag;
        @Child(name="lastModified", type={InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Server's date time modified", formalDefinition="The date/time that the resource was modified on the server.")
        protected InstantType lastModified;
        private static final long serialVersionUID = -1526413234L;

        public BundleEntryResponseComponent() {
        }

        public BundleEntryResponseComponent(StringType status) {
            this.status = status;
        }

        public StringType getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new StringType();
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public BundleEntryResponseComponent setStatusElement(StringType value) {
            this.status = value;
            return this;
        }

        public String getStatus() {
            return this.status == null ? null : (String)this.status.getValue();
        }

        public BundleEntryResponseComponent setStatus(String value) {
            if (this.status == null) {
                this.status = new StringType();
            }
            this.status.setValue(value);
            return this;
        }

        public UriType getLocationElement() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new UriType();
                }
            }
            return this.location;
        }

        public boolean hasLocationElement() {
            return this.location != null && !this.location.isEmpty();
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public BundleEntryResponseComponent setLocationElement(UriType value) {
            this.location = value;
            return this;
        }

        public String getLocation() {
            return this.location == null ? null : (String)this.location.getValue();
        }

        public BundleEntryResponseComponent setLocation(String value) {
            if (Utilities.noString(value)) {
                this.location = null;
            } else {
                if (this.location == null) {
                    this.location = new UriType();
                }
                this.location.setValue(value);
            }
            return this;
        }

        public StringType getEtagElement() {
            if (this.etag == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.etag");
                }
                if (Configuration.doAutoCreate()) {
                    this.etag = new StringType();
                }
            }
            return this.etag;
        }

        public boolean hasEtagElement() {
            return this.etag != null && !this.etag.isEmpty();
        }

        public boolean hasEtag() {
            return this.etag != null && !this.etag.isEmpty();
        }

        public BundleEntryResponseComponent setEtagElement(StringType value) {
            this.etag = value;
            return this;
        }

        public String getEtag() {
            return this.etag == null ? null : (String)this.etag.getValue();
        }

        public BundleEntryResponseComponent setEtag(String value) {
            if (Utilities.noString(value)) {
                this.etag = null;
            } else {
                if (this.etag == null) {
                    this.etag = new StringType();
                }
                this.etag.setValue(value);
            }
            return this;
        }

        public InstantType getLastModifiedElement() {
            if (this.lastModified == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.lastModified");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastModified = new InstantType();
                }
            }
            return this.lastModified;
        }

        public boolean hasLastModifiedElement() {
            return this.lastModified != null && !this.lastModified.isEmpty();
        }

        public boolean hasLastModified() {
            return this.lastModified != null && !this.lastModified.isEmpty();
        }

        public BundleEntryResponseComponent setLastModifiedElement(InstantType value) {
            this.lastModified = value;
            return this;
        }

        public Date getLastModified() {
            return this.lastModified == null ? null : (Date)this.lastModified.getValue();
        }

        public BundleEntryResponseComponent setLastModified(Date value) {
            if (value == null) {
                this.lastModified = null;
            } else {
                if (this.lastModified == null) {
                    this.lastModified = new InstantType();
                }
                this.lastModified.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("status", "string", "The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.", 0, Integer.MAX_VALUE, this.status));
            childrenList.add(new Property("location", "uri", "The location header created by processing this operation.", 0, Integer.MAX_VALUE, this.location));
            childrenList.add(new Property("etag", "string", "The etag for the resource, it the operation for the entry produced a versioned resource.", 0, Integer.MAX_VALUE, this.etag));
            childrenList.add(new Property("lastModified", "instant", "The date/time that the resource was modified on the server.", 0, Integer.MAX_VALUE, this.lastModified));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.location;
                    }
                    return baseArray;
                }
                case 3123477: {
                    Base[] baseArray;
                    if (this.etag == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.etag;
                    }
                    return baseArray;
                }
                case 1959003007: {
                    Base[] baseArray;
                    if (this.lastModified == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.lastModified;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = this.castToString(value);
                    break;
                }
                case 1901043637: {
                    this.location = this.castToUri(value);
                    break;
                }
                case 3123477: {
                    this.etag = this.castToString(value);
                    break;
                }
                case 1959003007: {
                    this.lastModified = this.castToInstant(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("status")) {
                this.status = this.castToString(value);
            } else if (name.equals("location")) {
                this.location = this.castToUri(value);
            } else if (name.equals("etag")) {
                this.etag = this.castToString(value);
            } else if (name.equals("lastModified")) {
                this.lastModified = this.castToInstant(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    throw new FHIRException("Cannot make property status as it is not a complex type");
                }
                case 1901043637: {
                    throw new FHIRException("Cannot make property location as it is not a complex type");
                }
                case 3123477: {
                    throw new FHIRException("Cannot make property etag as it is not a complex type");
                }
                case 1959003007: {
                    throw new FHIRException("Cannot make property lastModified as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("status")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.status");
            }
            if (name.equals("location")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.location");
            }
            if (name.equals("etag")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.etag");
            }
            if (name.equals("lastModified")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.lastModified");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryResponseComponent copy() {
            BundleEntryResponseComponent dst = new BundleEntryResponseComponent();
            this.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.etag = this.etag == null ? null : this.etag.copy();
            dst.lastModified = this.lastModified == null ? null : this.lastModified.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BundleEntryResponseComponent)) {
                return false;
            }
            BundleEntryResponseComponent o = (BundleEntryResponseComponent)other;
            return BundleEntryResponseComponent.compareDeep(this.status, o.status, true) && BundleEntryResponseComponent.compareDeep(this.location, o.location, true) && BundleEntryResponseComponent.compareDeep(this.etag, o.etag, true) && BundleEntryResponseComponent.compareDeep(this.lastModified, o.lastModified, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BundleEntryResponseComponent)) {
                return false;
            }
            BundleEntryResponseComponent o = (BundleEntryResponseComponent)other;
            return BundleEntryResponseComponent.compareValues(this.status, o.status, true) && BundleEntryResponseComponent.compareValues(this.location, o.location, true) && BundleEntryResponseComponent.compareValues(this.etag, o.etag, true) && BundleEntryResponseComponent.compareValues(this.lastModified, o.lastModified, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.status != null && !this.status.isEmpty() || this.location != null && !this.location.isEmpty() || this.etag != null && !this.etag.isEmpty() || this.lastModified != null && !this.lastModified.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.response";
        }
    }

    @Block
    public static class BundleEntryRequestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="method", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="GET | POST | PUT | DELETE", formalDefinition="The HTTP verb for this entry in either a change history, or a transaction/ transaction response.")
        protected Enumeration<HTTPVerb> method;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL for HTTP equivalent of this entry", formalDefinition="The URL for this entry, relative to the root (the address to which the request is posted).")
        protected UriType url;
        @Child(name="ifNoneMatch", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing cache currency", formalDefinition="If the ETag values match, return a 304 Not modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).")
        protected StringType ifNoneMatch;
        @Child(name="ifModifiedSince", type={InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing update contention", formalDefinition="Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).")
        protected InstantType ifModifiedSince;
        @Child(name="ifMatch", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing update contention", formalDefinition="Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).")
        protected StringType ifMatch;
        @Child(name="ifNoneExist", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For conditional creates", formalDefinition="Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").")
        protected StringType ifNoneExist;
        private static final long serialVersionUID = -1349769744L;

        public BundleEntryRequestComponent() {
        }

        public BundleEntryRequestComponent(Enumeration<HTTPVerb> method, UriType url) {
            this.method = method;
            this.url = url;
        }

        public Enumeration<HTTPVerb> getMethodElement() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory());
                }
            }
            return this.method;
        }

        public boolean hasMethodElement() {
            return this.method != null && !this.method.isEmpty();
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public BundleEntryRequestComponent setMethodElement(Enumeration<HTTPVerb> value) {
            this.method = value;
            return this;
        }

        public HTTPVerb getMethod() {
            return this.method == null ? null : (HTTPVerb)((Object)this.method.getValue());
        }

        public BundleEntryRequestComponent setMethod(HTTPVerb value) {
            if (this.method == null) {
                this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory());
            }
            this.method.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public BundleEntryRequestComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public BundleEntryRequestComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public StringType getIfNoneMatchElement() {
            if (this.ifNoneMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifNoneMatch = new StringType();
                }
            }
            return this.ifNoneMatch;
        }

        public boolean hasIfNoneMatchElement() {
            return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        public boolean hasIfNoneMatch() {
            return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        public BundleEntryRequestComponent setIfNoneMatchElement(StringType value) {
            this.ifNoneMatch = value;
            return this;
        }

        public String getIfNoneMatch() {
            return this.ifNoneMatch == null ? null : (String)this.ifNoneMatch.getValue();
        }

        public BundleEntryRequestComponent setIfNoneMatch(String value) {
            if (Utilities.noString(value)) {
                this.ifNoneMatch = null;
            } else {
                if (this.ifNoneMatch == null) {
                    this.ifNoneMatch = new StringType();
                }
                this.ifNoneMatch.setValue(value);
            }
            return this;
        }

        public InstantType getIfModifiedSinceElement() {
            if (this.ifModifiedSince == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifModifiedSince");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifModifiedSince = new InstantType();
                }
            }
            return this.ifModifiedSince;
        }

        public boolean hasIfModifiedSinceElement() {
            return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        public boolean hasIfModifiedSince() {
            return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        public BundleEntryRequestComponent setIfModifiedSinceElement(InstantType value) {
            this.ifModifiedSince = value;
            return this;
        }

        public Date getIfModifiedSince() {
            return this.ifModifiedSince == null ? null : (Date)this.ifModifiedSince.getValue();
        }

        public BundleEntryRequestComponent setIfModifiedSince(Date value) {
            if (value == null) {
                this.ifModifiedSince = null;
            } else {
                if (this.ifModifiedSince == null) {
                    this.ifModifiedSince = new InstantType();
                }
                this.ifModifiedSince.setValue(value);
            }
            return this;
        }

        public StringType getIfMatchElement() {
            if (this.ifMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifMatch = new StringType();
                }
            }
            return this.ifMatch;
        }

        public boolean hasIfMatchElement() {
            return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        public boolean hasIfMatch() {
            return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        public BundleEntryRequestComponent setIfMatchElement(StringType value) {
            this.ifMatch = value;
            return this;
        }

        public String getIfMatch() {
            return this.ifMatch == null ? null : (String)this.ifMatch.getValue();
        }

        public BundleEntryRequestComponent setIfMatch(String value) {
            if (Utilities.noString(value)) {
                this.ifMatch = null;
            } else {
                if (this.ifMatch == null) {
                    this.ifMatch = new StringType();
                }
                this.ifMatch.setValue(value);
            }
            return this;
        }

        public StringType getIfNoneExistElement() {
            if (this.ifNoneExist == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneExist");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifNoneExist = new StringType();
                }
            }
            return this.ifNoneExist;
        }

        public boolean hasIfNoneExistElement() {
            return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        public boolean hasIfNoneExist() {
            return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        public BundleEntryRequestComponent setIfNoneExistElement(StringType value) {
            this.ifNoneExist = value;
            return this;
        }

        public String getIfNoneExist() {
            return this.ifNoneExist == null ? null : (String)this.ifNoneExist.getValue();
        }

        public BundleEntryRequestComponent setIfNoneExist(String value) {
            if (Utilities.noString(value)) {
                this.ifNoneExist = null;
            } else {
                if (this.ifNoneExist == null) {
                    this.ifNoneExist = new StringType();
                }
                this.ifNoneExist.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("method", "code", "The HTTP verb for this entry in either a change history, or a transaction/ transaction response.", 0, Integer.MAX_VALUE, this.method));
            childrenList.add(new Property("url", "uri", "The URL for this entry, relative to the root (the address to which the request is posted).", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("ifNoneMatch", "string", "If the ETag values match, return a 304 Not modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, Integer.MAX_VALUE, this.ifNoneMatch));
            childrenList.add(new Property("ifModifiedSince", "instant", "Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, Integer.MAX_VALUE, this.ifModifiedSince));
            childrenList.add(new Property("ifMatch", "string", "Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).", 0, Integer.MAX_VALUE, this.ifMatch));
            childrenList.add(new Property("ifNoneExist", "string", "Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").", 0, Integer.MAX_VALUE, this.ifNoneExist));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.method;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 171868368: {
                    Base[] baseArray;
                    if (this.ifNoneMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.ifNoneMatch;
                    }
                    return baseArray;
                }
                case -2061602860: {
                    Base[] baseArray;
                    if (this.ifModifiedSince == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.ifModifiedSince;
                    }
                    return baseArray;
                }
                case 1692894888: {
                    Base[] baseArray;
                    if (this.ifMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.ifMatch;
                    }
                    return baseArray;
                }
                case 165155330: {
                    Base[] baseArray;
                    if (this.ifNoneExist == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.ifNoneExist;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    this.method = new HTTPVerbEnumFactory().fromType(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case 171868368: {
                    this.ifNoneMatch = this.castToString(value);
                    break;
                }
                case -2061602860: {
                    this.ifModifiedSince = this.castToInstant(value);
                    break;
                }
                case 1692894888: {
                    this.ifMatch = this.castToString(value);
                    break;
                }
                case 165155330: {
                    this.ifNoneExist = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("method")) {
                this.method = new HTTPVerbEnumFactory().fromType(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("ifNoneMatch")) {
                this.ifNoneMatch = this.castToString(value);
            } else if (name.equals("ifModifiedSince")) {
                this.ifModifiedSince = this.castToInstant(value);
            } else if (name.equals("ifMatch")) {
                this.ifMatch = this.castToString(value);
            } else if (name.equals("ifNoneExist")) {
                this.ifNoneExist = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    throw new FHIRException("Cannot make property method as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case 171868368: {
                    throw new FHIRException("Cannot make property ifNoneMatch as it is not a complex type");
                }
                case -2061602860: {
                    throw new FHIRException("Cannot make property ifModifiedSince as it is not a complex type");
                }
                case 1692894888: {
                    throw new FHIRException("Cannot make property ifMatch as it is not a complex type");
                }
                case 165155330: {
                    throw new FHIRException("Cannot make property ifNoneExist as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("method")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.method");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.url");
            }
            if (name.equals("ifNoneMatch")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.ifNoneMatch");
            }
            if (name.equals("ifModifiedSince")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.ifModifiedSince");
            }
            if (name.equals("ifMatch")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.ifMatch");
            }
            if (name.equals("ifNoneExist")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.ifNoneExist");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryRequestComponent copy() {
            BundleEntryRequestComponent dst = new BundleEntryRequestComponent();
            this.copyValues(dst);
            dst.method = this.method == null ? null : this.method.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.ifNoneMatch = this.ifNoneMatch == null ? null : this.ifNoneMatch.copy();
            dst.ifModifiedSince = this.ifModifiedSince == null ? null : this.ifModifiedSince.copy();
            dst.ifMatch = this.ifMatch == null ? null : this.ifMatch.copy();
            dst.ifNoneExist = this.ifNoneExist == null ? null : this.ifNoneExist.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BundleEntryRequestComponent)) {
                return false;
            }
            BundleEntryRequestComponent o = (BundleEntryRequestComponent)other;
            return BundleEntryRequestComponent.compareDeep(this.method, o.method, true) && BundleEntryRequestComponent.compareDeep(this.url, o.url, true) && BundleEntryRequestComponent.compareDeep(this.ifNoneMatch, o.ifNoneMatch, true) && BundleEntryRequestComponent.compareDeep(this.ifModifiedSince, o.ifModifiedSince, true) && BundleEntryRequestComponent.compareDeep(this.ifMatch, o.ifMatch, true) && BundleEntryRequestComponent.compareDeep(this.ifNoneExist, o.ifNoneExist, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BundleEntryRequestComponent)) {
                return false;
            }
            BundleEntryRequestComponent o = (BundleEntryRequestComponent)other;
            return BundleEntryRequestComponent.compareValues(this.method, o.method, true) && BundleEntryRequestComponent.compareValues(this.url, o.url, true) && BundleEntryRequestComponent.compareValues(this.ifNoneMatch, o.ifNoneMatch, true) && BundleEntryRequestComponent.compareValues(this.ifModifiedSince, o.ifModifiedSince, true) && BundleEntryRequestComponent.compareValues(this.ifMatch, o.ifMatch, true) && BundleEntryRequestComponent.compareValues(this.ifNoneExist, o.ifNoneExist, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.method != null && !this.method.isEmpty() || this.url != null && !this.url.isEmpty() || this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty() || this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty() || this.ifMatch != null && !this.ifMatch.isEmpty() || this.ifNoneExist != null && !this.ifNoneExist.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.request";
        }
    }

    @Block
    public static class BundleEntrySearchComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="match | include | outcome - why this is in the result set", formalDefinition="Why this entry is in the result set - whether it's included as a match or because of an _include requirement.")
        protected Enumeration<SearchEntryMode> mode;
        @Child(name="score", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search ranking (between 0 and 1)", formalDefinition="When searching, the server's search ranking score for the entry.")
        protected DecimalType score;
        private static final long serialVersionUID = 837739866L;

        public Enumeration<SearchEntryMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntrySearchComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public BundleEntrySearchComponent setModeElement(Enumeration<SearchEntryMode> value) {
            this.mode = value;
            return this;
        }

        public SearchEntryMode getMode() {
            return this.mode == null ? null : (SearchEntryMode)((Object)this.mode.getValue());
        }

        public BundleEntrySearchComponent setMode(SearchEntryMode value) {
            if (value == null) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory());
                }
                this.mode.setValue((Object)value);
            }
            return this;
        }

        public DecimalType getScoreElement() {
            if (this.score == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntrySearchComponent.score");
                }
                if (Configuration.doAutoCreate()) {
                    this.score = new DecimalType();
                }
            }
            return this.score;
        }

        public boolean hasScoreElement() {
            return this.score != null && !this.score.isEmpty();
        }

        public boolean hasScore() {
            return this.score != null && !this.score.isEmpty();
        }

        public BundleEntrySearchComponent setScoreElement(DecimalType value) {
            this.score = value;
            return this;
        }

        public BigDecimal getScore() {
            return this.score == null ? null : (BigDecimal)this.score.getValue();
        }

        public BundleEntrySearchComponent setScore(BigDecimal value) {
            if (value == null) {
                this.score = null;
            } else {
                if (this.score == null) {
                    this.score = new DecimalType();
                }
                this.score.setValue(value);
            }
            return this;
        }

        public BundleEntrySearchComponent setScore(long value) {
            this.score = new DecimalType();
            this.score.setValue(value);
            return this;
        }

        public BundleEntrySearchComponent setScore(double value) {
            this.score = new DecimalType();
            this.score.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("mode", "code", "Why this entry is in the result set - whether it's included as a match or because of an _include requirement.", 0, Integer.MAX_VALUE, this.mode));
            childrenList.add(new Property("score", "decimal", "When searching, the server's search ranking score for the entry.", 0, Integer.MAX_VALUE, this.score));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 109264530: {
                    Base[] baseArray;
                    if (this.score == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.score;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    this.mode = new SearchEntryModeEnumFactory().fromType(value);
                    break;
                }
                case 109264530: {
                    this.score = this.castToDecimal(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = new SearchEntryModeEnumFactory().fromType(value);
            } else if (name.equals("score")) {
                this.score = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    throw new FHIRException("Cannot make property mode as it is not a complex type");
                }
                case 109264530: {
                    throw new FHIRException("Cannot make property score as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.mode");
            }
            if (name.equals("score")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.score");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntrySearchComponent copy() {
            BundleEntrySearchComponent dst = new BundleEntrySearchComponent();
            this.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.score = this.score == null ? null : this.score.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BundleEntrySearchComponent)) {
                return false;
            }
            BundleEntrySearchComponent o = (BundleEntrySearchComponent)other;
            return BundleEntrySearchComponent.compareDeep(this.mode, o.mode, true) && BundleEntrySearchComponent.compareDeep(this.score, o.score, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BundleEntrySearchComponent)) {
                return false;
            }
            BundleEntrySearchComponent o = (BundleEntrySearchComponent)other;
            return BundleEntrySearchComponent.compareValues(this.mode, o.mode, true) && BundleEntrySearchComponent.compareValues(this.score, o.score, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.score != null && !this.score.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.search";
        }
    }

    @Block
    public static class BundleEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="link", type={BundleLinkComponent.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Links related to this entry", formalDefinition="A series of links that provide context to this entry.")
        protected List<BundleLinkComponent> link;
        @Child(name="fullUrl", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Absolute URL for resource (server address, or UUID/OID)", formalDefinition="The Absolute URL for the resource.  The fullUrl SHALL not disagree with the id in the resource. The fullUrl is a version independent reference to the resource. The fullUrl element SHALL have a value except that: \n* fullUrl can be empty on a POST (although it does not need to when specifying a temporary id for reference in the bundle)\n* Results from operations might involve resources that are not identified.")
        protected UriType fullUrl;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A resource in the bundle", formalDefinition="The Resources for the entry.")
        protected Resource resource;
        @Child(name="search", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search related information", formalDefinition="Information about the search process that lead to the creation of this entry.")
        protected BundleEntrySearchComponent search;
        @Child(name="request", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Transaction Related Information", formalDefinition="Additional information about how this entry should be processed as part of a transaction.")
        protected BundleEntryRequestComponent request;
        @Child(name="response", type={}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Transaction Related Information", formalDefinition="Additional information about how this entry should be processed as part of a transaction.")
        protected BundleEntryResponseComponent response;
        private static final long serialVersionUID = 517783054L;

        public List<BundleLinkComponent> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            return this.link;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (BundleLinkComponent item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BundleLinkComponent addLink() {
            BundleLinkComponent t = new BundleLinkComponent();
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            this.link.add(t);
            return t;
        }

        public BundleEntryComponent addLink(BundleLinkComponent t) {
            if (t == null) {
                return this;
            }
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            this.link.add(t);
            return this;
        }

        public UriType getFullUrlElement() {
            if (this.fullUrl == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.fullUrl");
                }
                if (Configuration.doAutoCreate()) {
                    this.fullUrl = new UriType();
                }
            }
            return this.fullUrl;
        }

        public boolean hasFullUrlElement() {
            return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        public boolean hasFullUrl() {
            return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        public BundleEntryComponent setFullUrlElement(UriType value) {
            this.fullUrl = value;
            return this;
        }

        public String getFullUrl() {
            return this.fullUrl == null ? null : (String)this.fullUrl.getValue();
        }

        public BundleEntryComponent setFullUrl(String value) {
            if (Utilities.noString(value)) {
                this.fullUrl = null;
            } else {
                if (this.fullUrl == null) {
                    this.fullUrl = new UriType();
                }
                this.fullUrl.setValue(value);
            }
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public BundleEntryComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public BundleEntrySearchComponent getSearch() {
            if (this.search == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.search");
                }
                if (Configuration.doAutoCreate()) {
                    this.search = new BundleEntrySearchComponent();
                }
            }
            return this.search;
        }

        public boolean hasSearch() {
            return this.search != null && !this.search.isEmpty();
        }

        public BundleEntryComponent setSearch(BundleEntrySearchComponent value) {
            this.search = value;
            return this;
        }

        public BundleEntryRequestComponent getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new BundleEntryRequestComponent();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public BundleEntryComponent setRequest(BundleEntryRequestComponent value) {
            this.request = value;
            return this;
        }

        public BundleEntryResponseComponent getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new BundleEntryResponseComponent();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public BundleEntryComponent setResponse(BundleEntryResponseComponent value) {
            this.response = value;
            return this;
        }

        public BundleLinkComponent getLink(String theRelation) {
            Validate.notBlank(theRelation, "theRelation may not be null or empty", new Object[0]);
            for (BundleLinkComponent next : this.getLink()) {
                if (!theRelation.equals(next.getRelation())) continue;
                return next;
            }
            return null;
        }

        public BundleLinkComponent getLinkOrCreate(String theRelation) {
            Validate.notBlank(theRelation, "theRelation may not be null or empty", new Object[0]);
            for (BundleLinkComponent next : this.getLink()) {
                if (!theRelation.equals(next.getRelation())) continue;
                return next;
            }
            BundleLinkComponent retVal = new BundleLinkComponent();
            retVal.setRelation(theRelation);
            this.getLink().add(retVal);
            return retVal;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("link", "@Bundle.link", "A series of links that provide context to this entry.", 0, Integer.MAX_VALUE, this.link));
            childrenList.add(new Property("fullUrl", "uri", "The Absolute URL for the resource.  The fullUrl SHALL not disagree with the id in the resource. The fullUrl is a version independent reference to the resource. The fullUrl element SHALL have a value except that: \n* fullUrl can be empty on a POST (although it does not need to when specifying a temporary id for reference in the bundle)\n* Results from operations might involve resources that are not identified.", 0, Integer.MAX_VALUE, this.fullUrl));
            childrenList.add(new Property("resource", "Resource", "The Resources for the entry.", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("search", "", "Information about the search process that lead to the creation of this entry.", 0, Integer.MAX_VALUE, this.search));
            childrenList.add(new Property("request", "", "Additional information about how this entry should be processed as part of a transaction.", 0, Integer.MAX_VALUE, this.request));
            childrenList.add(new Property("response", "", "Additional information about how this entry should be processed as part of a transaction.", 0, Integer.MAX_VALUE, this.response));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
                case -511251360: {
                    Base[] baseArray;
                    if (this.fullUrl == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.fullUrl;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case -906336856: {
                    Base[] baseArray;
                    if (this.search == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.search;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.request;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.response;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    this.getLink().add((BundleLinkComponent)value);
                    break;
                }
                case -511251360: {
                    this.fullUrl = this.castToUri(value);
                    break;
                }
                case -341064690: {
                    this.resource = this.castToResource(value);
                    break;
                }
                case -906336856: {
                    this.search = (BundleEntrySearchComponent)value;
                    break;
                }
                case 1095692943: {
                    this.request = (BundleEntryRequestComponent)value;
                    break;
                }
                case -340323263: {
                    this.response = (BundleEntryResponseComponent)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("link")) {
                this.getLink().add((BundleLinkComponent)value);
            } else if (name.equals("fullUrl")) {
                this.fullUrl = this.castToUri(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToResource(value);
            } else if (name.equals("search")) {
                this.search = (BundleEntrySearchComponent)value;
            } else if (name.equals("request")) {
                this.request = (BundleEntryRequestComponent)value;
            } else if (name.equals("response")) {
                this.response = (BundleEntryResponseComponent)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.addLink();
                }
                case -511251360: {
                    throw new FHIRException("Cannot make property fullUrl as it is not a complex type");
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case -906336856: {
                    return this.getSearch();
                }
                case 1095692943: {
                    return this.getRequest();
                }
                case -340323263: {
                    return this.getResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("link")) {
                return this.addLink();
            }
            if (name.equals("fullUrl")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.fullUrl");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type Bundle.resource");
            }
            if (name.equals("search")) {
                this.search = new BundleEntrySearchComponent();
                return this.search;
            }
            if (name.equals("request")) {
                this.request = new BundleEntryRequestComponent();
                return this.request;
            }
            if (name.equals("response")) {
                this.response = new BundleEntryResponseComponent();
                return this.response;
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryComponent copy() {
            BundleEntryComponent dst = new BundleEntryComponent();
            this.copyValues(dst);
            if (this.link != null) {
                dst.link = new ArrayList<BundleLinkComponent>();
                for (BundleLinkComponent i : this.link) {
                    dst.link.add(i.copy());
                }
            }
            dst.fullUrl = this.fullUrl == null ? null : this.fullUrl.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.search = this.search == null ? null : this.search.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.response = this.response == null ? null : this.response.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BundleEntryComponent)) {
                return false;
            }
            BundleEntryComponent o = (BundleEntryComponent)other;
            return BundleEntryComponent.compareDeep(this.link, o.link, true) && BundleEntryComponent.compareDeep(this.fullUrl, o.fullUrl, true) && BundleEntryComponent.compareDeep(this.resource, o.resource, true) && BundleEntryComponent.compareDeep(this.search, o.search, true) && BundleEntryComponent.compareDeep(this.request, o.request, true) && BundleEntryComponent.compareDeep(this.response, o.response, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BundleEntryComponent)) {
                return false;
            }
            BundleEntryComponent o = (BundleEntryComponent)other;
            return BundleEntryComponent.compareValues(this.fullUrl, o.fullUrl, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.link != null && !this.link.isEmpty() || this.fullUrl != null && !this.fullUrl.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.search != null && !this.search.isEmpty() || this.request != null && !this.request.isEmpty() || this.response != null && !this.response.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Bundle.entry";
        }
    }

    @Block
    public static class BundleLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relation", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="http://www.iana.org/assignments/link-relations/link-relations.xhtml", formalDefinition="A name which details the functional use for this link - see [[http://www.iana.org/assignments/link-relations/link-relations.xhtml]].")
        protected StringType relation;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference details for the link", formalDefinition="The reference details for the link.")
        protected UriType url;
        private static final long serialVersionUID = -1010386066L;

        public BundleLinkComponent() {
        }

        public BundleLinkComponent(StringType relation, UriType url) {
            this.relation = relation;
            this.url = url;
        }

        public StringType getRelationElement() {
            if (this.relation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleLinkComponent.relation");
                }
                if (Configuration.doAutoCreate()) {
                    this.relation = new StringType();
                }
            }
            return this.relation;
        }

        public boolean hasRelationElement() {
            return this.relation != null && !this.relation.isEmpty();
        }

        public boolean hasRelation() {
            return this.relation != null && !this.relation.isEmpty();
        }

        public BundleLinkComponent setRelationElement(StringType value) {
            this.relation = value;
            return this;
        }

        public String getRelation() {
            return this.relation == null ? null : (String)this.relation.getValue();
        }

        public BundleLinkComponent setRelation(String value) {
            if (this.relation == null) {
                this.relation = new StringType();
            }
            this.relation.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleLinkComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public BundleLinkComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public BundleLinkComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("relation", "string", "A name which details the functional use for this link - see [[http://www.iana.org/assignments/link-relations/link-relations.xhtml]].", 0, Integer.MAX_VALUE, this.relation));
            childrenList.add(new Property("url", "uri", "The reference details for the link.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    Base[] baseArray;
                    if (this.relation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relation;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    this.relation = this.castToString(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relation")) {
                this.relation = this.castToString(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    throw new FHIRException("Cannot make property relation as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.relation");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type Bundle.url");
            }
            return super.addChild(name);
        }

        @Override
        public BundleLinkComponent copy() {
            BundleLinkComponent dst = new BundleLinkComponent();
            this.copyValues(dst);
            dst.relation = this.relation == null ? null : this.relation.copy();
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof BundleLinkComponent)) {
                return false;
            }
            BundleLinkComponent o = (BundleLinkComponent)other;
            return BundleLinkComponent.compareDeep(this.relation, o.relation, true) && BundleLinkComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof BundleLinkComponent)) {
                return false;
            }
            BundleLinkComponent o = (BundleLinkComponent)other;
            return BundleLinkComponent.compareValues(this.relation, o.relation, true) && BundleLinkComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.relation != null && !this.relation.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Bundle.link";
        }
    }

    public static class HTTPVerbEnumFactory
    implements EnumFactory<HTTPVerb> {
        @Override
        public HTTPVerb fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return HTTPVerb.GET;
            }
            if ("POST".equals(codeString)) {
                return HTTPVerb.POST;
            }
            if ("PUT".equals(codeString)) {
                return HTTPVerb.PUT;
            }
            if ("DELETE".equals(codeString)) {
                return HTTPVerb.DELETE;
            }
            throw new IllegalArgumentException("Unknown HTTPVerb code '" + codeString + "'");
        }

        public Enumeration<HTTPVerb> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.GET);
            }
            if ("POST".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.POST);
            }
            if ("PUT".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.PUT);
            }
            if ("DELETE".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.DELETE);
            }
            throw new FHIRException("Unknown HTTPVerb code '" + codeString + "'");
        }

        @Override
        public String toCode(HTTPVerb code) {
            if (code == HTTPVerb.GET) {
                return "GET";
            }
            if (code == HTTPVerb.POST) {
                return "POST";
            }
            if (code == HTTPVerb.PUT) {
                return "PUT";
            }
            if (code == HTTPVerb.DELETE) {
                return "DELETE";
            }
            return "?";
        }

        @Override
        public String toSystem(HTTPVerb code) {
            return code.getSystem();
        }
    }

    public static enum HTTPVerb {
        GET,
        POST,
        PUT,
        DELETE,
        NULL;


        public static HTTPVerb fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return GET;
            }
            if ("POST".equals(codeString)) {
                return POST;
            }
            if ("PUT".equals(codeString)) {
                return PUT;
            }
            if ("DELETE".equals(codeString)) {
                return DELETE;
            }
            throw new FHIRException("Unknown HTTPVerb code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GET: {
                    return "GET";
                }
                case POST: {
                    return "POST";
                }
                case PUT: {
                    return "PUT";
                }
                case DELETE: {
                    return "DELETE";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GET: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case POST: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case PUT: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/http-verb";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GET: {
                    return "HTTP GET";
                }
                case POST: {
                    return "HTTP POST";
                }
                case PUT: {
                    return "HTTP PUT";
                }
                case DELETE: {
                    return "HTTP DELETE";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GET: {
                    return "GET";
                }
                case POST: {
                    return "POST";
                }
                case PUT: {
                    return "PUT";
                }
                case DELETE: {
                    return "DELETE";
                }
            }
            return "?";
        }
    }

    public static class SearchEntryModeEnumFactory
    implements EnumFactory<SearchEntryMode> {
        @Override
        public SearchEntryMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("match".equals(codeString)) {
                return SearchEntryMode.MATCH;
            }
            if ("include".equals(codeString)) {
                return SearchEntryMode.INCLUDE;
            }
            if ("outcome".equals(codeString)) {
                return SearchEntryMode.OUTCOME;
            }
            throw new IllegalArgumentException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        public Enumeration<SearchEntryMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("match".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.MATCH);
            }
            if ("include".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.INCLUDE);
            }
            if ("outcome".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.OUTCOME);
            }
            throw new FHIRException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchEntryMode code) {
            if (code == SearchEntryMode.MATCH) {
                return "match";
            }
            if (code == SearchEntryMode.INCLUDE) {
                return "include";
            }
            if (code == SearchEntryMode.OUTCOME) {
                return "outcome";
            }
            return "?";
        }

        @Override
        public String toSystem(SearchEntryMode code) {
            return code.getSystem();
        }
    }

    public static enum SearchEntryMode {
        MATCH,
        INCLUDE,
        OUTCOME,
        NULL;


        public static SearchEntryMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("match".equals(codeString)) {
                return MATCH;
            }
            if ("include".equals(codeString)) {
                return INCLUDE;
            }
            if ("outcome".equals(codeString)) {
                return OUTCOME;
            }
            throw new FHIRException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MATCH: {
                    return "match";
                }
                case INCLUDE: {
                    return "include";
                }
                case OUTCOME: {
                    return "outcome";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MATCH: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case INCLUDE: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case OUTCOME: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MATCH: {
                    return "This resource matched the search specification.";
                }
                case INCLUDE: {
                    return "This resource is returned because it is referred to from another resource in the search set.";
                }
                case OUTCOME: {
                    return "An OperationOutcome that provides additional information about the processing of a search.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MATCH: {
                    return "Match";
                }
                case INCLUDE: {
                    return "Include";
                }
                case OUTCOME: {
                    return "Outcome";
                }
            }
            return "?";
        }
    }

    public static class BundleTypeEnumFactory
    implements EnumFactory<BundleType> {
        @Override
        public BundleType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("document".equals(codeString)) {
                return BundleType.DOCUMENT;
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return BundleType.MESSAGE;
            }
            if ("transaction".equals(codeString)) {
                return BundleType.TRANSACTION;
            }
            if ("transaction-response".equals(codeString)) {
                return BundleType.TRANSACTIONRESPONSE;
            }
            if ("batch".equals(codeString)) {
                return BundleType.BATCH;
            }
            if ("batch-response".equals(codeString)) {
                return BundleType.BATCHRESPONSE;
            }
            if ("history".equals(codeString)) {
                return BundleType.HISTORY;
            }
            if ("searchset".equals(codeString)) {
                return BundleType.SEARCHSET;
            }
            if ("collection".equals(codeString)) {
                return BundleType.COLLECTION;
            }
            throw new IllegalArgumentException("Unknown BundleType code '" + codeString + "'");
        }

        public Enumeration<BundleType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("document".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.DOCUMENT);
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.MESSAGE);
            }
            if ("transaction".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.TRANSACTION);
            }
            if ("transaction-response".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.TRANSACTIONRESPONSE);
            }
            if ("batch".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.BATCH);
            }
            if ("batch-response".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.BATCHRESPONSE);
            }
            if ("history".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.HISTORY);
            }
            if ("searchset".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.SEARCHSET);
            }
            if ("collection".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.COLLECTION);
            }
            throw new FHIRException("Unknown BundleType code '" + codeString + "'");
        }

        @Override
        public String toCode(BundleType code) {
            if (code == BundleType.DOCUMENT) {
                return "document";
            }
            if (code == BundleType.MESSAGE) {
                return Bundle.SP_MESSAGE;
            }
            if (code == BundleType.TRANSACTION) {
                return "transaction";
            }
            if (code == BundleType.TRANSACTIONRESPONSE) {
                return "transaction-response";
            }
            if (code == BundleType.BATCH) {
                return "batch";
            }
            if (code == BundleType.BATCHRESPONSE) {
                return "batch-response";
            }
            if (code == BundleType.HISTORY) {
                return "history";
            }
            if (code == BundleType.SEARCHSET) {
                return "searchset";
            }
            if (code == BundleType.COLLECTION) {
                return "collection";
            }
            return "?";
        }

        @Override
        public String toSystem(BundleType code) {
            return code.getSystem();
        }
    }

    public static enum BundleType {
        DOCUMENT,
        MESSAGE,
        TRANSACTION,
        TRANSACTIONRESPONSE,
        BATCH,
        BATCHRESPONSE,
        HISTORY,
        SEARCHSET,
        COLLECTION,
        NULL;


        public static BundleType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("document".equals(codeString)) {
                return DOCUMENT;
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return MESSAGE;
            }
            if ("transaction".equals(codeString)) {
                return TRANSACTION;
            }
            if ("transaction-response".equals(codeString)) {
                return TRANSACTIONRESPONSE;
            }
            if ("batch".equals(codeString)) {
                return BATCH;
            }
            if ("batch-response".equals(codeString)) {
                return BATCHRESPONSE;
            }
            if ("history".equals(codeString)) {
                return HISTORY;
            }
            if ("searchset".equals(codeString)) {
                return SEARCHSET;
            }
            if ("collection".equals(codeString)) {
                return COLLECTION;
            }
            throw new FHIRException("Unknown BundleType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DOCUMENT: {
                    return "document";
                }
                case MESSAGE: {
                    return Bundle.SP_MESSAGE;
                }
                case TRANSACTION: {
                    return "transaction";
                }
                case TRANSACTIONRESPONSE: {
                    return "transaction-response";
                }
                case BATCH: {
                    return "batch";
                }
                case BATCHRESPONSE: {
                    return "batch-response";
                }
                case HISTORY: {
                    return "history";
                }
                case SEARCHSET: {
                    return "searchset";
                }
                case COLLECTION: {
                    return "collection";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DOCUMENT: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case MESSAGE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case TRANSACTION: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case TRANSACTIONRESPONSE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case BATCH: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case BATCHRESPONSE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case HISTORY: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case SEARCHSET: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case COLLECTION: {
                    return "http://hl7.org/fhir/bundle-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DOCUMENT: {
                    return "The bundle is a document. The first resource is a Composition.";
                }
                case MESSAGE: {
                    return "The bundle is a message. The first resource is a MessageHeader.";
                }
                case TRANSACTION: {
                    return "The bundle is a transaction - intended to be processed by a server as an atomic commit.";
                }
                case TRANSACTIONRESPONSE: {
                    return "The bundle is a transaction response. Because the response is a transaction response, the transactionhas succeeded, and all responses are error free.";
                }
                case BATCH: {
                    return "The bundle is a transaction - intended to be processed by a server as a group of actions.";
                }
                case BATCHRESPONSE: {
                    return "The bundle is a batch response. Note that as a batch, some responses may indicate failure and others success.";
                }
                case HISTORY: {
                    return "The bundle is a list of resources from a history interaction on a server.";
                }
                case SEARCHSET: {
                    return "The bundle is a list of resources returned as a result of a search/query interaction, operation, or message.";
                }
                case COLLECTION: {
                    return "The bundle is a set of resources collected into a single document for ease of distribution.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DOCUMENT: {
                    return "Document";
                }
                case MESSAGE: {
                    return "Message";
                }
                case TRANSACTION: {
                    return "Transaction";
                }
                case TRANSACTIONRESPONSE: {
                    return "Transaction Response";
                }
                case BATCH: {
                    return "Batch";
                }
                case BATCHRESPONSE: {
                    return "Batch Response";
                }
                case HISTORY: {
                    return "History List";
                }
                case SEARCHSET: {
                    return "Search Results";
                }
                case COLLECTION: {
                    return "Collection";
                }
            }
            return "?";
        }
    }
}

