/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Appointment;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.HealthcareService;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AppointmentResponse", profile="http://hl7.org/fhir/Profile/AppointmentResponse")
public class AppointmentResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.")
    protected List<Identifier> identifier;
    @Child(name="appointment", type={Appointment.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Appointment this response relates to", formalDefinition="Appointment that this response is replying to.")
    protected Reference appointment;
    protected Appointment appointmentTarget;
    @Child(name="start", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time from appointment, or requested new start time", formalDefinition="Date/Time that the appointment is to take place, or requested new start time.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time from appointment, or requested new end time", formalDefinition="This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.")
    protected InstantType end;
    @Child(name="participantType", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Role of participant in the appointment", formalDefinition="Role of participant in the appointment.")
    protected List<CodeableConcept> participantType;
    @Child(name="actor", type={Patient.class, Practitioner.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person, Location/HealthcareService or Device", formalDefinition="A Person, Location/HealthcareService or Device that is participating in the appointment.")
    protected Reference actor;
    protected Resource actorTarget;
    @Child(name="participantStatus", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="accepted | declined | tentative | in-process | completed | needs-action", formalDefinition="Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.")
    protected CodeType participantStatus;
    @Child(name="comment", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional comments", formalDefinition="Additional comments about the appointment.")
    protected StringType comment;
    private static final long serialVersionUID = -1645343660L;
    @SearchParamDefinition(name="patient", path="AppointmentResponse.actor", description="This Response is for this Patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AppointmentResponse:patient").toLocked();
    @SearchParamDefinition(name="practitioner", path="AppointmentResponse.actor", description="This Response is for this Practitioner", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("AppointmentResponse:practitioner").toLocked();
    @SearchParamDefinition(name="location", path="AppointmentResponse.actor", description="This Response is for this Location", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("AppointmentResponse:location").toLocked();
    @SearchParamDefinition(name="part-status", path="AppointmentResponse.participantStatus", description="The participants acceptance status for this appointment", type="token")
    public static final String SP_PART_STATUS = "part-status";
    public static final TokenClientParam PART_STATUS = new TokenClientParam("part-status");
    @SearchParamDefinition(name="actor", path="AppointmentResponse.actor", description="The Person, Location/HealthcareService or Device that this appointment response replies for", type="reference")
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("AppointmentResponse:actor").toLocked();
    @SearchParamDefinition(name="identifier", path="AppointmentResponse.identifier", description="An Identifier in this appointment response", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="appointment", path="AppointmentResponse.appointment", description="The appointment that the response is attached to", type="reference")
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("AppointmentResponse:appointment").toLocked();

    public AppointmentResponse() {
    }

    public AppointmentResponse(Reference appointment, CodeType participantStatus) {
        this.appointment = appointment;
        this.participantStatus = participantStatus;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AppointmentResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getAppointment() {
        if (this.appointment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointment = new Reference();
            }
        }
        return this.appointment;
    }

    public boolean hasAppointment() {
        return this.appointment != null && !this.appointment.isEmpty();
    }

    public AppointmentResponse setAppointment(Reference value) {
        this.appointment = value;
        return this;
    }

    public Appointment getAppointmentTarget() {
        if (this.appointmentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentTarget = new Appointment();
            }
        }
        return this.appointmentTarget;
    }

    public AppointmentResponse setAppointmentTarget(Appointment value) {
        this.appointmentTarget = value;
        return this;
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public AppointmentResponse setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public AppointmentResponse setStart(Date value) {
        if (value == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new InstantType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public AppointmentResponse setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public AppointmentResponse setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getParticipantType() {
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        return this.participantType;
    }

    public boolean hasParticipantType() {
        if (this.participantType == null) {
            return false;
        }
        for (CodeableConcept item : this.participantType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addParticipantType() {
        CodeableConcept t = new CodeableConcept();
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        this.participantType.add(t);
        return t;
    }

    public AppointmentResponse addParticipantType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.participantType == null) {
            this.participantType = new ArrayList<CodeableConcept>();
        }
        this.participantType.add(t);
        return this;
    }

    public Reference getActor() {
        if (this.actor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.actor");
            }
            if (Configuration.doAutoCreate()) {
                this.actor = new Reference();
            }
        }
        return this.actor;
    }

    public boolean hasActor() {
        return this.actor != null && !this.actor.isEmpty();
    }

    public AppointmentResponse setActor(Reference value) {
        this.actor = value;
        return this;
    }

    public Resource getActorTarget() {
        return this.actorTarget;
    }

    public AppointmentResponse setActorTarget(Resource value) {
        this.actorTarget = value;
        return this;
    }

    public CodeType getParticipantStatusElement() {
        if (this.participantStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.participantStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.participantStatus = new CodeType();
            }
        }
        return this.participantStatus;
    }

    public boolean hasParticipantStatusElement() {
        return this.participantStatus != null && !this.participantStatus.isEmpty();
    }

    public boolean hasParticipantStatus() {
        return this.participantStatus != null && !this.participantStatus.isEmpty();
    }

    public AppointmentResponse setParticipantStatusElement(CodeType value) {
        this.participantStatus = value;
        return this;
    }

    public String getParticipantStatus() {
        return this.participantStatus == null ? null : (String)this.participantStatus.getValue();
    }

    public AppointmentResponse setParticipantStatus(String value) {
        if (this.participantStatus == null) {
            this.participantStatus = new CodeType();
        }
        this.participantStatus.setValue(value);
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AppointmentResponse.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public AppointmentResponse setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public AppointmentResponse setComment(String value) {
        if (Utilities.noString(value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_APPOINTMENT, "Reference(Appointment)", "Appointment that this response is replying to.", 0, Integer.MAX_VALUE, this.appointment));
        childrenList.add(new Property("start", "instant", "Date/Time that the appointment is to take place, or requested new start time.", 0, Integer.MAX_VALUE, this.start));
        childrenList.add(new Property("end", "instant", "This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.", 0, Integer.MAX_VALUE, this.end));
        childrenList.add(new Property("participantType", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.participantType));
        childrenList.add(new Property(SP_ACTOR, "Reference(Patient|Practitioner|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location/HealthcareService or Device that is participating in the appointment.", 0, Integer.MAX_VALUE, this.actor));
        childrenList.add(new Property("participantStatus", "code", "Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.", 0, Integer.MAX_VALUE, this.participantStatus));
        childrenList.add(new Property("comment", "string", "Additional comments about the appointment.", 0, Integer.MAX_VALUE, this.comment));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1474995297: {
                Base[] baseArray;
                if (this.appointment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.appointment;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.start;
                }
                return baseArray;
            }
            case 100571: {
                Base[] baseArray;
                if (this.end == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.end;
                }
                return baseArray;
            }
            case 841294093: {
                return this.participantType == null ? new Base[]{} : this.participantType.toArray(new Base[this.participantType.size()]);
            }
            case 92645877: {
                Base[] baseArray;
                if (this.actor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.actor;
                }
                return baseArray;
            }
            case 996096261: {
                Base[] baseArray;
                if (this.participantStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.participantStatus;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.comment;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1474995297: {
                this.appointment = this.castToReference(value);
                break;
            }
            case 109757538: {
                this.start = this.castToInstant(value);
                break;
            }
            case 100571: {
                this.end = this.castToInstant(value);
                break;
            }
            case 841294093: {
                this.getParticipantType().add(this.castToCodeableConcept(value));
                break;
            }
            case 92645877: {
                this.actor = this.castToReference(value);
                break;
            }
            case 996096261: {
                this.participantStatus = this.castToCode(value);
                break;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_APPOINTMENT)) {
            this.appointment = this.castToReference(value);
        } else if (name.equals("start")) {
            this.start = this.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = this.castToInstant(value);
        } else if (name.equals("participantType")) {
            this.getParticipantType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_ACTOR)) {
            this.actor = this.castToReference(value);
        } else if (name.equals("participantStatus")) {
            this.participantStatus = this.castToCode(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1474995297: {
                return this.getAppointment();
            }
            case 109757538: {
                throw new FHIRException("Cannot make property start as it is not a complex type");
            }
            case 100571: {
                throw new FHIRException("Cannot make property end as it is not a complex type");
            }
            case 841294093: {
                return this.addParticipantType();
            }
            case 92645877: {
                return this.getActor();
            }
            case 996096261: {
                throw new FHIRException("Cannot make property participantStatus as it is not a complex type");
            }
            case 950398559: {
                throw new FHIRException("Cannot make property comment as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_APPOINTMENT)) {
            this.appointment = new Reference();
            return this.appointment;
        }
        if (name.equals("start")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.end");
        }
        if (name.equals("participantType")) {
            return this.addParticipantType();
        }
        if (name.equals(SP_ACTOR)) {
            this.actor = new Reference();
            return this.actor;
        }
        if (name.equals("participantStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.participantStatus");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type AppointmentResponse.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AppointmentResponse";
    }

    @Override
    public AppointmentResponse copy() {
        AppointmentResponse dst = new AppointmentResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.appointment = this.appointment == null ? null : this.appointment.copy();
        dst.start = this.start == null ? null : this.start.copy();
        InstantType instantType = dst.end = this.end == null ? null : this.end.copy();
        if (this.participantType != null) {
            dst.participantType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.participantType) {
                dst.participantType.add(codeableConcept.copy());
            }
        }
        dst.actor = this.actor == null ? null : this.actor.copy();
        dst.participantStatus = this.participantStatus == null ? null : this.participantStatus.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        return dst;
    }

    protected AppointmentResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof AppointmentResponse)) {
            return false;
        }
        AppointmentResponse o = (AppointmentResponse)other;
        return AppointmentResponse.compareDeep(this.identifier, o.identifier, true) && AppointmentResponse.compareDeep(this.appointment, o.appointment, true) && AppointmentResponse.compareDeep(this.start, o.start, true) && AppointmentResponse.compareDeep(this.end, o.end, true) && AppointmentResponse.compareDeep(this.participantType, o.participantType, true) && AppointmentResponse.compareDeep(this.actor, o.actor, true) && AppointmentResponse.compareDeep(this.participantStatus, o.participantStatus, true) && AppointmentResponse.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof AppointmentResponse)) {
            return false;
        }
        AppointmentResponse o = (AppointmentResponse)other;
        return AppointmentResponse.compareValues(this.start, o.start, true) && AppointmentResponse.compareValues(this.end, o.end, true) && AppointmentResponse.compareValues(this.participantStatus, o.participantStatus, true) && AppointmentResponse.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.appointment != null && !this.appointment.isEmpty() || this.start != null && !this.start.isEmpty() || this.end != null && !this.end.isEmpty() || this.participantType != null && !this.participantType.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.participantStatus != null && !this.participantStatus.isEmpty() || this.comment != null && !this.comment.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AppointmentResponse;
    }
}

