/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigDecimal;
import org.hl7.fhir.dstu2016may.formats.JsonParserBase;
import org.hl7.fhir.dstu2016may.model.Account;
import org.hl7.fhir.dstu2016may.model.ActionDefinition;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Age;
import org.hl7.fhir.dstu2016may.model.AllergyIntolerance;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Appointment;
import org.hl7.fhir.dstu2016may.model.AppointmentResponse;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.AuditEvent;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.Basic;
import org.hl7.fhir.dstu2016may.model.Binary;
import org.hl7.fhir.dstu2016may.model.BodySite;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CarePlan;
import org.hl7.fhir.dstu2016may.model.CareTeam;
import org.hl7.fhir.dstu2016may.model.Claim;
import org.hl7.fhir.dstu2016may.model.ClaimResponse;
import org.hl7.fhir.dstu2016may.model.ClinicalImpression;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Communication;
import org.hl7.fhir.dstu2016may.model.CommunicationRequest;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.Composition;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Contract;
import org.hl7.fhir.dstu2016may.model.Count;
import org.hl7.fhir.dstu2016may.model.Coverage;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.DataRequirement;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DecisionSupportRule;
import org.hl7.fhir.dstu2016may.model.DecisionSupportServiceModule;
import org.hl7.fhir.dstu2016may.model.DetectedIssue;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DeviceComponent;
import org.hl7.fhir.dstu2016may.model.DeviceMetric;
import org.hl7.fhir.dstu2016may.model.DeviceUseRequest;
import org.hl7.fhir.dstu2016may.model.DeviceUseStatement;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DiagnosticReport;
import org.hl7.fhir.dstu2016may.model.Distance;
import org.hl7.fhir.dstu2016may.model.DocumentManifest;
import org.hl7.fhir.dstu2016may.model.DocumentReference;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.EligibilityRequest;
import org.hl7.fhir.dstu2016may.model.EligibilityResponse;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnrollmentRequest;
import org.hl7.fhir.dstu2016may.model.EnrollmentResponse;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.EpisodeOfCare;
import org.hl7.fhir.dstu2016may.model.ExpansionProfile;
import org.hl7.fhir.dstu2016may.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.ExtensionHelper;
import org.hl7.fhir.dstu2016may.model.FamilyMemberHistory;
import org.hl7.fhir.dstu2016may.model.Flag;
import org.hl7.fhir.dstu2016may.model.Goal;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.GuidanceResponse;
import org.hl7.fhir.dstu2016may.model.HealthcareService;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.ImagingExcerpt;
import org.hl7.fhir.dstu2016may.model.ImagingObjectSelection;
import org.hl7.fhir.dstu2016may.model.ImagingStudy;
import org.hl7.fhir.dstu2016may.model.Immunization;
import org.hl7.fhir.dstu2016may.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Library;
import org.hl7.fhir.dstu2016may.model.Linkage;
import org.hl7.fhir.dstu2016may.model.ListResource;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.Measure;
import org.hl7.fhir.dstu2016may.model.MeasureReport;
import org.hl7.fhir.dstu2016may.model.Media;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.MedicationAdministration;
import org.hl7.fhir.dstu2016may.model.MedicationDispense;
import org.hl7.fhir.dstu2016may.model.MedicationOrder;
import org.hl7.fhir.dstu2016may.model.MedicationStatement;
import org.hl7.fhir.dstu2016may.model.MessageHeader;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.ModuleDefinition;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.dstu2016may.model.Narrative;
import org.hl7.fhir.dstu2016may.model.NutritionOrder;
import org.hl7.fhir.dstu2016may.model.Observation;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Order;
import org.hl7.fhir.dstu2016may.model.OrderResponse;
import org.hl7.fhir.dstu2016may.model.OrderSet;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.ParameterDefinition;
import org.hl7.fhir.dstu2016may.model.Parameters;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.PaymentNotice;
import org.hl7.fhir.dstu2016may.model.PaymentReconciliation;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Person;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PractitionerRole;
import org.hl7.fhir.dstu2016may.model.Procedure;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.ProcessRequest;
import org.hl7.fhir.dstu2016may.model.ProcessResponse;
import org.hl7.fhir.dstu2016may.model.Protocol;
import org.hl7.fhir.dstu2016may.model.Provenance;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.RiskAssessment;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.Schedule;
import org.hl7.fhir.dstu2016may.model.SearchParameter;
import org.hl7.fhir.dstu2016may.model.Sequence;
import org.hl7.fhir.dstu2016may.model.Signature;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.Slot;
import org.hl7.fhir.dstu2016may.model.Specimen;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.StructureMap;
import org.hl7.fhir.dstu2016may.model.Subscription;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.SupplyDelivery;
import org.hl7.fhir.dstu2016may.model.SupplyRequest;
import org.hl7.fhir.dstu2016may.model.Task;
import org.hl7.fhir.dstu2016may.model.TestScript;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.TriggerDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.UuidType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class JsonParser
extends JsonParserBase {
    public JsonParser() {
    }

    public JsonParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    @Override
    protected void parseElementProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
        super.parseElementProperties(json, element);
        if (json.has("extension")) {
            JsonArray array = json.getAsJsonArray("extension");
            for (int i = 0; i < array.size(); ++i) {
                element.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseBackboneProperties(JsonObject json, BackboneElement element) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, element);
        if (json.has("modifierExtension")) {
            JsonArray array = json.getAsJsonArray("modifierExtension");
            for (int i = 0; i < array.size(); ++i) {
                element.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected void parseTypeProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
        this.parseElementProperties(json, element);
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s2, E item, EnumFactory e) throws IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        if (s2 != null) {
            res.setValue(e.fromCode(s2));
        }
        return res;
    }

    protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(v);
        return res;
    }

    protected IntegerType parseInteger(Long v) throws IOException, FHIRFormatError {
        IntegerType res = new IntegerType(v);
        return res;
    }

    protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(v);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(v);
        return res;
    }

    protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
        CodeType res = new CodeType(v);
        return res;
    }

    protected DateType parseDate(String v) throws IOException, FHIRFormatError {
        DateType res = new DateType(v);
        return res;
    }

    protected DecimalType parseDecimal(BigDecimal v) throws IOException, FHIRFormatError {
        DecimalType res = new DecimalType(v);
        return res;
    }

    protected UriType parseUri(String v) throws IOException, FHIRFormatError {
        UriType res = new UriType(v);
        return res;
    }

    protected IdType parseId(String v) throws IOException, FHIRFormatError {
        IdType res = new IdType(v);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(v);
        return res;
    }

    protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
        TimeType res = new TimeType(v);
        return res;
    }

    protected OidType parseOid(String v) throws IOException, FHIRFormatError {
        OidType res = new OidType(v);
        return res;
    }

    protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(v);
        return res;
    }

    protected StringType parseString(String v) throws IOException, FHIRFormatError {
        StringType res = new StringType(v);
        return res;
    }

    protected BooleanType parseBoolean(Boolean v) throws IOException, FHIRFormatError {
        BooleanType res = new BooleanType(v);
        return res;
    }

    protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
        UuidType res = new UuidType(v);
        return res;
    }

    protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
        InstantType res = new InstantType(v);
        return res;
    }

    protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
        Type value;
        Extension res = new Extension();
        this.parseElementProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseElementProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("div")) {
            res.setDiv(this.parseXhtml(json.get("div").getAsString()));
        }
        return res;
    }

    protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
        Period res = new Period();
        this.parseTypeProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseDateTime(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseDateTime(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        return res;
    }

    protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseTypeProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(json.get("userSelected").getAsBoolean()));
        }
        if (json.has("_userSelected")) {
            this.parseElementProperties(json.getAsJsonObject("_userSelected"), res.getUserSelectedElement());
        }
        return res;
    }

    protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
        Range res = new Range();
        this.parseTypeProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseSimpleQuantity(json.getAsJsonObject("low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseSimpleQuantity(json.getAsJsonObject("high")));
        }
        return res;
    }

    protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseTypeProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseTypeProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseBase64Binary(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("size")) {
            res.setSizeElement(this.parseUnsignedInt(json.get("size").getAsString()));
        }
        if (json.has("_size")) {
            this.parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
        }
        if (json.has("hash")) {
            res.setHashElement(this.parseBase64Binary(json.get("hash").getAsString()));
        }
        if (json.has("_hash")) {
            this.parseElementProperties(json.getAsJsonObject("_hash"), res.getHashElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("creation")) {
            res.setCreationElement(this.parseDateTime(json.get("creation").getAsString()));
        }
        if (json.has("_creation")) {
            this.parseElementProperties(json.getAsJsonObject("_creation"), res.getCreationElement());
        }
        return res;
    }

    protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseTypeProperties(json, res);
        if (json.has("numerator")) {
            res.setNumerator(this.parseQuantity(json.getAsJsonObject("numerator")));
        }
        if (json.has("denominator")) {
            res.setDenominator(this.parseQuantity(json.getAsJsonObject("denominator")));
        }
        return res;
    }

    protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseTypeProperties(json, res);
        Type author = this.parseType("author", json);
        if (author != null) {
            res.setAuthor(author);
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseTypeProperties(json, res);
        if (json.has("origin")) {
            res.setOrigin(this.parseSimpleQuantity(json.getAsJsonObject("origin")));
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
        }
        if (json.has("_lowerLimit")) {
            this.parseElementProperties(json.getAsJsonObject("_lowerLimit"), res.getLowerLimitElement());
        }
        if (json.has("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(json.get("upperLimit").getAsBigDecimal()));
        }
        if (json.has("_upperLimit")) {
            this.parseElementProperties(json.getAsJsonObject("_upperLimit"), res.getUpperLimitElement());
        }
        if (json.has("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(json.get("dimensions").getAsString()));
        }
        if (json.has("_dimensions")) {
            this.parseElementProperties(json.getAsJsonObject("_dimensions"), res.getDimensionsElement());
        }
        if (json.has("data")) {
            res.setDataElement(this.parseString(json.get("data").getAsString()));
        }
        if (json.has("_data")) {
            this.parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
        }
        return res;
    }

    protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseTypeProperties(json, res);
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        return res;
    }

    protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseTypeProperties(json, res);
        if (json.has("coding")) {
            JsonArray array = json.getAsJsonArray("coding");
            for (int i = 0; i < array.size(); ++i) {
                res.getCoding().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseTypeProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("assigner")) {
            res.setAssigner(this.parseReference(json.getAsJsonObject("assigner")));
        }
        return res;
    }

    protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
        Type who;
        Signature res = new Signature();
        this.parseTypeProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("when")) {
            res.setWhenElement(this.parseInstant(json.get("when").getAsString()));
        }
        if (json.has("_when")) {
            this.parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
        }
        if ((who = this.parseType("who", json)) != null) {
            res.setWho(who);
        }
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("blob")) {
            res.setBlobElement(this.parseBase64Binary(json.get("blob").getAsString()));
        }
        if (json.has("_blob")) {
            this.parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
        }
        return res;
    }

    protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
        Age res = new Age();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
        Count res = new Count();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
        Money res = new Money();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected SimpleQuantity parseSimpleQuantity(JsonObject json) throws IOException, FHIRFormatError {
        SimpleQuantity res = new SimpleQuantity();
        this.parseElementProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("comparator")) {
            res.setComparatorElement(this.parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        }
        if (json.has("_comparator")) {
            this.parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
        }
        if (json.has("unit")) {
            res.setUnitElement(this.parseString(json.get("unit").getAsString()));
        }
        if (json.has("_unit")) {
            this.parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
        Type eventTiming;
        TriggerDefinition res = new TriggerDefinition();
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("eventName")) {
            res.setEventNameElement(this.parseString(json.get("eventName").getAsString()));
        }
        if (json.has("_eventName")) {
            this.parseElementProperties(json.getAsJsonObject("_eventName"), res.getEventNameElement());
        }
        if ((eventTiming = this.parseType("eventTiming", json)) != null) {
            res.setEventTiming(eventTiming);
        }
        if (json.has("eventData")) {
            res.setEventData(this.parseDataRequirement(json.getAsJsonObject("eventData")));
        }
        return res;
    }

    protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type maxValue;
        Type minValue;
        Type example;
        Type pattern;
        Type fixed;
        Type defaultValue;
        int i2;
        JsonArray array2;
        ElementDefinition res = new ElementDefinition();
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("representation")) {
            array2 = json.getAsJsonArray("representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getRepresentation().add(this.parseEnumeration(array2.get(i2).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
            }
        }
        if (json.has("_representation")) {
            array2 = json.getAsJsonArray("_representation");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getRepresentation().size()) {
                    res.getRepresentation().add(this.parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getRepresentation().get(i2));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("code")) {
            array2 = json.getAsJsonArray("code");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getCode().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("slicing")) {
            res.setSlicing(this.parseElementDefinitionElementDefinitionSlicingComponent(json.getAsJsonObject("slicing"), res));
        }
        if (json.has("short")) {
            res.setShortElement(this.parseString(json.get("short").getAsString()));
        }
        if (json.has("_short")) {
            this.parseElementProperties(json.getAsJsonObject("_short"), res.getShortElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseMarkdown(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseMarkdown(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("alias")) {
            array2 = json.getAsJsonArray("alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getAlias().add(this.parseString(array2.get(i2).getAsString()));
            }
        }
        if (json.has("_alias")) {
            array2 = json.getAsJsonArray("_alias");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                if (i2 == res.getAlias().size()) {
                    res.getAlias().add(this.parseString(null));
                }
                if (!(array2.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array2.get(i2).getAsJsonObject(), res.getAlias().get(i2));
            }
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseElementDefinitionElementDefinitionBaseComponent(json.getAsJsonObject("base"), res));
        }
        if (json.has("contentReference")) {
            res.setContentReferenceElement(this.parseUri(json.get("contentReference").getAsString()));
        }
        if (json.has("_contentReference")) {
            this.parseElementProperties(json.getAsJsonObject("_contentReference"), res.getContentReferenceElement());
        }
        if (json.has("type")) {
            array2 = json.getAsJsonArray("type");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getType().add(this.parseElementDefinitionTypeRefComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
        if ((defaultValue = this.parseType("defaultValue", json)) != null) {
            res.setDefaultValue(defaultValue);
        }
        if (json.has("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(json.get("meaningWhenMissing").getAsString()));
        }
        if (json.has("_meaningWhenMissing")) {
            this.parseElementProperties(json.getAsJsonObject("_meaningWhenMissing"), res.getMeaningWhenMissingElement());
        }
        if ((fixed = this.parseType("fixed", json)) != null) {
            res.setFixed(fixed);
        }
        if ((pattern = this.parseType("pattern", json)) != null) {
            res.setPattern(pattern);
        }
        if ((example = this.parseType("example", json)) != null) {
            res.setExample(example);
        }
        if ((minValue = this.parseType("minValue", json)) != null) {
            res.setMinValue(minValue);
        }
        if ((maxValue = this.parseType("maxValue", json)) != null) {
            res.setMaxValue(maxValue);
        }
        if (json.has("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(json.get("maxLength").getAsLong()));
        }
        if (json.has("_maxLength")) {
            this.parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseId(array.get(i).getAsString()));
            }
        }
        if (json.has("_condition")) {
            array = json.getAsJsonArray("_condition");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCondition().size()) {
                    res.getCondition().add(this.parseId(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
            }
        }
        if (json.has("constraint")) {
            array = json.getAsJsonArray("constraint");
            for (i = 0; i < array.size(); ++i) {
                res.getConstraint().add(this.parseElementDefinitionElementDefinitionConstraintComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(json.get("mustSupport").getAsBoolean()));
        }
        if (json.has("_mustSupport")) {
            this.parseElementProperties(json.getAsJsonObject("_mustSupport"), res.getMustSupportElement());
        }
        if (json.has("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(json.get("isModifier").getAsBoolean()));
        }
        if (json.has("_isModifier")) {
            this.parseElementProperties(json.getAsJsonObject("_isModifier"), res.getIsModifierElement());
        }
        if (json.has("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(json.get("isSummary").getAsBoolean()));
        }
        if (json.has("_isSummary")) {
            this.parseElementProperties(json.getAsJsonObject("_isSummary"), res.getIsSummaryElement());
        }
        if (json.has("binding")) {
            res.setBinding(this.parseElementDefinitionElementDefinitionBindingComponent(json.getAsJsonObject("binding"), res));
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseElementDefinitionElementDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementProperties(json, res);
        if (json.has("discriminator")) {
            array = json.getAsJsonArray("discriminator");
            for (i = 0; i < array.size(); ++i) {
                res.getDiscriminator().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_discriminator")) {
            array = json.getAsJsonArray("_discriminator");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDiscriminator().size()) {
                    res.getDiscriminator().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDiscriminator().get(i));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("ordered")) {
            res.setOrderedElement(this.parseBoolean(json.get("ordered").getAsBoolean()));
        }
        if (json.has("_ordered")) {
            this.parseElementProperties(json.getAsJsonObject("_ordered"), res.getOrderedElement());
        }
        if (json.has("rules")) {
            res.setRulesElement(this.parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        }
        if (json.has("_rules")) {
            this.parseElementProperties(json.getAsJsonObject("_rules"), res.getRulesElement());
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        return res;
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("aggregation")) {
            array = json.getAsJsonArray("aggregation");
            for (i = 0; i < array.size(); ++i) {
                res.getAggregation().add(this.parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
            }
        }
        if (json.has("_aggregation")) {
            array = json.getAsJsonArray("_aggregation");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAggregation().size()) {
                    res.getAggregation().add(this.parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementProperties(json, res);
        if (json.has("key")) {
            res.setKeyElement(this.parseId(json.get("key").getAsString()));
        }
        if (json.has("_key")) {
            this.parseElementProperties(json.getAsJsonObject("_key"), res.getKeyElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("human")) {
            res.setHumanElement(this.parseString(json.get("human").getAsString()));
        }
        if (json.has("_human")) {
            this.parseElementProperties(json.getAsJsonObject("_human"), res.getHumanElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
        if (json.has("xpath")) {
            res.setXpathElement(this.parseString(json.get("xpath").getAsString()));
        }
        if (json.has("_xpath")) {
            this.parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        Type valueSet;
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
        return res;
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("map")) {
            res.setMapElement(this.parseString(json.get("map").getAsString()));
        }
        if (json.has("_map")) {
            this.parseElementProperties(json.getAsJsonObject("_map"), res.getMapElement());
        }
        return res;
    }

    protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Timing res = new Timing();
        this.parseElementProperties(json, res);
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseDateTime(array.get(i).getAsString()));
            }
        }
        if (json.has("_event")) {
            array = json.getAsJsonArray("_event");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getEvent().size()) {
                    res.getEvent().add(this.parseDateTime(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
            }
        }
        if (json.has("repeat")) {
            res.setRepeat(this.parseTimingTimingRepeatComponent(json.getAsJsonObject("repeat"), res));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        return res;
    }

    protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(JsonObject json, Timing owner) throws IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseElementProperties(json, res);
        Type bounds = this.parseType("bounds", json);
        if (bounds != null) {
            res.setBounds(bounds);
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("countMax")) {
            res.setCountMaxElement(this.parseInteger(json.get("countMax").getAsLong()));
        }
        if (json.has("_countMax")) {
            this.parseElementProperties(json.getAsJsonObject("_countMax"), res.getCountMaxElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseDecimal(json.get("duration").getAsBigDecimal()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
        }
        if (json.has("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(json.get("durationMax").getAsBigDecimal()));
        }
        if (json.has("_durationMax")) {
            this.parseElementProperties(json.getAsJsonObject("_durationMax"), res.getDurationMaxElement());
        }
        if (json.has("durationUnit")) {
            res.setDurationUnitElement(this.parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_durationUnit")) {
            this.parseElementProperties(json.getAsJsonObject("_durationUnit"), res.getDurationUnitElement());
        }
        if (json.has("frequency")) {
            res.setFrequencyElement(this.parseInteger(json.get("frequency").getAsLong()));
        }
        if (json.has("_frequency")) {
            this.parseElementProperties(json.getAsJsonObject("_frequency"), res.getFrequencyElement());
        }
        if (json.has("frequencyMax")) {
            res.setFrequencyMaxElement(this.parseInteger(json.get("frequencyMax").getAsLong()));
        }
        if (json.has("_frequencyMax")) {
            this.parseElementProperties(json.getAsJsonObject("_frequencyMax"), res.getFrequencyMaxElement());
        }
        if (json.has("period")) {
            res.setPeriodElement(this.parseDecimal(json.get("period").getAsBigDecimal()));
        }
        if (json.has("_period")) {
            this.parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
        }
        if (json.has("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(json.get("periodMax").getAsBigDecimal()));
        }
        if (json.has("_periodMax")) {
            this.parseElementProperties(json.getAsJsonObject("_periodMax"), res.getPeriodMaxElement());
        }
        if (json.has("periodUnit")) {
            res.setPeriodUnitElement(this.parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        }
        if (json.has("_periodUnit")) {
            this.parseElementProperties(json.getAsJsonObject("_periodUnit"), res.getPeriodUnitElement());
        }
        if (json.has("when")) {
            res.setWhenElement(this.parseEnumeration(json.get("when").getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        }
        if (json.has("_when")) {
            this.parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
        }
        if (json.has("offset")) {
            res.setOffsetElement(this.parseUnsignedInt(json.get("offset").getAsString()));
        }
        if (json.has("_offset")) {
            this.parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
        }
        return res;
    }

    protected ModuleMetadata parseModuleMetadata(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ModuleMetadata res = new ModuleMetadata();
        this.parseElementProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ModuleMetadata.ModuleMetadataType.NULL, new ModuleMetadata.ModuleMetadataTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ModuleMetadata.ModuleMetadataStatus.NULL, new ModuleMetadata.ModuleMetadataStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseString(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("publicationDate")) {
            res.setPublicationDateElement(this.parseDate(json.get("publicationDate").getAsString()));
        }
        if (json.has("_publicationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_publicationDate"), res.getPublicationDateElement());
        }
        if (json.has("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(json.get("lastReviewDate").getAsString()));
        }
        if (json.has("_lastReviewDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
        }
        if (json.has("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(json.getAsJsonObject("effectivePeriod")));
        }
        if (json.has("coverage")) {
            array = json.getAsJsonArray("coverage");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverage().add(this.parseModuleMetadataModuleMetadataCoverageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contributor")) {
            array = json.getAsJsonArray("contributor");
            for (i = 0; i < array.size(); ++i) {
                res.getContributor().add(this.parseModuleMetadataModuleMetadataContributorComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseModuleMetadataModuleMetadataContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("relatedResource")) {
            array = json.getAsJsonArray("relatedResource");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedResource().add(this.parseModuleMetadataModuleMetadataRelatedResourceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ModuleMetadata.ModuleMetadataCoverageComponent parseModuleMetadataModuleMetadataCoverageComponent(JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataCoverageComponent res = new ModuleMetadata.ModuleMetadataCoverageComponent();
        this.parseElementProperties(json, res);
        if (json.has("focus")) {
            res.setFocus(this.parseCoding(json.getAsJsonObject("focus")));
        }
        if (json.has("value")) {
            res.setValue(this.parseCodeableConcept(json.getAsJsonObject("value")));
        }
        return res;
    }

    protected ModuleMetadata.ModuleMetadataContributorComponent parseModuleMetadataModuleMetadataContributorComponent(JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataContributorComponent res = new ModuleMetadata.ModuleMetadataContributorComponent();
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ModuleMetadata.ModuleMetadataContributorType.NULL, new ModuleMetadata.ModuleMetadataContributorTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("contact")) {
            JsonArray array = json.getAsJsonArray("contact");
            for (int i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseModuleMetadataModuleMetadataContributorContactComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ModuleMetadata.ModuleMetadataContributorContactComponent parseModuleMetadataModuleMetadataContributorContactComponent(JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataContributorContactComponent res = new ModuleMetadata.ModuleMetadataContributorContactComponent();
        this.parseElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ModuleMetadata.ModuleMetadataContactComponent parseModuleMetadataModuleMetadataContactComponent(JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataContactComponent res = new ModuleMetadata.ModuleMetadataContactComponent();
        this.parseElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ModuleMetadata.ModuleMetadataRelatedResourceComponent parseModuleMetadataModuleMetadataRelatedResourceComponent(JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
        ModuleMetadata.ModuleMetadataRelatedResourceComponent res = new ModuleMetadata.ModuleMetadataRelatedResourceComponent();
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ModuleMetadata.ModuleMetadataResourceType.NULL, new ModuleMetadata.ModuleMetadataResourceTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("document")) {
            res.setDocument(this.parseAttachment(json.getAsJsonObject("document")));
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        return res;
    }

    protected ActionDefinition parseActionDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ActionDefinition res = new ActionDefinition();
        this.parseElementProperties(json, res);
        if (json.has("actionIdentifier")) {
            res.setActionIdentifier(this.parseIdentifier(json.getAsJsonObject("actionIdentifier")));
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("textEquivalent")) {
            res.setTextEquivalentElement(this.parseString(json.get("textEquivalent").getAsString()));
        }
        if (json.has("_textEquivalent")) {
            this.parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingEvidence")) {
            array = json.getAsJsonArray("supportingEvidence");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingEvidence().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("documentation")) {
            array = json.getAsJsonArray("documentation");
            for (i = 0; i < array.size(); ++i) {
                res.getDocumentation().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedAction")) {
            res.setRelatedAction(this.parseActionDefinitionActionDefinitionRelatedActionComponent(json.getAsJsonObject("relatedAction"), res));
        }
        if (json.has("participantType")) {
            array = json.getAsJsonArray("participantType");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipantType().add(this.parseEnumeration(array.get(i).getAsString(), ActionDefinition.ParticipantType.NULL, new ActionDefinition.ParticipantTypeEnumFactory()));
            }
        }
        if (json.has("_participantType")) {
            array = json.getAsJsonArray("_participantType");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getParticipantType().size()) {
                    res.getParticipantType().add(this.parseEnumeration(null, ActionDefinition.ParticipantType.NULL, new ActionDefinition.ParticipantTypeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getParticipantType().get(i));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ActionDefinition.ActionType.NULL, new ActionDefinition.ActionTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("behavior")) {
            array = json.getAsJsonArray("behavior");
            for (i = 0; i < array.size(); ++i) {
                res.getBehavior().add(this.parseActionDefinitionActionDefinitionBehaviorComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        if (json.has("customization")) {
            array = json.getAsJsonArray("customization");
            for (i = 0; i < array.size(); ++i) {
                res.getCustomization().add(this.parseActionDefinitionActionDefinitionCustomizationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseActionDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ActionDefinition.ActionDefinitionRelatedActionComponent parseActionDefinitionActionDefinitionRelatedActionComponent(JsonObject json, ActionDefinition owner) throws IOException, FHIRFormatError {
        Type offset;
        ActionDefinition.ActionDefinitionRelatedActionComponent res = new ActionDefinition.ActionDefinitionRelatedActionComponent();
        this.parseElementProperties(json, res);
        if (json.has("actionIdentifier")) {
            res.setActionIdentifier(this.parseIdentifier(json.getAsJsonObject("actionIdentifier")));
        }
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(json.get("relationship").getAsString(), ActionDefinition.ActionRelationshipType.NULL, new ActionDefinition.ActionRelationshipTypeEnumFactory()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
        }
        if ((offset = this.parseType("offset", json)) != null) {
            res.setOffset(offset);
        }
        if (json.has("anchor")) {
            res.setAnchorElement(this.parseEnumeration(json.get("anchor").getAsString(), ActionDefinition.ActionRelationshipAnchor.NULL, new ActionDefinition.ActionRelationshipAnchorEnumFactory()));
        }
        if (json.has("_anchor")) {
            this.parseElementProperties(json.getAsJsonObject("_anchor"), res.getAnchorElement());
        }
        return res;
    }

    protected ActionDefinition.ActionDefinitionBehaviorComponent parseActionDefinitionActionDefinitionBehaviorComponent(JsonObject json, ActionDefinition owner) throws IOException, FHIRFormatError {
        ActionDefinition.ActionDefinitionBehaviorComponent res = new ActionDefinition.ActionDefinitionBehaviorComponent();
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("value")) {
            res.setValue(this.parseCoding(json.getAsJsonObject("value")));
        }
        return res;
    }

    protected ActionDefinition.ActionDefinitionCustomizationComponent parseActionDefinitionActionDefinitionCustomizationComponent(JsonObject json, ActionDefinition owner) throws IOException, FHIRFormatError {
        ActionDefinition.ActionDefinitionCustomizationComponent res = new ActionDefinition.ActionDefinitionCustomizationComponent();
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
        return res;
    }

    protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Address res = new Address();
        this.parseElementProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("line")) {
            array = json.getAsJsonArray("line");
            for (i = 0; i < array.size(); ++i) {
                res.getLine().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_line")) {
            array = json.getAsJsonArray("_line");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLine().size()) {
                    res.getLine().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
            }
        }
        if (json.has("city")) {
            res.setCityElement(this.parseString(json.get("city").getAsString()));
        }
        if (json.has("_city")) {
            this.parseElementProperties(json.getAsJsonObject("_city"), res.getCityElement());
        }
        if (json.has("district")) {
            res.setDistrictElement(this.parseString(json.get("district").getAsString()));
        }
        if (json.has("_district")) {
            this.parseElementProperties(json.getAsJsonObject("_district"), res.getDistrictElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseString(json.get("state").getAsString()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
        }
        if (json.has("postalCode")) {
            res.setPostalCodeElement(this.parseString(json.get("postalCode").getAsString()));
        }
        if (json.has("_postalCode")) {
            this.parseElementProperties(json.getAsJsonObject("_postalCode"), res.getPostalCodeElement());
        }
        if (json.has("country")) {
            res.setCountryElement(this.parseString(json.get("country").getAsString()));
        }
        if (json.has("_country")) {
            this.parseElementProperties(json.getAsJsonObject("_country"), res.getCountryElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        HumanName res = new HumanName();
        this.parseElementProperties(json, res);
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("family")) {
            array = json.getAsJsonArray("family");
            for (i = 0; i < array.size(); ++i) {
                res.getFamily().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_family")) {
            array = json.getAsJsonArray("_family");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFamily().size()) {
                    res.getFamily().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFamily().get(i));
            }
        }
        if (json.has("given")) {
            array = json.getAsJsonArray("given");
            for (i = 0; i < array.size(); ++i) {
                res.getGiven().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_given")) {
            array = json.getAsJsonArray("_given");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getGiven().size()) {
                    res.getGiven().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
            }
        }
        if (json.has("prefix")) {
            array = json.getAsJsonArray("prefix");
            for (i = 0; i < array.size(); ++i) {
                res.getPrefix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_prefix")) {
            array = json.getAsJsonArray("_prefix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPrefix().size()) {
                    res.getPrefix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
            }
        }
        if (json.has("suffix")) {
            array = json.getAsJsonArray("suffix");
            for (i = 0; i < array.size(); ++i) {
                res.getSuffix().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_suffix")) {
            array = json.getAsJsonArray("_suffix");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSuffix().size()) {
                    res.getSuffix().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataRequirement res = new DataRequirement();
        this.parseElementProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("mustSupport")) {
            array = json.getAsJsonArray("mustSupport");
            for (i = 0; i < array.size(); ++i) {
                res.getMustSupport().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_mustSupport")) {
            array = json.getAsJsonArray("_mustSupport");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getMustSupport().size()) {
                    res.getMustSupport().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
            }
        }
        if (json.has("codeFilter")) {
            array = json.getAsJsonArray("codeFilter");
            for (i = 0; i < array.size(); ++i) {
                res.getCodeFilter().add(this.parseDataRequirementDataRequirementCodeFilterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("dateFilter")) {
            array = json.getAsJsonArray("dateFilter");
            for (i = 0; i < array.size(); ++i) {
                res.getDateFilter().add(this.parseDataRequirementDataRequirementDateFilterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type valueSet;
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
        if (json.has("valueCode")) {
            array = json.getAsJsonArray("valueCode");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCode().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_valueCode")) {
            array = json.getAsJsonArray("_valueCode");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getValueCode().size()) {
                    res.getValueCode().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getValueCode().get(i));
            }
        }
        if (json.has("valueCoding")) {
            array = json.getAsJsonArray("valueCoding");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCoding().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("valueCodeableConcept")) {
            array = json.getAsJsonArray("valueCodeableConcept");
            for (i = 0; i < array.size(); ++i) {
                res.getValueCodeableConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
        Type value;
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseElementProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Meta res = new Meta();
        this.parseElementProperties(json, res);
        if (json.has("versionId")) {
            res.setVersionIdElement(this.parseId(json.get("versionId").getAsString()));
        }
        if (json.has("_versionId")) {
            this.parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
        }
        if (json.has("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(json.get("lastUpdated").getAsString()));
        }
        if (json.has("_lastUpdated")) {
            this.parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_profile")) {
            array = json.getAsJsonArray("_profile");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProfile().size()) {
                    res.getProfile().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
            }
        }
        if (json.has("security")) {
            array = json.getAsJsonArray("security");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurity().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("tag")) {
            array = json.getAsJsonArray("tag");
            for (i = 0; i < array.size(); ++i) {
                res.getTag().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseElementProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseCode(json.get("use").getAsString()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseElementProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("rank")) {
            res.setRankElement(this.parsePositiveInt(json.get("rank").getAsString()));
        }
        if (json.has("_rank")) {
            this.parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Parameters parseParameters(JsonObject json) throws IOException, FHIRFormatError {
        Parameters res = new Parameters();
        this.parseResourceProperties(json, res);
        if (json.has("parameter")) {
            JsonArray array = json.getAsJsonArray("parameter");
            for (int i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(JsonObject json, Parameters owner) throws IOException, FHIRFormatError {
        Type value;
        Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(json.getAsJsonObject("resource")));
        }
        if (json.has("part")) {
            JsonArray array = json.getAsJsonArray("part");
            for (int i = 0; i < array.size(); ++i) {
                res.getPart().add(this.parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
        if (json.has("id")) {
            res.setIdElement(this.parseId(json.get("id").getAsString()));
        }
        if (json.has("_id")) {
            this.parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
        }
        if (json.has("meta")) {
            res.setMeta(this.parseMeta(json.getAsJsonObject("meta")));
        }
        if (json.has("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(json.get("implicitRules").getAsString()));
        }
        if (json.has("_implicitRules")) {
            this.parseElementProperties(json.getAsJsonObject("_implicitRules"), res.getImplicitRulesElement());
        }
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
    }

    protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        this.parseResourceProperties(json, res);
        if (json.has("text")) {
            res.setText(this.parseNarrative(json.getAsJsonObject("text")));
        }
        if (json.has("contained")) {
            array = json.getAsJsonArray("contained");
            for (i = 0; i < array.size(); ++i) {
                res.getContained().add(this.parseResource(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("extension")) {
            array = json.getAsJsonArray("extension");
            for (i = 0; i < array.size(); ++i) {
                res.getExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modifierExtension")) {
            array = json.getAsJsonArray("modifierExtension");
            for (i = 0; i < array.size(); ++i) {
                res.getModifierExtension().add(this.parseExtension(array.get(i).getAsJsonObject()));
            }
        }
    }

    protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
        Account res = new Account();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("activePeriod")) {
            res.setActivePeriod(this.parsePeriod(json.getAsJsonObject("activePeriod")));
        }
        if (json.has("currency")) {
            res.setCurrency(this.parseCoding(json.getAsJsonObject("currency")));
        }
        if (json.has("balance")) {
            res.setBalance(this.parseMoney(json.getAsJsonObject("balance")));
        }
        if (json.has("coveragePeriod")) {
            res.setCoveragePeriod(this.parsePeriod(json.getAsJsonObject("coveragePeriod")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(json.getAsJsonObject("owner")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        return res;
    }

    protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), AllergyIntolerance.AllergyIntoleranceStatus.NULL, new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        }
        if (json.has("_criticality")) {
            this.parseElementProperties(json.getAsJsonObject("_criticality"), res.getCriticalityElement());
        }
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(json.getAsJsonObject("substance")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(json.get("recordedDate").getAsString()));
        }
        if (json.has("_recordedDate")) {
            this.parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
        }
        if (json.has("recorder")) {
            res.setRecorder(this.parseReference(json.getAsJsonObject("recorder")));
        }
        if (json.has("reporter")) {
            res.setReporter(this.parseReference(json.getAsJsonObject("reporter")));
        }
        if (json.has("onset")) {
            res.setOnsetElement(this.parseDateTime(json.get("onset").getAsString()));
        }
        if (json.has("_onset")) {
            this.parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
        }
        if (json.has("lastOccurence")) {
            res.setLastOccurenceElement(this.parseDateTime(json.get("lastOccurence").getAsString()));
        }
        if (json.has("_lastOccurence")) {
            this.parseElementProperties(json.getAsJsonObject("_lastOccurence"), res.getLastOccurenceElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reaction")) {
            array = json.getAsJsonArray("reaction");
            for (i = 0; i < array.size(); ++i) {
                res.getReaction().add(this.parseAllergyIntoleranceAllergyIntoleranceReactionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(JsonObject json, AllergyIntolerance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("substance")) {
            res.setSubstance(this.parseCodeableConcept(json.getAsJsonObject("substance")));
        }
        if (json.has("certainty")) {
            res.setCertaintyElement(this.parseEnumeration(json.get("certainty").getAsString(), AllergyIntolerance.AllergyIntoleranceCertainty.NULL, new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory()));
        }
        if (json.has("_certainty")) {
            this.parseElementProperties(json.getAsJsonObject("_certainty"), res.getCertaintyElement());
        }
        if (json.has("manifestation")) {
            array = json.getAsJsonArray("manifestation");
            for (i = 0; i < array.size(); ++i) {
                res.getManifestation().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("onset")) {
            res.setOnsetElement(this.parseDateTime(json.get("onset").getAsString()));
        }
        if (json.has("_onset")) {
            this.parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(json.getAsJsonObject("exposureRoute")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Appointment res = new Appointment();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(json.getAsJsonObject("appointmentType")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseUnsignedInt(json.get("priority").getAsString()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(json.get("minutesDuration").getAsString()));
        }
        if (json.has("_minutesDuration")) {
            this.parseElementProperties(json.getAsJsonObject("_minutesDuration"), res.getMinutesDurationElement());
        }
        if (json.has("slot")) {
            array = json.getAsJsonArray("slot");
            for (i = 0; i < array.size(); ++i) {
                res.getSlot().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseAppointmentAppointmentParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(JsonObject json, Appointment owner) throws IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        return res;
    }

    protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AppointmentResponse res = new AppointmentResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(json.getAsJsonObject("appointment")));
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("participantType")) {
            array = json.getAsJsonArray("participantType");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipantType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("participantStatus")) {
            res.setParticipantStatusElement(this.parseCode(json.get("participantStatus").getAsString()));
        }
        if (json.has("_participantStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_participantStatus"), res.getParticipantStatusElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        return res;
    }

    protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AuditEvent res = new AuditEvent();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("subtype")) {
            array = json.getAsJsonArray("subtype");
            for (i = 0; i < array.size(); ++i) {
                res.getSubtype().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseInstant(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("outcomeDesc")) {
            res.setOutcomeDescElement(this.parseString(json.get("outcomeDesc").getAsString()));
        }
        if (json.has("_outcomeDesc")) {
            this.parseElementProperties(json.getAsJsonObject("_outcomeDesc"), res.getOutcomeDescElement());
        }
        if (json.has("purposeOfEvent")) {
            array = json.getAsJsonArray("purposeOfEvent");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfEvent().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseAuditEventAuditEventAgentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("source")) {
            res.setSource(this.parseAuditEventAuditEventSourceComponent(json.getAsJsonObject("source"), res));
        }
        if (json.has("entity")) {
            array = json.getAsJsonArray("entity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntity().add(this.parseAuditEventAuditEventEntityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            array = json.getAsJsonArray("role");
            for (i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("userId")) {
            res.setUserId(this.parseIdentifier(json.getAsJsonObject("userId")));
        }
        if (json.has("altId")) {
            res.setAltIdElement(this.parseString(json.get("altId").getAsString()));
        }
        if (json.has("_altId")) {
            this.parseElementProperties(json.getAsJsonObject("_altId"), res.getAltIdElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("requestor")) {
            res.setRequestorElement(this.parseBoolean(json.get("requestor").getAsBoolean()));
        }
        if (json.has("_requestor")) {
            this.parseElementProperties(json.getAsJsonObject("_requestor"), res.getRequestorElement());
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = json.getAsJsonArray("_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
            }
        }
        if (json.has("media")) {
            res.setMedia(this.parseCoding(json.getAsJsonObject("media")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseAuditEventAuditEventAgentNetworkComponent(json.getAsJsonObject("network"), owner));
        }
        if (json.has("purposeOfUse")) {
            array = json.getAsJsonArray("purposeOfUse");
            for (i = 0; i < array.size(); ++i) {
                res.getPurposeOfUse().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("address")) {
            res.setAddressElement(this.parseString(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventParticipantNetworkType.NULL, new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        return res;
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("site")) {
            res.setSiteElement(this.parseString(json.get("site").getAsString()));
        }
        if (json.has("_site")) {
            this.parseElementProperties(json.getAsJsonObject("_site"), res.getSiteElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCoding(json.getAsJsonObject("role")));
        }
        if (json.has("lifecycle")) {
            res.setLifecycle(this.parseCoding(json.getAsJsonObject("lifecycle")));
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("query")) {
            res.setQueryElement(this.parseBase64Binary(json.get("query").getAsString()));
        }
        if (json.has("_query")) {
            this.parseElementProperties(json.getAsJsonObject("_query"), res.getQueryElement());
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseAuditEventAuditEventEntityDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(JsonObject json, AuditEvent owner) throws IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseBase64Binary(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDate(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        return res;
    }

    protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseResourceProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("content")) {
            res.setContentElement(this.parseBase64Binary(json.get("content").getAsString()));
        }
        if (json.has("_content")) {
            this.parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
        }
        return res;
    }

    protected BodySite parseBodySite(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        BodySite res = new BodySite();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("image")) {
            array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Bundle res = new Bundle();
        this.parseResourceProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("total")) {
            res.setTotalElement(this.parseUnsignedInt(json.get("total").getAsString()));
        }
        if (json.has("_total")) {
            this.parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseBundleBundleEntryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("signature")) {
            res.setSignature(this.parseSignature(json.getAsJsonObject("signature")));
        }
        return res;
    }

    protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("relation")) {
            res.setRelationElement(this.parseString(json.get("relation").getAsString()));
        }
        if (json.has("_relation")) {
            this.parseElementProperties(json.getAsJsonObject("_relation"), res.getRelationElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("link")) {
            JsonArray array = json.getAsJsonArray("link");
            for (int i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("fullUrl")) {
            res.setFullUrlElement(this.parseUri(json.get("fullUrl").getAsString()));
        }
        if (json.has("_fullUrl")) {
            this.parseElementProperties(json.getAsJsonObject("_fullUrl"), res.getFullUrlElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseResource(json.getAsJsonObject("resource")));
        }
        if (json.has("search")) {
            res.setSearch(this.parseBundleBundleEntrySearchComponent(json.getAsJsonObject("search"), owner));
        }
        if (json.has("request")) {
            res.setRequest(this.parseBundleBundleEntryRequestComponent(json.getAsJsonObject("request"), owner));
        }
        if (json.has("response")) {
            res.setResponse(this.parseBundleBundleEntryResponseComponent(json.getAsJsonObject("response"), owner));
        }
        return res;
    }

    protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("score")) {
            res.setScoreElement(this.parseDecimal(json.get("score").getAsBigDecimal()));
        }
        if (json.has("_score")) {
            this.parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
        }
        return res;
    }

    protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("method")) {
            res.setMethodElement(this.parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        }
        if (json.has("_method")) {
            this.parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(json.get("ifNoneMatch").getAsString()));
        }
        if (json.has("_ifNoneMatch")) {
            this.parseElementProperties(json.getAsJsonObject("_ifNoneMatch"), res.getIfNoneMatchElement());
        }
        if (json.has("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(json.get("ifModifiedSince").getAsString()));
        }
        if (json.has("_ifModifiedSince")) {
            this.parseElementProperties(json.getAsJsonObject("_ifModifiedSince"), res.getIfModifiedSinceElement());
        }
        if (json.has("ifMatch")) {
            res.setIfMatchElement(this.parseString(json.get("ifMatch").getAsString()));
        }
        if (json.has("_ifMatch")) {
            this.parseElementProperties(json.getAsJsonObject("_ifMatch"), res.getIfMatchElement());
        }
        if (json.has("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(json.get("ifNoneExist").getAsString()));
        }
        if (json.has("_ifNoneExist")) {
            this.parseElementProperties(json.getAsJsonObject("_ifNoneExist"), res.getIfNoneExistElement());
        }
        return res;
    }

    protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(JsonObject json, Bundle owner) throws IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseString(json.get("status").getAsString()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("location")) {
            res.setLocationElement(this.parseUri(json.get("location").getAsString()));
        }
        if (json.has("_location")) {
            this.parseElementProperties(json.getAsJsonObject("_location"), res.getLocationElement());
        }
        if (json.has("etag")) {
            res.setEtagElement(this.parseString(json.get("etag").getAsString()));
        }
        if (json.has("_etag")) {
            this.parseElementProperties(json.getAsJsonObject("_etag"), res.getEtagElement());
        }
        if (json.has("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(json.get("lastModified").getAsString()));
        }
        if (json.has("_lastModified")) {
            this.parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
        }
        return res;
    }

    protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CarePlan res = new CarePlan();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("modified")) {
            res.setModifiedElement(this.parseDateTime(json.get("modified").getAsString()));
        }
        if (json.has("_modified")) {
            this.parseElementProperties(json.getAsJsonObject("_modified"), res.getModifiedElement());
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("addresses")) {
            array = json.getAsJsonArray("addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("support")) {
            array = json.getAsJsonArray("support");
            for (i = 0; i < array.size(); ++i) {
                res.getSupport().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedPlan")) {
            array = json.getAsJsonArray("relatedPlan");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatedPlan().add(this.parseCarePlanCarePlanRelatedPlanComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseCarePlanCarePlanParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("activity")) {
            array = json.getAsJsonArray("activity");
            for (i = 0; i < array.size(); ++i) {
                res.getActivity().add(this.parseCarePlanCarePlanActivityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        return res;
    }

    protected CarePlan.CarePlanRelatedPlanComponent parseCarePlanCarePlanRelatedPlanComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        CarePlan.CarePlanRelatedPlanComponent res = new CarePlan.CarePlanRelatedPlanComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CarePlan.CarePlanRelationship.NULL, new CarePlan.CarePlanRelationshipEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("plan")) {
            res.setPlan(this.parseReference(json.getAsJsonObject("plan")));
        }
        return res;
    }

    protected CarePlan.CarePlanParticipantComponent parseCarePlanCarePlanParticipantComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        CarePlan.CarePlanParticipantComponent res = new CarePlan.CarePlanParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("member")) {
            res.setMember(this.parseReference(json.getAsJsonObject("member")));
        }
        return res;
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actionResulting")) {
            array = json.getAsJsonArray("actionResulting");
            for (i = 0; i < array.size(); ++i) {
                res.getActionResulting().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("progress")) {
            array = json.getAsJsonArray("progress");
            for (i = 0; i < array.size(); ++i) {
                res.getProgress().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reference")) {
            res.setReference(this.parseReference(json.getAsJsonObject("reference")));
        }
        if (json.has("detail")) {
            res.setDetail(this.parseCarePlanCarePlanActivityDetailComponent(json.getAsJsonObject("detail"), owner));
        }
        return res;
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(JsonObject json, CarePlan owner) throws IOException, FHIRFormatError {
        Type product;
        Type scheduled;
        int i;
        JsonArray array;
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("reasonCode")) {
            array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("goal")) {
            array = json.getAsJsonArray("goal");
            for (i = 0; i < array.size(); ++i) {
                res.getGoal().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(json.getAsJsonObject("statusReason")));
        }
        if (json.has("prohibited")) {
            res.setProhibitedElement(this.parseBoolean(json.get("prohibited").getAsBoolean()));
        }
        if (json.has("_prohibited")) {
            this.parseElementProperties(json.getAsJsonObject("_prohibited"), res.getProhibitedElement());
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getPerformer().add(this.parseReference(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((product = this.parseType("product", json)) != null) {
            res.setProduct(product);
        }
        if (json.has("dailyAmount")) {
            res.setDailyAmount(this.parseSimpleQuantity(json.getAsJsonObject("dailyAmount")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        return res;
    }

    protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CareTeam res = new CareTeam();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatus(this.parseCodeableConcept(json.getAsJsonObject("status")));
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseCareTeamCareTeamParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        return res;
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(JsonObject json, CareTeam owner) throws IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("member")) {
            res.setMember(this.parseReference(json.getAsJsonObject("member")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type accidentLocation;
        Type patient;
        int i2;
        JsonArray array;
        Type referral;
        Type originalPrescription;
        Type prescription;
        Type facility;
        Type enterer;
        Type organization;
        Type provider;
        Type target;
        int i3;
        JsonArray array2;
        Claim res = new Claim();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Claim.ClaimType.NULL, new Claim.ClaimTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("subType")) {
            array2 = json.getAsJsonArray("subType");
            for (i3 = 0; i3 < array2.size(); ++i3) {
                res.getSubType().add(this.parseCoding(array2.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("identifier")) {
            array2 = json.getAsJsonArray("identifier");
            for (i3 = 0; i3 < array2.size(); ++i3) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(json.getAsJsonObject("billablePeriod")));
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if ((provider = this.parseType("provider", json)) != null) {
            res.setProvider(provider);
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), Claim.Use.NULL, new Claim.UseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCoding(json.getAsJsonObject("priority")));
        }
        if (json.has("fundsReserve")) {
            res.setFundsReserve(this.parseCoding(json.getAsJsonObject("fundsReserve")));
        }
        if ((enterer = this.parseType("enterer", json)) != null) {
            res.setEnterer(enterer);
        }
        if ((facility = this.parseType("facility", json)) != null) {
            res.setFacility(facility);
        }
        if (json.has("related")) {
            JsonArray array3 = json.getAsJsonArray("related");
            for (int i4 = 0; i4 < array3.size(); ++i4) {
                res.getRelated().add(this.parseClaimRelatedClaimsComponent(array3.get(i4).getAsJsonObject(), res));
            }
        }
        if ((prescription = this.parseType("prescription", json)) != null) {
            res.setPrescription(prescription);
        }
        if ((originalPrescription = this.parseType("originalPrescription", json)) != null) {
            res.setOriginalPrescription(originalPrescription);
        }
        if (json.has("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(json.getAsJsonObject("payee"), res));
        }
        if ((referral = this.parseType("referral", json)) != null) {
            res.setReferral(referral);
        }
        if (json.has("occurrenceCode")) {
            array = json.getAsJsonArray("occurrenceCode");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getOccurrenceCode().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("occurenceSpanCode")) {
            array = json.getAsJsonArray("occurenceSpanCode");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getOccurenceSpanCode().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("valueCode")) {
            array = json.getAsJsonArray("valueCode");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getValueCode().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array = json.getAsJsonArray("diagnosis");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDiagnosis().add(this.parseClaimDiagnosisComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getProcedure().add(this.parseClaimProcedureComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("specialCondition")) {
            array = json.getAsJsonArray("specialCondition");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSpecialCondition().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if ((patient = this.parseType("patient", json)) != null) {
            res.setPatient(patient);
        }
        if (json.has("coverage")) {
            JsonArray array4 = json.getAsJsonArray("coverage");
            for (int i5 = 0; i5 < array4.size(); ++i5) {
                res.getCoverage().add(this.parseClaimCoverageComponent(array4.get(i5).getAsJsonObject(), res));
            }
        }
        if (json.has("accidentDate")) {
            res.setAccidentDateElement(this.parseDate(json.get("accidentDate").getAsString()));
        }
        if (json.has("_accidentDate")) {
            this.parseElementProperties(json.getAsJsonObject("_accidentDate"), res.getAccidentDateElement());
        }
        if (json.has("accidentType")) {
            res.setAccidentType(this.parseCoding(json.getAsJsonObject("accidentType")));
        }
        if ((accidentLocation = this.parseType("accidentLocation", json)) != null) {
            res.setAccidentLocation(accidentLocation);
        }
        if (json.has("interventionException")) {
            JsonArray array5 = json.getAsJsonArray("interventionException");
            for (i = 0; i < array5.size(); ++i) {
                res.getInterventionException().add(this.parseCoding(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("onset")) {
            JsonArray array6 = json.getAsJsonArray("onset");
            for (i = 0; i < array6.size(); ++i) {
                res.getOnset().add(this.parseClaimOnsetComponent(array6.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("employmentImpacted")) {
            res.setEmploymentImpacted(this.parsePeriod(json.getAsJsonObject("employmentImpacted")));
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parsePeriod(json.getAsJsonObject("hospitalization")));
        }
        if (json.has("item")) {
            JsonArray array7 = json.getAsJsonArray("item");
            for (i = 0; i < array7.size(); ++i) {
                res.getItem().add(this.parseClaimItemsComponent(array7.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("total")) {
            res.setTotal(this.parseMoney(json.getAsJsonObject("total")));
        }
        if (json.has("additionalMaterial")) {
            JsonArray array8 = json.getAsJsonArray("additionalMaterial");
            for (i = 0; i < array8.size(); ++i) {
                res.getAdditionalMaterial().add(this.parseCoding(array8.get(i).getAsJsonObject()));
            }
        }
        if (json.has("missingTeeth")) {
            JsonArray array9 = json.getAsJsonArray("missingTeeth");
            for (i = 0; i < array9.size(); ++i) {
                res.getMissingTeeth().add(this.parseClaimMissingTeethComponent(array9.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Claim.RelatedClaimsComponent parseClaimRelatedClaimsComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.RelatedClaimsComponent res = new Claim.RelatedClaimsComponent();
        this.parseBackboneProperties(json, res);
        Type claim = this.parseType("claim", json);
        if (claim != null) {
            res.setClaim(claim);
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(json.getAsJsonObject("relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(json.getAsJsonObject("reference")));
        }
        return res;
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Type party;
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((party = this.parseType("party", json)) != null) {
            res.setParty(party);
        }
        return res;
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("diagnosis")) {
            res.setDiagnosis(this.parseCoding(json.getAsJsonObject("diagnosis")));
        }
        return res;
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Type procedure;
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
        return res;
    }

    protected Claim.CoverageComponent parseClaimCoverageComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type coverage;
        Claim.CoverageComponent res = new Claim.CoverageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
        }
        if ((coverage = this.parseType("coverage", json)) != null) {
            res.setCoverage(coverage);
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(json.getAsJsonObject("claimResponse")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        return res;
    }

    protected Claim.OnsetComponent parseClaimOnsetComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.OnsetComponent res = new Claim.OnsetComponent();
        this.parseBackboneProperties(json, res);
        Type time = this.parseType("time", json);
        if (time != null) {
            res.setTime(time);
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        return res;
    }

    protected Claim.ItemsComponent parseClaimItemsComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        int i;
        Type serviced;
        int i2;
        JsonArray array;
        Type supervisor;
        Type provider;
        Claim.ItemsComponent res = new Claim.ItemsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((provider = this.parseType("provider", json)) != null) {
            res.setProvider(provider);
        }
        if ((supervisor = this.parseType("supervisor", json)) != null) {
            res.setSupervisor(supervisor);
        }
        if (json.has("providerQualification")) {
            res.setProviderQualification(this.parseCoding(json.getAsJsonObject("providerQualification")));
        }
        if (json.has("diagnosisLinkId")) {
            array = json.getAsJsonArray("diagnosisLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(array.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisLinkId")) {
            array = json.getAsJsonArray("_diagnosisLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getDiagnosisLinkId().size()) {
                    res.getDiagnosisLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getDiagnosisLinkId().get(i2));
            }
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("serviceModifier")) {
            array = json.getAsJsonArray("serviceModifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getServiceModifier().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getModifier().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getProgramCode().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("place")) {
            res.setPlace(this.parseCoding(json.getAsJsonObject("place")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            JsonArray array2 = json.getAsJsonArray("udi");
            for (i = 0; i < array2.size(); ++i) {
                res.getUdi().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCoding(json.getAsJsonObject("bodySite")));
        }
        if (json.has("subSite")) {
            JsonArray array3 = json.getAsJsonArray("subSite");
            for (i = 0; i < array3.size(); ++i) {
                res.getSubSite().add(this.parseCoding(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            JsonArray array4 = json.getAsJsonArray("detail");
            for (i = 0; i < array4.size(); ++i) {
                res.getDetail().add(this.parseClaimDetailComponent(array4.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("prosthesis")) {
            res.setProsthesis(this.parseClaimProsthesisComponent(json.getAsJsonObject("prosthesis"), owner));
        }
        return res;
    }

    protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Claim.ProsthesisComponent parseClaimProsthesisComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.ProsthesisComponent res = new Claim.ProsthesisComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("initial")) {
            res.setInitialElement(this.parseBoolean(json.get("initial").getAsBoolean()));
        }
        if (json.has("_initial")) {
            this.parseElementProperties(json.getAsJsonObject("_initial"), res.getInitialElement());
        }
        if (json.has("priorDate")) {
            res.setPriorDateElement(this.parseDate(json.get("priorDate").getAsString()));
        }
        if (json.has("_priorDate")) {
            this.parseElementProperties(json.getAsJsonObject("_priorDate"), res.getPriorDateElement());
        }
        if (json.has("priorMaterial")) {
            res.setPriorMaterial(this.parseCoding(json.getAsJsonObject("priorMaterial")));
        }
        return res;
    }

    protected Claim.MissingTeethComponent parseClaimMissingTeethComponent(JsonObject json, Claim owner) throws IOException, FHIRFormatError {
        Claim.MissingTeethComponent res = new Claim.MissingTeethComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("tooth")) {
            res.setTooth(this.parseCoding(json.getAsJsonObject("tooth")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("extractionDate")) {
            res.setExtractionDateElement(this.parseDate(json.get("extractionDate").getAsString()));
        }
        if (json.has("_extractionDate")) {
            this.parseElementProperties(json.getAsJsonObject("_extractionDate"), res.getExtractionDateElement());
        }
        return res;
    }

    protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type requestOrganization;
        Type requestProvider;
        Type organization;
        Type request;
        ClaimResponse res = new ClaimResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((request = this.parseType("request", json)) != null) {
            res.setRequest(request);
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if ((requestProvider = this.parseType("requestProvider", json)) != null) {
            res.setRequestProvider(requestProvider);
        }
        if ((requestOrganization = this.parseType("requestOrganization", json)) != null) {
            res.setRequestOrganization(requestOrganization);
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("payeeType")) {
            res.setPayeeType(this.parseCoding(json.getAsJsonObject("payeeType")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseClaimResponseItemsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("addItem")) {
            array = json.getAsJsonArray("addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseClaimResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("totalCost")) {
            res.setTotalCost(this.parseMoney(json.getAsJsonObject("totalCost")));
        }
        if (json.has("unallocDeductable")) {
            res.setUnallocDeductable(this.parseMoney(json.getAsJsonObject("unallocDeductable")));
        }
        if (json.has("totalBenefit")) {
            res.setTotalBenefit(this.parseMoney(json.getAsJsonObject("totalBenefit")));
        }
        if (json.has("paymentAdjustment")) {
            res.setPaymentAdjustment(this.parseMoney(json.getAsJsonObject("paymentAdjustment")));
        }
        if (json.has("paymentAdjustmentReason")) {
            res.setPaymentAdjustmentReason(this.parseCoding(json.getAsJsonObject("paymentAdjustmentReason")));
        }
        if (json.has("paymentDate")) {
            res.setPaymentDateElement(this.parseDate(json.get("paymentDate").getAsString()));
        }
        if (json.has("_paymentDate")) {
            this.parseElementProperties(json.getAsJsonObject("_paymentDate"), res.getPaymentDateElement());
        }
        if (json.has("paymentAmount")) {
            res.setPaymentAmount(this.parseMoney(json.getAsJsonObject("paymentAmount")));
        }
        if (json.has("paymentRef")) {
            res.setPaymentRef(this.parseIdentifier(json.getAsJsonObject("paymentRef")));
        }
        if (json.has("reserved")) {
            res.setReserved(this.parseCoding(json.getAsJsonObject("reserved")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseClaimResponseNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("coverage")) {
            array = json.getAsJsonArray("coverage");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverage().add(this.parseClaimResponseCoverageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ClaimResponse.ItemsComponent parseClaimResponseItemsComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse.ItemsComponent res = new ClaimResponse.ItemsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("noteNumber")) {
            array = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            array = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.ItemAdjudicationComponent parseClaimResponseItemAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.ItemAdjudicationComponent res = new ClaimResponse.ItemAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.DetailAdjudicationComponent parseClaimResponseDetailAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.DetailAdjudicationComponent res = new ClaimResponse.DetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("adjudication")) {
            JsonArray array = json.getAsJsonArray("adjudication");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseSubdetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.SubdetailAdjudicationComponent parseClaimResponseSubdetailAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.SubdetailAdjudicationComponent res = new ClaimResponse.SubdetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            array = json.getAsJsonArray("sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getSequenceLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_sequenceLinkId")) {
            array = json.getAsJsonArray("_sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSequenceLinkId().size()) {
                    res.getSequenceLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
            }
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("noteNumberLinkId")) {
            array = json.getAsJsonArray("noteNumberLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumberLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumberLinkId")) {
            array = json.getAsJsonArray("_noteNumberLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumberLinkId().size()) {
                    res.getNoteNumberLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumberLinkId().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseClaimResponseAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.AddedItemAdjudicationComponent parseClaimResponseAddedItemAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemAdjudicationComponent res = new ClaimResponse.AddedItemAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("adjudication")) {
            JsonArray array = json.getAsJsonArray("adjudication");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseClaimResponseAddedItemDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ClaimResponse.AddedItemDetailAdjudicationComponent parseClaimResponseAddedItemDetailAdjudicationComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailAdjudicationComponent res = new ClaimResponse.AddedItemDetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ClaimResponse.ErrorsComponent parseClaimResponseErrorsComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.ErrorsComponent res = new ClaimResponse.ErrorsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parsePositiveInt(json.get("sequenceLinkId").getAsString()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        if (json.has("detailSequenceLinkId")) {
            res.setDetailSequenceLinkIdElement(this.parsePositiveInt(json.get("detailSequenceLinkId").getAsString()));
        }
        if (json.has("_detailSequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_detailSequenceLinkId"), res.getDetailSequenceLinkIdElement());
        }
        if (json.has("subdetailSequenceLinkId")) {
            res.setSubdetailSequenceLinkIdElement(this.parsePositiveInt(json.get("subdetailSequenceLinkId").getAsString()));
        }
        if (json.has("_subdetailSequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_subdetailSequenceLinkId"), res.getSubdetailSequenceLinkIdElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        return res;
    }

    protected ClaimResponse.NotesComponent parseClaimResponseNotesComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        ClaimResponse.NotesComponent res = new ClaimResponse.NotesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected ClaimResponse.CoverageComponent parseClaimResponseCoverageComponent(JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type coverage;
        ClaimResponse.CoverageComponent res = new ClaimResponse.CoverageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("focal")) {
            res.setFocalElement(this.parseBoolean(json.get("focal").getAsBoolean()));
        }
        if (json.has("_focal")) {
            this.parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
        }
        if ((coverage = this.parseType("coverage", json)) != null) {
            res.setCoverage(coverage);
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        if (json.has("claimResponse")) {
            res.setClaimResponse(this.parseReference(json.getAsJsonObject("claimResponse")));
        }
        return res;
    }

    protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type trigger;
        ClinicalImpression res = new ClinicalImpression();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("assessor")) {
            res.setAssessor(this.parseReference(json.getAsJsonObject("assessor")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("previous")) {
            res.setPrevious(this.parseReference(json.getAsJsonObject("previous")));
        }
        if (json.has("problem")) {
            JsonArray array = json.getAsJsonArray("problem");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getProblem().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if ((trigger = this.parseType("trigger", json)) != null) {
            res.setTrigger(trigger);
        }
        if (json.has("investigations")) {
            JsonArray array = json.getAsJsonArray("investigations");
            for (i = 0; i < array.size(); ++i) {
                res.getInvestigations().add(this.parseClinicalImpressionClinicalImpressionInvestigationsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("protocol")) {
            res.setProtocolElement(this.parseUri(json.get("protocol").getAsString()));
        }
        if (json.has("_protocol")) {
            this.parseElementProperties(json.getAsJsonObject("_protocol"), res.getProtocolElement());
        }
        if (json.has("summary")) {
            res.setSummaryElement(this.parseString(json.get("summary").getAsString()));
        }
        if (json.has("_summary")) {
            this.parseElementProperties(json.getAsJsonObject("_summary"), res.getSummaryElement());
        }
        if (json.has("finding")) {
            JsonArray array = json.getAsJsonArray("finding");
            for (i = 0; i < array.size(); ++i) {
                res.getFinding().add(this.parseClinicalImpressionClinicalImpressionFindingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("resolved")) {
            JsonArray array = json.getAsJsonArray("resolved");
            for (i = 0; i < array.size(); ++i) {
                res.getResolved().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruledOut")) {
            JsonArray array = json.getAsJsonArray("ruledOut");
            for (i = 0; i < array.size(); ++i) {
                res.getRuledOut().add(this.parseClinicalImpressionClinicalImpressionRuledOutComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("prognosis")) {
            res.setPrognosisElement(this.parseString(json.get("prognosis").getAsString()));
        }
        if (json.has("_prognosis")) {
            this.parseElementProperties(json.getAsJsonObject("_prognosis"), res.getPrognosisElement());
        }
        if (json.has("plan")) {
            JsonArray array = json.getAsJsonArray("plan");
            for (i = 0; i < array.size(); ++i) {
                res.getPlan().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionInvestigationsComponent parseClinicalImpressionClinicalImpressionInvestigationsComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionInvestigationsComponent res = new ClinicalImpression.ClinicalImpressionInvestigationsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseCodeableConcept(json.getAsJsonObject("item")));
        }
        if (json.has("cause")) {
            res.setCauseElement(this.parseString(json.get("cause").getAsString()));
        }
        if (json.has("_cause")) {
            this.parseElementProperties(json.getAsJsonObject("_cause"), res.getCauseElement());
        }
        return res;
    }

    protected ClinicalImpression.ClinicalImpressionRuledOutComponent parseClinicalImpressionClinicalImpressionRuledOutComponent(JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionRuledOutComponent res = new ClinicalImpression.ClinicalImpressionRuledOutComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("item")) {
            res.setItem(this.parseCodeableConcept(json.getAsJsonObject("item")));
        }
        if (json.has("reason")) {
            res.setReasonElement(this.parseString(json.get("reason").getAsString()));
        }
        if (json.has("_reason")) {
            this.parseElementProperties(json.getAsJsonObject("_reason"), res.getReasonElement());
        }
        return res;
    }

    protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CodeSystem res = new CodeSystem();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseCodeSystemCodeSystemContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(json.get("caseSensitive").getAsBoolean()));
        }
        if (json.has("_caseSensitive")) {
            this.parseElementProperties(json.getAsJsonObject("_caseSensitive"), res.getCaseSensitiveElement());
        }
        if (json.has("valueSet")) {
            res.setValueSetElement(this.parseUri(json.get("valueSet").getAsString()));
        }
        if (json.has("_valueSet")) {
            this.parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
        }
        if (json.has("compositional")) {
            res.setCompositionalElement(this.parseBoolean(json.get("compositional").getAsBoolean()));
        }
        if (json.has("_compositional")) {
            this.parseElementProperties(json.getAsJsonObject("_compositional"), res.getCompositionalElement());
        }
        if (json.has("versionNeeded")) {
            res.setVersionNeededElement(this.parseBoolean(json.get("versionNeeded").getAsBoolean()));
        }
        if (json.has("_versionNeeded")) {
            this.parseElementProperties(json.getAsJsonObject("_versionNeeded"), res.getVersionNeededElement());
        }
        if (json.has("content")) {
            res.setContentElement(this.parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
        }
        if (json.has("_content")) {
            this.parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
        }
        if (json.has("count")) {
            res.setCountElement(this.parseUnsignedInt(json.get("count").getAsString()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("filter")) {
            array = json.getAsJsonArray("filter");
            for (i = 0; i < array.size(); ++i) {
                res.getFilter().add(this.parseCodeSystemCodeSystemFilterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemCodeSystemPropertyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected CodeSystem.CodeSystemContactComponent parseCodeSystemCodeSystemContactComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.CodeSystemContactComponent res = new CodeSystem.CodeSystemContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("operator")) {
            array = json.getAsJsonArray("operator");
            for (i = 0; i < array.size(); ++i) {
                res.getOperator().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_operator")) {
            array = json.getAsJsonArray("_operator");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOperator().size()) {
                    res.getOperator().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
            }
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected CodeSystem.CodeSystemPropertyComponent parseCodeSystemCodeSystemPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.CodeSystemPropertyComponent res = new CodeSystem.CodeSystemPropertyComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        return res;
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseString(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("designation")) {
            array = json.getAsJsonArray("designation");
            for (i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("property")) {
            array = json.getAsJsonArray("property");
            for (i = 0; i < array.size(); ++i) {
                res.getProperty().add(this.parseCodeSystemConceptDefinitionPropertyComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected CodeSystem.ConceptDefinitionPropertyComponent parseCodeSystemConceptDefinitionPropertyComponent(JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
        Type value;
        CodeSystem.ConceptDefinitionPropertyComponent res = new CodeSystem.ConceptDefinitionPropertyComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Communication res = new Communication();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(json.getAsJsonObject("sender")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseCommunicationCommunicationPayloadComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i = 0; i < array.size(); ++i) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("sent")) {
            res.setSentElement(this.parseDateTime(json.get("sent").getAsString()));
        }
        if (json.has("_sent")) {
            this.parseElementProperties(json.getAsJsonObject("_sent"), res.getSentElement());
        }
        if (json.has("received")) {
            res.setReceivedElement(this.parseDateTime(json.get("received").getAsString()));
        }
        if (json.has("_received")) {
            this.parseElementProperties(json.getAsJsonObject("_received"), res.getReceivedElement());
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("requestDetail")) {
            res.setRequestDetail(this.parseReference(json.getAsJsonObject("requestDetail")));
        }
        return res;
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(JsonObject json, Communication owner) throws IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type scheduled;
        int i;
        JsonArray array;
        CommunicationRequest res = new CommunicationRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("sender")) {
            res.setSender(this.parseReference(json.getAsJsonObject("sender")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("payload")) {
            array = json.getAsJsonArray("payload");
            for (i = 0; i < array.size(); ++i) {
                res.getPayload().add(this.parseCommunicationRequestCommunicationRequestPayloadComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("medium")) {
            array = json.getAsJsonArray("medium");
            for (i = 0; i < array.size(); ++i) {
                res.getMedium().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(json.getAsJsonObject("requester")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("reason")) {
            JsonArray array2 = json.getAsJsonArray("reason");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getReason().add(this.parseCodeableConcept(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("requestedOn")) {
            res.setRequestedOnElement(this.parseDateTime(json.get("requestedOn").getAsString()));
        }
        if (json.has("_requestedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_requestedOn"), res.getRequestedOnElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        return res;
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseCompartmentDefinitionCompartmentDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("search")) {
            res.setSearchElement(this.parseBoolean(json.get("search").getAsBoolean()));
        }
        if (json.has("_search")) {
            this.parseElementProperties(json.getAsJsonObject("_search"), res.getSearchElement());
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseCompartmentDefinitionCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected CompartmentDefinition.CompartmentDefinitionContactComponent parseCompartmentDefinitionCompartmentDefinitionContactComponent(JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionContactComponent res = new CompartmentDefinition.CompartmentDefinitionContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("param")) {
            array = json.getAsJsonArray("param");
            for (i = 0; i < array.size(); ++i) {
                res.getParam().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_param")) {
            array = json.getAsJsonArray("_param");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getParam().size()) {
                    res.getParam().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition res = new Composition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("class")) {
            res.setClass_(this.parseCodeableConcept(json.getAsJsonObject("class")));
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("confidentiality")) {
            res.setConfidentialityElement(this.parseCode(json.get("confidentiality").getAsString()));
        }
        if (json.has("_confidentiality")) {
            this.parseElementProperties(json.getAsJsonObject("_confidentiality"), res.getConfidentialityElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("attester")) {
            array = json.getAsJsonArray("attester");
            for (i = 0; i < array.size(); ++i) {
                res.getAttester().add(this.parseCompositionCompositionAttesterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(json.getAsJsonObject("custodian")));
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCompositionCompositionEventComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            array = json.getAsJsonArray("mode");
            for (i = 0; i < array.size(); ++i) {
                res.getMode().add(this.parseEnumeration(array.get(i).getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
            }
        }
        if (json.has("_mode")) {
            array = json.getAsJsonArray("_mode");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getMode().size()) {
                    res.getMode().add(this.parseEnumeration(null, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getMode().get(i));
            }
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
        return res;
    }

    protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json, Composition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("text")) {
            res.setText(this.parseNarrative(json.getAsJsonObject("text")));
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseCode(json.get("mode").getAsString()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(json.getAsJsonObject("orderedBy")));
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(json.getAsJsonObject("emptyReason")));
        }
        if (json.has("section")) {
            array = json.getAsJsonArray("section");
            for (i = 0; i < array.size(); ++i) {
                res.getSection().add(this.parseCompositionSectionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
        Type target;
        Type source;
        int i;
        JsonArray array;
        ConceptMap res = new ConceptMap();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseConceptMapConceptMapContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if (json.has("element")) {
            JsonArray array2 = json.getAsJsonArray("element");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getElement().add(this.parseConceptMapSourceElementComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ConceptMap.ConceptMapContactComponent parseConceptMapConceptMapContactComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.ConceptMapContactComponent res = new ConceptMap.ConceptMapContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("target")) {
            JsonArray array = json.getAsJsonArray("target");
            for (int i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("equivalence")) {
            res.setEquivalenceElement(this.parseEnumeration(json.get("equivalence").getAsString(), Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
        }
        if (json.has("_equivalence")) {
            this.parseElementProperties(json.getAsJsonObject("_equivalence"), res.getEquivalenceElement());
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseString(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        if (json.has("dependsOn")) {
            array = json.getAsJsonArray("dependsOn");
            for (i = 0; i < array.size(); ++i) {
                res.getDependsOn().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("product")) {
            array = json.getAsJsonArray("product");
            for (i = 0; i < array.size(); ++i) {
                res.getProduct().add(this.parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json, ConceptMap owner) throws IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("element")) {
            res.setElementElement(this.parseUri(json.get("element").getAsString()));
        }
        if (json.has("_element")) {
            this.parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseString(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        return res;
    }

    protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type abatement;
        Type onset;
        Condition res = new Condition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("asserter")) {
            res.setAsserter(this.parseReference(json.getAsJsonObject("asserter")));
        }
        if (json.has("dateRecorded")) {
            res.setDateRecordedElement(this.parseDate(json.get("dateRecorded").getAsString()));
        }
        if (json.has("_dateRecorded")) {
            this.parseElementProperties(json.getAsJsonObject("_dateRecorded"), res.getDateRecordedElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("clinicalStatus")) {
            res.setClinicalStatusElement(this.parseCode(json.get("clinicalStatus").getAsString()));
        }
        if (json.has("_clinicalStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
        }
        if (json.has("verificationStatus")) {
            res.setVerificationStatusElement(this.parseEnumeration(json.get("verificationStatus").getAsString(), Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
        }
        if (json.has("_verificationStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
        }
        if (json.has("severity")) {
            res.setSeverity(this.parseCodeableConcept(json.getAsJsonObject("severity")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if ((abatement = this.parseType("abatement", json)) != null) {
            res.setAbatement(abatement);
        }
        if (json.has("stage")) {
            res.setStage(this.parseConditionConditionStageComponent(json.getAsJsonObject("stage"), res));
        }
        if (json.has("evidence")) {
            array = json.getAsJsonArray("evidence");
            for (i = 0; i < array.size(); ++i) {
                res.getEvidence().add(this.parseConditionConditionEvidenceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("bodySite")) {
            array = json.getAsJsonArray("bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notes")) {
            res.setNotesElement(this.parseString(json.get("notes").getAsString()));
        }
        if (json.has("_notes")) {
            this.parseElementProperties(json.getAsJsonObject("_notes"), res.getNotesElement());
        }
        return res;
    }

    protected Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("summary")) {
            res.setSummary(this.parseCodeableConcept(json.getAsJsonObject("summary")));
        }
        if (json.has("assessment")) {
            JsonArray array = json.getAsJsonArray("assessment");
            for (int i = 0; i < array.size(); ++i) {
                res.getAssessment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject json, Condition owner) throws IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("detail")) {
            JsonArray array = json.getAsJsonArray("detail");
            for (int i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Conformance parseConformance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance res = new Conformance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseConformanceConformanceContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), Conformance.ConformanceStatementKind.NULL, new Conformance.ConformanceStatementKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("software")) {
            res.setSoftware(this.parseConformanceConformanceSoftwareComponent(json.getAsJsonObject("software"), res));
        }
        if (json.has("implementation")) {
            res.setImplementation(this.parseConformanceConformanceImplementationComponent(json.getAsJsonObject("implementation"), res));
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("acceptUnknown")) {
            res.setAcceptUnknownElement(this.parseEnumeration(json.get("acceptUnknown").getAsString(), Conformance.UnknownContentCode.NULL, new Conformance.UnknownContentCodeEnumFactory()));
        }
        if (json.has("_acceptUnknown")) {
            this.parseElementProperties(json.getAsJsonObject("_acceptUnknown"), res.getAcceptUnknownElement());
        }
        if (json.has("format")) {
            array = json.getAsJsonArray("format");
            for (i = 0; i < array.size(); ++i) {
                res.getFormat().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_format")) {
            array = json.getAsJsonArray("_format");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFormat().size()) {
                    res.getFormat().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
            }
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("rest")) {
            array = json.getAsJsonArray("rest");
            for (i = 0; i < array.size(); ++i) {
                res.getRest().add(this.parseConformanceConformanceRestComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("messaging")) {
            array = json.getAsJsonArray("messaging");
            for (i = 0; i < array.size(); ++i) {
                res.getMessaging().add(this.parseConformanceConformanceMessagingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("document")) {
            array = json.getAsJsonArray("document");
            for (i = 0; i < array.size(); ++i) {
                res.getDocument().add(this.parseConformanceConformanceDocumentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Conformance.ConformanceContactComponent parseConformanceConformanceContactComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceContactComponent res = new Conformance.ConformanceContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Conformance.ConformanceSoftwareComponent parseConformanceConformanceSoftwareComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceSoftwareComponent res = new Conformance.ConformanceSoftwareComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(json.get("releaseDate").getAsString()));
        }
        if (json.has("_releaseDate")) {
            this.parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
        }
        return res;
    }

    protected Conformance.ConformanceImplementationComponent parseConformanceConformanceImplementationComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceImplementationComponent res = new Conformance.ConformanceImplementationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestComponent parseConformanceConformanceRestComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestComponent res = new Conformance.ConformanceRestComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Conformance.RestfulConformanceMode.NULL, new Conformance.RestfulConformanceModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("security")) {
            res.setSecurity(this.parseConformanceConformanceRestSecurityComponent(json.getAsJsonObject("security"), owner));
        }
        if (json.has("resource")) {
            array = json.getAsJsonArray("resource");
            for (i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseConformanceConformanceRestResourceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseConformanceSystemInteractionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("transactionMode")) {
            res.setTransactionModeElement(this.parseEnumeration(json.get("transactionMode").getAsString(), Conformance.TransactionMode.NULL, new Conformance.TransactionModeEnumFactory()));
        }
        if (json.has("_transactionMode")) {
            this.parseElementProperties(json.getAsJsonObject("_transactionMode"), res.getTransactionModeElement());
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("operation")) {
            array = json.getAsJsonArray("operation");
            for (i = 0; i < array.size(); ++i) {
                res.getOperation().add(this.parseConformanceConformanceRestOperationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("compartment")) {
            array = json.getAsJsonArray("compartment");
            for (i = 0; i < array.size(); ++i) {
                res.getCompartment().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_compartment")) {
            array = json.getAsJsonArray("_compartment");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCompartment().size()) {
                    res.getCompartment().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
            }
        }
        return res;
    }

    protected Conformance.ConformanceRestSecurityComponent parseConformanceConformanceRestSecurityComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestSecurityComponent res = new Conformance.ConformanceRestSecurityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("cors")) {
            res.setCorsElement(this.parseBoolean(json.get("cors").getAsBoolean()));
        }
        if (json.has("_cors")) {
            this.parseElementProperties(json.getAsJsonObject("_cors"), res.getCorsElement());
        }
        if (json.has("service")) {
            array = json.getAsJsonArray("service");
            for (i = 0; i < array.size(); ++i) {
                res.getService().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("certificate")) {
            array = json.getAsJsonArray("certificate");
            for (i = 0; i < array.size(); ++i) {
                res.getCertificate().add(this.parseConformanceConformanceRestSecurityCertificateComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Conformance.ConformanceRestSecurityCertificateComponent parseConformanceConformanceRestSecurityCertificateComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceRestSecurityCertificateComponent res = new Conformance.ConformanceRestSecurityCertificateComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("blob")) {
            res.setBlobElement(this.parseBase64Binary(json.get("blob").getAsString()));
        }
        if (json.has("_blob")) {
            this.parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestResourceComponent parseConformanceConformanceRestResourceComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestResourceComponent res = new Conformance.ConformanceRestResourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("interaction")) {
            array = json.getAsJsonArray("interaction");
            for (i = 0; i < array.size(); ++i) {
                res.getInteraction().add(this.parseConformanceResourceInteractionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("versioning")) {
            res.setVersioningElement(this.parseEnumeration(json.get("versioning").getAsString(), Conformance.ResourceVersionPolicy.NULL, new Conformance.ResourceVersionPolicyEnumFactory()));
        }
        if (json.has("_versioning")) {
            this.parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
        }
        if (json.has("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(json.get("readHistory").getAsBoolean()));
        }
        if (json.has("_readHistory")) {
            this.parseElementProperties(json.getAsJsonObject("_readHistory"), res.getReadHistoryElement());
        }
        if (json.has("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(json.get("updateCreate").getAsBoolean()));
        }
        if (json.has("_updateCreate")) {
            this.parseElementProperties(json.getAsJsonObject("_updateCreate"), res.getUpdateCreateElement());
        }
        if (json.has("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(json.get("conditionalCreate").getAsBoolean()));
        }
        if (json.has("_conditionalCreate")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalCreate"), res.getConditionalCreateElement());
        }
        if (json.has("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
        }
        if (json.has("_conditionalUpdate")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalUpdate"), res.getConditionalUpdateElement());
        }
        if (json.has("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(json.get("conditionalDelete").getAsString(), Conformance.ConditionalDeleteStatus.NULL, new Conformance.ConditionalDeleteStatusEnumFactory()));
        }
        if (json.has("_conditionalDelete")) {
            this.parseElementProperties(json.getAsJsonObject("_conditionalDelete"), res.getConditionalDeleteElement());
        }
        if (json.has("searchInclude")) {
            array = json.getAsJsonArray("searchInclude");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchInclude")) {
            array = json.getAsJsonArray("_searchInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchInclude().size()) {
                    res.getSearchInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
            }
        }
        if (json.has("searchRevInclude")) {
            array = json.getAsJsonArray("searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchRevInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_searchRevInclude")) {
            array = json.getAsJsonArray("_searchRevInclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSearchRevInclude().size()) {
                    res.getSearchRevInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
            }
        }
        if (json.has("searchParam")) {
            array = json.getAsJsonArray("searchParam");
            for (i = 0; i < array.size(); ++i) {
                res.getSearchParam().add(this.parseConformanceConformanceRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Conformance.ResourceInteractionComponent parseConformanceResourceInteractionComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ResourceInteractionComponent res = new Conformance.ResourceInteractionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Conformance.TypeRestfulInteraction.NULL, new Conformance.TypeRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestResourceSearchParamComponent parseConformanceConformanceRestResourceSearchParamComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceRestResourceSearchParamComponent res = new Conformance.ConformanceRestResourceSearchParamComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseUri(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_target")) {
            array = json.getAsJsonArray("_target");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTarget().size()) {
                    res.getTarget().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
            }
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i = 0; i < array.size(); ++i) {
                res.getModifier().add(this.parseEnumeration(array.get(i).getAsString(), Conformance.SearchModifierCode.NULL, new Conformance.SearchModifierCodeEnumFactory()));
            }
        }
        if (json.has("_modifier")) {
            array = json.getAsJsonArray("_modifier");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getModifier().size()) {
                    res.getModifier().add(this.parseEnumeration(null, Conformance.SearchModifierCode.NULL, new Conformance.SearchModifierCodeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getModifier().get(i));
            }
        }
        if (json.has("chain")) {
            array = json.getAsJsonArray("chain");
            for (i = 0; i < array.size(); ++i) {
                res.getChain().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_chain")) {
            array = json.getAsJsonArray("_chain");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getChain().size()) {
                    res.getChain().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getChain().get(i));
            }
        }
        return res;
    }

    protected Conformance.SystemInteractionComponent parseConformanceSystemInteractionComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.SystemInteractionComponent res = new Conformance.SystemInteractionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), Conformance.SystemRestfulInteraction.NULL, new Conformance.SystemRestfulInteractionEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected Conformance.ConformanceRestOperationComponent parseConformanceConformanceRestOperationComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceRestOperationComponent res = new Conformance.ConformanceRestOperationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("definition")) {
            res.setDefinition(this.parseReference(json.getAsJsonObject("definition")));
        }
        return res;
    }

    protected Conformance.ConformanceMessagingComponent parseConformanceConformanceMessagingComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Conformance.ConformanceMessagingComponent res = new Conformance.ConformanceMessagingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("endpoint")) {
            array = json.getAsJsonArray("endpoint");
            for (i = 0; i < array.size(); ++i) {
                res.getEndpoint().add(this.parseConformanceConformanceMessagingEndpointComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(json.get("reliableCache").getAsString()));
        }
        if (json.has("_reliableCache")) {
            this.parseElementProperties(json.getAsJsonObject("_reliableCache"), res.getReliableCacheElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseConformanceConformanceMessagingEventComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Conformance.ConformanceMessagingEndpointComponent parseConformanceConformanceMessagingEndpointComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEndpointComponent res = new Conformance.ConformanceMessagingEndpointComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("protocol")) {
            res.setProtocol(this.parseCoding(json.getAsJsonObject("protocol")));
        }
        if (json.has("address")) {
            res.setAddressElement(this.parseUri(json.get("address").getAsString()));
        }
        if (json.has("_address")) {
            this.parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
        }
        return res;
    }

    protected Conformance.ConformanceMessagingEventComponent parseConformanceConformanceMessagingEventComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceMessagingEventComponent res = new Conformance.ConformanceMessagingEventComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), Conformance.MessageSignificanceCategory.NULL, new Conformance.MessageSignificanceCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Conformance.ConformanceEventMode.NULL, new Conformance.ConformanceEventModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("focus")) {
            res.setFocusElement(this.parseCode(json.get("focus").getAsString()));
        }
        if (json.has("_focus")) {
            this.parseElementProperties(json.getAsJsonObject("_focus"), res.getFocusElement());
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseReference(json.getAsJsonObject("response")));
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected Conformance.ConformanceDocumentComponent parseConformanceConformanceDocumentComponent(JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
        Conformance.ConformanceDocumentComponent res = new Conformance.ConformanceDocumentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Conformance.DocumentMode.NULL, new Conformance.DocumentModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type binding;
        int i2;
        JsonArray array;
        Contract res = new Contract();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(json.getAsJsonObject("applies")));
        }
        if (json.has("subject")) {
            array = json.getAsJsonArray("subject");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubject().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTopic().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("authority")) {
            array = json.getAsJsonArray("authority");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAuthority().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("domain")) {
            array = json.getAsJsonArray("domain");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDomain().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            array = json.getAsJsonArray("subType");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSubType().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAction().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("actionReason")) {
            array = json.getAsJsonArray("actionReason");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getActionReason().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getAgent().add(this.parseContractAgentComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("signer")) {
            array = json.getAsJsonArray("signer");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSigner().add(this.parseContractSignatoryComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("valuedItem")) {
            array = json.getAsJsonArray("valuedItem");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getValuedItem().add(this.parseContractValuedItemComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("term")) {
            array = json.getAsJsonArray("term");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTerm().add(this.parseContractTermComponent(array.get(i2).getAsJsonObject(), res));
            }
        }
        if ((binding = this.parseType("binding", json)) != null) {
            res.setBinding(binding);
        }
        if (json.has("friendly")) {
            JsonArray array2 = json.getAsJsonArray("friendly");
            for (i = 0; i < array2.size(); ++i) {
                res.getFriendly().add(this.parseContractFriendlyLanguageComponent(array2.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("legal")) {
            JsonArray array3 = json.getAsJsonArray("legal");
            for (i = 0; i < array3.size(); ++i) {
                res.getLegal().add(this.parseContractLegalLanguageComponent(array3.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("rule")) {
            JsonArray array4 = json.getAsJsonArray("rule");
            for (i = 0; i < array4.size(); ++i) {
                res.getRule().add(this.parseContractComputableLanguageComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Contract.AgentComponent parseContractAgentComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.AgentComponent res = new Contract.AgentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("party")) {
            res.setParty(this.parseReference(json.getAsJsonObject("party")));
        }
        if (json.has("signature")) {
            JsonArray array = json.getAsJsonArray("signature");
            for (int i = 0; i < array.size(); ++i) {
                res.getSignature().add(this.parseSignature(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseBackboneProperties(json, res);
        Type entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        return res;
    }

    protected Contract.TermComponent parseContractTermComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseDateTime(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("applies")) {
            res.setApplies(this.parsePeriod(json.getAsJsonObject("applies")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subType")) {
            res.setSubType(this.parseCodeableConcept(json.getAsJsonObject("subType")));
        }
        if (json.has("topic")) {
            array = json.getAsJsonArray("topic");
            for (i = 0; i < array.size(); ++i) {
                res.getTopic().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actionReason")) {
            array = json.getAsJsonArray("actionReason");
            for (i = 0; i < array.size(); ++i) {
                res.getActionReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseContractTermAgentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("valuedItem")) {
            array = json.getAsJsonArray("valuedItem");
            for (i = 0; i < array.size(); ++i) {
                res.getValuedItem().add(this.parseContractTermValuedItemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseContractTermComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Contract.TermAgentComponent parseContractTermAgentComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.TermAgentComponent res = new Contract.TermAgentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("role")) {
            JsonArray array = json.getAsJsonArray("role");
            for (int i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
        this.parseBackboneProperties(json, res);
        Type entity = this.parseType("entity", json);
        if (entity != null) {
            res.setEntity(entity);
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(json.get("effectiveTime").getAsString()));
        }
        if (json.has("_effectiveTime")) {
            this.parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        return res;
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json, Contract owner) throws IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseBackboneProperties(json, res);
        Type content = this.parseType("content", json);
        if (content != null) {
            res.setContent(content);
        }
        return res;
    }

    protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type beneficiary;
        Type planholder;
        Coverage res = new Coverage();
        this.parseDomainResourceProperties(json, res);
        Type issuer = this.parseType("issuer", json);
        if (issuer != null) {
            res.setIssuer(issuer);
        }
        if (json.has("bin")) {
            res.setBinElement(this.parseString(json.get("bin").getAsString()));
        }
        if (json.has("_bin")) {
            this.parseElementProperties(json.getAsJsonObject("_bin"), res.getBinElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((planholder = this.parseType("planholder", json)) != null) {
            res.setPlanholder(planholder);
        }
        if ((beneficiary = this.parseType("beneficiary", json)) != null) {
            res.setBeneficiary(beneficiary);
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(json.getAsJsonObject("relationship")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("group")) {
            res.setGroupElement(this.parseString(json.get("group").getAsString()));
        }
        if (json.has("_group")) {
            this.parseElementProperties(json.getAsJsonObject("_group"), res.getGroupElement());
        }
        if (json.has("plan")) {
            res.setPlanElement(this.parseString(json.get("plan").getAsString()));
        }
        if (json.has("_plan")) {
            this.parseElementProperties(json.getAsJsonObject("_plan"), res.getPlanElement());
        }
        if (json.has("subPlan")) {
            res.setSubPlanElement(this.parseString(json.get("subPlan").getAsString()));
        }
        if (json.has("_subPlan")) {
            this.parseElementProperties(json.getAsJsonObject("_subPlan"), res.getSubPlanElement());
        }
        if (json.has("dependent")) {
            res.setDependentElement(this.parsePositiveInt(json.get("dependent").getAsString()));
        }
        if (json.has("_dependent")) {
            this.parseElementProperties(json.getAsJsonObject("_dependent"), res.getDependentElement());
        }
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("exception")) {
            array = json.getAsJsonArray("exception");
            for (i = 0; i < array.size(); ++i) {
                res.getException().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("school")) {
            res.setSchoolElement(this.parseString(json.get("school").getAsString()));
        }
        if (json.has("_school")) {
            this.parseElementProperties(json.getAsJsonObject("_school"), res.getSchoolElement());
        }
        if (json.has("network")) {
            res.setNetworkElement(this.parseString(json.get("network").getAsString()));
        }
        if (json.has("_network")) {
            this.parseElementProperties(json.getAsJsonObject("_network"), res.getNetworkElement());
        }
        if (json.has("contract")) {
            array = json.getAsJsonArray("contract");
            for (i = 0; i < array.size(); ++i) {
                res.getContract().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DataElement parseDataElement(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DataElement res = new DataElement();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseDataElementDataElementContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("stringency")) {
            res.setStringencyElement(this.parseEnumeration(json.get("stringency").getAsString(), DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
        }
        if (json.has("_stringency")) {
            this.parseElementProperties(json.getAsJsonObject("_stringency"), res.getStringencyElement());
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseDataElementDataElementMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("element")) {
            array = json.getAsJsonArray("element");
            for (i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseElementDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DataElement.DataElementContactComponent parseDataElementDataElementContactComponent(JsonObject json, DataElement owner) throws IOException, FHIRFormatError {
        DataElement.DataElementContactComponent res = new DataElement.DataElementContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(JsonObject json, DataElement owner) throws IOException, FHIRFormatError {
        DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        return res;
    }

    protected DecisionSupportRule parseDecisionSupportRule(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DecisionSupportRule res = new DecisionSupportRule();
        this.parseDomainResourceProperties(json, res);
        if (json.has("moduleMetadata")) {
            res.setModuleMetadata(this.parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i = 0; i < array.size(); ++i) {
                res.getLibrary().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("trigger")) {
            array = json.getAsJsonArray("trigger");
            for (i = 0; i < array.size(); ++i) {
                res.getTrigger().add(this.parseTriggerDefinition(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            res.setConditionElement(this.parseString(json.get("condition").getAsString()));
        }
        if (json.has("_condition")) {
            this.parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseActionDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DecisionSupportServiceModule parseDecisionSupportServiceModule(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DecisionSupportServiceModule res = new DecisionSupportServiceModule();
        this.parseDomainResourceProperties(json, res);
        if (json.has("moduleMetadata")) {
            res.setModuleMetadata(this.parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
        }
        if (json.has("trigger")) {
            array = json.getAsJsonArray("trigger");
            for (i = 0; i < array.size(); ++i) {
                res.getTrigger().add(this.parseTriggerDefinition(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseParameterDefinition(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dataRequirement")) {
            array = json.getAsJsonArray("dataRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getDataRequirement().add(this.parseDataRequirement(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DetectedIssue res = new DetectedIssue();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("implicated")) {
            array = json.getAsJsonArray("implicated");
            for (i = 0; i < array.size(); ++i) {
                res.getImplicated().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("detail")) {
            res.setDetailElement(this.parseString(json.get("detail").getAsString()));
        }
        if (json.has("_detail")) {
            this.parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("mitigation")) {
            array = json.getAsJsonArray("mitigation");
            for (i = 0; i < array.size(); ++i) {
                res.getMitigation().add(this.parseDetectedIssueDetectedIssueMitigationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(json.getAsJsonObject("action")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        return res;
    }

    protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Device res = new Device();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("udiCarrier")) {
            res.setUdiCarrier(this.parseIdentifier(json.getAsJsonObject("udiCarrier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Device.DeviceStatus.NULL, new Device.DeviceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturerElement(this.parseString(json.get("manufacturer").getAsString()));
        }
        if (json.has("_manufacturer")) {
            this.parseElementProperties(json.getAsJsonObject("_manufacturer"), res.getManufacturerElement());
        }
        if (json.has("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(json.get("manufactureDate").getAsString()));
        }
        if (json.has("_manufactureDate")) {
            this.parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("model")) {
            res.setModelElement(this.parseString(json.get("model").getAsString()));
        }
        if (json.has("_model")) {
            this.parseElementProperties(json.getAsJsonObject("_model"), res.getModelElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(json.getAsJsonObject("owner")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DeviceComponent parseDeviceComponent(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DeviceComponent res = new DeviceComponent();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("lastSystemChange")) {
            res.setLastSystemChangeElement(this.parseInstant(json.get("lastSystemChange").getAsString()));
        }
        if (json.has("_lastSystemChange")) {
            this.parseElementProperties(json.getAsJsonObject("_lastSystemChange"), res.getLastSystemChangeElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("operationalStatus")) {
            array = json.getAsJsonArray("operationalStatus");
            for (i = 0; i < array.size(); ++i) {
                res.getOperationalStatus().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parameterGroup")) {
            res.setParameterGroup(this.parseCodeableConcept(json.getAsJsonObject("parameterGroup")));
        }
        if (json.has("measurementPrinciple")) {
            res.setMeasurementPrincipleElement(this.parseEnumeration(json.get("measurementPrinciple").getAsString(), DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
        }
        if (json.has("_measurementPrinciple")) {
            this.parseElementProperties(json.getAsJsonObject("_measurementPrinciple"), res.getMeasurementPrincipleElement());
        }
        if (json.has("productionSpecification")) {
            array = json.getAsJsonArray("productionSpecification");
            for (i = 0; i < array.size(); ++i) {
                res.getProductionSpecification().add(this.parseDeviceComponentDeviceComponentProductionSpecificationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("languageCode")) {
            res.setLanguageCode(this.parseCodeableConcept(json.getAsJsonObject("languageCode")));
        }
        return res;
    }

    protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(JsonObject json, DeviceComponent owner) throws IOException, FHIRFormatError {
        DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("specType")) {
            res.setSpecType(this.parseCodeableConcept(json.getAsJsonObject("specType")));
        }
        if (json.has("componentId")) {
            res.setComponentId(this.parseIdentifier(json.getAsJsonObject("componentId")));
        }
        if (json.has("productionSpec")) {
            res.setProductionSpecElement(this.parseString(json.get("productionSpec").getAsString()));
        }
        if (json.has("_productionSpec")) {
            this.parseElementProperties(json.getAsJsonObject("_productionSpec"), res.getProductionSpecElement());
        }
        return res;
    }

    protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCodeableConcept(json.getAsJsonObject("unit")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        }
        if (json.has("_operationalStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_operationalStatus"), res.getOperationalStatusElement());
        }
        if (json.has("color")) {
            res.setColorElement(this.parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
        }
        if (json.has("_color")) {
            this.parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("measurementPeriod")) {
            res.setMeasurementPeriod(this.parseTiming(json.getAsJsonObject("measurementPeriod")));
        }
        if (json.has("calibration")) {
            JsonArray array = json.getAsJsonArray("calibration");
            for (int i = 0; i < array.size(); ++i) {
                res.getCalibration().add(this.parseDeviceMetricDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(JsonObject json, DeviceMetric owner) throws IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("state")) {
            res.setStateElement(this.parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        }
        if (json.has("_state")) {
            this.parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseInstant(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        return res;
    }

    protected DeviceUseRequest parseDeviceUseRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type timing;
        int i;
        JsonArray array;
        DeviceUseRequest res = new DeviceUseRequest();
        this.parseDomainResourceProperties(json, res);
        Type bodySite = this.parseType("bodySite", json);
        if (bodySite != null) {
            res.setBodySite(bodySite);
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DeviceUseRequest.DeviceUseRequestStatus.NULL, new DeviceUseRequest.DeviceUseRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notes")) {
            array = json.getAsJsonArray("notes");
            for (i = 0; i < array.size(); ++i) {
                res.getNotes().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_notes")) {
            array = json.getAsJsonArray("_notes");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNotes().size()) {
                    res.getNotes().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNotes().get(i));
            }
        }
        if (json.has("prnReason")) {
            array = json.getAsJsonArray("prnReason");
            for (i = 0; i < array.size(); ++i) {
                res.getPrnReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("orderedOn")) {
            res.setOrderedOnElement(this.parseDateTime(json.get("orderedOn").getAsString()));
        }
        if (json.has("_orderedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_orderedOn"), res.getOrderedOnElement());
        }
        if (json.has("recordedOn")) {
            res.setRecordedOnElement(this.parseDateTime(json.get("recordedOn").getAsString()));
        }
        if (json.has("_recordedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), DeviceUseRequest.DeviceUseRequestPriority.NULL, new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        return res;
    }

    protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
        Type timing;
        int i;
        JsonArray array;
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDomainResourceProperties(json, res);
        Type bodySite = this.parseType("bodySite", json);
        if (bodySite != null) {
            res.setBodySite(bodySite);
        }
        if (json.has("whenUsed")) {
            res.setWhenUsed(this.parsePeriod(json.getAsJsonObject("whenUsed")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("notes")) {
            array = json.getAsJsonArray("notes");
            for (i = 0; i < array.size(); ++i) {
                res.getNotes().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_notes")) {
            array = json.getAsJsonArray("_notes");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNotes().size()) {
                    res.getNotes().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNotes().get(i));
            }
        }
        if (json.has("recordedOn")) {
            res.setRecordedOnElement(this.parseDateTime(json.get("recordedOn").getAsString()));
        }
        if (json.has("_recordedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        return res;
    }

    protected DiagnosticOrder parseDiagnosticOrder(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DiagnosticOrder res = new DiagnosticOrder();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), DiagnosticOrder.DiagnosticOrderPriority.NULL, new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("orderer")) {
            res.setOrderer(this.parseReference(json.getAsJsonObject("orderer")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInformation")) {
            array = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specimen")) {
            array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseDiagnosticOrderDiagnosticOrderItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderEventComponent parseDiagnosticOrderDiagnosticOrderEventComponent(JsonObject json, DiagnosticOrder owner) throws IOException, FHIRFormatError {
        DiagnosticOrder.DiagnosticOrderEventComponent res = new DiagnosticOrder.DiagnosticOrderEventComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("description")) {
            res.setDescription(this.parseCodeableConcept(json.getAsJsonObject("description")));
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        return res;
    }

    protected DiagnosticOrder.DiagnosticOrderItemComponent parseDiagnosticOrderDiagnosticOrderItemComponent(JsonObject json, DiagnosticOrder owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DiagnosticOrder.DiagnosticOrderItemComponent res = new DiagnosticOrder.DiagnosticOrderItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("specimen")) {
            array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseDiagnosticOrderDiagnosticOrderEventComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type effective;
        DiagnosticReport res = new DiagnosticReport();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("request")) {
            JsonArray array = json.getAsJsonArray("request");
            for (i = 0; i < array.size(); ++i) {
                res.getRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specimen")) {
            JsonArray array = json.getAsJsonArray("specimen");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecimen().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("result")) {
            JsonArray array = json.getAsJsonArray("result");
            for (i = 0; i < array.size(); ++i) {
                res.getResult().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("imagingStudy")) {
            JsonArray array = json.getAsJsonArray("imagingStudy");
            for (i = 0; i < array.size(); ++i) {
                res.getImagingStudy().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("image")) {
            JsonArray array = json.getAsJsonArray("image");
            for (i = 0; i < array.size(); ++i) {
                res.getImage().add(this.parseDiagnosticReportDiagnosticReportImageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("conclusion")) {
            res.setConclusionElement(this.parseString(json.get("conclusion").getAsString()));
        }
        if (json.has("_conclusion")) {
            this.parseElementProperties(json.getAsJsonObject("_conclusion"), res.getConclusionElement());
        }
        if (json.has("codedDiagnosis")) {
            JsonArray array = json.getAsJsonArray("codedDiagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getCodedDiagnosis().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("presentedForm")) {
            JsonArray array = json.getAsJsonArray("presentedForm");
            for (i = 0; i < array.size(); ++i) {
                res.getPresentedForm().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("link")) {
            res.setLink(this.parseReference(json.getAsJsonObject("link")));
        }
        return res;
    }

    protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DocumentManifest res = new DocumentManifest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(json.getAsJsonObject("masterIdentifier")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentManifestDocumentManifestContentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseDocumentManifestDocumentManifestRelatedComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
        this.parseBackboneProperties(json, res);
        Type p = this.parseType("p", json);
        if (p != null) {
            res.setP(p);
        }
        return res;
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("ref")) {
            res.setRef(this.parseReference(json.getAsJsonObject("ref")));
        }
        return res;
    }

    protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DocumentReference res = new DocumentReference();
        this.parseDomainResourceProperties(json, res);
        if (json.has("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(json.getAsJsonObject("masterIdentifier")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("class")) {
            res.setClass_(this.parseCodeableConcept(json.getAsJsonObject("class")));
        }
        if (json.has("author")) {
            array = json.getAsJsonArray("author");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthor().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("custodian")) {
            res.setCustodian(this.parseReference(json.getAsJsonObject("custodian")));
        }
        if (json.has("authenticator")) {
            res.setAuthenticator(this.parseReference(json.getAsJsonObject("authenticator")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("indexed")) {
            res.setIndexedElement(this.parseInstant(json.get("indexed").getAsString()));
        }
        if (json.has("_indexed")) {
            this.parseElementProperties(json.getAsJsonObject("_indexed"), res.getIndexedElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("docStatus")) {
            res.setDocStatus(this.parseCodeableConcept(json.getAsJsonObject("docStatus")));
        }
        if (json.has("relatesTo")) {
            array = json.getAsJsonArray("relatesTo");
            for (i = 0; i < array.size(); ++i) {
                res.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("securityLabel")) {
            array = json.getAsJsonArray("securityLabel");
            for (i = 0; i < array.size(); ++i) {
                res.getSecurityLabel().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("content")) {
            array = json.getAsJsonArray("content");
            for (i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseDocumentReferenceDocumentReferenceContentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("context")) {
            res.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(json.getAsJsonObject("context"), res));
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("attachment")) {
            res.setAttachment(this.parseAttachment(json.getAsJsonObject("attachment")));
        }
        if (json.has("format")) {
            JsonArray array = json.getAsJsonArray("format");
            for (int i = 0; i < array.size(); ++i) {
                res.getFormat().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("event")) {
            array = json.getAsJsonArray("event");
            for (i = 0; i < array.size(); ++i) {
                res.getEvent().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(json.getAsJsonObject("facilityType")));
        }
        if (json.has("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(json.getAsJsonObject("practiceSetting")));
        }
        if (json.has("sourcePatientInfo")) {
            res.setSourcePatientInfo(this.parseReference(json.getAsJsonObject("sourcePatientInfo")));
        }
        if (json.has("related")) {
            array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseDocumentReferenceDocumentReferenceContextRelatedComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("ref")) {
            res.setRef(this.parseReference(json.getAsJsonObject("ref")));
        }
        return res;
    }

    protected EligibilityRequest parseEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type serviced;
        Type coverage;
        Type patient;
        Type facility;
        Type enterer;
        Type organization;
        Type provider;
        Type target;
        EligibilityRequest res = new EligibilityRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if ((provider = this.parseType("provider", json)) != null) {
            res.setProvider(provider);
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCoding(json.getAsJsonObject("priority")));
        }
        if ((enterer = this.parseType("enterer", json)) != null) {
            res.setEnterer(enterer);
        }
        if ((facility = this.parseType("facility", json)) != null) {
            res.setFacility(facility);
        }
        if ((patient = this.parseType("patient", json)) != null) {
            res.setPatient(patient);
        }
        if ((coverage = this.parseType("coverage", json)) != null) {
            res.setCoverage(coverage);
        }
        if (json.has("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(json.get("businessArrangement").getAsString()));
        }
        if (json.has("_businessArrangement")) {
            this.parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("benefitCategory")) {
            res.setBenefitCategory(this.parseCoding(json.getAsJsonObject("benefitCategory")));
        }
        if (json.has("benefitSubCategory")) {
            res.setBenefitSubCategory(this.parseCoding(json.getAsJsonObject("benefitSubCategory")));
        }
        return res;
    }

    protected EligibilityResponse parseEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type requestOrganization;
        Type requestProvider;
        Type organization;
        Type request;
        EligibilityResponse res = new EligibilityResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((request = this.parseType("request", json)) != null) {
            res.setRequest(request);
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if ((requestProvider = this.parseType("requestProvider", json)) != null) {
            res.setRequestProvider(requestProvider);
        }
        if ((requestOrganization = this.parseType("requestOrganization", json)) != null) {
            res.setRequestOrganization(requestOrganization);
        }
        if (json.has("inforce")) {
            res.setInforceElement(this.parseBoolean(json.get("inforce").getAsBoolean()));
        }
        if (json.has("_inforce")) {
            this.parseElementProperties(json.getAsJsonObject("_inforce"), res.getInforceElement());
        }
        if (json.has("contract")) {
            res.setContract(this.parseReference(json.getAsJsonObject("contract")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("benefitBalance")) {
            array = json.getAsJsonArray("benefitBalance");
            for (i = 0; i < array.size(); ++i) {
                res.getBenefitBalance().add(this.parseEligibilityResponseBenefitsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseEligibilityResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected EligibilityResponse.BenefitsComponent parseEligibilityResponseBenefitsComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
        EligibilityResponse.BenefitsComponent res = new EligibilityResponse.BenefitsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("subCategory")) {
            res.setSubCategory(this.parseCoding(json.getAsJsonObject("subCategory")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCoding(json.getAsJsonObject("network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCoding(json.getAsJsonObject("unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCoding(json.getAsJsonObject("term")));
        }
        if (json.has("financial")) {
            JsonArray array = json.getAsJsonArray("financial");
            for (int i = 0; i < array.size(); ++i) {
                res.getFinancial().add(this.parseEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected EligibilityResponse.BenefitComponent parseEligibilityResponseBenefitComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
        Type benefitUsed;
        Type benefit;
        EligibilityResponse.BenefitComponent res = new EligibilityResponse.BenefitComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((benefit = this.parseType("benefit", json)) != null) {
            res.setBenefit(benefit);
        }
        if ((benefitUsed = this.parseType("benefitUsed", json)) != null) {
            res.setBenefitUsed(benefitUsed);
        }
        return res;
    }

    protected EligibilityResponse.ErrorsComponent parseEligibilityResponseErrorsComponent(JsonObject json, EligibilityResponse owner) throws IOException, FHIRFormatError {
        EligibilityResponse.ErrorsComponent res = new EligibilityResponse.ErrorsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCoding(json.getAsJsonObject("code")));
        }
        return res;
    }

    protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Encounter res = new Encounter();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEncounterEncounterStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("class")) {
            res.setClass_Element(this.parseEnumeration(json.get("class").getAsString(), Encounter.EncounterClass.NULL, new Encounter.EncounterClassEnumFactory()));
        }
        if (json.has("_class")) {
            this.parseElementProperties(json.getAsJsonObject("_class"), res.getClass_Element());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("episodeOfCare")) {
            array = json.getAsJsonArray("episodeOfCare");
            for (i = 0; i < array.size(); ++i) {
                res.getEpisodeOfCare().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("incomingReferral")) {
            array = json.getAsJsonArray("incomingReferral");
            for (i = 0; i < array.size(); ++i) {
                res.getIncomingReferral().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseEncounterEncounterParticipantComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("appointment")) {
            res.setAppointment(this.parseReference(json.getAsJsonObject("appointment")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("length")) {
            res.setLength(this.parseDuration(json.getAsJsonObject("length")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("indication")) {
            array = json.getAsJsonArray("indication");
            for (i = 0; i < array.size(); ++i) {
                res.getIndication().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(json.getAsJsonObject("hospitalization"), res));
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseEncounterEncounterLocationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("serviceProvider")) {
            res.setServiceProvider(this.parseReference(json.getAsJsonObject("serviceProvider")));
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        return res;
    }

    protected Encounter.EncounterStatusHistoryComponent parseEncounterEncounterStatusHistoryComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterStatusHistoryComponent res = new Encounter.EncounterStatusHistoryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterState.NULL, new Encounter.EncounterStateEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            JsonArray array = json.getAsJsonArray("type");
            for (int i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("individual")) {
            res.setIndividual(this.parseReference(json.getAsJsonObject("individual")));
        }
        return res;
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(json.getAsJsonObject("preAdmissionIdentifier")));
        }
        if (json.has("origin")) {
            res.setOrigin(this.parseReference(json.getAsJsonObject("origin")));
        }
        if (json.has("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(json.getAsJsonObject("admitSource")));
        }
        if (json.has("admittingDiagnosis")) {
            array = json.getAsJsonArray("admittingDiagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getAdmittingDiagnosis().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(json.getAsJsonObject("reAdmission")));
        }
        if (json.has("dietPreference")) {
            array = json.getAsJsonArray("dietPreference");
            for (i = 0; i < array.size(); ++i) {
                res.getDietPreference().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialCourtesy")) {
            array = json.getAsJsonArray("specialCourtesy");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialCourtesy().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialArrangement")) {
            array = json.getAsJsonArray("specialArrangement");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialArrangement().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(json.getAsJsonObject("dischargeDisposition")));
        }
        if (json.has("dischargeDiagnosis")) {
            array = json.getAsJsonArray("dischargeDiagnosis");
            for (i = 0; i < array.size(); ++i) {
                res.getDischargeDiagnosis().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject json, Encounter owner) throws IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("provider")) {
            res.setProvider(this.parseReference(json.getAsJsonObject("provider")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseReference(json.getAsJsonObject("coverage")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(json.getAsJsonObject("relationship")));
        }
        return res;
    }

    protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("requestProvider")) {
            res.setRequestProvider(this.parseReference(json.getAsJsonObject("requestProvider")));
        }
        if (json.has("requestOrganization")) {
            res.setRequestOrganization(this.parseReference(json.getAsJsonObject("requestOrganization")));
        }
        return res;
    }

    protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusHistory")) {
            array = json.getAsJsonArray("statusHistory");
            for (i = 0; i < array.size(); ++i) {
                res.getStatusHistory().add(this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("condition")) {
            array = json.getAsJsonArray("condition");
            for (i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("referralRequest")) {
            array = json.getAsJsonArray("referralRequest");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralRequest().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("careManager")) {
            res.setCareManager(this.parseReference(json.getAsJsonObject("careManager")));
        }
        if (json.has("team")) {
            array = json.getAsJsonArray("team");
            for (i = 0; i < array.size(); ++i) {
                res.getTeam().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected ExpansionProfile parseExpansionProfile(JsonObject json) throws IOException, FHIRFormatError {
        ExpansionProfile res = new ExpansionProfile();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            JsonArray array = json.getAsJsonArray("contact");
            for (int i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseExpansionProfileExpansionProfileContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("codeSystem")) {
            res.setCodeSystem(this.parseExpansionProfileExpansionProfileCodeSystemComponent(json.getAsJsonObject("codeSystem"), res));
        }
        if (json.has("includeDesignations")) {
            res.setIncludeDesignationsElement(this.parseBoolean(json.get("includeDesignations").getAsBoolean()));
        }
        if (json.has("_includeDesignations")) {
            this.parseElementProperties(json.getAsJsonObject("_includeDesignations"), res.getIncludeDesignationsElement());
        }
        if (json.has("designation")) {
            res.setDesignation(this.parseExpansionProfileExpansionProfileDesignationComponent(json.getAsJsonObject("designation"), res));
        }
        if (json.has("includeDefinition")) {
            res.setIncludeDefinitionElement(this.parseBoolean(json.get("includeDefinition").getAsBoolean()));
        }
        if (json.has("_includeDefinition")) {
            this.parseElementProperties(json.getAsJsonObject("_includeDefinition"), res.getIncludeDefinitionElement());
        }
        if (json.has("includeInactive")) {
            res.setIncludeInactiveElement(this.parseBoolean(json.get("includeInactive").getAsBoolean()));
        }
        if (json.has("_includeInactive")) {
            this.parseElementProperties(json.getAsJsonObject("_includeInactive"), res.getIncludeInactiveElement());
        }
        if (json.has("excludeNested")) {
            res.setExcludeNestedElement(this.parseBoolean(json.get("excludeNested").getAsBoolean()));
        }
        if (json.has("_excludeNested")) {
            this.parseElementProperties(json.getAsJsonObject("_excludeNested"), res.getExcludeNestedElement());
        }
        if (json.has("excludeNotForUI")) {
            res.setExcludeNotForUIElement(this.parseBoolean(json.get("excludeNotForUI").getAsBoolean()));
        }
        if (json.has("_excludeNotForUI")) {
            this.parseElementProperties(json.getAsJsonObject("_excludeNotForUI"), res.getExcludeNotForUIElement());
        }
        if (json.has("excludePostCoordinated")) {
            res.setExcludePostCoordinatedElement(this.parseBoolean(json.get("excludePostCoordinated").getAsBoolean()));
        }
        if (json.has("_excludePostCoordinated")) {
            this.parseElementProperties(json.getAsJsonObject("_excludePostCoordinated"), res.getExcludePostCoordinatedElement());
        }
        if (json.has("displayLanguage")) {
            res.setDisplayLanguageElement(this.parseCode(json.get("displayLanguage").getAsString()));
        }
        if (json.has("_displayLanguage")) {
            this.parseElementProperties(json.getAsJsonObject("_displayLanguage"), res.getDisplayLanguageElement());
        }
        if (json.has("limitedExpansion")) {
            res.setLimitedExpansionElement(this.parseBoolean(json.get("limitedExpansion").getAsBoolean()));
        }
        if (json.has("_limitedExpansion")) {
            this.parseElementProperties(json.getAsJsonObject("_limitedExpansion"), res.getLimitedExpansionElement());
        }
        return res;
    }

    protected ExpansionProfile.ExpansionProfileContactComponent parseExpansionProfileExpansionProfileContactComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileContactComponent res = new ExpansionProfile.ExpansionProfileContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ExpansionProfile.ExpansionProfileCodeSystemComponent parseExpansionProfileExpansionProfileCodeSystemComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileCodeSystemComponent res = new ExpansionProfile.ExpansionProfileCodeSystemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("include")) {
            res.setInclude(this.parseExpansionProfileCodeSystemIncludeComponent(json.getAsJsonObject("include"), owner));
        }
        if (json.has("exclude")) {
            res.setExclude(this.parseExpansionProfileCodeSystemExcludeComponent(json.getAsJsonObject("exclude"), owner));
        }
        return res;
    }

    protected ExpansionProfile.CodeSystemIncludeComponent parseExpansionProfileCodeSystemIncludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemIncludeComponent res = new ExpansionProfile.CodeSystemIncludeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("codeSystem")) {
            JsonArray array = json.getAsJsonArray("codeSystem");
            for (int i = 0; i < array.size(); ++i) {
                res.getCodeSystem().add(this.parseExpansionProfileCodeSystemIncludeCodeSystemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExpansionProfile.CodeSystemIncludeCodeSystemComponent parseExpansionProfileCodeSystemIncludeCodeSystemComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemIncludeCodeSystemComponent res = new ExpansionProfile.CodeSystemIncludeCodeSystemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        return res;
    }

    protected ExpansionProfile.CodeSystemExcludeComponent parseExpansionProfileCodeSystemExcludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemExcludeComponent res = new ExpansionProfile.CodeSystemExcludeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("codeSystem")) {
            JsonArray array = json.getAsJsonArray("codeSystem");
            for (int i = 0; i < array.size(); ++i) {
                res.getCodeSystem().add(this.parseExpansionProfileCodeSystemExcludeCodeSystemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExpansionProfile.CodeSystemExcludeCodeSystemComponent parseExpansionProfileCodeSystemExcludeCodeSystemComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.CodeSystemExcludeCodeSystemComponent res = new ExpansionProfile.CodeSystemExcludeCodeSystemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        return res;
    }

    protected ExpansionProfile.ExpansionProfileDesignationComponent parseExpansionProfileExpansionProfileDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.ExpansionProfileDesignationComponent res = new ExpansionProfile.ExpansionProfileDesignationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("include")) {
            res.setInclude(this.parseExpansionProfileDesignationIncludeComponent(json.getAsJsonObject("include"), owner));
        }
        if (json.has("exclude")) {
            res.setExclude(this.parseExpansionProfileDesignationExcludeComponent(json.getAsJsonObject("exclude"), owner));
        }
        return res;
    }

    protected ExpansionProfile.DesignationIncludeComponent parseExpansionProfileDesignationIncludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeComponent res = new ExpansionProfile.DesignationIncludeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("designation")) {
            JsonArray array = json.getAsJsonArray("designation");
            for (int i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseExpansionProfileDesignationIncludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExpansionProfile.DesignationIncludeDesignationComponent parseExpansionProfileDesignationIncludeDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationIncludeDesignationComponent res = new ExpansionProfile.DesignationIncludeDesignationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
        return res;
    }

    protected ExpansionProfile.DesignationExcludeComponent parseExpansionProfileDesignationExcludeComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeComponent res = new ExpansionProfile.DesignationExcludeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("designation")) {
            JsonArray array = json.getAsJsonArray("designation");
            for (int i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseExpansionProfileDesignationExcludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExpansionProfile.DesignationExcludeDesignationComponent parseExpansionProfileDesignationExcludeDesignationComponent(JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
        ExpansionProfile.DesignationExcludeDesignationComponent res = new ExpansionProfile.DesignationExcludeDesignationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
        return res;
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type accidentLocation;
        Type patient;
        int i2;
        JsonArray array2;
        Type referral;
        Type originalPrescription;
        Type prescription;
        Type facility;
        Type organization;
        Type provider;
        Type claimResponse;
        Type claim;
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array3 = json.getAsJsonArray("identifier");
            for (int i3 = 0; i3 < array3.size(); ++i3) {
                res.getIdentifier().add(this.parseIdentifier(array3.get(i3).getAsJsonObject()));
            }
        }
        if ((claim = this.parseType("claim", json)) != null) {
            res.setClaim(claim);
        }
        if ((claimResponse = this.parseType("claimResponse", json)) != null) {
            res.setClaimResponse(claimResponse);
        }
        if (json.has("subType")) {
            JsonArray array4 = json.getAsJsonArray("subType");
            for (int i4 = 0; i4 < array4.size(); ++i4) {
                res.getSubType().add(this.parseCoding(array4.get(i4).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(json.getAsJsonObject("billablePeriod")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if ((provider = this.parseType("provider", json)) != null) {
            res.setProvider(provider);
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if ((facility = this.parseType("facility", json)) != null) {
            res.setFacility(facility);
        }
        if (json.has("related")) {
            JsonArray array5 = json.getAsJsonArray("related");
            for (int i5 = 0; i5 < array5.size(); ++i5) {
                res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimsComponent(array5.get(i5).getAsJsonObject(), res));
            }
        }
        if ((prescription = this.parseType("prescription", json)) != null) {
            res.setPrescription(prescription);
        }
        if ((originalPrescription = this.parseType("originalPrescription", json)) != null) {
            res.setOriginalPrescription(originalPrescription);
        }
        if (json.has("payee")) {
            res.setPayee(this.parseExplanationOfBenefitPayeeComponent(json.getAsJsonObject("payee"), res));
        }
        if ((referral = this.parseType("referral", json)) != null) {
            res.setReferral(referral);
        }
        if (json.has("occurrenceCode")) {
            array2 = json.getAsJsonArray("occurrenceCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getOccurrenceCode().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("occurenceSpanCode")) {
            array2 = json.getAsJsonArray("occurenceSpanCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getOccurenceSpanCode().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("valueCode")) {
            array2 = json.getAsJsonArray("valueCode");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getValueCode().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("diagnosis")) {
            array2 = json.getAsJsonArray("diagnosis");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("procedure")) {
            array2 = json.getAsJsonArray("procedure");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(array2.get(i2).getAsJsonObject(), res));
            }
        }
        if (json.has("specialCondition")) {
            array2 = json.getAsJsonArray("specialCondition");
            for (i2 = 0; i2 < array2.size(); ++i2) {
                res.getSpecialCondition().add(this.parseCoding(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((patient = this.parseType("patient", json)) != null) {
            res.setPatient(patient);
        }
        if (json.has("precedence")) {
            res.setPrecedenceElement(this.parsePositiveInt(json.get("precedence").getAsString()));
        }
        if (json.has("_precedence")) {
            this.parseElementProperties(json.getAsJsonObject("_precedence"), res.getPrecedenceElement());
        }
        if (json.has("coverage")) {
            res.setCoverage(this.parseExplanationOfBenefitCoverageComponent(json.getAsJsonObject("coverage"), res));
        }
        if (json.has("accidentDate")) {
            res.setAccidentDateElement(this.parseDate(json.get("accidentDate").getAsString()));
        }
        if (json.has("_accidentDate")) {
            this.parseElementProperties(json.getAsJsonObject("_accidentDate"), res.getAccidentDateElement());
        }
        if (json.has("accidentType")) {
            res.setAccidentType(this.parseCoding(json.getAsJsonObject("accidentType")));
        }
        if ((accidentLocation = this.parseType("accidentLocation", json)) != null) {
            res.setAccidentLocation(accidentLocation);
        }
        if (json.has("interventionException")) {
            array = json.getAsJsonArray("interventionException");
            for (i = 0; i < array.size(); ++i) {
                res.getInterventionException().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("onset")) {
            array = json.getAsJsonArray("onset");
            for (i = 0; i < array.size(); ++i) {
                res.getOnset().add(this.parseExplanationOfBenefitOnsetComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("employmentImpacted")) {
            res.setEmploymentImpacted(this.parsePeriod(json.getAsJsonObject("employmentImpacted")));
        }
        if (json.has("hospitalization")) {
            res.setHospitalization(this.parsePeriod(json.getAsJsonObject("hospitalization")));
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseExplanationOfBenefitItemsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("addItem")) {
            array = json.getAsJsonArray("addItem");
            for (i = 0; i < array.size(); ++i) {
                res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("missingTeeth")) {
            array = json.getAsJsonArray("missingTeeth");
            for (i = 0; i < array.size(); ++i) {
                res.getMissingTeeth().add(this.parseExplanationOfBenefitMissingTeethComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("totalCost")) {
            res.setTotalCost(this.parseMoney(json.getAsJsonObject("totalCost")));
        }
        if (json.has("unallocDeductable")) {
            res.setUnallocDeductable(this.parseMoney(json.getAsJsonObject("unallocDeductable")));
        }
        if (json.has("totalBenefit")) {
            res.setTotalBenefit(this.parseMoney(json.getAsJsonObject("totalBenefit")));
        }
        if (json.has("paymentAdjustment")) {
            res.setPaymentAdjustment(this.parseMoney(json.getAsJsonObject("paymentAdjustment")));
        }
        if (json.has("paymentAdjustmentReason")) {
            res.setPaymentAdjustmentReason(this.parseCoding(json.getAsJsonObject("paymentAdjustmentReason")));
        }
        if (json.has("paymentDate")) {
            res.setPaymentDateElement(this.parseDate(json.get("paymentDate").getAsString()));
        }
        if (json.has("_paymentDate")) {
            this.parseElementProperties(json.getAsJsonObject("_paymentDate"), res.getPaymentDateElement());
        }
        if (json.has("paymentAmount")) {
            res.setPaymentAmount(this.parseMoney(json.getAsJsonObject("paymentAmount")));
        }
        if (json.has("paymentRef")) {
            res.setPaymentRef(this.parseIdentifier(json.getAsJsonObject("paymentRef")));
        }
        if (json.has("reserved")) {
            res.setReserved(this.parseCoding(json.getAsJsonObject("reserved")));
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseExplanationOfBenefitNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("benefitBalance")) {
            array = json.getAsJsonArray("benefitBalance");
            for (i = 0; i < array.size(); ++i) {
                res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ExplanationOfBenefit.RelatedClaimsComponent parseExplanationOfBenefitRelatedClaimsComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimsComponent res = new ExplanationOfBenefit.RelatedClaimsComponent();
        this.parseBackboneProperties(json, res);
        Type claim = this.parseType("claim", json);
        if (claim != null) {
            res.setClaim(claim);
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCoding(json.getAsJsonObject("relationship")));
        }
        if (json.has("reference")) {
            res.setReference(this.parseIdentifier(json.getAsJsonObject("reference")));
        }
        return res;
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        Type party;
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((party = this.parseType("party", json)) != null) {
            res.setParty(party);
        }
        return res;
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("diagnosis")) {
            res.setDiagnosis(this.parseCoding(json.getAsJsonObject("diagnosis")));
        }
        return res;
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        Type procedure;
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if ((procedure = this.parseType("procedure", json)) != null) {
            res.setProcedure(procedure);
        }
        return res;
    }

    protected ExplanationOfBenefit.CoverageComponent parseExplanationOfBenefitCoverageComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ExplanationOfBenefit.CoverageComponent res = new ExplanationOfBenefit.CoverageComponent();
        this.parseBackboneProperties(json, res);
        Type coverage = this.parseType("coverage", json);
        if (coverage != null) {
            res.setCoverage(coverage);
        }
        if (json.has("preAuthRef")) {
            array = json.getAsJsonArray("preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                res.getPreAuthRef().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_preAuthRef")) {
            array = json.getAsJsonArray("_preAuthRef");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPreAuthRef().size()) {
                    res.getPreAuthRef().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
            }
        }
        return res;
    }

    protected ExplanationOfBenefit.OnsetComponent parseExplanationOfBenefitOnsetComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.OnsetComponent res = new ExplanationOfBenefit.OnsetComponent();
        this.parseBackboneProperties(json, res);
        Type time = this.parseType("time", json);
        if (time != null) {
            res.setTime(time);
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        return res;
    }

    protected ExplanationOfBenefit.ItemsComponent parseExplanationOfBenefitItemsComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        int i;
        Type serviced;
        int i2;
        JsonArray array;
        Type supervisor;
        Type provider;
        ExplanationOfBenefit.ItemsComponent res = new ExplanationOfBenefit.ItemsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((provider = this.parseType("provider", json)) != null) {
            res.setProvider(provider);
        }
        if ((supervisor = this.parseType("supervisor", json)) != null) {
            res.setSupervisor(supervisor);
        }
        if (json.has("providerQualification")) {
            res.setProviderQualification(this.parseCoding(json.getAsJsonObject("providerQualification")));
        }
        if (json.has("diagnosisLinkId")) {
            array = json.getAsJsonArray("diagnosisLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getDiagnosisLinkId().add(this.parsePositiveInt(array.get(i2).getAsString()));
            }
        }
        if (json.has("_diagnosisLinkId")) {
            array = json.getAsJsonArray("_diagnosisLinkId");
            for (i2 = 0; i2 < array.size(); ++i2) {
                if (i2 == res.getDiagnosisLinkId().size()) {
                    res.getDiagnosisLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i2) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i2).getAsJsonObject(), res.getDiagnosisLinkId().get(i2));
            }
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("serviceModifier")) {
            array = json.getAsJsonArray("serviceModifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getServiceModifier().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("modifier")) {
            array = json.getAsJsonArray("modifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getModifier().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getProgramCode().add(this.parseCoding(array.get(i2).getAsJsonObject()));
            }
        }
        if ((serviced = this.parseType("serviced", json)) != null) {
            res.setServiced(serviced);
        }
        if (json.has("place")) {
            res.setPlace(this.parseCoding(json.getAsJsonObject("place")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            JsonArray array2 = json.getAsJsonArray("udi");
            for (i = 0; i < array2.size(); ++i) {
                res.getUdi().add(this.parseReference(array2.get(i).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCoding(json.getAsJsonObject("bodySite")));
        }
        if (json.has("subSite")) {
            JsonArray array3 = json.getAsJsonArray("subSite");
            for (i = 0; i < array3.size(); ++i) {
                res.getSubSite().add(this.parseCoding(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("noteNumber")) {
            JsonArray array4 = json.getAsJsonArray("noteNumber");
            for (i = 0; i < array4.size(); ++i) {
                res.getNoteNumber().add(this.parsePositiveInt(array4.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumber")) {
            JsonArray array5 = json.getAsJsonArray("_noteNumber");
            for (i = 0; i < array5.size(); ++i) {
                if (i == res.getNoteNumber().size()) {
                    res.getNoteNumber().add(this.parsePositiveInt(null));
                }
                if (!(array5.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array5.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
            }
        }
        if (json.has("adjudication")) {
            JsonArray array6 = json.getAsJsonArray("adjudication");
            for (i = 0; i < array6.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitItemAdjudicationComponent(array6.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            JsonArray array7 = json.getAsJsonArray("detail");
            for (i = 0; i < array7.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(array7.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("prosthesis")) {
            res.setProsthesis(this.parseExplanationOfBenefitProsthesisComponent(json.getAsJsonObject("prosthesis"), owner));
        }
        return res;
    }

    protected ExplanationOfBenefit.ItemAdjudicationComponent parseExplanationOfBenefitItemAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemAdjudicationComponent res = new ExplanationOfBenefit.ItemAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("subDetail")) {
            array = json.getAsJsonArray("subDetail");
            for (i = 0; i < array.size(); ++i) {
                res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExplanationOfBenefit.DetailAdjudicationComponent parseExplanationOfBenefitDetailAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailAdjudicationComponent res = new ExplanationOfBenefit.DetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(json.get("sequence").getAsString()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("programCode")) {
            array = json.getAsJsonArray("programCode");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("unitPrice")) {
            res.setUnitPrice(this.parseMoney(json.getAsJsonObject("unitPrice")));
        }
        if (json.has("factor")) {
            res.setFactorElement(this.parseDecimal(json.get("factor").getAsBigDecimal()));
        }
        if (json.has("_factor")) {
            this.parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
        }
        if (json.has("points")) {
            res.setPointsElement(this.parseDecimal(json.get("points").getAsBigDecimal()));
        }
        if (json.has("_points")) {
            this.parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
        }
        if (json.has("net")) {
            res.setNet(this.parseMoney(json.getAsJsonObject("net")));
        }
        if (json.has("udi")) {
            array = json.getAsJsonArray("udi");
            for (i = 0; i < array.size(); ++i) {
                res.getUdi().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitSubDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExplanationOfBenefit.SubDetailAdjudicationComponent parseExplanationOfBenefitSubDetailAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailAdjudicationComponent res = new ExplanationOfBenefit.SubDetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ExplanationOfBenefit.ProsthesisComponent parseExplanationOfBenefitProsthesisComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.ProsthesisComponent res = new ExplanationOfBenefit.ProsthesisComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("initial")) {
            res.setInitialElement(this.parseBoolean(json.get("initial").getAsBoolean()));
        }
        if (json.has("_initial")) {
            this.parseElementProperties(json.getAsJsonObject("_initial"), res.getInitialElement());
        }
        if (json.has("priorDate")) {
            res.setPriorDateElement(this.parseDate(json.get("priorDate").getAsString()));
        }
        if (json.has("_priorDate")) {
            this.parseElementProperties(json.getAsJsonObject("_priorDate"), res.getPriorDateElement());
        }
        if (json.has("priorMaterial")) {
            res.setPriorMaterial(this.parseCoding(json.getAsJsonObject("priorMaterial")));
        }
        return res;
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            array = json.getAsJsonArray("sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getSequenceLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_sequenceLinkId")) {
            array = json.getAsJsonArray("_sequenceLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSequenceLinkId().size()) {
                    res.getSequenceLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
            }
        }
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("noteNumberLinkId")) {
            array = json.getAsJsonArray("noteNumberLinkId");
            for (i = 0; i < array.size(); ++i) {
                res.getNoteNumberLinkId().add(this.parsePositiveInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_noteNumberLinkId")) {
            array = json.getAsJsonArray("_noteNumberLinkId");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNoteNumberLinkId().size()) {
                    res.getNoteNumberLinkId().add(this.parsePositiveInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumberLinkId().get(i));
            }
        }
        if (json.has("adjudication")) {
            array = json.getAsJsonArray("adjudication");
            for (i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAddedItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseExplanationOfBenefitAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExplanationOfBenefit.AddedItemAdjudicationComponent parseExplanationOfBenefitAddedItemAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemAdjudicationComponent res = new ExplanationOfBenefit.AddedItemAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ExplanationOfBenefit.AddedItemsDetailComponent parseExplanationOfBenefitAddedItemsDetailComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemsDetailComponent res = new ExplanationOfBenefit.AddedItemsDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("service")) {
            res.setService(this.parseCoding(json.getAsJsonObject("service")));
        }
        if (json.has("fee")) {
            res.setFee(this.parseMoney(json.getAsJsonObject("fee")));
        }
        if (json.has("adjudication")) {
            JsonArray array = json.getAsJsonArray("adjudication");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdjudication().add(this.parseExplanationOfBenefitAddedItemDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExplanationOfBenefit.AddedItemDetailAdjudicationComponent parseExplanationOfBenefitAddedItemDetailAdjudicationComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailAdjudicationComponent res = new ExplanationOfBenefit.AddedItemDetailAdjudicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDecimal(json.get("value").getAsBigDecimal()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ExplanationOfBenefit.MissingTeethComponent parseExplanationOfBenefitMissingTeethComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.MissingTeethComponent res = new ExplanationOfBenefit.MissingTeethComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("tooth")) {
            res.setTooth(this.parseCoding(json.getAsJsonObject("tooth")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCoding(json.getAsJsonObject("reason")));
        }
        if (json.has("extractionDate")) {
            res.setExtractionDateElement(this.parseDate(json.get("extractionDate").getAsString()));
        }
        if (json.has("_extractionDate")) {
            this.parseElementProperties(json.getAsJsonObject("_extractionDate"), res.getExtractionDateElement());
        }
        return res;
    }

    protected ExplanationOfBenefit.NotesComponent parseExplanationOfBenefitNotesComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.NotesComponent res = new ExplanationOfBenefit.NotesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            res.setNumberElement(this.parsePositiveInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategory(this.parseCoding(json.getAsJsonObject("category")));
        }
        if (json.has("subCategory")) {
            res.setSubCategory(this.parseCoding(json.getAsJsonObject("subCategory")));
        }
        if (json.has("network")) {
            res.setNetwork(this.parseCoding(json.getAsJsonObject("network")));
        }
        if (json.has("unit")) {
            res.setUnit(this.parseCoding(json.getAsJsonObject("unit")));
        }
        if (json.has("term")) {
            res.setTerm(this.parseCoding(json.getAsJsonObject("term")));
        }
        if (json.has("financial")) {
            JsonArray array = json.getAsJsonArray("financial");
            for (int i = 0; i < array.size(); ++i) {
                res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
        Type benefitUsed;
        Type benefit;
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((benefit = this.parseType("benefit", json)) != null) {
            res.setBenefit(benefit);
        }
        if ((benefitUsed = this.parseType("benefitUsed", json)) != null) {
            res.setBenefitUsed(benefitUsed);
        }
        return res;
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
        Type deceased;
        Type age;
        Type born;
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if ((born = this.parseType("born", json)) != null) {
            res.setBorn(born);
        }
        if ((age = this.parseType("age", json)) != null) {
            res.setAge(age);
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        if (json.has("condition")) {
            JsonArray array = json.getAsJsonArray("condition");
            for (int i = 0; i < array.size(); ++i) {
                res.getCondition().add(this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(JsonObject json, FamilyMemberHistory owner) throws IOException, FHIRFormatError {
        Type onset;
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if ((onset = this.parseType("onset", json)) != null) {
            res.setOnset(onset);
        }
        if (json.has("note")) {
            res.setNote(this.parseAnnotation(json.getAsJsonObject("note")));
        }
        return res;
    }

    protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        return res;
    }

    protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type target;
        Type start;
        Goal res = new Goal();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if ((start = this.parseType("start", json)) != null) {
            res.setStart(start);
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("statusDate")) {
            res.setStatusDateElement(this.parseDate(json.get("statusDate").getAsString()));
        }
        if (json.has("_statusDate")) {
            this.parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
        }
        if (json.has("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(json.getAsJsonObject("statusReason")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("addresses")) {
            array = json.getAsJsonArray("addresses");
            for (i = 0; i < array.size(); ++i) {
                res.getAddresses().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outcome")) {
            array = json.getAsJsonArray("outcome");
            for (i = 0; i < array.size(); ++i) {
                res.getOutcome().add(this.parseGoalGoalOutcomeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Goal.GoalOutcomeComponent parseGoalGoalOutcomeComponent(JsonObject json, Goal owner) throws IOException, FHIRFormatError {
        Goal.GoalOutcomeComponent res = new Goal.GoalOutcomeComponent();
        this.parseBackboneProperties(json, res);
        Type result = this.parseType("result", json);
        if (result != null) {
            res.setResult(result);
        }
        return res;
    }

    protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Group res = new Group();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("actual")) {
            res.setActualElement(this.parseBoolean(json.get("actual").getAsBoolean()));
        }
        if (json.has("_actual")) {
            this.parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("quantity")) {
            res.setQuantityElement(this.parseUnsignedInt(json.get("quantity").getAsString()));
        }
        if (json.has("_quantity")) {
            this.parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("member")) {
            array = json.getAsJsonArray("member");
            for (i = 0; i < array.size(); ++i) {
                res.getMember().add(this.parseGroupGroupMemberComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
        Type value;
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("exclude")) {
            res.setExcludeElement(this.parseBoolean(json.get("exclude").getAsBoolean()));
        }
        if (json.has("_exclude")) {
            this.parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Group.GroupMemberComponent parseGroupGroupMemberComponent(JsonObject json, Group owner) throws IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("entity")) {
            res.setEntity(this.parseReference(json.getAsJsonObject("entity")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("inactive")) {
            res.setInactiveElement(this.parseBoolean(json.get("inactive").getAsBoolean()));
        }
        if (json.has("_inactive")) {
            this.parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
        }
        return res;
    }

    protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        GuidanceResponse res = new GuidanceResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("requestId")) {
            res.setRequestIdElement(this.parseString(json.get("requestId").getAsString()));
        }
        if (json.has("_requestId")) {
            this.parseElementProperties(json.getAsJsonObject("_requestId"), res.getRequestIdElement());
        }
        if (json.has("module")) {
            res.setModule(this.parseReference(json.getAsJsonObject("module")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("evaluationMessage")) {
            array = json.getAsJsonArray("evaluationMessage");
            for (i = 0; i < array.size(); ++i) {
                res.getEvaluationMessage().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("outputParameters")) {
            res.setOutputParameters(this.parseReference(json.getAsJsonObject("outputParameters")));
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseGuidanceResponseGuidanceResponseActionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("dataRequirement")) {
            array = json.getAsJsonArray("dataRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getDataRequirement().add(this.parseDataRequirement(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected GuidanceResponse.GuidanceResponseActionComponent parseGuidanceResponseGuidanceResponseActionComponent(JsonObject json, GuidanceResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        GuidanceResponse.GuidanceResponseActionComponent res = new GuidanceResponse.GuidanceResponseActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actionIdentifier")) {
            res.setActionIdentifier(this.parseIdentifier(json.getAsJsonObject("actionIdentifier")));
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("textEquivalent")) {
            res.setTextEquivalentElement(this.parseString(json.get("textEquivalent").getAsString()));
        }
        if (json.has("_textEquivalent")) {
            this.parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingEvidence")) {
            array = json.getAsJsonArray("supportingEvidence");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingEvidence().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("relatedAction")) {
            res.setRelatedAction(this.parseGuidanceResponseGuidanceResponseActionRelatedActionComponent(json.getAsJsonObject("relatedAction"), owner));
        }
        if (json.has("documentation")) {
            array = json.getAsJsonArray("documentation");
            for (i = 0; i < array.size(); ++i) {
                res.getDocumentation().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("participant")) {
            array = json.getAsJsonArray("participant");
            for (i = 0; i < array.size(); ++i) {
                res.getParticipant().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("behavior")) {
            array = json.getAsJsonArray("behavior");
            for (i = 0; i < array.size(); ++i) {
                res.getBehavior().add(this.parseGuidanceResponseGuidanceResponseActionBehaviorComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseGuidanceResponseGuidanceResponseActionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected GuidanceResponse.GuidanceResponseActionRelatedActionComponent parseGuidanceResponseGuidanceResponseActionRelatedActionComponent(JsonObject json, GuidanceResponse owner) throws IOException, FHIRFormatError {
        Type offset;
        GuidanceResponse.GuidanceResponseActionRelatedActionComponent res = new GuidanceResponse.GuidanceResponseActionRelatedActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actionIdentifier")) {
            res.setActionIdentifier(this.parseIdentifier(json.getAsJsonObject("actionIdentifier")));
        }
        if (json.has("relationship")) {
            res.setRelationshipElement(this.parseCode(json.get("relationship").getAsString()));
        }
        if (json.has("_relationship")) {
            this.parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
        }
        if ((offset = this.parseType("offset", json)) != null) {
            res.setOffset(offset);
        }
        if (json.has("anchor")) {
            res.setAnchorElement(this.parseCode(json.get("anchor").getAsString()));
        }
        if (json.has("_anchor")) {
            this.parseElementProperties(json.getAsJsonObject("_anchor"), res.getAnchorElement());
        }
        return res;
    }

    protected GuidanceResponse.GuidanceResponseActionBehaviorComponent parseGuidanceResponseGuidanceResponseActionBehaviorComponent(JsonObject json, GuidanceResponse owner) throws IOException, FHIRFormatError {
        GuidanceResponse.GuidanceResponseActionBehaviorComponent res = new GuidanceResponse.GuidanceResponseActionBehaviorComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("value")) {
            res.setValue(this.parseCoding(json.getAsJsonObject("value")));
        }
        return res;
    }

    protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        HealthcareService res = new HealthcareService();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("providedBy")) {
            res.setProvidedBy(this.parseReference(json.getAsJsonObject("providedBy")));
        }
        if (json.has("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceName")) {
            res.setServiceNameElement(this.parseString(json.get("serviceName").getAsString()));
        }
        if (json.has("_serviceName")) {
            this.parseElementProperties(json.getAsJsonObject("_serviceName"), res.getServiceNameElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("extraDetails")) {
            res.setExtraDetailsElement(this.parseString(json.get("extraDetails").getAsString()));
        }
        if (json.has("_extraDetails")) {
            this.parseElementProperties(json.getAsJsonObject("_extraDetails"), res.getExtraDetailsElement());
        }
        if (json.has("photo")) {
            res.setPhoto(this.parseAttachment(json.getAsJsonObject("photo")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("coverageArea")) {
            array = json.getAsJsonArray("coverageArea");
            for (i = 0; i < array.size(); ++i) {
                res.getCoverageArea().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceProvisionCode")) {
            array = json.getAsJsonArray("serviceProvisionCode");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceProvisionCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("eligibility")) {
            res.setEligibility(this.parseCodeableConcept(json.getAsJsonObject("eligibility")));
        }
        if (json.has("eligibilityNote")) {
            res.setEligibilityNoteElement(this.parseString(json.get("eligibilityNote").getAsString()));
        }
        if (json.has("_eligibilityNote")) {
            this.parseElementProperties(json.getAsJsonObject("_eligibilityNote"), res.getEligibilityNoteElement());
        }
        if (json.has("programName")) {
            array = json.getAsJsonArray("programName");
            for (i = 0; i < array.size(); ++i) {
                res.getProgramName().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_programName")) {
            array = json.getAsJsonArray("_programName");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getProgramName().size()) {
                    res.getProgramName().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getProgramName().get(i));
            }
        }
        if (json.has("characteristic")) {
            array = json.getAsJsonArray("characteristic");
            for (i = 0; i < array.size(); ++i) {
                res.getCharacteristic().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referralMethod")) {
            array = json.getAsJsonArray("referralMethod");
            for (i = 0; i < array.size(); ++i) {
                res.getReferralMethod().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("publicKey")) {
            res.setPublicKeyElement(this.parseString(json.get("publicKey").getAsString()));
        }
        if (json.has("_publicKey")) {
            this.parseElementProperties(json.getAsJsonObject("_publicKey"), res.getPublicKeyElement());
        }
        if (json.has("appointmentRequired")) {
            res.setAppointmentRequiredElement(this.parseBoolean(json.get("appointmentRequired").getAsBoolean()));
        }
        if (json.has("_appointmentRequired")) {
            this.parseElementProperties(json.getAsJsonObject("_appointmentRequired"), res.getAppointmentRequiredElement());
        }
        if (json.has("availableTime")) {
            array = json.getAsJsonArray("availableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getAvailableTime().add(this.parseHealthcareServiceHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("notAvailable")) {
            array = json.getAsJsonArray("notAvailable");
            for (i = 0; i < array.size(); ++i) {
                res.getNotAvailable().add(this.parseHealthcareServiceHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(json.get("availabilityExceptions").getAsString()));
        }
        if (json.has("_availabilityExceptions")) {
            this.parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
        }
        return res;
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("daysOfWeek")) {
            array = json.getAsJsonArray("daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                res.getDaysOfWeek().add(this.parseEnumeration(array.get(i).getAsString(), HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
            }
        }
        if (json.has("_daysOfWeek")) {
            array = json.getAsJsonArray("_daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDaysOfWeek().size()) {
                    res.getDaysOfWeek().add(this.parseEnumeration(null, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
            }
        }
        if (json.has("allDay")) {
            res.setAllDayElement(this.parseBoolean(json.get("allDay").getAsBoolean()));
        }
        if (json.has("_allDay")) {
            this.parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
        }
        if (json.has("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(json.get("availableStartTime").getAsString()));
        }
        if (json.has("_availableStartTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
        }
        if (json.has("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(json.get("availableEndTime").getAsString()));
        }
        if (json.has("_availableEndTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
        }
        return res;
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("during")) {
            res.setDuring(this.parsePeriod(json.getAsJsonObject("during")));
        }
        return res;
    }

    protected ImagingExcerpt parseImagingExcerpt(JsonObject json) throws IOException, FHIRFormatError {
        ImagingExcerpt res = new ImagingExcerpt();
        this.parseDomainResourceProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("authoringTime")) {
            res.setAuthoringTimeElement(this.parseDateTime(json.get("authoringTime").getAsString()));
        }
        if (json.has("_authoringTime")) {
            this.parseElementProperties(json.getAsJsonObject("_authoringTime"), res.getAuthoringTimeElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("title")) {
            res.setTitle(this.parseCodeableConcept(json.getAsJsonObject("title")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("study")) {
            JsonArray array = json.getAsJsonArray("study");
            for (int i = 0; i < array.size(); ++i) {
                res.getStudy().add(this.parseImagingExcerptStudyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ImagingExcerpt.StudyComponent parseImagingExcerptStudyComponent(JsonObject json, ImagingExcerpt owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImagingExcerpt.StudyComponent res = new ImagingExcerpt.StudyComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("imagingStudy")) {
            res.setImagingStudy(this.parseReference(json.getAsJsonObject("imagingStudy")));
        }
        if (json.has("dicom")) {
            array = json.getAsJsonArray("dicom");
            for (i = 0; i < array.size(); ++i) {
                res.getDicom().add(this.parseImagingExcerptStudyDicomComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("viewable")) {
            array = json.getAsJsonArray("viewable");
            for (i = 0; i < array.size(); ++i) {
                res.getViewable().add(this.parseImagingExcerptStudyViewableComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("series")) {
            array = json.getAsJsonArray("series");
            for (i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingExcerptSeriesComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingExcerpt.StudyDicomComponent parseImagingExcerptStudyDicomComponent(JsonObject json, ImagingExcerpt owner) throws IOException, FHIRFormatError {
        ImagingExcerpt.StudyDicomComponent res = new ImagingExcerpt.StudyDicomComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ImagingExcerpt.DWebType.NULL, new ImagingExcerpt.DWebTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected ImagingExcerpt.StudyViewableComponent parseImagingExcerptStudyViewableComponent(JsonObject json, ImagingExcerpt owner) throws IOException, FHIRFormatError {
        ImagingExcerpt.StudyViewableComponent res = new ImagingExcerpt.StudyViewableComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseCode(json.get("contentType").getAsString()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("height")) {
            res.setHeightElement(this.parsePositiveInt(json.get("height").getAsString()));
        }
        if (json.has("_height")) {
            this.parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
        }
        if (json.has("width")) {
            res.setWidthElement(this.parsePositiveInt(json.get("width").getAsString()));
        }
        if (json.has("_width")) {
            this.parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
        }
        if (json.has("frames")) {
            res.setFramesElement(this.parsePositiveInt(json.get("frames").getAsString()));
        }
        if (json.has("_frames")) {
            this.parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseUnsignedInt(json.get("duration").getAsString()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
        }
        if (json.has("size")) {
            res.setSizeElement(this.parseUnsignedInt(json.get("size").getAsString()));
        }
        if (json.has("_size")) {
            this.parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected ImagingExcerpt.SeriesComponent parseImagingExcerptSeriesComponent(JsonObject json, ImagingExcerpt owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImagingExcerpt.SeriesComponent res = new ImagingExcerpt.SeriesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("dicom")) {
            array = json.getAsJsonArray("dicom");
            for (i = 0; i < array.size(); ++i) {
                res.getDicom().add(this.parseImagingExcerptSeriesDicomComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingExcerptInstanceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingExcerpt.SeriesDicomComponent parseImagingExcerptSeriesDicomComponent(JsonObject json, ImagingExcerpt owner) throws IOException, FHIRFormatError {
        ImagingExcerpt.SeriesDicomComponent res = new ImagingExcerpt.SeriesDicomComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ImagingExcerpt.DWebType.NULL, new ImagingExcerpt.DWebTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected ImagingExcerpt.InstanceComponent parseImagingExcerptInstanceComponent(JsonObject json, ImagingExcerpt owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImagingExcerpt.InstanceComponent res = new ImagingExcerpt.InstanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sopClass")) {
            res.setSopClassElement(this.parseOid(json.get("sopClass").getAsString()));
        }
        if (json.has("_sopClass")) {
            this.parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
        }
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("dicom")) {
            array = json.getAsJsonArray("dicom");
            for (i = 0; i < array.size(); ++i) {
                res.getDicom().add(this.parseImagingExcerptInstanceDicomComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("frameNumbers")) {
            array = json.getAsJsonArray("frameNumbers");
            for (i = 0; i < array.size(); ++i) {
                res.getFrameNumbers().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_frameNumbers")) {
            array = json.getAsJsonArray("_frameNumbers");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFrameNumbers().size()) {
                    res.getFrameNumbers().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFrameNumbers().get(i));
            }
        }
        return res;
    }

    protected ImagingExcerpt.InstanceDicomComponent parseImagingExcerptInstanceDicomComponent(JsonObject json, ImagingExcerpt owner) throws IOException, FHIRFormatError {
        ImagingExcerpt.InstanceDicomComponent res = new ImagingExcerpt.InstanceDicomComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ImagingExcerpt.DWebType.NULL, new ImagingExcerpt.DWebTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected ImagingObjectSelection parseImagingObjectSelection(JsonObject json) throws IOException, FHIRFormatError {
        ImagingObjectSelection res = new ImagingObjectSelection();
        this.parseDomainResourceProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("authoringTime")) {
            res.setAuthoringTimeElement(this.parseDateTime(json.get("authoringTime").getAsString()));
        }
        if (json.has("_authoringTime")) {
            this.parseElementProperties(json.getAsJsonObject("_authoringTime"), res.getAuthoringTimeElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("title")) {
            res.setTitle(this.parseCodeableConcept(json.getAsJsonObject("title")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("study")) {
            JsonArray array = json.getAsJsonArray("study");
            for (int i = 0; i < array.size(); ++i) {
                res.getStudy().add(this.parseImagingObjectSelectionStudyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.StudyComponent parseImagingObjectSelectionStudyComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        ImagingObjectSelection.StudyComponent res = new ImagingObjectSelection.StudyComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("imagingStudy")) {
            res.setImagingStudy(this.parseReference(json.getAsJsonObject("imagingStudy")));
        }
        if (json.has("series")) {
            JsonArray array = json.getAsJsonArray("series");
            for (int i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingObjectSelectionSeriesComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.SeriesComponent parseImagingObjectSelectionSeriesComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        ImagingObjectSelection.SeriesComponent res = new ImagingObjectSelection.SeriesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("instance")) {
            JsonArray array = json.getAsJsonArray("instance");
            for (int i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingObjectSelectionInstanceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.InstanceComponent parseImagingObjectSelectionInstanceComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        ImagingObjectSelection.InstanceComponent res = new ImagingObjectSelection.InstanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sopClass")) {
            res.setSopClassElement(this.parseOid(json.get("sopClass").getAsString()));
        }
        if (json.has("_sopClass")) {
            this.parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
        }
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("frame")) {
            JsonArray array = json.getAsJsonArray("frame");
            for (int i = 0; i < array.size(); ++i) {
                res.getFrame().add(this.parseImagingObjectSelectionFramesComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingObjectSelection.FramesComponent parseImagingObjectSelectionFramesComponent(JsonObject json, ImagingObjectSelection owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImagingObjectSelection.FramesComponent res = new ImagingObjectSelection.FramesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("number")) {
            array = json.getAsJsonArray("number");
            for (i = 0; i < array.size(); ++i) {
                res.getNumber().add(this.parseUnsignedInt(array.get(i).getAsString()));
            }
        }
        if (json.has("_number")) {
            array = json.getAsJsonArray("_number");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getNumber().size()) {
                    res.getNumber().add(this.parseUnsignedInt(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getNumber().get(i));
            }
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImagingStudy res = new ImagingStudy();
        this.parseDomainResourceProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("accession")) {
            res.setAccession(this.parseIdentifier(json.getAsJsonObject("accession")));
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (json.has("_availability")) {
            this.parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
        }
        if (json.has("modalityList")) {
            array = json.getAsJsonArray("modalityList");
            for (i = 0; i < array.size(); ++i) {
                res.getModalityList().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
        }
        if (json.has("order")) {
            array = json.getAsJsonArray("order");
            for (i = 0; i < array.size(); ++i) {
                res.getOrder().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("referrer")) {
            res.setReferrer(this.parseReference(json.getAsJsonObject("referrer")));
        }
        if (json.has("interpreter")) {
            res.setInterpreter(this.parseReference(json.getAsJsonObject("interpreter")));
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("numberOfSeries")) {
            res.setNumberOfSeriesElement(this.parseUnsignedInt(json.get("numberOfSeries").getAsString()));
        }
        if (json.has("_numberOfSeries")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfSeries"), res.getNumberOfSeriesElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("procedure")) {
            array = json.getAsJsonArray("procedure");
            for (i = 0; i < array.size(); ++i) {
                res.getProcedure().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("series")) {
            array = json.getAsJsonArray("series");
            for (i = 0; i < array.size(); ++i) {
                res.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("modality")) {
            res.setModality(this.parseCoding(json.getAsJsonObject("modality")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(json.get("numberOfInstances").getAsString()));
        }
        if (json.has("_numberOfInstances")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
        }
        if (json.has("availability")) {
            res.setAvailabilityElement(this.parseEnumeration(json.get("availability").getAsString(), ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
        }
        if (json.has("_availability")) {
            this.parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCoding(json.getAsJsonObject("bodySite")));
        }
        if (json.has("laterality")) {
            res.setLaterality(this.parseCoding(json.getAsJsonObject("laterality")));
        }
        if (json.has("started")) {
            res.setStartedElement(this.parseDateTime(json.get("started").getAsString()));
        }
        if (json.has("_started")) {
            this.parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
        }
        if (json.has("instance")) {
            JsonArray array = json.getAsJsonArray("instance");
            for (int i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("uid")) {
            res.setUidElement(this.parseOid(json.get("uid").getAsString()));
        }
        if (json.has("_uid")) {
            this.parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
        }
        if (json.has("number")) {
            res.setNumberElement(this.parseUnsignedInt(json.get("number").getAsString()));
        }
        if (json.has("_number")) {
            this.parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
        }
        if (json.has("sopClass")) {
            res.setSopClassElement(this.parseOid(json.get("sopClass").getAsString()));
        }
        if (json.has("_sopClass")) {
            this.parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("content")) {
            JsonArray array = json.getAsJsonArray("content");
            for (int i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Immunization res = new Immunization();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseCode(json.get("status").getAsString()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("wasNotGiven")) {
            res.setWasNotGivenElement(this.parseBoolean(json.get("wasNotGiven").getAsBoolean()));
        }
        if (json.has("_wasNotGiven")) {
            this.parseElementProperties(json.getAsJsonObject("_wasNotGiven"), res.getWasNotGivenElement());
        }
        if (json.has("reported")) {
            res.setReportedElement(this.parseBoolean(json.get("reported").getAsBoolean()));
        }
        if (json.has("_reported")) {
            this.parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(json.getAsJsonObject("requester")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(json.getAsJsonObject("manufacturer")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDate(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
        if (json.has("site")) {
            res.setSite(this.parseCodeableConcept(json.getAsJsonObject("site")));
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("doseQuantity")) {
            res.setDoseQuantity(this.parseSimpleQuantity(json.getAsJsonObject("doseQuantity")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("explanation")) {
            res.setExplanation(this.parseImmunizationImmunizationExplanationComponent(json.getAsJsonObject("explanation"), res));
        }
        if (json.has("reaction")) {
            array = json.getAsJsonArray("reaction");
            for (i = 0; i < array.size(); ++i) {
                res.getReaction().add(this.parseImmunizationImmunizationReactionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("vaccinationProtocol")) {
            array = json.getAsJsonArray("vaccinationProtocol");
            for (i = 0; i < array.size(); ++i) {
                res.getVaccinationProtocol().add(this.parseImmunizationImmunizationVaccinationProtocolComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonNotGiven")) {
            array = json.getAsJsonArray("reasonNotGiven");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("detail")) {
            res.setDetail(this.parseReference(json.getAsJsonObject("detail")));
        }
        if (json.has("reported")) {
            res.setReportedElement(this.parseBoolean(json.get("reported").getAsBoolean()));
        }
        if (json.has("_reported")) {
            this.parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
        }
        return res;
    }

    protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
        Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("doseSequence")) {
            res.setDoseSequenceElement(this.parsePositiveInt(json.get("doseSequence").getAsString()));
        }
        if (json.has("_doseSequence")) {
            this.parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(json.getAsJsonObject("authority")));
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
        }
        if (json.has("seriesDoses")) {
            res.setSeriesDosesElement(this.parsePositiveInt(json.get("seriesDoses").getAsString()));
        }
        if (json.has("_seriesDoses")) {
            this.parseElementProperties(json.getAsJsonObject("_seriesDoses"), res.getSeriesDosesElement());
        }
        if (json.has("targetDisease")) {
            JsonArray array = json.getAsJsonArray("targetDisease");
            for (int i = 0; i < array.size(); ++i) {
                res.getTargetDisease().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("doseStatus")) {
            res.setDoseStatus(this.parseCodeableConcept(json.getAsJsonObject("doseStatus")));
        }
        if (json.has("doseStatusReason")) {
            res.setDoseStatusReason(this.parseCodeableConcept(json.getAsJsonObject("doseStatusReason")));
        }
        return res;
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("recommendation")) {
            array = json.getAsJsonArray("recommendation");
            for (i = 0; i < array.size(); ++i) {
                res.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
        }
        if (json.has("doseNumber")) {
            res.setDoseNumberElement(this.parsePositiveInt(json.get("doseNumber").getAsString()));
        }
        if (json.has("_doseNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_doseNumber"), res.getDoseNumberElement());
        }
        if (json.has("forecastStatus")) {
            res.setForecastStatus(this.parseCodeableConcept(json.getAsJsonObject("forecastStatus")));
        }
        if (json.has("dateCriterion")) {
            array = json.getAsJsonArray("dateCriterion");
            for (i = 0; i < array.size(); ++i) {
                res.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("protocol")) {
            res.setProtocol(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(json.getAsJsonObject("protocol"), owner));
        }
        if (json.has("supportingImmunization")) {
            array = json.getAsJsonArray("supportingImmunization");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingImmunization().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingPatientInformation")) {
            array = json.getAsJsonArray("supportingPatientInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingPatientInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseDateTime(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("doseSequence")) {
            res.setDoseSequenceElement(this.parseInteger(json.get("doseSequence").getAsLong()));
        }
        if (json.has("_doseSequence")) {
            this.parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("authority")) {
            res.setAuthority(this.parseReference(json.getAsJsonObject("authority")));
        }
        if (json.has("series")) {
            res.setSeriesElement(this.parseString(json.get("series").getAsString()));
        }
        if (json.has("_series")) {
            this.parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
        }
        return res;
    }

    protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImplementationGuide res = new ImplementationGuide();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseImplementationGuideImplementationGuideContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("dependency")) {
            array = json.getAsJsonArray("dependency");
            for (i = 0; i < array.size(); ++i) {
                res.getDependency().add(this.parseImplementationGuideImplementationGuideDependencyComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("package")) {
            array = json.getAsJsonArray("package");
            for (i = 0; i < array.size(); ++i) {
                res.getPackage().add(this.parseImplementationGuideImplementationGuidePackageComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("global")) {
            array = json.getAsJsonArray("global");
            for (i = 0; i < array.size(); ++i) {
                res.getGlobal().add(this.parseImplementationGuideImplementationGuideGlobalComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("binary")) {
            array = json.getAsJsonArray("binary");
            for (i = 0; i < array.size(); ++i) {
                res.getBinary().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_binary")) {
            array = json.getAsJsonArray("_binary");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getBinary().size()) {
                    res.getBinary().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getBinary().get(i));
            }
        }
        if (json.has("page")) {
            res.setPage(this.parseImplementationGuideImplementationGuidePageComponent(json.getAsJsonObject("page"), res));
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuideContactComponent parseImplementationGuideImplementationGuideContactComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideContactComponent res = new ImplementationGuide.ImplementationGuideContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), ImplementationGuide.GuideDependencyType.NULL, new ImplementationGuide.GuideDependencyTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("resource")) {
            JsonArray array = json.getAsJsonArray("resource");
            for (int i = 0; i < array.size(); ++i) {
                res.getResource().add(this.parseImplementationGuideImplementationGuidePackageResourceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        Type source;
        ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("example")) {
            res.setExampleElement(this.parseBoolean(json.get("example").getAsBoolean()));
        }
        if (json.has("_example")) {
            this.parseElementProperties(json.getAsJsonObject("_example"), res.getExampleElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("acronym")) {
            res.setAcronymElement(this.parseString(json.get("acronym").getAsString()));
        }
        if (json.has("_acronym")) {
            this.parseElementProperties(json.getAsJsonObject("_acronym"), res.getAcronymElement());
        }
        if ((source = this.parseType("source", json)) != null) {
            res.setSource(source);
        }
        if (json.has("exampleFor")) {
            res.setExampleFor(this.parseReference(json.getAsJsonObject("exampleFor")));
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("source")) {
            res.setSourceElement(this.parseUri(json.get("source").getAsString()));
        }
        if (json.has("_source")) {
            this.parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), ImplementationGuide.GuidePageKind.NULL, new ImplementationGuide.GuidePageKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_type")) {
            array = json.getAsJsonArray("_type");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getType().size()) {
                    res.getType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
            }
        }
        if (json.has("package")) {
            array = json.getAsJsonArray("package");
            for (i = 0; i < array.size(); ++i) {
                res.getPackage().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_package")) {
            array = json.getAsJsonArray("_package");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPackage().size()) {
                    res.getPackage().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPackage().get(i));
            }
        }
        if (json.has("format")) {
            res.setFormatElement(this.parseCode(json.get("format").getAsString()));
        }
        if (json.has("_format")) {
            this.parseElementProperties(json.getAsJsonObject("_format"), res.getFormatElement());
        }
        if (json.has("page")) {
            array = json.getAsJsonArray("page");
            for (i = 0; i < array.size(); ++i) {
                res.getPage().add(this.parseImplementationGuideImplementationGuidePageComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Library res = new Library();
        this.parseDomainResourceProperties(json, res);
        if (json.has("moduleMetadata")) {
            res.setModuleMetadata(this.parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
        }
        if (json.has("model")) {
            array = json.getAsJsonArray("model");
            for (i = 0; i < array.size(); ++i) {
                res.getModel().add(this.parseLibraryLibraryModelComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i = 0; i < array.size(); ++i) {
                res.getLibrary().add(this.parseLibraryLibraryLibraryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("codeSystem")) {
            array = json.getAsJsonArray("codeSystem");
            for (i = 0; i < array.size(); ++i) {
                res.getCodeSystem().add(this.parseLibraryLibraryCodeSystemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("valueSet")) {
            array = json.getAsJsonArray("valueSet");
            for (i = 0; i < array.size(); ++i) {
                res.getValueSet().add(this.parseLibraryLibraryValueSetComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseParameterDefinition(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dataRequirement")) {
            array = json.getAsJsonArray("dataRequirement");
            for (i = 0; i < array.size(); ++i) {
                res.getDataRequirement().add(this.parseDataRequirement(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("document")) {
            res.setDocument(this.parseAttachment(json.getAsJsonObject("document")));
        }
        return res;
    }

    protected Library.LibraryModelComponent parseLibraryLibraryModelComponent(JsonObject json, Library owner) throws IOException, FHIRFormatError {
        Library.LibraryModelComponent res = new Library.LibraryModelComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        return res;
    }

    protected Library.LibraryLibraryComponent parseLibraryLibraryLibraryComponent(JsonObject json, Library owner) throws IOException, FHIRFormatError {
        Type document;
        Library.LibraryLibraryComponent res = new Library.LibraryLibraryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if ((document = this.parseType("document", json)) != null) {
            res.setDocument(document);
        }
        return res;
    }

    protected Library.LibraryCodeSystemComponent parseLibraryLibraryCodeSystemComponent(JsonObject json, Library owner) throws IOException, FHIRFormatError {
        Library.LibraryCodeSystemComponent res = new Library.LibraryCodeSystemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        return res;
    }

    protected Library.LibraryValueSetComponent parseLibraryLibraryValueSetComponent(JsonObject json, Library owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Library.LibraryValueSetComponent res = new Library.LibraryValueSetComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("codeSystem")) {
            array = json.getAsJsonArray("codeSystem");
            for (i = 0; i < array.size(); ++i) {
                res.getCodeSystem().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_codeSystem")) {
            array = json.getAsJsonArray("_codeSystem");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCodeSystem().size()) {
                    res.getCodeSystem().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCodeSystem().get(i));
            }
        }
        return res;
    }

    protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
        Linkage res = new Linkage();
        this.parseDomainResourceProperties(json, res);
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseLinkageLinkageItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(JsonObject json, Linkage owner) throws IOException, FHIRFormatError {
        Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        return res;
    }

    protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ListResource res = new ListResource();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(json.getAsJsonObject("orderedBy")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("entry")) {
            array = json.getAsJsonArray("entry");
            for (i = 0; i < array.size(); ++i) {
                res.getEntry().add(this.parseListResourceListEntryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(json.getAsJsonObject("emptyReason")));
        }
        return res;
    }

    protected ListResource.ListEntryComponent parseListResourceListEntryComponent(JsonObject json, ListResource owner) throws IOException, FHIRFormatError {
        ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("flag")) {
            res.setFlag(this.parseCodeableConcept(json.getAsJsonObject("flag")));
        }
        if (json.has("deleted")) {
            res.setDeletedElement(this.parseBoolean(json.get("deleted").getAsBoolean()));
        }
        if (json.has("_deleted")) {
            this.parseElementProperties(json.getAsJsonObject("_deleted"), res.getDeletedElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("item")) {
            res.setItem(this.parseReference(json.getAsJsonObject("item")));
        }
        return res;
    }

    protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Location res = new Location();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        if (json.has("physicalType")) {
            res.setPhysicalType(this.parseCodeableConcept(json.getAsJsonObject("physicalType")));
        }
        if (json.has("position")) {
            res.setPosition(this.parseLocationLocationPositionComponent(json.getAsJsonObject("position"), res));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        return res;
    }

    protected Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject json, Location owner) throws IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("longitude")) {
            res.setLongitudeElement(this.parseDecimal(json.get("longitude").getAsBigDecimal()));
        }
        if (json.has("_longitude")) {
            this.parseElementProperties(json.getAsJsonObject("_longitude"), res.getLongitudeElement());
        }
        if (json.has("latitude")) {
            res.setLatitudeElement(this.parseDecimal(json.get("latitude").getAsBigDecimal()));
        }
        if (json.has("_latitude")) {
            this.parseElementProperties(json.getAsJsonObject("_latitude"), res.getLatitudeElement());
        }
        if (json.has("altitude")) {
            res.setAltitudeElement(this.parseDecimal(json.get("altitude").getAsBigDecimal()));
        }
        if (json.has("_altitude")) {
            this.parseElementProperties(json.getAsJsonObject("_altitude"), res.getAltitudeElement());
        }
        return res;
    }

    protected Measure parseMeasure(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Measure res = new Measure();
        this.parseDomainResourceProperties(json, res);
        if (json.has("moduleMetadata")) {
            res.setModuleMetadata(this.parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i = 0; i < array.size(); ++i) {
                res.getLibrary().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("disclaimer")) {
            res.setDisclaimerElement(this.parseMarkdown(json.get("disclaimer").getAsString()));
        }
        if (json.has("_disclaimer")) {
            this.parseElementProperties(json.getAsJsonObject("_disclaimer"), res.getDisclaimerElement());
        }
        if (json.has("scoring")) {
            res.setScoringElement(this.parseEnumeration(json.get("scoring").getAsString(), Measure.MeasureScoring.NULL, new Measure.MeasureScoringEnumFactory()));
        }
        if (json.has("_scoring")) {
            this.parseElementProperties(json.getAsJsonObject("_scoring"), res.getScoringElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseEnumeration(array.get(i).getAsString(), Measure.MeasureType.NULL, new Measure.MeasureTypeEnumFactory()));
            }
        }
        if (json.has("_type")) {
            array = json.getAsJsonArray("_type");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getType().size()) {
                    res.getType().add(this.parseEnumeration(null, Measure.MeasureType.NULL, new Measure.MeasureTypeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
            }
        }
        if (json.has("riskAdjustment")) {
            res.setRiskAdjustmentElement(this.parseString(json.get("riskAdjustment").getAsString()));
        }
        if (json.has("_riskAdjustment")) {
            this.parseElementProperties(json.getAsJsonObject("_riskAdjustment"), res.getRiskAdjustmentElement());
        }
        if (json.has("rateAggregation")) {
            res.setRateAggregationElement(this.parseString(json.get("rateAggregation").getAsString()));
        }
        if (json.has("_rateAggregation")) {
            this.parseElementProperties(json.getAsJsonObject("_rateAggregation"), res.getRateAggregationElement());
        }
        if (json.has("rationale")) {
            res.setRationaleElement(this.parseMarkdown(json.get("rationale").getAsString()));
        }
        if (json.has("_rationale")) {
            this.parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
        }
        if (json.has("clinicalRecommendationStatement")) {
            res.setClinicalRecommendationStatementElement(this.parseMarkdown(json.get("clinicalRecommendationStatement").getAsString()));
        }
        if (json.has("_clinicalRecommendationStatement")) {
            this.parseElementProperties(json.getAsJsonObject("_clinicalRecommendationStatement"), res.getClinicalRecommendationStatementElement());
        }
        if (json.has("improvementNotation")) {
            res.setImprovementNotationElement(this.parseString(json.get("improvementNotation").getAsString()));
        }
        if (json.has("_improvementNotation")) {
            this.parseElementProperties(json.getAsJsonObject("_improvementNotation"), res.getImprovementNotationElement());
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseMarkdown(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("guidance")) {
            res.setGuidanceElement(this.parseMarkdown(json.get("guidance").getAsString()));
        }
        if (json.has("_guidance")) {
            this.parseElementProperties(json.getAsJsonObject("_guidance"), res.getGuidanceElement());
        }
        if (json.has("set")) {
            res.setSetElement(this.parseString(json.get("set").getAsString()));
        }
        if (json.has("_set")) {
            this.parseElementProperties(json.getAsJsonObject("_set"), res.getSetElement());
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseMeasureMeasureGroupComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("supplementalData")) {
            array = json.getAsJsonArray("supplementalData");
            for (i = 0; i < array.size(); ++i) {
                res.getSupplementalData().add(this.parseMeasureMeasureSupplementalDataComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("population")) {
            array = json.getAsJsonArray("population");
            for (i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parseMeasureMeasureGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("stratifier")) {
            array = json.getAsJsonArray("stratifier");
            for (i = 0; i < array.size(); ++i) {
                res.getStratifier().add(this.parseMeasureMeasureGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Measure.MeasurePopulationType.NULL, new Measure.MeasurePopulationTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
        return res;
    }

    protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        return res;
    }

    protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(JsonObject json, Measure owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("usage")) {
            array = json.getAsJsonArray("usage");
            for (i = 0; i < array.size(); ++i) {
                res.getUsage().add(this.parseEnumeration(array.get(i).getAsString(), Measure.MeasureDataUsage.NULL, new Measure.MeasureDataUsageEnumFactory()));
            }
        }
        if (json.has("_usage")) {
            array = json.getAsJsonArray("_usage");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getUsage().size()) {
                    res.getUsage().add(this.parseEnumeration(null, Measure.MeasureDataUsage.NULL, new Measure.MeasureDataUsageEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getUsage().get(i));
            }
        }
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        return res;
    }

    protected MeasureReport parseMeasureReport(JsonObject json) throws IOException, FHIRFormatError {
        MeasureReport res = new MeasureReport();
        this.parseDomainResourceProperties(json, res);
        if (json.has("measure")) {
            res.setMeasure(this.parseReference(json.getAsJsonObject("measure")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("reportingOrganization")) {
            res.setReportingOrganization(this.parseReference(json.getAsJsonObject("reportingOrganization")));
        }
        if (json.has("group")) {
            JsonArray array = json.getAsJsonArray("group");
            for (int i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseMeasureReportMeasureReportGroupComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("evaluatedResources")) {
            res.setEvaluatedResources(this.parseReference(json.getAsJsonObject("evaluatedResources")));
        }
        return res;
    }

    protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("population")) {
            array = json.getAsJsonArray("population");
            for (i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parseMeasureReportMeasureReportGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("measureScore")) {
            res.setMeasureScoreElement(this.parseDecimal(json.get("measureScore").getAsBigDecimal()));
        }
        if (json.has("_measureScore")) {
            this.parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
        }
        if (json.has("stratifier")) {
            array = json.getAsJsonArray("stratifier");
            for (i = 0; i < array.size(); ++i) {
                res.getStratifier().add(this.parseMeasureReportMeasureReportGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("supplementalData")) {
            array = json.getAsJsonArray("supplementalData");
            for (i = 0; i < array.size(); ++i) {
                res.getSupplementalData().add(this.parseMeasureReportMeasureReportGroupSupplementalDataComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("patients")) {
            res.setPatients(this.parseReference(json.getAsJsonObject("patients")));
        }
        return res;
    }

    protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("group")) {
            JsonArray array = json.getAsJsonArray("group");
            for (int i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseMeasureReportMeasureReportGroupStratifierGroupComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected MeasureReport.MeasureReportGroupStratifierGroupComponent parseMeasureReportMeasureReportGroupStratifierGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierGroupComponent res = new MeasureReport.MeasureReportGroupStratifierGroupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("population")) {
            JsonArray array = json.getAsJsonArray("population");
            for (int i = 0; i < array.size(); ++i) {
                res.getPopulation().add(this.parseMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("measureScore")) {
            res.setMeasureScoreElement(this.parseDecimal(json.get("measureScore").getAsBigDecimal()));
        }
        if (json.has("_measureScore")) {
            this.parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
        }
        return res;
    }

    protected MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent parseMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent res = new MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("patients")) {
            res.setPatients(this.parseReference(json.getAsJsonObject("patients")));
        }
        return res;
    }

    protected MeasureReport.MeasureReportGroupSupplementalDataComponent parseMeasureReportMeasureReportGroupSupplementalDataComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupSupplementalDataComponent res = new MeasureReport.MeasureReportGroupSupplementalDataComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("group")) {
            JsonArray array = json.getAsJsonArray("group");
            for (int i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseMeasureReportMeasureReportGroupSupplementalDataGroupComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected MeasureReport.MeasureReportGroupSupplementalDataGroupComponent parseMeasureReportMeasureReportGroupSupplementalDataGroupComponent(JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupSupplementalDataGroupComponent res = new MeasureReport.MeasureReportGroupSupplementalDataGroupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("count")) {
            res.setCountElement(this.parseInteger(json.get("count").getAsLong()));
        }
        if (json.has("_count")) {
            this.parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
        }
        if (json.has("patients")) {
            res.setPatients(this.parseReference(json.getAsJsonObject("patients")));
        }
        return res;
    }

    protected Media parseMedia(JsonObject json) throws IOException, FHIRFormatError {
        Media res = new Media();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Media.DigitalMediaType.NULL, new Media.DigitalMediaTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("subtype")) {
            res.setSubtype(this.parseCodeableConcept(json.getAsJsonObject("subtype")));
        }
        if (json.has("view")) {
            res.setView(this.parseCodeableConcept(json.getAsJsonObject("view")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("operator")) {
            res.setOperator(this.parseReference(json.getAsJsonObject("operator")));
        }
        if (json.has("deviceName")) {
            res.setDeviceNameElement(this.parseString(json.get("deviceName").getAsString()));
        }
        if (json.has("_deviceName")) {
            this.parseElementProperties(json.getAsJsonObject("_deviceName"), res.getDeviceNameElement());
        }
        if (json.has("height")) {
            res.setHeightElement(this.parsePositiveInt(json.get("height").getAsString()));
        }
        if (json.has("_height")) {
            this.parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
        }
        if (json.has("width")) {
            res.setWidthElement(this.parsePositiveInt(json.get("width").getAsString()));
        }
        if (json.has("_width")) {
            this.parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
        }
        if (json.has("frames")) {
            res.setFramesElement(this.parsePositiveInt(json.get("frames").getAsString()));
        }
        if (json.has("_frames")) {
            this.parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
        }
        if (json.has("duration")) {
            res.setDurationElement(this.parseUnsignedInt(json.get("duration").getAsString()));
        }
        if (json.has("_duration")) {
            this.parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
        }
        if (json.has("content")) {
            res.setContent(this.parseAttachment(json.getAsJsonObject("content")));
        }
        return res;
    }

    protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
        Medication res = new Medication();
        this.parseDomainResourceProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("isBrand")) {
            res.setIsBrandElement(this.parseBoolean(json.get("isBrand").getAsBoolean()));
        }
        if (json.has("_isBrand")) {
            this.parseElementProperties(json.getAsJsonObject("_isBrand"), res.getIsBrandElement());
        }
        if (json.has("manufacturer")) {
            res.setManufacturer(this.parseReference(json.getAsJsonObject("manufacturer")));
        }
        if (json.has("product")) {
            res.setProduct(this.parseMedicationMedicationProductComponent(json.getAsJsonObject("product"), res));
        }
        if (json.has("package")) {
            res.setPackage(this.parseMedicationMedicationPackageComponent(json.getAsJsonObject("package"), res));
        }
        return res;
    }

    protected Medication.MedicationProductComponent parseMedicationMedicationProductComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Medication.MedicationProductComponent res = new Medication.MedicationProductComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("form")) {
            res.setForm(this.parseCodeableConcept(json.getAsJsonObject("form")));
        }
        if (json.has("ingredient")) {
            array = json.getAsJsonArray("ingredient");
            for (i = 0; i < array.size(); ++i) {
                res.getIngredient().add(this.parseMedicationMedicationProductIngredientComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("batch")) {
            array = json.getAsJsonArray("batch");
            for (i = 0; i < array.size(); ++i) {
                res.getBatch().add(this.parseMedicationMedicationProductBatchComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Medication.MedicationProductIngredientComponent parseMedicationMedicationProductIngredientComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationProductIngredientComponent res = new Medication.MedicationProductIngredientComponent();
        this.parseBackboneProperties(json, res);
        Type item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
        if (json.has("amount")) {
            res.setAmount(this.parseRatio(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected Medication.MedicationProductBatchComponent parseMedicationMedicationProductBatchComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationProductBatchComponent res = new Medication.MedicationProductBatchComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("lotNumber")) {
            res.setLotNumberElement(this.parseString(json.get("lotNumber").getAsString()));
        }
        if (json.has("_lotNumber")) {
            this.parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
        }
        if (json.has("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(json.get("expirationDate").getAsString()));
        }
        if (json.has("_expirationDate")) {
            this.parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
        }
        return res;
    }

    protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("container")) {
            res.setContainer(this.parseCodeableConcept(json.getAsJsonObject("container")));
        }
        if (json.has("content")) {
            JsonArray array = json.getAsJsonArray("content");
            for (int i = 0; i < array.size(); ++i) {
                res.getContent().add(this.parseMedicationMedicationPackageContentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(JsonObject json, Medication owner) throws IOException, FHIRFormatError {
        Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
        this.parseBackboneProperties(json, res);
        Type item = this.parseType("item", json);
        if (item != null) {
            res.setItem(item);
        }
        if (json.has("amount")) {
            res.setAmount(this.parseSimpleQuantity(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected MedicationAdministration parseMedicationAdministration(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type effectiveTime;
        Type medication;
        MedicationAdministration res = new MedicationAdministration();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationAdministration.MedicationAdministrationStatus.NULL, new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((effectiveTime = this.parseType("effectiveTime", json)) != null) {
            res.setEffectiveTime(effectiveTime);
        }
        if (json.has("practitioner")) {
            res.setPractitioner(this.parseReference(json.getAsJsonObject("practitioner")));
        }
        if (json.has("prescription")) {
            res.setPrescription(this.parseReference(json.getAsJsonObject("prescription")));
        }
        if (json.has("wasNotGiven")) {
            res.setWasNotGivenElement(this.parseBoolean(json.get("wasNotGiven").getAsBoolean()));
        }
        if (json.has("_wasNotGiven")) {
            this.parseElementProperties(json.getAsJsonObject("_wasNotGiven"), res.getWasNotGivenElement());
        }
        if (json.has("reasonNotGiven")) {
            array = json.getAsJsonArray("reasonNotGiven");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonNotGiven().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonGiven")) {
            array = json.getAsJsonArray("reasonGiven");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonGiven().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("device")) {
            array = json.getAsJsonArray("device");
            for (i = 0; i < array.size(); ++i) {
                res.getDevice().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosage")) {
            res.setDosage(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(json.getAsJsonObject("dosage"), res));
        }
        return res;
    }

    protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
        Type rate;
        Type site;
        MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        return res;
    }

    protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type medication;
        MedicationDispense res = new MedicationDispense();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.NULL, new MedicationDispense.MedicationDispenseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("dispenser")) {
            res.setDispenser(this.parseReference(json.getAsJsonObject("dispenser")));
        }
        if (json.has("authorizingPrescription")) {
            array = json.getAsJsonArray("authorizingPrescription");
            for (i = 0; i < array.size(); ++i) {
                res.getAuthorizingPrescription().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("daysSupply")) {
            res.setDaysSupply(this.parseSimpleQuantity(json.getAsJsonObject("daysSupply")));
        }
        if (json.has("whenPrepared")) {
            res.setWhenPreparedElement(this.parseDateTime(json.get("whenPrepared").getAsString()));
        }
        if (json.has("_whenPrepared")) {
            this.parseElementProperties(json.getAsJsonObject("_whenPrepared"), res.getWhenPreparedElement());
        }
        if (json.has("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(json.get("whenHandedOver").getAsString()));
        }
        if (json.has("_whenHandedOver")) {
            this.parseElementProperties(json.getAsJsonObject("_whenHandedOver"), res.getWhenHandedOverElement());
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("receiver")) {
            array = json.getAsJsonArray("receiver");
            for (i = 0; i < array.size(); ++i) {
                res.getReceiver().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosageInstruction")) {
            array = json.getAsJsonArray("dosageInstruction");
            for (i = 0; i < array.size(); ++i) {
                res.getDosageInstruction().add(this.parseMedicationDispenseMedicationDispenseDosageInstructionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("substitution")) {
            res.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(json.getAsJsonObject("substitution"), res));
        }
        return res;
    }

    protected MedicationDispense.MedicationDispenseDosageInstructionComponent parseMedicationDispenseMedicationDispenseDosageInstructionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
        Type rate;
        Type dose;
        Type site;
        Type asNeeded;
        MedicationDispense.MedicationDispenseDosageInstructionComponent res = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("additionalInstructions")) {
            res.setAdditionalInstructions(this.parseCodeableConcept(json.getAsJsonObject("additionalInstructions")));
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(json.getAsJsonObject("timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if ((dose = this.parseType("dose", json)) != null) {
            res.setDose(dose);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
        }
        return res;
    }

    protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("responsibleParty")) {
            array = json.getAsJsonArray("responsibleParty");
            for (i = 0; i < array.size(); ++i) {
                res.getResponsibleParty().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected MedicationOrder parseMedicationOrder(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type medication;
        MedicationOrder res = new MedicationOrder();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationOrder.MedicationOrderStatus.NULL, new MedicationOrder.MedicationOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("dateWritten")) {
            res.setDateWrittenElement(this.parseDateTime(json.get("dateWritten").getAsString()));
        }
        if (json.has("_dateWritten")) {
            this.parseElementProperties(json.getAsJsonObject("_dateWritten"), res.getDateWrittenElement());
        }
        if (json.has("prescriber")) {
            res.setPrescriber(this.parseReference(json.getAsJsonObject("prescriber")));
        }
        if (json.has("reasonCode")) {
            JsonArray array = json.getAsJsonArray("reasonCode");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonCode().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reasonReference")) {
            JsonArray array = json.getAsJsonArray("reasonReference");
            for (i = 0; i < array.size(); ++i) {
                res.getReasonReference().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dateEnded")) {
            res.setDateEndedElement(this.parseDateTime(json.get("dateEnded").getAsString()));
        }
        if (json.has("_dateEnded")) {
            this.parseElementProperties(json.getAsJsonObject("_dateEnded"), res.getDateEndedElement());
        }
        if (json.has("reasonEnded")) {
            res.setReasonEnded(this.parseCodeableConcept(json.getAsJsonObject("reasonEnded")));
        }
        if (json.has("note")) {
            JsonArray array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosageInstruction")) {
            JsonArray array = json.getAsJsonArray("dosageInstruction");
            for (i = 0; i < array.size(); ++i) {
                res.getDosageInstruction().add(this.parseMedicationOrderMedicationOrderDosageInstructionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("dispenseRequest")) {
            res.setDispenseRequest(this.parseMedicationOrderMedicationOrderDispenseRequestComponent(json.getAsJsonObject("dispenseRequest"), res));
        }
        if (json.has("substitution")) {
            res.setSubstitution(this.parseMedicationOrderMedicationOrderSubstitutionComponent(json.getAsJsonObject("substitution"), res));
        }
        if (json.has("priorPrescription")) {
            res.setPriorPrescription(this.parseReference(json.getAsJsonObject("priorPrescription")));
        }
        return res;
    }

    protected MedicationOrder.MedicationOrderDosageInstructionComponent parseMedicationOrderMedicationOrderDosageInstructionComponent(JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
        Type rate;
        Type dose;
        Type site;
        Type asNeeded;
        MedicationOrder.MedicationOrderDosageInstructionComponent res = new MedicationOrder.MedicationOrderDosageInstructionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("additionalInstructions")) {
            res.setAdditionalInstructions(this.parseCodeableConcept(json.getAsJsonObject("additionalInstructions")));
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(json.getAsJsonObject("timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if ((dose = this.parseType("dose", json)) != null) {
            res.setDose(dose);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
        }
        return res;
    }

    protected MedicationOrder.MedicationOrderDispenseRequestComponent parseMedicationOrderMedicationOrderDispenseRequestComponent(JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderDispenseRequestComponent res = new MedicationOrder.MedicationOrderDispenseRequestComponent();
        this.parseBackboneProperties(json, res);
        Type medication = this.parseType("medication", json);
        if (medication != null) {
            res.setMedication(medication);
        }
        if (json.has("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(json.getAsJsonObject("validityPeriod")));
        }
        if (json.has("numberOfRepeatsAllowed")) {
            res.setNumberOfRepeatsAllowedElement(this.parsePositiveInt(json.get("numberOfRepeatsAllowed").getAsString()));
        }
        if (json.has("_numberOfRepeatsAllowed")) {
            this.parseElementProperties(json.getAsJsonObject("_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("expectedSupplyDuration")) {
            res.setExpectedSupplyDuration(this.parseDuration(json.getAsJsonObject("expectedSupplyDuration")));
        }
        return res;
    }

    protected MedicationOrder.MedicationOrderSubstitutionComponent parseMedicationOrderMedicationOrderSubstitutionComponent(JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
        MedicationOrder.MedicationOrderSubstitutionComponent res = new MedicationOrder.MedicationOrderSubstitutionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        return res;
    }

    protected MedicationStatement parseMedicationStatement(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type reasonForUse;
        int i2;
        JsonArray array;
        Type effective;
        Type medication;
        MedicationStatement res = new MedicationStatement();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if ((medication = this.parseType("medication", json)) != null) {
            res.setMedication(medication);
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("informationSource")) {
            res.setInformationSource(this.parseReference(json.getAsJsonObject("informationSource")));
        }
        if (json.has("supportingInformation")) {
            array = json.getAsJsonArray("supportingInformation");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getSupportingInformation().add(this.parseReference(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(json.get("dateAsserted").getAsString()));
        }
        if (json.has("_dateAsserted")) {
            this.parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
        }
        if (json.has("wasNotTaken")) {
            res.setWasNotTakenElement(this.parseBoolean(json.get("wasNotTaken").getAsBoolean()));
        }
        if (json.has("_wasNotTaken")) {
            this.parseElementProperties(json.getAsJsonObject("_wasNotTaken"), res.getWasNotTakenElement());
        }
        if (json.has("reasonNotTaken")) {
            array = json.getAsJsonArray("reasonNotTaken");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReasonNotTaken().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if ((reasonForUse = this.parseType("reasonForUse", json)) != null) {
            res.setReasonForUse(reasonForUse);
        }
        if (json.has("note")) {
            JsonArray array3 = json.getAsJsonArray("note");
            for (i = 0; i < array3.size(); ++i) {
                res.getNote().add(this.parseAnnotation(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dosage")) {
            JsonArray array4 = json.getAsJsonArray("dosage");
            for (i = 0; i < array4.size(); ++i) {
                res.getDosage().add(this.parseMedicationStatementMedicationStatementDosageComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected MedicationStatement.MedicationStatementDosageComponent parseMedicationStatementMedicationStatementDosageComponent(JsonObject json, MedicationStatement owner) throws IOException, FHIRFormatError {
        Type rate;
        Type quantity;
        Type site;
        Type asNeeded;
        MedicationStatement.MedicationStatementDosageComponent res = new MedicationStatement.MedicationStatementDosageComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("timing")) {
            res.setTiming(this.parseTiming(json.getAsJsonObject("timing")));
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if ((site = this.parseType("site", json)) != null) {
            res.setSite(site);
        }
        if (json.has("route")) {
            res.setRoute(this.parseCodeableConcept(json.getAsJsonObject("route")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if ((quantity = this.parseType("quantity", json)) != null) {
            res.setQuantity(quantity);
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        if (json.has("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
        }
        return res;
    }

    protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        MessageHeader res = new MessageHeader();
        this.parseDomainResourceProperties(json, res);
        if (json.has("timestamp")) {
            res.setTimestampElement(this.parseInstant(json.get("timestamp").getAsString()));
        }
        if (json.has("_timestamp")) {
            this.parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
        }
        if (json.has("event")) {
            res.setEvent(this.parseCoding(json.getAsJsonObject("event")));
        }
        if (json.has("response")) {
            res.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(json.getAsJsonObject("response"), res));
        }
        if (json.has("source")) {
            res.setSource(this.parseMessageHeaderMessageSourceComponent(json.getAsJsonObject("source"), res));
        }
        if (json.has("destination")) {
            array = json.getAsJsonArray("destination");
            for (i = 0; i < array.size(); ++i) {
                res.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("enterer")) {
            res.setEnterer(this.parseReference(json.getAsJsonObject("enterer")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("receiver")) {
            res.setReceiver(this.parseReference(json.getAsJsonObject("receiver")));
        }
        if (json.has("responsible")) {
            res.setResponsible(this.parseReference(json.getAsJsonObject("responsible")));
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("data")) {
            array = json.getAsJsonArray("data");
            for (i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseId(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("details")) {
            res.setDetails(this.parseReference(json.getAsJsonObject("details")));
        }
        return res;
    }

    protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("software")) {
            res.setSoftwareElement(this.parseString(json.get("software").getAsString()));
        }
        if (json.has("_software")) {
            this.parseElementProperties(json.getAsJsonObject("_software"), res.getSoftwareElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("contact")) {
            res.setContact(this.parseContactPoint(json.getAsJsonObject("contact")));
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
        return res;
    }

    protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
        MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
        return res;
    }

    protected ModuleDefinition parseModuleDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ModuleDefinition res = new ModuleDefinition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("model")) {
            array = json.getAsJsonArray("model");
            for (i = 0; i < array.size(); ++i) {
                res.getModel().add(this.parseModuleDefinitionModuleDefinitionModelComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i = 0; i < array.size(); ++i) {
                res.getLibrary().add(this.parseModuleDefinitionModuleDefinitionLibraryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("codeSystem")) {
            array = json.getAsJsonArray("codeSystem");
            for (i = 0; i < array.size(); ++i) {
                res.getCodeSystem().add(this.parseModuleDefinitionModuleDefinitionCodeSystemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("valueSet")) {
            array = json.getAsJsonArray("valueSet");
            for (i = 0; i < array.size(); ++i) {
                res.getValueSet().add(this.parseModuleDefinitionModuleDefinitionValueSetComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseModuleDefinitionModuleDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("data")) {
            array = json.getAsJsonArray("data");
            for (i = 0; i < array.size(); ++i) {
                res.getData().add(this.parseModuleDefinitionModuleDefinitionDataComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionModelComponent parseModuleDefinitionModuleDefinitionModelComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionModelComponent res = new ModuleDefinition.ModuleDefinitionModelComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionLibraryComponent parseModuleDefinitionModuleDefinitionLibraryComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        Type document;
        ModuleDefinition.ModuleDefinitionLibraryComponent res = new ModuleDefinition.ModuleDefinitionLibraryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if ((document = this.parseType("document", json)) != null) {
            res.setDocument(document);
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionCodeSystemComponent parseModuleDefinitionModuleDefinitionCodeSystemComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionCodeSystemComponent res = new ModuleDefinition.ModuleDefinitionCodeSystemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionValueSetComponent parseModuleDefinitionModuleDefinitionValueSetComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ModuleDefinition.ModuleDefinitionValueSetComponent res = new ModuleDefinition.ModuleDefinitionValueSetComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseString(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("codeSystem")) {
            array = json.getAsJsonArray("codeSystem");
            for (i = 0; i < array.size(); ++i) {
                res.getCodeSystem().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_codeSystem")) {
            array = json.getAsJsonArray("_codeSystem");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getCodeSystem().size()) {
                    res.getCodeSystem().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getCodeSystem().get(i));
            }
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionParameterComponent parseModuleDefinitionModuleDefinitionParameterComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        ModuleDefinition.ModuleDefinitionParameterComponent res = new ModuleDefinition.ModuleDefinitionParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseCode(json.get("use").getAsString()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionDataComponent parseModuleDefinitionModuleDefinitionDataComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ModuleDefinition.ModuleDefinitionDataComponent res = new ModuleDefinition.ModuleDefinitionDataComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("mustSupport")) {
            array = json.getAsJsonArray("mustSupport");
            for (i = 0; i < array.size(); ++i) {
                res.getMustSupport().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_mustSupport")) {
            array = json.getAsJsonArray("_mustSupport");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getMustSupport().size()) {
                    res.getMustSupport().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
            }
        }
        if (json.has("codeFilter")) {
            array = json.getAsJsonArray("codeFilter");
            for (i = 0; i < array.size(); ++i) {
                res.getCodeFilter().add(this.parseModuleDefinitionModuleDefinitionDataCodeFilterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("dateFilter")) {
            array = json.getAsJsonArray("dateFilter");
            for (i = 0; i < array.size(); ++i) {
                res.getDateFilter().add(this.parseModuleDefinitionModuleDefinitionDataDateFilterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionDataCodeFilterComponent parseModuleDefinitionModuleDefinitionDataCodeFilterComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        Type valueSet;
        ModuleDefinition.ModuleDefinitionDataCodeFilterComponent res = new ModuleDefinition.ModuleDefinitionDataCodeFilterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
        if (json.has("codeableConcept")) {
            JsonArray array = json.getAsJsonArray("codeableConcept");
            for (int i = 0; i < array.size(); ++i) {
                res.getCodeableConcept().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ModuleDefinition.ModuleDefinitionDataDateFilterComponent parseModuleDefinitionModuleDefinitionDataDateFilterComponent(JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
        Type value;
        ModuleDefinition.ModuleDefinitionDataDateFilterComponent res = new ModuleDefinition.ModuleDefinitionDataDateFilterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        NamingSystem res = new NamingSystem();
        this.parseDomainResourceProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseNamingSystemNamingSystemContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("responsible")) {
            res.setResponsibleElement(this.parseString(json.get("responsible").getAsString()));
        }
        if (json.has("_responsible")) {
            this.parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("usage")) {
            res.setUsageElement(this.parseString(json.get("usage").getAsString()));
        }
        if (json.has("_usage")) {
            this.parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
        }
        if (json.has("uniqueId")) {
            array = json.getAsJsonArray("uniqueId");
            for (i = 0; i < array.size(); ++i) {
                res.getUniqueId().add(this.parseNamingSystemNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("replacedBy")) {
            res.setReplacedBy(this.parseReference(json.getAsJsonObject("replacedBy")));
        }
        return res;
    }

    protected NamingSystem.NamingSystemContactComponent parseNamingSystemNamingSystemContactComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
        NamingSystem.NamingSystemContactComponent res = new NamingSystem.NamingSystemContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(JsonObject json, NamingSystem owner) throws IOException, FHIRFormatError {
        NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("preferred")) {
            res.setPreferredElement(this.parseBoolean(json.get("preferred").getAsBoolean()));
        }
        if (json.has("_preferred")) {
            this.parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        NutritionOrder res = new NutritionOrder();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(json.get("dateTime").getAsString()));
        }
        if (json.has("_dateTime")) {
            this.parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
        }
        if (json.has("orderer")) {
            res.setOrderer(this.parseReference(json.getAsJsonObject("orderer")));
        }
        if (json.has("allergyIntolerance")) {
            array = json.getAsJsonArray("allergyIntolerance");
            for (i = 0; i < array.size(); ++i) {
                res.getAllergyIntolerance().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("foodPreferenceModifier")) {
            array = json.getAsJsonArray("foodPreferenceModifier");
            for (i = 0; i < array.size(); ++i) {
                res.getFoodPreferenceModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("excludeFoodModifier")) {
            array = json.getAsJsonArray("excludeFoodModifier");
            for (i = 0; i < array.size(); ++i) {
                res.getExcludeFoodModifier().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("oralDiet")) {
            res.setOralDiet(this.parseNutritionOrderNutritionOrderOralDietComponent(json.getAsJsonObject("oralDiet"), res));
        }
        if (json.has("supplement")) {
            array = json.getAsJsonArray("supplement");
            for (i = 0; i < array.size(); ++i) {
                res.getSupplement().add(this.parseNutritionOrderNutritionOrderSupplementComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("enteralFormula")) {
            res.setEnteralFormula(this.parseNutritionOrderNutritionOrderEnteralFormulaComponent(json.getAsJsonObject("enteralFormula"), res));
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("schedule")) {
            array = json.getAsJsonArray("schedule");
            for (i = 0; i < array.size(); ++i) {
                res.getSchedule().add(this.parseTiming(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("nutrient")) {
            array = json.getAsJsonArray("nutrient");
            for (i = 0; i < array.size(); ++i) {
                res.getNutrient().add(this.parseNutritionOrderNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("texture")) {
            array = json.getAsJsonArray("texture");
            for (i = 0; i < array.size(); ++i) {
                res.getTexture().add(this.parseNutritionOrderNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("fluidConsistencyType")) {
            array = json.getAsJsonArray("fluidConsistencyType");
            for (i = 0; i < array.size(); ++i) {
                res.getFluidConsistencyType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("instruction")) {
            res.setInstructionElement(this.parseString(json.get("instruction").getAsString()));
        }
        if (json.has("_instruction")) {
            this.parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("modifier")) {
            res.setModifier(this.parseCodeableConcept(json.getAsJsonObject("modifier")));
        }
        if (json.has("amount")) {
            res.setAmount(this.parseSimpleQuantity(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("modifier")) {
            res.setModifier(this.parseCodeableConcept(json.getAsJsonObject("modifier")));
        }
        if (json.has("foodType")) {
            res.setFoodType(this.parseCodeableConcept(json.getAsJsonObject("foodType")));
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("productName")) {
            res.setProductNameElement(this.parseString(json.get("productName").getAsString()));
        }
        if (json.has("_productName")) {
            this.parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
        }
        if (json.has("schedule")) {
            JsonArray array = json.getAsJsonArray("schedule");
            for (int i = 0; i < array.size(); ++i) {
                res.getSchedule().add(this.parseTiming(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("instruction")) {
            res.setInstructionElement(this.parseString(json.get("instruction").getAsString()));
        }
        if (json.has("_instruction")) {
            this.parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("baseFormulaType")) {
            res.setBaseFormulaType(this.parseCodeableConcept(json.getAsJsonObject("baseFormulaType")));
        }
        if (json.has("baseFormulaProductName")) {
            res.setBaseFormulaProductNameElement(this.parseString(json.get("baseFormulaProductName").getAsString()));
        }
        if (json.has("_baseFormulaProductName")) {
            this.parseElementProperties(json.getAsJsonObject("_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
        }
        if (json.has("additiveType")) {
            res.setAdditiveType(this.parseCodeableConcept(json.getAsJsonObject("additiveType")));
        }
        if (json.has("additiveProductName")) {
            res.setAdditiveProductNameElement(this.parseString(json.get("additiveProductName").getAsString()));
        }
        if (json.has("_additiveProductName")) {
            this.parseElementProperties(json.getAsJsonObject("_additiveProductName"), res.getAdditiveProductNameElement());
        }
        if (json.has("caloricDensity")) {
            res.setCaloricDensity(this.parseSimpleQuantity(json.getAsJsonObject("caloricDensity")));
        }
        if (json.has("routeofAdministration")) {
            res.setRouteofAdministration(this.parseCodeableConcept(json.getAsJsonObject("routeofAdministration")));
        }
        if (json.has("administration")) {
            JsonArray array = json.getAsJsonArray("administration");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdministration().add(this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("maxVolumeToDeliver")) {
            res.setMaxVolumeToDeliver(this.parseSimpleQuantity(json.getAsJsonObject("maxVolumeToDeliver")));
        }
        if (json.has("administrationInstruction")) {
            res.setAdministrationInstructionElement(this.parseString(json.get("administrationInstruction").getAsString()));
        }
        if (json.has("_administrationInstruction")) {
            this.parseElementProperties(json.getAsJsonObject("_administrationInstruction"), res.getAdministrationInstructionElement());
        }
        return res;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
        Type rate;
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("schedule")) {
            res.setSchedule(this.parseTiming(json.getAsJsonObject("schedule")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if ((rate = this.parseType("rate", json)) != null) {
            res.setRate(rate);
        }
        return res;
    }

    protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type value;
        Type effective;
        Observation res = new Observation();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Observation.ObservationStatus.NULL, new Observation.ObservationStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((effective = this.parseType("effective", json)) != null) {
            res.setEffective(effective);
        }
        if (json.has("issued")) {
            res.setIssuedElement(this.parseInstant(json.get("issued").getAsString()));
        }
        if (json.has("_issued")) {
            this.parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
        }
        if (json.has("performer")) {
            JsonArray array = json.getAsJsonArray("performer");
            for (int i3 = 0; i3 < array.size(); ++i3) {
                res.getPerformer().add(this.parseReference(array.get(i3).getAsJsonObject()));
            }
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
        }
        if (json.has("interpretation")) {
            res.setInterpretation(this.parseCodeableConcept(json.getAsJsonObject("interpretation")));
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("specimen")) {
            res.setSpecimen(this.parseReference(json.getAsJsonObject("specimen")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("referenceRange")) {
            JsonArray array = json.getAsJsonArray("referenceRange");
            for (i = 0; i < array.size(); ++i) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("related")) {
            JsonArray array = json.getAsJsonArray("related");
            for (i = 0; i < array.size(); ++i) {
                res.getRelated().add(this.parseObservationObservationRelatedComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("component")) {
            JsonArray array = json.getAsJsonArray("component");
            for (i = 0; i < array.size(); ++i) {
                res.getComponent().add(this.parseObservationObservationComponentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("low")) {
            res.setLow(this.parseSimpleQuantity(json.getAsJsonObject("low")));
        }
        if (json.has("high")) {
            res.setHigh(this.parseSimpleQuantity(json.getAsJsonObject("high")));
        }
        if (json.has("meaning")) {
            res.setMeaning(this.parseCodeableConcept(json.getAsJsonObject("meaning")));
        }
        if (json.has("age")) {
            res.setAge(this.parseRange(json.getAsJsonObject("age")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Observation.ObservationRelationshipType.NULL, new Observation.ObservationRelationshipTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        return res;
    }

    protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(JsonObject json, Observation owner) throws IOException, FHIRFormatError {
        Type value;
        Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        if (json.has("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
        }
        if (json.has("referenceRange")) {
            JsonArray array = json.getAsJsonArray("referenceRange");
            for (int i = 0; i < array.size(); ++i) {
                res.getReferenceRange().add(this.parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected OperationDefinition parseOperationDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        OperationDefinition res = new OperationDefinition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), OperationDefinition.OperationKind.NULL, new OperationDefinition.OperationKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseOperationDefinitionOperationDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("idempotent")) {
            res.setIdempotentElement(this.parseBoolean(json.get("idempotent").getAsBoolean()));
        }
        if (json.has("_idempotent")) {
            this.parseElementProperties(json.getAsJsonObject("_idempotent"), res.getIdempotentElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if (json.has("base")) {
            res.setBase(this.parseReference(json.getAsJsonObject("base")));
        }
        if (json.has("system")) {
            res.setSystemElement(this.parseBoolean(json.get("system").getAsBoolean()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("type")) {
            array = json.getAsJsonArray("type");
            for (i = 0; i < array.size(); ++i) {
                res.getType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_type")) {
            array = json.getAsJsonArray("_type");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getType().size()) {
                    res.getType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
            }
        }
        if (json.has("instance")) {
            res.setInstanceElement(this.parseBoolean(json.get("instance").getAsBoolean()));
        }
        if (json.has("_instance")) {
            this.parseElementProperties(json.getAsJsonObject("_instance"), res.getInstanceElement());
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected OperationDefinition.OperationDefinitionContactComponent parseOperationDefinitionOperationDefinitionContactComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionContactComponent res = new OperationDefinition.OperationDefinitionContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseCode(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("use")) {
            res.setUseElement(this.parseEnumeration(json.get("use").getAsString(), OperationDefinition.OperationParameterUse.NULL, new OperationDefinition.OperationParameterUseEnumFactory()));
        }
        if (json.has("_use")) {
            this.parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
        }
        if (json.has("min")) {
            res.setMinElement(this.parseInteger(json.get("min").getAsLong()));
        }
        if (json.has("_min")) {
            this.parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
        }
        if (json.has("max")) {
            res.setMaxElement(this.parseString(json.get("max").getAsString()));
        }
        if (json.has("_max")) {
            this.parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseCode(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("searchType")) {
            res.setSearchTypeElement(this.parseEnumeration(json.get("searchType").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_searchType")) {
            this.parseElementProperties(json.getAsJsonObject("_searchType"), res.getSearchTypeElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseReference(json.getAsJsonObject("profile")));
        }
        if (json.has("binding")) {
            res.setBinding(this.parseOperationDefinitionOperationDefinitionParameterBindingComponent(json.getAsJsonObject("binding"), owner));
        }
        if (json.has("part")) {
            JsonArray array = json.getAsJsonArray("part");
            for (int i = 0; i < array.size(); ++i) {
                res.getPart().add(this.parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
        Type valueSet;
        OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("strength")) {
            res.setStrengthElement(this.parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        }
        if (json.has("_strength")) {
            this.parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
        }
        if ((valueSet = this.parseType("valueSet", json)) != null) {
            res.setValueSet(valueSet);
        }
        return res;
    }

    protected OperationOutcome parseOperationOutcome(JsonObject json) throws IOException, FHIRFormatError {
        OperationOutcome res = new OperationOutcome();
        this.parseDomainResourceProperties(json, res);
        if (json.has("issue")) {
            JsonArray array = json.getAsJsonArray("issue");
            for (int i = 0; i < array.size(); ++i) {
                res.getIssue().add(this.parseOperationOutcomeOperationOutcomeIssueComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(JsonObject json, OperationOutcome owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("severity")) {
            res.setSeverityElement(this.parseEnumeration(json.get("severity").getAsString(), OperationOutcome.IssueSeverity.NULL, new OperationOutcome.IssueSeverityEnumFactory()));
        }
        if (json.has("_severity")) {
            this.parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseEnumeration(json.get("code").getAsString(), OperationOutcome.IssueType.NULL, new OperationOutcome.IssueTypeEnumFactory()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("details")) {
            res.setDetails(this.parseCodeableConcept(json.getAsJsonObject("details")));
        }
        if (json.has("diagnostics")) {
            res.setDiagnosticsElement(this.parseString(json.get("diagnostics").getAsString()));
        }
        if (json.has("_diagnostics")) {
            this.parseElementProperties(json.getAsJsonObject("_diagnostics"), res.getDiagnosticsElement());
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_location")) {
            array = json.getAsJsonArray("_location");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLocation().size()) {
                    res.getLocation().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLocation().get(i));
            }
        }
        if (json.has("expression")) {
            array = json.getAsJsonArray("expression");
            for (i = 0; i < array.size(); ++i) {
                res.getExpression().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_expression")) {
            array = json.getAsJsonArray("_expression");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExpression().size()) {
                    res.getExpression().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getExpression().get(i));
            }
        }
        return res;
    }

    protected Order parseOrder(JsonObject json) throws IOException, FHIRFormatError {
        Type reason;
        Order res = new Order();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("when")) {
            res.setWhen(this.parseOrderOrderWhenComponent(json.getAsJsonObject("when"), res));
        }
        if (json.has("detail")) {
            JsonArray array = json.getAsJsonArray("detail");
            for (int i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Order.OrderWhenComponent parseOrderOrderWhenComponent(JsonObject json, Order owner) throws IOException, FHIRFormatError {
        Order.OrderWhenComponent res = new Order.OrderWhenComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("schedule")) {
            res.setSchedule(this.parseTiming(json.getAsJsonObject("schedule")));
        }
        return res;
    }

    protected OrderResponse parseOrderResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        OrderResponse res = new OrderResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("who")) {
            res.setWho(this.parseReference(json.getAsJsonObject("who")));
        }
        if (json.has("orderStatus")) {
            res.setOrderStatusElement(this.parseEnumeration(json.get("orderStatus").getAsString(), OrderResponse.OrderStatus.NULL, new OrderResponse.OrderStatusEnumFactory()));
        }
        if (json.has("_orderStatus")) {
            this.parseElementProperties(json.getAsJsonObject("_orderStatus"), res.getOrderStatusElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("fulfillment")) {
            array = json.getAsJsonArray("fulfillment");
            for (i = 0; i < array.size(); ++i) {
                res.getFulfillment().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected OrderSet parseOrderSet(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        OrderSet res = new OrderSet();
        this.parseDomainResourceProperties(json, res);
        if (json.has("moduleMetadata")) {
            res.setModuleMetadata(this.parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
        }
        if (json.has("library")) {
            array = json.getAsJsonArray("library");
            for (i = 0; i < array.size(); ++i) {
                res.getLibrary().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("action")) {
            array = json.getAsJsonArray("action");
            for (i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseActionDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Organization parseOrganization(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Organization res = new Organization();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("partOf")) {
            res.setPartOf(this.parseReference(json.getAsJsonObject("partOf")));
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseOrganizationOrganizationContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(JsonObject json, Organization owner) throws IOException, FHIRFormatError {
        Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("purpose")) {
            res.setPurpose(this.parseCodeableConcept(json.getAsJsonObject("purpose")));
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        return res;
    }

    protected Patient parsePatient(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type multipleBirth;
        Type deceased;
        int i2;
        JsonArray array;
        Patient res = new Patient();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getName().add(this.parseHumanName(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getTelecom().add(this.parseContactPoint(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if ((deceased = this.parseType("deceased", json)) != null) {
            res.setDeceased(deceased);
        }
        if (json.has("address")) {
            JsonArray array2 = json.getAsJsonArray("address");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getAddress().add(this.parseAddress(array2.get(i3).getAsJsonObject()));
            }
        }
        if (json.has("maritalStatus")) {
            res.setMaritalStatus(this.parseCodeableConcept(json.getAsJsonObject("maritalStatus")));
        }
        if ((multipleBirth = this.parseType("multipleBirth", json)) != null) {
            res.setMultipleBirth(multipleBirth);
        }
        if (json.has("photo")) {
            JsonArray array3 = json.getAsJsonArray("photo");
            for (i = 0; i < array3.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("contact")) {
            JsonArray array4 = json.getAsJsonArray("contact");
            for (i = 0; i < array4.size(); ++i) {
                res.getContact().add(this.parsePatientContactComponent(array4.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("animal")) {
            res.setAnimal(this.parsePatientAnimalComponent(json.getAsJsonObject("animal"), res));
        }
        if (json.has("communication")) {
            JsonArray array5 = json.getAsJsonArray("communication");
            for (i = 0; i < array5.size(); ++i) {
                res.getCommunication().add(this.parsePatientPatientCommunicationComponent(array5.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("careProvider")) {
            JsonArray array6 = json.getAsJsonArray("careProvider");
            for (i = 0; i < array6.size(); ++i) {
                res.getCareProvider().add(this.parseReference(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("link")) {
            JsonArray array7 = json.getAsJsonArray("link");
            for (i = 0; i < array7.size(); ++i) {
                res.getLink().add(this.parsePatientPatientLinkComponent(array7.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Patient.ContactComponent parsePatientContactComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Patient.ContactComponent res = new Patient.ContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("relationship")) {
            array = json.getAsJsonArray("relationship");
            for (i = 0; i < array.size(); ++i) {
                res.getRelationship().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            res.setAddress(this.parseAddress(json.getAsJsonObject("address")));
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected Patient.AnimalComponent parsePatientAnimalComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.AnimalComponent res = new Patient.AnimalComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("species")) {
            res.setSpecies(this.parseCodeableConcept(json.getAsJsonObject("species")));
        }
        if (json.has("breed")) {
            res.setBreed(this.parseCodeableConcept(json.getAsJsonObject("breed")));
        }
        if (json.has("genderStatus")) {
            res.setGenderStatus(this.parseCodeableConcept(json.getAsJsonObject("genderStatus")));
        }
        return res;
    }

    protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguage(this.parseCodeableConcept(json.getAsJsonObject("language")));
        }
        if (json.has("preferred")) {
            res.setPreferredElement(this.parseBoolean(json.get("preferred").getAsBoolean()));
        }
        if (json.has("_preferred")) {
            this.parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
        }
        return res;
    }

    protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(JsonObject json, Patient owner) throws IOException, FHIRFormatError {
        Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("other")) {
            res.setOther(this.parseReference(json.getAsJsonObject("other")));
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        return res;
    }

    protected PaymentNotice parsePaymentNotice(JsonObject json) throws IOException, FHIRFormatError {
        Type response;
        Type request;
        Type organization;
        Type provider;
        Type target;
        PaymentNotice res = new PaymentNotice();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if ((provider = this.parseType("provider", json)) != null) {
            res.setProvider(provider);
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if ((request = this.parseType("request", json)) != null) {
            res.setRequest(request);
        }
        if ((response = this.parseType("response", json)) != null) {
            res.setResponse(response);
        }
        if (json.has("paymentStatus")) {
            res.setPaymentStatus(this.parseCoding(json.getAsJsonObject("paymentStatus")));
        }
        if (json.has("statusDate")) {
            res.setStatusDateElement(this.parseDate(json.get("statusDate").getAsString()));
        }
        if (json.has("_statusDate")) {
            this.parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
        }
        return res;
    }

    protected PaymentReconciliation parsePaymentReconciliation(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type requestOrganization;
        Type requestProvider;
        Type organization;
        Type request;
        PaymentReconciliation res = new PaymentReconciliation();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((request = this.parseType("request", json)) != null) {
            res.setRequest(request);
        }
        if (json.has("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        }
        if (json.has("_outcome")) {
            this.parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if ((requestProvider = this.parseType("requestProvider", json)) != null) {
            res.setRequestProvider(requestProvider);
        }
        if ((requestOrganization = this.parseType("requestOrganization", json)) != null) {
            res.setRequestOrganization(requestOrganization);
        }
        if (json.has("detail")) {
            array = json.getAsJsonArray("detail");
            for (i = 0; i < array.size(); ++i) {
                res.getDetail().add(this.parsePaymentReconciliationDetailsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("total")) {
            res.setTotal(this.parseMoney(json.getAsJsonObject("total")));
        }
        if (json.has("note")) {
            array = json.getAsJsonArray("note");
            for (i = 0; i < array.size(); ++i) {
                res.getNote().add(this.parsePaymentReconciliationNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
        Type payee;
        Type submitter;
        Type responce;
        Type request;
        PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if ((request = this.parseType("request", json)) != null) {
            res.setRequest(request);
        }
        if ((responce = this.parseType("responce", json)) != null) {
            res.setResponce(responce);
        }
        if ((submitter = this.parseType("submitter", json)) != null) {
            res.setSubmitter(submitter);
        }
        if ((payee = this.parseType("payee", json)) != null) {
            res.setPayee(payee);
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDate(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("amount")) {
            res.setAmount(this.parseMoney(json.getAsJsonObject("amount")));
        }
        return res;
    }

    protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(JsonObject json, PaymentReconciliation owner) throws IOException, FHIRFormatError {
        PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Person parsePerson(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Person res = new Person();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseHumanName(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("photo")) {
            res.setPhoto(this.parseAttachment(json.getAsJsonObject("photo")));
        }
        if (json.has("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(json.getAsJsonObject("managingOrganization")));
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parsePersonPersonLinkComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Person.PersonLinkComponent parsePersonPersonLinkComponent(JsonObject json, Person owner) throws IOException, FHIRFormatError {
        Person.PersonLinkComponent res = new Person.PersonLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("target")) {
            res.setTarget(this.parseReference(json.getAsJsonObject("target")));
        }
        if (json.has("assurance")) {
            res.setAssuranceElement(this.parseEnumeration(json.get("assurance").getAsString(), Person.IdentityAssuranceLevel.NULL, new Person.IdentityAssuranceLevelEnumFactory()));
        }
        if (json.has("_assurance")) {
            this.parseElementProperties(json.getAsJsonObject("_assurance"), res.getAssuranceElement());
        }
        return res;
    }

    protected Practitioner parsePractitioner(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Practitioner res = new Practitioner();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("name")) {
            array = json.getAsJsonArray("name");
            for (i = 0; i < array.size(); ++i) {
                res.getName().add(this.parseHumanName(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("photo")) {
            array = json.getAsJsonArray("photo");
            for (i = 0; i < array.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("practitionerRole")) {
            array = json.getAsJsonArray("practitionerRole");
            for (i = 0; i < array.size(); ++i) {
                res.getPractitionerRole().add(this.parsePractitionerPractitionerPractitionerRoleComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("qualification")) {
            array = json.getAsJsonArray("qualification");
            for (i = 0; i < array.size(); ++i) {
                res.getQualification().add(this.parsePractitionerPractitionerQualificationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("communication")) {
            array = json.getAsJsonArray("communication");
            for (i = 0; i < array.size(); ++i) {
                res.getCommunication().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Practitioner.PractitionerPractitionerRoleComponent parsePractitionerPractitionerPractitionerRoleComponent(JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Practitioner.PractitionerPractitionerRoleComponent res = new Practitioner.PractitionerPractitionerRoleComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("healthcareService")) {
            array = json.getAsJsonArray("healthcareService");
            for (i = 0; i < array.size(); ++i) {
                res.getHealthcareService().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
        Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("issuer")) {
            res.setIssuer(this.parseReference(json.getAsJsonObject("issuer")));
        }
        return res;
    }

    protected PractitionerRole parsePractitionerRole(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        PractitionerRole res = new PractitionerRole();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("active")) {
            res.setActiveElement(this.parseBoolean(json.get("active").getAsBoolean()));
        }
        if (json.has("_active")) {
            this.parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
        }
        if (json.has("practitioner")) {
            res.setPractitioner(this.parseReference(json.getAsJsonObject("practitioner")));
        }
        if (json.has("organization")) {
            res.setOrganization(this.parseReference(json.getAsJsonObject("organization")));
        }
        if (json.has("role")) {
            array = json.getAsJsonArray("role");
            for (i = 0; i < array.size(); ++i) {
                res.getRole().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("location")) {
            array = json.getAsJsonArray("location");
            for (i = 0; i < array.size(); ++i) {
                res.getLocation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("healthcareService")) {
            array = json.getAsJsonArray("healthcareService");
            for (i = 0; i < array.size(); ++i) {
                res.getHealthcareService().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("availableTime")) {
            array = json.getAsJsonArray("availableTime");
            for (i = 0; i < array.size(); ++i) {
                res.getAvailableTime().add(this.parsePractitionerRolePractitionerRoleAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("notAvailable")) {
            array = json.getAsJsonArray("notAvailable");
            for (i = 0; i < array.size(); ++i) {
                res.getNotAvailable().add(this.parsePractitionerRolePractitionerRoleNotAvailableComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(json.get("availabilityExceptions").getAsString()));
        }
        if (json.has("_availabilityExceptions")) {
            this.parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
        }
        return res;
    }

    protected PractitionerRole.PractitionerRoleAvailableTimeComponent parsePractitionerRolePractitionerRoleAvailableTimeComponent(JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        PractitionerRole.PractitionerRoleAvailableTimeComponent res = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("daysOfWeek")) {
            array = json.getAsJsonArray("daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                res.getDaysOfWeek().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_daysOfWeek")) {
            array = json.getAsJsonArray("_daysOfWeek");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getDaysOfWeek().size()) {
                    res.getDaysOfWeek().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
            }
        }
        if (json.has("allDay")) {
            res.setAllDayElement(this.parseBoolean(json.get("allDay").getAsBoolean()));
        }
        if (json.has("_allDay")) {
            this.parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
        }
        if (json.has("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(json.get("availableStartTime").getAsString()));
        }
        if (json.has("_availableStartTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
        }
        if (json.has("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(json.get("availableEndTime").getAsString()));
        }
        if (json.has("_availableEndTime")) {
            this.parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
        }
        return res;
    }

    protected PractitionerRole.PractitionerRoleNotAvailableComponent parsePractitionerRolePractitionerRoleNotAvailableComponent(JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
        PractitionerRole.PractitionerRoleNotAvailableComponent res = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("during")) {
            res.setDuring(this.parsePeriod(json.getAsJsonObject("during")));
        }
        return res;
    }

    protected Procedure parseProcedure(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        Type performed;
        Type reason;
        int i2;
        JsonArray array;
        Procedure res = new Procedure();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Procedure.ProcedureStatus.NULL, new Procedure.ProcedureStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategory(this.parseCodeableConcept(json.getAsJsonObject("category")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("notPerformed")) {
            res.setNotPerformedElement(this.parseBoolean(json.get("notPerformed").getAsBoolean()));
        }
        if (json.has("_notPerformed")) {
            this.parseElementProperties(json.getAsJsonObject("_notPerformed"), res.getNotPerformedElement());
        }
        if (json.has("reasonNotPerformed")) {
            array = json.getAsJsonArray("reasonNotPerformed");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getReasonNotPerformed().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("bodySite")) {
            array = json.getAsJsonArray("bodySite");
            for (i2 = 0; i2 < array.size(); ++i2) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i2).getAsJsonObject()));
            }
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("performer")) {
            JsonArray array2 = json.getAsJsonArray("performer");
            for (int i3 = 0; i3 < array2.size(); ++i3) {
                res.getPerformer().add(this.parseProcedureProcedurePerformerComponent(array2.get(i3).getAsJsonObject(), res));
            }
        }
        if ((performed = this.parseType("performed", json)) != null) {
            res.setPerformed(performed);
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if (json.has("report")) {
            JsonArray array3 = json.getAsJsonArray("report");
            for (i = 0; i < array3.size(); ++i) {
                res.getReport().add(this.parseReference(array3.get(i).getAsJsonObject()));
            }
        }
        if (json.has("complication")) {
            JsonArray array4 = json.getAsJsonArray("complication");
            for (i = 0; i < array4.size(); ++i) {
                res.getComplication().add(this.parseCodeableConcept(array4.get(i).getAsJsonObject()));
            }
        }
        if (json.has("followUp")) {
            JsonArray array5 = json.getAsJsonArray("followUp");
            for (i = 0; i < array5.size(); ++i) {
                res.getFollowUp().add(this.parseCodeableConcept(array5.get(i).getAsJsonObject()));
            }
        }
        if (json.has("request")) {
            res.setRequest(this.parseReference(json.getAsJsonObject("request")));
        }
        if (json.has("notes")) {
            JsonArray array6 = json.getAsJsonArray("notes");
            for (i = 0; i < array6.size(); ++i) {
                res.getNotes().add(this.parseAnnotation(array6.get(i).getAsJsonObject()));
            }
        }
        if (json.has("focalDevice")) {
            JsonArray array7 = json.getAsJsonArray("focalDevice");
            for (i = 0; i < array7.size(); ++i) {
                res.getFocalDevice().add(this.parseProcedureProcedureFocalDeviceComponent(array7.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("used")) {
            JsonArray array8 = json.getAsJsonArray("used");
            for (i = 0; i < array8.size(); ++i) {
                res.getUsed().add(this.parseReference(array8.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
        Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("role")) {
            res.setRole(this.parseCodeableConcept(json.getAsJsonObject("role")));
        }
        return res;
    }

    protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(JsonObject json, Procedure owner) throws IOException, FHIRFormatError {
        Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            res.setAction(this.parseCodeableConcept(json.getAsJsonObject("action")));
        }
        if (json.has("manipulated")) {
            res.setManipulated(this.parseReference(json.getAsJsonObject("manipulated")));
        }
        return res;
    }

    protected ProcedureRequest parseProcedureRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type asNeeded;
        Type scheduled;
        Type reason;
        int i;
        JsonArray array;
        ProcedureRequest res = new ProcedureRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("bodySite")) {
            array = json.getAsJsonArray("bodySite");
            for (i = 0; i < array.size(); ++i) {
                res.getBodySite().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if ((scheduled = this.parseType("scheduled", json)) != null) {
            res.setScheduled(scheduled);
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("notes")) {
            JsonArray array2 = json.getAsJsonArray("notes");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getNotes().add(this.parseAnnotation(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((asNeeded = this.parseType("asNeeded", json)) != null) {
            res.setAsNeeded(asNeeded);
        }
        if (json.has("orderedOn")) {
            res.setOrderedOnElement(this.parseDateTime(json.get("orderedOn").getAsString()));
        }
        if (json.has("_orderedOn")) {
            this.parseElementProperties(json.getAsJsonObject("_orderedOn"), res.getOrderedOnElement());
        }
        if (json.has("orderer")) {
            res.setOrderer(this.parseReference(json.getAsJsonObject("orderer")));
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        return res;
    }

    protected ProcessRequest parseProcessRequest(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type response;
        Type request;
        Type organization;
        Type provider;
        Type target;
        ProcessRequest res = new ProcessRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("action")) {
            res.setActionElement(this.parseEnumeration(json.get("action").getAsString(), ProcessRequest.ActionList.NULL, new ProcessRequest.ActionListEnumFactory()));
        }
        if (json.has("_action")) {
            this.parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
        }
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if ((target = this.parseType("target", json)) != null) {
            res.setTarget(target);
        }
        if ((provider = this.parseType("provider", json)) != null) {
            res.setProvider(provider);
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if ((request = this.parseType("request", json)) != null) {
            res.setRequest(request);
        }
        if ((response = this.parseType("response", json)) != null) {
            res.setResponse(response);
        }
        if (json.has("nullify")) {
            res.setNullifyElement(this.parseBoolean(json.get("nullify").getAsBoolean()));
        }
        if (json.has("_nullify")) {
            this.parseElementProperties(json.getAsJsonObject("_nullify"), res.getNullifyElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseString(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseProcessRequestItemsComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("include")) {
            array = json.getAsJsonArray("include");
            for (i = 0; i < array.size(); ++i) {
                res.getInclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_include")) {
            array = json.getAsJsonArray("_include");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getInclude().size()) {
                    res.getInclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getInclude().get(i));
            }
        }
        if (json.has("exclude")) {
            array = json.getAsJsonArray("exclude");
            for (i = 0; i < array.size(); ++i) {
                res.getExclude().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_exclude")) {
            array = json.getAsJsonArray("_exclude");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getExclude().size()) {
                    res.getExclude().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getExclude().get(i));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(JsonObject json, ProcessRequest owner) throws IOException, FHIRFormatError {
        ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequenceLinkId")) {
            res.setSequenceLinkIdElement(this.parseInteger(json.get("sequenceLinkId").getAsLong()));
        }
        if (json.has("_sequenceLinkId")) {
            this.parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
        }
        return res;
    }

    protected ProcessResponse parseProcessResponse(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Type requestOrganization;
        Type requestProvider;
        Type organization;
        Type request;
        ProcessResponse res = new ProcessResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array2 = json.getAsJsonArray("identifier");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getIdentifier().add(this.parseIdentifier(array2.get(i2).getAsJsonObject()));
            }
        }
        if ((request = this.parseType("request", json)) != null) {
            res.setRequest(request);
        }
        if (json.has("outcome")) {
            res.setOutcome(this.parseCoding(json.getAsJsonObject("outcome")));
        }
        if (json.has("disposition")) {
            res.setDispositionElement(this.parseString(json.get("disposition").getAsString()));
        }
        if (json.has("_disposition")) {
            this.parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseCoding(json.getAsJsonObject("ruleset")));
        }
        if (json.has("originalRuleset")) {
            res.setOriginalRuleset(this.parseCoding(json.getAsJsonObject("originalRuleset")));
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if ((organization = this.parseType("organization", json)) != null) {
            res.setOrganization(organization);
        }
        if ((requestProvider = this.parseType("requestProvider", json)) != null) {
            res.setRequestProvider(requestProvider);
        }
        if ((requestOrganization = this.parseType("requestOrganization", json)) != null) {
            res.setRequestOrganization(requestOrganization);
        }
        if (json.has("form")) {
            res.setForm(this.parseCoding(json.getAsJsonObject("form")));
        }
        if (json.has("notes")) {
            array = json.getAsJsonArray("notes");
            for (i = 0; i < array.size(); ++i) {
                res.getNotes().add(this.parseProcessResponseProcessResponseNotesComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("error")) {
            array = json.getAsJsonArray("error");
            for (i = 0; i < array.size(); ++i) {
                res.getError().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ProcessResponse.ProcessResponseNotesComponent parseProcessResponseProcessResponseNotesComponent(JsonObject json, ProcessResponse owner) throws IOException, FHIRFormatError {
        ProcessResponse.ProcessResponseNotesComponent res = new ProcessResponse.ProcessResponseNotesComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        return res;
    }

    protected Protocol parseProtocol(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Protocol res = new Protocol();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Protocol.ProtocolStatus.NULL, new Protocol.ProtocolStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Protocol.ProtocolType.NULL, new Protocol.ProtocolTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("group")) {
            res.setGroup(this.parseReference(json.getAsJsonObject("group")));
        }
        if (json.has("purpose")) {
            res.setPurposeElement(this.parseString(json.get("purpose").getAsString()));
        }
        if (json.has("_purpose")) {
            this.parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("step")) {
            array = json.getAsJsonArray("step");
            for (i = 0; i < array.size(); ++i) {
                res.getStep().add(this.parseProtocolProtocolStepComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Protocol.ProtocolStepComponent parseProtocolProtocolStepComponent(JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Protocol.ProtocolStepComponent res = new Protocol.ProtocolStepComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("duration")) {
            res.setDuration(this.parseDuration(json.getAsJsonObject("duration")));
        }
        if (json.has("precondition")) {
            res.setPrecondition(this.parseProtocolProtocolStepPreconditionComponent(json.getAsJsonObject("precondition"), owner));
        }
        if (json.has("exit")) {
            res.setExit(this.parseProtocolProtocolStepPreconditionComponent(json.getAsJsonObject("exit"), owner));
        }
        if (json.has("firstActivity")) {
            res.setFirstActivityElement(this.parseUri(json.get("firstActivity").getAsString()));
        }
        if (json.has("_firstActivity")) {
            this.parseElementProperties(json.getAsJsonObject("_firstActivity"), res.getFirstActivityElement());
        }
        if (json.has("activity")) {
            array = json.getAsJsonArray("activity");
            for (i = 0; i < array.size(); ++i) {
                res.getActivity().add(this.parseProtocolProtocolStepActivityComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("next")) {
            array = json.getAsJsonArray("next");
            for (i = 0; i < array.size(); ++i) {
                res.getNext().add(this.parseProtocolProtocolStepNextComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Protocol.ProtocolStepPreconditionComponent parseProtocolProtocolStepPreconditionComponent(JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Protocol.ProtocolStepPreconditionComponent res = new Protocol.ProtocolStepPreconditionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("condition")) {
            res.setCondition(this.parseProtocolProtocolStepPreconditionConditionComponent(json.getAsJsonObject("condition"), owner));
        }
        if (json.has("intersection")) {
            array = json.getAsJsonArray("intersection");
            for (i = 0; i < array.size(); ++i) {
                res.getIntersection().add(this.parseProtocolProtocolStepPreconditionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("union")) {
            array = json.getAsJsonArray("union");
            for (i = 0; i < array.size(); ++i) {
                res.getUnion().add(this.parseProtocolProtocolStepPreconditionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("exclude")) {
            array = json.getAsJsonArray("exclude");
            for (i = 0; i < array.size(); ++i) {
                res.getExclude().add(this.parseProtocolProtocolStepPreconditionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Protocol.ProtocolStepPreconditionConditionComponent parseProtocolProtocolStepPreconditionConditionComponent(JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
        Type value;
        Protocol.ProtocolStepPreconditionConditionComponent res = new Protocol.ProtocolStepPreconditionConditionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected Protocol.ProtocolStepActivityComponent parseProtocolProtocolStepActivityComponent(JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Protocol.ProtocolStepActivityComponent res = new Protocol.ProtocolStepActivityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("alternative")) {
            array = json.getAsJsonArray("alternative");
            for (i = 0; i < array.size(); ++i) {
                res.getAlternative().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_alternative")) {
            array = json.getAsJsonArray("_alternative");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getAlternative().size()) {
                    res.getAlternative().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getAlternative().get(i));
            }
        }
        if (json.has("component")) {
            array = json.getAsJsonArray("component");
            for (i = 0; i < array.size(); ++i) {
                res.getComponent().add(this.parseProtocolProtocolStepActivityComponentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("following")) {
            array = json.getAsJsonArray("following");
            for (i = 0; i < array.size(); ++i) {
                res.getFollowing().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_following")) {
            array = json.getAsJsonArray("_following");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getFollowing().size()) {
                    res.getFollowing().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getFollowing().get(i));
            }
        }
        if (json.has("wait")) {
            res.setWait(this.parseDuration(json.getAsJsonObject("wait")));
        }
        if (json.has("detail")) {
            res.setDetail(this.parseProtocolProtocolStepActivityDetailComponent(json.getAsJsonObject("detail"), owner));
        }
        return res;
    }

    protected Protocol.ProtocolStepActivityComponentComponent parseProtocolProtocolStepActivityComponentComponent(JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
        Protocol.ProtocolStepActivityComponentComponent res = new Protocol.ProtocolStepActivityComponentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("sequence")) {
            res.setSequenceElement(this.parseInteger(json.get("sequence").getAsLong()));
        }
        if (json.has("_sequence")) {
            this.parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
        }
        if (json.has("activity")) {
            res.setActivityElement(this.parseUri(json.get("activity").getAsString()));
        }
        if (json.has("_activity")) {
            this.parseElementProperties(json.getAsJsonObject("_activity"), res.getActivityElement());
        }
        return res;
    }

    protected Protocol.ProtocolStepActivityDetailComponent parseProtocolProtocolStepActivityDetailComponent(JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
        Type timing;
        Protocol.ProtocolStepActivityDetailComponent res = new Protocol.ProtocolStepActivityDetailComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), Protocol.ActivityDefinitionCategory.NULL, new Protocol.ActivityDefinitionCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if ((timing = this.parseType("timing", json)) != null) {
            res.setTiming(timing);
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("performer")) {
            JsonArray array = json.getAsJsonArray("performer");
            for (int i = 0; i < array.size(); ++i) {
                res.getPerformer().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("product")) {
            res.setProduct(this.parseReference(json.getAsJsonObject("product")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        return res;
    }

    protected Protocol.ProtocolStepNextComponent parseProtocolProtocolStepNextComponent(JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
        Protocol.ProtocolStepNextComponent res = new Protocol.ProtocolStepNextComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("condition")) {
            res.setCondition(this.parseProtocolProtocolStepPreconditionComponent(json.getAsJsonObject("condition"), owner));
        }
        return res;
    }

    protected Provenance parseProvenance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Provenance res = new Provenance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        if (json.has("recorded")) {
            res.setRecordedElement(this.parseInstant(json.get("recorded").getAsString()));
        }
        if (json.has("_recorded")) {
            this.parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
        }
        if (json.has("reason")) {
            array = json.getAsJsonArray("reason");
            for (i = 0; i < array.size(); ++i) {
                res.getReason().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("activity")) {
            res.setActivity(this.parseCoding(json.getAsJsonObject("activity")));
        }
        if (json.has("location")) {
            res.setLocation(this.parseReference(json.getAsJsonObject("location")));
        }
        if (json.has("policy")) {
            array = json.getAsJsonArray("policy");
            for (i = 0; i < array.size(); ++i) {
                res.getPolicy().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_policy")) {
            array = json.getAsJsonArray("_policy");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getPolicy().size()) {
                    res.getPolicy().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
            }
        }
        if (json.has("agent")) {
            array = json.getAsJsonArray("agent");
            for (i = 0; i < array.size(); ++i) {
                res.getAgent().add(this.parseProvenanceProvenanceAgentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("entity")) {
            array = json.getAsJsonArray("entity");
            for (i = 0; i < array.size(); ++i) {
                res.getEntity().add(this.parseProvenanceProvenanceEntityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("signature")) {
            array = json.getAsJsonArray("signature");
            for (i = 0; i < array.size(); ++i) {
                res.getSignature().add(this.parseSignature(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRole(this.parseCoding(json.getAsJsonObject("role")));
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("userId")) {
            res.setUserId(this.parseIdentifier(json.getAsJsonObject("userId")));
        }
        if (json.has("relatedAgent")) {
            JsonArray array = json.getAsJsonArray("relatedAgent");
            for (int i = 0; i < array.size(); ++i) {
                res.getRelatedAgent().add(this.parseProvenanceProvenanceAgentRelatedAgentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Provenance.ProvenanceAgentRelatedAgentComponent parseProvenanceProvenanceAgentRelatedAgentComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceAgentRelatedAgentComponent res = new Provenance.ProvenanceAgentRelatedAgentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("target")) {
            res.setTargetElement(this.parseUri(json.get("target").getAsString()));
        }
        if (json.has("_target")) {
            this.parseElementProperties(json.getAsJsonObject("_target"), res.getTargetElement());
        }
        return res;
    }

    protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
        Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("role")) {
            res.setRoleElement(this.parseEnumeration(json.get("role").getAsString(), Provenance.ProvenanceEntityRole.NULL, new Provenance.ProvenanceEntityRoleEnumFactory()));
        }
        if (json.has("_role")) {
            this.parseElementProperties(json.getAsJsonObject("_role"), res.getRoleElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("reference")) {
            res.setReferenceElement(this.parseUri(json.get("reference").getAsString()));
        }
        if (json.has("_reference")) {
            this.parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("agent")) {
            res.setAgent(this.parseProvenanceProvenanceAgentComponent(json.getAsJsonObject("agent"), owner));
        }
        return res;
    }

    protected Questionnaire parseQuestionnaire(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Questionnaire res = new Questionnaire();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Questionnaire.QuestionnaireStatus.NULL, new Questionnaire.QuestionnaireStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("title")) {
            res.setTitleElement(this.parseString(json.get("title").getAsString()));
        }
        if (json.has("_title")) {
            this.parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("subjectType")) {
            array = json.getAsJsonArray("subjectType");
            for (i = 0; i < array.size(); ++i) {
                res.getSubjectType().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_subjectType")) {
            array = json.getAsJsonArray("_subjectType");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getSubjectType().size()) {
                    res.getSubjectType().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getSubjectType().get(i));
            }
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Questionnaire.QuestionnaireItemComponent parseQuestionnaireQuestionnaireItemComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        Type initial;
        int i;
        JsonArray array;
        Questionnaire.QuestionnaireItemComponent res = new Questionnaire.QuestionnaireItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prefix")) {
            res.setPrefixElement(this.parseString(json.get("prefix").getAsString()));
        }
        if (json.has("_prefix")) {
            this.parseElementProperties(json.getAsJsonObject("_prefix"), res.getPrefixElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Questionnaire.QuestionnaireItemType.NULL, new Questionnaire.QuestionnaireItemTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("enableWhen")) {
            array = json.getAsJsonArray("enableWhen");
            for (i = 0; i < array.size(); ++i) {
                res.getEnableWhen().add(this.parseQuestionnaireQuestionnaireItemEnableWhenComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("repeats")) {
            res.setRepeatsElement(this.parseBoolean(json.get("repeats").getAsBoolean()));
        }
        if (json.has("_repeats")) {
            this.parseElementProperties(json.getAsJsonObject("_repeats"), res.getRepeatsElement());
        }
        if (json.has("readOnly")) {
            res.setReadOnlyElement(this.parseBoolean(json.get("readOnly").getAsBoolean()));
        }
        if (json.has("_readOnly")) {
            this.parseElementProperties(json.getAsJsonObject("_readOnly"), res.getReadOnlyElement());
        }
        if (json.has("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(json.get("maxLength").getAsLong()));
        }
        if (json.has("_maxLength")) {
            this.parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
        }
        if (json.has("options")) {
            res.setOptions(this.parseReference(json.getAsJsonObject("options")));
        }
        if (json.has("option")) {
            array = json.getAsJsonArray("option");
            for (i = 0; i < array.size(); ++i) {
                res.getOption().add(this.parseQuestionnaireQuestionnaireItemOptionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if ((initial = this.parseType("initial", json)) != null) {
            res.setInitial(initial);
        }
        if (json.has("item")) {
            JsonArray array2 = json.getAsJsonArray("item");
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                res.getItem().add(this.parseQuestionnaireQuestionnaireItemComponent(array2.get(i2).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected Questionnaire.QuestionnaireItemEnableWhenComponent parseQuestionnaireQuestionnaireItemEnableWhenComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        Type answer;
        Questionnaire.QuestionnaireItemEnableWhenComponent res = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("question")) {
            res.setQuestionElement(this.parseString(json.get("question").getAsString()));
        }
        if (json.has("_question")) {
            this.parseElementProperties(json.getAsJsonObject("_question"), res.getQuestionElement());
        }
        if (json.has("answered")) {
            res.setAnsweredElement(this.parseBoolean(json.get("answered").getAsBoolean()));
        }
        if (json.has("_answered")) {
            this.parseElementProperties(json.getAsJsonObject("_answered"), res.getAnsweredElement());
        }
        if ((answer = this.parseType("answer", json)) != null) {
            res.setAnswer(answer);
        }
        return res;
    }

    protected Questionnaire.QuestionnaireItemOptionComponent parseQuestionnaireQuestionnaireItemOptionComponent(JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
        Questionnaire.QuestionnaireItemOptionComponent res = new Questionnaire.QuestionnaireItemOptionComponent();
        this.parseBackboneProperties(json, res);
        Type value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
        return res;
    }

    protected QuestionnaireResponse parseQuestionnaireResponse(JsonObject json) throws IOException, FHIRFormatError {
        QuestionnaireResponse res = new QuestionnaireResponse();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("questionnaire")) {
            res.setQuestionnaire(this.parseReference(json.getAsJsonObject("questionnaire")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), QuestionnaireResponse.QuestionnaireResponseStatus.NULL, new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("author")) {
            res.setAuthor(this.parseReference(json.getAsJsonObject("author")));
        }
        if (json.has("authored")) {
            res.setAuthoredElement(this.parseDateTime(json.get("authored").getAsString()));
        }
        if (json.has("_authored")) {
            this.parseElementProperties(json.getAsJsonObject("_authored"), res.getAuthoredElement());
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemComponent parseQuestionnaireResponseQuestionnaireResponseItemComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        QuestionnaireResponse.QuestionnaireResponseItemComponent res = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("linkId")) {
            res.setLinkIdElement(this.parseString(json.get("linkId").getAsString()));
        }
        if (json.has("_linkId")) {
            this.parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
        }
        if (json.has("text")) {
            res.setTextElement(this.parseString(json.get("text").getAsString()));
        }
        if (json.has("_text")) {
            this.parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("answer")) {
            array = json.getAsJsonArray("answer");
            for (i = 0; i < array.size(); ++i) {
                res.getAnswer().add(this.parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("item")) {
            array = json.getAsJsonArray("item");
            for (i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        this.parseBackboneProperties(json, res);
        Type value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
        if (json.has("item")) {
            JsonArray array = json.getAsJsonArray("item");
            for (int i = 0; i < array.size(); ++i) {
                res.getItem().add(this.parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ReferralRequest parseReferralRequest(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ReferralRequest res = new ReferralRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("basedOn")) {
            array = json.getAsJsonArray("basedOn");
            for (i = 0; i < array.size(); ++i) {
                res.getBasedOn().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("parent")) {
            res.setParent(this.parseIdentifier(json.getAsJsonObject("parent")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), ReferralRequest.ReferralStatus.NULL, new ReferralRequest.ReferralStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("category")) {
            res.setCategoryElement(this.parseEnumeration(json.get("category").getAsString(), ReferralRequest.ReferralCategory.NULL, new ReferralRequest.ReferralCategoryEnumFactory()));
        }
        if (json.has("_category")) {
            this.parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("priority")) {
            res.setPriority(this.parseCodeableConcept(json.getAsJsonObject("priority")));
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("context")) {
            res.setContext(this.parseReference(json.getAsJsonObject("context")));
        }
        if (json.has("fulfillmentTime")) {
            res.setFulfillmentTime(this.parsePeriod(json.getAsJsonObject("fulfillmentTime")));
        }
        if (json.has("authored")) {
            res.setAuthoredElement(this.parseDateTime(json.get("authored").getAsString()));
        }
        if (json.has("_authored")) {
            this.parseElementProperties(json.getAsJsonObject("_authored"), res.getAuthoredElement());
        }
        if (json.has("requester")) {
            res.setRequester(this.parseReference(json.getAsJsonObject("requester")));
        }
        if (json.has("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(json.getAsJsonObject("specialty")));
        }
        if (json.has("recipient")) {
            array = json.getAsJsonArray("recipient");
            for (i = 0; i < array.size(); ++i) {
                res.getRecipient().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            res.setReason(this.parseCodeableConcept(json.getAsJsonObject("reason")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("serviceRequested")) {
            array = json.getAsJsonArray("serviceRequested");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceRequested().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("supportingInformation")) {
            array = json.getAsJsonArray("supportingInformation");
            for (i = 0; i < array.size(); ++i) {
                res.getSupportingInformation().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected RelatedPerson parseRelatedPerson(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        RelatedPerson res = new RelatedPerson();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("relationship")) {
            res.setRelationship(this.parseCodeableConcept(json.getAsJsonObject("relationship")));
        }
        if (json.has("name")) {
            res.setName(this.parseHumanName(json.getAsJsonObject("name")));
        }
        if (json.has("telecom")) {
            array = json.getAsJsonArray("telecom");
            for (i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("gender")) {
            res.setGenderElement(this.parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL, new Enumerations.AdministrativeGenderEnumFactory()));
        }
        if (json.has("_gender")) {
            this.parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
        }
        if (json.has("birthDate")) {
            res.setBirthDateElement(this.parseDate(json.get("birthDate").getAsString()));
        }
        if (json.has("_birthDate")) {
            this.parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
        }
        if (json.has("address")) {
            array = json.getAsJsonArray("address");
            for (i = 0; i < array.size(); ++i) {
                res.getAddress().add(this.parseAddress(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("photo")) {
            array = json.getAsJsonArray("photo");
            for (i = 0; i < array.size(); ++i) {
                res.getPhoto().add(this.parseAttachment(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("period")) {
            res.setPeriod(this.parsePeriod(json.getAsJsonObject("period")));
        }
        return res;
    }

    protected RiskAssessment parseRiskAssessment(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        RiskAssessment res = new RiskAssessment();
        this.parseDomainResourceProperties(json, res);
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("condition")) {
            res.setCondition(this.parseReference(json.getAsJsonObject("condition")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if (json.has("performer")) {
            res.setPerformer(this.parseReference(json.getAsJsonObject("performer")));
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("basis")) {
            array = json.getAsJsonArray("basis");
            for (i = 0; i < array.size(); ++i) {
                res.getBasis().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("prediction")) {
            array = json.getAsJsonArray("prediction");
            for (i = 0; i < array.size(); ++i) {
                res.getPrediction().add(this.parseRiskAssessmentRiskAssessmentPredictionComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("mitigation")) {
            res.setMitigationElement(this.parseString(json.get("mitigation").getAsString()));
        }
        if (json.has("_mitigation")) {
            this.parseElementProperties(json.getAsJsonObject("_mitigation"), res.getMitigationElement());
        }
        return res;
    }

    protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(JsonObject json, RiskAssessment owner) throws IOException, FHIRFormatError {
        Type when;
        Type probability;
        RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("outcome")) {
            res.setOutcome(this.parseCodeableConcept(json.getAsJsonObject("outcome")));
        }
        if ((probability = this.parseType("probability", json)) != null) {
            res.setProbability(probability);
        }
        if (json.has("relativeRisk")) {
            res.setRelativeRiskElement(this.parseDecimal(json.get("relativeRisk").getAsBigDecimal()));
        }
        if (json.has("_relativeRisk")) {
            this.parseElementProperties(json.getAsJsonObject("_relativeRisk"), res.getRelativeRiskElement());
        }
        if ((when = this.parseType("when", json)) != null) {
            res.setWhen(when);
        }
        if (json.has("rationale")) {
            res.setRationaleElement(this.parseString(json.get("rationale").getAsString()));
        }
        if (json.has("_rationale")) {
            this.parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
        }
        return res;
    }

    protected Schedule parseSchedule(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Schedule res = new Schedule();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("actor")) {
            res.setActor(this.parseReference(json.getAsJsonObject("actor")));
        }
        if (json.has("planningHorizon")) {
            res.setPlanningHorizon(this.parsePeriod(json.getAsJsonObject("planningHorizon")));
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        return res;
    }

    protected SearchParameter parseSearchParameter(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        SearchParameter res = new SearchParameter();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseSearchParameterSearchParameterContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("base")) {
            res.setBaseElement(this.parseCode(json.get("base").getAsString()));
        }
        if (json.has("_base")) {
            this.parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("expression")) {
            res.setExpressionElement(this.parseString(json.get("expression").getAsString()));
        }
        if (json.has("_expression")) {
            this.parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
        }
        if (json.has("xpath")) {
            res.setXpathElement(this.parseString(json.get("xpath").getAsString()));
        }
        if (json.has("_xpath")) {
            this.parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
        }
        if (json.has("xpathUsage")) {
            res.setXpathUsageElement(this.parseEnumeration(json.get("xpathUsage").getAsString(), SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
        }
        if (json.has("_xpathUsage")) {
            this.parseElementProperties(json.getAsJsonObject("_xpathUsage"), res.getXpathUsageElement());
        }
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseCode(array.get(i).getAsString()));
            }
        }
        if (json.has("_target")) {
            array = json.getAsJsonArray("_target");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getTarget().size()) {
                    res.getTarget().add(this.parseCode(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
            }
        }
        return res;
    }

    protected SearchParameter.SearchParameterContactComponent parseSearchParameterSearchParameterContactComponent(JsonObject json, SearchParameter owner) throws IOException, FHIRFormatError {
        SearchParameter.SearchParameterContactComponent res = new SearchParameter.SearchParameterContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Sequence parseSequence(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Sequence res = new Sequence();
        this.parseDomainResourceProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Sequence.SequenceType.NULL, new Sequence.SequenceTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("specimen")) {
            res.setSpecimen(this.parseReference(json.getAsJsonObject("specimen")));
        }
        if (json.has("device")) {
            res.setDevice(this.parseReference(json.getAsJsonObject("device")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("species")) {
            res.setSpecies(this.parseCodeableConcept(json.getAsJsonObject("species")));
        }
        if (json.has("referenceSeq")) {
            array = json.getAsJsonArray("referenceSeq");
            for (i = 0; i < array.size(); ++i) {
                res.getReferenceSeq().add(this.parseSequenceSequenceReferenceSeqComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("variation")) {
            res.setVariation(this.parseSequenceSequenceVariationComponent(json.getAsJsonObject("variation"), res));
        }
        if (json.has("quality")) {
            array = json.getAsJsonArray("quality");
            for (i = 0; i < array.size(); ++i) {
                res.getQuality().add(this.parseSequenceSequenceQualityComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("allelicState")) {
            res.setAllelicState(this.parseCodeableConcept(json.getAsJsonObject("allelicState")));
        }
        if (json.has("allelicFrequency")) {
            res.setAllelicFrequencyElement(this.parseDecimal(json.get("allelicFrequency").getAsBigDecimal()));
        }
        if (json.has("_allelicFrequency")) {
            this.parseElementProperties(json.getAsJsonObject("_allelicFrequency"), res.getAllelicFrequencyElement());
        }
        if (json.has("copyNumberEvent")) {
            res.setCopyNumberEvent(this.parseCodeableConcept(json.getAsJsonObject("copyNumberEvent")));
        }
        if (json.has("readCoverage")) {
            res.setReadCoverageElement(this.parseInteger(json.get("readCoverage").getAsLong()));
        }
        if (json.has("_readCoverage")) {
            this.parseElementProperties(json.getAsJsonObject("_readCoverage"), res.getReadCoverageElement());
        }
        if (json.has("repository")) {
            array = json.getAsJsonArray("repository");
            for (i = 0; i < array.size(); ++i) {
                res.getRepository().add(this.parseSequenceSequenceRepositoryComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("pointer")) {
            array = json.getAsJsonArray("pointer");
            for (i = 0; i < array.size(); ++i) {
                res.getPointer().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("observedSeq")) {
            res.setObservedSeqElement(this.parseString(json.get("observedSeq").getAsString()));
        }
        if (json.has("_observedSeq")) {
            this.parseElementProperties(json.getAsJsonObject("_observedSeq"), res.getObservedSeqElement());
        }
        if (json.has("observation")) {
            res.setObservation(this.parseReference(json.getAsJsonObject("observation")));
        }
        if (json.has("structureVariation")) {
            res.setStructureVariation(this.parseSequenceSequenceStructureVariationComponent(json.getAsJsonObject("structureVariation"), res));
        }
        return res;
    }

    protected Sequence.SequenceReferenceSeqComponent parseSequenceSequenceReferenceSeqComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceReferenceSeqComponent res = new Sequence.SequenceReferenceSeqComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("chromosome")) {
            res.setChromosome(this.parseCodeableConcept(json.getAsJsonObject("chromosome")));
        }
        if (json.has("genomeBuild")) {
            res.setGenomeBuildElement(this.parseString(json.get("genomeBuild").getAsString()));
        }
        if (json.has("_genomeBuild")) {
            this.parseElementProperties(json.getAsJsonObject("_genomeBuild"), res.getGenomeBuildElement());
        }
        if (json.has("referenceSeqId")) {
            res.setReferenceSeqId(this.parseCodeableConcept(json.getAsJsonObject("referenceSeqId")));
        }
        if (json.has("referenceSeqPointer")) {
            res.setReferenceSeqPointer(this.parseReference(json.getAsJsonObject("referenceSeqPointer")));
        }
        if (json.has("referenceSeqString")) {
            res.setReferenceSeqStringElement(this.parseString(json.get("referenceSeqString").getAsString()));
        }
        if (json.has("_referenceSeqString")) {
            this.parseElementProperties(json.getAsJsonObject("_referenceSeqString"), res.getReferenceSeqStringElement());
        }
        if (json.has("windowStart")) {
            res.setWindowStartElement(this.parseInteger(json.get("windowStart").getAsLong()));
        }
        if (json.has("_windowStart")) {
            this.parseElementProperties(json.getAsJsonObject("_windowStart"), res.getWindowStartElement());
        }
        if (json.has("windowEnd")) {
            res.setWindowEndElement(this.parseInteger(json.get("windowEnd").getAsLong()));
        }
        if (json.has("_windowEnd")) {
            this.parseElementProperties(json.getAsJsonObject("_windowEnd"), res.getWindowEndElement());
        }
        return res;
    }

    protected Sequence.SequenceVariationComponent parseSequenceSequenceVariationComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceVariationComponent res = new Sequence.SequenceVariationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseInteger(json.get("start").getAsLong()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInteger(json.get("end").getAsLong()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("observedAllele")) {
            res.setObservedAlleleElement(this.parseString(json.get("observedAllele").getAsString()));
        }
        if (json.has("_observedAllele")) {
            this.parseElementProperties(json.getAsJsonObject("_observedAllele"), res.getObservedAlleleElement());
        }
        if (json.has("referenceAllele")) {
            res.setReferenceAlleleElement(this.parseString(json.get("referenceAllele").getAsString()));
        }
        if (json.has("_referenceAllele")) {
            this.parseElementProperties(json.getAsJsonObject("_referenceAllele"), res.getReferenceAlleleElement());
        }
        if (json.has("cigar")) {
            res.setCigarElement(this.parseString(json.get("cigar").getAsString()));
        }
        if (json.has("_cigar")) {
            this.parseElementProperties(json.getAsJsonObject("_cigar"), res.getCigarElement());
        }
        return res;
    }

    protected Sequence.SequenceQualityComponent parseSequenceSequenceQualityComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceQualityComponent res = new Sequence.SequenceQualityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseInteger(json.get("start").getAsLong()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInteger(json.get("end").getAsLong()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("score")) {
            res.setScore(this.parseQuantity(json.getAsJsonObject("score")));
        }
        if (json.has("method")) {
            res.setMethodElement(this.parseString(json.get("method").getAsString()));
        }
        if (json.has("_method")) {
            this.parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
        }
        return res;
    }

    protected Sequence.SequenceRepositoryComponent parseSequenceSequenceRepositoryComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceRepositoryComponent res = new Sequence.SequenceRepositoryComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("variantId")) {
            res.setVariantIdElement(this.parseString(json.get("variantId").getAsString()));
        }
        if (json.has("_variantId")) {
            this.parseElementProperties(json.getAsJsonObject("_variantId"), res.getVariantIdElement());
        }
        if (json.has("readId")) {
            res.setReadIdElement(this.parseString(json.get("readId").getAsString()));
        }
        if (json.has("_readId")) {
            this.parseElementProperties(json.getAsJsonObject("_readId"), res.getReadIdElement());
        }
        return res;
    }

    protected Sequence.SequenceStructureVariationComponent parseSequenceSequenceStructureVariationComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceStructureVariationComponent res = new Sequence.SequenceStructureVariationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("precisionOfBoundaries")) {
            res.setPrecisionOfBoundariesElement(this.parseString(json.get("precisionOfBoundaries").getAsString()));
        }
        if (json.has("_precisionOfBoundaries")) {
            this.parseElementProperties(json.getAsJsonObject("_precisionOfBoundaries"), res.getPrecisionOfBoundariesElement());
        }
        if (json.has("reportedaCGHRatio")) {
            res.setReportedaCGHRatioElement(this.parseDecimal(json.get("reportedaCGHRatio").getAsBigDecimal()));
        }
        if (json.has("_reportedaCGHRatio")) {
            this.parseElementProperties(json.getAsJsonObject("_reportedaCGHRatio"), res.getReportedaCGHRatioElement());
        }
        if (json.has("length")) {
            res.setLengthElement(this.parseInteger(json.get("length").getAsLong()));
        }
        if (json.has("_length")) {
            this.parseElementProperties(json.getAsJsonObject("_length"), res.getLengthElement());
        }
        if (json.has("outer")) {
            res.setOuter(this.parseSequenceSequenceStructureVariationOuterComponent(json.getAsJsonObject("outer"), owner));
        }
        if (json.has("inner")) {
            res.setInner(this.parseSequenceSequenceStructureVariationInnerComponent(json.getAsJsonObject("inner"), owner));
        }
        return res;
    }

    protected Sequence.SequenceStructureVariationOuterComponent parseSequenceSequenceStructureVariationOuterComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceStructureVariationOuterComponent res = new Sequence.SequenceStructureVariationOuterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseInteger(json.get("start").getAsLong()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInteger(json.get("end").getAsLong()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        return res;
    }

    protected Sequence.SequenceStructureVariationInnerComponent parseSequenceSequenceStructureVariationInnerComponent(JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
        Sequence.SequenceStructureVariationInnerComponent res = new Sequence.SequenceStructureVariationInnerComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("start")) {
            res.setStartElement(this.parseInteger(json.get("start").getAsLong()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInteger(json.get("end").getAsLong()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        return res;
    }

    protected Slot parseSlot(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Slot res = new Slot();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("serviceCategory")) {
            res.setServiceCategory(this.parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
        }
        if (json.has("serviceType")) {
            array = json.getAsJsonArray("serviceType");
            for (i = 0; i < array.size(); ++i) {
                res.getServiceType().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("specialty")) {
            array = json.getAsJsonArray("specialty");
            for (i = 0; i < array.size(); ++i) {
                res.getSpecialty().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(json.getAsJsonObject("appointmentType")));
        }
        if (json.has("schedule")) {
            res.setSchedule(this.parseReference(json.getAsJsonObject("schedule")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("start")) {
            res.setStartElement(this.parseInstant(json.get("start").getAsString()));
        }
        if (json.has("_start")) {
            this.parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("overbooked")) {
            res.setOverbookedElement(this.parseBoolean(json.get("overbooked").getAsBoolean()));
        }
        if (json.has("_overbooked")) {
            this.parseElementProperties(json.getAsJsonObject("_overbooked"), res.getOverbookedElement());
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        return res;
    }

    protected Specimen parseSpecimen(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Specimen res = new Specimen();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("accessionIdentifier")) {
            res.setAccessionIdentifier(this.parseIdentifier(json.getAsJsonObject("accessionIdentifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Specimen.SpecimenStatus.NULL, new Specimen.SpecimenStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("receivedTime")) {
            res.setReceivedTimeElement(this.parseDateTime(json.get("receivedTime").getAsString()));
        }
        if (json.has("_receivedTime")) {
            this.parseElementProperties(json.getAsJsonObject("_receivedTime"), res.getReceivedTimeElement());
        }
        if (json.has("parent")) {
            array = json.getAsJsonArray("parent");
            for (i = 0; i < array.size(); ++i) {
                res.getParent().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("collection")) {
            res.setCollection(this.parseSpecimenSpecimenCollectionComponent(json.getAsJsonObject("collection"), res));
        }
        if (json.has("treatment")) {
            array = json.getAsJsonArray("treatment");
            for (i = 0; i < array.size(); ++i) {
                res.getTreatment().add(this.parseSpecimenSpecimenTreatmentComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("container")) {
            array = json.getAsJsonArray("container");
            for (i = 0; i < array.size(); ++i) {
                res.getContainer().add(this.parseSpecimenSpecimenContainerComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
        Type collected;
        Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("collector")) {
            res.setCollector(this.parseReference(json.getAsJsonObject("collector")));
        }
        if (json.has("comment")) {
            res.setCommentElement(this.parseString(json.get("comment").getAsString()));
        }
        if (json.has("_comment")) {
            this.parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
        }
        if ((collected = this.parseType("collected", json)) != null) {
            res.setCollected(collected);
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("method")) {
            res.setMethod(this.parseCodeableConcept(json.getAsJsonObject("method")));
        }
        if (json.has("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(json.getAsJsonObject("bodySite")));
        }
        return res;
    }

    protected Specimen.SpecimenTreatmentComponent parseSpecimenSpecimenTreatmentComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
        Specimen.SpecimenTreatmentComponent res = new Specimen.SpecimenTreatmentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("procedure")) {
            res.setProcedure(this.parseCodeableConcept(json.getAsJsonObject("procedure")));
        }
        if (json.has("additive")) {
            JsonArray array = json.getAsJsonArray("additive");
            for (int i = 0; i < array.size(); ++i) {
                res.getAdditive().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(JsonObject json, Specimen owner) throws IOException, FHIRFormatError {
        Type additive;
        Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("capacity")) {
            res.setCapacity(this.parseSimpleQuantity(json.getAsJsonObject("capacity")));
        }
        if (json.has("specimenQuantity")) {
            res.setSpecimenQuantity(this.parseSimpleQuantity(json.getAsJsonObject("specimenQuantity")));
        }
        if ((additive = this.parseType("additive", json)) != null) {
            res.setAdditive(additive);
        }
        return res;
    }

    protected StructureDefinition parseStructureDefinition(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        StructureDefinition res = new StructureDefinition();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseStructureDefinitionStructureDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("code")) {
            array = json.getAsJsonArray("code");
            for (i = 0; i < array.size(); ++i) {
                res.getCode().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("fhirVersion")) {
            res.setFhirVersionElement(this.parseId(json.get("fhirVersion").getAsString()));
        }
        if (json.has("_fhirVersion")) {
            this.parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
        }
        if (json.has("mapping")) {
            array = json.getAsJsonArray("mapping");
            for (i = 0; i < array.size(); ++i) {
                res.getMapping().add(this.parseStructureDefinitionStructureDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("kind")) {
            res.setKindElement(this.parseEnumeration(json.get("kind").getAsString(), StructureDefinition.StructureDefinitionKind.NULL, new StructureDefinition.StructureDefinitionKindEnumFactory()));
        }
        if (json.has("_kind")) {
            this.parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
        }
        if (json.has("abstract")) {
            res.setAbstractElement(this.parseBoolean(json.get("abstract").getAsBoolean()));
        }
        if (json.has("_abstract")) {
            this.parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
        }
        if (json.has("contextType")) {
            res.setContextTypeElement(this.parseEnumeration(json.get("contextType").getAsString(), StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
        }
        if (json.has("_contextType")) {
            this.parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
        }
        if (json.has("context")) {
            array = json.getAsJsonArray("context");
            for (i = 0; i < array.size(); ++i) {
                res.getContext().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_context")) {
            array = json.getAsJsonArray("_context");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getContext().size()) {
                    res.getContext().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getContext().get(i));
            }
        }
        if (json.has("baseType")) {
            res.setBaseTypeElement(this.parseCode(json.get("baseType").getAsString()));
        }
        if (json.has("_baseType")) {
            this.parseElementProperties(json.getAsJsonObject("_baseType"), res.getBaseTypeElement());
        }
        if (json.has("baseDefinition")) {
            res.setBaseDefinitionElement(this.parseUri(json.get("baseDefinition").getAsString()));
        }
        if (json.has("_baseDefinition")) {
            this.parseElementProperties(json.getAsJsonObject("_baseDefinition"), res.getBaseDefinitionElement());
        }
        if (json.has("derivation")) {
            res.setDerivationElement(this.parseEnumeration(json.get("derivation").getAsString(), StructureDefinition.TypeDerivationRule.NULL, new StructureDefinition.TypeDerivationRuleEnumFactory()));
        }
        if (json.has("_derivation")) {
            this.parseElementProperties(json.getAsJsonObject("_derivation"), res.getDerivationElement());
        }
        if (json.has("snapshot")) {
            res.setSnapshot(this.parseStructureDefinitionStructureDefinitionSnapshotComponent(json.getAsJsonObject("snapshot"), res));
        }
        if (json.has("differential")) {
            res.setDifferential(this.parseStructureDefinitionStructureDefinitionDifferentialComponent(json.getAsJsonObject("differential"), res));
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionContactComponent parseStructureDefinitionStructureDefinitionContactComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionContactComponent res = new StructureDefinition.StructureDefinitionContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identity")) {
            res.setIdentityElement(this.parseId(json.get("identity").getAsString()));
        }
        if (json.has("_identity")) {
            this.parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
        }
        if (json.has("uri")) {
            res.setUriElement(this.parseUri(json.get("uri").getAsString()));
        }
        if (json.has("_uri")) {
            this.parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("comments")) {
            res.setCommentsElement(this.parseString(json.get("comments").getAsString()));
        }
        if (json.has("_comments")) {
            this.parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("element")) {
            JsonArray array = json.getAsJsonArray("element");
            for (int i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseElementDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
        StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("element")) {
            JsonArray array = json.getAsJsonArray("element");
            for (int i = 0; i < array.size(); ++i) {
                res.getElement().add(this.parseElementDefinition(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected StructureMap parseStructureMap(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        StructureMap res = new StructureMap();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseStructureMapStructureMapContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("structure")) {
            array = json.getAsJsonArray("structure");
            for (i = 0; i < array.size(); ++i) {
                res.getStructure().add(this.parseStructureMapStructureMapStructureComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("import")) {
            array = json.getAsJsonArray("import");
            for (i = 0; i < array.size(); ++i) {
                res.getImport().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_import")) {
            array = json.getAsJsonArray("_import");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImport().size()) {
                    res.getImport().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImport().get(i));
            }
        }
        if (json.has("group")) {
            array = json.getAsJsonArray("group");
            for (i = 0; i < array.size(); ++i) {
                res.getGroup().add(this.parseStructureMapStructureMapGroupComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected StructureMap.StructureMapContactComponent parseStructureMapStructureMapContactComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        StructureMap.StructureMapContactComponent res = new StructureMap.StructureMapContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected StructureMap.StructureMapStructureComponent parseStructureMapStructureMapStructureComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        StructureMap.StructureMapStructureComponent res = new StructureMap.StructureMapStructureComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), StructureMap.StructureMapModelMode.NULL, new StructureMap.StructureMapModelModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected StructureMap.StructureMapGroupComponent parseStructureMapStructureMapGroupComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        StructureMap.StructureMapGroupComponent res = new StructureMap.StructureMapGroupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseId(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("extends")) {
            res.setExtendsElement(this.parseId(json.get("extends").getAsString()));
        }
        if (json.has("_extends")) {
            this.parseElementProperties(json.getAsJsonObject("_extends"), res.getExtendsElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        if (json.has("input")) {
            array = json.getAsJsonArray("input");
            for (i = 0; i < array.size(); ++i) {
                res.getInput().add(this.parseStructureMapStructureMapGroupInputComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("rule")) {
            array = json.getAsJsonArray("rule");
            for (i = 0; i < array.size(); ++i) {
                res.getRule().add(this.parseStructureMapStructureMapGroupRuleComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected StructureMap.StructureMapGroupInputComponent parseStructureMapStructureMapGroupInputComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        StructureMap.StructureMapGroupInputComponent res = new StructureMap.StructureMapGroupInputComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseId(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("type")) {
            res.setTypeElement(this.parseString(json.get("type").getAsString()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("mode")) {
            res.setModeElement(this.parseEnumeration(json.get("mode").getAsString(), StructureMap.StructureMapInputMode.NULL, new StructureMap.StructureMapInputModeEnumFactory()));
        }
        if (json.has("_mode")) {
            this.parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected StructureMap.StructureMapGroupRuleComponent parseStructureMapStructureMapGroupRuleComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        StructureMap.StructureMapGroupRuleComponent res = new StructureMap.StructureMapGroupRuleComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseId(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("source")) {
            array = json.getAsJsonArray("source");
            for (i = 0; i < array.size(); ++i) {
                res.getSource().add(this.parseStructureMapStructureMapGroupRuleSourceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("target")) {
            array = json.getAsJsonArray("target");
            for (i = 0; i < array.size(); ++i) {
                res.getTarget().add(this.parseStructureMapStructureMapGroupRuleTargetComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("rule")) {
            array = json.getAsJsonArray("rule");
            for (i = 0; i < array.size(); ++i) {
                res.getRule().add(this.parseStructureMapStructureMapGroupRuleComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("dependent")) {
            array = json.getAsJsonArray("dependent");
            for (i = 0; i < array.size(); ++i) {
                res.getDependent().add(this.parseStructureMapStructureMapGroupRuleDependentComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("documentation")) {
            res.setDocumentationElement(this.parseString(json.get("documentation").getAsString()));
        }
        if (json.has("_documentation")) {
            this.parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
        }
        return res;
    }

    protected StructureMap.StructureMapGroupRuleSourceComponent parseStructureMapStructureMapGroupRuleSourceComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleSourceComponent res = new StructureMap.StructureMapGroupRuleSourceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("context")) {
            res.setContextElement(this.parseId(json.get("context").getAsString()));
        }
        if (json.has("_context")) {
            this.parseElementProperties(json.getAsJsonObject("_context"), res.getContextElement());
        }
        if (json.has("contextType")) {
            res.setContextTypeElement(this.parseEnumeration(json.get("contextType").getAsString(), StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
        }
        if (json.has("_contextType")) {
            this.parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
        }
        if (json.has("element")) {
            res.setElementElement(this.parseString(json.get("element").getAsString()));
        }
        if (json.has("_element")) {
            this.parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
        }
        if (json.has("listMode")) {
            res.setListModeElement(this.parseEnumeration(json.get("listMode").getAsString(), StructureMap.StructureMapListMode.NULL, new StructureMap.StructureMapListModeEnumFactory()));
        }
        if (json.has("_listMode")) {
            this.parseElementProperties(json.getAsJsonObject("_listMode"), res.getListModeElement());
        }
        if (json.has("variable")) {
            res.setVariableElement(this.parseId(json.get("variable").getAsString()));
        }
        if (json.has("_variable")) {
            this.parseElementProperties(json.getAsJsonObject("_variable"), res.getVariableElement());
        }
        if (json.has("condition")) {
            res.setConditionElement(this.parseString(json.get("condition").getAsString()));
        }
        if (json.has("_condition")) {
            this.parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
        }
        if (json.has("check")) {
            res.setCheckElement(this.parseString(json.get("check").getAsString()));
        }
        if (json.has("_check")) {
            this.parseElementProperties(json.getAsJsonObject("_check"), res.getCheckElement());
        }
        return res;
    }

    protected StructureMap.StructureMapGroupRuleTargetComponent parseStructureMapStructureMapGroupRuleTargetComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        StructureMap.StructureMapGroupRuleTargetComponent res = new StructureMap.StructureMapGroupRuleTargetComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("context")) {
            res.setContextElement(this.parseId(json.get("context").getAsString()));
        }
        if (json.has("_context")) {
            this.parseElementProperties(json.getAsJsonObject("_context"), res.getContextElement());
        }
        if (json.has("contextType")) {
            res.setContextTypeElement(this.parseEnumeration(json.get("contextType").getAsString(), StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
        }
        if (json.has("_contextType")) {
            this.parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
        }
        if (json.has("element")) {
            res.setElementElement(this.parseString(json.get("element").getAsString()));
        }
        if (json.has("_element")) {
            this.parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
        }
        if (json.has("variable")) {
            res.setVariableElement(this.parseId(json.get("variable").getAsString()));
        }
        if (json.has("_variable")) {
            this.parseElementProperties(json.getAsJsonObject("_variable"), res.getVariableElement());
        }
        if (json.has("listMode")) {
            array = json.getAsJsonArray("listMode");
            for (i = 0; i < array.size(); ++i) {
                res.getListMode().add(this.parseEnumeration(array.get(i).getAsString(), StructureMap.StructureMapListMode.NULL, new StructureMap.StructureMapListModeEnumFactory()));
            }
        }
        if (json.has("_listMode")) {
            array = json.getAsJsonArray("_listMode");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getListMode().size()) {
                    res.getListMode().add(this.parseEnumeration(null, StructureMap.StructureMapListMode.NULL, new StructureMap.StructureMapListModeEnumFactory()));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getListMode().get(i));
            }
        }
        if (json.has("listRuleId")) {
            res.setListRuleIdElement(this.parseId(json.get("listRuleId").getAsString()));
        }
        if (json.has("_listRuleId")) {
            this.parseElementProperties(json.getAsJsonObject("_listRuleId"), res.getListRuleIdElement());
        }
        if (json.has("transform")) {
            res.setTransformElement(this.parseEnumeration(json.get("transform").getAsString(), StructureMap.StructureMapTransform.NULL, new StructureMap.StructureMapTransformEnumFactory()));
        }
        if (json.has("_transform")) {
            this.parseElementProperties(json.getAsJsonObject("_transform"), res.getTransformElement());
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseStructureMapStructureMapGroupRuleTargetParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected StructureMap.StructureMapGroupRuleTargetParameterComponent parseStructureMapStructureMapGroupRuleTargetParameterComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        StructureMap.StructureMapGroupRuleTargetParameterComponent res = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        this.parseBackboneProperties(json, res);
        Type value = this.parseType("value", json);
        if (value != null) {
            res.setValue(value);
        }
        return res;
    }

    protected StructureMap.StructureMapGroupRuleDependentComponent parseStructureMapStructureMapGroupRuleDependentComponent(JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        StructureMap.StructureMapGroupRuleDependentComponent res = new StructureMap.StructureMapGroupRuleDependentComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseId(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("variable")) {
            array = json.getAsJsonArray("variable");
            for (i = 0; i < array.size(); ++i) {
                res.getVariable().add(this.parseString(array.get(i).getAsString()));
            }
        }
        if (json.has("_variable")) {
            array = json.getAsJsonArray("_variable");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getVariable().size()) {
                    res.getVariable().add(this.parseString(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getVariable().get(i));
            }
        }
        return res;
    }

    protected Subscription parseSubscription(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Subscription res = new Subscription();
        this.parseDomainResourceProperties(json, res);
        if (json.has("criteria")) {
            res.setCriteriaElement(this.parseString(json.get("criteria").getAsString()));
        }
        if (json.has("_criteria")) {
            this.parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("reason")) {
            res.setReasonElement(this.parseString(json.get("reason").getAsString()));
        }
        if (json.has("_reason")) {
            this.parseElementProperties(json.getAsJsonObject("_reason"), res.getReasonElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Subscription.SubscriptionStatus.NULL, new Subscription.SubscriptionStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("error")) {
            res.setErrorElement(this.parseString(json.get("error").getAsString()));
        }
        if (json.has("_error")) {
            this.parseElementProperties(json.getAsJsonObject("_error"), res.getErrorElement());
        }
        if (json.has("channel")) {
            res.setChannel(this.parseSubscriptionSubscriptionChannelComponent(json.getAsJsonObject("channel"), res));
        }
        if (json.has("end")) {
            res.setEndElement(this.parseInstant(json.get("end").getAsString()));
        }
        if (json.has("_end")) {
            this.parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
        }
        if (json.has("tag")) {
            array = json.getAsJsonArray("tag");
            for (i = 0; i < array.size(); ++i) {
                res.getTag().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(JsonObject json, Subscription owner) throws IOException, FHIRFormatError {
        Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setTypeElement(this.parseEnumeration(json.get("type").getAsString(), Subscription.SubscriptionChannelType.NULL, new Subscription.SubscriptionChannelTypeEnumFactory()));
        }
        if (json.has("_type")) {
            this.parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
        }
        if (json.has("endpoint")) {
            res.setEndpointElement(this.parseUri(json.get("endpoint").getAsString()));
        }
        if (json.has("_endpoint")) {
            this.parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
        }
        if (json.has("payload")) {
            res.setPayloadElement(this.parseString(json.get("payload").getAsString()));
        }
        if (json.has("_payload")) {
            this.parseElementProperties(json.getAsJsonObject("_payload"), res.getPayloadElement());
        }
        if (json.has("header")) {
            res.setHeaderElement(this.parseString(json.get("header").getAsString()));
        }
        if (json.has("_header")) {
            this.parseElementProperties(json.getAsJsonObject("_header"), res.getHeaderElement());
        }
        return res;
    }

    protected Substance parseSubstance(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Substance res = new Substance();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            array = json.getAsJsonArray("identifier");
            for (i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("category")) {
            array = json.getAsJsonArray("category");
            for (i = 0; i < array.size(); ++i) {
                res.getCategory().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("instance")) {
            array = json.getAsJsonArray("instance");
            for (i = 0; i < array.size(); ++i) {
                res.getInstance().add(this.parseSubstanceSubstanceInstanceComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("ingredient")) {
            array = json.getAsJsonArray("ingredient");
            for (i = 0; i < array.size(); ++i) {
                res.getIngredient().add(this.parseSubstanceSubstanceIngredientComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(JsonObject json, Substance owner) throws IOException, FHIRFormatError {
        Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("expiry")) {
            res.setExpiryElement(this.parseDateTime(json.get("expiry").getAsString()));
        }
        if (json.has("_expiry")) {
            this.parseElementProperties(json.getAsJsonObject("_expiry"), res.getExpiryElement());
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        return res;
    }

    protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(JsonObject json, Substance owner) throws IOException, FHIRFormatError {
        Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("quantity")) {
            res.setQuantity(this.parseRatio(json.getAsJsonObject("quantity")));
        }
        if (json.has("substance")) {
            res.setSubstance(this.parseReference(json.getAsJsonObject("substance")));
        }
        return res;
    }

    protected SupplyDelivery parseSupplyDelivery(JsonObject json) throws IOException, FHIRFormatError {
        SupplyDelivery res = new SupplyDelivery();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), SupplyDelivery.SupplyDeliveryStatus.NULL, new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("quantity")) {
            res.setQuantity(this.parseSimpleQuantity(json.getAsJsonObject("quantity")));
        }
        if (json.has("suppliedItem")) {
            res.setSuppliedItem(this.parseReference(json.getAsJsonObject("suppliedItem")));
        }
        if (json.has("supplier")) {
            res.setSupplier(this.parseReference(json.getAsJsonObject("supplier")));
        }
        if (json.has("whenPrepared")) {
            res.setWhenPrepared(this.parsePeriod(json.getAsJsonObject("whenPrepared")));
        }
        if (json.has("time")) {
            res.setTimeElement(this.parseDateTime(json.get("time").getAsString()));
        }
        if (json.has("_time")) {
            this.parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
        }
        if (json.has("destination")) {
            res.setDestination(this.parseReference(json.getAsJsonObject("destination")));
        }
        if (json.has("receiver")) {
            JsonArray array = json.getAsJsonArray("receiver");
            for (int i = 0; i < array.size(); ++i) {
                res.getReceiver().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected SupplyRequest parseSupplyRequest(JsonObject json) throws IOException, FHIRFormatError {
        Type reason;
        SupplyRequest res = new SupplyRequest();
        this.parseDomainResourceProperties(json, res);
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("source")) {
            res.setSource(this.parseReference(json.getAsJsonObject("source")));
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), SupplyRequest.SupplyRequestStatus.NULL, new SupplyRequest.SupplyRequestStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("kind")) {
            res.setKind(this.parseCodeableConcept(json.getAsJsonObject("kind")));
        }
        if (json.has("orderedItem")) {
            res.setOrderedItem(this.parseReference(json.getAsJsonObject("orderedItem")));
        }
        if (json.has("supplier")) {
            JsonArray array = json.getAsJsonArray("supplier");
            for (int i = 0; i < array.size(); ++i) {
                res.getSupplier().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("when")) {
            res.setWhen(this.parseSupplyRequestSupplyRequestWhenComponent(json.getAsJsonObject("when"), res));
        }
        return res;
    }

    protected SupplyRequest.SupplyRequestWhenComponent parseSupplyRequestSupplyRequestWhenComponent(JsonObject json, SupplyRequest owner) throws IOException, FHIRFormatError {
        SupplyRequest.SupplyRequestWhenComponent res = new SupplyRequest.SupplyRequestWhenComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCode(this.parseCodeableConcept(json.getAsJsonObject("code")));
        }
        if (json.has("schedule")) {
            res.setSchedule(this.parseTiming(json.getAsJsonObject("schedule")));
        }
        return res;
    }

    protected Task parseTask(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        Task res = new Task();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("type")) {
            res.setType(this.parseCodeableConcept(json.getAsJsonObject("type")));
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("performerType")) {
            array = json.getAsJsonArray("performerType");
            for (i = 0; i < array.size(); ++i) {
                res.getPerformerType().add(this.parseCoding(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("priority")) {
            res.setPriorityElement(this.parseEnumeration(json.get("priority").getAsString(), Task.TaskPriority.NULL, new Task.TaskPriorityEnumFactory()));
        }
        if (json.has("_priority")) {
            this.parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Task.TaskStatus.NULL, new Task.TaskStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("failureReason")) {
            res.setFailureReason(this.parseCodeableConcept(json.getAsJsonObject("failureReason")));
        }
        if (json.has("subject")) {
            res.setSubject(this.parseReference(json.getAsJsonObject("subject")));
        }
        if (json.has("for")) {
            res.setFor(this.parseReference(json.getAsJsonObject("for")));
        }
        if (json.has("definition")) {
            res.setDefinitionElement(this.parseUri(json.get("definition").getAsString()));
        }
        if (json.has("_definition")) {
            this.parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
        }
        if (json.has("created")) {
            res.setCreatedElement(this.parseDateTime(json.get("created").getAsString()));
        }
        if (json.has("_created")) {
            this.parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
        }
        if (json.has("lastModified")) {
            res.setLastModifiedElement(this.parseDateTime(json.get("lastModified").getAsString()));
        }
        if (json.has("_lastModified")) {
            this.parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
        }
        if (json.has("creator")) {
            res.setCreator(this.parseReference(json.getAsJsonObject("creator")));
        }
        if (json.has("owner")) {
            res.setOwner(this.parseReference(json.getAsJsonObject("owner")));
        }
        if (json.has("parent")) {
            res.setParent(this.parseReference(json.getAsJsonObject("parent")));
        }
        if (json.has("input")) {
            array = json.getAsJsonArray("input");
            for (i = 0; i < array.size(); ++i) {
                res.getInput().add(this.parseTaskParameterComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("output")) {
            array = json.getAsJsonArray("output");
            for (i = 0; i < array.size(); ++i) {
                res.getOutput().add(this.parseTaskTaskOutputComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected Task.ParameterComponent parseTaskParameterComponent(JsonObject json, Task owner) throws IOException, FHIRFormatError {
        Type value;
        Task.ParameterComponent res = new Task.ParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected Task.TaskOutputComponent parseTaskTaskOutputComponent(JsonObject json, Task owner) throws IOException, FHIRFormatError {
        Type value;
        Task.TaskOutputComponent res = new Task.TaskOutputComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected TestScript parseTestScript(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        TestScript res = new TestScript();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseTestScriptTestScriptContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("origin")) {
            array = json.getAsJsonArray("origin");
            for (i = 0; i < array.size(); ++i) {
                res.getOrigin().add(this.parseTestScriptTestScriptOriginComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("destination")) {
            array = json.getAsJsonArray("destination");
            for (i = 0; i < array.size(); ++i) {
                res.getDestination().add(this.parseTestScriptTestScriptDestinationComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("metadata")) {
            res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), res));
        }
        if (json.has("fixture")) {
            array = json.getAsJsonArray("fixture");
            for (i = 0; i < array.size(); ++i) {
                res.getFixture().add(this.parseTestScriptTestScriptFixtureComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("profile")) {
            array = json.getAsJsonArray("profile");
            for (i = 0; i < array.size(); ++i) {
                res.getProfile().add(this.parseReference(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("variable")) {
            array = json.getAsJsonArray("variable");
            for (i = 0; i < array.size(); ++i) {
                res.getVariable().add(this.parseTestScriptTestScriptVariableComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("rule")) {
            array = json.getAsJsonArray("rule");
            for (i = 0; i < array.size(); ++i) {
                res.getRule().add(this.parseTestScriptTestScriptRuleComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("ruleset")) {
            array = json.getAsJsonArray("ruleset");
            for (i = 0; i < array.size(); ++i) {
                res.getRuleset().add(this.parseTestScriptTestScriptRulesetComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("setup")) {
            res.setSetup(this.parseTestScriptTestScriptSetupComponent(json.getAsJsonObject("setup"), res));
        }
        if (json.has("test")) {
            array = json.getAsJsonArray("test");
            for (i = 0; i < array.size(); ++i) {
                res.getTest().add(this.parseTestScriptTestScriptTestComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("teardown")) {
            res.setTeardown(this.parseTestScriptTestScriptTeardownComponent(json.getAsJsonObject("teardown"), res));
        }
        return res;
    }

    protected TestScript.TestScriptContactComponent parseTestScriptTestScriptContactComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptContactComponent res = new TestScript.TestScriptContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected TestScript.TestScriptOriginComponent parseTestScriptTestScriptOriginComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptOriginComponent res = new TestScript.TestScriptOriginComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("index")) {
            res.setIndexElement(this.parseInteger(json.get("index").getAsLong()));
        }
        if (json.has("_index")) {
            this.parseElementProperties(json.getAsJsonObject("_index"), res.getIndexElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseCoding(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected TestScript.TestScriptDestinationComponent parseTestScriptTestScriptDestinationComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptDestinationComponent res = new TestScript.TestScriptDestinationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("index")) {
            res.setIndexElement(this.parseInteger(json.get("index").getAsLong()));
        }
        if (json.has("_index")) {
            this.parseElementProperties(json.getAsJsonObject("_index"), res.getIndexElement());
        }
        if (json.has("profile")) {
            res.setProfile(this.parseCoding(json.getAsJsonObject("profile")));
        }
        return res;
    }

    protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseTestScriptTestScriptMetadataLinkComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("capability")) {
            array = json.getAsJsonArray("capability");
            for (i = 0; i < array.size(); ++i) {
                res.getCapability().add(this.parseTestScriptTestScriptMetadataCapabilityComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        return res;
    }

    protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("required")) {
            res.setRequiredElement(this.parseBoolean(json.get("required").getAsBoolean()));
        }
        if (json.has("_required")) {
            this.parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
        }
        if (json.has("validated")) {
            res.setValidatedElement(this.parseBoolean(json.get("validated").getAsBoolean()));
        }
        if (json.has("_validated")) {
            this.parseElementProperties(json.getAsJsonObject("_validated"), res.getValidatedElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("origin")) {
            array = json.getAsJsonArray("origin");
            for (i = 0; i < array.size(); ++i) {
                res.getOrigin().add(this.parseInteger(array.get(i).getAsLong()));
            }
        }
        if (json.has("_origin")) {
            array = json.getAsJsonArray("_origin");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getOrigin().size()) {
                    res.getOrigin().add(this.parseInteger(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getOrigin().get(i));
            }
        }
        if (json.has("destination")) {
            res.setDestinationElement(this.parseInteger(json.get("destination").getAsLong()));
        }
        if (json.has("_destination")) {
            this.parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
        }
        if (json.has("link")) {
            array = json.getAsJsonArray("link");
            for (i = 0; i < array.size(); ++i) {
                res.getLink().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_link")) {
            array = json.getAsJsonArray("_link");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getLink().size()) {
                    res.getLink().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getLink().get(i));
            }
        }
        if (json.has("conformance")) {
            res.setConformance(this.parseReference(json.getAsJsonObject("conformance")));
        }
        return res;
    }

    protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("autocreate")) {
            res.setAutocreateElement(this.parseBoolean(json.get("autocreate").getAsBoolean()));
        }
        if (json.has("_autocreate")) {
            this.parseElementProperties(json.getAsJsonObject("_autocreate"), res.getAutocreateElement());
        }
        if (json.has("autodelete")) {
            res.setAutodeleteElement(this.parseBoolean(json.get("autodelete").getAsBoolean()));
        }
        if (json.has("_autodelete")) {
            this.parseElementProperties(json.getAsJsonObject("_autodelete"), res.getAutodeleteElement());
        }
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        return res;
    }

    protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("defaultValue")) {
            res.setDefaultValueElement(this.parseString(json.get("defaultValue").getAsString()));
        }
        if (json.has("_defaultValue")) {
            this.parseElementProperties(json.getAsJsonObject("_defaultValue"), res.getDefaultValueElement());
        }
        if (json.has("headerField")) {
            res.setHeaderFieldElement(this.parseString(json.get("headerField").getAsString()));
        }
        if (json.has("_headerField")) {
            this.parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("sourceId")) {
            res.setSourceIdElement(this.parseId(json.get("sourceId").getAsString()));
        }
        if (json.has("_sourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
        }
        return res;
    }

    protected TestScript.TestScriptRuleComponent parseTestScriptTestScriptRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptRuleComponent res = new TestScript.TestScriptRuleComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        if (json.has("param")) {
            JsonArray array = json.getAsJsonArray("param");
            for (int i = 0; i < array.size(); ++i) {
                res.getParam().add(this.parseTestScriptTestScriptRuleParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptRuleParamComponent parseTestScriptTestScriptRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptRuleParamComponent res = new TestScript.TestScriptRuleParamComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected TestScript.TestScriptRulesetComponent parseTestScriptTestScriptRulesetComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptRulesetComponent res = new TestScript.TestScriptRulesetComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("resource")) {
            res.setResource(this.parseReference(json.getAsJsonObject("resource")));
        }
        if (json.has("rule")) {
            JsonArray array = json.getAsJsonArray("rule");
            for (int i = 0; i < array.size(); ++i) {
                res.getRule().add(this.parseTestScriptTestScriptRulesetRuleComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptRulesetRuleComponent parseTestScriptTestScriptRulesetRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptRulesetRuleComponent res = new TestScript.TestScriptRulesetRuleComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("ruleId")) {
            res.setRuleIdElement(this.parseId(json.get("ruleId").getAsString()));
        }
        if (json.has("_ruleId")) {
            this.parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
        }
        if (json.has("param")) {
            JsonArray array = json.getAsJsonArray("param");
            for (int i = 0; i < array.size(); ++i) {
                res.getParam().add(this.parseTestScriptTestScriptRulesetRuleParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestScriptRulesetRuleParamComponent parseTestScriptTestScriptRulesetRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptRulesetRuleParamComponent res = new TestScript.TestScriptRulesetRuleParamComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected TestScript.TestScriptSetupComponent parseTestScriptTestScriptSetupComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptSetupComponent res = new TestScript.TestScriptSetupComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("metadata")) {
            res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), owner));
        }
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (int i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseTestScriptSetupActionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.SetupActionComponent parseTestScriptSetupActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionComponent res = new TestScript.SetupActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("operation")) {
            res.setOperation(this.parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
        }
        if (json.has("assert")) {
            res.setAssert(this.parseTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
        }
        return res;
    }

    protected TestScript.SetupActionOperationComponent parseTestScriptSetupActionOperationComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionOperationComponent res = new TestScript.SetupActionOperationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("type")) {
            res.setType(this.parseCoding(json.getAsJsonObject("type")));
        }
        if (json.has("resource")) {
            res.setResourceElement(this.parseCode(json.get("resource").getAsString()));
        }
        if (json.has("_resource")) {
            this.parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
        }
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("accept")) {
            res.setAcceptElement(this.parseEnumeration(json.get("accept").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
        }
        if (json.has("_accept")) {
            this.parseElementProperties(json.getAsJsonObject("_accept"), res.getAcceptElement());
        }
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("destination")) {
            res.setDestinationElement(this.parseInteger(json.get("destination").getAsLong()));
        }
        if (json.has("_destination")) {
            this.parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
        }
        if (json.has("encodeRequestUrl")) {
            res.setEncodeRequestUrlElement(this.parseBoolean(json.get("encodeRequestUrl").getAsBoolean()));
        }
        if (json.has("_encodeRequestUrl")) {
            this.parseElementProperties(json.getAsJsonObject("_encodeRequestUrl"), res.getEncodeRequestUrlElement());
        }
        if (json.has("origin")) {
            res.setOriginElement(this.parseInteger(json.get("origin").getAsLong()));
        }
        if (json.has("_origin")) {
            this.parseElementProperties(json.getAsJsonObject("_origin"), res.getOriginElement());
        }
        if (json.has("params")) {
            res.setParamsElement(this.parseString(json.get("params").getAsString()));
        }
        if (json.has("_params")) {
            this.parseElementProperties(json.getAsJsonObject("_params"), res.getParamsElement());
        }
        if (json.has("requestHeader")) {
            JsonArray array = json.getAsJsonArray("requestHeader");
            for (int i = 0; i < array.size(); ++i) {
                res.getRequestHeader().add(this.parseTestScriptSetupActionOperationRequestHeaderComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("responseId")) {
            res.setResponseIdElement(this.parseId(json.get("responseId").getAsString()));
        }
        if (json.has("_responseId")) {
            this.parseElementProperties(json.getAsJsonObject("_responseId"), res.getResponseIdElement());
        }
        if (json.has("sourceId")) {
            res.setSourceIdElement(this.parseId(json.get("sourceId").getAsString()));
        }
        if (json.has("_sourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
        }
        if (json.has("targetId")) {
            res.setTargetIdElement(this.parseId(json.get("targetId").getAsString()));
        }
        if (json.has("_targetId")) {
            this.parseElementProperties(json.getAsJsonObject("_targetId"), res.getTargetIdElement());
        }
        if (json.has("url")) {
            res.setUrlElement(this.parseString(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        return res;
    }

    protected TestScript.SetupActionOperationRequestHeaderComponent parseTestScriptSetupActionOperationRequestHeaderComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionOperationRequestHeaderComponent res = new TestScript.SetupActionOperationRequestHeaderComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("field")) {
            res.setFieldElement(this.parseString(json.get("field").getAsString()));
        }
        if (json.has("_field")) {
            this.parseElementProperties(json.getAsJsonObject("_field"), res.getFieldElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected TestScript.SetupActionAssertComponent parseTestScriptSetupActionAssertComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionAssertComponent res = new TestScript.SetupActionAssertComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("label")) {
            res.setLabelElement(this.parseString(json.get("label").getAsString()));
        }
        if (json.has("_label")) {
            this.parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("direction")) {
            res.setDirectionElement(this.parseEnumeration(json.get("direction").getAsString(), TestScript.AssertionDirectionType.NULL, new TestScript.AssertionDirectionTypeEnumFactory()));
        }
        if (json.has("_direction")) {
            this.parseElementProperties(json.getAsJsonObject("_direction"), res.getDirectionElement());
        }
        if (json.has("compareToSourceId")) {
            res.setCompareToSourceIdElement(this.parseString(json.get("compareToSourceId").getAsString()));
        }
        if (json.has("_compareToSourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_compareToSourceId"), res.getCompareToSourceIdElement());
        }
        if (json.has("compareToSourcePath")) {
            res.setCompareToSourcePathElement(this.parseString(json.get("compareToSourcePath").getAsString()));
        }
        if (json.has("_compareToSourcePath")) {
            this.parseElementProperties(json.getAsJsonObject("_compareToSourcePath"), res.getCompareToSourcePathElement());
        }
        if (json.has("contentType")) {
            res.setContentTypeElement(this.parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL, new TestScript.ContentTypeEnumFactory()));
        }
        if (json.has("_contentType")) {
            this.parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
        }
        if (json.has("headerField")) {
            res.setHeaderFieldElement(this.parseString(json.get("headerField").getAsString()));
        }
        if (json.has("_headerField")) {
            this.parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
        }
        if (json.has("minimumId")) {
            res.setMinimumIdElement(this.parseString(json.get("minimumId").getAsString()));
        }
        if (json.has("_minimumId")) {
            this.parseElementProperties(json.getAsJsonObject("_minimumId"), res.getMinimumIdElement());
        }
        if (json.has("navigationLinks")) {
            res.setNavigationLinksElement(this.parseBoolean(json.get("navigationLinks").getAsBoolean()));
        }
        if (json.has("_navigationLinks")) {
            this.parseElementProperties(json.getAsJsonObject("_navigationLinks"), res.getNavigationLinksElement());
        }
        if (json.has("operator")) {
            res.setOperatorElement(this.parseEnumeration(json.get("operator").getAsString(), TestScript.AssertionOperatorType.NULL, new TestScript.AssertionOperatorTypeEnumFactory()));
        }
        if (json.has("_operator")) {
            this.parseElementProperties(json.getAsJsonObject("_operator"), res.getOperatorElement());
        }
        if (json.has("path")) {
            res.setPathElement(this.parseString(json.get("path").getAsString()));
        }
        if (json.has("_path")) {
            this.parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
        }
        if (json.has("resource")) {
            res.setResourceElement(this.parseCode(json.get("resource").getAsString()));
        }
        if (json.has("_resource")) {
            this.parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
        }
        if (json.has("response")) {
            res.setResponseElement(this.parseEnumeration(json.get("response").getAsString(), TestScript.AssertionResponseTypes.NULL, new TestScript.AssertionResponseTypesEnumFactory()));
        }
        if (json.has("_response")) {
            this.parseElementProperties(json.getAsJsonObject("_response"), res.getResponseElement());
        }
        if (json.has("responseCode")) {
            res.setResponseCodeElement(this.parseString(json.get("responseCode").getAsString()));
        }
        if (json.has("_responseCode")) {
            this.parseElementProperties(json.getAsJsonObject("_responseCode"), res.getResponseCodeElement());
        }
        if (json.has("rule")) {
            res.setRule(this.parseTestScriptSetupActionAssertRuleComponent(json.getAsJsonObject("rule"), owner));
        }
        if (json.has("ruleset")) {
            res.setRuleset(this.parseTestScriptSetupActionAssertRulesetComponent(json.getAsJsonObject("ruleset"), owner));
        }
        if (json.has("sourceId")) {
            res.setSourceIdElement(this.parseId(json.get("sourceId").getAsString()));
        }
        if (json.has("_sourceId")) {
            this.parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
        }
        if (json.has("validateProfileId")) {
            res.setValidateProfileIdElement(this.parseId(json.get("validateProfileId").getAsString()));
        }
        if (json.has("_validateProfileId")) {
            this.parseElementProperties(json.getAsJsonObject("_validateProfileId"), res.getValidateProfileIdElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        if (json.has("warningOnly")) {
            res.setWarningOnlyElement(this.parseBoolean(json.get("warningOnly").getAsBoolean()));
        }
        if (json.has("_warningOnly")) {
            this.parseElementProperties(json.getAsJsonObject("_warningOnly"), res.getWarningOnlyElement());
        }
        return res;
    }

    protected TestScript.SetupActionAssertRuleComponent parseTestScriptSetupActionAssertRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionAssertRuleComponent res = new TestScript.SetupActionAssertRuleComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("ruleId")) {
            res.setRuleIdElement(this.parseId(json.get("ruleId").getAsString()));
        }
        if (json.has("_ruleId")) {
            this.parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
        }
        if (json.has("param")) {
            JsonArray array = json.getAsJsonArray("param");
            for (int i = 0; i < array.size(); ++i) {
                res.getParam().add(this.parseTestScriptSetupActionAssertRuleParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.SetupActionAssertRuleParamComponent parseTestScriptSetupActionAssertRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionAssertRuleParamComponent res = new TestScript.SetupActionAssertRuleParamComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected TestScript.SetupActionAssertRulesetComponent parseTestScriptSetupActionAssertRulesetComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionAssertRulesetComponent res = new TestScript.SetupActionAssertRulesetComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("rulesetId")) {
            res.setRulesetIdElement(this.parseId(json.get("rulesetId").getAsString()));
        }
        if (json.has("_rulesetId")) {
            this.parseElementProperties(json.getAsJsonObject("_rulesetId"), res.getRulesetIdElement());
        }
        if (json.has("rule")) {
            JsonArray array = json.getAsJsonArray("rule");
            for (int i = 0; i < array.size(); ++i) {
                res.getRule().add(this.parseTestScriptSetupActionAssertRulesetRuleComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.SetupActionAssertRulesetRuleComponent parseTestScriptSetupActionAssertRulesetRuleComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionAssertRulesetRuleComponent res = new TestScript.SetupActionAssertRulesetRuleComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("ruleId")) {
            res.setRuleIdElement(this.parseId(json.get("ruleId").getAsString()));
        }
        if (json.has("_ruleId")) {
            this.parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
        }
        if (json.has("param")) {
            JsonArray array = json.getAsJsonArray("param");
            for (int i = 0; i < array.size(); ++i) {
                res.getParam().add(this.parseTestScriptSetupActionAssertRulesetRuleParamComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.SetupActionAssertRulesetRuleParamComponent parseTestScriptSetupActionAssertRulesetRuleParamComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.SetupActionAssertRulesetRuleParamComponent res = new TestScript.SetupActionAssertRulesetRuleParamComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected TestScript.TestScriptTestComponent parseTestScriptTestScriptTestComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptTestComponent res = new TestScript.TestScriptTestComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("metadata")) {
            res.setMetadata(this.parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), owner));
        }
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (int i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseTestScriptTestActionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TestActionComponent parseTestScriptTestActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestActionComponent res = new TestScript.TestActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("operation")) {
            res.setOperation(this.parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
        }
        if (json.has("assert")) {
            res.setAssert(this.parseTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
        }
        return res;
    }

    protected TestScript.TestScriptTeardownComponent parseTestScriptTestScriptTeardownComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TestScriptTeardownComponent res = new TestScript.TestScriptTeardownComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("action")) {
            JsonArray array = json.getAsJsonArray("action");
            for (int i = 0; i < array.size(); ++i) {
                res.getAction().add(this.parseTestScriptTeardownActionComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected TestScript.TeardownActionComponent parseTestScriptTeardownActionComponent(JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
        TestScript.TeardownActionComponent res = new TestScript.TeardownActionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("operation")) {
            res.setOperation(this.parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
        }
        return res;
    }

    protected ValueSet parseValueSet(JsonObject json) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet res = new ValueSet();
        this.parseDomainResourceProperties(json, res);
        if (json.has("url")) {
            res.setUrlElement(this.parseUri(json.get("url").getAsString()));
        }
        if (json.has("_url")) {
            this.parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
        }
        if (json.has("identifier")) {
            res.setIdentifier(this.parseIdentifier(json.getAsJsonObject("identifier")));
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("status")) {
            res.setStatusElement(this.parseEnumeration(json.get("status").getAsString(), Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
        }
        if (json.has("_status")) {
            this.parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
        }
        if (json.has("experimental")) {
            res.setExperimentalElement(this.parseBoolean(json.get("experimental").getAsBoolean()));
        }
        if (json.has("_experimental")) {
            this.parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
        }
        if (json.has("publisher")) {
            res.setPublisherElement(this.parseString(json.get("publisher").getAsString()));
        }
        if (json.has("_publisher")) {
            this.parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
        }
        if (json.has("contact")) {
            array = json.getAsJsonArray("contact");
            for (i = 0; i < array.size(); ++i) {
                res.getContact().add(this.parseValueSetValueSetContactComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        if (json.has("date")) {
            res.setDateElement(this.parseDateTime(json.get("date").getAsString()));
        }
        if (json.has("_date")) {
            this.parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
        }
        if (json.has("lockedDate")) {
            res.setLockedDateElement(this.parseDate(json.get("lockedDate").getAsString()));
        }
        if (json.has("_lockedDate")) {
            this.parseElementProperties(json.getAsJsonObject("_lockedDate"), res.getLockedDateElement());
        }
        if (json.has("description")) {
            res.setDescriptionElement(this.parseString(json.get("description").getAsString()));
        }
        if (json.has("_description")) {
            this.parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
        }
        if (json.has("useContext")) {
            array = json.getAsJsonArray("useContext");
            for (i = 0; i < array.size(); ++i) {
                res.getUseContext().add(this.parseCodeableConcept(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("immutable")) {
            res.setImmutableElement(this.parseBoolean(json.get("immutable").getAsBoolean()));
        }
        if (json.has("_immutable")) {
            this.parseElementProperties(json.getAsJsonObject("_immutable"), res.getImmutableElement());
        }
        if (json.has("requirements")) {
            res.setRequirementsElement(this.parseString(json.get("requirements").getAsString()));
        }
        if (json.has("_requirements")) {
            this.parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
        }
        if (json.has("copyright")) {
            res.setCopyrightElement(this.parseString(json.get("copyright").getAsString()));
        }
        if (json.has("_copyright")) {
            this.parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
        }
        if (json.has("extensible")) {
            res.setExtensibleElement(this.parseBoolean(json.get("extensible").getAsBoolean()));
        }
        if (json.has("_extensible")) {
            this.parseElementProperties(json.getAsJsonObject("_extensible"), res.getExtensibleElement());
        }
        if (json.has("compose")) {
            res.setCompose(this.parseValueSetValueSetComposeComponent(json.getAsJsonObject("compose"), res));
        }
        if (json.has("expansion")) {
            res.setExpansion(this.parseValueSetValueSetExpansionComponent(json.getAsJsonObject("expansion"), res));
        }
        return res;
    }

    protected ValueSet.ValueSetContactComponent parseValueSetValueSetContactComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ValueSetContactComponent res = new ValueSet.ValueSetContactComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if (json.has("telecom")) {
            JsonArray array = json.getAsJsonArray("telecom");
            for (int i = 0; i < array.size(); ++i) {
                res.getTelecom().add(this.parseContactPoint(array.get(i).getAsJsonObject()));
            }
        }
        return res;
    }

    protected ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet.ValueSetComposeComponent res = new ValueSet.ValueSetComposeComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("import")) {
            array = json.getAsJsonArray("import");
            for (i = 0; i < array.size(); ++i) {
                res.getImport().add(this.parseUri(array.get(i).getAsString()));
            }
        }
        if (json.has("_import")) {
            array = json.getAsJsonArray("_import");
            for (i = 0; i < array.size(); ++i) {
                if (i == res.getImport().size()) {
                    res.getImport().add(this.parseUri(null));
                }
                if (!(array.get(i) instanceof JsonObject)) continue;
                this.parseElementProperties(array.get(i).getAsJsonObject(), res.getImport().get(i));
            }
        }
        if (json.has("include")) {
            array = json.getAsJsonArray("include");
            for (i = 0; i < array.size(); ++i) {
                res.getInclude().add(this.parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("exclude")) {
            array = json.getAsJsonArray("exclude");
            for (i = 0; i < array.size(); ++i) {
                res.getExclude().add(this.parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet.ConceptSetComponent res = new ValueSet.ConceptSetComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("concept")) {
            array = json.getAsJsonArray("concept");
            for (i = 0; i < array.size(); ++i) {
                res.getConcept().add(this.parseValueSetConceptReferenceComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("filter")) {
            array = json.getAsJsonArray("filter");
            for (i = 0; i < array.size(); ++i) {
                res.getFilter().add(this.parseValueSetConceptSetFilterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptReferenceComponent parseValueSetConceptReferenceComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ConceptReferenceComponent res = new ValueSet.ConceptReferenceComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("designation")) {
            JsonArray array = json.getAsJsonArray("designation");
            for (int i = 0; i < array.size(); ++i) {
                res.getDesignation().add(this.parseValueSetConceptReferenceDesignationComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ConceptReferenceDesignationComponent parseValueSetConceptReferenceDesignationComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ConceptReferenceDesignationComponent res = new ValueSet.ConceptReferenceDesignationComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("language")) {
            res.setLanguageElement(this.parseCode(json.get("language").getAsString()));
        }
        if (json.has("_language")) {
            this.parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
        }
        if (json.has("use")) {
            res.setUse(this.parseCoding(json.getAsJsonObject("use")));
        }
        if (json.has("value")) {
            res.setValueElement(this.parseString(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ConceptSetFilterComponent res = new ValueSet.ConceptSetFilterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("property")) {
            res.setPropertyElement(this.parseCode(json.get("property").getAsString()));
        }
        if (json.has("_property")) {
            this.parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
        }
        if (json.has("op")) {
            res.setOpElement(this.parseEnumeration(json.get("op").getAsString(), ValueSet.FilterOperator.NULL, new ValueSet.FilterOperatorEnumFactory()));
        }
        if (json.has("_op")) {
            this.parseElementProperties(json.getAsJsonObject("_op"), res.getOpElement());
        }
        if (json.has("value")) {
            res.setValueElement(this.parseCode(json.get("value").getAsString()));
        }
        if (json.has("_value")) {
            this.parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
        }
        return res;
    }

    protected ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        int i;
        JsonArray array;
        ValueSet.ValueSetExpansionComponent res = new ValueSet.ValueSetExpansionComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("identifier")) {
            res.setIdentifierElement(this.parseUri(json.get("identifier").getAsString()));
        }
        if (json.has("_identifier")) {
            this.parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
        }
        if (json.has("timestamp")) {
            res.setTimestampElement(this.parseDateTime(json.get("timestamp").getAsString()));
        }
        if (json.has("_timestamp")) {
            this.parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
        }
        if (json.has("total")) {
            res.setTotalElement(this.parseInteger(json.get("total").getAsLong()));
        }
        if (json.has("_total")) {
            this.parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
        }
        if (json.has("offset")) {
            res.setOffsetElement(this.parseInteger(json.get("offset").getAsLong()));
        }
        if (json.has("_offset")) {
            this.parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
        }
        if (json.has("parameter")) {
            array = json.getAsJsonArray("parameter");
            for (i = 0; i < array.size(); ++i) {
                res.getParameter().add(this.parseValueSetValueSetExpansionParameterComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        if (json.has("contains")) {
            array = json.getAsJsonArray("contains");
            for (i = 0; i < array.size(); ++i) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected ValueSet.ValueSetExpansionParameterComponent parseValueSetValueSetExpansionParameterComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        Type value;
        ValueSet.ValueSetExpansionParameterComponent res = new ValueSet.ValueSetExpansionParameterComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("name")) {
            res.setNameElement(this.parseString(json.get("name").getAsString()));
        }
        if (json.has("_name")) {
            this.parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
        }
        if ((value = this.parseType("value", json)) != null) {
            res.setValue(value);
        }
        return res;
    }

    protected ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
        ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("system")) {
            res.setSystemElement(this.parseUri(json.get("system").getAsString()));
        }
        if (json.has("_system")) {
            this.parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
        }
        if (json.has("abstract")) {
            res.setAbstractElement(this.parseBoolean(json.get("abstract").getAsBoolean()));
        }
        if (json.has("_abstract")) {
            this.parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
        }
        if (json.has("version")) {
            res.setVersionElement(this.parseString(json.get("version").getAsString()));
        }
        if (json.has("_version")) {
            this.parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
        }
        if (json.has("code")) {
            res.setCodeElement(this.parseCode(json.get("code").getAsString()));
        }
        if (json.has("_code")) {
            this.parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
        }
        if (json.has("display")) {
            res.setDisplayElement(this.parseString(json.get("display").getAsString()));
        }
        if (json.has("_display")) {
            this.parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
        }
        if (json.has("contains")) {
            JsonArray array = json.getAsJsonArray("contains");
            for (int i = 0; i < array.size(); ++i) {
                res.getContains().add(this.parseValueSetValueSetExpansionContainsComponent(array.get(i).getAsJsonObject(), owner));
            }
        }
        return res;
    }

    protected VisionPrescription parseVisionPrescription(JsonObject json) throws IOException, FHIRFormatError {
        Type reason;
        VisionPrescription res = new VisionPrescription();
        this.parseDomainResourceProperties(json, res);
        if (json.has("identifier")) {
            JsonArray array = json.getAsJsonArray("identifier");
            for (int i = 0; i < array.size(); ++i) {
                res.getIdentifier().add(this.parseIdentifier(array.get(i).getAsJsonObject()));
            }
        }
        if (json.has("dateWritten")) {
            res.setDateWrittenElement(this.parseDateTime(json.get("dateWritten").getAsString()));
        }
        if (json.has("_dateWritten")) {
            this.parseElementProperties(json.getAsJsonObject("_dateWritten"), res.getDateWrittenElement());
        }
        if (json.has("patient")) {
            res.setPatient(this.parseReference(json.getAsJsonObject("patient")));
        }
        if (json.has("prescriber")) {
            res.setPrescriber(this.parseReference(json.getAsJsonObject("prescriber")));
        }
        if (json.has("encounter")) {
            res.setEncounter(this.parseReference(json.getAsJsonObject("encounter")));
        }
        if ((reason = this.parseType("reason", json)) != null) {
            res.setReason(reason);
        }
        if (json.has("dispense")) {
            JsonArray array = json.getAsJsonArray("dispense");
            for (int i = 0; i < array.size(); ++i) {
                res.getDispense().add(this.parseVisionPrescriptionVisionPrescriptionDispenseComponent(array.get(i).getAsJsonObject(), res));
            }
        }
        return res;
    }

    protected VisionPrescription.VisionPrescriptionDispenseComponent parseVisionPrescriptionVisionPrescriptionDispenseComponent(JsonObject json, VisionPrescription owner) throws IOException, FHIRFormatError {
        VisionPrescription.VisionPrescriptionDispenseComponent res = new VisionPrescription.VisionPrescriptionDispenseComponent();
        this.parseBackboneProperties(json, res);
        if (json.has("product")) {
            res.setProduct(this.parseCoding(json.getAsJsonObject("product")));
        }
        if (json.has("eye")) {
            res.setEyeElement(this.parseEnumeration(json.get("eye").getAsString(), VisionPrescription.VisionEyes.NULL, new VisionPrescription.VisionEyesEnumFactory()));
        }
        if (json.has("_eye")) {
            this.parseElementProperties(json.getAsJsonObject("_eye"), res.getEyeElement());
        }
        if (json.has("sphere")) {
            res.setSphereElement(this.parseDecimal(json.get("sphere").getAsBigDecimal()));
        }
        if (json.has("_sphere")) {
            this.parseElementProperties(json.getAsJsonObject("_sphere"), res.getSphereElement());
        }
        if (json.has("cylinder")) {
            res.setCylinderElement(this.parseDecimal(json.get("cylinder").getAsBigDecimal()));
        }
        if (json.has("_cylinder")) {
            this.parseElementProperties(json.getAsJsonObject("_cylinder"), res.getCylinderElement());
        }
        if (json.has("axis")) {
            res.setAxisElement(this.parseInteger(json.get("axis").getAsLong()));
        }
        if (json.has("_axis")) {
            this.parseElementProperties(json.getAsJsonObject("_axis"), res.getAxisElement());
        }
        if (json.has("prism")) {
            res.setPrismElement(this.parseDecimal(json.get("prism").getAsBigDecimal()));
        }
        if (json.has("_prism")) {
            this.parseElementProperties(json.getAsJsonObject("_prism"), res.getPrismElement());
        }
        if (json.has("base")) {
            res.setBaseElement(this.parseEnumeration(json.get("base").getAsString(), VisionPrescription.VisionBase.NULL, new VisionPrescription.VisionBaseEnumFactory()));
        }
        if (json.has("_base")) {
            this.parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
        }
        if (json.has("add")) {
            res.setAddElement(this.parseDecimal(json.get("add").getAsBigDecimal()));
        }
        if (json.has("_add")) {
            this.parseElementProperties(json.getAsJsonObject("_add"), res.getAddElement());
        }
        if (json.has("power")) {
            res.setPowerElement(this.parseDecimal(json.get("power").getAsBigDecimal()));
        }
        if (json.has("_power")) {
            this.parseElementProperties(json.getAsJsonObject("_power"), res.getPowerElement());
        }
        if (json.has("backCurve")) {
            res.setBackCurveElement(this.parseDecimal(json.get("backCurve").getAsBigDecimal()));
        }
        if (json.has("_backCurve")) {
            this.parseElementProperties(json.getAsJsonObject("_backCurve"), res.getBackCurveElement());
        }
        if (json.has("diameter")) {
            res.setDiameterElement(this.parseDecimal(json.get("diameter").getAsBigDecimal()));
        }
        if (json.has("_diameter")) {
            this.parseElementProperties(json.getAsJsonObject("_diameter"), res.getDiameterElement());
        }
        if (json.has("duration")) {
            res.setDuration(this.parseSimpleQuantity(json.getAsJsonObject("duration")));
        }
        if (json.has("color")) {
            res.setColorElement(this.parseString(json.get("color").getAsString()));
        }
        if (json.has("_color")) {
            this.parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
        }
        if (json.has("brand")) {
            res.setBrandElement(this.parseString(json.get("brand").getAsString()));
        }
        if (json.has("_brand")) {
            this.parseElementProperties(json.getAsJsonObject("_brand"), res.getBrandElement());
        }
        if (json.has("notes")) {
            res.setNotesElement(this.parseString(json.get("notes").getAsString()));
        }
        if (json.has("_notes")) {
            this.parseElementProperties(json.getAsJsonObject("_notes"), res.getNotesElement());
        }
        return res;
    }

    @Override
    protected Resource parseResource(JsonObject json) throws IOException, FHIRFormatError {
        if (!json.has("resourceType")) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        String t = json.get("resourceType").getAsString();
        if (Utilities.noString(t)) {
            throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
        }
        if (t.equals("Parameters")) {
            return this.parseParameters(json);
        }
        if (t.equals("Account")) {
            return this.parseAccount(json);
        }
        if (t.equals("AllergyIntolerance")) {
            return this.parseAllergyIntolerance(json);
        }
        if (t.equals("Appointment")) {
            return this.parseAppointment(json);
        }
        if (t.equals("AppointmentResponse")) {
            return this.parseAppointmentResponse(json);
        }
        if (t.equals("AuditEvent")) {
            return this.parseAuditEvent(json);
        }
        if (t.equals("Basic")) {
            return this.parseBasic(json);
        }
        if (t.equals("Binary")) {
            return this.parseBinary(json);
        }
        if (t.equals("BodySite")) {
            return this.parseBodySite(json);
        }
        if (t.equals("Bundle")) {
            return this.parseBundle(json);
        }
        if (t.equals("CarePlan")) {
            return this.parseCarePlan(json);
        }
        if (t.equals("CareTeam")) {
            return this.parseCareTeam(json);
        }
        if (t.equals("Claim")) {
            return this.parseClaim(json);
        }
        if (t.equals("ClaimResponse")) {
            return this.parseClaimResponse(json);
        }
        if (t.equals("ClinicalImpression")) {
            return this.parseClinicalImpression(json);
        }
        if (t.equals("CodeSystem")) {
            return this.parseCodeSystem(json);
        }
        if (t.equals("Communication")) {
            return this.parseCommunication(json);
        }
        if (t.equals("CommunicationRequest")) {
            return this.parseCommunicationRequest(json);
        }
        if (t.equals("CompartmentDefinition")) {
            return this.parseCompartmentDefinition(json);
        }
        if (t.equals("Composition")) {
            return this.parseComposition(json);
        }
        if (t.equals("ConceptMap")) {
            return this.parseConceptMap(json);
        }
        if (t.equals("Condition")) {
            return this.parseCondition(json);
        }
        if (t.equals("Conformance")) {
            return this.parseConformance(json);
        }
        if (t.equals("Contract")) {
            return this.parseContract(json);
        }
        if (t.equals("Coverage")) {
            return this.parseCoverage(json);
        }
        if (t.equals("DataElement")) {
            return this.parseDataElement(json);
        }
        if (t.equals("DecisionSupportRule")) {
            return this.parseDecisionSupportRule(json);
        }
        if (t.equals("DecisionSupportServiceModule")) {
            return this.parseDecisionSupportServiceModule(json);
        }
        if (t.equals("DetectedIssue")) {
            return this.parseDetectedIssue(json);
        }
        if (t.equals("Device")) {
            return this.parseDevice(json);
        }
        if (t.equals("DeviceComponent")) {
            return this.parseDeviceComponent(json);
        }
        if (t.equals("DeviceMetric")) {
            return this.parseDeviceMetric(json);
        }
        if (t.equals("DeviceUseRequest")) {
            return this.parseDeviceUseRequest(json);
        }
        if (t.equals("DeviceUseStatement")) {
            return this.parseDeviceUseStatement(json);
        }
        if (t.equals("DiagnosticOrder")) {
            return this.parseDiagnosticOrder(json);
        }
        if (t.equals("DiagnosticReport")) {
            return this.parseDiagnosticReport(json);
        }
        if (t.equals("DocumentManifest")) {
            return this.parseDocumentManifest(json);
        }
        if (t.equals("DocumentReference")) {
            return this.parseDocumentReference(json);
        }
        if (t.equals("EligibilityRequest")) {
            return this.parseEligibilityRequest(json);
        }
        if (t.equals("EligibilityResponse")) {
            return this.parseEligibilityResponse(json);
        }
        if (t.equals("Encounter")) {
            return this.parseEncounter(json);
        }
        if (t.equals("EnrollmentRequest")) {
            return this.parseEnrollmentRequest(json);
        }
        if (t.equals("EnrollmentResponse")) {
            return this.parseEnrollmentResponse(json);
        }
        if (t.equals("EpisodeOfCare")) {
            return this.parseEpisodeOfCare(json);
        }
        if (t.equals("ExpansionProfile")) {
            return this.parseExpansionProfile(json);
        }
        if (t.equals("ExplanationOfBenefit")) {
            return this.parseExplanationOfBenefit(json);
        }
        if (t.equals("FamilyMemberHistory")) {
            return this.parseFamilyMemberHistory(json);
        }
        if (t.equals("Flag")) {
            return this.parseFlag(json);
        }
        if (t.equals("Goal")) {
            return this.parseGoal(json);
        }
        if (t.equals("Group")) {
            return this.parseGroup(json);
        }
        if (t.equals("GuidanceResponse")) {
            return this.parseGuidanceResponse(json);
        }
        if (t.equals("HealthcareService")) {
            return this.parseHealthcareService(json);
        }
        if (t.equals("ImagingExcerpt")) {
            return this.parseImagingExcerpt(json);
        }
        if (t.equals("ImagingObjectSelection")) {
            return this.parseImagingObjectSelection(json);
        }
        if (t.equals("ImagingStudy")) {
            return this.parseImagingStudy(json);
        }
        if (t.equals("Immunization")) {
            return this.parseImmunization(json);
        }
        if (t.equals("ImmunizationRecommendation")) {
            return this.parseImmunizationRecommendation(json);
        }
        if (t.equals("ImplementationGuide")) {
            return this.parseImplementationGuide(json);
        }
        if (t.equals("Library")) {
            return this.parseLibrary(json);
        }
        if (t.equals("Linkage")) {
            return this.parseLinkage(json);
        }
        if (t.equals("List")) {
            return this.parseListResource(json);
        }
        if (t.equals("Location")) {
            return this.parseLocation(json);
        }
        if (t.equals("Measure")) {
            return this.parseMeasure(json);
        }
        if (t.equals("MeasureReport")) {
            return this.parseMeasureReport(json);
        }
        if (t.equals("Media")) {
            return this.parseMedia(json);
        }
        if (t.equals("Medication")) {
            return this.parseMedication(json);
        }
        if (t.equals("MedicationAdministration")) {
            return this.parseMedicationAdministration(json);
        }
        if (t.equals("MedicationDispense")) {
            return this.parseMedicationDispense(json);
        }
        if (t.equals("MedicationOrder")) {
            return this.parseMedicationOrder(json);
        }
        if (t.equals("MedicationStatement")) {
            return this.parseMedicationStatement(json);
        }
        if (t.equals("MessageHeader")) {
            return this.parseMessageHeader(json);
        }
        if (t.equals("ModuleDefinition")) {
            return this.parseModuleDefinition(json);
        }
        if (t.equals("NamingSystem")) {
            return this.parseNamingSystem(json);
        }
        if (t.equals("NutritionOrder")) {
            return this.parseNutritionOrder(json);
        }
        if (t.equals("Observation")) {
            return this.parseObservation(json);
        }
        if (t.equals("OperationDefinition")) {
            return this.parseOperationDefinition(json);
        }
        if (t.equals("OperationOutcome")) {
            return this.parseOperationOutcome(json);
        }
        if (t.equals("Order")) {
            return this.parseOrder(json);
        }
        if (t.equals("OrderResponse")) {
            return this.parseOrderResponse(json);
        }
        if (t.equals("OrderSet")) {
            return this.parseOrderSet(json);
        }
        if (t.equals("Organization")) {
            return this.parseOrganization(json);
        }
        if (t.equals("Patient")) {
            return this.parsePatient(json);
        }
        if (t.equals("PaymentNotice")) {
            return this.parsePaymentNotice(json);
        }
        if (t.equals("PaymentReconciliation")) {
            return this.parsePaymentReconciliation(json);
        }
        if (t.equals("Person")) {
            return this.parsePerson(json);
        }
        if (t.equals("Practitioner")) {
            return this.parsePractitioner(json);
        }
        if (t.equals("PractitionerRole")) {
            return this.parsePractitionerRole(json);
        }
        if (t.equals("Procedure")) {
            return this.parseProcedure(json);
        }
        if (t.equals("ProcedureRequest")) {
            return this.parseProcedureRequest(json);
        }
        if (t.equals("ProcessRequest")) {
            return this.parseProcessRequest(json);
        }
        if (t.equals("ProcessResponse")) {
            return this.parseProcessResponse(json);
        }
        if (t.equals("Protocol")) {
            return this.parseProtocol(json);
        }
        if (t.equals("Provenance")) {
            return this.parseProvenance(json);
        }
        if (t.equals("Questionnaire")) {
            return this.parseQuestionnaire(json);
        }
        if (t.equals("QuestionnaireResponse")) {
            return this.parseQuestionnaireResponse(json);
        }
        if (t.equals("ReferralRequest")) {
            return this.parseReferralRequest(json);
        }
        if (t.equals("RelatedPerson")) {
            return this.parseRelatedPerson(json);
        }
        if (t.equals("RiskAssessment")) {
            return this.parseRiskAssessment(json);
        }
        if (t.equals("Schedule")) {
            return this.parseSchedule(json);
        }
        if (t.equals("SearchParameter")) {
            return this.parseSearchParameter(json);
        }
        if (t.equals("Sequence")) {
            return this.parseSequence(json);
        }
        if (t.equals("Slot")) {
            return this.parseSlot(json);
        }
        if (t.equals("Specimen")) {
            return this.parseSpecimen(json);
        }
        if (t.equals("StructureDefinition")) {
            return this.parseStructureDefinition(json);
        }
        if (t.equals("StructureMap")) {
            return this.parseStructureMap(json);
        }
        if (t.equals("Subscription")) {
            return this.parseSubscription(json);
        }
        if (t.equals("Substance")) {
            return this.parseSubstance(json);
        }
        if (t.equals("SupplyDelivery")) {
            return this.parseSupplyDelivery(json);
        }
        if (t.equals("SupplyRequest")) {
            return this.parseSupplyRequest(json);
        }
        if (t.equals("Task")) {
            return this.parseTask(json);
        }
        if (t.equals("TestScript")) {
            return this.parseTestScript(json);
        }
        if (t.equals("ValueSet")) {
            return this.parseValueSet(json);
        }
        if (t.equals("VisionPrescription")) {
            return this.parseVisionPrescription(json);
        }
        if (t.equals("Binary")) {
            return this.parseBinary(json);
        }
        throw new FHIRFormatError("Unknown.Unrecognised resource type '" + t + "' (in property 'resourceType')");
    }

    @Override
    protected Type parseType(String prefix, JsonObject json) throws IOException, FHIRFormatError {
        if (json.has(prefix + "Period")) {
            return this.parsePeriod(json.getAsJsonObject(prefix + "Period"));
        }
        if (json.has(prefix + "Coding")) {
            return this.parseCoding(json.getAsJsonObject(prefix + "Coding"));
        }
        if (json.has(prefix + "Range")) {
            return this.parseRange(json.getAsJsonObject(prefix + "Range"));
        }
        if (json.has(prefix + "Quantity")) {
            return this.parseQuantity(json.getAsJsonObject(prefix + "Quantity"));
        }
        if (json.has(prefix + "Attachment")) {
            return this.parseAttachment(json.getAsJsonObject(prefix + "Attachment"));
        }
        if (json.has(prefix + "Ratio")) {
            return this.parseRatio(json.getAsJsonObject(prefix + "Ratio"));
        }
        if (json.has(prefix + "Annotation")) {
            return this.parseAnnotation(json.getAsJsonObject(prefix + "Annotation"));
        }
        if (json.has(prefix + "SampledData")) {
            return this.parseSampledData(json.getAsJsonObject(prefix + "SampledData"));
        }
        if (json.has(prefix + "Reference")) {
            return this.parseReference(json.getAsJsonObject(prefix + "Reference"));
        }
        if (json.has(prefix + "CodeableConcept")) {
            return this.parseCodeableConcept(json.getAsJsonObject(prefix + "CodeableConcept"));
        }
        if (json.has(prefix + "Identifier")) {
            return this.parseIdentifier(json.getAsJsonObject(prefix + "Identifier"));
        }
        if (json.has(prefix + "Signature")) {
            return this.parseSignature(json.getAsJsonObject(prefix + "Signature"));
        }
        if (json.has(prefix + "Age")) {
            return this.parseAge(json.getAsJsonObject(prefix + "Age"));
        }
        if (json.has(prefix + "Count")) {
            return this.parseCount(json.getAsJsonObject(prefix + "Count"));
        }
        if (json.has(prefix + "Money")) {
            return this.parseMoney(json.getAsJsonObject(prefix + "Money"));
        }
        if (json.has(prefix + "Distance")) {
            return this.parseDistance(json.getAsJsonObject(prefix + "Distance"));
        }
        if (json.has(prefix + "Duration")) {
            return this.parseDuration(json.getAsJsonObject(prefix + "Duration"));
        }
        if (json.has(prefix + "SimpleQuantity")) {
            return this.parseSimpleQuantity(json.getAsJsonObject(prefix + "SimpleQuantity"));
        }
        if (json.has(prefix + "TriggerDefinition")) {
            return this.parseTriggerDefinition(json.getAsJsonObject(prefix + "TriggerDefinition"));
        }
        if (json.has(prefix + "ElementDefinition")) {
            return this.parseElementDefinition(json.getAsJsonObject(prefix + "ElementDefinition"));
        }
        if (json.has(prefix + "Timing")) {
            return this.parseTiming(json.getAsJsonObject(prefix + "Timing"));
        }
        if (json.has(prefix + "ModuleMetadata")) {
            return this.parseModuleMetadata(json.getAsJsonObject(prefix + "ModuleMetadata"));
        }
        if (json.has(prefix + "ActionDefinition")) {
            return this.parseActionDefinition(json.getAsJsonObject(prefix + "ActionDefinition"));
        }
        if (json.has(prefix + "Address")) {
            return this.parseAddress(json.getAsJsonObject(prefix + "Address"));
        }
        if (json.has(prefix + "HumanName")) {
            return this.parseHumanName(json.getAsJsonObject(prefix + "HumanName"));
        }
        if (json.has(prefix + "DataRequirement")) {
            return this.parseDataRequirement(json.getAsJsonObject(prefix + "DataRequirement"));
        }
        if (json.has(prefix + "Meta")) {
            return this.parseMeta(json.getAsJsonObject(prefix + "Meta"));
        }
        if (json.has(prefix + "ParameterDefinition")) {
            return this.parseParameterDefinition(json.getAsJsonObject(prefix + "ParameterDefinition"));
        }
        if (json.has(prefix + "ContactPoint")) {
            return this.parseContactPoint(json.getAsJsonObject(prefix + "ContactPoint"));
        }
        if (json.has(prefix + "Markdown") || json.has("_" + prefix + "Markdown")) {
            MarkdownType t;
            MarkdownType markdownType = t = json.has(prefix + "Markdown") ? this.parseMarkdown(json.get(prefix + "Markdown").getAsString()) : new MarkdownType();
            if (json.has("_" + prefix + "Markdown")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Markdown"), t);
            }
            return t;
        }
        if (json.has(prefix + "Integer") || json.has("_" + prefix + "Integer")) {
            IntegerType t;
            IntegerType integerType = t = json.has(prefix + "Integer") ? this.parseInteger(json.get(prefix + "Integer").getAsLong()) : new IntegerType();
            if (json.has("_" + prefix + "Integer")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Integer"), t);
            }
            return t;
        }
        if (json.has(prefix + "DateTime") || json.has("_" + prefix + "DateTime")) {
            DateTimeType t;
            DateTimeType dateTimeType = t = json.has(prefix + "DateTime") ? this.parseDateTime(json.get(prefix + "DateTime").getAsString()) : new DateTimeType();
            if (json.has("_" + prefix + "DateTime")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "DateTime"), t);
            }
            return t;
        }
        if (json.has(prefix + "UnsignedInt") || json.has("_" + prefix + "UnsignedInt")) {
            UnsignedIntType t;
            UnsignedIntType unsignedIntType = t = json.has(prefix + "UnsignedInt") ? this.parseUnsignedInt(json.get(prefix + "UnsignedInt").getAsString()) : new UnsignedIntType();
            if (json.has("_" + prefix + "UnsignedInt")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "UnsignedInt"), t);
            }
            return t;
        }
        if (json.has(prefix + "Code") || json.has("_" + prefix + "Code")) {
            CodeType t;
            CodeType codeType = t = json.has(prefix + "Code") ? this.parseCode(json.get(prefix + "Code").getAsString()) : new CodeType();
            if (json.has("_" + prefix + "Code")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Code"), t);
            }
            return t;
        }
        if (json.has(prefix + "Date") || json.has("_" + prefix + "Date")) {
            DateType t;
            DateType dateType = t = json.has(prefix + "Date") ? this.parseDate(json.get(prefix + "Date").getAsString()) : new DateType();
            if (json.has("_" + prefix + "Date")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Date"), t);
            }
            return t;
        }
        if (json.has(prefix + "Decimal") || json.has("_" + prefix + "Decimal")) {
            DecimalType t;
            DecimalType decimalType = t = json.has(prefix + "Decimal") ? this.parseDecimal(json.get(prefix + "Decimal").getAsBigDecimal()) : new DecimalType();
            if (json.has("_" + prefix + "Decimal")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Decimal"), t);
            }
            return t;
        }
        if (json.has(prefix + "Uri") || json.has("_" + prefix + "Uri")) {
            UriType t;
            UriType uriType = t = json.has(prefix + "Uri") ? this.parseUri(json.get(prefix + "Uri").getAsString()) : new UriType();
            if (json.has("_" + prefix + "Uri")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Uri"), t);
            }
            return t;
        }
        if (json.has(prefix + "Id") || json.has("_" + prefix + "Id")) {
            IdType t;
            IdType idType = t = json.has(prefix + "Id") ? this.parseId(json.get(prefix + "Id").getAsString()) : new IdType();
            if (json.has("_" + prefix + "Id")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Id"), (Element)t);
            }
            return t;
        }
        if (json.has(prefix + "Base64Binary") || json.has("_" + prefix + "Base64Binary")) {
            Base64BinaryType t;
            Base64BinaryType base64BinaryType = t = json.has(prefix + "Base64Binary") ? this.parseBase64Binary(json.get(prefix + "Base64Binary").getAsString()) : new Base64BinaryType();
            if (json.has("_" + prefix + "Base64Binary")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Base64Binary"), t);
            }
            return t;
        }
        if (json.has(prefix + "Time") || json.has("_" + prefix + "Time")) {
            TimeType t;
            TimeType timeType = t = json.has(prefix + "Time") ? this.parseTime(json.get(prefix + "Time").getAsString()) : new TimeType();
            if (json.has("_" + prefix + "Time")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Time"), t);
            }
            return t;
        }
        if (json.has(prefix + "Oid") || json.has("_" + prefix + "Oid")) {
            OidType t;
            OidType oidType = t = json.has(prefix + "Oid") ? this.parseOid(json.get(prefix + "Oid").getAsString()) : new OidType();
            if (json.has("_" + prefix + "Oid")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Oid"), t);
            }
            return t;
        }
        if (json.has(prefix + "PositiveInt") || json.has("_" + prefix + "PositiveInt")) {
            PositiveIntType t;
            PositiveIntType positiveIntType = t = json.has(prefix + "PositiveInt") ? this.parsePositiveInt(json.get(prefix + "PositiveInt").getAsString()) : new PositiveIntType();
            if (json.has("_" + prefix + "PositiveInt")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "PositiveInt"), t);
            }
            return t;
        }
        if (json.has(prefix + "String") || json.has("_" + prefix + "String")) {
            StringType t;
            StringType stringType = t = json.has(prefix + "String") ? this.parseString(json.get(prefix + "String").getAsString()) : new StringType();
            if (json.has("_" + prefix + "String")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "String"), t);
            }
            return t;
        }
        if (json.has(prefix + "Boolean") || json.has("_" + prefix + "Boolean")) {
            BooleanType t;
            BooleanType booleanType = t = json.has(prefix + "Boolean") ? this.parseBoolean(json.get(prefix + "Boolean").getAsBoolean()) : new BooleanType();
            if (json.has("_" + prefix + "Boolean")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Boolean"), t);
            }
            return t;
        }
        if (json.has(prefix + "Uuid") || json.has("_" + prefix + "Uuid")) {
            UuidType t;
            UuidType uuidType = t = json.has(prefix + "Uuid") ? this.parseUuid(json.get(prefix + "Uuid").getAsString()) : new UuidType();
            if (json.has("_" + prefix + "Uuid")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Uuid"), t);
            }
            return t;
        }
        if (json.has(prefix + "Instant") || json.has("_" + prefix + "Instant")) {
            InstantType t;
            InstantType instantType = t = json.has(prefix + "Instant") ? this.parseInstant(json.get(prefix + "Instant").getAsString()) : new InstantType();
            if (json.has("_" + prefix + "Instant")) {
                this.parseElementProperties(json.getAsJsonObject("_" + prefix + "Instant"), t);
            }
            return t;
        }
        return null;
    }

    @Override
    protected Type parseType(JsonObject json, String type) throws IOException, FHIRFormatError {
        if (type.equals("Period")) {
            return this.parsePeriod(json);
        }
        if (type.equals("Coding")) {
            return this.parseCoding(json);
        }
        if (type.equals("Range")) {
            return this.parseRange(json);
        }
        if (type.equals("Quantity")) {
            return this.parseQuantity(json);
        }
        if (type.equals("Attachment")) {
            return this.parseAttachment(json);
        }
        if (type.equals("Ratio")) {
            return this.parseRatio(json);
        }
        if (type.equals("Annotation")) {
            return this.parseAnnotation(json);
        }
        if (type.equals("SampledData")) {
            return this.parseSampledData(json);
        }
        if (type.equals("Reference")) {
            return this.parseReference(json);
        }
        if (type.equals("CodeableConcept")) {
            return this.parseCodeableConcept(json);
        }
        if (type.equals("Identifier")) {
            return this.parseIdentifier(json);
        }
        if (type.equals("Signature")) {
            return this.parseSignature(json);
        }
        if (type.equals("Age")) {
            return this.parseAge(json);
        }
        if (type.equals("Count")) {
            return this.parseCount(json);
        }
        if (type.equals("Money")) {
            return this.parseMoney(json);
        }
        if (type.equals("Distance")) {
            return this.parseDistance(json);
        }
        if (type.equals("Duration")) {
            return this.parseDuration(json);
        }
        if (type.equals("SimpleQuantity")) {
            return this.parseSimpleQuantity(json);
        }
        if (type.equals("TriggerDefinition")) {
            return this.parseTriggerDefinition(json);
        }
        if (type.equals("ElementDefinition")) {
            return this.parseElementDefinition(json);
        }
        if (type.equals("Timing")) {
            return this.parseTiming(json);
        }
        if (type.equals("ModuleMetadata")) {
            return this.parseModuleMetadata(json);
        }
        if (type.equals("ActionDefinition")) {
            return this.parseActionDefinition(json);
        }
        if (type.equals("Address")) {
            return this.parseAddress(json);
        }
        if (type.equals("HumanName")) {
            return this.parseHumanName(json);
        }
        if (type.equals("DataRequirement")) {
            return this.parseDataRequirement(json);
        }
        if (type.equals("Meta")) {
            return this.parseMeta(json);
        }
        if (type.equals("ParameterDefinition")) {
            return this.parseParameterDefinition(json);
        }
        if (type.equals("ContactPoint")) {
            return this.parseContactPoint(json);
        }
        throw new FHIRFormatError("Unknown Type " + type);
    }

    @Override
    protected boolean hasTypeName(JsonObject json, String prefix) {
        if (json.has(prefix + "Period")) {
            return true;
        }
        if (json.has(prefix + "Coding")) {
            return true;
        }
        if (json.has(prefix + "Range")) {
            return true;
        }
        if (json.has(prefix + "Quantity")) {
            return true;
        }
        if (json.has(prefix + "Attachment")) {
            return true;
        }
        if (json.has(prefix + "Ratio")) {
            return true;
        }
        if (json.has(prefix + "Annotation")) {
            return true;
        }
        if (json.has(prefix + "SampledData")) {
            return true;
        }
        if (json.has(prefix + "Reference")) {
            return true;
        }
        if (json.has(prefix + "CodeableConcept")) {
            return true;
        }
        if (json.has(prefix + "Identifier")) {
            return true;
        }
        if (json.has(prefix + "Signature")) {
            return true;
        }
        if (json.has(prefix + "Age")) {
            return true;
        }
        if (json.has(prefix + "Count")) {
            return true;
        }
        if (json.has(prefix + "Money")) {
            return true;
        }
        if (json.has(prefix + "Distance")) {
            return true;
        }
        if (json.has(prefix + "Duration")) {
            return true;
        }
        if (json.has(prefix + "SimpleQuantity")) {
            return true;
        }
        if (json.has(prefix + "TriggerDefinition")) {
            return true;
        }
        if (json.has(prefix + "ElementDefinition")) {
            return true;
        }
        if (json.has(prefix + "Timing")) {
            return true;
        }
        if (json.has(prefix + "ModuleMetadata")) {
            return true;
        }
        if (json.has(prefix + "ActionDefinition")) {
            return true;
        }
        if (json.has(prefix + "Address")) {
            return true;
        }
        if (json.has(prefix + "HumanName")) {
            return true;
        }
        if (json.has(prefix + "DataRequirement")) {
            return true;
        }
        if (json.has(prefix + "Meta")) {
            return true;
        }
        if (json.has(prefix + "ParameterDefinition")) {
            return true;
        }
        if (json.has(prefix + "ContactPoint")) {
            return true;
        }
        if (json.has(prefix + "Parameters")) {
            return true;
        }
        if (json.has(prefix + "Account")) {
            return true;
        }
        if (json.has(prefix + "AllergyIntolerance")) {
            return true;
        }
        if (json.has(prefix + "Appointment")) {
            return true;
        }
        if (json.has(prefix + "AppointmentResponse")) {
            return true;
        }
        if (json.has(prefix + "AuditEvent")) {
            return true;
        }
        if (json.has(prefix + "Basic")) {
            return true;
        }
        if (json.has(prefix + "Binary")) {
            return true;
        }
        if (json.has(prefix + "BodySite")) {
            return true;
        }
        if (json.has(prefix + "Bundle")) {
            return true;
        }
        if (json.has(prefix + "CarePlan")) {
            return true;
        }
        if (json.has(prefix + "CareTeam")) {
            return true;
        }
        if (json.has(prefix + "Claim")) {
            return true;
        }
        if (json.has(prefix + "ClaimResponse")) {
            return true;
        }
        if (json.has(prefix + "ClinicalImpression")) {
            return true;
        }
        if (json.has(prefix + "CodeSystem")) {
            return true;
        }
        if (json.has(prefix + "Communication")) {
            return true;
        }
        if (json.has(prefix + "CommunicationRequest")) {
            return true;
        }
        if (json.has(prefix + "CompartmentDefinition")) {
            return true;
        }
        if (json.has(prefix + "Composition")) {
            return true;
        }
        if (json.has(prefix + "ConceptMap")) {
            return true;
        }
        if (json.has(prefix + "Condition")) {
            return true;
        }
        if (json.has(prefix + "Conformance")) {
            return true;
        }
        if (json.has(prefix + "Contract")) {
            return true;
        }
        if (json.has(prefix + "Coverage")) {
            return true;
        }
        if (json.has(prefix + "DataElement")) {
            return true;
        }
        if (json.has(prefix + "DecisionSupportRule")) {
            return true;
        }
        if (json.has(prefix + "DecisionSupportServiceModule")) {
            return true;
        }
        if (json.has(prefix + "DetectedIssue")) {
            return true;
        }
        if (json.has(prefix + "Device")) {
            return true;
        }
        if (json.has(prefix + "DeviceComponent")) {
            return true;
        }
        if (json.has(prefix + "DeviceMetric")) {
            return true;
        }
        if (json.has(prefix + "DeviceUseRequest")) {
            return true;
        }
        if (json.has(prefix + "DeviceUseStatement")) {
            return true;
        }
        if (json.has(prefix + "DiagnosticOrder")) {
            return true;
        }
        if (json.has(prefix + "DiagnosticReport")) {
            return true;
        }
        if (json.has(prefix + "DocumentManifest")) {
            return true;
        }
        if (json.has(prefix + "DocumentReference")) {
            return true;
        }
        if (json.has(prefix + "EligibilityRequest")) {
            return true;
        }
        if (json.has(prefix + "EligibilityResponse")) {
            return true;
        }
        if (json.has(prefix + "Encounter")) {
            return true;
        }
        if (json.has(prefix + "EnrollmentRequest")) {
            return true;
        }
        if (json.has(prefix + "EnrollmentResponse")) {
            return true;
        }
        if (json.has(prefix + "EpisodeOfCare")) {
            return true;
        }
        if (json.has(prefix + "ExpansionProfile")) {
            return true;
        }
        if (json.has(prefix + "ExplanationOfBenefit")) {
            return true;
        }
        if (json.has(prefix + "FamilyMemberHistory")) {
            return true;
        }
        if (json.has(prefix + "Flag")) {
            return true;
        }
        if (json.has(prefix + "Goal")) {
            return true;
        }
        if (json.has(prefix + "Group")) {
            return true;
        }
        if (json.has(prefix + "GuidanceResponse")) {
            return true;
        }
        if (json.has(prefix + "HealthcareService")) {
            return true;
        }
        if (json.has(prefix + "ImagingExcerpt")) {
            return true;
        }
        if (json.has(prefix + "ImagingObjectSelection")) {
            return true;
        }
        if (json.has(prefix + "ImagingStudy")) {
            return true;
        }
        if (json.has(prefix + "Immunization")) {
            return true;
        }
        if (json.has(prefix + "ImmunizationRecommendation")) {
            return true;
        }
        if (json.has(prefix + "ImplementationGuide")) {
            return true;
        }
        if (json.has(prefix + "Library")) {
            return true;
        }
        if (json.has(prefix + "Linkage")) {
            return true;
        }
        if (json.has(prefix + "List")) {
            return true;
        }
        if (json.has(prefix + "Location")) {
            return true;
        }
        if (json.has(prefix + "Measure")) {
            return true;
        }
        if (json.has(prefix + "MeasureReport")) {
            return true;
        }
        if (json.has(prefix + "Media")) {
            return true;
        }
        if (json.has(prefix + "Medication")) {
            return true;
        }
        if (json.has(prefix + "MedicationAdministration")) {
            return true;
        }
        if (json.has(prefix + "MedicationDispense")) {
            return true;
        }
        if (json.has(prefix + "MedicationOrder")) {
            return true;
        }
        if (json.has(prefix + "MedicationStatement")) {
            return true;
        }
        if (json.has(prefix + "MessageHeader")) {
            return true;
        }
        if (json.has(prefix + "ModuleDefinition")) {
            return true;
        }
        if (json.has(prefix + "NamingSystem")) {
            return true;
        }
        if (json.has(prefix + "NutritionOrder")) {
            return true;
        }
        if (json.has(prefix + "Observation")) {
            return true;
        }
        if (json.has(prefix + "OperationDefinition")) {
            return true;
        }
        if (json.has(prefix + "OperationOutcome")) {
            return true;
        }
        if (json.has(prefix + "Order")) {
            return true;
        }
        if (json.has(prefix + "OrderResponse")) {
            return true;
        }
        if (json.has(prefix + "OrderSet")) {
            return true;
        }
        if (json.has(prefix + "Organization")) {
            return true;
        }
        if (json.has(prefix + "Patient")) {
            return true;
        }
        if (json.has(prefix + "PaymentNotice")) {
            return true;
        }
        if (json.has(prefix + "PaymentReconciliation")) {
            return true;
        }
        if (json.has(prefix + "Person")) {
            return true;
        }
        if (json.has(prefix + "Practitioner")) {
            return true;
        }
        if (json.has(prefix + "PractitionerRole")) {
            return true;
        }
        if (json.has(prefix + "Procedure")) {
            return true;
        }
        if (json.has(prefix + "ProcedureRequest")) {
            return true;
        }
        if (json.has(prefix + "ProcessRequest")) {
            return true;
        }
        if (json.has(prefix + "ProcessResponse")) {
            return true;
        }
        if (json.has(prefix + "Protocol")) {
            return true;
        }
        if (json.has(prefix + "Provenance")) {
            return true;
        }
        if (json.has(prefix + "Questionnaire")) {
            return true;
        }
        if (json.has(prefix + "QuestionnaireResponse")) {
            return true;
        }
        if (json.has(prefix + "ReferralRequest")) {
            return true;
        }
        if (json.has(prefix + "RelatedPerson")) {
            return true;
        }
        if (json.has(prefix + "RiskAssessment")) {
            return true;
        }
        if (json.has(prefix + "Schedule")) {
            return true;
        }
        if (json.has(prefix + "SearchParameter")) {
            return true;
        }
        if (json.has(prefix + "Sequence")) {
            return true;
        }
        if (json.has(prefix + "Slot")) {
            return true;
        }
        if (json.has(prefix + "Specimen")) {
            return true;
        }
        if (json.has(prefix + "StructureDefinition")) {
            return true;
        }
        if (json.has(prefix + "StructureMap")) {
            return true;
        }
        if (json.has(prefix + "Subscription")) {
            return true;
        }
        if (json.has(prefix + "Substance")) {
            return true;
        }
        if (json.has(prefix + "SupplyDelivery")) {
            return true;
        }
        if (json.has(prefix + "SupplyRequest")) {
            return true;
        }
        if (json.has(prefix + "Task")) {
            return true;
        }
        if (json.has(prefix + "TestScript")) {
            return true;
        }
        if (json.has(prefix + "ValueSet")) {
            return true;
        }
        if (json.has(prefix + "VisionPrescription")) {
            return true;
        }
        if (json.has(prefix + "Markdown") || json.has("_" + prefix + "Markdown")) {
            return true;
        }
        if (json.has(prefix + "Integer") || json.has("_" + prefix + "Integer")) {
            return true;
        }
        if (json.has(prefix + "DateTime") || json.has("_" + prefix + "DateTime")) {
            return true;
        }
        if (json.has(prefix + "UnsignedInt") || json.has("_" + prefix + "UnsignedInt")) {
            return true;
        }
        if (json.has(prefix + "Code") || json.has("_" + prefix + "Code")) {
            return true;
        }
        if (json.has(prefix + "Date") || json.has("_" + prefix + "Date")) {
            return true;
        }
        if (json.has(prefix + "Decimal") || json.has("_" + prefix + "Decimal")) {
            return true;
        }
        if (json.has(prefix + "Uri") || json.has("_" + prefix + "Uri")) {
            return true;
        }
        if (json.has(prefix + "Id") || json.has("_" + prefix + "Id")) {
            return true;
        }
        if (json.has(prefix + "Base64Binary") || json.has("_" + prefix + "Base64Binary")) {
            return true;
        }
        if (json.has(prefix + "Time") || json.has("_" + prefix + "Time")) {
            return true;
        }
        if (json.has(prefix + "Oid") || json.has("_" + prefix + "Oid")) {
            return true;
        }
        if (json.has(prefix + "PositiveInt") || json.has("_" + prefix + "PositiveInt")) {
            return true;
        }
        if (json.has(prefix + "String") || json.has("_" + prefix + "String")) {
            return true;
        }
        if (json.has(prefix + "Boolean") || json.has("_" + prefix + "Boolean")) {
            return true;
        }
        if (json.has(prefix + "Uuid") || json.has("_" + prefix + "Uuid")) {
            return true;
        }
        return json.has(prefix + "Instant") || json.has("_" + prefix + "Instant");
    }

    protected void composeElement(Element element) throws IOException {
        if (element.hasId()) {
            this.prop("id", element.getId());
        }
        if (this.makeComments(element)) {
            this.openArray("fhir_comments");
            for (String s2 : element.getFormatCommentsPre()) {
                this.prop(null, s2);
            }
            for (String s2 : element.getFormatCommentsPost()) {
                this.prop(null, s2);
            }
            this.closeArray();
        }
        if (element.hasExtension()) {
            this.openArray("extension");
            for (Extension e : element.getExtension()) {
                this.composeExtension(null, e);
            }
            this.closeArray();
        }
    }

    protected void composeBackbone(BackboneElement element) throws IOException {
        this.composeElement(element);
        if (element.hasModifierExtension()) {
            this.openArray("modifierExtension");
            for (Extension e : element.getModifierExtension()) {
                this.composeExtension(null, e);
            }
            this.closeArray();
        }
    }

    protected <E extends Enum<E>> void composeEnumerationCore(String name, Enumeration<E> value, EnumFactory e, boolean inArray) throws IOException {
        if (value != null && value.getValue() != null) {
            this.prop(name, e.toCode((Enum)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected <E extends Enum<E>> void composeEnumerationExtras(String name, Enumeration<E> value, EnumFactory e, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeMarkdownCore(String name, MarkdownType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeMarkdownExtras(String name, MarkdownType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIntegerCore(String name, IntegerType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (int)((Integer)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIntegerExtras(String name, IntegerType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateTimeCore(String name, DateTimeType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateTimeExtras(String name, DateTimeType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUnsignedIntCore(String name, UnsignedIntType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (int)((Integer)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUnsignedIntExtras(String name, UnsignedIntType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeCodeCore(String name, CodeType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeCodeExtras(String name, CodeType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateCore(String name, DateType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDateExtras(String name, DateType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDecimalCore(String name, DecimalType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (BigDecimal)value.getValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeDecimalExtras(String name, DecimalType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUriCore(String name, UriType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUriExtras(String name, UriType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIdCore(String name, IdType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString(value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeIdExtras(String name, IdType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBase64BinaryCore(String name, Base64BinaryType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, JsonParser.toString((byte[])value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBase64BinaryExtras(String name, Base64BinaryType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeTimeCore(String name, TimeType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeTimeExtras(String name, TimeType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeOidCore(String name, OidType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeOidExtras(String name, OidType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composePositiveIntCore(String name, PositiveIntType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (int)((Integer)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composePositiveIntExtras(String name, PositiveIntType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    @Override
    protected void composeStringCore(String name, StringType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    @Override
    protected void composeStringExtras(String name, StringType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBooleanCore(String name, BooleanType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, (Boolean)value.getValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeBooleanExtras(String name, BooleanType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUuidCore(String name, UuidType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, this.toString((String)value.getValue()));
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeUuidExtras(String name, UuidType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeInstantCore(String name, InstantType value, boolean inArray) throws IOException {
        if (value != null && value.hasValue()) {
            this.prop(name, value.asStringValue());
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeInstantExtras(String name, InstantType value, boolean inArray) throws IOException {
        if (value != null && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || this.makeComments(value))) {
            this.open(inArray ? null : "_" + name);
            this.composeElement(value);
            this.close();
        } else if (inArray) {
            this.writeNull(name);
        }
    }

    protected void composeExtension(String name, Extension element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeExtensionInner(element);
            this.close();
        }
    }

    protected void composeExtensionInner(Extension element) throws IOException {
        this.composeElement(element);
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasValue()) {
            this.composeType("value", element.getValue());
        }
    }

    protected void composeNarrative(String name, Narrative element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeNarrativeInner(element);
            this.close();
        }
    }

    protected void composeNarrativeInner(Narrative element) throws IOException {
        this.composeElement(element);
        if (element.hasStatusElement()) {
            this.composeEnumerationCore("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory(), false);
            this.composeEnumerationExtras("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory(), false);
        }
        if (element.hasDiv()) {
            XhtmlNode node = element.getDiv();
            if (node.getNsDecl() == null) {
                node.attribute("xmlns", "http://www.w3.org/1999/xhtml");
            }
            this.composeXhtml("div", node);
        }
    }

    protected void composePeriod(String name, Period element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composePeriodInner(element);
            this.close();
        }
    }

    protected void composePeriodInner(Period element) throws IOException {
        this.composeElement(element);
        if (element.hasStartElement()) {
            this.composeDateTimeCore("start", element.getStartElement(), false);
            this.composeDateTimeExtras("start", element.getStartElement(), false);
        }
        if (element.hasEndElement()) {
            this.composeDateTimeCore("end", element.getEndElement(), false);
            this.composeDateTimeExtras("end", element.getEndElement(), false);
        }
    }

    protected void composeCoding(String name, Coding element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeCodingInner(element);
            this.close();
        }
    }

    protected void composeCodingInner(Coding element) throws IOException {
        this.composeElement(element);
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasVersionElement()) {
            this.composeStringCore("version", element.getVersionElement(), false);
            this.composeStringExtras("version", element.getVersionElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
        if (element.hasDisplayElement()) {
            this.composeStringCore("display", element.getDisplayElement(), false);
            this.composeStringExtras("display", element.getDisplayElement(), false);
        }
        if (element.hasUserSelectedElement()) {
            this.composeBooleanCore("userSelected", element.getUserSelectedElement(), false);
            this.composeBooleanExtras("userSelected", element.getUserSelectedElement(), false);
        }
    }

    protected void composeRange(String name, Range element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeRangeInner(element);
            this.close();
        }
    }

    protected void composeRangeInner(Range element) throws IOException {
        this.composeElement(element);
        if (element.hasLow()) {
            this.composeSimpleQuantity("low", element.getLow());
        }
        if (element.hasHigh()) {
            this.composeSimpleQuantity("high", element.getHigh());
        }
    }

    protected void composeQuantity(String name, Quantity element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeQuantityInner(element);
            this.close();
        }
    }

    protected void composeQuantityInner(Quantity element) throws IOException {
        this.composeElement(element);
        if (element.hasValueElement()) {
            this.composeDecimalCore("value", element.getValueElement(), false);
            this.composeDecimalExtras("value", element.getValueElement(), false);
        }
        if (element.hasComparatorElement()) {
            this.composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
            this.composeEnumerationExtras("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(), false);
        }
        if (element.hasUnitElement()) {
            this.composeStringCore("unit", element.getUnitElement(), false);
            this.composeStringExtras("unit", element.getUnitElement(), false);
        }
        if (element.hasSystemElement()) {
            this.composeUriCore("system", element.getSystemElement(), false);
            this.composeUriExtras("system", element.getSystemElement(), false);
        }
        if (element.hasCodeElement()) {
            this.composeCodeCore("code", element.getCodeElement(), false);
            this.composeCodeExtras("code", element.getCodeElement(), false);
        }
    }

    protected void composeAttachment(String name, Attachment element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAttachmentInner(element);
            this.close();
        }
    }

    protected void composeAttachmentInner(Attachment element) throws IOException {
        this.composeElement(element);
        if (element.hasContentTypeElement()) {
            this.composeCodeCore("contentType", element.getContentTypeElement(), false);
            this.composeCodeExtras("contentType", element.getContentTypeElement(), false);
        }
        if (element.hasLanguageElement()) {
            this.composeCodeCore("language", element.getLanguageElement(), false);
            this.composeCodeExtras("language", element.getLanguageElement(), false);
        }
        if (element.hasDataElement()) {
            this.composeBase64BinaryCore("data", element.getDataElement(), false);
            this.composeBase64BinaryExtras("data", element.getDataElement(), false);
        }
        if (element.hasUrlElement()) {
            this.composeUriCore("url", element.getUrlElement(), false);
            this.composeUriExtras("url", element.getUrlElement(), false);
        }
        if (element.hasSizeElement()) {
            this.composeUnsignedIntCore("size", element.getSizeElement(), false);
            this.composeUnsignedIntExtras("size", element.getSizeElement(), false);
        }
        if (element.hasHashElement()) {
            this.composeBase64BinaryCore("hash", element.getHashElement(), false);
            this.composeBase64BinaryExtras("hash", element.getHashElement(), false);
        }
        if (element.hasTitleElement()) {
            this.composeStringCore("title", element.getTitleElement(), false);
            this.composeStringExtras("title", element.getTitleElement(), false);
        }
        if (element.hasCreationElement()) {
            this.composeDateTimeCore("creation", element.getCreationElement(), false);
            this.composeDateTimeExtras("creation", element.getCreationElement(), false);
        }
    }

    protected void composeRatio(String name, Ratio element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeRatioInner(element);
            this.close();
        }
    }

    protected void composeRatioInner(Ratio element) throws IOException {
        this.composeElement(element);
        if (element.hasNumerator()) {
            this.composeQuantity("numerator", element.getNumerator());
        }
        if (element.hasDenominator()) {
            this.composeQuantity("denominator", element.getDenominator());
        }
    }

    protected void composeAnnotation(String name, Annotation element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeAnnotationInner(element);
            this.close();
        }
    }

    protected void composeAnnotationInner(Annotation element) throws IOException {
        this.composeElement(element);
        if (element.hasAuthor()) {
            this.composeType("author", element.getAuthor());
        }
        if (element.hasTimeElement()) {
            this.composeDateTimeCore("time", element.getTimeElement(), false);
            this.composeDateTimeExtras("time", element.getTimeElement(), false);
        }
        if (element.hasTextElement()) {
            this.composeStringCore("text", element.getTextElement(), false);
            this.composeStringExtras("text", element.getTextElement(), false);
        }
    }

    protected void composeSampledData(String name, SampledData element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeSampledDataInner(element);
            this.close();
        }
    }

    protected void composeSampledDataInner(SampledData element) throws IOException {
        this.composeElement(element);
        if (element.hasOrigin()) {
            this.composeSimpleQuantity("origin", element.getOrigin());
        }
        if (element.hasPeriodElement()) {
            this.composeDecimalCore("period", element.getPeriodElement(), false);
            this.composeDecimalExtras("period", element.getPeriodElement(), false);
        }
        if (element.hasFactorElement()) {
            this.composeDecimalCore("factor", element.getFactorElement(), false);
            this.composeDecimalExtras("factor", element.getFactorElement(), false);
        }
        if (element.hasLowerLimitElement()) {
            this.composeDecimalCore("lowerLimit", element.getLowerLimitElement(), false);
            this.composeDecimalExtras("lowerLimit", element.getLowerLimitElement(), false);
        }
        if (element.hasUpperLimitElement()) {
            this.composeDecimalCore("upperLimit", element.getUpperLimitElement(), false);
            this.composeDecimalExtras("upperLimit", element.getUpperLimitElement(), false);
        }
        if (element.hasDimensionsElement()) {
            this.composePositiveIntCore("dimensions", element.getDimensionsElement(), false);
            this.composePositiveIntExtras("dimensions", element.getDimensionsElement(), false);
        }
        if (element.hasDataElement()) {
            this.composeStringCore("data", element.getDataElement(), false);
            this.composeStringExtras("data", element.getDataElement(), false);
        }
    }

    protected void composeReference(String name, Reference element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeReferenceInner(element);
            this.close();
        }
    }

    protected void composeReferenceInner(Reference element) throws IOException {
        this.composeElement(element);
        if (element.hasReferenceElement()) {
            this.composeStringCore("reference", element.getReferenceElement(), false);
            this.composeStringExtras("reference", element.getReferenceElement(), false);
        }
        if (element.hasDisplayElement()) {
            this.composeStringCore("display", element.getDisplayElement(), false);
            this.composeStringExtras("display", element.getDisplayElement(), false);
        }
    }

    protected void composeCodeableConcept(String name, CodeableConcept element) throws IOException {
        if (element != null) {
            this.open(name);
            this.composeC