/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2.utils.IWorkerContext;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.SchematronWriter;

public class ProfileUtilities {
    private final boolean ADD_REFERENCE_TO_TABLE = true;
    private static final String ROW_COLOR_ERROR = "#ffcccc";
    private static final String ROW_COLOR_FATAL = "#ff9999";
    private static final String ROW_COLOR_WARNING = "#ffebcc";
    private static final String ROW_COLOR_HINT = "#ebf5ff";
    public static final int STATUS_OK = 0;
    public static final int STATUS_HINT = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_FATAL = 4;
    private static final String DERIVATION_EQUALS = "derivation.equals";
    public static final String DERIVATION_POINTER = "derived.pointer";
    public static final String IS_DERIVED = "derived.fact";
    public static final String UD_ERROR_STATUS = "error-status";
    private final IWorkerContext context;
    private List<ValidationMessage> messages;
    private List<String> snapshotStack = new ArrayList<String>();
    private ProfileKnowledgeProvider pkp;

    public ProfileUtilities(IWorkerContext context, List<ValidationMessage> messages, ProfileKnowledgeProvider pkp) {
        this.context = context;
        this.messages = messages;
        this.pkp = pkp;
    }

    public static List<ElementDefinition> getChildMap(StructureDefinition profile, String name, String path, String nameReference) throws DefinitionException {
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        if (nameReference != null) {
            boolean found = false;
            for (ElementDefinition e : profile.getSnapshot().getElement()) {
                if (!nameReference.equals(e.getName())) continue;
                found = true;
                path = e.getPath();
            }
            if (!found) {
                throw new DefinitionException("Unable to resolve name reference " + nameReference + " at path " + path);
            }
        }
        for (ElementDefinition e : profile.getSnapshot().getElement()) {
            String tail;
            String p = e.getPath();
            if (path != null && !Utilities.noString(e.getNameReference()) && path.startsWith(p)) {
                if (path.length() > p.length()) {
                    return ProfileUtilities.getChildMap(profile, name, e.getNameReference() + "." + path.substring(p.length() + 1), null);
                }
                return ProfileUtilities.getChildMap(profile, name, e.getNameReference(), null);
            }
            if (!p.startsWith(path + ".") || (tail = p.substring(path.length() + 1)).contains(".")) continue;
            res.add(e);
        }
        return res;
    }

    public static List<ElementDefinition> getChildMap(StructureDefinition profile, ElementDefinition element) throws DefinitionException {
        return ProfileUtilities.getChildMap(profile, element.getName(), element.getPath(), null);
    }

    public static List<ElementDefinition> getChildList(StructureDefinition profile, String path) {
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : profile.getSnapshot().getElement()) {
            String tail;
            String p = e.getPath();
            if (!Utilities.noString(e.getNameReference()) && path.startsWith(p)) {
                if (path.length() > p.length()) {
                    return ProfileUtilities.getChildList(profile, e.getNameReference() + "." + path.substring(p.length() + 1));
                }
                return ProfileUtilities.getChildList(profile, e.getNameReference());
            }
            if (!p.startsWith(path + ".") || p.equals(path) || (tail = p.substring(path.length() + 1)).contains(".")) continue;
            res.add(e);
        }
        return res;
    }

    public static List<ElementDefinition> getChildList(StructureDefinition structure, ElementDefinition element) {
        return ProfileUtilities.getChildList(structure, element.getPath());
    }

    public void generateSnapshot(StructureDefinition base, StructureDefinition derived, String url, String profileName) throws DefinitionException, FHIRException {
        if (base == null) {
            throw new DefinitionException("no base profile provided");
        }
        if (derived == null) {
            throw new DefinitionException("no derived structure provided");
        }
        if (this.snapshotStack.contains(derived.getUrl())) {
            throw new DefinitionException("Circular snapshot references detected; cannot generate snapshot (stack = " + this.snapshotStack.toString() + ")");
        }
        this.snapshotStack.add(derived.getUrl());
        derived.setSnapshot(new StructureDefinition.StructureDefinitionSnapshotComponent());
        int baseCursor = 0;
        int diffCursor = 0;
        this.processPaths(derived.getSnapshot(), base.getSnapshot(), derived.getDifferential(), baseCursor, diffCursor, base.getSnapshot().getElement().size() - 1, derived.getDifferential().getElement().size() - 1, url, derived.getId(), null, false, base.getUrl(), null, false);
    }

    private void processPaths(StructureDefinition.StructureDefinitionSnapshotComponent result, StructureDefinition.StructureDefinitionSnapshotComponent base, StructureDefinition.StructureDefinitionDifferentialComponent differential, int baseCursor, int diffCursor, int baseLimit, int diffLimit, String url, String profileName, String contextPath, boolean trimDifferential, String contextName, String resultPathBase, boolean slicingDone) throws DefinitionException, FHIRException {
        while (baseCursor <= baseLimit) {
            boolean isExtension;
            ElementDefinition currentBase = base.getElement().get(baseCursor);
            String cpath = this.fixedPath(contextPath, currentBase.getPath());
            List<ElementDefinition> diffMatches = this.getDiffMatches(differential, cpath, diffCursor, diffLimit, profileName);
            if (!currentBase.hasSlicing()) {
                ElementDefinition outcome;
                if (diffMatches.isEmpty()) {
                    outcome = this.updateURLs(url, currentBase.copy());
                    outcome.setPath(this.fixedPath(contextPath, outcome.getPath()));
                    this.updateFromBase(outcome, currentBase);
                    this.markDerived(outcome);
                    if (resultPathBase == null) {
                        resultPathBase = outcome.getPath();
                    } else if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    ++baseCursor;
                    continue;
                }
                if (diffMatches.size() == 1 && (!diffMatches.get(0).hasSlicing() || slicingDone)) {
                    String p;
                    StructureDefinition sd;
                    ElementDefinition template = null;
                    if (diffMatches.get(0).hasType() && diffMatches.get(0).getType().size() == 1 && diffMatches.get(0).getType().get(0).hasProfile() && !diffMatches.get(0).getType().get(0).getCode().equals("Reference") && (sd = this.context.fetchResource(StructureDefinition.class, p = diffMatches.get(0).getType().get(0).getProfile().get(0).asStringValue())) != null) {
                        if (!sd.hasSnapshot()) {
                            StructureDefinition sdb = this.context.fetchResource(StructureDefinition.class, sd.getBase());
                            if (sdb == null) {
                                throw new DefinitionException("no base for " + sd.getBase());
                            }
                            this.generateSnapshot(sdb, sd, sd.getUrl(), sd.getName());
                        }
                        template = sd.getSnapshot().getElement().get(0).copy().setPath(currentBase.getPath());
                        if (!diffMatches.get(0).getType().get(0).getCode().equals("Extension")) {
                            template.setMin(currentBase.getMin());
                            template.setMax(currentBase.getMax());
                        }
                    }
                    template = template == null ? currentBase.copy() : this.overWriteWithCurrent(template, currentBase);
                    ElementDefinition outcome2 = this.updateURLs(url, template);
                    outcome2.setPath(this.fixedPath(contextPath, outcome2.getPath()));
                    this.updateFromBase(outcome2, currentBase);
                    if (diffMatches.get(0).hasName()) {
                        outcome2.setName(diffMatches.get(0).getName());
                    }
                    outcome2.setSlicing(null);
                    this.updateFromDefinition(outcome2, diffMatches.get(0), profileName, trimDifferential, url);
                    if (outcome2.getPath().endsWith("[x]") && outcome2.getType().size() == 1 && !outcome2.getType().get(0).getCode().equals("*")) {
                        outcome2.setPath(outcome2.getPath().substring(0, outcome2.getPath().length() - 3) + Utilities.capitalize(outcome2.getType().get(0).getCode()));
                    }
                    if (resultPathBase == null) {
                        resultPathBase = outcome2.getPath();
                    } else if (!outcome2.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome2);
                    ++baseCursor;
                    if (differential.getElement().size() <= diffCursor || !outcome2.getPath().contains(".") || !this.isDataType(outcome2.getType()) || !this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + ".")) continue;
                    if (outcome2.getType().size() > 1) {
                        throw new DefinitionException(diffMatches.get(0).getPath() + " has children (" + differential.getElement().get(diffCursor).getPath() + ") and multiple types (" + ProfileUtilities.typeCode(outcome2.getType()) + ") in profile " + profileName);
                    }
                    StructureDefinition dt = this.getProfileForDataType(outcome2.getType().get(0));
                    if (dt == null) {
                        throw new DefinitionException(diffMatches.get(0).getPath() + " has children (" + differential.getElement().get(diffCursor).getPath() + ") for type " + ProfileUtilities.typeCode(outcome2.getType()) + " in profile " + profileName + ", but can't find type");
                    }
                    contextName = dt.getUrl();
                    int start = diffCursor;
                    for (diffCursor = differential.getElement().indexOf(diffMatches.get(0)) + 1; differential.getElement().size() > diffCursor && this.pathStartsWith(differential.getElement().get(diffCursor).getPath(), diffMatches.get(0).getPath() + "."); ++diffCursor) {
                    }
                    this.processPaths(result, dt.getSnapshot(), differential, 1, start - 1, dt.getSnapshot().getElement().size() - 1, diffCursor - 1, url, profileName + this.pathTail(diffMatches, 0), diffMatches.get(0).getPath(), trimDifferential, contextName, resultPathBase, false);
                    continue;
                }
                if (!this.unbounded(currentBase) && !this.isSlicedToOneOnly(diffMatches.get(0))) {
                    throw new DefinitionException("Attempt to a slice an element that does not repeat: " + currentBase.getPath() + "/" + currentBase.getName() + " from " + contextName);
                }
                if (!diffMatches.get(0).hasSlicing() && !this.isExtension(currentBase)) {
                    throw new DefinitionException("differential does not have a slice: " + currentBase.getPath());
                }
                outcome = this.updateURLs(url, currentBase.copy());
                outcome.setPath(this.fixedPath(contextPath, outcome.getPath()));
                this.updateFromBase(outcome, currentBase);
                if (!diffMatches.get(0).hasSlicing()) {
                    outcome.setSlicing(this.makeExtensionSlicing());
                } else {
                    outcome.setSlicing(diffMatches.get(0).getSlicing().copy());
                }
                if (!outcome.getPath().startsWith(resultPathBase)) {
                    throw new DefinitionException("Adding wrong path");
                }
                result.getElement().add(outcome);
                int start = 0;
                if (!diffMatches.get(0).hasName()) {
                    this.updateFromDefinition(outcome, diffMatches.get(0), profileName, trimDifferential, url);
                    if (!outcome.hasType()) {
                        throw new DefinitionException("not done yet");
                    }
                    start = 1;
                } else {
                    this.checkExtensionDoco(outcome);
                }
                int nbl = this.findEndOfElement(base, baseCursor);
                int ndc = diffCursor;
                int ndl = diffCursor;
                for (int i = start; i < diffMatches.size(); ++i) {
                    ndc = differential.getElement().indexOf(diffMatches.get(i));
                    ndl = this.findEndOfElement(differential, ndc);
                    this.processPaths(result, base, differential, baseCursor, ndc, nbl, ndl, url, profileName + this.pathTail(diffMatches, i), contextPath, trimDifferential, contextName, resultPathBase, true);
                }
                baseCursor = nbl + 1;
                diffCursor = ndl + 1;
                continue;
            }
            String path = currentBase.getPath();
            ElementDefinition original = currentBase;
            if (diffMatches.isEmpty()) {
                while (baseCursor < base.getElement().size() && base.getElement().get(baseCursor).getPath().startsWith(path)) {
                    ElementDefinition outcome = this.updateURLs(url, base.getElement().get(baseCursor).copy());
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    ++baseCursor;
                }
                continue;
            }
            boolean closed = currentBase.getSlicing().getRules() == ElementDefinition.SlicingRules.CLOSED;
            int diffpos = 0;
            boolean bl = isExtension = cpath.endsWith(".extension") || cpath.endsWith(".modifierExtension");
            if (diffMatches.get(0).hasSlicing()) {
                if (!isExtension) {
                    ++diffpos;
                }
                ElementDefinition.ElementDefinitionSlicingComponent dSlice = diffMatches.get(0).getSlicing();
                ElementDefinition.ElementDefinitionSlicingComponent bSlice = currentBase.getSlicing();
                if (!this.orderMatches(dSlice.getOrderedElement(), bSlice.getOrderedElement())) {
                    throw new DefinitionException("Slicing rules on differential (" + this.summariseSlicing(dSlice) + ") do not match those on base (" + this.summariseSlicing(bSlice) + ") - order @ " + path + " (" + contextName + ")");
                }
                if (!this.discriiminatorMatches(dSlice.getDiscriminator(), bSlice.getDiscriminator())) {
                    throw new DefinitionException("Slicing rules on differential (" + this.summariseSlicing(dSlice) + ") do not match those on base (" + this.summariseSlicing(bSlice) + ") - disciminator @ " + path + " (" + contextName + ")");
                }
                if (!this.ruleMatches(dSlice.getRules(), bSlice.getRules())) {
                    throw new DefinitionException("Slicing rules on differential (" + this.summariseSlicing(dSlice) + ") do not match those on base (" + this.summariseSlicing(bSlice) + ") - rule @ " + path + " (" + contextName + ")");
                }
            }
            ElementDefinition outcome = this.updateURLs(url, currentBase.copy());
            outcome.setPath(this.fixedPath(contextPath, outcome.getPath()));
            this.updateFromBase(outcome, currentBase);
            if (diffMatches.get(0).hasSlicing() && !isExtension) {
                this.updateFromSlicing(outcome.getSlicing(), diffMatches.get(0).getSlicing());
                this.updateFromDefinition(outcome, diffMatches.get(0), profileName, closed, url);
            }
            if (diffMatches.get(0).hasSlicing() && !diffMatches.get(0).hasName()) {
                ++diffpos;
            }
            result.getElement().add(outcome);
            List<ElementDefinition> baseMatches = this.getSiblings(base.getElement(), currentBase);
            for (ElementDefinition baseItem : baseMatches) {
                baseCursor = base.getElement().indexOf(baseItem);
                outcome = this.updateURLs(url, baseItem.copy());
                this.updateFromBase(outcome, currentBase);
                outcome.setPath(this.fixedPath(contextPath, outcome.getPath()));
                outcome.setSlicing(null);
                if (!outcome.getPath().startsWith(resultPathBase)) {
                    throw new DefinitionException("Adding wrong path");
                }
                if (diffpos < diffMatches.size() && diffMatches.get(diffpos).getName().equals(outcome.getName())) {
                    int nbl = this.findEndOfElement(base, baseCursor);
                    int ndc = differential.getElement().indexOf(diffMatches.get(diffpos));
                    int ndl = this.findEndOfElement(differential, ndc);
                    this.processPaths(result, base, differential, baseCursor, ndc, nbl, ndl, url, profileName + this.pathTail(diffMatches, diffpos), contextPath, closed, contextName, resultPathBase, true);
                    baseCursor = nbl + 1;
                    diffCursor = ndl + 1;
                    ++diffpos;
                    continue;
                }
                result.getElement().add(outcome);
                ++baseCursor;
                while (baseCursor < base.getElement().size() && base.getElement().get(baseCursor).getPath().startsWith(path) && !base.getElement().get(baseCursor).getPath().equals(path)) {
                    outcome = this.updateURLs(url, currentBase.copy());
                    outcome.setPath(this.fixedPath(contextPath, outcome.getPath()));
                    if (!outcome.getPath().startsWith(resultPathBase)) {
                        throw new DefinitionException("Adding wrong path");
                    }
                    result.getElement().add(outcome);
                    ++baseCursor;
                }
            }
            if (closed && diffpos < diffMatches.size()) {
                throw new DefinitionException("The base snapshot marks a slicing as closed, but the differential tries to extend it in " + profileName + " at " + path + " (" + cpath + ")");
            }
            while (diffpos < diffMatches.size()) {
                ElementDefinition diffItem = diffMatches.get(diffpos);
                for (ElementDefinition baseItem : baseMatches) {
                    if (!baseItem.getName().equals(diffItem.getName())) continue;
                    throw new DefinitionException("Named items are out of order in the slice");
                }
                outcome = this.updateURLs(url, original.copy());
                outcome.setPath(this.fixedPath(contextPath, outcome.getPath()));
                this.updateFromBase(outcome, currentBase);
                outcome.setSlicing(null);
                if (!outcome.getPath().startsWith(resultPathBase)) {
                    throw new DefinitionException("Adding wrong path");
                }
                result.getElement().add(outcome);
                this.updateFromDefinition(outcome, diffItem, profileName, trimDifferential, url);
                ++diffpos;
            }
        }
    }

    private ElementDefinition overWriteWithCurrent(ElementDefinition profile, ElementDefinition usage) {
        ElementDefinition res = profile.copy();
        if (usage.hasName()) {
            res.setName(usage.getName());
        }
        if (usage.hasLabel()) {
            res.setLabel(usage.getLabel());
        }
        for (Coding coding : usage.getCode()) {
            res.addCode(coding);
        }
        if (usage.hasDefinition()) {
            res.setDefinition(usage.getDefinition());
        }
        if (usage.hasShort()) {
            res.setShort(usage.getShort());
        }
        if (usage.hasComments()) {
            res.setComments(usage.getComments());
        }
        if (usage.hasRequirements()) {
            res.setRequirements(usage.getRequirements());
        }
        for (StringType stringType : usage.getAlias()) {
            res.addAlias((String)stringType.getValue());
        }
        if (usage.hasMin()) {
            res.setMin(usage.getMin());
        }
        if (usage.hasMax()) {
            res.setMax(usage.getMax());
        }
        if (usage.hasFixed()) {
            res.setFixed(usage.getFixed());
        }
        if (usage.hasPattern()) {
            res.setPattern(usage.getPattern());
        }
        if (usage.hasExample()) {
            res.setExample(usage.getExample());
        }
        if (usage.hasMinValue()) {
            res.setMinValue(usage.getMinValue());
        }
        if (usage.hasMaxValue()) {
            res.setMaxValue(usage.getMaxValue());
        }
        if (usage.hasMaxLength()) {
            res.setMaxLength(usage.getMaxLength());
        }
        if (usage.hasMustSupport()) {
            res.setMustSupport(usage.getMustSupport());
        }
        if (usage.hasBinding()) {
            res.setBinding(usage.getBinding().copy());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : usage.getConstraint()) {
            res.addConstraint(elementDefinitionConstraintComponent);
        }
        return res;
    }

    private boolean checkExtensionDoco(ElementDefinition base) {
        boolean isExtension;
        boolean bl = isExtension = base.getPath().equals("Extension") || base.getPath().endsWith(".extension") || base.getPath().endsWith(".modifierExtension");
        if (isExtension) {
            base.setDefinition("An Extension");
            base.setShort("Extension");
            base.setCommentsElement(null);
            base.setRequirementsElement(null);
            base.getAlias().clear();
            base.getMapping().clear();
        }
        return isExtension;
    }

    private String pathTail(List<ElementDefinition> diffMatches, int i) {
        ElementDefinition d = diffMatches.get(i);
        String s2 = d.getPath().contains(".") ? d.getPath().substring(d.getPath().lastIndexOf(".") + 1) : d.getPath();
        return "." + s2 + (d.hasType() && d.getType().get(0).hasProfile() ? "[" + d.getType().get(0).getProfile().get(0).asStringValue() + "]" : "");
    }

    private void markDerived(ElementDefinition outcome) {
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : outcome.getConstraint()) {
            inv.setUserData(IS_DERIVED, true);
        }
    }

    private String summariseSlicing(ElementDefinition.ElementDefinitionSlicingComponent slice) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (StringType d : slice.getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(d);
        }
        b.append("(");
        if (slice.hasOrdered()) {
            b.append(slice.getOrderedElement().asStringValue());
        }
        b.append("/");
        if (slice.hasRules()) {
            b.append(slice.getRules().toCode());
        }
        b.append(")");
        if (slice.hasDescription()) {
            b.append(" \"");
            b.append(slice.getDescription());
            b.append("\"");
        }
        return b.toString();
    }

    private void updateFromBase(ElementDefinition derived, ElementDefinition base) {
        if (base.hasBase()) {
            derived.getBase().setPath(base.getBase().getPath());
            derived.getBase().setMin(base.getBase().getMin());
            derived.getBase().setMax(base.getBase().getMax());
        } else {
            derived.getBase().setPath(base.getPath());
            derived.getBase().setMin(base.getMin());
            derived.getBase().setMax(base.getMax());
        }
    }

    private boolean pathStartsWith(String p1, String p2) {
        return p1.startsWith(p2);
    }

    private boolean pathMatches(String p1, String p2) {
        return p1.equals(p2) || p2.endsWith("[x]") && p1.startsWith(p2.substring(0, p2.length() - 3)) && !p1.substring(p2.length() - 3).contains(".");
    }

    private String fixedPath(String contextPath, String pathSimple) {
        if (contextPath == null) {
            return pathSimple;
        }
        return contextPath + "." + pathSimple.substring(pathSimple.indexOf(".") + 1);
    }

    private StructureDefinition getProfileForDataType(ElementDefinition.TypeRefComponent type) {
        StructureDefinition sd = null;
        if (type.hasProfile()) {
            sd = this.context.fetchResource(StructureDefinition.class, type.getProfile().get(0).asStringValue());
        }
        if (sd == null) {
            sd = this.context.fetchTypeDefinition(type.getCode());
        }
        if (sd == null) {
            System.out.println("XX: failed to find profle for type: " + type.getCode());
        }
        return sd;
    }

    public static String typeCode(List<ElementDefinition.TypeRefComponent> types) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent type : types) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(type.getCode());
            if (!type.hasProfile()) continue;
            b.append("{" + type.getProfile() + "}");
        }
        return b.toString();
    }

    private boolean isDataType(List<ElementDefinition.TypeRefComponent> types) {
        if (types.isEmpty()) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent type : types) {
            String t = type.getCode();
            if (this.isDataType(t) || t.equals("Reference") || t.equals("Narrative") || t.equals("Extension") || t.equals("ElementDefinition") || ProfileUtilities.isPrimitive(t)) continue;
            return false;
        }
        return true;
    }

    private ElementDefinition updateURLs(String url, ElementDefinition element) {
        if (element != null) {
            ElementDefinition defn = element;
            if (defn.hasBinding() && defn.getBinding().getValueSet() instanceof Reference && ((Reference)defn.getBinding().getValueSet()).getReference().startsWith("#")) {
                ((Reference)defn.getBinding().getValueSet()).setReference(url + ((Reference)defn.getBinding().getValueSet()).getReference());
            }
            for (ElementDefinition.TypeRefComponent t : defn.getType()) {
                for (UriType tp : t.getProfile()) {
                    if (!((String)tp.getValue()).startsWith("#")) continue;
                    tp.setValue(url + t.getProfile());
                }
            }
        }
        return element;
    }

    private List<ElementDefinition> getSiblings(List<ElementDefinition> list, ElementDefinition current) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        String path = current.getPath();
        for (int cursor = list.indexOf(current) + 1; cursor < list.size() && list.get(cursor).getPath().length() >= path.length(); ++cursor) {
            if (!this.pathMatches(list.get(cursor).getPath(), path)) continue;
            result.add(list.get(cursor));
        }
        return result;
    }

    private void updateFromSlicing(ElementDefinition.ElementDefinitionSlicingComponent dst, ElementDefinition.ElementDefinitionSlicingComponent src) {
        if (src.hasOrderedElement()) {
            dst.setOrderedElement(src.getOrderedElement().copy());
        }
        if (src.hasDiscriminator()) {
            dst.getDiscriminator().addAll(src.getDiscriminator());
        }
        if (src.hasRulesElement()) {
            dst.setRulesElement((Enumeration<ElementDefinition.SlicingRules>)src.getRulesElement().copy());
        }
    }

    private boolean orderMatches(BooleanType diff, BooleanType base) {
        return diff == null || base == null || diff.getValue() == base.getValue();
    }

    private boolean discriiminatorMatches(List<StringType> diff, List<StringType> base) {
        if (diff.isEmpty() || base.isEmpty()) {
            return true;
        }
        if (diff.size() != base.size()) {
            return false;
        }
        for (int i = 0; i < diff.size(); ++i) {
            if (((String)diff.get(i).getValue()).equals(base.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean ruleMatches(ElementDefinition.SlicingRules diff, ElementDefinition.SlicingRules base) {
        return diff == null || base == null || diff == base || diff == ElementDefinition.SlicingRules.OPEN || diff == ElementDefinition.SlicingRules.OPENATEND && base == ElementDefinition.SlicingRules.CLOSED;
    }

    private boolean isSlicedToOneOnly(ElementDefinition e) {
        return e.hasSlicing() && e.hasMaxElement() && e.getMax().equals("1");
    }

    private ElementDefinition.ElementDefinitionSlicingComponent makeExtensionSlicing() {
        ElementDefinition.ElementDefinitionSlicingComponent slice = new ElementDefinition.ElementDefinitionSlicingComponent();
        slice.addDiscriminator("url");
        slice.setOrdered(false);
        slice.setRules(ElementDefinition.SlicingRules.OPEN);
        return slice;
    }

    private boolean isExtension(ElementDefinition currentBase) {
        return currentBase.getPath().endsWith(".extension") || currentBase.getPath().endsWith(".modifierExtension");
    }

    private List<ElementDefinition> getDiffMatches(StructureDefinition.StructureDefinitionDifferentialComponent context, String path, int start, int end, String profileName) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        for (int i = start; i <= end; ++i) {
            String statedPath = context.getElement().get(i).getPath();
            if (statedPath.equals(path) || path.endsWith("[x]") && statedPath.length() > path.length() - 2 && statedPath.substring(0, path.length() - 3).equals(path.substring(0, path.length() - 3)) && !statedPath.substring(path.length()).contains(".")) {
                result.add(context.getElement().get(i));
                continue;
            }
            if (!result.isEmpty()) continue;
        }
        return result;
    }

    private int findEndOfElement(StructureDefinition.StructureDefinitionDifferentialComponent context, int cursor) {
        int result;
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    private int findEndOfElement(StructureDefinition.StructureDefinitionSnapshotComponent context, int cursor) {
        int result;
        String path = context.getElement().get(cursor).getPath() + ".";
        for (result = cursor; result < context.getElement().size() - 1 && context.getElement().get(result + 1).getPath().startsWith(path); ++result) {
        }
        return result;
    }

    private boolean unbounded(ElementDefinition definition) {
        StringType max = definition.getMaxElement();
        if (max == null) {
            return false;
        }
        if (((String)max.getValue()).equals("1")) {
            return false;
        }
        return !((String)max.getValue()).equals("0");
    }

    private void updateFromDefinition(ElementDefinition dest, ElementDefinition source, String pn, boolean trimDifferential, String purl) throws DefinitionException, FHIRException {
        ElementDefinition base = dest;
        ElementDefinition derived = source;
        derived.setUserData(DERIVATION_POINTER, base);
        if (derived != null) {
            boolean isExtension = this.checkExtensionDoco(base);
            if (derived.hasShortElement()) {
                if (!Base.compareDeep(derived.getShortElement(), base.getShortElement(), false)) {
                    base.setShortElement(derived.getShortElement().copy());
                } else if (trimDifferential) {
                    derived.setShortElement(null);
                } else if (derived.hasShortElement()) {
                    derived.getShortElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasDefinitionElement()) {
                if (derived.getDefinition().startsWith("...")) {
                    base.setDefinition(base.getDefinition() + "\r\n" + derived.getDefinition().substring(3));
                } else if (!Base.compareDeep(derived.getDefinitionElement(), base.getDefinitionElement(), false)) {
                    base.setDefinitionElement(derived.getDefinitionElement().copy());
                } else if (trimDifferential) {
                    derived.setDefinitionElement(null);
                } else if (derived.hasDefinitionElement()) {
                    derived.getDefinitionElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasCommentsElement()) {
                if (derived.getComments().startsWith("...")) {
                    base.setComments(base.getComments() + "\r\n" + derived.getComments().substring(3));
                } else if (!Base.compareDeep(derived.getCommentsElement(), base.getCommentsElement(), false)) {
                    base.setCommentsElement(derived.getCommentsElement().copy());
                } else if (trimDifferential) {
                    base.setCommentsElement(derived.getCommentsElement().copy());
                } else if (derived.hasCommentsElement()) {
                    derived.getCommentsElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasLabelElement()) {
                if (derived.getLabel().startsWith("...")) {
                    base.setLabel(base.getLabel() + "\r\n" + derived.getLabel().substring(3));
                } else if (!Base.compareDeep(derived.getLabelElement(), base.getLabelElement(), false)) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (trimDifferential) {
                    base.setLabelElement(derived.getLabelElement().copy());
                } else if (derived.hasLabelElement()) {
                    derived.getLabelElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirementsElement()) {
                if (derived.getRequirements().startsWith("...")) {
                    base.setRequirements(base.getRequirements() + "\r\n" + derived.getRequirements().substring(3));
                } else if (!Base.compareDeep(derived.getRequirementsElement(), base.getRequirementsElement(), false)) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (trimDifferential) {
                    base.setRequirementsElement(derived.getRequirementsElement().copy());
                } else if (derived.hasRequirementsElement()) {
                    derived.getRequirementsElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasRequirements() && !base.getPath().contains(".")) {
                derived.setRequirements(null);
            }
            if (base.hasRequirements() && !base.getPath().contains(".")) {
                base.setRequirements(null);
            }
            if (derived.hasAlias()) {
                if (!Base.compareDeep(derived.getAlias(), base.getAlias(), false)) {
                    for (StringType stringType : derived.getAlias()) {
                        if (base.hasAlias((String)stringType.getValue())) continue;
                        base.getAlias().add(stringType.copy());
                    }
                } else if (trimDifferential) {
                    derived.getAlias().clear();
                } else {
                    for (StringType stringType : derived.getAlias()) {
                        stringType.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMinElement()) {
                if (!Base.compareDeep(derived.getMinElement(), base.getMinElement(), false)) {
                    if (derived.getMin() < base.getMin()) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Derived min  (" + Integer.toString(derived.getMin()) + ") cannot be less than base min (" + Integer.toString(base.getMin()) + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMinElement(derived.getMinElement().copy());
                } else if (trimDifferential) {
                    derived.setMinElement(null);
                } else {
                    derived.getMinElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxElement()) {
                if (!Base.compareDeep(derived.getMaxElement(), base.getMaxElement(), false)) {
                    if (this.isLargerMax(derived.getMax(), base.getMax())) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Derived max (" + derived.getMax() + ") cannot be greater than base max (" + base.getMax() + ")", ValidationMessage.IssueSeverity.ERROR));
                    }
                    base.setMaxElement(derived.getMaxElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxElement(null);
                } else {
                    derived.getMaxElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasFixed()) {
                if (!Base.compareDeep(derived.getFixed(), base.getFixed(), true)) {
                    base.setFixed(derived.getFixed().copy());
                } else if (trimDifferential) {
                    derived.setFixed(null);
                } else {
                    derived.getFixed().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasPattern()) {
                if (!Base.compareDeep(derived.getPattern(), base.getPattern(), false)) {
                    base.setPattern(derived.getPattern().copy());
                } else if (trimDifferential) {
                    derived.setPattern(null);
                } else {
                    derived.getPattern().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasExample()) {
                if (!Base.compareDeep(derived.getExample(), base.getExample(), false)) {
                    base.setExample(derived.getExample().copy());
                } else if (trimDifferential) {
                    derived.setExample(null);
                } else {
                    derived.getExample().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMaxLengthElement()) {
                if (!Base.compareDeep(derived.getMaxLengthElement(), base.getMaxLengthElement(), false)) {
                    base.setMaxLengthElement(derived.getMaxLengthElement().copy());
                } else if (trimDifferential) {
                    derived.setMaxLengthElement(null);
                } else {
                    derived.getMaxLengthElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasMustSupportElement()) {
                if (!Base.compareDeep(derived.getMustSupportElement(), base.getMustSupportElement(), false)) {
                    base.setMustSupportElement(derived.getMustSupportElement().copy());
                } else if (trimDifferential) {
                    derived.setMustSupportElement(null);
                } else {
                    derived.getMustSupportElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (isExtension) {
                if (!Base.compareDeep(derived.getIsModifierElement(), base.getIsModifierElement(), false)) {
                    base.setIsModifierElement(derived.getIsModifierElement().copy());
                } else if (trimDifferential) {
                    derived.setIsModifierElement(null);
                } else {
                    derived.getIsModifierElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasBinding()) {
                if (!Base.compareDeep(derived.getBinding(), base.getBinding(), false)) {
                    if (base.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && derived.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "illegal attempt to change a binding from " + base.getBinding().getStrength().toCode() + " to " + derived.getBinding().getStrength().toCode(), ValidationMessage.IssueSeverity.ERROR));
                    } else if (base.hasBinding() && derived.hasBinding() && base.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED) {
                        ValueSetExpander.ValueSetExpansionOutcome expBase = this.context.expandVS(this.context.fetchResource(ValueSet.class, base.getBinding().getValueSetReference().getReference()), true);
                        ValueSetExpander.ValueSetExpansionOutcome valueSetExpansionOutcome = this.context.expandVS(this.context.fetchResource(ValueSet.class, derived.getBinding().getValueSetReference().getReference()), true);
                        if (expBase.getValueset() == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + base.getPath(), "Binding " + base.getBinding().getValueSetReference().getReference() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                        } else if (valueSetExpansionOutcome.getValueset() == null) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSetReference().getReference() + " could not be expanded", ValidationMessage.IssueSeverity.WARNING));
                        } else if (!this.isSubset(expBase.getValueset(), valueSetExpansionOutcome.getValueset())) {
                            this.messages.add(new ValidationMessage(ValidationMessage.Source.ProfileValidator, ValidationMessage.IssueType.BUSINESSRULE, pn + "." + derived.getPath(), "Binding " + derived.getBinding().getValueSetReference().getReference() + " is not a subset of binding " + base.getBinding().getValueSetReference().getReference(), ValidationMessage.IssueSeverity.ERROR));
                        }
                    }
                    base.setBinding(derived.getBinding().copy());
                } else if (trimDifferential) {
                    derived.setBinding(null);
                } else {
                    derived.getBinding().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasIsSummaryElement()) {
                if (!Base.compareDeep(derived.getIsSummaryElement(), base.getIsSummaryElement(), false)) {
                    base.setIsSummaryElement(derived.getIsSummaryElement().copy());
                } else if (trimDifferential) {
                    derived.setIsSummaryElement(null);
                } else {
                    derived.getIsSummaryElement().setUserData(DERIVATION_EQUALS, true);
                }
            }
            if (derived.hasType()) {
                if (!Base.compareDeep(derived.getType(), base.getType(), false)) {
                    if (base.hasType()) {
                        for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                            boolean ok = false;
                            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                            for (ElementDefinition.TypeRefComponent td : base.getType()) {
                                b.append(td.getCode());
                                if (!td.hasCode() || !td.getCode().equals(typeRefComponent.getCode()) && !td.getCode().equals("Extension") && !td.getCode().equals("Element") && !td.getCode().equals("*") && !td.getCode().equals("Resource") && (!td.getCode().equals("DomainResource") || !this.pkp.isResource(typeRefComponent.getCode()))) continue;
                                ok = true;
                            }
                            if (ok) continue;
                            throw new DefinitionException("StructureDefinition " + pn + " at " + derived.getPath() + ": illegal constrained type " + typeRefComponent.getCode() + " from " + b.toString());
                        }
                    }
                    base.getType().clear();
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        ElementDefinition.TypeRefComponent tt = typeRefComponent.copy();
                        base.getType().add(tt);
                    }
                } else if (trimDifferential) {
                    derived.getType().clear();
                } else {
                    for (ElementDefinition.TypeRefComponent typeRefComponent : derived.getType()) {
                        typeRefComponent.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            if (derived.hasMapping()) {
                if (!Base.compareDeep(derived.getMapping(), base.getMapping(), false)) {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        boolean found = false;
                        for (ElementDefinition.ElementDefinitionMappingComponent d : base.getMapping()) {
                            found = found || d.getIdentity().equals(elementDefinitionMappingComponent.getIdentity()) && d.getMap().equals(elementDefinitionMappingComponent.getMap());
                        }
                        if (found) continue;
                        base.getMapping().add(elementDefinitionMappingComponent);
                    }
                } else if (trimDifferential) {
                    derived.getMapping().clear();
                } else {
                    for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : derived.getMapping()) {
                        elementDefinitionMappingComponent.setUserData(DERIVATION_EQUALS, true);
                    }
                }
            }
            for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : base.getConstraint()) {
                elementDefinitionConstraintComponent.setUserData(IS_DERIVED, true);
            }
            if (derived.hasConstraint()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : derived.getConstraint()) {
                    base.getConstraint().add(elementDefinitionConstraintComponent.copy());
                }
            }
        }
    }

    private boolean isLargerMax(String derived, String base) {
        if ("*".equals(base)) {
            return false;
        }
        if ("*".equals(derived)) {
            return true;
        }
        return Integer.parseInt(derived) > Integer.parseInt(base);
    }

    private boolean isSubset(ValueSet expBase, ValueSet expDerived) {
        return this.codesInExpansion(expDerived.getExpansion().getContains(), expBase.getExpansion());
    }

    private boolean codesInExpansion(List<ValueSet.ValueSetExpansionContainsComponent> contains, ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (!this.inExpansion(cc, expansion.getContains())) {
                return false;
            }
            if (this.codesInExpansion(cc.getContains(), expansion)) continue;
            return false;
        }
        return true;
    }

    private boolean inExpansion(ValueSet.ValueSetExpansionContainsComponent cc, List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : contains) {
            if (cc.getSystem().equals(cc1.getSystem()) && cc.getCode().equals(cc1.getCode())) {
                return true;
            }
            if (!this.inExpansion(cc, cc1.getContains())) continue;
            return true;
        }
        return false;
    }

    public XhtmlNode generateExtensionTable(String defFile, StructureDefinition ed, String imageFolder, boolean inlineGraphics, boolean full, String corePath, Set<String> outputTracker) throws IOException, FHIRException {
        List<Object> children;
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics);
        HierarchicalTableGenerator.TableModel model = gen.initNormalTable(corePath, false, true, ed.getId(), false);
        boolean deep = false;
        boolean vdeep = false;
        for (ElementDefinition eld : ed.getSnapshot().getElement()) {
            deep = deep || eld.getPath().contains("Extension.extension.");
            vdeep = vdeep || eld.getPath().contains("Extension.extension.extension.");
        }
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        model.getRows().add(r);
        List<HierarchicalTableGenerator.Cell> list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, defFile == null ? "" : defFile + "-definitions.html#extension." + ed.getName(), ed.getSnapshot().getElement().get(0).getIsModifier() ? "modifierExtension" : "extension", null, null));
        r.getCells().add(new HierarchicalTableGenerator.Cell(gen));
        List<HierarchicalTableGenerator.Cell> list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, this.describeCardinality(ed.getSnapshot().getElement().get(0), null, new UnusedTracker()), null, null));
        if (full || vdeep) {
            List<HierarchicalTableGenerator.Cell> list3 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, "", "", "Extension", null, null));
            r.setIcon(deep ? "icon_extension_complex.png" : "icon_extension_simple.png", deep ? "Complex Extension" : "Simple Extension");
            children = this.getChildren(ed.getSnapshot().getElement(), ed.getSnapshot().getElement().get(0));
            for (ElementDefinition elementDefinition : children) {
                if (elementDefinition.getPath().endsWith(".id")) continue;
                this.genElement(defFile == null ? "" : defFile + "-definitions.html#extension.", gen, r.getSubRows(), elementDefinition, ed.getSnapshot().getElement(), null, true, defFile, true, full, corePath);
            }
        } else if (deep) {
            children = new ArrayList<ElementDefinition>();
            for (ElementDefinition elementDefinition : ed.getSnapshot().getElement()) {
                if (!elementDefinition.getPath().equals("Extension.extension")) continue;
                children.add(elementDefinition);
            }
            List<HierarchicalTableGenerator.Cell> list4 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, "", "", "Extension", null, null));
            r.setIcon("icon_extension_complex.png", "Complex Extension");
            for (ElementDefinition elementDefinition : children) {
                ElementDefinition ved = this.getValueFor(ed, elementDefinition);
                ElementDefinition ued = this.getUrlFor(ed, elementDefinition);
                if (ved == null || ued == null) continue;
                HierarchicalTableGenerator.Row r1 = new HierarchicalTableGenerator.Row(gen);
                r.getSubRows().add(r1);
                List<HierarchicalTableGenerator.Cell> list5 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, defFile == null ? "" : defFile + "-definitions.html#extension." + ed.getName(), (String)((UriType)ued.getFixed()).getValue(), null, null));
                r1.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                List<HierarchicalTableGenerator.Cell> list6 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, this.describeCardinality(elementDefinition, null, new UnusedTracker()), null, null));
                this.genTypes(gen, r1, ved, defFile, ed, corePath);
                List<HierarchicalTableGenerator.Cell> list7 = r1.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator7);
                list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, elementDefinition.getDefinition(), null, null));
                r1.setIcon("icon_extension_simple.png", "Simple Extension");
            }
        } else {
            ElementDefinition ved = null;
            for (ElementDefinition elementDefinition : ed.getSnapshot().getElement()) {
                if (!elementDefinition.getPath().startsWith("Extension.value")) continue;
                ved = elementDefinition;
            }
            this.genTypes(gen, r, ved, defFile, ed, corePath);
            r.setIcon("icon_extension_simple.png", "Simple Extension");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator8);
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator8, "", "", "URL = " + ed.getUrl(), null, null);
        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator9);
        HierarchicalTableGenerator.Cell cell = c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, "br"));
        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator10);
        cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, ed.getName() + ": " + ed.getDescription(), null));
        HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator11);
        HierarchicalTableGenerator.Cell cell2 = c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, "br"));
        HierarchicalTableGenerator hierarchicalTableGenerator12 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator12);
        cell2.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator12, null, ProfileUtilities.describeExtensionContext(ed), null));
        r.getCells().add(c);
        return gen.generate(model, corePath, 0, outputTracker);
    }

    private ElementDefinition getUrlFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().equals(c.getPath() + ".url")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    private ElementDefinition getValueFor(StructureDefinition ed, ElementDefinition c) {
        for (int i = ed.getSnapshot().getElement().indexOf(c) + 1; i < ed.getSnapshot().getElement().size() && ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + "."); ++i) {
            if (!ed.getSnapshot().getElement().get(i).getPath().startsWith(c.getPath() + ".value")) continue;
            return ed.getSnapshot().getElement().get(i);
        }
        return null;
    }

    private HierarchicalTableGenerator.Cell genTypes(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row r, ElementDefinition e, String profileBaseFileName, StructureDefinition profile, String corePath) {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        r.getCells().add(c);
        List<ElementDefinition.TypeRefComponent> types = e.getType();
        if (!e.hasType()) {
            if (e.hasNameReference()) {
                ElementDefinition ed = this.getElementByName(profile.getSnapshot().getElement(), e.getNameReference());
                if (ed == null) {
                    List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Unknown reference to " + e.getNameReference(), null));
                } else {
                    List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "#" + ed.getPath(), "See " + ed.getPath(), null));
                }
                return c;
            }
            ElementDefinition d = (ElementDefinition)e.getUserData(DERIVATION_POINTER);
            if (d != null && d.hasType()) {
                types = new ArrayList<ElementDefinition.TypeRefComponent>();
                for (ElementDefinition.TypeRefComponent tr : d.getType()) {
                    ElementDefinition.TypeRefComponent tt = tr.copy();
                    tt.setUserData(DERIVATION_EQUALS, true);
                    types.add(tt);
                }
            } else {
                return c;
            }
        }
        boolean first = true;
        Element source = types.get(0);
        boolean allReference = !types.isEmpty();
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.getCode().equals("Reference") && t.hasProfile()) continue;
            allReference = false;
        }
        if (allReference) {
            List<HierarchicalTableGenerator.Piece> list = c.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + "references.html", "Reference", null));
            List<HierarchicalTableGenerator.Piece> list2 = c.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, "(", null));
        }
        ElementDefinition.TypeRefComponent tl = null;
        for (ElementDefinition.TypeRefComponent t : types) {
            if (first) {
                first = false;
            } else if (allReference) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " | ", null)));
            } else {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(tl, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ", ", null)));
            }
            tl = t;
            if (t.getCode().equals("Reference") || t.getCode().equals("Resource") && t.hasProfile()) {
                if (!allReference) {
                    List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + "references.html", "Reference", null));
                    List<HierarchicalTableGenerator.Piece> list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "(", null));
                }
                if (t.hasProfile() && ((String)t.getProfile().get(0).getValue()).startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                    StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, (String)t.getProfile().get(0).getValue());
                    if (sd != null) {
                        String disp = sd.hasDisplay() ? sd.getDisplay() : sd.getName();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + sd.getUserString("path"), disp, null)));
                    } else {
                        String rn = ((String)t.getProfile().get(0).getValue()).substring(40);
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + this.pkp.getLinkFor(rn), rn, null)));
                    }
                } else if (t.getProfile().size() == 0) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, t.getCode(), null)));
                } else if (((String)t.getProfile().get(0).getValue()).startsWith("#")) {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + profileBaseFileName + "." + ((String)t.getProfile().get(0).getValue()).substring(1).toLowerCase() + ".html", (String)t.getProfile().get(0).getValue(), null)));
                } else {
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + (String)t.getProfile().get(0).getValue(), (String)t.getProfile().get(0).getValue(), null)));
                }
                if (allReference) continue;
                List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ")", null));
                continue;
            }
            if (t.hasProfile()) {
                String ref = this.pkp.getLinkForProfile(profile, (String)t.getProfile().get(0).getValue());
                if (ref != null) {
                    String[] parts = ref.split("\\|");
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + parts[0], parts[1], t.getCode())));
                    continue;
                }
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + ref, t.getCode(), null)));
                continue;
            }
            if (this.pkp.hasLinkFor(t.getCode())) {
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, corePath + this.pkp.getLinkFor(t.getCode()), t.getCode(), null)));
                continue;
            }
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            c.addPiece(this.checkForNoChange(t, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, t.getCode(), null)));
        }
        if (allReference) {
            List<HierarchicalTableGenerator.Piece> list = c.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ")", null));
        }
        return c;
    }

    private ElementDefinition getElementByName(List<ElementDefinition> elements, String nameReference) {
        for (ElementDefinition ed : elements) {
            if (!ed.hasName() || !ed.getName().equals(nameReference)) continue;
            return ed;
        }
        return null;
    }

    public static String describeExtensionContext(StructureDefinition ext) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (StringType t : ext.getContext()) {
            b.append((String)t.getValue());
        }
        if (!ext.hasContextType()) {
            throw new Error("no context type on " + ext.getUrl());
        }
        switch (ext.getContextType()) {
            case DATATYPE: {
                return "Use on data type: " + b.toString();
            }
            case EXTENSION: {
                return "Use on extension: " + b.toString();
            }
            case RESOURCE: {
                return "Use on element: " + b.toString();
            }
            case MAPPING: {
                return "Use where element has mapping: " + b.toString();
            }
        }
        return "??";
    }

    private String describeCardinality(ElementDefinition definition, ElementDefinition fallback, UnusedTracker tracker) {
        StringType max;
        IntegerType min2 = definition.hasMinElement() ? definition.getMinElement() : new IntegerType();
        StringType stringType = max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType();
        if (min2.isEmpty() && fallback != null) {
            min2 = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        tracker.used = !max.isEmpty() && !((String)max.getValue()).equals("0");
        if (min2.isEmpty() && max.isEmpty()) {
            return null;
        }
        return (!min2.hasValue() ? "" : Integer.toString((Integer)min2.getValue())) + ".." + (!max.hasValue() ? "" : (String)max.getValue());
    }

    private void genCardinality(HierarchicalTableGenerator gen, ElementDefinition definition, HierarchicalTableGenerator.Row row, boolean hasDef, UnusedTracker tracker, ElementDefinition fallback) {
        ElementDefinition base;
        StringType max;
        IntegerType min2;
        IntegerType integerType = !hasDef ? new IntegerType() : (min2 = definition.hasMinElement() ? definition.getMinElement() : new IntegerType());
        StringType stringType = !hasDef ? new StringType() : (max = definition.hasMaxElement() ? definition.getMaxElement() : new StringType());
        if (min2.isEmpty() && definition.getUserData(DERIVATION_POINTER) != null) {
            base = (ElementDefinition)definition.getUserData(DERIVATION_POINTER);
            min2 = base.getMinElement().copy();
            min2.setUserData(DERIVATION_EQUALS, true);
        }
        if (max.isEmpty() && definition.getUserData(DERIVATION_POINTER) != null) {
            base = (ElementDefinition)definition.getUserData(DERIVATION_POINTER);
            max = base.getMaxElement().copy();
            max.setUserData(DERIVATION_EQUALS, true);
        }
        if (min2.isEmpty() && fallback != null) {
            min2 = fallback.getMinElement();
        }
        if (max.isEmpty() && fallback != null) {
            max = fallback.getMaxElement();
        }
        if (!max.isEmpty()) {
            tracker.used = !((String)max.getValue()).equals("0");
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null);
        row.getCells().add(cell);
        if (!min2.isEmpty() || !max.isEmpty()) {
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            cell.addPiece(this.checkForNoChange(min2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, !min2.hasValue() ? "" : Integer.toString((Integer)min2.getValue()), null)));
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            cell.addPiece(this.checkForNoChange(min2, max, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "..", null)));
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            cell.addPiece(this.checkForNoChange(min2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, !max.hasValue() ? "" : (String)max.getValue(), null)));
        }
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(Element source, HierarchicalTableGenerator.Piece piece) {
        if (source.hasUserData(DERIVATION_EQUALS)) {
            piece.addStyle("opacity: 0.4");
        }
        return piece;
    }

    private HierarchicalTableGenerator.Piece checkForNoChange(Element src1, Element src2, HierarchicalTableGenerator.Piece piece) {
        if (src1.hasUserData(DERIVATION_EQUALS) && src2.hasUserData(DERIVATION_EQUALS)) {
            piece.addStyle("opacity: 0.5");
        }
        return piece;
    }

    public XhtmlNode generateTable(String defFile, StructureDefinition profile, boolean diff, String imageFolder, boolean inlineGraphics, String profileBaseFileName, boolean snapshot, String corePath, Set<String> outputTracker) throws IOException, FHIRException {
        assert (diff != snapshot);
        HierarchicalTableGenerator gen = new HierarchicalTableGenerator(imageFolder, inlineGraphics);
        HierarchicalTableGenerator.TableModel model = gen.initNormalTable(corePath, false, true, profile.getId() + (diff ? "d" : "s"), false);
        List<ElementDefinition> list = diff ? profile.getDifferential().getElement() : profile.getSnapshot().getElement();
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        profiles.add(profile);
        this.genElement(defFile == null ? null : defFile + "#" + profile.getId() + ".", gen, model.getRows(), list.get(0), list, profiles, diff, profileBaseFileName, null, snapshot, corePath);
        return gen.generate(model, corePath, 0, outputTracker);
    }

    private void genElement(String defPath, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ElementDefinition element, List<ElementDefinition> all, List<StructureDefinition> profiles, boolean showMissing, String profileBaseFileName, Boolean extensions, boolean snapshot, String corePath) throws IOException {
        block45: {
            HierarchicalTableGenerator.Row row;
            boolean isExtension;
            List<ElementDefinition> children;
            block46: {
                StructureDefinition profile = profiles == null ? null : profiles.get(profiles.size() - 1);
                String s2 = this.tail(element.getPath());
                children = this.getChildren(all, element);
                boolean bl = isExtension = s2.equals("extension") || s2.equals("modifierExtension");
                if (!snapshot && extensions != null && extensions != isExtension) {
                    return;
                }
                if (this.onlyInformationIsMapping(all, element)) break block45;
                row = new HierarchicalTableGenerator.Row(gen);
                row.setAnchor(element.getPath());
                row.setColor(this.getRowColor(element));
                boolean hasDef = element != null;
                boolean ext = false;
                if (s2.equals("extension") || s2.equals("modifierExtension")) {
                    if (element.hasType() && element.getType().get(0).hasProfile() && this.extensionIsComplex((String)element.getType().get(0).getProfile().get(0).getValue())) {
                        row.setIcon("icon_extension_complex.png", "Complex Extension");
                    } else {
                        row.setIcon("icon_extension_simple.png", "Simple Extension");
                    }
                    ext = true;
                } else if (!hasDef || element.getType().size() == 0) {
                    row.setIcon("icon_element.gif", "Element");
                } else if (hasDef && element.getType().size() > 1) {
                    if (this.allTypesAre(element.getType(), "Reference")) {
                        row.setIcon("icon_reference.png", "Reference to another Resource");
                    } else {
                        row.setIcon("icon_choice.gif", "Choice of Types");
                    }
                } else if (hasDef && element.getType().get(0).getCode() != null && element.getType().get(0).getCode().startsWith("@")) {
                    row.setIcon("icon_reuse.png", "Reference to another Element");
                } else if (hasDef && ProfileUtilities.isPrimitive(element.getType().get(0).getCode())) {
                    row.setIcon("icon_primitive.png", "Primitive Data Type");
                } else if (hasDef && this.isReference(element.getType().get(0).getCode())) {
                    row.setIcon("icon_reference.png", "Reference to another Resource");
                } else if (hasDef && this.isDataType(element.getType().get(0).getCode())) {
                    row.setIcon("icon_datatype.gif", "Data Type");
                } else {
                    row.setIcon("icon_resource.png", "Resource");
                }
                String ref = defPath == null ? null : defPath + this.makePathLink(element);
                UnusedTracker used = new UnusedTracker();
                used.used = true;
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                HierarchicalTableGenerator.Cell left = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, ref, s2, !hasDef ? null : element.getDefinition(), null);
                row.getCells().add(left);
                HierarchicalTableGenerator.Cell gc = new HierarchicalTableGenerator.Cell(gen);
                row.getCells().add(gc);
                if (element != null && element.getIsModifier()) {
                    this.checkForNoChange(element.getIsModifierElement(), gc.addStyledText("This element is a modifier element", "?!", null, null, null, false));
                }
                if (element != null && element.getMustSupport()) {
                    this.checkForNoChange(element.getMustSupportElement(), gc.addStyledText("This element must be supported", "S", null, null, null, false));
                }
                if (element != null && element.getIsSummary()) {
                    this.checkForNoChange(element.getIsSummaryElement(), gc.addStyledText("This element is included in summaries", "\u2211", null, null, null, false));
                }
                if (!(element == null || element.getConstraint().isEmpty() && element.getCondition().isEmpty())) {
                    gc.addStyledText("This element has or is affected by some invariants", "I", null, null, null, false);
                }
                ExtensionContext extDefn = null;
                if (ext) {
                    if (element != null && element.getType().size() == 1 && element.getType().get(0).hasProfile()) {
                        extDefn = this.locateExtension(StructureDefinition.class, (String)element.getType().get(0).getProfile().get(0).getValue());
                        if (extDefn == null) {
                            this.genCardinality(gen, element, row, hasDef, used, null);
                            List<HierarchicalTableGenerator.Cell> list = row.getCells();
                            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator2);
                            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "?? " + element.getType().get(0).getProfile(), null, null));
                            this.generateDescription(gen, row, element, null, used.used, profile.getUrl(), (String)element.getType().get(0).getProfile().get(0).getValue(), profile, corePath);
                        } else {
                            String name = this.urltail((String)element.getType().get(0).getProfile().get(0).getValue());
                            left.getPieces().get(0).setText(name);
                            left.getPieces().get(0).setHint("Extension URL = " + extDefn.getUrl());
                            this.genCardinality(gen, element, row, hasDef, used, extDefn.getElement());
                            ElementDefinition valueDefn = extDefn.getExtensionValueDefinition();
                            if (valueDefn != null && !"0".equals(valueDefn.getMax())) {
                                this.genTypes(gen, row, valueDefn, profileBaseFileName, profile, corePath);
                            } else {
                                List<HierarchicalTableGenerator.Cell> list = row.getCells();
                                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                                Objects.requireNonNull(hierarchicalTableGenerator3);
                                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, "(Complex)", null, null));
                            }
                            this.generateDescription(gen, row, element, extDefn.getElement(), used.used, null, extDefn.getUrl(), profile, corePath);
                        }
                    } else {
                        this.genCardinality(gen, element, row, hasDef, used, null);
                        if ("0".equals(element.getMax())) {
                            row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                        } else {
                            this.genTypes(gen, row, element, profileBaseFileName, profile, corePath);
                        }
                        this.generateDescription(gen, row, element, null, used.used, null, null, profile, corePath);
                    }
                } else {
                    this.genCardinality(gen, element, row, hasDef, used, null);
                    if (hasDef && !"0".equals(element.getMax())) {
                        this.genTypes(gen, row, element, profileBaseFileName, profile, corePath);
                    } else {
                        row.getCells().add(new HierarchicalTableGenerator.Cell(gen));
                    }
                    this.generateDescription(gen, row, element, null, used.used, null, null, profile, corePath);
                }
                if (element.hasSlicing()) {
                    if (this.standardExtensionSlicing(element)) {
                        used.used = element.hasType() && element.getType().get(0).hasProfile();
                        showMissing = false;
                    } else {
                        row.setIcon("icon_slice.png", "Slice Definition");
                        row.getCells().get(2).getPieces().clear();
                        for (HierarchicalTableGenerator.Cell cell : row.getCells()) {
                            for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                                p.addStyle("font-style: italic");
                            }
                        }
                    }
                }
                if (used.used || showMissing) {
                    rows.add(row);
                }
                if (used.used || element.hasSlicing()) break block46;
                for (HierarchicalTableGenerator.Cell cell : row.getCells()) {
                    for (HierarchicalTableGenerator.Piece p : cell.getPieces()) {
                        p.setStyle("text-decoration:line-through");
                        p.setReference(null);
                    }
                }
                break block45;
            }
            for (ElementDefinition child : children) {
                if (child.getPath().endsWith(".id")) continue;
                this.genElement(defPath, gen, row.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, isExtension, snapshot, corePath);
            }
            if (snapshot || extensions != null && extensions.booleanValue()) break block45;
            for (ElementDefinition child : children) {
                if (!child.getPath().endsWith(".extension")) continue;
                this.genElement(defPath, gen, row.getSubRows(), child, all, profiles, showMissing, profileBaseFileName, true, false, corePath);
            }
        }
    }

    private ExtensionContext locateExtension(Class<StructureDefinition> class1, String value) {
        if (value.contains("#")) {
            StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return null;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getName())) continue;
                ed = ted;
                return new ExtensionContext(ext, ed);
            }
            return null;
        }
        StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value);
        if (ext == null) {
            return null;
        }
        return new ExtensionContext(ext, ext.getSnapshot().getElement().get(0));
    }

    private boolean extensionIsComplex(String value) {
        if (value.contains("#")) {
            int j;
            StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value.substring(0, value.indexOf("#")));
            if (ext == null) {
                return false;
            }
            String tail = value.substring(value.indexOf("#") + 1);
            ElementDefinition ed = null;
            for (ElementDefinition ted : ext.getSnapshot().getElement()) {
                if (!tail.equals(ted.getName())) continue;
                ed = ted;
                break;
            }
            if (ed == null) {
                return false;
            }
            int i = ext.getSnapshot().getElement().indexOf(ed);
            for (j = i + 1; j < ext.getSnapshot().getElement().size() && !ext.getSnapshot().getElement().get(j).getPath().equals(ed.getPath()); ++j) {
            }
            return j - i > 5;
        }
        StructureDefinition ext = this.context.fetchResource(StructureDefinition.class, value);
        return ext != null && ext.getSnapshot().getElement().size() > 5;
    }

    private String getRowColor(ElementDefinition element) {
        switch (element.getUserInt(UD_ERROR_STATUS)) {
            case 0: {
                return null;
            }
            case 1: {
                return ROW_COLOR_HINT;
            }
            case 2: {
                return ROW_COLOR_WARNING;
            }
            case 3: {
                return ROW_COLOR_ERROR;
            }
            case 4: {
                return ROW_COLOR_FATAL;
            }
        }
        return null;
    }

    private String urltail(String path) {
        if (path.contains("#")) {
            return path.substring(path.lastIndexOf(35) + 1);
        }
        if (path.contains("/")) {
            return path.substring(path.lastIndexOf(47) + 1);
        }
        return path;
    }

    private boolean standardExtensionSlicing(ElementDefinition element) {
        String t = this.tail(element.getPath());
        return (t.equals("extension") || t.equals("modifierExtension")) && element.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED && element.getSlicing().getDiscriminator().size() == 1 && ((String)element.getSlicing().getDiscriminator().get(0).getValue()).equals("url");
    }

    private String makePathLink(ElementDefinition element) {
        if (!element.hasName()) {
            return element.getPath();
        }
        if (!element.getPath().contains(".")) {
            return element.getName();
        }
        return element.getPath().substring(0, element.getPath().lastIndexOf(".")) + "." + element.getName();
    }

    private HierarchicalTableGenerator.Cell generateDescription(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Row row, ElementDefinition definition, ElementDefinition fallback, boolean used, String baseURL, String url, StructureDefinition profile, String corePath) throws IOException {
        HierarchicalTableGenerator.Cell c = new HierarchicalTableGenerator.Cell(gen);
        row.getCells().add(c);
        if (used) {
            if (definition.getPath().endsWith("url") && definition.hasFixed()) {
                List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                Type type = definition.getFixed();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "\"" + this.buildJson(definition.getFixed()) + "\"", null).addStyle("color: darkgreen")));
            } else {
                if (definition != null && definition.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    StringType stringType = definition.getShortElement();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(stringType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, definition.getShort(), null)));
                } else if (fallback != null && fallback != null && fallback.hasShort()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    StringType stringType = fallback.getShortElement();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    c.addPiece(this.checkForNoChange(stringType, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, fallback.getShort(), null)));
                }
                if (url != null) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    String fullUrl = url.startsWith("#") ? baseURL + url : url;
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    String ref = ed == null ? null : corePath + ed.getUserData("path");
                    List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "URL: ", null).addStyle("font-weight:bold"));
                    List<HierarchicalTableGenerator.Piece> list2 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator2);
                    list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, ref, fullUrl, null));
                }
                if (definition.hasSlicing()) {
                    if (!c.getPieces().isEmpty()) {
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                    }
                    List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator);
                    list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Slice: ", null).addStyle("font-weight:bold"));
                    List<HierarchicalTableGenerator.Piece> list3 = c.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, this.describeSlice(definition.getSlicing()), null));
                }
                if (definition != null) {
                    if (definition.hasBinding()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        ProfileKnowledgeProvider.BindingResolution br = this.pkp.resolveBinding(definition.getBinding());
                        List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                        ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent = definition.getBinding();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(elementDefinitionBindingComponent, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Binding: ", null).addStyle("font-weight:bold")));
                        List<HierarchicalTableGenerator.Piece> list4 = c.getPieces();
                        ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent2 = definition.getBinding();
                        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator4);
                        list4.add(this.checkForNoChange(elementDefinitionBindingComponent2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, br.url == null ? null : (Utilities.isAbsoluteUrl(br.url) ? br.url : corePath + br.url), br.display, null)));
                        if (definition.getBinding().hasStrength()) {
                            List<HierarchicalTableGenerator.Piece> list5 = c.getPieces();
                            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent3 = definition.getBinding();
                            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator5);
                            list5.add(this.checkForNoChange(elementDefinitionBindingComponent3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, " (", null)));
                            List<HierarchicalTableGenerator.Piece> list6 = c.getPieces();
                            ElementDefinition.ElementDefinitionBindingComponent elementDefinitionBindingComponent4 = definition.getBinding();
                            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator6);
                            list6.add(this.checkForNoChange(elementDefinitionBindingComponent4, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, corePath + "terminologies.html#" + definition.getBinding().getStrength().toCode(), definition.getBinding().getStrength().toCode(), definition.getBinding().getStrength().getDefinition())));
                            List<HierarchicalTableGenerator.Piece> list7 = c.getPieces();
                            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator7);
                            list7.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, null, ")", null));
                        }
                    }
                    for (ElementDefinition.ElementDefinitionConstraintComponent inv : definition.getConstraint()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, inv.getKey() + ": ", null).addStyle("font-weight:bold")));
                        List<HierarchicalTableGenerator.Piece> list8 = c.getPieces();
                        HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator8);
                        list8.add(this.checkForNoChange(inv, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, inv.getHuman(), null)));
                    }
                    if (definition.hasFixed()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                        Type type = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Fixed Value: ", null).addStyle("font-weight:bold")));
                        List<HierarchicalTableGenerator.Piece> list9 = c.getPieces();
                        Type type2 = definition.getFixed();
                        HierarchicalTableGenerator hierarchicalTableGenerator9 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator9);
                        list9.add(this.checkForNoChange(type2, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator9, null, this.buildJson(definition.getFixed()), null).addStyle("color: darkgreen")));
                    } else if (definition.hasPattern()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                        Type type = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Required Pattern: ", null).addStyle("font-weight:bold")));
                        List<HierarchicalTableGenerator.Piece> list10 = c.getPieces();
                        Type type3 = definition.getPattern();
                        HierarchicalTableGenerator hierarchicalTableGenerator10 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator10);
                        list10.add(this.checkForNoChange(type3, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator10, null, this.buildJson(definition.getPattern()), null).addStyle("color: darkgreen")));
                    } else if (definition.hasExample()) {
                        if (!c.getPieces().isEmpty()) {
                            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                            Objects.requireNonNull(hierarchicalTableGenerator);
                            c.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
                        }
                        List<HierarchicalTableGenerator.Piece> list = c.getPieces();
                        Type type = definition.getExample();
                        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator);
                        list.add(this.checkForNoChange(type, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "Example: ", null).addStyle("font-weight:bold")));
                        List<HierarchicalTableGenerator.Piece> list11 = c.getPieces();
                        Type type4 = definition.getExample();
                        HierarchicalTableGenerator hierarchicalTableGenerator11 = gen;
                        Objects.requireNonNull(hierarchicalTableGenerator11);
                        list11.add(this.checkForNoChange(type4, new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator11, null, this.buildJson(definition.getExample()), null).addStyle("color: darkgreen")));
                    }
                }
            }
        }
        return c;
    }

    private String buildJson(Type value) throws IOException {
        if (value instanceof PrimitiveType) {
            return ((PrimitiveType)value).asStringValue();
        }
        IParser json = this.context.newJsonParser();
        return json.composeString(value, null);
    }

    public String describeSlice(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        return (slicing.getOrdered() ? "Ordered, " : "Unordered, ") + this.describe(slicing.getRules()) + ", by " + this.commas(slicing.getDiscriminator());
    }

    private String commas(List<StringType> discriminator) {
        CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
        for (StringType id : discriminator) {
            c.append(id.asStringValue());
        }
        return c.toString();
    }

    private String describe(ElementDefinition.SlicingRules rules) {
        switch (rules) {
            case CLOSED: {
                return "Closed";
            }
            case OPEN: {
                return "Open";
            }
            case OPENATEND: {
                return "Open At End";
            }
        }
        return "??";
    }

    private boolean onlyInformationIsMapping(List<ElementDefinition> list, ElementDefinition e) {
        return !e.hasName() && !e.hasSlicing() && this.onlyInformationIsMapping(e) && this.getChildren(list, e).isEmpty();
    }

    private boolean onlyInformationIsMapping(ElementDefinition d) {
        return !d.hasShort() && !d.hasDefinition() && !d.hasRequirements() && !d.getAlias().isEmpty() && !d.hasMinElement() && !d.hasMax() && !d.getType().isEmpty() && !d.hasNameReference() && !d.hasExample() && !d.hasFixed() && !d.hasMaxLengthElement() && !d.getCondition().isEmpty() && !d.getConstraint().isEmpty() && !d.hasMustSupportElement() && !d.hasBinding();
    }

    private boolean allTypesAre(List<ElementDefinition.TypeRefComponent> types, String name) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (t.getCode().equals(name)) continue;
            return false;
        }
        return true;
    }

    private List<ElementDefinition> getChildren(List<ElementDefinition> all, ElementDefinition element) {
        ArrayList<ElementDefinition> result = new ArrayList<ElementDefinition>();
        for (int i = all.indexOf(element) + 1; i < all.size() && all.get(i).getPath().length() > element.getPath().length(); ++i) {
            if (!all.get(i).getPath().substring(0, element.getPath().length() + 1).equals(element.getPath() + ".") || all.get(i).getPath().substring(element.getPath().length() + 1).contains(".")) continue;
            result.add(all.get(i));
        }
        return result;
    }

    private String tail(String path) {
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    private boolean isDataType(String value) {
        return Utilities.existsInList(value, "Identifier", "HumanName", "Address", "ContactPoint", "Timing", "SimpleQuantity", "Quantity", "Attachment", "Range", "Period", "Ratio", "CodeableConcept", "Coding", "SampledData", "Age", "Distance", "Duration", "Count", "Money");
    }

    private boolean isReference(String value) {
        return value.equals("Reference");
    }

    public static boolean isPrimitive(String value) {
        return value == null || Utilities.existsInListNC(value, "boolean", "integer", "decimal", "base64Binary", "instant", "string", "date", "dateTime", "code", "oid", "uuid", "id", "uri");
    }

    public StructureDefinition getProfile(StructureDefinition source, String url) {
        String code;
        StructureDefinition profile;
        if (url.startsWith("#")) {
            profile = source;
            code = url.substring(1);
        } else {
            String[] parts = url.split("\\#");
            profile = this.context.fetchResource(StructureDefinition.class, parts[0]);
            String string = code = parts.length == 1 ? null : parts[1];
        }
        if (profile == null) {
            return null;
        }
        if (code == null) {
            return profile;
        }
        for (Resource r : profile.getContained()) {
            if (!(r instanceof StructureDefinition) || !r.getId().equals(code)) continue;
            return (StructureDefinition)r;
        }
        return null;
    }

    public void sortDifferential(StructureDefinition base, StructureDefinition diff, String name, List<String> errors) {
        List<ElementDefinition> diffList = diff.getDifferential().getElement();
        ElementDefinitionHolder edh = new ElementDefinitionHolder(diffList.get(0));
        boolean hasSlicing = false;
        ArrayList<String> paths = new ArrayList<String>();
        for (ElementDefinition elt : diffList) {
            if (elt.hasSlicing() || paths.contains(elt.getPath())) {
                hasSlicing = true;
                break;
            }
            paths.add(elt.getPath());
        }
        if (!hasSlicing) {
            Collections.sort(diffList, new ElementNameCompare());
        }
        int i = 1;
        this.processElementsIntoTree(edh, i, diff.getDifferential().getElement());
        ElementDefinitionComparer cmp = new ElementDefinitionComparer(true, base.getSnapshot().getElement(), "", 0, name);
        this.sortElements(edh, cmp, errors);
        diffList.clear();
        this.writeElements(edh, diffList);
    }

    private int processElementsIntoTree(ElementDefinitionHolder edh, int i, List<ElementDefinition> list) {
        String path = edh.getSelf().getPath();
        String prefix = path + ".";
        while (i < list.size() && list.get(i).getPath().startsWith(prefix)) {
            ElementDefinitionHolder child = new ElementDefinitionHolder(list.get(i));
            edh.getChildren().add(child);
            i = this.processElementsIntoTree(child, i + 1, list);
        }
        return i;
    }

    private void sortElements(ElementDefinitionHolder edh, ElementDefinitionComparer cmp, List<String> errors) {
        if (edh.getChildren().size() == 1) {
            edh.getChildren().get(0).baseIndex = cmp.find(edh.getChildren().get(0).getSelf().getPath());
        } else {
            Collections.sort(edh.getChildren(), cmp);
        }
        cmp.checkForErrors(errors);
        for (ElementDefinitionHolder child : edh.getChildren()) {
            ElementDefinitionComparer ccmp;
            if (child.getChildren().size() <= 0) continue;
            ElementDefinition ed = (ElementDefinition)cmp.snapshot.get(child.getBaseIndex());
            if (ed.getType().isEmpty() || this.isAbstract(ed.getType().get(0).getCode()) || ed.getType().get(0).getCode().equals(ed.getPath())) {
                ccmp = new ElementDefinitionComparer(true, cmp.snapshot, cmp.base, cmp.prefixLength, cmp.name);
            } else if (ed.getType().get(0).getCode().equals("Extension") && child.getSelf().getType().size() == 1 && child.getSelf().getType().get(0).hasProfile()) {
                ccmp = new ElementDefinitionComparer(true, this.context.fetchResource(StructureDefinition.class, (String)child.getSelf().getType().get(0).getProfile().get(0).getValue()).getSnapshot().getElement(), ed.getType().get(0).getCode(), child.getSelf().getPath().length(), cmp.name);
            } else if (ed.getType().size() == 1 && !ed.getType().get(0).getCode().equals("*")) {
                ccmp = new ElementDefinitionComparer(false, this.context.fetchTypeDefinition(ed.getType().get(0).getCode()).getSnapshot().getElement(), ed.getType().get(0).getCode(), child.getSelf().getPath().length(), cmp.name);
            } else if (child.getSelf().getType().size() == 1) {
                ccmp = new ElementDefinitionComparer(false, this.context.fetchTypeDefinition(child.getSelf().getType().get(0).getCode()).getSnapshot().getElement(), child.getSelf().getType().get(0).getCode(), child.getSelf().getPath().length(), cmp.name);
            } else if (ed.getPath().endsWith("[x]") && !child.getSelf().getPath().endsWith("[x]")) {
                String p = child.getSelf().getPath().substring(ed.getPath().length() - 3);
                StructureDefinition sd = this.context.fetchTypeDefinition(p);
                if (sd == null) {
                    throw new Error("Unable to find profile " + p);
                }
                ccmp = new ElementDefinitionComparer(false, sd.getSnapshot().getElement(), p, child.getSelf().getPath().length(), cmp.name);
            } else {
                throw new Error("Not handled yet (sortElements: " + ed.getPath() + ":" + ProfileUtilities.typeCode(ed.getType()) + ")");
            }
            this.sortElements(child, ccmp, errors);
        }
    }

    private boolean isAbstract(String code) {
        return code.equals("Element") || code.equals("BackboneElement") || code.equals("Resource") || code.equals("DomainResource");
    }

    private void writeElements(ElementDefinitionHolder edh, List<ElementDefinition> list) {
        list.add(edh.getSelf());
        for (ElementDefinitionHolder child : edh.getChildren()) {
            this.writeElements(child, list);
        }
    }

    public void generateSchematrons(OutputStream dest, StructureDefinition structure) throws IOException, DefinitionException {
        if (!structure.hasConstrainedType()) {
            throw new DefinitionException("not the right kind of structure to generate schematrons for (" + structure.getUrl() + ")");
        }
        if (!structure.hasSnapshot()) {
            throw new DefinitionException("needs a snapshot for (" + structure.getUrl() + ")");
        }
        StructureDefinition base = this.context.fetchResource(StructureDefinition.class, structure.getBase());
        SchematronWriter sch = new SchematronWriter(dest, SchematronWriter.SchematronType.PROFILE, base.getName());
        ElementDefinition ed = structure.getSnapshot().getElement().get(0);
        this.generateForChildren(sch, "f:" + ed.getPath(), ed, structure, base);
        sch.dump();
    }

    private Slicer generateSlicer(ElementDefinition child, ElementDefinition.ElementDefinitionSlicingComponent slicing, StructureDefinition structure) {
        if (child.getPath().endsWith(".extension")) {
            ElementDefinition ued = this.getUrlFor(structure, child);
            if (!(ued != null && ued.hasFixed() || child.getType().get(0).hasProfile())) {
                return new Slicer(false);
            }
            Slicer s2 = new Slicer(true);
            String url = ued == null || !ued.hasFixed() ? child.getType().get(0).getProfile().get(0).asStringValue() : ((UriType)ued.getFixed()).asStringValue();
            s2.name = " with URL = '" + url + "'";
            s2.criteria = "[@url = '" + url + "']";
            return s2;
        }
        return new Slicer(false);
    }

    private void generateForChildren(SchematronWriter sch, String xpath, ElementDefinition ed, StructureDefinition structure, StructureDefinition base) throws IOException {
        String name;
        List<ElementDefinition> children = ProfileUtilities.getChildList(structure, ed);
        String sliceName = null;
        ElementDefinition.ElementDefinitionSlicingComponent slicing = null;
        for (ElementDefinition child : children) {
            Slicer slicer;
            name = this.tail(child.getPath());
            if (child.hasSlicing()) {
                sliceName = name;
                slicing = child.getSlicing();
            } else if (!name.equals(sliceName)) {
                slicing = null;
            }
            ElementDefinition based = this.getByPath(base, child.getPath());
            boolean doMin = child.getMin() > 0 && (based == null || child.getMin() != based.getMin());
            boolean doMax = !child.getMax().equals("*") && (based == null || !child.getMax().equals(based.getMax()));
            Slicer slicer2 = slicer = slicing == null ? new Slicer(true) : this.generateSlicer(child, slicing, structure);
            if (!slicer.check || !doMin && !doMax) continue;
            SchematronWriter.Section s2 = sch.section(xpath);
            SchematronWriter.Rule r = s2.rule(xpath);
            if (doMin) {
                r.assrt("count(f:" + name + slicer.criteria + ") >= " + Integer.toString(child.getMin()), name + slicer.name + ": minimum cardinality of '" + name + "' is " + Integer.toString(child.getMin()));
            }
            if (!doMax) continue;
            r.assrt("count(f:" + name + slicer.criteria + ") <= " + child.getMax(), name + slicer.name + ": maximum cardinality of '" + name + "' is " + child.getMax());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            if (!inv.hasXpath()) continue;
            SchematronWriter.Section s3 = sch.section(ed.getPath());
            SchematronWriter.Rule r = s3.rule(xpath);
            r.assrt(inv.getXpath(), (inv.hasId() ? inv.getId() + ": " : "") + inv.getHuman() + (inv.hasUserData(IS_DERIVED) ? " (inherited)" : ""));
        }
        for (ElementDefinition child : children) {
            name = this.tail(child.getPath());
            this.generateForChildren(sch, xpath + "/f:" + name, child, structure, base);
        }
    }

    private ElementDefinition getByPath(StructureDefinition base, String path) {
        for (ElementDefinition ed : base.getSnapshot().getElement()) {
            if (ed.getPath().equals(path)) {
                return ed;
            }
            if (!ed.getPath().endsWith("[x]") || ed.getPath().length() > path.length() - 3 || !ed.getPath().substring(0, ed.getPath().length() - 3).equals(path.substring(0, ed.getPath().length() - 3))) continue;
            return ed;
        }
        return null;
    }

    private class Slicer
    extends ElementDefinition.ElementDefinitionSlicingComponent {
        String criteria = "";
        String name = "";
        boolean check;

        public Slicer(boolean cantCheck) {
            this.check = cantCheck;
        }
    }

    private static class ElementNameCompare
    implements Comparator<ElementDefinition> {
        private ElementNameCompare() {
        }

        @Override
        public int compare(ElementDefinition o1, ElementDefinition o2) {
            String path2;
            String path1 = ElementNameCompare.normalizePath(o1);
            int cmp = path1.compareTo(path2 = ElementNameCompare.normalizePath(o2));
            if (cmp == 0) {
                String name1 = o1.hasName() ? o1.getName() : "";
                String name2 = o2.hasName() ? o2.getName() : "";
                cmp = name1.compareTo(name2);
            }
            return cmp;
        }

        private static String normalizePath(ElementDefinition e) {
            if (!e.hasPath()) {
                return "";
            }
            String path = e.getPath();
            if (path.endsWith("[x]")) {
                path = path.substring(0, path.length() - 3);
            }
            return path;
        }
    }

    public static class ElementDefinitionComparer
    implements Comparator<ElementDefinitionHolder> {
        private boolean inExtension;
        private List<ElementDefinition> snapshot;
        private int prefixLength;
        private String base;
        private String name;
        private Set<String> errors = new HashSet<String>();

        public ElementDefinitionComparer(boolean inExtension, List<ElementDefinition> snapshot, String base, int prefixLength, String name) {
            this.inExtension = inExtension;
            this.snapshot = snapshot;
            this.prefixLength = prefixLength;
            this.base = base;
            this.name = name;
        }

        @Override
        public int compare(ElementDefinitionHolder o1, ElementDefinitionHolder o2) {
            if (o1.getBaseIndex() == 0) {
                o1.setBaseIndex(this.find(o1.getSelf().getPath()));
            }
            if (o2.getBaseIndex() == 0) {
                o2.setBaseIndex(this.find(o2.getSelf().getPath()));
            }
            return o1.getBaseIndex() - o2.getBaseIndex();
        }

        private int find(String path) {
            String actual = this.base + path.substring(this.prefixLength);
            for (int i = 0; i < this.snapshot.size(); ++i) {
                String p = this.snapshot.get(i).getPath();
                if (p.equals(actual)) {
                    return i;
                }
                if (!p.endsWith("[x]") || !actual.startsWith(p.substring(0, p.length() - 3)) || actual.endsWith("[x]") || actual.substring(p.length() - 3).contains(".")) continue;
                return i;
            }
            if (this.prefixLength == 0) {
                this.errors.add("Differential contains path " + path + " which is not found in the base");
            } else {
                this.errors.add("Differential contains path " + path + " which is actually " + actual + ", which is not found in the base");
            }
            return 0;
        }

        public void checkForErrors(List<String> errorList) {
            if (this.errors.size() > 0) {
                for (String s2 : this.errors) {
                    if (s2.startsWith("!")) {
                        errorList.add("!StructureDefinition " + this.name + ": " + s2.substring(1));
                        continue;
                    }
                    errorList.add("StructureDefinition " + this.name + ": " + s2);
                }
            }
        }
    }

    public static class ElementDefinitionHolder {
        private String name;
        private ElementDefinition self;
        private int baseIndex = 0;
        private List<ElementDefinitionHolder> children;

        public ElementDefinitionHolder(ElementDefinition self) {
            this.self = self;
            this.name = self.getPath();
            this.children = new ArrayList<ElementDefinitionHolder>();
        }

        public ElementDefinition getSelf() {
            return this.self;
        }

        public List<ElementDefinitionHolder> getChildren() {
            return this.children;
        }

        public int getBaseIndex() {
            return this.baseIndex;
        }

        public void setBaseIndex(int baseIndex) {
            this.baseIndex = baseIndex;
        }
    }

    public static interface ProfileKnowledgeProvider {
        public boolean isDatatype(String var1);

        public boolean isResource(String var1);

        public boolean hasLinkFor(String var1);

        public String getLinkFor(String var1);

        public BindingResolution resolveBinding(ElementDefinition.ElementDefinitionBindingComponent var1);

        public String getLinkForProfile(StructureDefinition var1, String var2);

        public static class BindingResolution {
            public String display;
            public String url;
        }
    }

    private class UnusedTracker {
        private boolean used;

        private UnusedTracker() {
        }
    }

    public class ExtensionContext {
        private ElementDefinition element;
        private StructureDefinition defn;

        public ExtensionContext(StructureDefinition ext, ElementDefinition ed) {
            this.defn = ext;
            this.element = ed;
        }

        public ElementDefinition getElement() {
            return this.element;
        }

        public StructureDefinition getDefn() {
            return this.defn;
        }

        public String getUrl() {
            if (this.element == this.defn.getSnapshot().getElement().get(0)) {
                return this.defn.getUrl();
            }
            return this.element.getName();
        }

        public ElementDefinition getExtensionValueDefinition() {
            for (int i = this.defn.getSnapshot().getElement().indexOf(this.element) + 1; i < this.defn.getSnapshot().getElement().size(); ++i) {
                ElementDefinition ed = this.defn.getSnapshot().getElement().get(i);
                if (ed.getPath().equals(this.element.getPath())) {
                    return null;
                }
                if (!ed.getPath().startsWith(this.element.getPath() + ".value")) continue;
                return ed;
            }
            return null;
        }
    }
}

