/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Money;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.ProcessRequest;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PaymentReconciliation", profile="http://hl7.org/fhir/Profile/PaymentReconciliation")
public class PaymentReconciliation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="request", type={ProcessRequest.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Claim reference", formalDefinition="Original request resource reference.")
    protected Reference request;
    protected ProcessRequest requestTarget;
    @Child(name="outcome", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="complete | error", formalDefinition="Transaction status: error, complete.")
    protected Enumeration<Enumerations.RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="ruleset", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="period", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period covered", formalDefinition="The period of time for which payments have been gathered into this bulk payment for settlement.")
    protected Period period;
    @Child(name="organization", type={Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="requestProvider", type={Practitioner.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    protected Practitioner requestProviderTarget;
    @Child(name="requestOrganization", type={Organization.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference requestOrganization;
    protected Organization requestOrganizationTarget;
    @Child(name="detail", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Details", formalDefinition="List of individual settlement amounts and the corresponding transaction.")
    protected List<DetailsComponent> detail;
    @Child(name="form", type={Coding.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    protected Coding form;
    @Child(name="total", type={Money.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total amount of Payment", formalDefinition="Total payment amount.")
    protected Money total;
    @Child(name="note", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Note text", formalDefinition="Suite of notes.")
    protected List<NotesComponent> note;
    private static final long serialVersionUID = 454328025L;
    @SearchParamDefinition(name="identifier", path="PaymentReconciliation.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";

    public PaymentReconciliation() {
    }

    public PaymentReconciliation(Money total) {
        this.total = total;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentReconciliation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentReconciliation setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public ProcessRequest getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new ProcessRequest();
            }
        }
        return this.requestTarget;
    }

    public PaymentReconciliation setRequestTarget(ProcessRequest value) {
        this.requestTarget = value;
        return this;
    }

    public Enumeration<Enumerations.RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public PaymentReconciliation setOutcomeElement(Enumeration<Enumerations.RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (Enumerations.RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public PaymentReconciliation setOutcome(Enumerations.RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public PaymentReconciliation setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public PaymentReconciliation setDisposition(String value) {
        if (Utilities.noString(value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public PaymentReconciliation setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public PaymentReconciliation setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentReconciliation setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentReconciliation setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public PaymentReconciliation setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public PaymentReconciliation setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public PaymentReconciliation setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public PaymentReconciliation setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    public Practitioner getRequestProviderTarget() {
        if (this.requestProviderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProviderTarget = new Practitioner();
            }
        }
        return this.requestProviderTarget;
    }

    public PaymentReconciliation setRequestProviderTarget(Practitioner value) {
        this.requestProviderTarget = value;
        return this;
    }

    public Reference getRequestOrganization() {
        if (this.requestOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganization = new Reference();
            }
        }
        return this.requestOrganization;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public PaymentReconciliation setRequestOrganization(Reference value) {
        this.requestOrganization = value;
        return this;
    }

    public Organization getRequestOrganizationTarget() {
        if (this.requestOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganizationTarget = new Organization();
            }
        }
        return this.requestOrganizationTarget;
    }

    public PaymentReconciliation setRequestOrganizationTarget(Organization value) {
        this.requestOrganizationTarget = value;
        return this;
    }

    public List<DetailsComponent> getDetail() {
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        return this.detail;
    }

    public boolean hasDetail() {
        if (this.detail == null) {
            return false;
        }
        for (DetailsComponent item : this.detail) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetailsComponent addDetail() {
        DetailsComponent t = new DetailsComponent();
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        this.detail.add(t);
        return t;
    }

    public PaymentReconciliation addDetail(DetailsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        this.detail.add(t);
        return this;
    }

    public Coding getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new Coding();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public PaymentReconciliation setForm(Coding value) {
        this.form = value;
        return this;
    }

    public Money getTotal() {
        if (this.total == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.total");
            }
            if (Configuration.doAutoCreate()) {
                this.total = new Money();
            }
        }
        return this.total;
    }

    public boolean hasTotal() {
        return this.total != null && !this.total.isEmpty();
    }

    public PaymentReconciliation setTotal(Money value) {
        this.total = value;
        return this;
    }

    public List<NotesComponent> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (NotesComponent item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NotesComponent addNote() {
        NotesComponent t = new NotesComponent();
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return t;
    }

    public PaymentReconciliation addNote(NotesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("request", "Reference(ProcessRequest)", "Original request resource reference.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property("outcome", "code", "Transaction status: error, complete.", 0, Integer.MAX_VALUE, this.outcome));
        childrenList.add(new Property("disposition", "string", "A description of the status of the adjudication.", 0, Integer.MAX_VALUE, this.disposition));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("period", "Period", "The period of time for which payments have been gathered into this bulk payment for settlement.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("organization", "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestProvider));
        childrenList.add(new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestOrganization));
        childrenList.add(new Property("detail", "", "List of individual settlement amounts and the corresponding transaction.", 0, Integer.MAX_VALUE, this.detail));
        childrenList.add(new Property("form", "Coding", "The form to be used for printing the content.", 0, Integer.MAX_VALUE, this.form));
        childrenList.add(new Property("total", "Money", "Total payment amount.", 0, Integer.MAX_VALUE, this.total));
        childrenList.add(new Property("note", "", "Suite of notes.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("request")) {
            this.request = this.castToReference(value);
        } else if (name.equals("outcome")) {
            this.outcome = new Enumerations.RemittanceOutcomeEnumFactory().fromType(value);
        } else if (name.equals("disposition")) {
            this.disposition = this.castToString(value);
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("organization")) {
            this.organization = this.castToReference(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = this.castToReference(value);
        } else if (name.equals("requestOrganization")) {
            this.requestOrganization = this.castToReference(value);
        } else if (name.equals("detail")) {
            this.getDetail().add((DetailsComponent)value);
        } else if (name.equals("form")) {
            this.form = this.castToCoding(value);
        } else if (name.equals("total")) {
            this.total = this.castToMoney(value);
        } else if (name.equals("note")) {
            this.getNote().add((NotesComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("request")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("outcome")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.outcome");
        }
        if (name.equals("disposition")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.disposition");
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.created");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganization")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals("detail")) {
            return this.addDetail();
        }
        if (name.equals("form")) {
            this.form = new Coding();
            return this.form;
        }
        if (name.equals("total")) {
            this.total = new Money();
            return this.total;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentReconciliation";
    }

    @Override
    public PaymentReconciliation copy() {
        PaymentReconciliation dst = new PaymentReconciliation();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        Reference reference = dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        if (this.detail != null) {
            dst.detail = new ArrayList<DetailsComponent>();
            for (DetailsComponent detailsComponent : this.detail) {
                dst.detail.add(detailsComponent.copy());
            }
        }
        dst.form = this.form == null ? null : this.form.copy();
        Money money = dst.total = this.total == null ? null : this.total.copy();
        if (this.note != null) {
            dst.note = new ArrayList<NotesComponent>();
            for (NotesComponent notesComponent : this.note) {
                dst.note.add(notesComponent.copy());
            }
        }
        return dst;
    }

    protected PaymentReconciliation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other;
        return PaymentReconciliation.compareDeep(this.identifier, o.identifier, true) && PaymentReconciliation.compareDeep(this.request, o.request, true) && PaymentReconciliation.compareDeep(this.outcome, o.outcome, true) && PaymentReconciliation.compareDeep(this.disposition, o.disposition, true) && PaymentReconciliation.compareDeep(this.ruleset, o.ruleset, true) && PaymentReconciliation.compareDeep(this.originalRuleset, o.originalRuleset, true) && PaymentReconciliation.compareDeep(this.created, o.created, true) && PaymentReconciliation.compareDeep(this.period, o.period, true) && PaymentReconciliation.compareDeep(this.organization, o.organization, true) && PaymentReconciliation.compareDeep(this.requestProvider, o.requestProvider, true) && PaymentReconciliation.compareDeep(this.requestOrganization, o.requestOrganization, true) && PaymentReconciliation.compareDeep(this.detail, o.detail, true) && PaymentReconciliation.compareDeep(this.form, o.form, true) && PaymentReconciliation.compareDeep(this.total, o.total, true) && PaymentReconciliation.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other;
        return PaymentReconciliation.compareValues(this.outcome, o.outcome, true) && PaymentReconciliation.compareValues(this.disposition, o.disposition, true) && PaymentReconciliation.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.request != null && !this.request.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.disposition != null && !this.disposition.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.period != null && !this.period.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.requestProvider != null && !this.requestProvider.isEmpty() || this.requestOrganization != null && !this.requestOrganization.isEmpty() || this.detail != null && !this.detail.isEmpty() || this.form != null && !this.form.isEmpty() || this.total != null && !this.total.isEmpty() || this.note != null && !this.note.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentReconciliation;
    }

    @Block
    public static class NotesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        protected Coding type;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Notes text", formalDefinition="The note text.")
        protected StringType text;
        private static final long serialVersionUID = 129959202L;

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NotesComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NotesComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NotesComponent setText(String value) {
            if (Utilities.noString(value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "The note purpose: Print/Display.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("text", "string", "The note text.", 0, Integer.MAX_VALUE, this.text));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.text");
            }
            return super.addChild(name);
        }

        @Override
        public NotesComponent copy() {
            NotesComponent dst = new NotesComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareDeep(this.type, o.type, true) && NotesComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.text != null && !this.text.isEmpty());
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.note";
        }
    }

    @Block
    public static class DetailsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type code", formalDefinition="Code to indicate the nature of the payment, adjustment, funds advance, etc.")
        protected Coding type;
        @Child(name="request", type={}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Claim", formalDefinition="The claim or financial resource.")
        protected Reference request;
        protected Resource requestTarget;
        @Child(name="responce", type={}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Claim Response", formalDefinition="The claim response resource.")
        protected Reference responce;
        protected Resource responceTarget;
        @Child(name="submitter", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Submitter", formalDefinition="The Organization which submitted the invoice or financial transaction.")
        protected Reference submitter;
        protected Organization submitterTarget;
        @Child(name="payee", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Payee", formalDefinition="The organization which is receiving the payment.")
        protected Reference payee;
        protected Organization payeeTarget;
        @Child(name="date", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Invoice date", formalDefinition="The date of the invoice or financial resource.")
        protected DateType date;
        @Child(name="amount", type={Money.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Detail amount", formalDefinition="Amount paid for this detail.")
        protected Money amount;
        private static final long serialVersionUID = -1644048062L;

        public DetailsComponent() {
        }

        public DetailsComponent(Coding type) {
            this.type = type;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DetailsComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Reference getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new Reference();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public DetailsComponent setRequest(Reference value) {
            this.request = value;
            return this;
        }

        public Resource getRequestTarget() {
            return this.requestTarget;
        }

        public DetailsComponent setRequestTarget(Resource value) {
            this.requestTarget = value;
            return this;
        }

        public Reference getResponce() {
            if (this.responce == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.responce");
                }
                if (Configuration.doAutoCreate()) {
                    this.responce = new Reference();
                }
            }
            return this.responce;
        }

        public boolean hasResponce() {
            return this.responce != null && !this.responce.isEmpty();
        }

        public DetailsComponent setResponce(Reference value) {
            this.responce = value;
            return this;
        }

        public Resource getResponceTarget() {
            return this.responceTarget;
        }

        public DetailsComponent setResponceTarget(Resource value) {
            this.responceTarget = value;
            return this;
        }

        public Reference getSubmitter() {
            if (this.submitter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.submitter");
                }
                if (Configuration.doAutoCreate()) {
                    this.submitter = new Reference();
                }
            }
            return this.submitter;
        }

        public boolean hasSubmitter() {
            return this.submitter != null && !this.submitter.isEmpty();
        }

        public DetailsComponent setSubmitter(Reference value) {
            this.submitter = value;
            return this;
        }

        public Organization getSubmitterTarget() {
            if (this.submitterTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.submitter");
                }
                if (Configuration.doAutoCreate()) {
                    this.submitterTarget = new Organization();
                }
            }
            return this.submitterTarget;
        }

        public DetailsComponent setSubmitterTarget(Organization value) {
            this.submitterTarget = value;
            return this;
        }

        public Reference getPayee() {
            if (this.payee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.payee");
                }
                if (Configuration.doAutoCreate()) {
                    this.payee = new Reference();
                }
            }
            return this.payee;
        }

        public boolean hasPayee() {
            return this.payee != null && !this.payee.isEmpty();
        }

        public DetailsComponent setPayee(Reference value) {
            this.payee = value;
            return this;
        }

        public Organization getPayeeTarget() {
            if (this.payeeTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.payee");
                }
                if (Configuration.doAutoCreate()) {
                    this.payeeTarget = new Organization();
                }
            }
            return this.payeeTarget;
        }

        public DetailsComponent setPayeeTarget(Organization value) {
            this.payeeTarget = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public DetailsComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public DetailsComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public DetailsComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Code to indicate the nature of the payment, adjustment, funds advance, etc.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("request", "Reference(Any)", "The claim or financial resource.", 0, Integer.MAX_VALUE, this.request));
            childrenList.add(new Property("responce", "Reference(Any)", "The claim response resource.", 0, Integer.MAX_VALUE, this.responce));
            childrenList.add(new Property("submitter", "Reference(Organization)", "The Organization which submitted the invoice or financial transaction.", 0, Integer.MAX_VALUE, this.submitter));
            childrenList.add(new Property("payee", "Reference(Organization)", "The organization which is receiving the payment.", 0, Integer.MAX_VALUE, this.payee));
            childrenList.add(new Property("date", "date", "The date of the invoice or financial resource.", 0, Integer.MAX_VALUE, this.date));
            childrenList.add(new Property("amount", "Money", "Amount paid for this detail.", 0, Integer.MAX_VALUE, this.amount));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("request")) {
                this.request = this.castToReference(value);
            } else if (name.equals("responce")) {
                this.responce = this.castToReference(value);
            } else if (name.equals("submitter")) {
                this.submitter = this.castToReference(value);
            } else if (name.equals("payee")) {
                this.payee = this.castToReference(value);
            } else if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("request")) {
                this.request = new Reference();
                return this.request;
            }
            if (name.equals("responce")) {
                this.responce = new Reference();
                return this.responce;
            }
            if (name.equals("submitter")) {
                this.submitter = new Reference();
                return this.submitter;
            }
            if (name.equals("payee")) {
                this.payee = new Reference();
                return this.payee;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.date");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public DetailsComponent copy() {
            DetailsComponent dst = new DetailsComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.responce = this.responce == null ? null : this.responce.copy();
            dst.submitter = this.submitter == null ? null : this.submitter.copy();
            dst.payee = this.payee == null ? null : this.payee.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other;
            return DetailsComponent.compareDeep(this.type, o.type, true) && DetailsComponent.compareDeep(this.request, o.request, true) && DetailsComponent.compareDeep(this.responce, o.responce, true) && DetailsComponent.compareDeep(this.submitter, o.submitter, true) && DetailsComponent.compareDeep(this.payee, o.payee, true) && DetailsComponent.compareDeep(this.date, o.date, true) && DetailsComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other;
            return DetailsComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.request != null && !this.request.isEmpty() || this.responce != null && !this.responce.isEmpty() || this.submitter != null && !this.submitter.isEmpty() || this.payee != null && !this.payee.isEmpty() || this.date != null && !this.date.isEmpty() || this.amount != null && !this.amount.isEmpty());
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.detail";
        }
    }
}

