/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Location", profile="http://hl7.org/fhir/Profile/Location")
public class Location
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique code or number identifying the location to its users", formalDefinition="Unique code or number identifying the location to its users.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | suspended | inactive", formalDefinition="active | suspended | inactive.")
    protected Enumeration<LocationStatus> status;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the location as used by humans", formalDefinition="Name of the location as used by humans. Does not need to be unique.")
    protected StringType name;
    @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of the location", formalDefinition="Description of the Location, which helps in finding or referencing the place.")
    protected StringType description;
    @Child(name="mode", type={CodeType.class}, order=4, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="instance | kind", formalDefinition="Indicates whether a resource instance represents a specific location or a class of locations.")
    protected Enumeration<LocationMode> mode;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of function performed", formalDefinition="Indicates the type of function performed at the location.")
    protected CodeableConcept type;
    @Child(name="telecom", type={ContactPoint.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact details of the location", formalDefinition="The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.")
    protected List<ContactPoint> telecom;
    @Child(name="address", type={Address.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Physical location", formalDefinition="Physical location.")
    protected Address address;
    @Child(name="physicalType", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Physical form of the location", formalDefinition="Physical form of the location, e.g. building, room, vehicle, road.")
    protected CodeableConcept physicalType;
    @Child(name="position", type={}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The absolute geographic location", formalDefinition="The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML).")
    protected LocationPositionComponent position;
    @Child(name="managingOrganization", type={Organization.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization responsible for provisioning and upkeep", formalDefinition="The organization responsible for the provisioning and upkeep of the location.")
    protected Reference managingOrganization;
    protected Organization managingOrganizationTarget;
    @Child(name="partOf", type={Location.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Another Location this one is physically part of", formalDefinition="Another Location which this Location is physically part of.")
    protected Reference partOf;
    protected Location partOfTarget;
    private static final long serialVersionUID = -2100435761L;
    @SearchParamDefinition(name="identifier", path="Location.identifier", description="Unique code or number identifying the location to its users", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="partof", path="Location.partOf", description="The location of which this location is a part", type="reference")
    public static final String SP_PARTOF = "partof";
    @SearchParamDefinition(name="near-distance", path="Location.position", description="A distance quantity to limit the near search to locations within a specific distance", type="token")
    public static final String SP_NEARDISTANCE = "near-distance";
    @SearchParamDefinition(name="address", path="Location.address", description="A (part of the) address of the location", type="string")
    public static final String SP_ADDRESS = "address";
    @SearchParamDefinition(name="address-state", path="Location.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESSSTATE = "address-state";
    @SearchParamDefinition(name="type", path="Location.type", description="A code for the type of location", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="address-postalcode", path="Location.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESSPOSTALCODE = "address-postalcode";
    @SearchParamDefinition(name="address-country", path="Location.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESSCOUNTRY = "address-country";
    @SearchParamDefinition(name="organization", path="Location.managingOrganization", description="Searches for locations that are managed by the provided organization", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    @SearchParamDefinition(name="name", path="Location.name", description="A (portion of the) name of the location", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="address-use", path="Location.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESSUSE = "address-use";
    @SearchParamDefinition(name="near", path="Location.position", description="The coordinates expressed as [lat],[long] (using the WGS84 datum, see notes) to find locations near to (servers may search using a square rather than a circle for efficiency)", type="token")
    public static final String SP_NEAR = "near";
    @SearchParamDefinition(name="address-city", path="Location.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESSCITY = "address-city";
    @SearchParamDefinition(name="status", path="Location.status", description="Searches for locations with a specific kind of status", type="token")
    public static final String SP_STATUS = "status";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Location addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<LocationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<LocationStatus>(new LocationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Location setStatusElement(Enumeration<LocationStatus> value) {
        this.status = value;
        return this;
    }

    public LocationStatus getStatus() {
        return this.status == null ? null : (LocationStatus)((Object)this.status.getValue());
    }

    public Location setStatus(LocationStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<LocationStatus>(new LocationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Location setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Location setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Location setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Location setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Enumeration<LocationMode> getModeElement() {
        if (this.mode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.mode");
            }
            if (Configuration.doAutoCreate()) {
                this.mode = new Enumeration<LocationMode>(new LocationModeEnumFactory());
            }
        }
        return this.mode;
    }

    public boolean hasModeElement() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public boolean hasMode() {
        return this.mode != null && !this.mode.isEmpty();
    }

    public Location setModeElement(Enumeration<LocationMode> value) {
        this.mode = value;
        return this;
    }

    public LocationMode getMode() {
        return this.mode == null ? null : (LocationMode)((Object)this.mode.getValue());
    }

    public Location setMode(LocationMode value) {
        if (value == null) {
            this.mode = null;
        } else {
            if (this.mode == null) {
                this.mode = new Enumeration<LocationMode>(new LocationModeEnumFactory());
            }
            this.mode.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Location setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Location addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public Address getAddress() {
        if (this.address == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.address");
            }
            if (Configuration.doAutoCreate()) {
                this.address = new Address();
            }
        }
        return this.address;
    }

    public boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public Location setAddress(Address value) {
        this.address = value;
        return this;
    }

    public CodeableConcept getPhysicalType() {
        if (this.physicalType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.physicalType");
            }
            if (Configuration.doAutoCreate()) {
                this.physicalType = new CodeableConcept();
            }
        }
        return this.physicalType;
    }

    public boolean hasPhysicalType() {
        return this.physicalType != null && !this.physicalType.isEmpty();
    }

    public Location setPhysicalType(CodeableConcept value) {
        this.physicalType = value;
        return this;
    }

    public LocationPositionComponent getPosition() {
        if (this.position == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.position");
            }
            if (Configuration.doAutoCreate()) {
                this.position = new LocationPositionComponent();
            }
        }
        return this.position;
    }

    public boolean hasPosition() {
        return this.position != null && !this.position.isEmpty();
    }

    public Location setPosition(LocationPositionComponent value) {
        this.position = value;
        return this;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public Location setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        if (this.managingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganizationTarget = new Organization();
            }
        }
        return this.managingOrganizationTarget;
    }

    public Location setManagingOrganizationTarget(Organization value) {
        this.managingOrganizationTarget = value;
        return this;
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Location setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public Location getPartOfTarget() {
        if (this.partOfTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Location.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOfTarget = new Location();
            }
        }
        return this.partOfTarget;
    }

    public Location setPartOfTarget(Location value) {
        this.partOfTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Unique code or number identifying the location to its users.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "active | suspended | inactive.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_NAME, "string", "Name of the location as used by humans. Does not need to be unique.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("description", "string", "Description of the Location, which helps in finding or referencing the place.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("mode", "code", "Indicates whether a resource instance represents a specific location or a class of locations.", 0, Integer.MAX_VALUE, this.mode));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Indicates the type of function performed at the location.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("telecom", "ContactPoint", "The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property(SP_ADDRESS, "Address", "Physical location.", 0, Integer.MAX_VALUE, this.address));
        childrenList.add(new Property("physicalType", "CodeableConcept", "Physical form of the location, e.g. building, room, vehicle, road.", 0, Integer.MAX_VALUE, this.physicalType));
        childrenList.add(new Property("position", "", "The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML).", 0, Integer.MAX_VALUE, this.position));
        childrenList.add(new Property("managingOrganization", "Reference(Organization)", "The organization responsible for the provisioning and upkeep of the location.", 0, Integer.MAX_VALUE, this.managingOrganization));
        childrenList.add(new Property("partOf", "Reference(Location)", "Another Location which this Location is physically part of.", 0, Integer.MAX_VALUE, this.partOf));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new LocationStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("mode")) {
            this.mode = new LocationModeEnumFactory().fromType(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_ADDRESS)) {
            this.address = this.castToAddress(value);
        } else if (name.equals("physicalType")) {
            this.physicalType = this.castToCodeableConcept(value);
        } else if (name.equals("position")) {
            this.position = (LocationPositionComponent)value;
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = this.castToReference(value);
        } else if (name.equals("partOf")) {
            this.partOf = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Location.status");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Location.name");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Location.description");
        }
        if (name.equals("mode")) {
            throw new FHIRException("Cannot call addChild on a primitive type Location.mode");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals(SP_ADDRESS)) {
            this.address = new Address();
            return this.address;
        }
        if (name.equals("physicalType")) {
            this.physicalType = new CodeableConcept();
            return this.physicalType;
        }
        if (name.equals("position")) {
            this.position = new LocationPositionComponent();
            return this.position;
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Location";
    }

    @Override
    public Location copy() {
        Location dst = new Location();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.mode = this.mode == null ? null : this.mode.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.address = this.address == null ? null : this.address.copy();
        dst.physicalType = this.physicalType == null ? null : this.physicalType.copy();
        dst.position = this.position == null ? null : this.position.copy();
        dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        dst.partOf = this.partOf == null ? null : this.partOf.copy();
        return dst;
    }

    protected Location typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location o = (Location)other;
        return Location.compareDeep(this.identifier, o.identifier, true) && Location.compareDeep(this.status, o.status, true) && Location.compareDeep(this.name, o.name, true) && Location.compareDeep(this.description, o.description, true) && Location.compareDeep(this.mode, o.mode, true) && Location.compareDeep(this.type, o.type, true) && Location.compareDeep(this.telecom, o.telecom, true) && Location.compareDeep(this.address, o.address, true) && Location.compareDeep(this.physicalType, o.physicalType, true) && Location.compareDeep(this.position, o.position, true) && Location.compareDeep(this.managingOrganization, o.managingOrganization, true) && Location.compareDeep(this.partOf, o.partOf, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location o = (Location)other;
        return Location.compareValues(this.status, o.status, true) && Location.compareValues(this.name, o.name, true) && Location.compareValues(this.description, o.description, true) && Location.compareValues(this.mode, o.mode, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.mode != null && !this.mode.isEmpty() || this.type != null && !this.type.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.address != null && !this.address.isEmpty() || this.physicalType != null && !this.physicalType.isEmpty() || this.position != null && !this.position.isEmpty() || this.managingOrganization != null && !this.managingOrganization.isEmpty() || this.partOf != null && !this.partOf.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Location;
    }

    @Block
    public static class LocationPositionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="longitude", type={DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Longitude with WGS84 datum", formalDefinition="Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below).")
        protected DecimalType longitude;
        @Child(name="latitude", type={DecimalType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Latitude with WGS84 datum", formalDefinition="Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below).")
        protected DecimalType latitude;
        @Child(name="altitude", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Altitude with WGS84 datum", formalDefinition="Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below).")
        protected DecimalType altitude;
        private static final long serialVersionUID = -74276134L;

        public LocationPositionComponent() {
        }

        public LocationPositionComponent(DecimalType longitude, DecimalType latitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public DecimalType getLongitudeElement() {
            if (this.longitude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LocationPositionComponent.longitude");
                }
                if (Configuration.doAutoCreate()) {
                    this.longitude = new DecimalType();
                }
            }
            return this.longitude;
        }

        public boolean hasLongitudeElement() {
            return this.longitude != null && !this.longitude.isEmpty();
        }

        public boolean hasLongitude() {
            return this.longitude != null && !this.longitude.isEmpty();
        }

        public LocationPositionComponent setLongitudeElement(DecimalType value) {
            this.longitude = value;
            return this;
        }

        public BigDecimal getLongitude() {
            return this.longitude == null ? null : (BigDecimal)this.longitude.getValue();
        }

        public LocationPositionComponent setLongitude(BigDecimal value) {
            if (this.longitude == null) {
                this.longitude = new DecimalType();
            }
            this.longitude.setValue(value);
            return this;
        }

        public DecimalType getLatitudeElement() {
            if (this.latitude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LocationPositionComponent.latitude");
                }
                if (Configuration.doAutoCreate()) {
                    this.latitude = new DecimalType();
                }
            }
            return this.latitude;
        }

        public boolean hasLatitudeElement() {
            return this.latitude != null && !this.latitude.isEmpty();
        }

        public boolean hasLatitude() {
            return this.latitude != null && !this.latitude.isEmpty();
        }

        public LocationPositionComponent setLatitudeElement(DecimalType value) {
            this.latitude = value;
            return this;
        }

        public BigDecimal getLatitude() {
            return this.latitude == null ? null : (BigDecimal)this.latitude.getValue();
        }

        public LocationPositionComponent setLatitude(BigDecimal value) {
            if (this.latitude == null) {
                this.latitude = new DecimalType();
            }
            this.latitude.setValue(value);
            return this;
        }

        public DecimalType getAltitudeElement() {
            if (this.altitude == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LocationPositionComponent.altitude");
                }
                if (Configuration.doAutoCreate()) {
                    this.altitude = new DecimalType();
                }
            }
            return this.altitude;
        }

        public boolean hasAltitudeElement() {
            return this.altitude != null && !this.altitude.isEmpty();
        }

        public boolean hasAltitude() {
            return this.altitude != null && !this.altitude.isEmpty();
        }

        public LocationPositionComponent setAltitudeElement(DecimalType value) {
            this.altitude = value;
            return this;
        }

        public BigDecimal getAltitude() {
            return this.altitude == null ? null : (BigDecimal)this.altitude.getValue();
        }

        public LocationPositionComponent setAltitude(BigDecimal value) {
            if (value == null) {
                this.altitude = null;
            } else {
                if (this.altitude == null) {
                    this.altitude = new DecimalType();
                }
                this.altitude.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("longitude", "decimal", "Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below).", 0, Integer.MAX_VALUE, this.longitude));
            childrenList.add(new Property("latitude", "decimal", "Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below).", 0, Integer.MAX_VALUE, this.latitude));
            childrenList.add(new Property("altitude", "decimal", "Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below).", 0, Integer.MAX_VALUE, this.altitude));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("longitude")) {
                this.longitude = this.castToDecimal(value);
            } else if (name.equals("latitude")) {
                this.latitude = this.castToDecimal(value);
            } else if (name.equals("altitude")) {
                this.altitude = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("longitude")) {
                throw new FHIRException("Cannot call addChild on a primitive type Location.longitude");
            }
            if (name.equals("latitude")) {
                throw new FHIRException("Cannot call addChild on a primitive type Location.latitude");
            }
            if (name.equals("altitude")) {
                throw new FHIRException("Cannot call addChild on a primitive type Location.altitude");
            }
            return super.addChild(name);
        }

        @Override
        public LocationPositionComponent copy() {
            LocationPositionComponent dst = new LocationPositionComponent();
            this.copyValues(dst);
            dst.longitude = this.longitude == null ? null : this.longitude.copy();
            dst.latitude = this.latitude == null ? null : this.latitude.copy();
            dst.altitude = this.altitude == null ? null : this.altitude.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof LocationPositionComponent)) {
                return false;
            }
            LocationPositionComponent o = (LocationPositionComponent)other;
            return LocationPositionComponent.compareDeep(this.longitude, o.longitude, true) && LocationPositionComponent.compareDeep(this.latitude, o.latitude, true) && LocationPositionComponent.compareDeep(this.altitude, o.altitude, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof LocationPositionComponent)) {
                return false;
            }
            LocationPositionComponent o = (LocationPositionComponent)other;
            return LocationPositionComponent.compareValues(this.longitude, o.longitude, true) && LocationPositionComponent.compareValues(this.latitude, o.latitude, true) && LocationPositionComponent.compareValues(this.altitude, o.altitude, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.longitude != null && !this.longitude.isEmpty() || this.latitude != null && !this.latitude.isEmpty() || this.altitude != null && !this.altitude.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Location.position";
        }
    }

    public static class LocationModeEnumFactory
    implements EnumFactory<LocationMode> {
        @Override
        public LocationMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return LocationMode.INSTANCE;
            }
            if ("kind".equals(codeString)) {
                return LocationMode.KIND;
            }
            throw new IllegalArgumentException("Unknown LocationMode code '" + codeString + "'");
        }

        public Enumeration<LocationMode> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return new Enumeration<LocationMode>(this, LocationMode.INSTANCE);
            }
            if ("kind".equals(codeString)) {
                return new Enumeration<LocationMode>(this, LocationMode.KIND);
            }
            throw new FHIRException("Unknown LocationMode code '" + codeString + "'");
        }

        @Override
        public String toCode(LocationMode code) {
            if (code == LocationMode.INSTANCE) {
                return "instance";
            }
            if (code == LocationMode.KIND) {
                return "kind";
            }
            return "?";
        }
    }

    public static enum LocationMode {
        INSTANCE,
        KIND,
        NULL;


        public static LocationMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("instance".equals(codeString)) {
                return INSTANCE;
            }
            if ("kind".equals(codeString)) {
                return KIND;
            }
            throw new FHIRException("Unknown LocationMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INSTANCE: {
                    return "instance";
                }
                case KIND: {
                    return "kind";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INSTANCE: {
                    return "http://hl7.org/fhir/location-mode";
                }
                case KIND: {
                    return "http://hl7.org/fhir/location-mode";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INSTANCE: {
                    return "The Location resource represents a specific instance of a location (e.g. Operating Theatre 1A).";
                }
                case KIND: {
                    return "The Location represents a class of locations (e.g. Any Operating Theatre) although this class of locations could be constrained within a specific boundary (such as organization, or parent location, address etc.).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INSTANCE: {
                    return "Instance";
                }
                case KIND: {
                    return "Kind";
                }
            }
            return "?";
        }
    }

    public static class LocationStatusEnumFactory
    implements EnumFactory<LocationStatus> {
        @Override
        public LocationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return LocationStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return LocationStatus.SUSPENDED;
            }
            if ("inactive".equals(codeString)) {
                return LocationStatus.INACTIVE;
            }
            throw new IllegalArgumentException("Unknown LocationStatus code '" + codeString + "'");
        }

        public Enumeration<LocationStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<LocationStatus>(this, LocationStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<LocationStatus>(this, LocationStatus.SUSPENDED);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<LocationStatus>(this, LocationStatus.INACTIVE);
            }
            throw new FHIRException("Unknown LocationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(LocationStatus code) {
            if (code == LocationStatus.ACTIVE) {
                return "active";
            }
            if (code == LocationStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == LocationStatus.INACTIVE) {
                return "inactive";
            }
            return "?";
        }
    }

    public static enum LocationStatus {
        ACTIVE,
        SUSPENDED,
        INACTIVE,
        NULL;


        public static LocationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            throw new FHIRException("Unknown LocationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case INACTIVE: {
                    return "inactive";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/location-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/location-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/location-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The location is operational.";
                }
                case SUSPENDED: {
                    return "The location is temporarily closed.";
                }
                case INACTIVE: {
                    return "The location is no longer used.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case INACTIVE: {
                    return "Inactive";
                }
            }
            return "?";
        }
    }
}

