/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Device", profile="http://hl7.org/fhir/Profile/Device")
public class Device
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instance id from manufacturer, owner, and others", formalDefinition="Unique instance identifiers assigned to a device by organizations like manufacturers or owners. If the identifier identifies the type of device, Device.type should be used.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What kind of device this is", formalDefinition="Code or identifier to identify a kind of device.")
    protected CodeableConcept type;
    @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device notes and comments", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    protected List<Annotation> note;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="available | not-available | entered-in-error", formalDefinition="Status of the Device availability.")
    protected Enumeration<DeviceStatus> status;
    @Child(name="manufacturer", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer.")
    protected StringType manufacturer;
    @Child(name="model", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Model id assigned by the manufacturer", formalDefinition="The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.")
    protected StringType model;
    @Child(name="version", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Version number (i.e. software)", formalDefinition="The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.")
    protected StringType version;
    @Child(name="manufactureDate", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Manufacture date", formalDefinition="The date and time when the device was manufactured.")
    protected DateTimeType manufactureDate;
    @Child(name="expiry", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date and time of expiry of this device (if applicable)", formalDefinition="The date and time beyond which this device is no longer valid or should not be used (if applicable).")
    protected DateTimeType expiry;
    @Child(name="udi", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="FDA mandated Unique Device Identifier", formalDefinition="United States Food and Drug Administration mandated Unique Device Identifier (UDI). Use the human readable information (the content that the user sees, which is sometimes different to the exact syntax represented in the barcode)  - see http://www.fda.gov/MedicalDevices/DeviceRegulationandGuidance/UniqueDeviceIdentification/default.htm.")
    protected StringType udi;
    @Child(name="lotNumber", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Lot number of manufacture", formalDefinition="Lot number assigned by the manufacturer.")
    protected StringType lotNumber;
    @Child(name="owner", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    protected Reference owner;
    protected Organization ownerTarget;
    @Child(name="location", type={Location.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the resource is found", formalDefinition="The place where the device can be found.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="patient", type={Patient.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="If the resource is affixed to a person", formalDefinition="Patient information, if the resource is affixed to a person.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="contact", type={ContactPoint.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device.")
    protected List<ContactPoint> contact;
    @Child(name="url", type={UriType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Network address to contact device", formalDefinition="A network address on which the device may be contacted directly.")
    protected UriType url;
    private static final long serialVersionUID = 366690094L;
    @SearchParamDefinition(name="identifier", path="Device.identifier", description="Instance id from manufacturer, owner, and others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="patient", path="Device.patient", description="Patient information, if the resource is affixed to a person", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="organization", path="Device.owner", description="The organization responsible for the device", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    @SearchParamDefinition(name="model", path="Device.model", description="The model of the device", type="string")
    public static final String SP_MODEL = "model";
    @SearchParamDefinition(name="location", path="Device.location", description="A location, where the resource is found", type="reference")
    public static final String SP_LOCATION = "location";
    @SearchParamDefinition(name="udi", path="Device.udi", description="FDA mandated Unique Device Identifier", type="string")
    public static final String SP_UDI = "udi";
    @SearchParamDefinition(name="type", path="Device.type", description="The type of the device", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="url", path="Device.url", description="Network address to contact device", type="uri")
    public static final String SP_URL = "url";
    @SearchParamDefinition(name="manufacturer", path="Device.manufacturer", description="The manufacturer of the device", type="string")
    public static final String SP_MANUFACTURER = "manufacturer";

    public Device() {
    }

    public Device(CodeableConcept type) {
        this.type = type;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Device addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Device setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Device addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Enumeration<DeviceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DeviceStatus>(new DeviceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Device setStatusElement(Enumeration<DeviceStatus> value) {
        this.status = value;
        return this;
    }

    public DeviceStatus getStatus() {
        return this.status == null ? null : (DeviceStatus)((Object)this.status.getValue());
    }

    public Device setStatus(DeviceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<DeviceStatus>(new DeviceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public StringType getManufacturerElement() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new StringType();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturerElement() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Device setManufacturerElement(StringType value) {
        this.manufacturer = value;
        return this;
    }

    public String getManufacturer() {
        return this.manufacturer == null ? null : (String)this.manufacturer.getValue();
    }

    public Device setManufacturer(String value) {
        if (Utilities.noString(value)) {
            this.manufacturer = null;
        } else {
            if (this.manufacturer == null) {
                this.manufacturer = new StringType();
            }
            this.manufacturer.setValue(value);
        }
        return this;
    }

    public StringType getModelElement() {
        if (this.model == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.model");
            }
            if (Configuration.doAutoCreate()) {
                this.model = new StringType();
            }
        }
        return this.model;
    }

    public boolean hasModelElement() {
        return this.model != null && !this.model.isEmpty();
    }

    public boolean hasModel() {
        return this.model != null && !this.model.isEmpty();
    }

    public Device setModelElement(StringType value) {
        this.model = value;
        return this;
    }

    public String getModel() {
        return this.model == null ? null : (String)this.model.getValue();
    }

    public Device setModel(String value) {
        if (Utilities.noString(value)) {
            this.model = null;
        } else {
            if (this.model == null) {
                this.model = new StringType();
            }
            this.model.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Device setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Device setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public DateTimeType getManufactureDateElement() {
        if (this.manufactureDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufactureDate");
            }
            if (Configuration.doAutoCreate()) {
                this.manufactureDate = new DateTimeType();
            }
        }
        return this.manufactureDate;
    }

    public boolean hasManufactureDateElement() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public boolean hasManufactureDate() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public Device setManufactureDateElement(DateTimeType value) {
        this.manufactureDate = value;
        return this;
    }

    public Date getManufactureDate() {
        return this.manufactureDate == null ? null : (Date)this.manufactureDate.getValue();
    }

    public Device setManufactureDate(Date value) {
        if (value == null) {
            this.manufactureDate = null;
        } else {
            if (this.manufactureDate == null) {
                this.manufactureDate = new DateTimeType();
            }
            this.manufactureDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getExpiryElement() {
        if (this.expiry == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.expiry");
            }
            if (Configuration.doAutoCreate()) {
                this.expiry = new DateTimeType();
            }
        }
        return this.expiry;
    }

    public boolean hasExpiryElement() {
        return this.expiry != null && !this.expiry.isEmpty();
    }

    public boolean hasExpiry() {
        return this.expiry != null && !this.expiry.isEmpty();
    }

    public Device setExpiryElement(DateTimeType value) {
        this.expiry = value;
        return this;
    }

    public Date getExpiry() {
        return this.expiry == null ? null : (Date)this.expiry.getValue();
    }

    public Device setExpiry(Date value) {
        if (value == null) {
            this.expiry = null;
        } else {
            if (this.expiry == null) {
                this.expiry = new DateTimeType();
            }
            this.expiry.setValue(value);
        }
        return this;
    }

    public StringType getUdiElement() {
        if (this.udi == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.udi");
            }
            if (Configuration.doAutoCreate()) {
                this.udi = new StringType();
            }
        }
        return this.udi;
    }

    public boolean hasUdiElement() {
        return this.udi != null && !this.udi.isEmpty();
    }

    public boolean hasUdi() {
        return this.udi != null && !this.udi.isEmpty();
    }

    public Device setUdiElement(StringType value) {
        this.udi = value;
        return this;
    }

    public String getUdi() {
        return this.udi == null ? null : (String)this.udi.getValue();
    }

    public Device setUdi(String value) {
        if (Utilities.noString(value)) {
            this.udi = null;
        } else {
            if (this.udi == null) {
                this.udi = new StringType();
            }
            this.udi.setValue(value);
        }
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public Device setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public Device setLotNumber(String value) {
        if (Utilities.noString(value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Device setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Organization getOwnerTarget() {
        if (this.ownerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.ownerTarget = new Organization();
            }
        }
        return this.ownerTarget;
    }

    public Device setOwnerTarget(Organization value) {
        this.ownerTarget = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Device setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Device setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Device setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Device setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Device addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Device setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Device setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by organizations like manufacturers or owners. If the identifier identifies the type of device, Device.type should be used.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Code or identifier to identify a kind of device.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("status", "code", "Status of the Device availability.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_MANUFACTURER, "string", "A name of the manufacturer.", 0, Integer.MAX_VALUE, this.manufacturer));
        childrenList.add(new Property(SP_MODEL, "string", "The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.", 0, Integer.MAX_VALUE, this.model));
        childrenList.add(new Property("version", "string", "The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, Integer.MAX_VALUE, this.manufactureDate));
        childrenList.add(new Property("expiry", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, Integer.MAX_VALUE, this.expiry));
        childrenList.add(new Property(SP_UDI, "string", "United States Food and Drug Administration mandated Unique Device Identifier (UDI). Use the human readable information (the content that the user sees, which is sometimes different to the exact syntax represented in the barcode)  - see http://www.fda.gov/MedicalDevices/DeviceRegulationandGuidance/UniqueDeviceIdentification/default.htm.", 0, Integer.MAX_VALUE, this.udi));
        childrenList.add(new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, Integer.MAX_VALUE, this.lotNumber));
        childrenList.add(new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, Integer.MAX_VALUE, this.owner));
        childrenList.add(new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient information, if the resource is affixed to a person.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, Integer.MAX_VALUE, this.url));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("status")) {
            this.status = new DeviceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToString(value);
        } else if (name.equals(SP_MODEL)) {
            this.model = this.castToString(value);
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals("manufactureDate")) {
            this.manufactureDate = this.castToDateTime(value);
        } else if (name.equals("expiry")) {
            this.expiry = this.castToDateTime(value);
        } else if (name.equals(SP_UDI)) {
            this.udi = this.castToString(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = this.castToString(value);
        } else if (name.equals("owner")) {
            this.owner = this.castToReference(value);
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactPoint(value));
        } else if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.status");
        }
        if (name.equals(SP_MANUFACTURER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.manufacturer");
        }
        if (name.equals(SP_MODEL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.model");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.version");
        }
        if (name.equals("manufactureDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.manufactureDate");
        }
        if (name.equals("expiry")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.expiry");
        }
        if (name.equals(SP_UDI)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.udi");
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.lotNumber");
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.url");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Device";
    }

    @Override
    public Device copy() {
        Device dst = new Device();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.model = this.model == null ? null : this.model.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.manufactureDate = this.manufactureDate == null ? null : this.manufactureDate.copy();
        dst.expiry = this.expiry == null ? null : this.expiry.copy();
        dst.udi = this.udi == null ? null : this.udi.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        dst.owner = this.owner == null ? null : this.owner.copy();
        dst.location = this.location == null ? null : this.location.copy();
        Reference reference = dst.patient = this.patient == null ? null : this.patient.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.url = this.url == null ? null : this.url.copy();
        return dst;
    }

    protected Device typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Device)) {
            return false;
        }
        Device o = (Device)other;
        return Device.compareDeep(this.identifier, o.identifier, true) && Device.compareDeep(this.type, o.type, true) && Device.compareDeep(this.note, o.note, true) && Device.compareDeep(this.status, o.status, true) && Device.compareDeep(this.manufacturer, o.manufacturer, true) && Device.compareDeep(this.model, o.model, true) && Device.compareDeep(this.version, o.version, true) && Device.compareDeep(this.manufactureDate, o.manufactureDate, true) && Device.compareDeep(this.expiry, o.expiry, true) && Device.compareDeep(this.udi, o.udi, true) && Device.compareDeep(this.lotNumber, o.lotNumber, true) && Device.compareDeep(this.owner, o.owner, true) && Device.compareDeep(this.location, o.location, true) && Device.compareDeep(this.patient, o.patient, true) && Device.compareDeep(this.contact, o.contact, true) && Device.compareDeep(this.url, o.url, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Device)) {
            return false;
        }
        Device o = (Device)other;
        return Device.compareValues(this.status, o.status, true) && Device.compareValues(this.manufacturer, o.manufacturer, true) && Device.compareValues(this.model, o.model, true) && Device.compareValues(this.version, o.version, true) && Device.compareValues(this.manufactureDate, o.manufactureDate, true) && Device.compareValues(this.expiry, o.expiry, true) && Device.compareValues(this.udi, o.udi, true) && Device.compareValues(this.lotNumber, o.lotNumber, true) && Device.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.type != null && !this.type.isEmpty() || this.note != null && !this.note.isEmpty() || this.status != null && !this.status.isEmpty() || this.manufacturer != null && !this.manufacturer.isEmpty() || this.model != null && !this.model.isEmpty() || this.version != null && !this.version.isEmpty() || this.manufactureDate != null && !this.manufactureDate.isEmpty() || this.expiry != null && !this.expiry.isEmpty() || this.udi != null && !this.udi.isEmpty() || this.lotNumber != null && !this.lotNumber.isEmpty() || this.owner != null && !this.owner.isEmpty() || this.location != null && !this.location.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.url != null && !this.url.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Device;
    }

    public static class DeviceStatusEnumFactory
    implements EnumFactory<DeviceStatus> {
        @Override
        public DeviceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("available".equals(codeString)) {
                return DeviceStatus.AVAILABLE;
            }
            if ("not-available".equals(codeString)) {
                return DeviceStatus.NOTAVAILABLE;
            }
            if ("entered-in-error".equals(codeString)) {
                return DeviceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown DeviceStatus code '" + codeString + "'");
        }

        public Enumeration<DeviceStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return new Enumeration<DeviceStatus>(this, DeviceStatus.AVAILABLE);
            }
            if ("not-available".equals(codeString)) {
                return new Enumeration<DeviceStatus>(this, DeviceStatus.NOTAVAILABLE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DeviceStatus>(this, DeviceStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown DeviceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceStatus code) {
            if (code == DeviceStatus.AVAILABLE) {
                return "available";
            }
            if (code == DeviceStatus.NOTAVAILABLE) {
                return "not-available";
            }
            if (code == DeviceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }
    }

    public static enum DeviceStatus {
        AVAILABLE,
        NOTAVAILABLE,
        ENTEREDINERROR,
        NULL;


        public static DeviceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("not-available".equals(codeString)) {
                return NOTAVAILABLE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown DeviceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AVAILABLE: {
                    return "available";
                }
                case NOTAVAILABLE: {
                    return "not-available";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AVAILABLE: {
                    return "http://hl7.org/fhir/devicestatus";
                }
                case NOTAVAILABLE: {
                    return "http://hl7.org/fhir/devicestatus";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/devicestatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AVAILABLE: {
                    return "The Device is available for use.";
                }
                case NOTAVAILABLE: {
                    return "The Device is no longer available for use (e.g. lost, expired, damaged).";
                }
                case ENTEREDINERROR: {
                    return "The Device was entered in error and voided.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AVAILABLE: {
                    return "Available";
                }
                case NOTAVAILABLE: {
                    return "Not Available";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

