/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.Slot;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Appointment", profile="http://hl7.org/fhir/Profile/Appointment")
public class Appointment
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | pending | booked | arrived | fulfilled | cancelled | noshow", formalDefinition="The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.")
    protected Enumeration<AppointmentStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of appointment that is being booked", formalDefinition="The type of appointment that is being booked (This may also be associated with participants for location, and/or a HealthcareService).")
    protected CodeableConcept type;
    @Child(name="reason", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason this appointment is scheduled", formalDefinition="The reason that this appointment is being scheduled. This is more clinical than administrative.")
    protected CodeableConcept reason;
    @Child(name="priority", type={UnsignedIntType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Used to make informed decisions if needing to re-prioritize", formalDefinition="The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).")
    protected UnsignedIntType priority;
    @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Shown on a subject line in a meeting request, or appointment list", formalDefinition="The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field.")
    protected StringType description;
    @Child(name="start", type={InstantType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When appointment is to take place", formalDefinition="Date/Time that the appointment is to take place.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When appointment is to conclude", formalDefinition="Date/Time that the appointment is to conclude.")
    protected InstantType end;
    @Child(name="minutesDuration", type={PositiveIntType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Can be less than start/end (e.g. estimate)", formalDefinition="Number of minutes that the appointment is to take. This can be less than the duration between the start and end times (where actual time of appointment is only an estimate or is a planned appointment request).")
    protected PositiveIntType minutesDuration;
    @Child(name="slot", type={Slot.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="If provided, then no schedule and start/end values MUST match slot", formalDefinition="The slot that this appointment is filling. If provided then the schedule will not be provided as slots are not recursive, and the start/end values MUST be the same as from the slot.")
    protected List<Reference> slot;
    protected List<Slot> slotTarget;
    @Child(name="comment", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional comments", formalDefinition="Additional comments about the appointment.")
    protected StringType comment;
    @Child(name="participant", type={}, order=11, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Participants involved in appointment", formalDefinition="List of participants involved in the appointment.")
    protected List<AppointmentParticipantComponent> participant;
    private static final long serialVersionUID = -1403944125L;
    @SearchParamDefinition(name="date", path="Appointment.start", description="Appointment date/time.", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="actor", path="Appointment.participant.actor", description="Any one of the individuals participating in the appointment", type="reference")
    public static final String SP_ACTOR = "actor";
    @SearchParamDefinition(name="identifier", path="Appointment.identifier", description="An Identifier of the Appointment", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="practitioner", path="Appointment.participant.actor", description="One of the individuals of the appointment is this practitioner", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    @SearchParamDefinition(name="part-status", path="Appointment.participant.status", description="The Participation status of the subject, or other participant on the appointment. Can be used to locate participants that have not responded to meeting requests.", type="token")
    public static final String SP_PARTSTATUS = "part-status";
    @SearchParamDefinition(name="patient", path="Appointment.participant.actor", description="One of the individuals of the appointment is this patient", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="location", path="Appointment.participant.actor", description="This location is listed in the participants of the appointment", type="reference")
    public static final String SP_LOCATION = "location";
    @SearchParamDefinition(name="status", path="Appointment.status", description="The overall status of the appointment", type="token")
    public static final String SP_STATUS = "status";

    public Appointment() {
    }

    public Appointment(Enumeration<AppointmentStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Appointment addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<AppointmentStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AppointmentStatus>(new AppointmentStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Appointment setStatusElement(Enumeration<AppointmentStatus> value) {
        this.status = value;
        return this;
    }

    public AppointmentStatus getStatus() {
        return this.status == null ? null : (AppointmentStatus)((Object)this.status.getValue());
    }

    public Appointment setStatus(AppointmentStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<AppointmentStatus>(new AppointmentStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Appointment setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Appointment setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public UnsignedIntType getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new UnsignedIntType();
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Appointment setPriorityElement(UnsignedIntType value) {
        this.priority = value;
        return this;
    }

    public int getPriority() {
        return this.priority == null || this.priority.isEmpty() ? 0 : (Integer)this.priority.getValue();
    }

    public Appointment setPriority(int value) {
        if (this.priority == null) {
            this.priority = new UnsignedIntType();
        }
        this.priority.setValue((Object)value);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Appointment setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Appointment setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Appointment setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public Appointment setStart(Date value) {
        if (value == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new InstantType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Appointment setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Appointment setEnd(Date value) {
        if (value == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new InstantType();
            }
            this.end.setValue(value);
        }
        return this;
    }

    public PositiveIntType getMinutesDurationElement() {
        if (this.minutesDuration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.minutesDuration");
            }
            if (Configuration.doAutoCreate()) {
                this.minutesDuration = new PositiveIntType();
            }
        }
        return this.minutesDuration;
    }

    public boolean hasMinutesDurationElement() {
        return this.minutesDuration != null && !this.minutesDuration.isEmpty();
    }

    public boolean hasMinutesDuration() {
        return this.minutesDuration != null && !this.minutesDuration.isEmpty();
    }

    public Appointment setMinutesDurationElement(PositiveIntType value) {
        this.minutesDuration = value;
        return this;
    }

    public int getMinutesDuration() {
        return this.minutesDuration == null || this.minutesDuration.isEmpty() ? 0 : (Integer)this.minutesDuration.getValue();
    }

    public Appointment setMinutesDuration(int value) {
        if (this.minutesDuration == null) {
            this.minutesDuration = new PositiveIntType();
        }
        this.minutesDuration.setValue((Object)value);
        return this;
    }

    public List<Reference> getSlot() {
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        return this.slot;
    }

    public boolean hasSlot() {
        if (this.slot == null) {
            return false;
        }
        for (Reference item : this.slot) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSlot() {
        Reference t = new Reference();
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        this.slot.add(t);
        return t;
    }

    public Appointment addSlot(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.slot == null) {
            this.slot = new ArrayList<Reference>();
        }
        this.slot.add(t);
        return this;
    }

    public List<Slot> getSlotTarget() {
        if (this.slotTarget == null) {
            this.slotTarget = new ArrayList<Slot>();
        }
        return this.slotTarget;
    }

    public Slot addSlotTarget() {
        Slot r = new Slot();
        if (this.slotTarget == null) {
            this.slotTarget = new ArrayList<Slot>();
        }
        this.slotTarget.add(r);
        return r;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Appointment.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Appointment setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Appointment setComment(String value) {
        if (Utilities.noString(value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public List<AppointmentParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        return this.participant;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (AppointmentParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AppointmentParticipantComponent addParticipant() {
        AppointmentParticipantComponent t = new AppointmentParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Appointment addParticipant(AppointmentParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<AppointmentParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("type", "CodeableConcept", "The type of appointment that is being booked (This may also be associated with participants for location, and/or a HealthcareService).", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("reason", "CodeableConcept", "The reason that this appointment is being scheduled. This is more clinical than administrative.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("priority", "unsignedInt", "The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property("description", "string", "The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("start", "instant", "Date/Time that the appointment is to take place.", 0, Integer.MAX_VALUE, this.start));
        childrenList.add(new Property("end", "instant", "Date/Time that the appointment is to conclude.", 0, Integer.MAX_VALUE, this.end));
        childrenList.add(new Property("minutesDuration", "positiveInt", "Number of minutes that the appointment is to take. This can be less than the duration between the start and end times (where actual time of appointment is only an estimate or is a planned appointment request).", 0, Integer.MAX_VALUE, this.minutesDuration));
        childrenList.add(new Property("slot", "Reference(Slot)", "The slot that this appointment is filling. If provided then the schedule will not be provided as slots are not recursive, and the start/end values MUST be the same as from the slot.", 0, Integer.MAX_VALUE, this.slot));
        childrenList.add(new Property("comment", "string", "Additional comments about the appointment.", 0, Integer.MAX_VALUE, this.comment));
        childrenList.add(new Property("participant", "", "List of participants involved in the appointment.", 0, Integer.MAX_VALUE, this.participant));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new AppointmentStatusEnumFactory().fromType(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("reason")) {
            this.reason = this.castToCodeableConcept(value);
        } else if (name.equals("priority")) {
            this.priority = this.castToUnsignedInt(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("start")) {
            this.start = this.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = this.castToInstant(value);
        } else if (name.equals("minutesDuration")) {
            this.minutesDuration = this.castToPositiveInt(value);
        } else if (name.equals("slot")) {
            this.getSlot().add(this.castToReference(value));
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((AppointmentParticipantComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.status");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("reason")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.priority");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.description");
        }
        if (name.equals("start")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.end");
        }
        if (name.equals("minutesDuration")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.minutesDuration");
        }
        if (name.equals("slot")) {
            return this.addSlot();
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Appointment.comment");
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Appointment";
    }

    @Override
    public Appointment copy() {
        Appointment dst = new Appointment();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.start = this.start == null ? null : this.start.copy();
        dst.end = this.end == null ? null : this.end.copy();
        PositiveIntType positiveIntType = dst.minutesDuration = this.minutesDuration == null ? null : this.minutesDuration.copy();
        if (this.slot != null) {
            dst.slot = new ArrayList<Reference>();
            for (Reference reference : this.slot) {
                dst.slot.add(reference.copy());
            }
        }
        StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<AppointmentParticipantComponent>();
            for (AppointmentParticipantComponent appointmentParticipantComponent : this.participant) {
                dst.participant.add(appointmentParticipantComponent.copy());
            }
        }
        return dst;
    }

    protected Appointment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Appointment)) {
            return false;
        }
        Appointment o = (Appointment)other;
        return Appointment.compareDeep(this.identifier, o.identifier, true) && Appointment.compareDeep(this.status, o.status, true) && Appointment.compareDeep(this.type, o.type, true) && Appointment.compareDeep(this.reason, o.reason, true) && Appointment.compareDeep(this.priority, o.priority, true) && Appointment.compareDeep(this.description, o.description, true) && Appointment.compareDeep(this.start, o.start, true) && Appointment.compareDeep(this.end, o.end, true) && Appointment.compareDeep(this.minutesDuration, o.minutesDuration, true) && Appointment.compareDeep(this.slot, o.slot, true) && Appointment.compareDeep(this.comment, o.comment, true) && Appointment.compareDeep(this.participant, o.participant, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Appointment)) {
            return false;
        }
        Appointment o = (Appointment)other;
        return Appointment.compareValues(this.status, o.status, true) && Appointment.compareValues(this.priority, o.priority, true) && Appointment.compareValues(this.description, o.description, true) && Appointment.compareValues(this.start, o.start, true) && Appointment.compareValues(this.end, o.end, true) && Appointment.compareValues(this.minutesDuration, o.minutesDuration, true) && Appointment.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.type != null && !this.type.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.description != null && !this.description.isEmpty() || this.start != null && !this.start.isEmpty() || this.end != null && !this.end.isEmpty() || this.minutesDuration != null && !this.minutesDuration.isEmpty() || this.slot != null && !this.slot.isEmpty() || this.comment != null && !this.comment.isEmpty() || this.participant != null && !this.participant.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Appointment;
    }

    @Block
    public static class AppointmentParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Role of participant in the appointment", formalDefinition="Role of participant in the appointment.")
        protected List<CodeableConcept> type;
        @Child(name="actor", type={Patient.class, Practitioner.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Person, Location/HealthcareService or Device", formalDefinition="A Person, Location/HealthcareService or Device that is participating in the appointment.")
        protected Reference actor;
        protected Resource actorTarget;
        @Child(name="required", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="required | optional | information-only", formalDefinition="Is this participant required to be present at the meeting. This covers a use-case where 2 doctors need to meet to discuss the results for a specific patient, and the patient is not required to be present.")
        protected Enumeration<ParticipantRequired> required;
        @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="accepted | declined | tentative | needs-action", formalDefinition="Participation status of the Patient.")
        protected Enumeration<ParticipationStatus> status;
        private static final long serialVersionUID = -1620552507L;

        public AppointmentParticipantComponent() {
        }

        public AppointmentParticipantComponent(Enumeration<ParticipationStatus> status) {
            this.status = status;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public AppointmentParticipantComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public AppointmentParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public AppointmentParticipantComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        public Enumeration<ParticipantRequired> getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new Enumeration<ParticipantRequired>(new ParticipantRequiredEnumFactory());
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public AppointmentParticipantComponent setRequiredElement(Enumeration<ParticipantRequired> value) {
            this.required = value;
            return this;
        }

        public ParticipantRequired getRequired() {
            return this.required == null ? null : (ParticipantRequired)((Object)this.required.getValue());
        }

        public AppointmentParticipantComponent setRequired(ParticipantRequired value) {
            if (value == null) {
                this.required = null;
            } else {
                if (this.required == null) {
                    this.required = new Enumeration<ParticipantRequired>(new ParticipantRequiredEnumFactory());
                }
                this.required.setValue((Object)value);
            }
            return this;
        }

        public Enumeration<ParticipationStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AppointmentParticipantComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<ParticipationStatus>(new ParticipationStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public AppointmentParticipantComponent setStatusElement(Enumeration<ParticipationStatus> value) {
            this.status = value;
            return this;
        }

        public ParticipationStatus getStatus() {
            return this.status == null ? null : (ParticipationStatus)((Object)this.status.getValue());
        }

        public AppointmentParticipantComponent setStatus(ParticipationStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<ParticipationStatus>(new ParticipationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "CodeableConcept", "Role of participant in the appointment.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(Appointment.SP_ACTOR, "Reference(Patient|Practitioner|RelatedPerson|Device|HealthcareService|Location)", "A Person, Location/HealthcareService or Device that is participating in the appointment.", 0, Integer.MAX_VALUE, this.actor));
            childrenList.add(new Property("required", "code", "Is this participant required to be present at the meeting. This covers a use-case where 2 doctors need to meet to discuss the results for a specific patient, and the patient is not required to be present.", 0, Integer.MAX_VALUE, this.required));
            childrenList.add(new Property(Appointment.SP_STATUS, "code", "Participation status of the Patient.", 0, Integer.MAX_VALUE, this.status));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals(Appointment.SP_ACTOR)) {
                this.actor = this.castToReference(value);
            } else if (name.equals("required")) {
                this.required = new ParticipantRequiredEnumFactory().fromType(value);
            } else if (name.equals(Appointment.SP_STATUS)) {
                this.status = new ParticipationStatusEnumFactory().fromType(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals(Appointment.SP_ACTOR)) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type Appointment.required");
            }
            if (name.equals(Appointment.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Appointment.status");
            }
            return super.addChild(name);
        }

        @Override
        public AppointmentParticipantComponent copy() {
            AppointmentParticipantComponent dst = new AppointmentParticipantComponent();
            this.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.required = this.required == null ? null : this.required.copy();
            dst.status = this.status == null ? null : this.status.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AppointmentParticipantComponent)) {
                return false;
            }
            AppointmentParticipantComponent o = (AppointmentParticipantComponent)other;
            return AppointmentParticipantComponent.compareDeep(this.type, o.type, true) && AppointmentParticipantComponent.compareDeep(this.actor, o.actor, true) && AppointmentParticipantComponent.compareDeep(this.required, o.required, true) && AppointmentParticipantComponent.compareDeep(this.status, o.status, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AppointmentParticipantComponent)) {
                return false;
            }
            AppointmentParticipantComponent o = (AppointmentParticipantComponent)other;
            return AppointmentParticipantComponent.compareValues(this.required, o.required, true) && AppointmentParticipantComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.required != null && !this.required.isEmpty() || this.status != null && !this.status.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Appointment.participant";
        }
    }

    public static class ParticipationStatusEnumFactory
    implements EnumFactory<ParticipationStatus> {
        @Override
        public ParticipationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return ParticipationStatus.ACCEPTED;
            }
            if ("declined".equals(codeString)) {
                return ParticipationStatus.DECLINED;
            }
            if ("tentative".equals(codeString)) {
                return ParticipationStatus.TENTATIVE;
            }
            if ("needs-action".equals(codeString)) {
                return ParticipationStatus.NEEDSACTION;
            }
            throw new IllegalArgumentException("Unknown ParticipationStatus code '" + codeString + "'");
        }

        public Enumeration<ParticipationStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.ACCEPTED);
            }
            if ("declined".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.DECLINED);
            }
            if ("tentative".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.TENTATIVE);
            }
            if ("needs-action".equals(codeString)) {
                return new Enumeration<ParticipationStatus>(this, ParticipationStatus.NEEDSACTION);
            }
            throw new FHIRException("Unknown ParticipationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ParticipationStatus code) {
            if (code == ParticipationStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == ParticipationStatus.DECLINED) {
                return "declined";
            }
            if (code == ParticipationStatus.TENTATIVE) {
                return "tentative";
            }
            if (code == ParticipationStatus.NEEDSACTION) {
                return "needs-action";
            }
            return "?";
        }
    }

    public static enum ParticipationStatus {
        ACCEPTED,
        DECLINED,
        TENTATIVE,
        NEEDSACTION,
        NULL;


        public static ParticipationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("declined".equals(codeString)) {
                return DECLINED;
            }
            if ("tentative".equals(codeString)) {
                return TENTATIVE;
            }
            if ("needs-action".equals(codeString)) {
                return NEEDSACTION;
            }
            throw new FHIRException("Unknown ParticipationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACCEPTED: {
                    return "accepted";
                }
                case DECLINED: {
                    return "declined";
                }
                case TENTATIVE: {
                    return "tentative";
                }
                case NEEDSACTION: {
                    return "needs-action";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACCEPTED: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case DECLINED: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case TENTATIVE: {
                    return "http://hl7.org/fhir/participationstatus";
                }
                case NEEDSACTION: {
                    return "http://hl7.org/fhir/participationstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACCEPTED: {
                    return "The participant has accepted the appointment.";
                }
                case DECLINED: {
                    return "The participant has declined the appointment and will not participate in the appointment.";
                }
                case TENTATIVE: {
                    return "The participant has  tentatively accepted the appointment. This could be automatically created by a system and requires further processing before it can be accepted. There is no commitment that attendance will occur.";
                }
                case NEEDSACTION: {
                    return "The participant needs to indicate if they accept the appointment by changing this status to one of the other statuses.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACCEPTED: {
                    return "Accepted";
                }
                case DECLINED: {
                    return "Declined";
                }
                case TENTATIVE: {
                    return "Tentative";
                }
                case NEEDSACTION: {
                    return "Needs Action";
                }
            }
            return "?";
        }
    }

    public static class ParticipantRequiredEnumFactory
    implements EnumFactory<ParticipantRequired> {
        @Override
        public ParticipantRequired fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("required".equals(codeString)) {
                return ParticipantRequired.REQUIRED;
            }
            if ("optional".equals(codeString)) {
                return ParticipantRequired.OPTIONAL;
            }
            if ("information-only".equals(codeString)) {
                return ParticipantRequired.INFORMATIONONLY;
            }
            throw new IllegalArgumentException("Unknown ParticipantRequired code '" + codeString + "'");
        }

        public Enumeration<ParticipantRequired> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("required".equals(codeString)) {
                return new Enumeration<ParticipantRequired>(this, ParticipantRequired.REQUIRED);
            }
            if ("optional".equals(codeString)) {
                return new Enumeration<ParticipantRequired>(this, ParticipantRequired.OPTIONAL);
            }
            if ("information-only".equals(codeString)) {
                return new Enumeration<ParticipantRequired>(this, ParticipantRequired.INFORMATIONONLY);
            }
            throw new FHIRException("Unknown ParticipantRequired code '" + codeString + "'");
        }

        @Override
        public String toCode(ParticipantRequired code) {
            if (code == ParticipantRequired.REQUIRED) {
                return "required";
            }
            if (code == ParticipantRequired.OPTIONAL) {
                return "optional";
            }
            if (code == ParticipantRequired.INFORMATIONONLY) {
                return "information-only";
            }
            return "?";
        }
    }

    public static enum ParticipantRequired {
        REQUIRED,
        OPTIONAL,
        INFORMATIONONLY,
        NULL;


        public static ParticipantRequired fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("required".equals(codeString)) {
                return REQUIRED;
            }
            if ("optional".equals(codeString)) {
                return OPTIONAL;
            }
            if ("information-only".equals(codeString)) {
                return INFORMATIONONLY;
            }
            throw new FHIRException("Unknown ParticipantRequired code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REQUIRED: {
                    return "required";
                }
                case OPTIONAL: {
                    return "optional";
                }
                case INFORMATIONONLY: {
                    return "information-only";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REQUIRED: {
                    return "http://hl7.org/fhir/participantrequired";
                }
                case OPTIONAL: {
                    return "http://hl7.org/fhir/participantrequired";
                }
                case INFORMATIONONLY: {
                    return "http://hl7.org/fhir/participantrequired";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REQUIRED: {
                    return "The participant is required to attend the appointment.";
                }
                case OPTIONAL: {
                    return "The participant may optionally attend the appointment.";
                }
                case INFORMATIONONLY: {
                    return "The participant is excluded from the appointment, and may not be informed of the appointment taking place. (Appointment is about them, not for them - such as 2 doctors discussing results about a patient's test).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REQUIRED: {
                    return "Required";
                }
                case OPTIONAL: {
                    return "Optional";
                }
                case INFORMATIONONLY: {
                    return "Information Only";
                }
            }
            return "?";
        }
    }

    public static class AppointmentStatusEnumFactory
    implements EnumFactory<AppointmentStatus> {
        @Override
        public AppointmentStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return AppointmentStatus.PROPOSED;
            }
            if ("pending".equals(codeString)) {
                return AppointmentStatus.PENDING;
            }
            if ("booked".equals(codeString)) {
                return AppointmentStatus.BOOKED;
            }
            if ("arrived".equals(codeString)) {
                return AppointmentStatus.ARRIVED;
            }
            if ("fulfilled".equals(codeString)) {
                return AppointmentStatus.FULFILLED;
            }
            if ("cancelled".equals(codeString)) {
                return AppointmentStatus.CANCELLED;
            }
            if ("noshow".equals(codeString)) {
                return AppointmentStatus.NOSHOW;
            }
            throw new IllegalArgumentException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        public Enumeration<AppointmentStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.PROPOSED);
            }
            if ("pending".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.PENDING);
            }
            if ("booked".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.BOOKED);
            }
            if ("arrived".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.ARRIVED);
            }
            if ("fulfilled".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.FULFILLED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.CANCELLED);
            }
            if ("noshow".equals(codeString)) {
                return new Enumeration<AppointmentStatus>(this, AppointmentStatus.NOSHOW);
            }
            throw new FHIRException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AppointmentStatus code) {
            if (code == AppointmentStatus.PROPOSED) {
                return "proposed";
            }
            if (code == AppointmentStatus.PENDING) {
                return "pending";
            }
            if (code == AppointmentStatus.BOOKED) {
                return "booked";
            }
            if (code == AppointmentStatus.ARRIVED) {
                return "arrived";
            }
            if (code == AppointmentStatus.FULFILLED) {
                return "fulfilled";
            }
            if (code == AppointmentStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == AppointmentStatus.NOSHOW) {
                return "noshow";
            }
            return "?";
        }
    }

    public static enum AppointmentStatus {
        PROPOSED,
        PENDING,
        BOOKED,
        ARRIVED,
        FULFILLED,
        CANCELLED,
        NOSHOW,
        NULL;


        public static AppointmentStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("pending".equals(codeString)) {
                return PENDING;
            }
            if ("booked".equals(codeString)) {
                return BOOKED;
            }
            if ("arrived".equals(codeString)) {
                return ARRIVED;
            }
            if ("fulfilled".equals(codeString)) {
                return FULFILLED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("noshow".equals(codeString)) {
                return NOSHOW;
            }
            throw new FHIRException("Unknown AppointmentStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case PENDING: {
                    return "pending";
                }
                case BOOKED: {
                    return "booked";
                }
                case ARRIVED: {
                    return "arrived";
                }
                case FULFILLED: {
                    return "fulfilled";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case NOSHOW: {
                    return "noshow";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case PENDING: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case BOOKED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case ARRIVED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case FULFILLED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
                case NOSHOW: {
                    return "http://hl7.org/fhir/appointmentstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "None of the participant(s) have finalized their acceptance of the appointment request, and the start/end time may not be set yet.";
                }
                case PENDING: {
                    return "Some or all of the participant(s) have not finalized their acceptance of the appointment request.";
                }
                case BOOKED: {
                    return "All participant(s) have been considered and the appointment is confirmed to go ahead at the date/times specified.";
                }
                case ARRIVED: {
                    return "Some of the patients have arrived.";
                }
                case FULFILLED: {
                    return "This appointment has completed and may have resulted in an encounter.";
                }
                case CANCELLED: {
                    return "The appointment has been cancelled.";
                }
                case NOSHOW: {
                    return "Some or all of the participant(s) have not/did not appear for the appointment (usually the patient).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case PENDING: {
                    return "Pending";
                }
                case BOOKED: {
                    return "Booked";
                }
                case ARRIVED: {
                    return "Arrived";
                }
                case FULFILLED: {
                    return "Fulfilled";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case NOSHOW: {
                    return "No Show";
                }
            }
            return "?";
        }
    }
}

