/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.context.SimpleWorkerContext;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ISO21090Importer {
    private IWorkerContext ctxt;
    private Element schema;
    private Map<String, EnumValueSet> bindings = new HashMap<String, EnumValueSet>();
    private Map<String, DataType> types = new HashMap<String, DataType>();

    public static void main(String[] args) throws Exception {
        new ISO21090Importer().process();
    }

    private void process() throws Exception {
        this.ctxt = SimpleWorkerContext.fromPack("C:\\work\\org.hl7.fhir\\build\\publish\\igpack.zip");
        this.load();
        this.processEnums();
        this.processDataTypes();
        this.generate();
        System.out.print("done");
    }

    private void generate() throws Exception {
        for (EnumValueSet evs : this.bindings.values()) {
            this.generateValueSet(evs);
        }
        for (DataType dt : this.types.values()) {
            this.generateType(dt);
        }
    }

    private void generateType(DataType dt) throws Exception {
        StructureDefinition sd = new StructureDefinition();
        sd.setId(dt.name);
        sd.setUrl("http://hl7.org/fhir/iso21090/StructureDefinition/" + sd.getId());
        sd.setName(dt.name + " data type");
        sd.setStatus(Enumerations.PublicationStatus.ACTIVE);
        sd.setExperimental(false);
        sd.setPublisher("HL7 / ISO");
        sd.setDate(new Date());
        sd.setDescription(dt.doco);
        sd.setKind(StructureDefinition.StructureDefinitionKind.LOGICAL);
        sd.setAbstract(Utilities.existsInList(dt.name, "HXIT", "QTY"));
        sd.setType("Element");
        if (dt.parent == null) {
            sd.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Element");
        } else {
            sd.setBaseDefinition("http://hl7.org/fhir/iso21090/StructureDefinition/" + dt.parent);
        }
        sd.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        ElementDefinition ed = sd.getDifferential().addElement();
        ed.setPath(dt.name);
        this.produceProperties(sd.getDifferential().getElement(), dt.name, dt.properties, true, false);
        this.produceProperties(sd.getDifferential().getElement(), dt.name, dt.properties, false, false);
        ed = sd.getSnapshot().addElement();
        ed.setPath(dt.name);
        if (dt.parent != null) {
            this.addParentProperties(sd.getSnapshot().getElement(), dt.name, dt.parent, true, true);
        }
        this.produceProperties(sd.getSnapshot().getElement(), dt.name, dt.properties, true, true);
        if (dt.parent != null) {
            this.addParentProperties(sd.getSnapshot().getElement(), dt.name, dt.parent, false, true);
        }
        this.produceProperties(sd.getSnapshot().getElement(), dt.name, dt.properties, false, true);
        ed.getBase().setPath(ed.getPath()).setMin(ed.getMin()).setMax(ed.getMax());
        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream("c:\\temp\\iso21090\\StructureDefinition-" + dt.name + ".xml"), sd);
    }

    private void addParentProperties(List<ElementDefinition> elements, String name, String parent, boolean attrMode, boolean snapshot) throws FHIRFormatError {
        DataType dt = this.types.get(parent);
        if (dt == null) {
            throw new Error("No find " + parent);
        }
        if (dt.parent != null) {
            this.addParentProperties(elements, name, dt.parent, attrMode, snapshot);
        }
        this.produceProperties(elements, name, dt.properties, attrMode, snapshot);
    }

    private void produceProperties(List<ElementDefinition> elements, String name, List<Property> properties, boolean attrMode, boolean snapshot) throws FHIRFormatError {
        for (Property p : properties) {
            if (p.isattr != attrMode) continue;
            ElementDefinition ed = new ElementDefinition();
            elements.add(ed);
            ed.setPath(name + "." + p.name);
            if (p.type.startsWith("xsd:")) {
                ToolingExtensions.addStringExtension(ed.addType(), "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-type", p.type);
            } else {
                ed.addType().setCode(p.type);
            }
            ed.setMin(p.min);
            ed.setMax(p.max == Integer.MAX_VALUE ? "*" : Integer.toString(p.max));
            ed.setDefinition(p.doco);
            if (p.isattr) {
                ed.addRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR);
            }
            if (p.binding != null) {
                ed.getBinding().setStrength(Enumerations.BindingStrength.REQUIRED).setValueSet(new UriType("http://hl7.org/fhir/iso21090/ValueSet/" + p.binding));
            }
            if (!snapshot) continue;
            ed.getBase().setPath(ed.getPath()).setMin(ed.getMin()).setMax(ed.getMax());
        }
    }

    private void generateValueSet(EnumValueSet evs) throws Exception {
        ValueSet bvs = this.ctxt.fetchResource(ValueSet.class, evs.template);
        if (bvs == null) {
            throw new Exception("Did not find template value set " + evs.template);
        }
        ValueSet vs = bvs.copy();
        vs.getCompose().getInclude().clear();
        vs.getIdentifier().clear();
        vs.setName("ISO 20190 " + evs.name + " Enumeration");
        vs.setId(evs.name);
        vs.setUrl("http://hl7.org/fhir/iso21090/ValueSet/" + vs.getId());
        vs.setDate(new Date());
        vs.setExperimental(false);
        ValueSet.ConceptSetComponent inc = vs.getCompose().addInclude().setSystem(evs.system);
        for (String code : evs.codes) {
            inc.addConcept().setCode(code);
        }
        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream("c:\\temp\\iso21090\\ValueSet-" + evs.name + ".xml"), vs);
    }

    private void processDataTypes() {
        Element type = XMLUtil.getFirstChild(this.schema);
        while (type != null) {
            String n;
            if (type.getTagName().equals("xsd:complexType") && !(n = type.getAttribute("name")).contains(".") && !n.contains("_") && !n.equals("XReference")) {
                this.processDataType(n, type);
            }
            type = XMLUtil.getNextSibling(type);
        }
    }

    private void processDataType(String n, Element type) {
        Element cnt;
        DataType dt = new DataType();
        this.types.put(n, dt);
        dt.name = n;
        dt.doco = this.getDoco(type);
        Element ext = XMLUtil.getNamedChild(XMLUtil.getNamedChild(type, "xsd:complexContent"), "xsd:extension");
        if (ext != null) {
            dt.parent = ext.getAttribute("base");
            cnt = XMLUtil.getFirstChild(ext);
        } else {
            cnt = XMLUtil.getFirstChild(type);
        }
        if (cnt.getTagName().equals("xsd:annotation")) {
            cnt = XMLUtil.getNextSibling(cnt);
        }
        System.out.println(n + " (" + dt.parent + ")");
        while (cnt != null) {
            if (cnt.getTagName().equals("xsd:attribute")) {
                this.processAttribute(dt, cnt);
            } else if (cnt.getTagName().equals("xsd:sequence")) {
                Element e = XMLUtil.getFirstChild(cnt);
                while (e != null) {
                    if (e.getTagName().equals("xsd:element")) {
                        this.processElement(dt, e);
                    } else {
                        System.out.println("2. ignore " + e.getTagName());
                    }
                    e = XMLUtil.getNextSibling(e);
                }
            } else {
                System.out.println("ignore " + cnt.getTagName());
            }
            cnt = XMLUtil.getNextSibling(cnt);
        }
    }

    private void processElement(DataType dt, Element elem) {
        Property prop = new Property();
        prop.name = elem.getAttribute("name");
        prop.min = Integer.parseInt(elem.getAttribute("minOccurs"));
        prop.max = "unbounded".equals(elem.getAttribute("maxOccurs")) ? Integer.MAX_VALUE : Integer.parseInt(elem.getAttribute("maxOccurs"));
        prop.type = elem.getAttribute("type");
        prop.doco = this.getDoco(elem);
        dt.properties.add(prop);
        System.out.println("  " + prop.name + " : " + prop.type + " [" + Integer.toString(prop.min) + ".." + Integer.toString(prop.max) + "]");
    }

    private void processAttribute(DataType dt, Element attr) {
        Property prop = new Property();
        prop.name = attr.getAttribute("name");
        prop.type = attr.getAttribute("type");
        if (!prop.type.startsWith("xsd:")) {
            if (Utilities.noString(prop.type)) {
                prop.type = "xsd:string";
            } else if (this.bindings.containsKey(prop.type)) {
                prop.binding = prop.type;
                prop.type = "xsd:string";
            } else if (prop.type.startsWith("set_") && this.bindings.containsKey(prop.type.substring(4))) {
                prop.binding = prop.type.substring(4);
                prop.type = "xsd:string";
                prop.max = Integer.MAX_VALUE;
            } else if ("Uid".equals(prop.type)) {
                prop.type = "xsd:string";
            } else if ("Code".equals(prop.type)) {
                prop.type = "xsd:token";
            } else if ("Decimal".equals(prop.type)) {
                prop.type = "xsd:decimal";
            } else {
                throw new Error("Unknown type " + prop.type + " on " + dt.name + "." + prop.name);
            }
        }
        prop.min = "optional".equals(attr.getAttribute("use")) ? 0 : 1;
        prop.max = 1;
        prop.doco = this.getDoco(attr);
        prop.isattr = true;
        dt.properties.add(prop);
        System.out.println("  " + prop.name + " : " + prop.type + " [" + Integer.toString(prop.min) + ".." + Integer.toString(prop.max) + "]");
    }

    private void processEnums() {
        Element type = XMLUtil.getFirstChild(this.schema);
        while (type != null) {
            Element res;
            Element en;
            if (type.getTagName().equals("xsd:simpleType") && (en = XMLUtil.getFirstChild(res = XMLUtil.getFirstChild(type))) != null && en.getTagName().equals("xsd:enumeration") && !type.getAttribute("name").contains(".")) {
                this.processEnum(type.getAttribute("name"), en);
            }
            type = XMLUtil.getNextSibling(type);
        }
    }

    private void processEnum(String n, Element en) {
        EnumValueSet vs = new EnumValueSet();
        this.bindings.put(n, vs);
        vs.name = n;
        String v3n = n.contains("EntityName") ? n + "R2" : (n.equals("Compression") ? "CompressionAlgorithm" : (n.equals("UpdateMode") ? "HL7UpdateMode" : (n.equals("UncertaintyType") ? "ProbabilityDistributionType" : (n.equals("TelecommunicationAddressUse") || n.equals("PostalAddressUse") ? "AddressUse" : (n.equals("TelecommunicationCapability") ? "TelecommunicationCapabilities" : n)))));
        vs.system = "http://hl7.org/fhir/v3-" + v3n;
        vs.template = "http://hl7.org/fhir/ValueSet/v3-" + v3n;
        System.out.println("Enum: " + n + " == " + vs.system);
        while (en != null) {
            vs.codes.add(en.getAttribute("value"));
            vs.members.put(en.getAttribute("value"), this.getDoco(en));
            en = XMLUtil.getNextSibling(en);
        }
    }

    private String getDoco(Element en) {
        Element doco = XMLUtil.getNamedChild(XMLUtil.getNamedChild(en, "xsd:annotation"), "xsd:documentation");
        return doco == null ? null : doco.getTextContent();
    }

    private void load() throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new FileInputStream("C:\\work\\projects\\org.hl7.v3.dt\\iso\\iso-21090-datatypes.xsd"));
        this.schema = doc.getDocumentElement();
    }

    public class EnumValueSet {
        private String name;
        private String template;
        private String system;
        private List<String> codes = new ArrayList<String>();
        private Map<String, String> members = new HashMap<String, String>();
    }

    private class DataType {
        private boolean isAbstract;
        private String name;
        private String doco;
        private String parent;
        private List<Property> properties = new ArrayList<Property>();

        private DataType() {
        }
    }

    private class Property {
        private boolean isattr;
        private String name;
        private int min;
        private int max;
        private String type;
        private String doco;
        private String binding;

        private Property() {
        }
    }
}

