/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.formats.XmlParserBase;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class ICD11Generator {
    public static void main(String[] args) throws IOException {
        new ICD11Generator().execute(args[0], args[1]);
    }

    private void execute(String base, String dest) throws IOException {
        CodeSystem cs = this.makeMMSCodeSystem();
        JsonObject version = this.fetchJson(Utilities.pathURL(base, "/icd/release/11/mms"));
        String[] p = version.get("latestRelease").getAsString().split("\\/");
        cs.setVersion(p[6]);
        JsonObject root = this.fetchJson(this.url(base, version.get("latestRelease").getAsString()));
        cs.setDateElement(new DateTimeType(root.get("releaseDate").getAsString()));
        for (JsonElement child : root.getAsJsonArray("child")) {
            this.processMMSEntity(cs, base, child.getAsString(), cs.addConcept(), dest);
            System.out.println();
        }
        new XmlParser(XmlParserBase.XmlVersion.V1_1).setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(dest, "icd-11-mms.xml")), cs);
        this.makeFullVs(dest, cs);
        cs = this.makeEntityCodeSystem();
        root = this.fetchJson(Utilities.pathURL(base, "/icd/entity"));
        cs.setVersion(root.get("releaseId").getAsString());
        cs.setDateElement(new DateTimeType(root.get("releaseDate").getAsString()));
        cs.setTitle(this.readString(root, "title"));
        HashSet<String> ids = new HashSet<String>();
        for (JsonElement child : root.getAsJsonArray("child")) {
            this.processEntity(cs, ids, base, this.tail(child.getAsString()), dest);
            System.out.println();
        }
        new XmlParser(XmlParserBase.XmlVersion.V1_1).setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(dest, "icd-11-foundation.xml")), cs);
        this.makeFullVs2(dest, cs);
        System.out.println("finished");
    }

    private void processEntity(CodeSystem cs, Set<String> ids, String base, String id, String dest) throws IOException {
        if (!ids.contains(id)) {
            String v;
            String v2;
            JsonObject co;
            System.out.print(".");
            ids.add(id);
            CodeSystem.ConceptDefinitionComponent cc = cs.addConcept().setCode(id);
            JsonObject entity = this.fetchJson(Utilities.pathURL(base, "icd", "entity", id));
            cc.setDisplay(this.readString(entity, "title"));
            String d = this.readString(entity, "definition");
            if (d != null) {
                cc.setDefinition(d);
            }
            if (entity.has("inclusion")) {
                for (JsonElement child : entity.getAsJsonArray("inclusion")) {
                    co = (JsonObject)child;
                    v2 = this.readString(co, "label");
                    if (v2 == null || !co.has("foundationReference")) continue;
                    cc.addProperty().setValue(new Coding().setSystem("http://id.who.int/icd11/foundation").setCode(this.tail(co.get("foundationReference").getAsString())).setDisplay(v2)).setCode("inclusion");
                }
            }
            if (entity.has("exclusion")) {
                for (JsonElement child : entity.getAsJsonArray("exclusion")) {
                    co = (JsonObject)child;
                    v2 = this.readString(co, "label");
                    if (v2 == null || !co.has("foundationReference")) continue;
                    cc.addProperty().setValue(new Coding().setSystem("http://id.who.int/icd11/foundation").setCode(this.tail(co.get("foundationReference").getAsString())).setDisplay(v2)).setCode("exclusion");
                }
            }
            if (entity.has("narrowerTerm")) {
                for (JsonElement child : entity.getAsJsonArray("narrowerTerm")) {
                    co = (JsonObject)child;
                    v2 = this.readString(co, "label");
                    if (v2 == null || !co.has("narrowerTerm")) continue;
                    cc.addProperty().setValue(new Coding().setSystem("http://id.who.int/icd11/foundation").setCode(this.tail(co.get("foundationReference").getAsString())).setDisplay(v2)).setCode("narrowerTerm");
                }
            }
            this.addDesignation(this.readString(entity, "longDefinition"), cc, "http://id.who.int/icd11/mms/designation", "longDefinition");
            this.addDesignation(this.readString(entity, "fullySpecifiedName"), cc, "http://snomed.info/sct", "900000000000003001");
            if (entity.has("synonym")) {
                for (JsonElement j : entity.getAsJsonArray("synonym")) {
                    v = this.readString((JsonObject)j, "label");
                    if (v == null || v.equals(cc.getDisplay())) continue;
                    this.addDesignation(v, cc, "http://id.who.int/icd11/mms/designation", "synonym");
                }
            }
            for (JsonElement j : entity.getAsJsonArray("parent")) {
                v = j.getAsString();
                if ("http://id.who.int/icd/entity".equals(v)) continue;
                cc.addProperty().setValue(new CodeType(this.tail(v))).setCode("narrowerTerm");
            }
            if (entity.has("child")) {
                for (JsonElement j : entity.getAsJsonArray("child")) {
                    v = j.getAsString();
                    cc.addProperty().setValue(new CodeType(this.tail(v))).setCode("child");
                    this.processEntity(cs, ids, base, this.tail(v), dest);
                }
            }
        }
    }

    private void makeFullVs(String dest, CodeSystem cs) throws FileNotFoundException, IOException {
        String url = "http://id.who.int/icd11/ValueSet/all-MMS";
        ValueSet vs = new ValueSet();
        vs.setId("all-MMS");
        vs.setUrl(url);
        vs.setName("ICDMMSAll");
        vs.setTitle("Value Set for all ICD MMS Codes");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.setExperimental(false);
        vs.setDate(cs.getDate());
        vs.setPublisher("WHO");
        vs.setCopyright("Consult WHO For terms of use");
        vs.setVersion(cs.getVersion());
        vs.setStatus(cs.getStatus());
        ValueSet.ConceptSetComponent inc = vs.getCompose().addInclude();
        inc.setSystem(cs.getUrl());
        new XmlParser(XmlParserBase.XmlVersion.V1_1).setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(dest, "vs-all-MMS.xml")), vs);
    }

    private void makeFullVs2(String dest, CodeSystem cs) throws FileNotFoundException, IOException {
        String url = "http://id.who.int/icd11/ValueSet/all-foundation";
        ValueSet vs = new ValueSet();
        vs.setId("all-foundation");
        vs.setUrl(url);
        vs.setName("ICDFoundationAll");
        vs.setTitle("Value Set for all ICD Foundation Concepts");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.setExperimental(false);
        vs.setDate(cs.getDate());
        vs.setPublisher("WHO");
        vs.setCopyright("Consult WHO For terms of use");
        vs.setVersion(cs.getVersion());
        vs.setStatus(cs.getStatus());
        ValueSet.ConceptSetComponent inc = vs.getCompose().addInclude();
        inc.setSystem(cs.getUrl());
        new XmlParser(XmlParserBase.XmlVersion.V1_1).setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(dest, "vs-all-foundation.xml")), vs);
    }

    private void processMMSEntity(CodeSystem cs, String base, String ref, CodeSystem.ConceptDefinitionComponent cc, String dest) throws IOException {
        boolean first;
        System.out.print(".");
        JsonObject entity = this.fetchJson(this.url(base, ref));
        cc.setId(this.tail(ref));
        if (entity.has("code") && !Utilities.noString(entity.get("code").getAsString())) {
            cc.setCode(entity.get("code").getAsString());
        } else if (entity.has("blockId") && !Utilities.noString(entity.get("blockId").getAsString())) {
            cc.setCode(entity.get("blockId").getAsString());
        } else {
            cc.setCode(cc.getId());
            cc.addProperty().setCode("abstract").setValue(new BooleanType(true));
        }
        if (entity.has("classKind") && !Utilities.noString(entity.get("classKind").getAsString()) && !"category".equals(entity.get("classKind").getAsString())) {
            cc.addProperty().setCode("kind").setValue(new CodeType(entity.get("classKind").getAsString()));
        }
        cc.setDisplay(this.readString(entity, "title"));
        StringBuilder defn = new StringBuilder();
        String d = this.readString(entity, "definition");
        if (d != null) {
            defn.append(d);
        }
        if (d == null && (entity.has("inclusion") || entity.has("exclusion"))) {
            defn.append(cc.getDisplay());
        }
        if (entity.has("inclusion")) {
            defn.append(". Includes: ");
            first = true;
            for (JsonElement child : entity.getAsJsonArray("inclusion")) {
                if (first) {
                    first = false;
                } else {
                    defn.append(", ");
                }
                defn.append(this.readString((JsonObject)child, "label"));
            }
        }
        if (entity.has("exclusion")) {
            defn.append(". Excludes: ");
            first = true;
            for (JsonElement child : entity.getAsJsonArray("exclusion")) {
                JsonObject co;
                String v;
                if (first) {
                    first = false;
                } else {
                    defn.append(", ");
                }
                if ((v = this.readString(co = (JsonObject)child, "label")) == null) continue;
                defn.append(v);
                if (!co.has("linearizationReference")) continue;
                cc.addProperty().setValue(new Coding().setSystem("http://id.who.int/icd11/mms").setCode(this.tail(co.get("linearizationReference").getAsString())).setDisplay(v)).setCode("exclusion");
            }
        }
        cc.setDefinition(defn.toString());
        this.addDesignation(this.readString(entity, "longDefinition"), cc, "http://id.who.int/icd11/mms/designation", "longDefinition");
        this.addDesignation(this.readString(entity, "fullySpecifiedName"), cc, "http://snomed.info/sct", "900000000000003001");
        this.addProperty(this.readString(entity, "codingNote"), cc, "codingNote");
        if (entity.has("indexTerm")) {
            for (JsonElement child : entity.getAsJsonArray("indexTerm")) {
                this.processIndexTerm(cc, (JsonObject)child);
            }
        }
        if (entity.has("postcoordinationScale")) {
            for (JsonElement child : entity.getAsJsonArray("postcoordinationScale")) {
                JsonObject o = (JsonObject)child;
                String name = this.tail(o.get("axisName").getAsString());
                CodeSystem.ConceptPropertyComponent prop = cc.addProperty();
                prop.setCode("postcoordinationScale");
                prop.setValue(new CodeType(name));
                ToolingExtensions.addBooleanExtension(prop, "http://id.who.int/icd11/extensions/required", o.get("requiredPostcoordination").getAsBoolean());
                ToolingExtensions.addBooleanExtension(prop, "http://id.who.int/icd11/extensions/repeats", o.get("allowMultipleValues").getAsBoolean());
                if (!o.has("scaleEntity")) continue;
                ToolingExtensions.addUriExtension(prop, "http://id.who.int/icd11/extensions/valueSet", this.buildValueSet(cs, cc.getCode(), name, o, dest));
            }
        }
        if (entity.has("child")) {
            for (JsonElement child : entity.getAsJsonArray("child")) {
                this.processMMSEntity(cs, base, child.getAsString(), cc.addConcept(), dest);
            }
        }
    }

    private String buildValueSet(CodeSystem cs, String code, String name, JsonObject o, String dest) throws FileNotFoundException, IOException {
        String id = code + "-" + name;
        String url = "http://id.who.int/icd11/ValueSet/" + id;
        ValueSet vs = new ValueSet();
        vs.setId(id);
        vs.setUrl(url);
        vs.setName("VS" + name + "4" + code);
        vs.setTitle("Value Set for " + name + " on " + code);
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.setExperimental(false);
        vs.setDate(cs.getDate());
        vs.setPublisher("WHO");
        vs.setCopyright("Consult WHO For terms of use");
        vs.setVersion(cs.getVersion());
        vs.setStatus(cs.getStatus());
        ValueSet.ConceptSetComponent inc = vs.getCompose().addInclude();
        inc.setSystem(cs.getUrl());
        for (JsonElement e : o.getAsJsonArray("scaleEntity")) {
            inc.addFilter().setProperty("concept").setOp(ValueSet.FilterOperator.ISA).setValue(this.tail(e.getAsString()));
        }
        new XmlParser(XmlParserBase.XmlVersion.V1_1).setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(Utilities.path(dest, "vs-" + id + ".xml")), vs);
        return url;
    }

    private void processIndexTerm(CodeSystem.ConceptDefinitionComponent cc, JsonObject child) {
        String s2 = this.readString(child, "label");
        if (s2 != null && !s2.equals(cc.getDisplay())) {
            cc.addDesignation().setValue(s2).setUse(new Coding().setSystem("http://id.who.int/icd11/mms/designation").setCode("term"));
        }
    }

    private String tail(String ref) {
        return ref.substring(ref.lastIndexOf("/") + 1);
    }

    private void addExtension(String v, CodeSystem.ConceptDefinitionComponent cc, String url) {
        if (v != null) {
            ToolingExtensions.setStringExtension(cc, url, v);
        }
    }

    private void addDesignation(String v, CodeSystem.ConceptDefinitionComponent cc, String system, String code) {
        if (v != null) {
            cc.addDesignation().setValue(v.replace("\r", "").replace("\n", "")).setUse(new Coding().setSystem(system).setCode(code));
        }
    }

    private void addProperty(String v, CodeSystem.ConceptDefinitionComponent cc, String code) {
        if (v != null) {
            cc.addProperty().setValue(new StringType(v.replace("\r", " ").replace("\n", ""))).setCode(code);
        }
    }

    private String readString(JsonObject obj, String name) {
        JsonObject p = obj.getAsJsonObject(name);
        if (p == null) {
            return null;
        }
        if (p.has("@value")) {
            return p.get("@value").getAsString();
        }
        return null;
    }

    private String url(String base, String u) {
        return u.replace("http://id.who.int", base);
    }

    private CodeSystem makeMMSCodeSystem() {
        CodeSystem cs = new CodeSystem();
        cs.setId("icd11-mms");
        cs.setUrl("http://id.who.int/icd11/mms");
        cs.setName("ICD11MMS");
        cs.setTitle("ICD-11 MMS Linearization");
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        cs.setExperimental(false);
        cs.setDate(new Date());
        cs.setPublisher("WHO");
        cs.setCopyright("Consult WHO For terms of use");
        cs.setCaseSensitive(true);
        cs.setHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
        cs.setCompositional(true);
        cs.setVersionNeeded(true);
        cs.setValueSet("http://id.who.int/icd11/ValueSet/all-MMS");
        cs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
        CodeSystemUtilities.defineCodeSystemProperty(cs, "kind", "The kind of artifact this concept represents", CodeSystem.PropertyType.CODE).setUri("http://id.who.int/icd11/properties#kind");
        CodeSystemUtilities.defineCodeSystemProperty(cs, "terms", "Other keywords for searching", CodeSystem.PropertyType.STRING).setUri("http://id.who.int/icd11/properties#terms");
        CodeSystemUtilities.defineCodeSystemProperty(cs, "codingNote", "Coding advice for this concept", CodeSystem.PropertyType.STRING).setUri("http://id.who.int/icd11/properties#codingNote");
        CodeSystemUtilities.defineCodeSystemProperty(cs, "exclusion", "References to diseases that are excluded from this concept", CodeSystem.PropertyType.CODING).setUri("http://id.who.int/icd11/properties#exclusion");
        CodeSystemUtilities.defineCodeSystemProperty(cs, "abstract", "If concept is abstract", CodeSystem.PropertyType.BOOLEAN);
        CodeSystemUtilities.defineCodeSystemProperty(cs, "postcoordinationScale", "", CodeSystem.PropertyType.CODE).setUri("http://id.who.int/icd11/properties#postcoordinationScale");
        return cs;
    }

    private CodeSystem makeEntityCodeSystem() {
        CodeSystem cs = new CodeSystem();
        cs.setId("icd11-foundation");
        cs.setUrl("http://id.who.int/icd11/foundation");
        cs.setName("ICD11Entity");
        cs.setTitle("ICD-11 Entities (Foundation)");
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        cs.setExperimental(false);
        cs.setDate(new Date());
        cs.setPublisher("WHO");
        cs.setCopyright("Consult WHO For terms of use");
        cs.setCaseSensitive(true);
        cs.setHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning.ISA);
        cs.setValueSet("http://id.who.int/icd11/ValueSet/all-foundation");
        cs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
        CodeSystemUtilities.defineCodeSystemProperty(cs, "exclusion", "References to diseases that are excluded from this concept", CodeSystem.PropertyType.CODING).setUri("http://id.who.int/icd11/properties#exclusion");
        CodeSystemUtilities.defineCodeSystemProperty(cs, "inclusion", "References to diseases that are included from this concept", CodeSystem.PropertyType.CODING).setUri("http://id.who.int/icd11/properties#inclusion");
        CodeSystemUtilities.defineCodeSystemProperty(cs, "narrowerTerm", "Narrower terms for this entity", CodeSystem.PropertyType.CODE).setUri("http://id.who.int/icd11/properties#narrowerTerm");
        CodeSystemUtilities.defineCodeSystemProperty(cs, "parent", "Parent for this concept", CodeSystem.PropertyType.CODE);
        CodeSystemUtilities.defineCodeSystemProperty(cs, "child", "Child for this concept", CodeSystem.PropertyType.CODE);
        return cs;
    }

    private JsonObject fetchJson(String source) throws IOException {
        URL url = new URL(source);
        URLConnection c = url.openConnection();
        c.addRequestProperty("Accept", "application/json");
        c.addRequestProperty("API-Version", "v2");
        c.addRequestProperty("Accept-Language", "en");
        return (JsonObject)new JsonParser().parse(TextFile.streamToString(c.getInputStream()));
    }
}

