/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hl7.fhir.convertors.misc.ADLImporter;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CKMImporter {
    private String ckm;
    private String dest;
    private String config;
    private String info;

    public static void main(String[] args) throws Exception {
        CKMImporter self = new CKMImporter();
        self.ckm = CKMImporter.getParam(args, "ckm");
        self.dest = CKMImporter.getParam(args, "dest");
        self.config = CKMImporter.getParam(args, "config");
        self.info = CKMImporter.getParam(args, "info");
        if (self.ckm == null || self.dest == null || self.config == null) {
            System.out.println("ADL to FHIR StructureDefinition Converter");
            System.out.println("This tool takes 4 parameters:");
            System.out.println("-ckm: Baase URL of CKM");
            System.out.println("-dest: folder for output");
            System.out.println("-config: filename of OpenEHR/FHIR knowlege base (required)");
            System.out.println("-info: folder for additional knowlege of archetypes");
        } else {
            self.execute();
        }
    }

    private static String getParam(String[] args, String name) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-" + name)) continue;
            return args[i + 1];
        }
        return null;
    }

    private void execute() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        Document xml = this.loadXml(this.ckm + "/services/ArchetypeFinderBean/getAllArchetypeIds");
        Element e = XMLUtil.getFirstChild(xml.getDocumentElement());
        while (e != null) {
            ids.add(e.getTextContent());
            e = XMLUtil.getNextSibling(e);
        }
        for (String id : ids) {
            this.processArchetype(id);
        }
    }

    private void downloadArchetype(String id) throws Exception {
        System.out.println("Fetch " + id);
        Document sxml = this.loadXml(this.ckm + "/services/ArchetypeFinderBean/getArchetypeInXML?archetypeId=" + id);
        Element e = XMLUtil.getFirstChild(sxml.getDocumentElement());
        String src = Utilities.path("c:\\temp", id + ".xml");
        TextFile.stringToFile(e.getTextContent(), src);
    }

    private void processArchetype(String id) throws Exception {
        System.out.println("Process " + id);
        String cfg = this.info == null ? null : Utilities.path(this.info, id + ".config");
        String src = Utilities.path("c:\\temp", id + ".xml");
        String dst = Utilities.path(this.dest, id + ".xml");
        if (!new File(src).exists()) {
            this.downloadArchetype(id);
        }
        if (cfg != null && new File(cfg).exists()) {
            ADLImporter.main(new String[]{"-source", src, "-dest", dst, "-config", this.config, "-info", cfg});
        } else {
            ADLImporter.main(new String[]{"-source", src, "-dest", dst, "-config", this.config});
        }
    }

    private Document loadXml(String address) throws Exception {
        URL url = new URL(address);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/xml");
        InputStream xml = connection.getInputStream();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(xml);
    }
}

