/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.convertors.misc.CDAUtilities;
import org.hl7.fhir.convertors.misc.Convert;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Comparison;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Factory;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceFactory;
import org.hl7.fhir.dstu3.utils.NarrativeGenerator;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.w3c.dom.Element;

public class CCDAConverter {
    protected CDAUtilities cda;
    protected Element doc;
    protected Convert convert;
    protected Bundle feed;
    protected Composition composition;
    protected Map<String, Practitioner> practitionerCache = new HashMap<String, Practitioner>();
    protected Integer refCounter = 0;
    protected UcumService ucumSvc;
    protected IWorkerContext context;

    public CCDAConverter(UcumService ucumSvc, IWorkerContext context) {
        this.ucumSvc = ucumSvc;
        this.context = context;
    }

    public Bundle convert(InputStream stream) throws Exception {
        this.cda = new CDAUtilities(stream);
        this.doc = this.cda.getElement();
        this.cda.checkTemplateId(this.doc, "2.16.840.1.113883.10.20.22.1.1");
        this.convert = new Convert(this.cda, this.ucumSvc, "Z");
        this.feed = new Bundle();
        this.feed.setMeta(new Meta().setLastUpdatedElement(InstantType.now()));
        this.feed.setId(this.makeUUIDReference());
        this.feed.getMeta().getTag().add(new Coding());
        this.makeDocument();
        this.composition.setSubject(Factory.makeReference(this.makeSubject()));
        for (Element e : this.cda.getChildren(this.doc, "author")) {
            this.composition.getAuthor().add(Factory.makeReference(this.makeAuthor(e)));
        }
        this.composition.setCustodian(Factory.makeReference(this.makeOrganization(this.cda.getDescendent(this.doc, "custodian/assignedCustodian/representedCustodianOrganization"), "Custodian")));
        for (Element e : this.cda.getChildren(this.doc, "legalAuthenticator")) {
            this.composition.getAttester().add(this.makeAttester(e, Composition.CompositionAttestationMode.LEGAL, "Legal Authenticator"));
        }
        for (Element e : this.cda.getChildren(this.doc, "authenticator")) {
            this.composition.getAttester().add(this.makeAttester(e, Composition.CompositionAttestationMode.PROFESSIONAL, "Authenticator"));
        }
        Element body = this.cda.getDescendent(this.doc, "component/structuredBody");
        this.processComponentSections(this.composition.getSection(), body);
        return this.feed;
    }

    protected String addReference(DomainResource r, String title, String id) throws Exception {
        if (r.getText() == null) {
            r.setText(new Narrative());
        }
        if (r.getText().getDiv() == null) {
            r.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
            new NarrativeGenerator("", "", this.context).generate(r);
        }
        r.setMeta(new Meta().setLastUpdatedElement(InstantType.now()));
        r.setId(id);
        this.feed.getEntry().add(new Bundle.BundleEntryComponent().setResource(r));
        return id;
    }

    protected void makeDocument() throws Exception {
        Element ee;
        this.composition = (Composition)ResourceFactory.createResource("Composition");
        this.addReference(this.composition, "Composition", this.makeUUIDReference());
        Element title = this.cda.getChild(this.doc, "title");
        this.composition.setTitle(title.getTextContent());
        if (this.cda.getChild(this.doc, "setId") != null) {
            this.feed.setId(this.convert.makeURIfromII(this.cda.getChild(this.doc, "id")));
            this.composition.setIdentifier(this.convert.makeIdentifierFromII(this.cda.getChild(this.doc, "setId")));
        } else {
            this.composition.setIdentifier(this.convert.makeIdentifierFromII(this.cda.getChild(this.doc, "id")));
        }
        this.composition.setDateElement(this.convert.makeDateTimeFromTS(this.cda.getChild(this.doc, "effectiveTime")));
        this.composition.setType(this.convert.makeCodeableConceptFromCD(this.cda.getChild(this.doc, "code")));
        this.composition.setConfidentiality(this.convertConfidentiality(this.cda.getChild(this.doc, "confidentialityCode")));
        if (this.cda.getChild(this.doc, "confidentialityCode") != null) {
            this.composition.setLanguage(this.cda.getChild(this.doc, "confidentialityCode").getAttribute("value"));
        }
        if ((ee = this.cda.getChild(this.doc, "componentOf")) != null) {
            ee = this.cda.getChild(ee, "encompassingEncounter");
        }
        if (ee != null) {
            Encounter visit = new Encounter();
            for (Element e : this.cda.getChildren(ee, "id")) {
                visit.getIdentifier().add(this.convert.makeIdentifierFromII(e));
            }
            visit.setPeriod(this.convert.makePeriodFromIVL(this.cda.getChild(ee, "effectiveTime")));
            this.composition.getEvent().add(new Composition.CompositionEventComponent());
            this.composition.getEvent().get(0).getCode().add(this.convert.makeCodeableConceptFromCD(this.cda.getChild(ee, "code")));
            this.composition.getEvent().get(0).setPeriod(visit.getPeriod());
            this.composition.getEvent().get(0).getDetail().add(Factory.makeReference(this.addReference(visit, "Encounter", this.makeUUIDReference())));
        }
    }

    protected Composition.DocumentConfidentiality convertConfidentiality(Element child) throws FHIRException, FHIRException {
        return Composition.DocumentConfidentiality.fromCode(child.getAttribute("code"));
    }

    protected String makeSubject() throws Exception {
        Element rt = this.cda.getChild(this.doc, "recordTarget");
        Element pr = this.cda.getChild(rt, "patientRole");
        Element p = this.cda.getChild(pr, "patient");
        Patient pat = (Patient)ResourceFactory.createResource("Patient");
        for (Element e : this.cda.getChildren(pr, "id")) {
            pat.getIdentifier().add(this.convert.makeIdentifierFromII(e));
        }
        for (Element e : this.cda.getChildren(pr, "addr")) {
            pat.getAddress().add(this.convert.makeAddressFromAD(e));
        }
        for (Element e : this.cda.getChildren(pr, "telecom")) {
            pat.getTelecom().add(this.convert.makeContactFromTEL(e));
        }
        for (Element e : this.cda.getChildren(p, "name")) {
            pat.getName().add(this.convert.makeNameFromEN(e));
        }
        pat.setGender(this.convert.makeGenderFromCD(this.cda.getChild(p, "administrativeGenderCode")));
        pat.setBirthDateElement(this.convert.makeDateFromTS(this.cda.getChild(p, "birthTime")));
        pat.setMaritalStatus(this.convert.makeCodeableConceptFromCD(this.cda.getChild(p, "maritalStatusCode")));
        pat.getExtension().add(Factory.newExtension("http://hl7.org/ccda/religious-affiliation", this.convert.makeCodeableConceptFromCD(this.cda.getChild(p, "religiousAffiliationCode")), false));
        pat.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/us-core-race", this.convert.makeCodeableConceptFromCD(this.cda.getChild(p, "raceCode")), false));
        pat.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/us-core-ethnicity", this.convert.makeCodeableConceptFromCD(this.cda.getChild(p, "ethnicGroupCode")), false));
        pat.getExtension().add(Factory.newExtension("http://hl7.org/ccdabirthplace", this.convert.makeAddressFromAD(this.cda.getChild(p, new String[]{"birthplace", "place", "addr"})), false));
        Patient.ContactComponent guardian = new Patient.ContactComponent();
        pat.getContact().add(guardian);
        guardian.getRelationship().add(Factory.newCodeableConcept("GUARD", "urn:oid:2.16.840.1.113883.5.110", "guardian"));
        Element g2 = this.cda.getChild(p, "guardian");
        for (Element e : this.cda.getChildren(g2, "addr")) {
            if (guardian.getAddress() != null) continue;
            guardian.setAddress(this.convert.makeAddressFromAD(e));
        }
        for (Element e : this.cda.getChildren(g2, "telecom")) {
            guardian.getTelecom().add(this.convert.makeContactFromTEL(e));
        }
        g2 = this.cda.getChild(g2, "guardianPerson");
        for (Element e : this.cda.getChildren(g2, "name")) {
            if (guardian.getName() != null) continue;
            guardian.setName(this.convert.makeNameFromEN(e));
        }
        Element l = this.cda.getChild(p, "languageCommunication");
        CodeableConcept cc = new CodeableConcept();
        Coding c = new Coding();
        c.setCode(this.cda.getChild(l, "languageCode").getAttribute("code"));
        cc.getCoding().add(c);
        pat.addCommunication().setLanguage(cc);
        cc.getExtension().add(Factory.newExtension("http://hl7.org/ccdaproficiency-level", this.convert.makeCodeableConceptFromCD(this.cda.getChild(l, "modeCode")), false));
        pat.getExtension().add(Factory.newExtension("http://hl7.org/ccda/religious-affiliation", this.convert.makeCodeableConceptFromCD(this.cda.getChild(p, "religiousAffiliationCode")), false));
        pat.setManagingOrganization(Factory.makeReference(this.makeOrganization(this.cda.getChild(pr, "providerOrganization"), "Provider")));
        return this.addReference(pat, "Subject", this.makeUUIDReference());
    }

    protected String makeOrganization(Element org, String name) throws Exception {
        Organization o = new Organization();
        for (Element e : this.cda.getChildren(org, "id")) {
            o.getIdentifier().add(this.convert.makeIdentifierFromII(e));
        }
        for (Element e : this.cda.getChildren(org, "name")) {
            o.setName(e.getTextContent());
        }
        for (Element e : this.cda.getChildren(org, "addr")) {
            o.getAddress().add(this.convert.makeAddressFromAD(e));
        }
        for (Element e : this.cda.getChildren(org, "telecom")) {
            o.getTelecom().add(this.convert.makeContactFromTEL(e));
        }
        return this.addReference(o, name, this.makeUUIDReference());
    }

    protected String makeAuthor(Element auth) throws Exception {
        Element aa = this.cda.getChild(auth, "assignedAuthor");
        Element ap = this.cda.getChild(aa, "assignedPerson");
        Practitioner pr = (Practitioner)ResourceFactory.createResource("Practitioner");
        for (Element e : this.cda.getChildren(aa, "id")) {
            pr.getIdentifier().add(this.convert.makeIdentifierFromII(e));
        }
        for (Element e : this.cda.getChildren(aa, "addr")) {
            if (pr.getAddress() != null) continue;
            pr.getAddress().add(this.convert.makeAddressFromAD(e));
        }
        for (Element e : this.cda.getChildren(aa, "telecom")) {
            pr.getTelecom().add(this.convert.makeContactFromTEL(e));
        }
        for (Element e : this.cda.getChildren(ap, "name")) {
            if (pr.getName() == null) continue;
            pr.addName(this.convert.makeNameFromEN(e));
        }
        return this.addReference(pr, "Author", this.makeUUIDReference());
    }

    protected String makeUUIDReference() {
        return "urn:uuid:" + UUID.randomUUID().toString().toLowerCase();
    }

    protected Composition.CompositionAttesterComponent makeAttester(Element a1, Composition.CompositionAttestationMode mode, String title) throws Exception {
        Practitioner pr = (Practitioner)ResourceFactory.createResource("Practitioner");
        Element ass = this.cda.getChild(a1, "assignedEntity");
        for (Element element : this.cda.getChildren(ass, "id")) {
            pr.getIdentifier().add(this.convert.makeIdentifierFromII(element));
        }
        for (Element element : this.cda.getChildren(ass, "addr")) {
            if (pr.getAddress() != null) continue;
            pr.getAddress().add(this.convert.makeAddressFromAD(element));
        }
        for (Element element : this.cda.getChildren(ass, "telecom")) {
            pr.getTelecom().add(this.convert.makeContactFromTEL(element));
        }
        Element ap = this.cda.getChild(ass, "assignedPerson");
        for (Element e : this.cda.getChildren(ap, "name")) {
            if (pr.getName() != null) continue;
            pr.addName(this.convert.makeNameFromEN(e));
        }
        Composition.CompositionAttesterComponent compositionAttesterComponent = new Composition.CompositionAttesterComponent();
        compositionAttesterComponent.addMode(mode);
        compositionAttesterComponent.setTimeElement(this.convert.makeDateTimeFromTS(this.cda.getChild(a1, "time")));
        compositionAttesterComponent.setParty(Factory.makeReference(this.addReference(pr, title, this.makeUUIDReference())));
        return compositionAttesterComponent;
    }

    protected void processComponentSections(List<Composition.SectionComponent> sections, Element container) throws Exception {
        for (Element c : this.cda.getChildren(container, "component")) {
            Composition.SectionComponent s2 = this.processSection(this.cda.getChild(c, "section"));
            if (s2 == null) continue;
            sections.add(s2);
        }
    }

    protected Composition.SectionComponent processSection(Element section) throws Exception {
        this.checkNoSubject(section, "Section");
        if (this.cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.6") || this.cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.6.1")) {
            return this.processAdverseReactionsSection(section);
        }
        if (this.cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.7") || this.cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.7.1")) {
            return this.processProceduresSection(section);
        }
        if (this.cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.17")) {
            return this.processSocialHistorySection(section);
        }
        if (this.cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.4") || this.cda.hasTemplateId(section, "2.16.840.1.113883.10.20.22.2.4.1")) {
            return this.processVitalSignsSection(section);
        }
        return null;
    }

    protected void checkNoSubject(Element act, String path) throws Exception {
        if (this.cda.getChild(act, "subject") != null) {
            throw new Exception("The conversion program cannot accept a nullFlavor at the location " + path);
        }
    }

    protected Composition.SectionComponent processProceduresSection(Element section) throws Exception {
        ListResource list = new ListResource();
        for (Element entry : this.cda.getChildren(section, "entry")) {
            Element procedure = this.cda.getlastChild(entry);
            if (this.cda.hasTemplateId(procedure, "2.16.840.1.113883.10.20.22.4.14")) {
                this.processProcedure(list, procedure, ProcedureType.Procedure);
                continue;
            }
            if (this.cda.hasTemplateId(procedure, "2.16.840.1.113883.10.20.22.4.13")) {
                this.processProcedure(list, procedure, ProcedureType.Observation);
                continue;
            }
            if (this.cda.hasTemplateId(procedure, "2.16.840.1.113883.10.20.22.4.12")) {
                this.processProcedure(list, procedure, ProcedureType.Act);
                continue;
            }
            throw new Exception("Unhandled Section template ids: " + this.cda.showTemplateIds(procedure));
        }
        Composition.SectionComponent s2 = new Composition.SectionComponent();
        s2.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(section, "code")));
        s2.addEntry(Factory.makeReference(this.addReference(list, "Procedures", this.makeUUIDReference())));
        return s2;
    }

    protected void processProcedure(ListResource list, Element procedure, ProcedureType type) throws Exception {
        switch (type) {
            case Procedure: {
                this.cda.checkTemplateId(procedure, "2.16.840.1.113883.10.20.22.4.14");
                break;
            }
            case Observation: {
                this.cda.checkTemplateId(procedure, "2.16.840.1.113883.10.20.22.4.13");
                break;
            }
            case Act: {
                this.cda.checkTemplateId(procedure, "2.16.840.1.113883.10.20.22.4.12");
            }
        }
        this.checkNoNegationOrNullFlavor(procedure, "Procedure (" + type.toString() + ")");
        this.checkNoSubject(procedure, "Procedure (" + type.toString() + ")");
        Procedure p = new Procedure();
        this.addItemToList(list, p);
        if (procedure.getAttribute("moodCode").equals("INT")) {
            p.getModifierExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/procedure-planned", Factory.newBoolean(true), false));
        }
        for (Element e : this.cda.getChildren(procedure, "id")) {
            p.getIdentifier().add(this.convert.makeIdentifierFromII(e));
        }
        p.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(procedure, "code")));
        p.getModifierExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/procedure-status", Factory.newCode(this.cda.getStatus(procedure)), false));
        p.setPerformed(this.convert.makePeriodFromIVL(this.cda.getChild(procedure, "effectiveTime")));
        p.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/procedure-priority", this.convert.makeCodeableConceptFromCD(this.cda.getChild(procedure, "priorityCode")), false));
        p.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/procedure-method", this.convert.makeCodeableConceptFromCD(this.cda.getChild(procedure, "methodCode")), false));
        if (type == ProcedureType.Observation) {
            // empty if block
        }
        for (Element e : this.cda.getChildren(procedure, "targetSiteCode")) {
            p.addBodySite(this.convert.makeCodeableConceptFromCD(e));
        }
        for (Element e : this.cda.getChildren(procedure, "performer")) {
            Procedure.ProcedurePerformerComponent pp = new Procedure.ProcedurePerformerComponent();
            p.getPerformer().add(pp);
            pp.setActor(this.makeReferenceToPractitionerForAssignedEntity(e, p));
        }
        for (Element participant : this.cda.getChildren(procedure, "participant")) {
            Element participantRole = this.cda.getlastChild(participant);
            if (type == ProcedureType.Procedure && this.cda.hasTemplateId(participantRole, "2.16.840.1.113883.10.20.22.4.37")) {
                p.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/implanted-devices", Factory.makeReference(this.processDevice(participantRole, p)), false));
                continue;
            }
            if (!this.cda.hasTemplateId(participantRole, "2.16.840.1.113883.10.20.22.4.32")) continue;
            p.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/location", Factory.makeReference(this.processSDLocation(participantRole, p)), false));
        }
        for (Element e : this.cda.getChildren(procedure, "entryRelationship")) {
            Element a = this.cda.getlastChild(e);
            if (a.getLocalName().equals("encounter")) continue;
            if (this.cda.hasTemplateId(a, "2.16.840.1.113883.10.20.22.4.20")) {
                Extension n = Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/procedure-instructions", null, true);
                n.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/procedure-instructions-type", this.convert.makeCodeableConceptFromCD(this.cda.getChild(a, "code")), false));
                n.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/procedure-instructions-text", this.convert.makeStringFromED(this.cda.getChild(a, "text")), false));
                p.getExtension().add(n);
                continue;
            }
            if (this.cda.hasTemplateId(a, "2.16.840.1.113883.10.20.22.4.19")) {
                p.addReasonCode(this.processIndication(a));
                continue;
            }
            if (!this.cda.hasTemplateId(this.cda.getlastChild(e), "2.16.840.1.113883.10.20.22.4.16")) continue;
        }
    }

    protected String processSDLocation(Element participantRole, DomainResource r) throws Exception {
        Location l = new Location();
        l.setType(this.convert.makeCodeableConceptFromCD(this.cda.getChild(participantRole, "code")));
        for (Element element : this.cda.getChildren(participantRole, "id")) {
            if (l.getIdentifier() != null) continue;
            l.getIdentifier().add(this.convert.makeIdentifierFromII(element));
        }
        for (Element element : this.cda.getChildren(participantRole, "addr")) {
            if (l.getAddress() != null) continue;
            l.setAddress(this.convert.makeAddressFromAD(element));
        }
        for (Element element : this.cda.getChildren(participantRole, "telecom")) {
            l.getTelecom().add(this.convert.makeContactFromTEL(element));
        }
        Element place = this.cda.getChild(participantRole, "playingDevice");
        if (this.cda.getChild(place, "name") != null) {
            l.setName(this.cda.getChild(place, "name").getTextContent());
        }
        String string = this.nextRef();
        l.setId(string);
        r.getContained().add(l);
        return "#" + string;
    }

    protected String processDevice(Element participantRole, DomainResource r) throws Exception {
        Device d = new Device();
        for (Element id : this.cda.getChildren(participantRole, "id")) {
            d.getIdentifier().add(this.convert.makeIdentifierFromII(id));
        }
        Element device = this.cda.getChild(participantRole, "playingDevice");
        d.setType(this.convert.makeCodeableConceptFromCD(this.cda.getChild(device, "code")));
        Element org = this.cda.getChild(participantRole, "scopingEntity");
        d.setManufacturer(this.convert.makeURIfromII(this.cda.getChild(org, "id")));
        String id = this.nextRef();
        d.setId(id);
        r.getContained().add(d);
        return "#" + id;
    }

    protected CodeableConcept processIndication(Element obs) throws Exception {
        Element o;
        Element v = this.cda.getChild(obs, "value");
        if (v == null && (o = this.cda.getById(this.cda.getChild(obs, "id"), "value")) != null) {
            v = this.cda.getChild(obs, "value");
        }
        if (v != null) {
            return this.convert.makeCodeableConceptFromCD(v);
        }
        return null;
    }

    protected Reference makeReferenceToPractitionerForAssignedEntity(Element assignedEntity, DomainResource r) throws Exception {
        Reference ref = null;
        String uri = this.getIdForEntity(assignedEntity);
        Practitioner p = null;
        if (uri != null) {
            ref = Factory.makeReference(uri);
            p = this.practitionerCache.get(uri);
        }
        if (p == null) {
            p = new Practitioner();
            if (uri == null) {
                String n = this.nextRef();
                p.setId(n);
                r.getContained().add(p);
                ref = Factory.makeReference("#" + n);
            } else {
                ref = Factory.makeReference(this.addReference(p, "Practitioner", uri));
            }
        }
        for (Element e : this.cda.getChildren(assignedEntity, "id")) {
            this.addToIdList(p.getIdentifier(), this.convert.makeIdentifierFromII(e));
        }
        for (Element e : this.cda.getChildren(assignedEntity, "addr")) {
            if (p.getAddress() != null) continue;
            p.getAddress().add(this.convert.makeAddressFromAD(e));
        }
        for (Element e : this.cda.getChildren(assignedEntity, "telecom")) {
            this.addToContactList(p.getTelecom(), this.convert.makeContactFromTEL(e));
        }
        for (Element e : this.cda.getChildren(this.cda.getChild(assignedEntity, "assignedPerson"), "name")) {
            if (p.getName() != null) continue;
            p.addName(this.convert.makeNameFromEN(e));
        }
        return ref;
    }

    protected void addToContactList(List<ContactPoint> list, ContactPoint c) throws Exception {
        for (ContactPoint item : list) {
            if (!Comparison.matches(item, c, null)) continue;
            Comparison.merge(item, c);
        }
        list.add(c);
    }

    protected void addToIdList(List<Identifier> list, Identifier id) throws Exception {
        for (Identifier item : list) {
            if (!Comparison.matches(item, id, null)) continue;
            Comparison.merge(item, id);
        }
        list.add(id);
    }

    protected void addToCodeableList(List<CodeableConcept> list, CodeableConcept code) throws Exception {
        for (CodeableConcept item : list) {
            if (!Comparison.matches(item, code, null)) continue;
            Comparison.merge(item, code);
        }
        list.add(code);
    }

    protected String getIdForEntity(Element assignedEntity) throws Exception {
        Element id = this.cda.getChild(assignedEntity, "id");
        if (id == null) {
            return null;
        }
        if (id.getAttribute("extension") == null) {
            if (this.convert.isGuid(id.getAttribute("root"))) {
                return "urn:uuid:" + id.getAttribute("root");
            }
            return "urn:oid:" + id.getAttribute("root");
        }
        return "ii:" + id.getAttribute("root") + "::" + id.getAttribute("extension");
    }

    protected Composition.SectionComponent processAdverseReactionsSection(Element section) throws Exception {
        ListResource list = new ListResource();
        for (Element entry : this.cda.getChildren(section, "entry")) {
            Element concern = this.cda.getChild(entry, "act");
            if (this.cda.hasTemplateId(concern, "2.16.840.1.113883.10.20.22.4.30")) {
                this.processAllergyProblemAct(list, concern);
                continue;
            }
            throw new Exception("Unhandled Section template ids: " + this.cda.showTemplateIds(concern));
        }
        Composition.SectionComponent s2 = new Composition.SectionComponent();
        s2.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(section, "code")));
        s2.addEntry(Factory.makeReference(this.addReference(list, "Allergies, Adverse Reactions, Alerts", this.makeUUIDReference())));
        return s2;
    }

    protected void processAllergyProblemAct(ListResource list, Element concern) throws Exception {
        this.cda.checkTemplateId(concern, "2.16.840.1.113883.10.20.22.4.30");
        this.checkNoNegationOrNullFlavor(concern, "Allergy Problem Act");
        this.checkNoSubject(concern, "Allergy Problem Act");
        for (Element entry : this.cda.getChildren(concern, "entryRelationship")) {
            Element obs = this.cda.getChild(entry, "observation");
            this.cda.checkTemplateId(obs, "2.16.840.1.113883.10.20.22.4.7");
            this.checkNoNegationOrNullFlavor(obs, "Allergy - intolerance Observation");
            this.checkNoSubject(obs, "Allergy Problem Act");
            AllergyIntolerance ai = new AllergyIntolerance();
            ListResource.ListEntryComponent item = this.addItemToList(list, ai);
            for (Element e : this.cda.getChildren(concern, "id")) {
                ai.getIdentifier().add(this.convert.makeIdentifierFromII(e));
            }
            String s2 = this.cda.getStatus(concern);
            item.setFlag(Factory.newCodeableConcept(s2, "http://hl7.org/fhir/v3/ActStatus", s2));
            if (s2.equals("aborted")) {
                item.setDeleted(true);
            }
            Period p = this.convert.makePeriodFromIVL(this.cda.getChild(concern, "effectiveTime"));
            item.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/list-period", p, false));
            if (p.getEnd() != null) {
                item.setDate(p.getEnd());
            } else {
                item.setDate(p.getStart());
            }
            for (Element e : this.cda.getChildren(obs, "id")) {
                ai.getIdentifier().add(this.convert.makeIdentifierFromII(e));
            }
            ai.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/allergyintolerance-period", this.convert.makePeriodFromIVL(this.cda.getChild(obs, "effectiveTime")), false));
            CodeableConcept type = this.convert.makeCodeableConceptFromCD(this.cda.getChild(obs, "value"));
            String ss = type.getCoding().get(0).getCode();
            if (ss.equals("416098002") || ss.equals("414285001")) {
                ai.setType(AllergyIntolerance.AllergyIntoleranceType.ALLERGY);
            } else if (ss.equals("59037007") || ss.equals("235719002")) {
                ai.setType(AllergyIntolerance.AllergyIntoleranceType.INTOLERANCE);
            }
            ai.getExtension().add(Factory.newExtension("http://www.healthintersections.com.au/fhir/extensions/allergy-category", type, false));
            ai.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getDescendent(obs, "participant/participantRole/playingEntity/code")));
            for (Element e : this.cda.getChildren(obs, "entryRelationship")) {
                Element child = this.cda.getChild(e, "observation");
                if (this.cda.hasTemplateId(child, "2.16.840.1.113883.10.20.22.4.28") && ai.getClinicalStatus() == null) {
                    String sc = this.cda.getChild(child, "value").getAttribute("code");
                    if (sc.equals("55561003")) {
                        ai.setClinicalStatus(AllergyIntolerance.AllergyIntoleranceClinicalStatus.ACTIVE);
                        ai.setVerificationStatus(AllergyIntolerance.AllergyIntoleranceVerificationStatus.CONFIRMED);
                        continue;
                    }
                    ai.setClinicalStatus(AllergyIntolerance.AllergyIntoleranceClinicalStatus.RESOLVED);
                    continue;
                }
                if (!this.cda.hasTemplateId(child, "2.16.840.1.113883.10.20.22.4.9")) continue;
                ai.getReaction().add(this.processAdverseReactionObservation(child));
            }
            ai.setCriticality(this.readCriticality(this.cda.getSeverity(obs)));
        }
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent processAdverseReactionObservation(Element reaction) throws Exception {
        this.checkNoNegationOrNullFlavor(reaction, "Adverse Reaction Observation");
        this.checkNoSubject(reaction, "Adverse Reaction Observation");
        AllergyIntolerance.AllergyIntoleranceReactionComponent ar = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        for (Element e : this.cda.getChildren(reaction, "id")) {
            ToolingExtensions.addIdentifier(ar, this.convert.makeIdentifierFromII(e));
        }
        ar.setOnsetElement(this.convert.makeDateTimeFromIVL(this.cda.getChild(reaction, "effectiveTime")));
        ar.getManifestation().add(this.convert.makeCodeableConceptFromCD(this.cda.getChild(reaction, "value")));
        ar.setSeverity(this.readSeverity(this.cda.getSeverity(reaction)));
        return ar;
    }

    protected Composition.SectionComponent processSocialHistorySection(Element section) throws Exception {
        ListResource list = new ListResource();
        for (Element entry : this.cda.getChildren(section, "entry")) {
            Element observation = this.cda.getlastChild(entry);
            if (this.cda.hasTemplateId(observation, "2.16.840.1.113883.10.20.22.4.38")) {
                this.processSocialObservation(list, observation, SocialHistoryType.SocialHistory);
                continue;
            }
            if (this.cda.hasTemplateId(observation, "2.16.840.1.113883.10.20.15.3.8")) {
                this.processSocialObservation(list, observation, SocialHistoryType.Pregnancy);
                continue;
            }
            if (this.cda.hasTemplateId(observation, "2.16.840.1.113883.10.20.22.4.78")) {
                this.processSocialObservation(list, observation, SocialHistoryType.SmokingStatus);
                continue;
            }
            if (this.cda.hasTemplateId(observation, "2.16.840.1.113883.10.20.22.4.85")) {
                this.processSocialObservation(list, observation, SocialHistoryType.TobaccoUse);
                continue;
            }
            throw new Exception("Unhandled Section template ids: " + this.cda.showTemplateIds(observation));
        }
        Composition.SectionComponent s2 = new Composition.SectionComponent();
        s2.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(section, "code")));
        s2.addEntry(Factory.makeReference(this.addReference(list, "Procedures", this.makeUUIDReference())));
        return s2;
    }

    protected void processSocialObservation(ListResource list, Element so, SocialHistoryType type) throws Exception {
        Observation obs = new Observation();
        this.addItemToList(list, obs);
        switch (type) {
            case SocialHistory: {
                this.cda.checkTemplateId(so, "2.16.840.1.113883.10.20.22.4.38");
                obs.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(so, "code")));
                break;
            }
            case Pregnancy: {
                this.cda.checkTemplateId(so, "2.16.840.1.113883.10.20.15.3.8");
                obs.setCode(Factory.newCodeableConcept("11449-6", "http://loinc.org", "Pregnancy Status"));
                break;
            }
            case SmokingStatus: {
                this.cda.checkTemplateId(so, "2.16.840.1.113883.10.20.22.4.78");
                obs.setCode(Factory.newCodeableConcept("72166-2", "http://loinc.org", "Tobacco Smoking Status"));
                break;
            }
            case TobaccoUse: {
                this.cda.checkTemplateId(so, "2.16.840.1.113883.10.20.22.4.12");
                obs.setCode(Factory.newCodeableConcept("11367-0", "http://loinc.org", "History of Tobacco Use"));
            }
        }
        for (Element e : this.cda.getChildren(so, "id")) {
            obs.getIdentifier().add(this.convert.makeIdentifierFromII(e));
        }
        obs.setStatus(Observation.ObservationStatus.FINAL);
        Element et = this.cda.getChild(so, "effectiveTime");
        if (et != null) {
            if (this.cda.getChild(et, "low") != null) {
                obs.setEffective(this.convert.makeDateTimeFromTS(this.cda.getChild(et, "low")));
            } else {
                obs.setEffective(this.convert.makeDateTimeFromIVL(et));
            }
        }
        for (Element e : this.cda.getChildren(so, "value")) {
            if (obs.getValue() == null) {
                if (type == SocialHistoryType.Pregnancy && "true".equals(e.getAttribute("negationInd"))) {
                    obs.setValue(Factory.newCodeableConcept("60001007", "http://snomed.info/sct", "Not pregnant"));
                    continue;
                }
                this.checkNoNegation(so, "Social Observation (" + type.toString() + ")");
                if (so.hasAttribute("nullFlavor")) {
                    obs.setValue(this.convert.makeCodeableConceptFromNullFlavor(so.getAttribute("nullFlavor")));
                    continue;
                }
                if (e.hasAttribute("nullFlavor") && !"OTH".equals(e.getAttribute("nullFlavor"))) {
                    obs.setValue(this.convert.makeCodeableConceptFromNullFlavor(e.getAttribute("nullFlavor")));
                    continue;
                }
                obs.setValue(this.convert.makeTypeFromANY(e));
                continue;
            }
            throw new Exception("too many values on Social Observation");
        }
        if (type == SocialHistoryType.Pregnancy) {
            for (Element e : this.cda.getChildren(so, "entyRelationship")) {
                Element dd = this.cda.getChild(e, "observation");
                this.checkNoNegationOrNullFlavor(dd, "Estimated Date of Delivery");
                Observation co = new Observation();
                String id = this.nextRef();
                co.setId(id);
                obs.getContained().add(co);
                Observation.ObservationRelatedComponent or = new Observation.ObservationRelatedComponent();
                obs.getRelated().add(or);
                or.setType(Observation.ObservationRelationshipType.HASMEMBER);
                or.setTarget(Factory.makeReference("#" + id));
                co.setCode(Factory.newCodeableConcept("11778-8", "http://loinc.org", "Delivery date Estimated"));
                co.setValue(this.convert.makeDateTimeFromTS(this.cda.getChild(dd, "value")));
            }
        }
    }

    protected void checkNoNegation(Element act, String path) throws Exception {
        if ("true".equals(act.getAttribute("negationInd"))) {
            throw new Exception("The conversion program cannot accept a negationInd at the location " + path);
        }
    }

    protected void checkNoNegationOrNullFlavor(Element act, String path) throws Exception {
        if (act.hasAttribute("nullFlavor")) {
            throw new Exception("The conversion program cannot accept a nullFlavor at the location " + path);
        }
        if ("true".equals(act.getAttribute("negationInd"))) {
            throw new Exception("The conversion program cannot accept a negationInd at the location " + path);
        }
    }

    protected ListResource.ListEntryComponent addItemToList(ListResource list, DomainResource ai) throws Exception {
        list.getContained().add(ai);
        String n = this.nextRef();
        ai.setId(n);
        ListResource.ListEntryComponent item = new ListResource.ListEntryComponent();
        list.getEntry().add(item);
        item.setItem(Factory.makeReference("#" + n));
        return item;
    }

    protected String nextRef() {
        Integer n = this.refCounter;
        Integer n2 = this.refCounter = Integer.valueOf(this.refCounter + 1);
        String n3 = this.refCounter.toString();
        return n3;
    }

    protected AllergyIntolerance.AllergyIntoleranceCriticality readCriticality(String severity) {
        if ("255604002".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceCriticality.LOW;
        }
        if ("371923003".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceCriticality.LOW;
        }
        if ("6736007".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceCriticality.LOW;
        }
        if ("371924009".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceCriticality.HIGH;
        }
        if ("24484000".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceCriticality.HIGH;
        }
        if ("399166001".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceCriticality.HIGH;
        }
        return null;
    }

    protected AllergyIntolerance.AllergyIntoleranceSeverity readSeverity(String severity) {
        if ("255604002".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceSeverity.MILD;
        }
        if ("371923003".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE;
        }
        if ("6736007".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE;
        }
        if ("371924009".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE;
        }
        if ("24484000".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE;
        }
        if ("399166001".equals(severity)) {
            return AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE;
        }
        return null;
    }

    protected Composition.SectionComponent processVitalSignsSection(Element section) throws Exception {
        ListResource list = new ListResource();
        for (Element entry : this.cda.getChildren(section, "entry")) {
            Element organizer = this.cda.getlastChild(entry);
            if (this.cda.hasTemplateId(organizer, "2.16.840.1.113883.10.20.22.4.26")) {
                this.processVitalSignsOrganizer(list, organizer);
                continue;
            }
            throw new Exception("Unhandled Section template ids: " + this.cda.showTemplateIds(organizer));
        }
        Composition.SectionComponent s2 = new Composition.SectionComponent();
        s2.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(section, "code")));
        s2.addEntry(Factory.makeReference(this.addReference(list, "Vital Signs", this.makeUUIDReference())));
        return s2;
    }

    protected void processVitalSignsOrganizer(ListResource list, Element organizer) throws Exception {
        this.cda.checkTemplateId(organizer, "2.16.840.1.113883.10.20.22.4.26");
        this.checkNoNegationOrNullFlavor(organizer, "Vital Signs Organizer");
        this.checkNoSubject(organizer, "Vital Signs Organizer");
        Observation obs = new Observation();
        this.addItemToList(list, obs);
        for (Element e : this.cda.getChildren(organizer, "id")) {
            obs.getIdentifier().add(this.convert.makeIdentifierFromII(e));
        }
        obs.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(organizer, "code")));
        obs.setEffective(this.convert.makeMatchingTypeFromIVL(this.cda.getChild(organizer, "effectiveTime")));
        for (Element e : this.cda.getChildren(organizer, "component")) {
            Observation.ObservationRelatedComponent ro = new Observation.ObservationRelatedComponent();
            ro.setType(Observation.ObservationRelationshipType.HASMEMBER);
            ro.setTarget(Factory.makeReference("#" + this.processVitalSignsObservation(e, list)));
        }
    }

    protected String processVitalSignsObservation(Element comp, ListResource list) throws Exception {
        Element observation = this.cda.getChild(comp, "observation");
        this.cda.checkTemplateId(observation, "2.16.840.1.113883.10.20.22.4.27");
        this.checkNoNegationOrNullFlavor(observation, "Vital Signs Observation");
        this.checkNoSubject(observation, "Vital Signs Observation");
        Observation obs = new Observation();
        for (Element e : this.cda.getChildren(observation, "id")) {
            obs.getIdentifier().add(this.convert.makeIdentifierFromII(e));
        }
        obs.setCode(this.convert.makeCodeableConceptFromCD(this.cda.getChild(observation, "code")));
        obs.setEffective(this.convert.makeMatchingTypeFromIVL(this.cda.getChild(observation, "effectiveTime")));
        obs.setValue(this.convert.makeQuantityFromPQ(this.cda.getChild(observation, "value")));
        obs.setInterpretation(this.convert.makeCodeableConceptFromCD(this.cda.getChild(observation, "interpretationCode")));
        obs.setMethod(this.convert.makeCodeableConceptFromCD(this.cda.getChild(observation, "methodCode")));
        obs.setBodySite(this.convert.makeCodeableConceptFromCD(this.cda.getChild(observation, "targetSiteCode")));
        if (this.cda.getChild(observation, "author") != null) {
            obs.getPerformer().add(this.makeReferenceToPractitionerForAssignedEntity(this.cda.getChild(observation, "author"), this.composition));
        }
        String n = this.nextRef();
        obs.setId(n);
        list.getContained().add(obs);
        return n;
    }

    public static enum ProcedureType {
        Observation,
        Procedure,
        Act;

    }

    public static enum SocialHistoryType {
        SocialHistory,
        Pregnancy,
        SmokingStatus,
        TobaccoUse;

    }
}

