/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.CharUtils;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class ADLImporter {
    private String source;
    private String dest;
    private String config;
    private String info;
    private Element adl;
    private Map<String, TextSet> texts = new HashMap<String, TextSet>();
    private Element adlConfig;

    public static void main(String[] args) throws Exception {
        ADLImporter self = new ADLImporter();
        self.source = ADLImporter.getParam(args, "source");
        self.dest = ADLImporter.getParam(args, "dest");
        self.config = ADLImporter.getParam(args, "config");
        self.info = ADLImporter.getParam(args, "info");
        if (self.source == null || self.dest == null || self.config == null) {
            System.out.println("ADL to FHIR StructureDefinition Converter");
            System.out.println("This tool takes 4 parameters:");
            System.out.println("-source: ADL 1.4 XML representation of an archetype (required)");
            System.out.println("-dest: filename of structure definition to produce (required)");
            System.out.println("-config: filename of OpenEHR/FHIR knowlege base (required)");
            System.out.println("-info: filename of additional knowlege for this adl file (optional)");
        } else {
            self.execute();
        }
    }

    private static String getParam(String[] args, String name) {
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-" + name)) continue;
            return args[i + 1];
        }
        return null;
    }

    private void execute() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.adlConfig = builder.parse(new FileInputStream(this.config)).getDocumentElement();
        builder = factory.newDocumentBuilder();
        this.adl = builder.parse(new FileInputStream(this.source)).getDocumentElement();
        this.check("root", this.adl.getNamespaceURI(), "http://schemas.openehr.org/v1", "Wrong namespace for ADL XML");
        this.check("root", this.adl.getNodeName(), "archetype", "Wrong XML for ADL XML");
        this.check("root", XMLUtil.getNamedChild(this.adl, "adl_version").getTextContent(), "1.4", "unsupported ADL version");
        String id = XMLUtil.getFirstChild(XMLUtil.getNamedChild(this.adl, "archetype_id")).getTextContent().split("\\.")[1];
        StructureDefinition sd = new StructureDefinition();
        sd.setId(id);
        Element description = XMLUtil.getNamedChild(this.adl, "description");
        Element details = XMLUtil.getNamedChild(description, "details");
        sd.setDescription(XMLUtil.getNamedChild(details, "purpose").getTextContent());
        sd.setCopyright(XMLUtil.getNamedChild(details, "copyright").getTextContent());
        sd.setPurpose("Use:\r\n" + XMLUtil.getNamedChild(details, "use").getTextContent() + "\r\n\r\nMisuse:\r\n" + XMLUtil.getNamedChild(details, "misuse").getTextContent());
        ArrayList<Element> set = new ArrayList<Element>();
        XMLUtil.getNamedChildren(details, "keywords", set);
        for (Element e : set) {
            sd.addKeyword().setDisplay(e.getTextContent());
        }
        String status = XMLUtil.getNamedChild(description, "lifecycle_state").getTextContent();
        if (!"CommitteeDraft".equals(status) && !"AuthorDraft".equals(status)) {
            throw new Exception("Unknown life cycle state " + XMLUtil.getNamedChild(description, "lifecycle_state").getTextContent());
        }
        sd.setStatus(Enumerations.PublicationStatus.DRAFT);
        Element ontology = XMLUtil.getNamedChild(this.adl, "ontology");
        Element term_definitions = XMLUtil.getNamedChild(ontology, "term_definitions");
        set.clear();
        XMLUtil.getNamedChildren(term_definitions, "items", set);
        for (Element item : set) {
            this.processTextItem(item);
        }
        Element definition = XMLUtil.getNamedChild(this.adl, "definition");
        NodeTreeEntry root = new NodeTreeEntry();
        root.typeName = XMLUtil.getNamedChild(definition, "rm_type_name").getTextContent();
        root.atCode = XMLUtil.getNamedChild(definition, "node_id").getTextContent();
        root.name = this.generateToken(root.atCode, true);
        sd.setName(root.name);
        root.cardinality = this.readCardinality("root", XMLUtil.getNamedChild(definition, "occurrences"));
        set.clear();
        XMLUtil.getNamedChildren(definition, "attributes", set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Element item;
            Element attributes = item = (Element)iterator.next();
            this.loadChildren(root.atCode, root, attributes);
        }
        this.dumpChildren("", root);
        this.genElements(sd, root.name, root);
        new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream(this.dest), sd);
        System.out.println("done. saved as " + this.dest);
    }

    private void genElements(StructureDefinition sd, String path, NodeTreeEntry item) throws Exception {
        ElementDefinition ed = sd.getSnapshot().addElement();
        ed.setPath(path);
        ed.setMax(item.cardinality.max);
        ed.setMin(Integer.parseInt(item.cardinality.min));
        ed.setShort(this.texts.get(item.atCode).text);
        ed.setDefinition(this.texts.get(item.atCode).description);
        ed.setComment(this.texts.get(item.atCode).comment);
        Element te = this.findTypeElement(item.typeName);
        if (te.hasAttribute("profile")) {
            ed.addType().setCode(te.getAttribute("fhir")).setProfile(te.getAttribute("profile"));
        } else {
            ed.addType().setCode(te.getAttribute("fhir"));
        }
        ed.getBase().setPath(ed.getPath()).setMin(ed.getMin()).setMax(ed.getMax());
        for (NodeTreeEntry child : item.children) {
            this.genElements(sd, path + "." + child.name, child);
        }
    }

    private Element findTypeElement(String typeName) throws Exception {
        Element dataTypes = XMLUtil.getNamedChild(this.adlConfig, "dataTypes");
        ArrayList<Element> set = new ArrayList<Element>();
        XMLUtil.getNamedChildren(dataTypes, "dataType", set);
        for (Element e : set) {
            if (!typeName.equals(e.getAttribute("name"))) continue;
            return e;
        }
        throw new Exception("No FHIR equivalent found for " + typeName);
    }

    private void dumpChildren(String prefix, NodeTreeEntry item) throws Exception {
        Element te = this.findTypeElement(item.typeName);
        if (te.hasAttribute("profile")) {
            System.out.println(prefix + item.atCode + " [" + item.cardinality.min + ".." + item.cardinality.max + "]:" + te.getAttribute("fhir") + "{" + te.getAttribute("profile") + "} // " + item.name + " = " + this.texts.get(item.atCode).text);
        } else {
            System.out.println(prefix + item.atCode + " [" + item.cardinality.min + ".." + item.cardinality.max + "]:" + te.getAttribute("fhir") + " // " + item.name + " = " + this.texts.get(item.atCode).text);
        }
        for (NodeTreeEntry child : item.children) {
            this.dumpChildren(prefix + "  ", child);
        }
    }

    private void loadChildren(String path, NodeTreeEntry parent, Element attributes) throws DOMException, Exception {
        ArrayList<Element> set = new ArrayList<Element>();
        XMLUtil.getNamedChildren(attributes, "children", set);
        for (Element e : set) {
            NodeTreeEntry item = new NodeTreeEntry();
            item.typeName = XMLUtil.getNamedChild(e, "rm_type_name").getTextContent();
            item.atCode = XMLUtil.getNamedChild(e, "node_id").getTextContent();
            item.name = this.generateToken(item.atCode, false);
            item.cardinality = this.readCardinality(path + "/" + item.atCode, XMLUtil.getNamedChild(e, "occurrences"));
            parent.children.add(item);
            Element attr = XMLUtil.getNamedChild(e, "attributes");
            String type = attr.getAttribute("xsi:type");
            if ("C_SINGLE_ATTRIBUTE".equals(type)) {
                this.check(path, item.typeName, "ELEMENT", "type for simple element: " + item.typeName);
                this.checkCardSingle(path, XMLUtil.getNamedChild(attr, "existence"));
                Element c = XMLUtil.getNamedChild(attr, "children");
                this.checkCardSingle(path, XMLUtil.getNamedChild(c, "occurrences"));
                item.typeName = XMLUtil.getNamedChild(c, "rm_type_name").getTextContent();
                continue;
            }
            this.check(path, item.typeName, "CLUSTER", "type for complex element");
            this.loadChildren(path + "/" + item.atCode, item, attr);
        }
    }

    private String generateToken(String atCode, boolean upFirst) {
        if (!this.texts.containsKey(atCode)) {
            return atCode;
        }
        String text = this.texts.get(atCode).getText();
        boolean lastText = false;
        StringBuilder b = new StringBuilder();
        for (char c : text.toCharArray()) {
            boolean ok = CharUtils.isAscii(c);
            if (ok) {
                if (b.length() == 0) {
                    ok = Character.isAlphabetic(c);
                } else {
                    boolean bl = ok = Character.isAlphabetic(c) || Character.isDigit(c);
                }
            }
            if (!ok) {
                lastText = false;
                continue;
            }
            if (!lastText && (b.length() > 0 || upFirst)) {
                b.append(Character.toUpperCase(c));
            } else {
                b.append(Character.toLowerCase(c));
            }
            lastText = true;
        }
        return b.toString();
    }

    private void checkCardSingle(String path, Element element) throws DOMException, Exception {
        this.check(path, XMLUtil.getNamedChild(element, "lower_included").getTextContent(), "true", "Cardinality check");
        this.check(path, XMLUtil.getNamedChild(element, "upper_included").getTextContent(), "true", "Cardinality check");
        this.check(path, XMLUtil.getNamedChild(element, "lower_unbounded").getTextContent(), "false", "Cardinality check");
        this.check(path, XMLUtil.getNamedChild(element, "upper_unbounded").getTextContent(), "false", "Cardinality check");
        this.check(path, XMLUtil.getNamedChild(element, "lower").getTextContent(), "1", "Cardinality check");
        this.check(path, XMLUtil.getNamedChild(element, "upper").getTextContent(), "1", "Cardinality check");
    }

    private Cardinality readCardinality(String path, Element element) throws DOMException, Exception {
        this.check(path, XMLUtil.getNamedChild(element, "lower_included").getTextContent(), "true", "Cardinality check");
        if (XMLUtil.getNamedChild(element, "upper_included") != null) {
            this.check(path, XMLUtil.getNamedChild(element, "upper_included").getTextContent(), "true", "Cardinality check");
        }
        this.check(path, XMLUtil.getNamedChild(element, "lower_unbounded").getTextContent(), "false", "Cardinality check");
        Cardinality card = new Cardinality();
        card.min = XMLUtil.getNamedChild(element, "lower").getTextContent();
        if ("true".equals(XMLUtil.getNamedChild(element, "upper_unbounded").getTextContent())) {
            card.max = "*";
        } else {
            card.max = XMLUtil.getNamedChild(element, "upper").getTextContent();
        }
        return card;
    }

    private void processTextItem(Element item) throws Exception {
        String atcode = item.getAttribute("code");
        TextSet ts = new TextSet();
        ArrayList<Element> set = new ArrayList<Element>();
        XMLUtil.getNamedChildren(item, "items", set);
        for (Element e : set) {
            String code = e.getAttribute("id");
            if (code.equals("text")) {
                ts.setText(e.getTextContent());
                continue;
            }
            if (code.equals("description")) {
                ts.setDescription(e.getTextContent());
                continue;
            }
            if (code.equals("comment")) {
                ts.setComment(e.getTextContent());
                continue;
            }
            throw new Exception("unknown code " + code);
        }
        this.texts.put(atcode, ts);
    }

    private void check(String path, String found, String expected, String message) throws Exception {
        if (!expected.equals(found.trim())) {
            throw new Exception(message + ". Expected '" + expected + "' but found '" + found.trim() + "', at " + path);
        }
    }

    public class NodeTreeEntry {
        private String name;
        private String atCode;
        private String typeName;
        private Cardinality cardinality;
        private List<NodeTreeEntry> children = new ArrayList<NodeTreeEntry>();
    }

    public class TextSet {
        private String text;
        private String description;
        private String comment;

        public String getText() {
            return this.text;
        }

        public String getDescription() {
            return this.description;
        }

        public String getComment() {
            return this.comment;
        }

        public void setText(String value) {
            this.text = value;
        }

        public void setDescription(String value) {
            this.description = value;
        }

        public void setComment(String value) {
            this.comment = value;
        }
    }

    public class Cardinality {
        private String min;
        private String max;
    }
}

