/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.VisionPrescription;

public class VisionPrescription40_50
extends VersionConvertor_40_50 {
    public static VisionPrescription convertVisionPrescription(org.hl7.fhir.r4.model.VisionPrescription src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VisionPrescription tgt = new VisionPrescription();
        VisionPrescription40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VisionPrescription40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VisionPrescription40_50.convertVisionStatus(src.getStatusElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(VisionPrescription40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VisionPrescription40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VisionPrescription40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDateWritten()) {
            tgt.setDateWrittenElement(VisionPrescription40_50.convertDateTime(src.getDateWrittenElement()));
        }
        if (src.hasPrescriber()) {
            tgt.setPrescriber(VisionPrescription40_50.convertReference(src.getPrescriber()));
        }
        for (VisionPrescription.VisionPrescriptionLensSpecificationComponent visionPrescriptionLensSpecificationComponent : src.getLensSpecification()) {
            tgt.addLensSpecification(VisionPrescription40_50.convertVisionPrescriptionLensSpecificationComponent(visionPrescriptionLensSpecificationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.VisionPrescription convertVisionPrescription(VisionPrescription src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.VisionPrescription tgt = new org.hl7.fhir.r4.model.VisionPrescription();
        VisionPrescription40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VisionPrescription40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VisionPrescription40_50.convertVisionStatus(src.getStatusElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(VisionPrescription40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VisionPrescription40_50.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VisionPrescription40_50.convertReference(src.getEncounter()));
        }
        if (src.hasDateWritten()) {
            tgt.setDateWrittenElement(VisionPrescription40_50.convertDateTime(src.getDateWrittenElement()));
        }
        if (src.hasPrescriber()) {
            tgt.setPrescriber(VisionPrescription40_50.convertReference(src.getPrescriber()));
        }
        for (VisionPrescription.VisionPrescriptionLensSpecificationComponent visionPrescriptionLensSpecificationComponent : src.getLensSpecification()) {
            tgt.addLensSpecification(VisionPrescription40_50.convertVisionPrescriptionLensSpecificationComponent(visionPrescriptionLensSpecificationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertVisionStatus(Enumeration<VisionPrescription.VisionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((VisionPrescription.VisionStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<VisionPrescription.VisionStatus> convertVisionStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<VisionPrescription.VisionStatus> tgt = new Enumeration<VisionPrescription.VisionStatus>(new VisionPrescription.VisionStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)VisionPrescription.VisionStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)VisionPrescription.VisionStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)VisionPrescription.VisionStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)VisionPrescription.VisionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)VisionPrescription.VisionStatus.NULL);
            }
        }
        return tgt;
    }

    public static VisionPrescription.VisionPrescriptionLensSpecificationComponent convertVisionPrescriptionLensSpecificationComponent(VisionPrescription.VisionPrescriptionLensSpecificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VisionPrescription.VisionPrescriptionLensSpecificationComponent tgt = new VisionPrescription.VisionPrescriptionLensSpecificationComponent();
        VisionPrescription40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProduct()) {
            tgt.setProduct(VisionPrescription40_50.convertCodeableConcept(src.getProduct()));
        }
        if (src.hasEye()) {
            tgt.setEyeElement(VisionPrescription40_50.convertVisionEyes(src.getEyeElement()));
        }
        if (src.hasSphere()) {
            tgt.setSphereElement(VisionPrescription40_50.convertDecimal(src.getSphereElement()));
        }
        if (src.hasCylinder()) {
            tgt.setCylinderElement(VisionPrescription40_50.convertDecimal(src.getCylinderElement()));
        }
        if (src.hasAxis()) {
            tgt.setAxisElement(VisionPrescription40_50.convertInteger(src.getAxisElement()));
        }
        for (VisionPrescription.PrismComponent prismComponent : src.getPrism()) {
            tgt.addPrism(VisionPrescription40_50.convertPrismComponent(prismComponent));
        }
        if (src.hasAdd()) {
            tgt.setAddElement(VisionPrescription40_50.convertDecimal(src.getAddElement()));
        }
        if (src.hasPower()) {
            tgt.setPowerElement(VisionPrescription40_50.convertDecimal(src.getPowerElement()));
        }
        if (src.hasBackCurve()) {
            tgt.setBackCurveElement(VisionPrescription40_50.convertDecimal(src.getBackCurveElement()));
        }
        if (src.hasDiameter()) {
            tgt.setDiameterElement(VisionPrescription40_50.convertDecimal(src.getDiameterElement()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(VisionPrescription40_50.convertSimpleQuantity(src.getDuration()));
        }
        if (src.hasColor()) {
            tgt.setColorElement(VisionPrescription40_50.convertString(src.getColorElement()));
        }
        if (src.hasBrand()) {
            tgt.setBrandElement(VisionPrescription40_50.convertString(src.getBrandElement()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VisionPrescription40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static VisionPrescription.VisionPrescriptionLensSpecificationComponent convertVisionPrescriptionLensSpecificationComponent(VisionPrescription.VisionPrescriptionLensSpecificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VisionPrescription.VisionPrescriptionLensSpecificationComponent tgt = new VisionPrescription.VisionPrescriptionLensSpecificationComponent();
        VisionPrescription40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProduct()) {
            tgt.setProduct(VisionPrescription40_50.convertCodeableConcept(src.getProduct()));
        }
        if (src.hasEye()) {
            tgt.setEyeElement(VisionPrescription40_50.convertVisionEyes(src.getEyeElement()));
        }
        if (src.hasSphere()) {
            tgt.setSphereElement(VisionPrescription40_50.convertDecimal(src.getSphereElement()));
        }
        if (src.hasCylinder()) {
            tgt.setCylinderElement(VisionPrescription40_50.convertDecimal(src.getCylinderElement()));
        }
        if (src.hasAxis()) {
            tgt.setAxisElement(VisionPrescription40_50.convertInteger(src.getAxisElement()));
        }
        for (VisionPrescription.PrismComponent prismComponent : src.getPrism()) {
            tgt.addPrism(VisionPrescription40_50.convertPrismComponent(prismComponent));
        }
        if (src.hasAdd()) {
            tgt.setAddElement(VisionPrescription40_50.convertDecimal(src.getAddElement()));
        }
        if (src.hasPower()) {
            tgt.setPowerElement(VisionPrescription40_50.convertDecimal(src.getPowerElement()));
        }
        if (src.hasBackCurve()) {
            tgt.setBackCurveElement(VisionPrescription40_50.convertDecimal(src.getBackCurveElement()));
        }
        if (src.hasDiameter()) {
            tgt.setDiameterElement(VisionPrescription40_50.convertDecimal(src.getDiameterElement()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(VisionPrescription40_50.convertSimpleQuantity(src.getDuration()));
        }
        if (src.hasColor()) {
            tgt.setColorElement(VisionPrescription40_50.convertString(src.getColorElement()));
        }
        if (src.hasBrand()) {
            tgt.setBrandElement(VisionPrescription40_50.convertString(src.getBrandElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VisionPrescription40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionEyes> convertVisionEyes(Enumeration<VisionPrescription.VisionEyes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionEyes> tgt = new org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionEyes>(new VisionPrescription.VisionEyesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((VisionPrescription.VisionEyes)((Object)src.getValue())) {
            case RIGHT: {
                tgt.setValue((Object)VisionPrescription.VisionEyes.RIGHT);
                break;
            }
            case LEFT: {
                tgt.setValue((Object)VisionPrescription.VisionEyes.LEFT);
                break;
            }
            default: {
                tgt.setValue((Object)VisionPrescription.VisionEyes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<VisionPrescription.VisionEyes> convertVisionEyes(org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionEyes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<VisionPrescription.VisionEyes> tgt = new Enumeration<VisionPrescription.VisionEyes>(new VisionPrescription.VisionEyesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((VisionPrescription.VisionEyes)((Object)src.getValue())) {
            case RIGHT: {
                tgt.setValue((Object)VisionPrescription.VisionEyes.RIGHT);
                break;
            }
            case LEFT: {
                tgt.setValue((Object)VisionPrescription.VisionEyes.LEFT);
                break;
            }
            default: {
                tgt.setValue((Object)VisionPrescription.VisionEyes.NULL);
            }
        }
        return tgt;
    }

    public static VisionPrescription.PrismComponent convertPrismComponent(VisionPrescription.PrismComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VisionPrescription.PrismComponent tgt = new VisionPrescription.PrismComponent();
        VisionPrescription40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAmount()) {
            tgt.setAmountElement(VisionPrescription40_50.convertDecimal(src.getAmountElement()));
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VisionPrescription40_50.convertVisionBase(src.getBaseElement()));
        }
        return tgt;
    }

    public static VisionPrescription.PrismComponent convertPrismComponent(VisionPrescription.PrismComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        VisionPrescription.PrismComponent tgt = new VisionPrescription.PrismComponent();
        VisionPrescription40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAmount()) {
            tgt.setAmountElement(VisionPrescription40_50.convertDecimal(src.getAmountElement()));
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VisionPrescription40_50.convertVisionBase(src.getBaseElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionBase> convertVisionBase(Enumeration<VisionPrescription.VisionBase> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionBase> tgt = new org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionBase>(new VisionPrescription.VisionBaseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((VisionPrescription.VisionBase)((Object)src.getValue())) {
            case UP: {
                tgt.setValue((Object)VisionPrescription.VisionBase.UP);
                break;
            }
            case DOWN: {
                tgt.setValue((Object)VisionPrescription.VisionBase.DOWN);
                break;
            }
            case IN: {
                tgt.setValue((Object)VisionPrescription.VisionBase.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)VisionPrescription.VisionBase.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)VisionPrescription.VisionBase.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<VisionPrescription.VisionBase> convertVisionBase(org.hl7.fhir.r5.model.Enumeration<VisionPrescription.VisionBase> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<VisionPrescription.VisionBase> tgt = new Enumeration<VisionPrescription.VisionBase>(new VisionPrescription.VisionBaseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((VisionPrescription.VisionBase)((Object)src.getValue())) {
            case UP: {
                tgt.setValue((Object)VisionPrescription.VisionBase.UP);
                break;
            }
            case DOWN: {
                tgt.setValue((Object)VisionPrescription.VisionBase.DOWN);
                break;
            }
            case IN: {
                tgt.setValue((Object)VisionPrescription.VisionBase.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)VisionPrescription.VisionBase.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)VisionPrescription.VisionBase.NULL);
            }
        }
        return tgt;
    }
}

