/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ValueSet;

public class ValueSet40_50
extends VersionConvertor_40_50 {
    public static ValueSet convertValueSet(org.hl7.fhir.r4.model.ValueSet src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet tgt = new ValueSet();
        ValueSet40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ValueSet40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ValueSet40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ValueSet40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ValueSet40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ValueSet40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ValueSet40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ValueSet40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ValueSet40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ValueSet40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ValueSet40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ValueSet40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ValueSet40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasImmutable()) {
            tgt.setImmutableElement(ValueSet40_50.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ValueSet40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ValueSet40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasCompose()) {
            tgt.setCompose(ValueSet40_50.convertValueSetComposeComponent(src.getCompose()));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet40_50.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ValueSet convertValueSet(ValueSet src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ValueSet tgt = new org.hl7.fhir.r4.model.ValueSet();
        ValueSet40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ValueSet40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ValueSet40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ValueSet40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ValueSet40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ValueSet40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ValueSet40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ValueSet40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ValueSet40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ValueSet40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ValueSet40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ValueSet40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ValueSet40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasImmutable()) {
            tgt.setImmutableElement(ValueSet40_50.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ValueSet40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ValueSet40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasCompose()) {
            tgt.setCompose(ValueSet40_50.convertValueSetComposeComponent(src.getCompose()));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet40_50.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLockedDate()) {
            tgt.setLockedDateElement(ValueSet40_50.convertDate(src.getLockedDateElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(ValueSet40_50.convertBoolean(src.getInactiveElement()));
        }
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            tgt.addInclude(ValueSet40_50.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(ValueSet40_50.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLockedDate()) {
            tgt.setLockedDateElement(ValueSet40_50.convertDate(src.getLockedDateElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(ValueSet40_50.convertBoolean(src.getInactiveElement()));
        }
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            tgt.addInclude(ValueSet40_50.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(ValueSet40_50.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(ValueSet40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ValueSet40_50.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet40_50.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet40_50.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        for (CanonicalType canonicalType : src.getValueSet()) {
            tgt.getValueSet().add(ValueSet40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(ValueSet40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ValueSet40_50.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet40_50.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet40_50.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getValueSet()) {
            tgt.getValueSet().add(ValueSet40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ValueSet40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ValueSet40_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet40_50.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ValueSet40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ValueSet40_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet40_50.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(ValueSet40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(ValueSet40_50.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ValueSet40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(ValueSet40_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(ValueSet40_50.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ValueSet40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(ValueSet40_50.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(ValueSet40_50.convertFilterOperator(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ValueSet40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(ValueSet40_50.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(ValueSet40_50.convertFilterOperator(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ValueSet40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> convertFilterOperator(Enumeration<ValueSet.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ValueSet.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)Enumerations.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)Enumerations.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)Enumerations.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)Enumerations.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)Enumerations.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)Enumerations.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)Enumerations.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)Enumerations.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)Enumerations.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ValueSet.FilterOperator> convertFilterOperator(org.hl7.fhir.r5.model.Enumeration<Enumerations.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ValueSet.FilterOperator> tgt = new Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)ValueSet.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)ValueSet.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ValueSet.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(ValueSet40_50.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestamp()) {
            tgt.setTimestampElement(ValueSet40_50.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(ValueSet40_50.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(ValueSet40_50.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet40_50.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet40_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(ValueSet40_50.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestamp()) {
            tgt.setTimestampElement(ValueSet40_50.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(ValueSet40_50.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(ValueSet40_50.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet40_50.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet40_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ValueSet40_50.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(ValueSet40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ValueSet40_50.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(ValueSet40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(ValueSet40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(ValueSet40_50.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(ValueSet40_50.convertBoolean(src.getInactiveElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ValueSet40_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(ValueSet40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ValueSet40_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent conceptReferenceDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(ValueSet40_50.convertConceptReferenceDesignationComponent(conceptReferenceDesignationComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet40_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        ValueSet40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(ValueSet40_50.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(ValueSet40_50.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(ValueSet40_50.convertBoolean(src.getInactiveElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ValueSet40_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(ValueSet40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ValueSet40_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent conceptReferenceDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(ValueSet40_50.convertConceptReferenceDesignationComponent(conceptReferenceDesignationComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet40_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }
}

