/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.TerminologyCapabilities;

public class TerminologyCapabilities40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.TerminologyCapabilities convertTerminologyCapabilities(TerminologyCapabilities src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.TerminologyCapabilities tgt = new org.hl7.fhir.r5.model.TerminologyCapabilities();
        TerminologyCapabilities40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(TerminologyCapabilities40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(TerminologyCapabilities40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(TerminologyCapabilities40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(TerminologyCapabilities40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(TerminologyCapabilities40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(TerminologyCapabilities40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(TerminologyCapabilities40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(TerminologyCapabilities40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TerminologyCapabilities40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(TerminologyCapabilities40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(TerminologyCapabilities40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(TerminologyCapabilities40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(TerminologyCapabilities40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(TerminologyCapabilities40_50.convertCapabilityStatementKind(src.getKindElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(TerminologyCapabilities40_50.convertTerminologyCapabilitiesSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(TerminologyCapabilities40_50.convertTerminologyCapabilitiesImplementationComponent(src.getImplementation()));
        }
        if (src.hasLockedDate()) {
            tgt.setLockedDateElement(TerminologyCapabilities40_50.convertBoolean(src.getLockedDateElement()));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent terminologyCapabilitiesCodeSystemComponent : src.getCodeSystem()) {
            tgt.addCodeSystem(TerminologyCapabilities40_50.convertTerminologyCapabilitiesCodeSystemComponent(terminologyCapabilitiesCodeSystemComponent));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(TerminologyCapabilities40_50.convertTerminologyCapabilitiesExpansionComponent(src.getExpansion()));
        }
        if (src.hasCodeSearch()) {
            tgt.setCodeSearchElement(TerminologyCapabilities40_50.convertCodeSearchSupport(src.getCodeSearchElement()));
        }
        if (src.hasValidateCode()) {
            tgt.setValidateCode(TerminologyCapabilities40_50.convertTerminologyCapabilitiesValidateCodeComponent(src.getValidateCode()));
        }
        if (src.hasTranslation()) {
            tgt.setTranslation(TerminologyCapabilities40_50.convertTerminologyCapabilitiesTranslationComponent(src.getTranslation()));
        }
        if (src.hasClosure()) {
            tgt.setClosure(TerminologyCapabilities40_50.convertTerminologyCapabilitiesClosureComponent(src.getClosure()));
        }
        return tgt;
    }

    public static TerminologyCapabilities convertTerminologyCapabilities(org.hl7.fhir.r5.model.TerminologyCapabilities src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities tgt = new TerminologyCapabilities();
        TerminologyCapabilities40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(TerminologyCapabilities40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(TerminologyCapabilities40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(TerminologyCapabilities40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(TerminologyCapabilities40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(TerminologyCapabilities40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(TerminologyCapabilities40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(TerminologyCapabilities40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(TerminologyCapabilities40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TerminologyCapabilities40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(TerminologyCapabilities40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(TerminologyCapabilities40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(TerminologyCapabilities40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(TerminologyCapabilities40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(TerminologyCapabilities40_50.convertCapabilityStatementKind(src.getKindElement()));
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(TerminologyCapabilities40_50.convertTerminologyCapabilitiesSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(TerminologyCapabilities40_50.convertTerminologyCapabilitiesImplementationComponent(src.getImplementation()));
        }
        if (src.hasLockedDate()) {
            tgt.setLockedDateElement(TerminologyCapabilities40_50.convertBoolean(src.getLockedDateElement()));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent terminologyCapabilitiesCodeSystemComponent : src.getCodeSystem()) {
            tgt.addCodeSystem(TerminologyCapabilities40_50.convertTerminologyCapabilitiesCodeSystemComponent(terminologyCapabilitiesCodeSystemComponent));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(TerminologyCapabilities40_50.convertTerminologyCapabilitiesExpansionComponent(src.getExpansion()));
        }
        if (src.hasCodeSearch()) {
            tgt.setCodeSearchElement(TerminologyCapabilities40_50.convertCodeSearchSupport(src.getCodeSearchElement()));
        }
        if (src.hasValidateCode()) {
            tgt.setValidateCode(TerminologyCapabilities40_50.convertTerminologyCapabilitiesValidateCodeComponent(src.getValidateCode()));
        }
        if (src.hasTranslation()) {
            tgt.setTranslation(TerminologyCapabilities40_50.convertTerminologyCapabilitiesTranslationComponent(src.getTranslation()));
        }
        if (src.hasClosure()) {
            tgt.setClosure(TerminologyCapabilities40_50.convertTerminologyCapabilitiesClosureComponent(src.getClosure()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> convertCapabilityStatementKind(Enumeration<TerminologyCapabilities.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TerminologyCapabilities.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TerminologyCapabilities.CapabilityStatementKind> convertCapabilityStatementKind(org.hl7.fhir.r5.model.Enumeration<Enumerations.CapabilityStatementKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TerminologyCapabilities.CapabilityStatementKind> tgt = new Enumeration<TerminologyCapabilities.CapabilityStatementKind>(new TerminologyCapabilities.CapabilityStatementKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CapabilityStatementKind)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)TerminologyCapabilities.CapabilityStatementKind.INSTANCE);
                break;
            }
            case CAPABILITY: {
                tgt.setValue((Object)TerminologyCapabilities.CapabilityStatementKind.CAPABILITY);
                break;
            }
            case REQUIREMENTS: {
                tgt.setValue((Object)TerminologyCapabilities.CapabilityStatementKind.REQUIREMENTS);
                break;
            }
            default: {
                tgt.setValue((Object)TerminologyCapabilities.CapabilityStatementKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TerminologyCapabilities.CodeSearchSupport> convertCodeSearchSupport(Enumeration<TerminologyCapabilities.CodeSearchSupport> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TerminologyCapabilities.CodeSearchSupport> tgt = new org.hl7.fhir.r5.model.Enumeration<TerminologyCapabilities.CodeSearchSupport>(new TerminologyCapabilities.CodeSearchSupportEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TerminologyCapabilities.CodeSearchSupport)((Object)src.getValue())) {
            case EXPLICIT: {
                tgt.setValue((Object)TerminologyCapabilities.CodeSearchSupport.EXPLICIT);
                break;
            }
            case ALL: {
                tgt.setValue((Object)TerminologyCapabilities.CodeSearchSupport.ALL);
                break;
            }
            default: {
                tgt.setValue((Object)TerminologyCapabilities.CodeSearchSupport.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TerminologyCapabilities.CodeSearchSupport> convertCodeSearchSupport(org.hl7.fhir.r5.model.Enumeration<TerminologyCapabilities.CodeSearchSupport> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TerminologyCapabilities.CodeSearchSupport> tgt = new Enumeration<TerminologyCapabilities.CodeSearchSupport>(new TerminologyCapabilities.CodeSearchSupportEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TerminologyCapabilities.CodeSearchSupport)((Object)src.getValue())) {
            case EXPLICIT: {
                tgt.setValue((Object)TerminologyCapabilities.CodeSearchSupport.EXPLICIT);
                break;
            }
            case ALL: {
                tgt.setValue((Object)TerminologyCapabilities.CodeSearchSupport.ALL);
                break;
            }
            default: {
                tgt.setValue((Object)TerminologyCapabilities.CodeSearchSupport.NULL);
            }
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent convertTerminologyCapabilitiesSoftwareComponent(TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TerminologyCapabilities40_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(TerminologyCapabilities40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent convertTerminologyCapabilitiesSoftwareComponent(TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TerminologyCapabilities40_50.convertString(src.getNameElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(TerminologyCapabilities40_50.convertString(src.getVersionElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent convertTerminologyCapabilitiesImplementationComponent(TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TerminologyCapabilities40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(TerminologyCapabilities40_50.convertUrl(src.getUrlElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent convertTerminologyCapabilitiesImplementationComponent(TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TerminologyCapabilities40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(TerminologyCapabilities40_50.convertUrl(src.getUrlElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent convertTerminologyCapabilitiesCodeSystemComponent(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUri()) {
            tgt.setUriElement(TerminologyCapabilities40_50.convertCanonical(src.getUriElement()));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent t : src.getVersion()) {
            tgt.addVersion(TerminologyCapabilities40_50.convertTerminologyCapabilitiesCodeSystemVersionComponent(t));
        }
        if (src.hasSubsumption()) {
            tgt.setSubsumptionElement(TerminologyCapabilities40_50.convertBoolean(src.getSubsumptionElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent convertTerminologyCapabilitiesCodeSystemComponent(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUri()) {
            tgt.setUriElement(TerminologyCapabilities40_50.convertCanonical(src.getUriElement()));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent t : src.getVersion()) {
            tgt.addVersion(TerminologyCapabilities40_50.convertTerminologyCapabilitiesCodeSystemVersionComponent(t));
        }
        if (src.hasSubsumption()) {
            tgt.setSubsumptionElement(TerminologyCapabilities40_50.convertBoolean(src.getSubsumptionElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent convertTerminologyCapabilitiesCodeSystemVersionComponent(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(TerminologyCapabilities40_50.convertString(src.getCodeElement()));
        }
        if (src.hasIsDefault()) {
            tgt.setIsDefaultElement(TerminologyCapabilities40_50.convertBoolean(src.getIsDefaultElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(TerminologyCapabilities40_50.convertBoolean(src.getCompositionalElement()));
        }
        for (CodeType codeType : src.getLanguage()) {
            tgt.getLanguage().add(TerminologyCapabilities40_50.convertCode(codeType));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent terminologyCapabilitiesCodeSystemVersionFilterComponent : src.getFilter()) {
            tgt.addFilter(TerminologyCapabilities40_50.convertTerminologyCapabilitiesCodeSystemVersionFilterComponent(terminologyCapabilitiesCodeSystemVersionFilterComponent));
        }
        for (CodeType codeType : src.getProperty()) {
            tgt.getProperty().add(TerminologyCapabilities40_50.convertCode(codeType));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent convertTerminologyCapabilitiesCodeSystemVersionComponent(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(TerminologyCapabilities40_50.convertString(src.getCodeElement()));
        }
        if (src.hasIsDefault()) {
            tgt.setIsDefaultElement(TerminologyCapabilities40_50.convertBoolean(src.getIsDefaultElement()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositionalElement(TerminologyCapabilities40_50.convertBoolean(src.getCompositionalElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getLanguage()) {
            tgt.getLanguage().add(TerminologyCapabilities40_50.convertCode(codeType));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent terminologyCapabilitiesCodeSystemVersionFilterComponent : src.getFilter()) {
            tgt.addFilter(TerminologyCapabilities40_50.convertTerminologyCapabilitiesCodeSystemVersionFilterComponent(terminologyCapabilitiesCodeSystemVersionFilterComponent));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getProperty()) {
            tgt.getProperty().add(TerminologyCapabilities40_50.convertCode(codeType));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent convertTerminologyCapabilitiesCodeSystemVersionFilterComponent(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(TerminologyCapabilities40_50.convertCode(src.getCodeElement()));
        }
        for (CodeType t : src.getOp()) {
            tgt.getOp().add(TerminologyCapabilities40_50.convertCode(t));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent convertTerminologyCapabilitiesCodeSystemVersionFilterComponent(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(TerminologyCapabilities40_50.convertCode(src.getCodeElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType t : src.getOp()) {
            tgt.getOp().add(TerminologyCapabilities40_50.convertCode(t));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent convertTerminologyCapabilitiesExpansionComponent(TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasHierarchical()) {
            tgt.setHierarchicalElement(TerminologyCapabilities40_50.convertBoolean(src.getHierarchicalElement()));
        }
        if (src.hasPaging()) {
            tgt.setPagingElement(TerminologyCapabilities40_50.convertBoolean(src.getPagingElement()));
        }
        if (src.hasIncomplete()) {
            tgt.setIncompleteElement(TerminologyCapabilities40_50.convertBoolean(src.getIncompleteElement()));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent t : src.getParameter()) {
            tgt.addParameter(TerminologyCapabilities40_50.convertTerminologyCapabilitiesExpansionParameterComponent(t));
        }
        if (src.hasTextFilter()) {
            tgt.setTextFilterElement(TerminologyCapabilities40_50.convertMarkdown(src.getTextFilterElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent convertTerminologyCapabilitiesExpansionComponent(TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasHierarchical()) {
            tgt.setHierarchicalElement(TerminologyCapabilities40_50.convertBoolean(src.getHierarchicalElement()));
        }
        if (src.hasPaging()) {
            tgt.setPagingElement(TerminologyCapabilities40_50.convertBoolean(src.getPagingElement()));
        }
        if (src.hasIncomplete()) {
            tgt.setIncompleteElement(TerminologyCapabilities40_50.convertBoolean(src.getIncompleteElement()));
        }
        for (TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent t : src.getParameter()) {
            tgt.addParameter(TerminologyCapabilities40_50.convertTerminologyCapabilitiesExpansionParameterComponent(t));
        }
        if (src.hasTextFilter()) {
            tgt.setTextFilterElement(TerminologyCapabilities40_50.convertMarkdown(src.getTextFilterElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent convertTerminologyCapabilitiesExpansionParameterComponent(TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TerminologyCapabilities40_50.convertCode(src.getNameElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(TerminologyCapabilities40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent convertTerminologyCapabilitiesExpansionParameterComponent(TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TerminologyCapabilities40_50.convertCode(src.getNameElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(TerminologyCapabilities40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent convertTerminologyCapabilitiesValidateCodeComponent(TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTranslations()) {
            tgt.setTranslationsElement(TerminologyCapabilities40_50.convertBoolean(src.getTranslationsElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent convertTerminologyCapabilitiesValidateCodeComponent(TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTranslations()) {
            tgt.setTranslationsElement(TerminologyCapabilities40_50.convertBoolean(src.getTranslationsElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent convertTerminologyCapabilitiesTranslationComponent(TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNeedsMap()) {
            tgt.setNeedsMapElement(TerminologyCapabilities40_50.convertBoolean(src.getNeedsMapElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent convertTerminologyCapabilitiesTranslationComponent(TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNeedsMap()) {
            tgt.setNeedsMapElement(TerminologyCapabilities40_50.convertBoolean(src.getNeedsMapElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesClosureComponent convertTerminologyCapabilitiesClosureComponent(TerminologyCapabilities.TerminologyCapabilitiesClosureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesClosureComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesClosureComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTranslation()) {
            tgt.setTranslationElement(TerminologyCapabilities40_50.convertBoolean(src.getTranslationElement()));
        }
        return tgt;
    }

    public static TerminologyCapabilities.TerminologyCapabilitiesClosureComponent convertTerminologyCapabilitiesClosureComponent(TerminologyCapabilities.TerminologyCapabilitiesClosureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TerminologyCapabilities.TerminologyCapabilitiesClosureComponent tgt = new TerminologyCapabilities.TerminologyCapabilitiesClosureComponent();
        TerminologyCapabilities40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTranslation()) {
            tgt.setTranslationElement(TerminologyCapabilities40_50.convertBoolean(src.getTranslationElement()));
        }
        return tgt;
    }
}

