/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r5.model.Substance;

public class Substance40_50
extends VersionConvertor_40_50 {
    public static Substance convertSubstance(org.hl7.fhir.r4.model.Substance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance tgt = new Substance();
        Substance40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Substance40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Substance40_50.convertFHIRSubstanceStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Substance40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(Substance40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Substance40_50.convertString(src.getDescriptionElement()));
        }
        for (Substance.SubstanceInstanceComponent substanceInstanceComponent : src.getInstance()) {
            tgt.addInstance(Substance40_50.convertSubstanceInstanceComponent(substanceInstanceComponent));
        }
        for (Substance.SubstanceIngredientComponent substanceIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(Substance40_50.convertSubstanceIngredientComponent(substanceIngredientComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Substance convertSubstance(Substance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Substance tgt = new org.hl7.fhir.r4.model.Substance();
        Substance40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Substance40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Substance40_50.convertFHIRSubstanceStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Substance40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(Substance40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Substance40_50.convertString(src.getDescriptionElement()));
        }
        for (Substance.SubstanceInstanceComponent substanceInstanceComponent : src.getInstance()) {
            tgt.addInstance(Substance40_50.convertSubstanceInstanceComponent(substanceInstanceComponent));
        }
        for (Substance.SubstanceIngredientComponent substanceIngredientComponent : src.getIngredient()) {
            tgt.addIngredient(Substance40_50.convertSubstanceIngredientComponent(substanceIngredientComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Substance.FHIRSubstanceStatus> convertFHIRSubstanceStatus(Enumeration<Substance.FHIRSubstanceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Substance.FHIRSubstanceStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Substance.FHIRSubstanceStatus>(new Substance.FHIRSubstanceStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Substance.FHIRSubstanceStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Substance.FHIRSubstanceStatus> convertFHIRSubstanceStatus(org.hl7.fhir.r5.model.Enumeration<Substance.FHIRSubstanceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Substance.FHIRSubstanceStatus> tgt = new Enumeration<Substance.FHIRSubstanceStatus>(new Substance.FHIRSubstanceStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Substance.FHIRSubstanceStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Substance.FHIRSubstanceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        Substance40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Substance40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiry()) {
            tgt.setExpiryElement(Substance40_50.convertDateTime(src.getExpiryElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Substance40_50.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        Substance40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Substance40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiry()) {
            tgt.setExpiryElement(Substance40_50.convertDateTime(src.getExpiryElement()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Substance40_50.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        Substance40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(Substance40_50.convertRatio(src.getQuantity()));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(Substance40_50.convertType(src.getSubstance()));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        Substance40_50.copyElement(src, tgt, new String[0]);
        if (src.hasQuantity()) {
            tgt.setQuantity(Substance40_50.convertRatio(src.getQuantity()));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(Substance40_50.convertType(src.getSubstance()));
        }
        return tgt;
    }
}

