/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.SpecimenDefinition;

public class SpecimenDefinition40_50
extends VersionConvertor_40_50 {
    public static SpecimenDefinition convertSpecimenDefinition(org.hl7.fhir.r4.model.SpecimenDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition tgt = new SpecimenDefinition();
        SpecimenDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(SpecimenDefinition40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasTypeCollected()) {
            tgt.setTypeCollected(SpecimenDefinition40_50.convertCodeableConcept(src.getTypeCollected()));
        }
        for (CodeableConcept codeableConcept : src.getPatientPreparation()) {
            tgt.addPatientPreparation(SpecimenDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTimeAspect()) {
            tgt.setTimeAspectElement(SpecimenDefinition40_50.convertString(src.getTimeAspectElement()));
        }
        for (CodeableConcept codeableConcept : src.getCollection()) {
            tgt.addCollection(SpecimenDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (SpecimenDefinition.SpecimenDefinitionTypeTestedComponent specimenDefinitionTypeTestedComponent : src.getTypeTested()) {
            tgt.addTypeTested(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedComponent(specimenDefinitionTypeTestedComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.SpecimenDefinition convertSpecimenDefinition(SpecimenDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.SpecimenDefinition tgt = new org.hl7.fhir.r4.model.SpecimenDefinition();
        SpecimenDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(SpecimenDefinition40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasTypeCollected()) {
            tgt.setTypeCollected(SpecimenDefinition40_50.convertCodeableConcept(src.getTypeCollected()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getPatientPreparation()) {
            tgt.addPatientPreparation(SpecimenDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTimeAspect()) {
            tgt.setTimeAspectElement(SpecimenDefinition40_50.convertString(src.getTimeAspectElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCollection()) {
            tgt.addCollection(SpecimenDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (SpecimenDefinition.SpecimenDefinitionTypeTestedComponent specimenDefinitionTypeTestedComponent : src.getTypeTested()) {
            tgt.addTypeTested(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedComponent(specimenDefinitionTypeTestedComponent));
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedComponent convertSpecimenDefinitionTypeTestedComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIsDerived()) {
            tgt.setIsDerivedElement(SpecimenDefinition40_50.convertBoolean(src.getIsDerivedElement()));
        }
        if (src.hasType()) {
            tgt.setType(SpecimenDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPreference()) {
            tgt.setPreferenceElement(SpecimenDefinition40_50.convertSpecimenContainedPreference(src.getPreferenceElement()));
        }
        if (src.hasContainer()) {
            tgt.setContainer(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedContainerComponent(src.getContainer()));
        }
        if (src.hasRequirement()) {
            tgt.setRequirementElement(SpecimenDefinition40_50.convertString(src.getRequirementElement()));
        }
        if (src.hasRetentionTime()) {
            tgt.setRetentionTime(SpecimenDefinition40_50.convertDuration(src.getRetentionTime()));
        }
        for (CodeableConcept codeableConcept : src.getRejectionCriterion()) {
            tgt.addRejectionCriterion(SpecimenDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent specimenDefinitionTypeTestedHandlingComponent : src.getHandling()) {
            tgt.addHandling(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedHandlingComponent(specimenDefinitionTypeTestedHandlingComponent));
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedComponent convertSpecimenDefinitionTypeTestedComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIsDerived()) {
            tgt.setIsDerivedElement(SpecimenDefinition40_50.convertBoolean(src.getIsDerivedElement()));
        }
        if (src.hasType()) {
            tgt.setType(SpecimenDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasPreference()) {
            tgt.setPreferenceElement(SpecimenDefinition40_50.convertSpecimenContainedPreference(src.getPreferenceElement()));
        }
        if (src.hasContainer()) {
            tgt.setContainer(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedContainerComponent(src.getContainer()));
        }
        if (src.hasRequirement()) {
            tgt.setRequirementElement(SpecimenDefinition40_50.convertString(src.getRequirementElement()));
        }
        if (src.hasRetentionTime()) {
            tgt.setRetentionTime(SpecimenDefinition40_50.convertDuration(src.getRetentionTime()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getRejectionCriterion()) {
            tgt.addRejectionCriterion(SpecimenDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent specimenDefinitionTypeTestedHandlingComponent : src.getHandling()) {
            tgt.addHandling(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedHandlingComponent(specimenDefinitionTypeTestedHandlingComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<SpecimenDefinition.SpecimenContainedPreference> convertSpecimenContainedPreference(Enumeration<SpecimenDefinition.SpecimenContainedPreference> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<SpecimenDefinition.SpecimenContainedPreference> tgt = new org.hl7.fhir.r5.model.Enumeration<SpecimenDefinition.SpecimenContainedPreference>(new SpecimenDefinition.SpecimenContainedPreferenceEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((SpecimenDefinition.SpecimenContainedPreference)((Object)src.getValue())) {
            case PREFERRED: {
                tgt.setValue((Object)SpecimenDefinition.SpecimenContainedPreference.PREFERRED);
                break;
            }
            case ALTERNATE: {
                tgt.setValue((Object)SpecimenDefinition.SpecimenContainedPreference.ALTERNATE);
                break;
            }
            default: {
                tgt.setValue((Object)SpecimenDefinition.SpecimenContainedPreference.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SpecimenDefinition.SpecimenContainedPreference> convertSpecimenContainedPreference(org.hl7.fhir.r5.model.Enumeration<SpecimenDefinition.SpecimenContainedPreference> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SpecimenDefinition.SpecimenContainedPreference> tgt = new Enumeration<SpecimenDefinition.SpecimenContainedPreference>(new SpecimenDefinition.SpecimenContainedPreferenceEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((SpecimenDefinition.SpecimenContainedPreference)((Object)src.getValue())) {
            case PREFERRED: {
                tgt.setValue((Object)SpecimenDefinition.SpecimenContainedPreference.PREFERRED);
                break;
            }
            case ALTERNATE: {
                tgt.setValue((Object)SpecimenDefinition.SpecimenContainedPreference.ALTERNATE);
                break;
            }
            default: {
                tgt.setValue((Object)SpecimenDefinition.SpecimenContainedPreference.NULL);
            }
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent convertSpecimenDefinitionTypeTestedContainerComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMaterial()) {
            tgt.setMaterial(SpecimenDefinition40_50.convertCodeableConcept(src.getMaterial()));
        }
        if (src.hasType()) {
            tgt.setType(SpecimenDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasCap()) {
            tgt.setCap(SpecimenDefinition40_50.convertCodeableConcept(src.getCap()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(SpecimenDefinition40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(SpecimenDefinition40_50.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasMinimumVolume()) {
            tgt.setMinimumVolume(SpecimenDefinition40_50.convertType(src.getMinimumVolume()));
        }
        for (SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent t : src.getAdditive()) {
            tgt.addAdditive(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedContainerAdditiveComponent(t));
        }
        if (src.hasPreparation()) {
            tgt.setPreparationElement(SpecimenDefinition40_50.convertString(src.getPreparationElement()));
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent convertSpecimenDefinitionTypeTestedContainerComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMaterial()) {
            tgt.setMaterial(SpecimenDefinition40_50.convertCodeableConcept(src.getMaterial()));
        }
        if (src.hasType()) {
            tgt.setType(SpecimenDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasCap()) {
            tgt.setCap(SpecimenDefinition40_50.convertCodeableConcept(src.getCap()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(SpecimenDefinition40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(SpecimenDefinition40_50.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasMinimumVolume()) {
            tgt.setMinimumVolume(SpecimenDefinition40_50.convertType(src.getMinimumVolume()));
        }
        for (SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent t : src.getAdditive()) {
            tgt.addAdditive(SpecimenDefinition40_50.convertSpecimenDefinitionTypeTestedContainerAdditiveComponent(t));
        }
        if (src.hasPreparation()) {
            tgt.setPreparationElement(SpecimenDefinition40_50.convertString(src.getPreparationElement()));
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent convertSpecimenDefinitionTypeTestedContainerAdditiveComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAdditive()) {
            tgt.setAdditive(SpecimenDefinition40_50.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent convertSpecimenDefinitionTypeTestedContainerAdditiveComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAdditive()) {
            tgt.setAdditive(SpecimenDefinition40_50.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent convertSpecimenDefinitionTypeTestedHandlingComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTemperatureQualifier()) {
            tgt.setTemperatureQualifier(SpecimenDefinition40_50.convertCodeableConcept(src.getTemperatureQualifier()));
        }
        if (src.hasTemperatureRange()) {
            tgt.setTemperatureRange(SpecimenDefinition40_50.convertRange(src.getTemperatureRange()));
        }
        if (src.hasMaxDuration()) {
            tgt.setMaxDuration(SpecimenDefinition40_50.convertDuration(src.getMaxDuration()));
        }
        if (src.hasInstruction()) {
            tgt.setInstructionElement(SpecimenDefinition40_50.convertString(src.getInstructionElement()));
        }
        return tgt;
    }

    public static SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent convertSpecimenDefinitionTypeTestedHandlingComponent(SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent tgt = new SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent();
        SpecimenDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTemperatureQualifier()) {
            tgt.setTemperatureQualifier(SpecimenDefinition40_50.convertCodeableConcept(src.getTemperatureQualifier()));
        }
        if (src.hasTemperatureRange()) {
            tgt.setTemperatureRange(SpecimenDefinition40_50.convertRange(src.getTemperatureRange()));
        }
        if (src.hasMaxDuration()) {
            tgt.setMaxDuration(SpecimenDefinition40_50.convertDuration(src.getMaxDuration()));
        }
        if (src.hasInstruction()) {
            tgt.setInstructionElement(SpecimenDefinition40_50.convertString(src.getInstructionElement()));
        }
        return tgt;
    }
}

