/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResearchStudy;

public class ResearchStudy40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ResearchStudy convertResearchStudy(ResearchStudy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ResearchStudy tgt = new org.hl7.fhir.r5.model.ResearchStudy();
        ResearchStudy40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ResearchStudy40_50.convertIdentifier(identifier));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ResearchStudy40_50.convertString(src.getTitleElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getProtocol()) {
            tgt.addProtocol(ResearchStudy40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(ResearchStudy40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ResearchStudy40_50.convertResearchStudyStatus(src.getStatusElement()));
        }
        if (src.hasPrimaryPurposeType()) {
            tgt.setPrimaryPurposeType(ResearchStudy40_50.convertCodeableConcept(src.getPrimaryPurposeType()));
        }
        if (src.hasPhase()) {
            tgt.setPhase(ResearchStudy40_50.convertCodeableConcept(src.getPhase()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getFocus()) {
            tgt.addFocus(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCondition()) {
            tgt.addCondition(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ResearchStudy40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r4.model.RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(ResearchStudy40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getKeyword()) {
            tgt.addKeyword(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getLocation()) {
            tgt.addLocation(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ResearchStudy40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEnrollment()) {
            tgt.addEnrollment(ResearchStudy40_50.convertReference(reference));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(ResearchStudy40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasSponsor()) {
            tgt.setSponsor(ResearchStudy40_50.convertReference(src.getSponsor()));
        }
        if (src.hasPrincipalInvestigator()) {
            tgt.setPrincipalInvestigator(ResearchStudy40_50.convertReference(src.getPrincipalInvestigator()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSite()) {
            tgt.addSite(ResearchStudy40_50.convertReference(reference));
        }
        if (src.hasReasonStopped()) {
            tgt.setReasonStopped(ResearchStudy40_50.convertCodeableConcept(src.getReasonStopped()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(ResearchStudy40_50.convertAnnotation(annotation));
        }
        for (ResearchStudy.ResearchStudyArmComponent researchStudyArmComponent : src.getArm()) {
            tgt.addArm(ResearchStudy40_50.convertResearchStudyArmComponent(researchStudyArmComponent));
        }
        for (ResearchStudy.ResearchStudyObjectiveComponent researchStudyObjectiveComponent : src.getObjective()) {
            tgt.addObjective(ResearchStudy40_50.convertResearchStudyObjectiveComponent(researchStudyObjectiveComponent));
        }
        return tgt;
    }

    public static ResearchStudy convertResearchStudy(org.hl7.fhir.r5.model.ResearchStudy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ResearchStudy tgt = new ResearchStudy();
        ResearchStudy40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ResearchStudy40_50.convertIdentifier(identifier));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ResearchStudy40_50.convertString(src.getTitleElement()));
        }
        for (Reference reference : src.getProtocol()) {
            tgt.addProtocol(ResearchStudy40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(ResearchStudy40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ResearchStudy40_50.convertResearchStudyStatus(src.getStatusElement()));
        }
        if (src.hasPrimaryPurposeType()) {
            tgt.setPrimaryPurposeType(ResearchStudy40_50.convertCodeableConcept(src.getPrimaryPurposeType()));
        }
        if (src.hasPhase()) {
            tgt.setPhase(ResearchStudy40_50.convertCodeableConcept(src.getPhase()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getFocus()) {
            tgt.addFocus(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getCondition()) {
            tgt.addCondition(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ResearchStudy40_50.convertContactDetail(contactDetail));
        }
        for (RelatedArtifact relatedArtifact : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(ResearchStudy40_50.convertRelatedArtifact(relatedArtifact));
        }
        for (CodeableConcept codeableConcept : src.getKeyword()) {
            tgt.addKeyword(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getLocation()) {
            tgt.addLocation(ResearchStudy40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ResearchStudy40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (Reference reference : src.getEnrollment()) {
            tgt.addEnrollment(ResearchStudy40_50.convertReference(reference));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(ResearchStudy40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasSponsor()) {
            tgt.setSponsor(ResearchStudy40_50.convertReference(src.getSponsor()));
        }
        if (src.hasPrincipalInvestigator()) {
            tgt.setPrincipalInvestigator(ResearchStudy40_50.convertReference(src.getPrincipalInvestigator()));
        }
        for (Reference reference : src.getSite()) {
            tgt.addSite(ResearchStudy40_50.convertReference(reference));
        }
        if (src.hasReasonStopped()) {
            tgt.setReasonStopped(ResearchStudy40_50.convertCodeableConcept(src.getReasonStopped()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(ResearchStudy40_50.convertAnnotation(annotation));
        }
        for (ResearchStudy.ResearchStudyArmComponent researchStudyArmComponent : src.getArm()) {
            tgt.addArm(ResearchStudy40_50.convertResearchStudyArmComponent(researchStudyArmComponent));
        }
        for (ResearchStudy.ResearchStudyObjectiveComponent researchStudyObjectiveComponent : src.getObjective()) {
            tgt.addObjective(ResearchStudy40_50.convertResearchStudyObjectiveComponent(researchStudyObjectiveComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ResearchStudy.ResearchStudyStatus> convertResearchStudyStatus(Enumeration<ResearchStudy.ResearchStudyStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ResearchStudy.ResearchStudyStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<ResearchStudy.ResearchStudyStatus>(new ResearchStudy.ResearchStudyStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ResearchStudy.ResearchStudyStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.ACTIVE);
                break;
            }
            case ADMINISTRATIVELYCOMPLETED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.ADMINISTRATIVELYCOMPLETED);
                break;
            }
            case APPROVED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.APPROVED);
                break;
            }
            case CLOSEDTOACCRUAL: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.CLOSEDTOACCRUAL);
                break;
            }
            case CLOSEDTOACCRUALANDINTERVENTION: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.CLOSEDTOACCRUALANDINTERVENTION);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.COMPLETED);
                break;
            }
            case DISAPPROVED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.DISAPPROVED);
                break;
            }
            case INREVIEW: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.INREVIEW);
                break;
            }
            case TEMPORARILYCLOSEDTOACCRUAL: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUAL);
                break;
            }
            case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION);
                break;
            }
            case WITHDRAWN: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.WITHDRAWN);
                break;
            }
            default: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ResearchStudy.ResearchStudyStatus> convertResearchStudyStatus(org.hl7.fhir.r5.model.Enumeration<ResearchStudy.ResearchStudyStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ResearchStudy.ResearchStudyStatus> tgt = new Enumeration<ResearchStudy.ResearchStudyStatus>(new ResearchStudy.ResearchStudyStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ResearchStudy.ResearchStudyStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.ACTIVE);
                break;
            }
            case ADMINISTRATIVELYCOMPLETED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.ADMINISTRATIVELYCOMPLETED);
                break;
            }
            case APPROVED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.APPROVED);
                break;
            }
            case CLOSEDTOACCRUAL: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.CLOSEDTOACCRUAL);
                break;
            }
            case CLOSEDTOACCRUALANDINTERVENTION: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.CLOSEDTOACCRUALANDINTERVENTION);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.COMPLETED);
                break;
            }
            case DISAPPROVED: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.DISAPPROVED);
                break;
            }
            case INREVIEW: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.INREVIEW);
                break;
            }
            case TEMPORARILYCLOSEDTOACCRUAL: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUAL);
                break;
            }
            case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION);
                break;
            }
            case WITHDRAWN: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.WITHDRAWN);
                break;
            }
            default: {
                tgt.setValue((Object)ResearchStudy.ResearchStudyStatus.NULL);
            }
        }
        return tgt;
    }

    public static ResearchStudy.ResearchStudyArmComponent convertResearchStudyArmComponent(ResearchStudy.ResearchStudyArmComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ResearchStudy.ResearchStudyArmComponent tgt = new ResearchStudy.ResearchStudyArmComponent();
        ResearchStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ResearchStudy40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setType(ResearchStudy40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ResearchStudy40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ResearchStudy.ResearchStudyArmComponent convertResearchStudyArmComponent(ResearchStudy.ResearchStudyArmComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ResearchStudy.ResearchStudyArmComponent tgt = new ResearchStudy.ResearchStudyArmComponent();
        ResearchStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ResearchStudy40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setType(ResearchStudy40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ResearchStudy40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ResearchStudy.ResearchStudyObjectiveComponent convertResearchStudyObjectiveComponent(ResearchStudy.ResearchStudyObjectiveComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ResearchStudy.ResearchStudyObjectiveComponent tgt = new ResearchStudy.ResearchStudyObjectiveComponent();
        ResearchStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ResearchStudy40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setType(ResearchStudy40_50.convertCodeableConcept(src.getType()));
        }
        return tgt;
    }

    public static ResearchStudy.ResearchStudyObjectiveComponent convertResearchStudyObjectiveComponent(ResearchStudy.ResearchStudyObjectiveComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ResearchStudy.ResearchStudyObjectiveComponent tgt = new ResearchStudy.ResearchStudyObjectiveComponent();
        ResearchStudy40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(ResearchStudy40_50.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setType(ResearchStudy40_50.convertCodeableConcept(src.getType()));
        }
        return tgt;
    }
}

