/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Reference;

public class Procedure40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Procedure convertProcedure(Procedure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Procedure tgt = new org.hl7.fhir.r5.model.Procedure();
        Procedure40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Procedure40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(Procedure40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(Procedure40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Procedure40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(Procedure40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Procedure40_50.convertProcedureStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Procedure40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(Procedure40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(Procedure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Procedure40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Procedure40_50.convertReference(src.getEncounter()));
        }
        if (src.hasPerformed()) {
            tgt.setOccurrence(Procedure40_50.convertType(src.getPerformed()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(Procedure40_50.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setReported(Procedure40_50.convertReference(src.getAsserter()));
        }
        for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Procedure40_50.convertProcedurePerformerComponent(procedurePerformerComponent));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Procedure40_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(Procedure40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(Procedure40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(Procedure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(Procedure40_50.convertCodeableConcept(src.getOutcome()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReport()) {
            tgt.addReport(Procedure40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getComplication()) {
            tgt.addComplication(Procedure40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getComplicationDetail()) {
            tgt.addComplicationDetail(Procedure40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getFollowUp()) {
            tgt.addFollowUp(Procedure40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Procedure40_50.convertAnnotation(annotation));
        }
        for (Procedure.ProcedureFocalDeviceComponent procedureFocalDeviceComponent : src.getFocalDevice()) {
            tgt.addFocalDevice(Procedure40_50.convertProcedureFocalDeviceComponent(procedureFocalDeviceComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUsedReference()) {
            tgt.addUsed(Procedure40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getUsedCode()) {
            tgt.addUsed(Procedure40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        return tgt;
    }

    public static Procedure convertProcedure(org.hl7.fhir.r5.model.Procedure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure tgt = new Procedure();
        Procedure40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Procedure40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(Procedure40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(Procedure40_50.convertUri(uriType));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(Procedure40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(Procedure40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Procedure40_50.convertProcedureStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(Procedure40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Procedure40_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasCode()) {
            tgt.setCode(Procedure40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Procedure40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Procedure40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setPerformed(Procedure40_50.convertType(src.getOccurrence()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(Procedure40_50.convertReference(src.getRecorder()));
        }
        if (src.hasReportedReference()) {
            tgt.setAsserter(Procedure40_50.convertReference(src.getReportedReference()));
        }
        for (Procedure.ProcedurePerformerComponent procedurePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(Procedure40_50.convertProcedurePerformerComponent(procedurePerformerComponent));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Procedure40_50.convertReference(src.getLocation()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(Procedure40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(Procedure40_50.convertReference(codeableReference.getReference()));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(Procedure40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(Procedure40_50.convertCodeableConcept(src.getOutcome()));
        }
        for (Reference reference : src.getReport()) {
            tgt.addReport(Procedure40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getComplication()) {
            tgt.addComplication(Procedure40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getComplicationDetail()) {
            tgt.addComplicationDetail(Procedure40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getFollowUp()) {
            tgt.addFollowUp(Procedure40_50.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Procedure40_50.convertAnnotation(annotation));
        }
        for (Procedure.ProcedureFocalDeviceComponent procedureFocalDeviceComponent : src.getFocalDevice()) {
            tgt.addFocalDevice(Procedure40_50.convertProcedureFocalDeviceComponent(procedureFocalDeviceComponent));
        }
        for (CodeableReference codeableReference : src.getUsed()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addUsedReference(Procedure40_50.convertReference(codeableReference.getReference()));
        }
        for (CodeableReference codeableReference : src.getUsed()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addUsedCode(Procedure40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> convertProcedureStatus(Enumeration<Procedure.ProcedureStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Procedure.ProcedureStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Enumerations.EventStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Enumerations.EventStatus.INPROGRESS);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)Enumerations.EventStatus.NOTDONE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.EventStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)Enumerations.EventStatus.STOPPED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.EventStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.EventStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.EventStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.EventStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Procedure.ProcedureStatus> convertProcedureStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Procedure.ProcedureStatus> tgt = new Enumeration<Procedure.ProcedureStatus>(new Procedure.ProcedureStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.EventStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Procedure.ProcedureStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Procedure.ProcedureStatus.INPROGRESS);
                break;
            }
            case NOTDONE: {
                tgt.setValue((Object)Procedure.ProcedureStatus.NOTDONE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ONHOLD);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.STOPPED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Procedure.ProcedureStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Procedure.ProcedureStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Procedure.ProcedureStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Procedure.ProcedureStatus.NULL);
            }
        }
        return tgt;
    }

    public static Procedure.ProcedurePerformerComponent convertProcedurePerformerComponent(Procedure.ProcedurePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedurePerformerComponent tgt = new Procedure.ProcedurePerformerComponent();
        Procedure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(Procedure40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(Procedure40_50.convertReference(src.getActor()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(Procedure40_50.convertReference(src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Procedure.ProcedurePerformerComponent convertProcedurePerformerComponent(Procedure.ProcedurePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedurePerformerComponent tgt = new Procedure.ProcedurePerformerComponent();
        Procedure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFunction()) {
            tgt.setFunction(Procedure40_50.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(Procedure40_50.convertReference(src.getActor()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(Procedure40_50.convertReference(src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Procedure.ProcedureFocalDeviceComponent convertProcedureFocalDeviceComponent(Procedure.ProcedureFocalDeviceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedureFocalDeviceComponent tgt = new Procedure.ProcedureFocalDeviceComponent();
        Procedure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAction()) {
            tgt.setAction(Procedure40_50.convertCodeableConcept(src.getAction()));
        }
        if (src.hasManipulated()) {
            tgt.setManipulated(Procedure40_50.convertReference(src.getManipulated()));
        }
        return tgt;
    }

    public static Procedure.ProcedureFocalDeviceComponent convertProcedureFocalDeviceComponent(Procedure.ProcedureFocalDeviceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Procedure.ProcedureFocalDeviceComponent tgt = new Procedure.ProcedureFocalDeviceComponent();
        Procedure40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAction()) {
            tgt.setAction(Procedure40_50.convertCodeableConcept(src.getAction()));
        }
        if (src.hasManipulated()) {
            tgt.setManipulated(Procedure40_50.convertReference(src.getManipulated()));
        }
        return tgt;
    }
}

