/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Reference;

public class PractitionerRole40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.PractitionerRole convertPractitionerRole(PractitionerRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.PractitionerRole tgt = new org.hl7.fhir.r5.model.PractitionerRole();
        PractitionerRole40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(PractitionerRole40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(PractitionerRole40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(PractitionerRole40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasPractitioner()) {
            tgt.setPractitioner(PractitionerRole40_50.convertReference(src.getPractitioner()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(PractitionerRole40_50.convertReference(src.getOrganization()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(PractitionerRole40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(PractitionerRole40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getLocation()) {
            tgt.addLocation(PractitionerRole40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getHealthcareService()) {
            tgt.addHealthcareService(PractitionerRole40_50.convertReference(reference));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(PractitionerRole40_50.convertContactPoint(contactPoint));
        }
        for (PractitionerRole.PractitionerRoleAvailableTimeComponent practitionerRoleAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(PractitionerRole40_50.convertPractitionerRoleAvailableTimeComponent(practitionerRoleAvailableTimeComponent));
        }
        for (PractitionerRole.PractitionerRoleNotAvailableComponent practitionerRoleNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(PractitionerRole40_50.convertPractitionerRoleNotAvailableComponent(practitionerRoleNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(PractitionerRole40_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(PractitionerRole40_50.convertReference(reference));
        }
        return tgt;
    }

    public static PractitionerRole convertPractitionerRole(org.hl7.fhir.r5.model.PractitionerRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole tgt = new PractitionerRole();
        PractitionerRole40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(PractitionerRole40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(PractitionerRole40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(PractitionerRole40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasPractitioner()) {
            tgt.setPractitioner(PractitionerRole40_50.convertReference(src.getPractitioner()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(PractitionerRole40_50.convertReference(src.getOrganization()));
        }
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(PractitionerRole40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(PractitionerRole40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getLocation()) {
            tgt.addLocation(PractitionerRole40_50.convertReference(reference));
        }
        for (Reference reference : src.getHealthcareService()) {
            tgt.addHealthcareService(PractitionerRole40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(PractitionerRole40_50.convertContactPoint(contactPoint));
        }
        for (PractitionerRole.PractitionerRoleAvailableTimeComponent practitionerRoleAvailableTimeComponent : src.getAvailableTime()) {
            tgt.addAvailableTime(PractitionerRole40_50.convertPractitionerRoleAvailableTimeComponent(practitionerRoleAvailableTimeComponent));
        }
        for (PractitionerRole.PractitionerRoleNotAvailableComponent practitionerRoleNotAvailableComponent : src.getNotAvailable()) {
            tgt.addNotAvailable(PractitionerRole40_50.convertPractitionerRoleNotAvailableComponent(practitionerRoleNotAvailableComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(PractitionerRole40_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(PractitionerRole40_50.convertReference(reference));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleAvailableTimeComponent convertPractitionerRoleAvailableTimeComponent(PractitionerRole.PractitionerRoleAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleAvailableTimeComponent tgt = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        PractitionerRole40_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(PractitionerRole40_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(PractitionerRole40_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(PractitionerRole40_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(PractitionerRole40_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleAvailableTimeComponent convertPractitionerRoleAvailableTimeComponent(PractitionerRole.PractitionerRoleAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleAvailableTimeComponent tgt = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        PractitionerRole40_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(PractitionerRole40_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(PractitionerRole40_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTimeElement(PractitionerRole40_50.convertTime(src.getAvailableStartTimeElement()));
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTimeElement(PractitionerRole40_50.convertTime(src.getAvailableEndTimeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> convertDaysOfWeek(Enumeration<PractitionerRole.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PractitionerRole.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PractitionerRole.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PractitionerRole.DaysOfWeek> tgt = new Enumeration<PractitionerRole.DaysOfWeek>(new PractitionerRole.DaysOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)PractitionerRole.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleNotAvailableComponent convertPractitionerRoleNotAvailableComponent(PractitionerRole.PractitionerRoleNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleNotAvailableComponent tgt = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        PractitionerRole40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(PractitionerRole40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(PractitionerRole40_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleNotAvailableComponent convertPractitionerRoleNotAvailableComponent(PractitionerRole.PractitionerRoleNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleNotAvailableComponent tgt = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        PractitionerRole40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(PractitionerRole40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDuring()) {
            tgt.setDuring(PractitionerRole40_50.convertPeriod(src.getDuring()));
        }
        return tgt;
    }
}

