/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PaymentReconciliation;

public class PaymentReconciliation40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.PaymentReconciliation convertPaymentReconciliation(PaymentReconciliation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.PaymentReconciliation tgt = new org.hl7.fhir.r5.model.PaymentReconciliation();
        PaymentReconciliation40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(PaymentReconciliation40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(PaymentReconciliation40_50.convertPaymentReconciliationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(PaymentReconciliation40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(PaymentReconciliation40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasPaymentIssuer()) {
            tgt.setPaymentIssuer(PaymentReconciliation40_50.convertReference(src.getPaymentIssuer()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(PaymentReconciliation40_50.convertReference(src.getRequest()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(PaymentReconciliation40_50.convertReference(src.getRequestor()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(PaymentReconciliation40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(PaymentReconciliation40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasPaymentDate()) {
            tgt.setPaymentDateElement(PaymentReconciliation40_50.convertDate(src.getPaymentDateElement()));
        }
        if (src.hasPaymentAmount()) {
            tgt.setPaymentAmount(PaymentReconciliation40_50.convertMoney(src.getPaymentAmount()));
        }
        if (src.hasPaymentIdentifier()) {
            tgt.setPaymentIdentifier(PaymentReconciliation40_50.convertIdentifier(src.getPaymentIdentifier()));
        }
        for (PaymentReconciliation.DetailsComponent detailsComponent : src.getDetail()) {
            tgt.addDetail(PaymentReconciliation40_50.convertDetailsComponent(detailsComponent));
        }
        if (src.hasFormCode()) {
            tgt.setFormCode(PaymentReconciliation40_50.convertCodeableConcept(src.getFormCode()));
        }
        for (PaymentReconciliation.NotesComponent notesComponent : src.getProcessNote()) {
            tgt.addProcessNote(PaymentReconciliation40_50.convertNotesComponent(notesComponent));
        }
        return tgt;
    }

    public static PaymentReconciliation convertPaymentReconciliation(org.hl7.fhir.r5.model.PaymentReconciliation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentReconciliation tgt = new PaymentReconciliation();
        PaymentReconciliation40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(PaymentReconciliation40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(PaymentReconciliation40_50.convertPaymentReconciliationStatus(src.getStatusElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(PaymentReconciliation40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(PaymentReconciliation40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasPaymentIssuer()) {
            tgt.setPaymentIssuer(PaymentReconciliation40_50.convertReference(src.getPaymentIssuer()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(PaymentReconciliation40_50.convertReference(src.getRequest()));
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(PaymentReconciliation40_50.convertReference(src.getRequestor()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(PaymentReconciliation40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(PaymentReconciliation40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasPaymentDate()) {
            tgt.setPaymentDateElement(PaymentReconciliation40_50.convertDate(src.getPaymentDateElement()));
        }
        if (src.hasPaymentAmount()) {
            tgt.setPaymentAmount(PaymentReconciliation40_50.convertMoney(src.getPaymentAmount()));
        }
        if (src.hasPaymentIdentifier()) {
            tgt.setPaymentIdentifier(PaymentReconciliation40_50.convertIdentifier(src.getPaymentIdentifier()));
        }
        for (PaymentReconciliation.DetailsComponent detailsComponent : src.getDetail()) {
            tgt.addDetail(PaymentReconciliation40_50.convertDetailsComponent(detailsComponent));
        }
        if (src.hasFormCode()) {
            tgt.setFormCode(PaymentReconciliation40_50.convertCodeableConcept(src.getFormCode()));
        }
        for (PaymentReconciliation.NotesComponent notesComponent : src.getProcessNote()) {
            tgt.addProcessNote(PaymentReconciliation40_50.convertNotesComponent(notesComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertPaymentReconciliationStatus(Enumeration<PaymentReconciliation.PaymentReconciliationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((PaymentReconciliation.PaymentReconciliationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<PaymentReconciliation.PaymentReconciliationStatus> convertPaymentReconciliationStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PaymentReconciliation.PaymentReconciliationStatus> tgt = new Enumeration<PaymentReconciliation.PaymentReconciliationStatus>(new PaymentReconciliation.PaymentReconciliationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)PaymentReconciliation.PaymentReconciliationStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)PaymentReconciliation.PaymentReconciliationStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)PaymentReconciliation.PaymentReconciliationStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)PaymentReconciliation.PaymentReconciliationStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)PaymentReconciliation.PaymentReconciliationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> convertRemittanceOutcome(Enumeration<Enumerations.RemittanceOutcome> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RemittanceOutcome)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.RemittanceOutcome> convertRemittanceOutcome(org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.RemittanceOutcome> tgt = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ClaimProcessingCodes)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.NULL);
            }
        }
        return tgt;
    }

    public static PaymentReconciliation.DetailsComponent convertDetailsComponent(PaymentReconciliation.DetailsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentReconciliation.DetailsComponent tgt = new PaymentReconciliation.DetailsComponent();
        PaymentReconciliation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(PaymentReconciliation40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasPredecessor()) {
            tgt.setPredecessor(PaymentReconciliation40_50.convertIdentifier(src.getPredecessor()));
        }
        if (src.hasType()) {
            tgt.setType(PaymentReconciliation40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(PaymentReconciliation40_50.convertReference(src.getRequest()));
        }
        if (src.hasSubmitter()) {
            tgt.setSubmitter(PaymentReconciliation40_50.convertReference(src.getSubmitter()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(PaymentReconciliation40_50.convertReference(src.getResponse()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(PaymentReconciliation40_50.convertDate(src.getDateElement()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(PaymentReconciliation40_50.convertReference(src.getResponsible()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(PaymentReconciliation40_50.convertReference(src.getPayee()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(PaymentReconciliation40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static PaymentReconciliation.DetailsComponent convertDetailsComponent(PaymentReconciliation.DetailsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentReconciliation.DetailsComponent tgt = new PaymentReconciliation.DetailsComponent();
        PaymentReconciliation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(PaymentReconciliation40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasPredecessor()) {
            tgt.setPredecessor(PaymentReconciliation40_50.convertIdentifier(src.getPredecessor()));
        }
        if (src.hasType()) {
            tgt.setType(PaymentReconciliation40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(PaymentReconciliation40_50.convertReference(src.getRequest()));
        }
        if (src.hasSubmitter()) {
            tgt.setSubmitter(PaymentReconciliation40_50.convertReference(src.getSubmitter()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(PaymentReconciliation40_50.convertReference(src.getResponse()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(PaymentReconciliation40_50.convertDate(src.getDateElement()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(PaymentReconciliation40_50.convertReference(src.getResponsible()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(PaymentReconciliation40_50.convertReference(src.getPayee()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(PaymentReconciliation40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static PaymentReconciliation.NotesComponent convertNotesComponent(PaymentReconciliation.NotesComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentReconciliation.NotesComponent tgt = new PaymentReconciliation.NotesComponent();
        PaymentReconciliation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertNoteType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(PaymentReconciliation40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static PaymentReconciliation.NotesComponent convertNotesComponent(PaymentReconciliation.NotesComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentReconciliation.NotesComponent tgt = new PaymentReconciliation.NotesComponent();
        PaymentReconciliation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertNoteType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(PaymentReconciliation40_50.convertString(src.getTextElement()));
        }
        return tgt;
    }
}

