/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Reference;

public class MedicinalProductDefinition40_50
extends VersionConvertor_40_50 {
    public static MedicinalProductDefinition convertMedicinalProduct(MedicinalProduct src) throws FHIRException {
        Element c;
        if (src == null) {
            return null;
        }
        MedicinalProductDefinition tgt = new MedicinalProductDefinition();
        MedicinalProductDefinition40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicinalProductDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setType(MedicinalProductDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasDomain()) {
            tgt.getDomain().addCoding(MedicinalProductDefinition40_50.convertCoding(src.getDomain()));
        }
        if (src.hasCombinedPharmaceuticalDoseForm()) {
            tgt.setCombinedPharmaceuticalDoseForm(MedicinalProductDefinition40_50.convertCodeableConcept(src.getCombinedPharmaceuticalDoseForm()));
        }
        if (src.hasLegalStatusOfSupply()) {
            tgt.setLegalStatusOfSupply(MedicinalProductDefinition40_50.convertCodeableConcept(src.getLegalStatusOfSupply()));
        }
        if (src.hasAdditionalMonitoringIndicator()) {
            tgt.setAdditionalMonitoringIndicator(MedicinalProductDefinition40_50.convertCodeableConcept(src.getAdditionalMonitoringIndicator()));
        }
        for (StringType stringType : src.getSpecialMeasures()) {
            c = new CodeableConcept();
            tgt.addSpecialMeasures((CodeableConcept)c);
            ((CodeableConcept)c).setTextElement(MedicinalProductDefinition40_50.convertString(stringType));
        }
        if (src.hasPaediatricUseIndicator()) {
            tgt.setPaediatricUseIndicator(MedicinalProductDefinition40_50.convertCodeableConcept(src.getPaediatricUseIndicator()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProductClassification()) {
            tgt.addProductClassification(MedicinalProductDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.MarketingStatus marketingStatus : src.getMarketingStatus()) {
            tgt.addMarketingStatus(MedicinalProductDefinition40_50.convertMarketingStatus(marketingStatus));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPharmaceuticalProduct()) {
            tgt.addPharmaceuticalProduct(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPackagedMedicinalProduct()) {
            tgt.addPackagedMedicinalProduct(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAttachedDocument()) {
            tgt.addAttachedDocument(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getMasterFile()) {
            tgt.addMasterFile(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getContact()) {
            c = new MedicinalProductDefinition.MedicinalProductDefinitionContactComponent();
            tgt.addContact((MedicinalProductDefinition.MedicinalProductDefinitionContactComponent)c);
            ((MedicinalProductDefinition.MedicinalProductDefinitionContactComponent)c).setContact(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getClinicalTrial()) {
            tgt.addClinicalTrial(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (MedicinalProduct.MedicinalProductNameComponent medicinalProductNameComponent : src.getName()) {
            MedicinalProductDefinition.MedicinalProductDefinitionNameComponent tgtName = new MedicinalProductDefinition.MedicinalProductDefinitionNameComponent();
            MedicinalProductDefinition40_50.copyElement(medicinalProductNameComponent, tgtName, new String[0]);
            tgt.addName(tgtName);
            tgtName.setProductNameElement(MedicinalProductDefinition40_50.convertString(medicinalProductNameComponent.getProductNameElement()));
            for (MedicinalProduct.MedicinalProductNameNamePartComponent srcPart : medicinalProductNameComponent.getNamePart()) {
                MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent tgtPart = new MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent();
                MedicinalProductDefinition40_50.copyElement(srcPart, tgtPart, new String[0]);
                tgtName.addNamePart(tgtPart);
                tgtPart.setPartElement(MedicinalProductDefinition40_50.convertString(srcPart.getPartElement()));
                tgtPart.getType().addCoding(MedicinalProductDefinition40_50.convertCoding(srcPart.getType()));
            }
            for (MedicinalProduct.MedicinalProductNameCountryLanguageComponent srcLang : medicinalProductNameComponent.getCountryLanguage()) {
                MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent tgtLang = new MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent();
                MedicinalProductDefinition40_50.copyElement(srcLang, tgtLang, new String[0]);
                tgtName.addCountryLanguage(tgtLang);
                tgtLang.setCountry(MedicinalProductDefinition40_50.convertCodeableConcept(srcLang.getCountry()));
                tgtLang.setLanguage(MedicinalProductDefinition40_50.convertCodeableConcept(srcLang.getLanguage()));
            }
        }
        for (Identifier identifier : src.getCrossReference()) {
            c = new MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent();
            tgt.addCrossReference((MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent)c);
            ((MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent)c).setProduct(MedicinalProductDefinition40_50.convertIdentifier(identifier));
        }
        for (MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent medicinalProductManufacturingBusinessOperationComponent : src.getManufacturingBusinessOperation()) {
            MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent tgtMBO = new MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent();
            MedicinalProductDefinition40_50.copyElement(medicinalProductManufacturingBusinessOperationComponent, tgtMBO, new String[0]);
            tgt.addManufacturingBusinessOperation(tgtMBO);
            if (medicinalProductManufacturingBusinessOperationComponent.hasOperationType()) {
                tgtMBO.getType().setConcept(MedicinalProductDefinition40_50.convertCodeableConcept(medicinalProductManufacturingBusinessOperationComponent.getOperationType()));
            }
            if (medicinalProductManufacturingBusinessOperationComponent.hasAuthorisationReferenceNumber()) {
                throw new FHIRException("Converting MedicinalProduct.ManufacturingBusinessOperation.authorizationReferenceNumber is not supported");
            }
            if (medicinalProductManufacturingBusinessOperationComponent.hasEffectiveDate()) {
                Period p = new Period();
                tgtMBO.setEffectiveDate(p);
                p.setStartElement(MedicinalProductDefinition40_50.convertDateTime(medicinalProductManufacturingBusinessOperationComponent.getEffectiveDateElement()));
                p.setEndElement(MedicinalProductDefinition40_50.convertDateTime(medicinalProductManufacturingBusinessOperationComponent.getEffectiveDateElement()));
            }
            if (medicinalProductManufacturingBusinessOperationComponent.hasConfidentialityIndicator()) {
                tgtMBO.setConfidentialityIndicator(MedicinalProductDefinition40_50.convertCodeableConcept(medicinalProductManufacturingBusinessOperationComponent.getConfidentialityIndicator()));
            }
            for (org.hl7.fhir.r4.model.Reference t : medicinalProductManufacturingBusinessOperationComponent.getManufacturer()) {
                tgtMBO.addManufacturer(MedicinalProductDefinition40_50.convertReference(t));
            }
            if (!medicinalProductManufacturingBusinessOperationComponent.hasRegulator()) continue;
            throw new FHIRException("Converting MedicinalProduct.ManufacturingBusinessOperation.regulator is not supported");
        }
        if (src.hasSpecialDesignation()) {
            throw new FHIRException("Converting MedicinalProduct.specialDesignation is not supported");
        }
        return tgt;
    }

    public static MedicinalProduct convertMedicinalProductDefinition(MedicinalProductDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicinalProduct tgt = new MedicinalProduct();
        MedicinalProductDefinition40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicinalProductDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setType(MedicinalProductDefinition40_50.convertCodeableConcept(src.getType()));
        }
        if (src.getDomain().hasCoding()) {
            tgt.setDomain(MedicinalProductDefinition40_50.convertCoding(src.getDomain().getCodingFirstRep()));
        }
        if (src.hasVersion()) {
            throw new FHIRException("Converting MedicinalProductDefinition.version is not supported");
        }
        if (src.hasStatus()) {
            throw new FHIRException("Converting MedicinalProductDefinition.status is not supported");
        }
        if (src.hasDescription()) {
            throw new FHIRException("Converting MedicinalProductDefinition.description is not supported");
        }
        if (src.hasCombinedPharmaceuticalDoseForm()) {
            tgt.setCombinedPharmaceuticalDoseForm(MedicinalProductDefinition40_50.convertCodeableConcept(src.getCombinedPharmaceuticalDoseForm()));
        }
        if (src.hasIndication()) {
            throw new FHIRException("Converting MedicinalProductDefinition.indication is not supported");
        }
        if (src.hasLegalStatusOfSupply()) {
            tgt.setLegalStatusOfSupply(MedicinalProductDefinition40_50.convertCodeableConcept(src.getLegalStatusOfSupply()));
        }
        if (src.hasAdditionalMonitoringIndicator()) {
            tgt.setAdditionalMonitoringIndicator(MedicinalProductDefinition40_50.convertCodeableConcept(src.getAdditionalMonitoringIndicator()));
        }
        for (CodeableConcept codeableConcept : src.getSpecialMeasures()) {
            if (codeableConcept.hasText()) {
                StringType s2 = tgt.addSpecialMeasuresElement();
                MedicinalProductDefinition40_50.copyElement(codeableConcept.getTextElement(), s2, new String[0]);
                s2.setValue(codeableConcept.getText());
            }
            MedicinalProductDefinition40_50.checkBase(codeableConcept, "MedicinalProductDefinition.specialMeasures");
            if (!codeableConcept.hasCoding()) continue;
            throw new FHIRException("Converting MedicinalProductDefinition.specialMeasures.coding is not supported");
        }
        if (src.hasPaediatricUseIndicator()) {
            tgt.setPaediatricUseIndicator(MedicinalProductDefinition40_50.convertCodeableConcept(src.getPaediatricUseIndicator()));
        }
        for (CodeableConcept codeableConcept : src.getProductClassification()) {
            tgt.addProductClassification(MedicinalProductDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        for (MarketingStatus marketingStatus : src.getMarketingStatus()) {
            tgt.addMarketingStatus(MedicinalProductDefinition40_50.convertMarketingStatus(marketingStatus));
        }
        for (Reference reference : src.getPharmaceuticalProduct()) {
            tgt.addPharmaceuticalProduct(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (Reference reference : src.getPackagedMedicinalProduct()) {
            tgt.addPackagedMedicinalProduct(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (Reference reference : src.getAttachedDocument()) {
            tgt.addAttachedDocument(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (Reference reference : src.getMasterFile()) {
            tgt.addMasterFile(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (MedicinalProductDefinition.MedicinalProductDefinitionContactComponent medicinalProductDefinitionContactComponent : src.getContact()) {
            if (medicinalProductDefinitionContactComponent.hasContact()) {
                tgt.addContact(MedicinalProductDefinition40_50.convertReference(medicinalProductDefinitionContactComponent.getContact()));
            }
            MedicinalProductDefinition40_50.checkBase(medicinalProductDefinitionContactComponent, "MedicinalProductDefinition.contact");
            if (!medicinalProductDefinitionContactComponent.hasType()) continue;
            throw new FHIRException("Converting MedicinalProductDefinition.contact.type is not supported");
        }
        for (Reference reference : src.getClinicalTrial()) {
            tgt.addClinicalTrial(MedicinalProductDefinition40_50.convertReference(reference));
        }
        for (MedicinalProductDefinition.MedicinalProductDefinitionNameComponent medicinalProductDefinitionNameComponent : src.getName()) {
            MedicinalProduct.MedicinalProductNameComponent tgtName = new MedicinalProduct.MedicinalProductNameComponent();
            MedicinalProductDefinition40_50.copyElement(medicinalProductDefinitionNameComponent, tgtName, new String[0]);
            tgt.addName(tgtName);
            tgtName.setProductNameElement(MedicinalProductDefinition40_50.convertString(medicinalProductDefinitionNameComponent.getProductNameElement()));
            for (MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent srcPart : medicinalProductDefinitionNameComponent.getNamePart()) {
                MedicinalProduct.MedicinalProductNameNamePartComponent tgtPart = new MedicinalProduct.MedicinalProductNameNamePartComponent();
                MedicinalProductDefinition40_50.copyElement(srcPart, tgtPart, new String[0]);
                tgtName.addNamePart(tgtPart);
                tgtPart.setPartElement(MedicinalProductDefinition40_50.convertString(srcPart.getPartElement()));
                if (!srcPart.getType().hasCoding()) continue;
                tgtPart.setType(MedicinalProductDefinition40_50.convertCoding(srcPart.getType().getCodingFirstRep()));
            }
            for (MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent srcLang : medicinalProductDefinitionNameComponent.getCountryLanguage()) {
                MedicinalProduct.MedicinalProductNameCountryLanguageComponent tgtLang = new MedicinalProduct.MedicinalProductNameCountryLanguageComponent();
                MedicinalProductDefinition40_50.copyElement(srcLang, tgtLang, new String[0]);
                tgtName.addCountryLanguage(tgtLang);
                tgtLang.setCountry(MedicinalProductDefinition40_50.convertCodeableConcept(srcLang.getCountry()));
                tgtLang.setLanguage(MedicinalProductDefinition40_50.convertCodeableConcept(srcLang.getLanguage()));
            }
        }
        for (MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent medicinalProductDefinitionCrossReferenceComponent : src.getCrossReference()) {
            if (medicinalProductDefinitionCrossReferenceComponent.hasProduct()) {
                if (medicinalProductDefinitionCrossReferenceComponent.getProduct() instanceof org.hl7.fhir.r5.model.Identifier) {
                    tgt.addCrossReference(MedicinalProductDefinition40_50.convertIdentifier((org.hl7.fhir.r5.model.Identifier)medicinalProductDefinitionCrossReferenceComponent.getProduct()));
                } else {
                    throw new FHIRException("Converting MedicinalProductDefinition.crossReference.productReference is not supported");
                }
            }
            MedicinalProductDefinition40_50.checkBase(medicinalProductDefinitionCrossReferenceComponent, "MedicinalProductDefinition.crossReference");
            if (!medicinalProductDefinitionCrossReferenceComponent.hasType()) continue;
            throw new FHIRException("Converting MedicinalProductDefinition.crossReference.type is not supported");
        }
        for (MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent medicinalProductDefinitionManufacturingBusinessOperationComponent : src.getManufacturingBusinessOperation()) {
            MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent tgtMBO = new MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent();
            MedicinalProductDefinition40_50.copyElement(medicinalProductDefinitionManufacturingBusinessOperationComponent, tgtMBO, new String[0]);
            tgt.addManufacturingBusinessOperation(tgtMBO);
            if (medicinalProductDefinitionManufacturingBusinessOperationComponent.hasType()) {
                if (medicinalProductDefinitionManufacturingBusinessOperationComponent.getType().hasConcept()) {
                    tgtMBO.setOperationType(MedicinalProductDefinition40_50.convertCodeableConcept(medicinalProductDefinitionManufacturingBusinessOperationComponent.getType().getConcept()));
                } else {
                    throw new FHIRException("Converting MedicinalProductDefinition.manufacturingBusinessOperation.typeReference is not supported");
                }
            }
            if (medicinalProductDefinitionManufacturingBusinessOperationComponent.hasEffectiveDate()) {
                Period d = medicinalProductDefinitionManufacturingBusinessOperationComponent.getEffectiveDate();
                MedicinalProductDefinition40_50.checkBase(medicinalProductDefinitionManufacturingBusinessOperationComponent, "MedicinalProductDefinition.manufacturingBusinessOperation.effectiveDate");
                if (d.hasStart() || d.hasEnd()) {
                    if (d.hasStart() != d.hasEnd() || !d.getStart().equals(d.getEnd())) {
                        throw new FHIRException("Converting MedicinalProductDefinition.manufacturingBusinessOperation.effectiveDate is not supported when start is not identical to end");
                    }
                    tgtMBO.setEffectiveDateElement(MedicinalProductDefinition40_50.convertDateTime(d.getStartElement()));
                }
            }
            if (medicinalProductDefinitionManufacturingBusinessOperationComponent.hasAuthorization()) {
                throw new FHIRException("Converting MedicinalProductDefinition.manufacturingBusinessOperation.authorization is not supported");
            }
            if (medicinalProductDefinitionManufacturingBusinessOperationComponent.hasConfidentialityIndicator()) {
                tgtMBO.setConfidentialityIndicator(MedicinalProductDefinition40_50.convertCodeableConcept(medicinalProductDefinitionManufacturingBusinessOperationComponent.getConfidentialityIndicator()));
            }
            for (Reference t : medicinalProductDefinitionManufacturingBusinessOperationComponent.getManufacturer()) {
                tgtMBO.addManufacturer(MedicinalProductDefinition40_50.convertReference(t));
            }
        }
        return tgt;
    }

    public static void checkBase(Element e, String path) throws FHIRException {
        if (e.hasId()) {
            throw new FHIRException("Converting " + path + ".id is not supported");
        }
        if (e.hasExtension()) {
            throw new FHIRException("Converting " + path + ".extension is not supported");
        }
    }

    public static org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> convertMedicationStatementStatus(Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes>(new MedicationUsage.MedicationUsageStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.ONHOLD);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            case NOTTAKEN: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.NOTTAKEN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationUsage.MedicationUsageStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ONHOLD);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.UNKNOWN);
                break;
            }
            case NOTTAKEN: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NOTTAKEN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }
}

