/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;

public class Location40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Location convertLocation(Location src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Location tgt = new org.hl7.fhir.r5.model.Location();
        Location40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Location40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Location40_50.convertLocationStatus(src.getStatusElement()));
        }
        if (src.hasOperationalStatus()) {
            tgt.setOperationalStatus(Location40_50.convertCoding(src.getOperationalStatus()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Location40_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getAlias()) {
            tgt.getAlias().add(Location40_50.convertString(stringType));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Location40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Location40_50.convertLocationMode(src.getModeElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Location40_50.convertCodeableConcept(codeableConcept));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Location40_50.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(Location40_50.convertAddress(src.getAddress()));
        }
        if (src.hasPhysicalType()) {
            tgt.setPhysicalType(Location40_50.convertCodeableConcept(src.getPhysicalType()));
        }
        if (src.hasPosition()) {
            tgt.setPosition(Location40_50.convertLocationPositionComponent(src.getPosition()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(Location40_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(Location40_50.convertReference(src.getPartOf()));
        }
        for (Location.LocationHoursOfOperationComponent locationHoursOfOperationComponent : src.getHoursOfOperation()) {
            tgt.addHoursOfOperation(Location40_50.convertLocationHoursOfOperationComponent(locationHoursOfOperationComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(Location40_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(Location40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Location convertLocation(org.hl7.fhir.r5.model.Location src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location tgt = new Location();
        Location40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Location40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Location40_50.convertLocationStatus(src.getStatusElement()));
        }
        if (src.hasOperationalStatus()) {
            tgt.setOperationalStatus(Location40_50.convertCoding(src.getOperationalStatus()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Location40_50.convertString(src.getNameElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.getAlias().add(Location40_50.convertString(stringType));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(Location40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasMode()) {
            tgt.setModeElement(Location40_50.convertLocationMode(src.getModeElement()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Location40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(Location40_50.convertContactPoint(contactPoint));
        }
        if (src.hasAddress()) {
            tgt.setAddress(Location40_50.convertAddress(src.getAddress()));
        }
        if (src.hasPhysicalType()) {
            tgt.setPhysicalType(Location40_50.convertCodeableConcept(src.getPhysicalType()));
        }
        if (src.hasPosition()) {
            tgt.setPosition(Location40_50.convertLocationPositionComponent(src.getPosition()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(Location40_50.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(Location40_50.convertReference(src.getPartOf()));
        }
        for (Location.LocationHoursOfOperationComponent locationHoursOfOperationComponent : src.getHoursOfOperation()) {
            tgt.addHoursOfOperation(Location40_50.convertLocationHoursOfOperationComponent(locationHoursOfOperationComponent));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptionsElement(Location40_50.convertString(src.getAvailabilityExceptionsElement()));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(Location40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Location.LocationStatus> convertLocationStatus(Enumeration<Location.LocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Location.LocationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Location.LocationStatus>(new Location.LocationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Location.LocationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Location.LocationStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.INACTIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Location.LocationStatus> convertLocationStatus(org.hl7.fhir.r5.model.Enumeration<Location.LocationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Location.LocationStatus> tgt = new Enumeration<Location.LocationStatus>(new Location.LocationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Location.LocationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Location.LocationStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Location.LocationStatus.INACTIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Location.LocationMode> convertLocationMode(Enumeration<Location.LocationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Location.LocationMode> tgt = new org.hl7.fhir.r5.model.Enumeration<Location.LocationMode>(new Location.LocationModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Location.LocationMode)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Location.LocationMode.INSTANCE);
                break;
            }
            case KIND: {
                tgt.setValue((Object)Location.LocationMode.KIND);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Location.LocationMode> convertLocationMode(org.hl7.fhir.r5.model.Enumeration<Location.LocationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Location.LocationMode> tgt = new Enumeration<Location.LocationMode>(new Location.LocationModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Location.LocationMode)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Location.LocationMode.INSTANCE);
                break;
            }
            case KIND: {
                tgt.setValue((Object)Location.LocationMode.KIND);
                break;
            }
            default: {
                tgt.setValue((Object)Location.LocationMode.NULL);
            }
        }
        return tgt;
    }

    public static Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        Location40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLongitude()) {
            tgt.setLongitudeElement(Location40_50.convertDecimal(src.getLongitudeElement()));
        }
        if (src.hasLatitude()) {
            tgt.setLatitudeElement(Location40_50.convertDecimal(src.getLatitudeElement()));
        }
        if (src.hasAltitude()) {
            tgt.setAltitudeElement(Location40_50.convertDecimal(src.getAltitudeElement()));
        }
        return tgt;
    }

    public static Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        Location40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLongitude()) {
            tgt.setLongitudeElement(Location40_50.convertDecimal(src.getLongitudeElement()));
        }
        if (src.hasLatitude()) {
            tgt.setLatitudeElement(Location40_50.convertDecimal(src.getLatitudeElement()));
        }
        if (src.hasAltitude()) {
            tgt.setAltitudeElement(Location40_50.convertDecimal(src.getAltitudeElement()));
        }
        return tgt;
    }

    public static Location.LocationHoursOfOperationComponent convertLocationHoursOfOperationComponent(Location.LocationHoursOfOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location.LocationHoursOfOperationComponent tgt = new Location.LocationHoursOfOperationComponent();
        Location40_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(Location40_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(Location40_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasOpeningTime()) {
            tgt.setOpeningTimeElement(Location40_50.convertTime(src.getOpeningTimeElement()));
        }
        if (src.hasClosingTime()) {
            tgt.setClosingTimeElement(Location40_50.convertTime(src.getClosingTimeElement()));
        }
        return tgt;
    }

    public static Location.LocationHoursOfOperationComponent convertLocationHoursOfOperationComponent(Location.LocationHoursOfOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location.LocationHoursOfOperationComponent tgt = new Location.LocationHoursOfOperationComponent();
        Location40_50.copyElement(src, tgt, new String[0]);
        tgt.setDaysOfWeek(src.getDaysOfWeek().stream().map(Location40_50::convertDaysOfWeek).collect(Collectors.toList()));
        if (src.hasAllDay()) {
            tgt.setAllDayElement(Location40_50.convertBoolean(src.getAllDayElement()));
        }
        if (src.hasOpeningTime()) {
            tgt.setOpeningTimeElement(Location40_50.convertTime(src.getOpeningTimeElement()));
        }
        if (src.hasClosingTime()) {
            tgt.setClosingTimeElement(Location40_50.convertTime(src.getClosingTimeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> convertDaysOfWeek(Enumeration<Location.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Location.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Location.DaysOfWeek> convertDaysOfWeek(org.hl7.fhir.r5.model.Enumeration<Enumerations.DaysOfWeek> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Location.DaysOfWeek> tgt = new Enumeration<Location.DaysOfWeek>(new Location.DaysOfWeekEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DaysOfWeek)((Object)src.getValue())) {
            case MON: {
                tgt.setValue((Object)Location.DaysOfWeek.MON);
                break;
            }
            case TUE: {
                tgt.setValue((Object)Location.DaysOfWeek.TUE);
                break;
            }
            case WED: {
                tgt.setValue((Object)Location.DaysOfWeek.WED);
                break;
            }
            case THU: {
                tgt.setValue((Object)Location.DaysOfWeek.THU);
                break;
            }
            case FRI: {
                tgt.setValue((Object)Location.DaysOfWeek.FRI);
                break;
            }
            case SAT: {
                tgt.setValue((Object)Location.DaysOfWeek.SAT);
                break;
            }
            case SUN: {
                tgt.setValue((Object)Location.DaysOfWeek.SUN);
                break;
            }
            default: {
                tgt.setValue((Object)Location.DaysOfWeek.NULL);
            }
        }
        return tgt;
    }
}

