/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InsurancePlan;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;

public class InsurancePlan40_50
extends VersionConvertor_40_50 {
    public static InsurancePlan convertInsurancePlan(org.hl7.fhir.r4.model.InsurancePlan src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan tgt = new InsurancePlan();
        InsurancePlan40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(InsurancePlan40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(InsurancePlan40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(InsurancePlan40_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getAlias()) {
            tgt.getAlias().add(InsurancePlan40_50.convertString(stringType));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(InsurancePlan40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasOwnedBy()) {
            tgt.setOwnedBy(InsurancePlan40_50.convertReference(src.getOwnedBy()));
        }
        if (src.hasAdministeredBy()) {
            tgt.setAdministeredBy(InsurancePlan40_50.convertReference(src.getAdministeredBy()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.InsurancePlanContactComponent insurancePlanContactComponent : src.getContact()) {
            tgt.addContact(InsurancePlan40_50.convertInsurancePlanContactComponent(insurancePlanContactComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(InsurancePlan40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getNetwork()) {
            tgt.addNetwork(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.InsurancePlanCoverageComponent insurancePlanCoverageComponent : src.getCoverage()) {
            tgt.addCoverage(InsurancePlan40_50.convertInsurancePlanCoverageComponent(insurancePlanCoverageComponent));
        }
        for (InsurancePlan.InsurancePlanPlanComponent insurancePlanPlanComponent : src.getPlan()) {
            tgt.addPlan(InsurancePlan40_50.convertInsurancePlanPlanComponent(insurancePlanPlanComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.InsurancePlan convertInsurancePlan(InsurancePlan src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.InsurancePlan tgt = new org.hl7.fhir.r4.model.InsurancePlan();
        InsurancePlan40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(InsurancePlan40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(InsurancePlan40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(InsurancePlan40_50.convertString(src.getNameElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.getAlias().add(InsurancePlan40_50.convertString(stringType));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(InsurancePlan40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasOwnedBy()) {
            tgt.setOwnedBy(InsurancePlan40_50.convertReference(src.getOwnedBy()));
        }
        if (src.hasAdministeredBy()) {
            tgt.setAdministeredBy(InsurancePlan40_50.convertReference(src.getAdministeredBy()));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.InsurancePlanContactComponent insurancePlanContactComponent : src.getContact()) {
            tgt.addContact(InsurancePlan40_50.convertInsurancePlanContactComponent(insurancePlanContactComponent));
        }
        for (Reference reference : src.getEndpoint()) {
            tgt.addEndpoint(InsurancePlan40_50.convertReference(reference));
        }
        for (Reference reference : src.getNetwork()) {
            tgt.addNetwork(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.InsurancePlanCoverageComponent insurancePlanCoverageComponent : src.getCoverage()) {
            tgt.addCoverage(InsurancePlan40_50.convertInsurancePlanCoverageComponent(insurancePlanCoverageComponent));
        }
        for (InsurancePlan.InsurancePlanPlanComponent insurancePlanPlanComponent : src.getPlan()) {
            tgt.addPlan(InsurancePlan40_50.convertInsurancePlanPlanComponent(insurancePlanPlanComponent));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanContactComponent convertInsurancePlanContactComponent(InsurancePlan.InsurancePlanContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanContactComponent tgt = new InsurancePlan.InsurancePlanContactComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(InsurancePlan40_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(InsurancePlan40_50.convertHumanName(src.getName()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(InsurancePlan40_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(InsurancePlan40_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanContactComponent convertInsurancePlanContactComponent(InsurancePlan.InsurancePlanContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanContactComponent tgt = new InsurancePlan.InsurancePlanContactComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasPurpose()) {
            tgt.setPurpose(InsurancePlan40_50.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(InsurancePlan40_50.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(InsurancePlan40_50.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(InsurancePlan40_50.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanCoverageComponent convertInsurancePlanCoverageComponent(InsurancePlan.InsurancePlanCoverageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanCoverageComponent tgt = new InsurancePlan.InsurancePlanCoverageComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getNetwork()) {
            tgt.addNetwork(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.CoverageBenefitComponent coverageBenefitComponent : src.getBenefit()) {
            tgt.addBenefit(InsurancePlan40_50.convertCoverageBenefitComponent(coverageBenefitComponent));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanCoverageComponent convertInsurancePlanCoverageComponent(InsurancePlan.InsurancePlanCoverageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanCoverageComponent tgt = new InsurancePlan.InsurancePlanCoverageComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        for (Reference reference : src.getNetwork()) {
            tgt.addNetwork(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.CoverageBenefitComponent coverageBenefitComponent : src.getBenefit()) {
            tgt.addBenefit(InsurancePlan40_50.convertCoverageBenefitComponent(coverageBenefitComponent));
        }
        return tgt;
    }

    public static InsurancePlan.CoverageBenefitComponent convertCoverageBenefitComponent(InsurancePlan.CoverageBenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.CoverageBenefitComponent tgt = new InsurancePlan.CoverageBenefitComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasRequirement()) {
            tgt.setRequirementElement(InsurancePlan40_50.convertString(src.getRequirementElement()));
        }
        for (InsurancePlan.CoverageBenefitLimitComponent t : src.getLimit()) {
            tgt.addLimit(InsurancePlan40_50.convertCoverageBenefitLimitComponent(t));
        }
        return tgt;
    }

    public static InsurancePlan.CoverageBenefitComponent convertCoverageBenefitComponent(InsurancePlan.CoverageBenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.CoverageBenefitComponent tgt = new InsurancePlan.CoverageBenefitComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasRequirement()) {
            tgt.setRequirementElement(InsurancePlan40_50.convertString(src.getRequirementElement()));
        }
        for (InsurancePlan.CoverageBenefitLimitComponent t : src.getLimit()) {
            tgt.addLimit(InsurancePlan40_50.convertCoverageBenefitLimitComponent(t));
        }
        return tgt;
    }

    public static InsurancePlan.CoverageBenefitLimitComponent convertCoverageBenefitLimitComponent(InsurancePlan.CoverageBenefitLimitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.CoverageBenefitLimitComponent tgt = new InsurancePlan.CoverageBenefitLimitComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(InsurancePlan40_50.convertQuantity(src.getValue()));
        }
        if (src.hasCode()) {
            tgt.setCode(InsurancePlan40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static InsurancePlan.CoverageBenefitLimitComponent convertCoverageBenefitLimitComponent(InsurancePlan.CoverageBenefitLimitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.CoverageBenefitLimitComponent tgt = new InsurancePlan.CoverageBenefitLimitComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasValue()) {
            tgt.setValue(InsurancePlan40_50.convertQuantity(src.getValue()));
        }
        if (src.hasCode()) {
            tgt.setCode(InsurancePlan40_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanPlanComponent convertInsurancePlanPlanComponent(InsurancePlan.InsurancePlanPlanComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanPlanComponent tgt = new InsurancePlan.InsurancePlanPlanComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(InsurancePlan40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(InsurancePlan40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getNetwork()) {
            tgt.addNetwork(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.InsurancePlanPlanGeneralCostComponent insurancePlanPlanGeneralCostComponent : src.getGeneralCost()) {
            tgt.addGeneralCost(InsurancePlan40_50.convertInsurancePlanPlanGeneralCostComponent(insurancePlanPlanGeneralCostComponent));
        }
        for (InsurancePlan.InsurancePlanPlanSpecificCostComponent insurancePlanPlanSpecificCostComponent : src.getSpecificCost()) {
            tgt.addSpecificCost(InsurancePlan40_50.convertInsurancePlanPlanSpecificCostComponent(insurancePlanPlanSpecificCostComponent));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanPlanComponent convertInsurancePlanPlanComponent(InsurancePlan.InsurancePlanPlanComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanPlanComponent tgt = new InsurancePlan.InsurancePlanPlanComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(InsurancePlan40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        for (Reference reference : src.getCoverageArea()) {
            tgt.addCoverageArea(InsurancePlan40_50.convertReference(reference));
        }
        for (Reference reference : src.getNetwork()) {
            tgt.addNetwork(InsurancePlan40_50.convertReference(reference));
        }
        for (InsurancePlan.InsurancePlanPlanGeneralCostComponent insurancePlanPlanGeneralCostComponent : src.getGeneralCost()) {
            tgt.addGeneralCost(InsurancePlan40_50.convertInsurancePlanPlanGeneralCostComponent(insurancePlanPlanGeneralCostComponent));
        }
        for (InsurancePlan.InsurancePlanPlanSpecificCostComponent insurancePlanPlanSpecificCostComponent : src.getSpecificCost()) {
            tgt.addSpecificCost(InsurancePlan40_50.convertInsurancePlanPlanSpecificCostComponent(insurancePlanPlanSpecificCostComponent));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanPlanGeneralCostComponent convertInsurancePlanPlanGeneralCostComponent(InsurancePlan.InsurancePlanPlanGeneralCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanPlanGeneralCostComponent tgt = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasGroupSize()) {
            tgt.setGroupSizeElement(InsurancePlan40_50.convertPositiveInt(src.getGroupSizeElement()));
        }
        if (src.hasCost()) {
            tgt.setCost(InsurancePlan40_50.convertMoney(src.getCost()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(InsurancePlan40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanPlanGeneralCostComponent convertInsurancePlanPlanGeneralCostComponent(InsurancePlan.InsurancePlanPlanGeneralCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanPlanGeneralCostComponent tgt = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasGroupSize()) {
            tgt.setGroupSizeElement(InsurancePlan40_50.convertPositiveInt(src.getGroupSizeElement()));
        }
        if (src.hasCost()) {
            tgt.setCost(InsurancePlan40_50.convertMoney(src.getCost()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(InsurancePlan40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanPlanSpecificCostComponent convertInsurancePlanPlanSpecificCostComponent(InsurancePlan.InsurancePlanPlanSpecificCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanPlanSpecificCostComponent tgt = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(InsurancePlan40_50.convertCodeableConcept(src.getCategory()));
        }
        for (InsurancePlan.PlanBenefitComponent t : src.getBenefit()) {
            tgt.addBenefit(InsurancePlan40_50.convertPlanBenefitComponent(t));
        }
        return tgt;
    }

    public static InsurancePlan.InsurancePlanPlanSpecificCostComponent convertInsurancePlanPlanSpecificCostComponent(InsurancePlan.InsurancePlanPlanSpecificCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.InsurancePlanPlanSpecificCostComponent tgt = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(InsurancePlan40_50.convertCodeableConcept(src.getCategory()));
        }
        for (InsurancePlan.PlanBenefitComponent t : src.getBenefit()) {
            tgt.addBenefit(InsurancePlan40_50.convertPlanBenefitComponent(t));
        }
        return tgt;
    }

    public static InsurancePlan.PlanBenefitComponent convertPlanBenefitComponent(InsurancePlan.PlanBenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.PlanBenefitComponent tgt = new InsurancePlan.PlanBenefitComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        for (InsurancePlan.PlanBenefitCostComponent t : src.getCost()) {
            tgt.addCost(InsurancePlan40_50.convertPlanBenefitCostComponent(t));
        }
        return tgt;
    }

    public static InsurancePlan.PlanBenefitComponent convertPlanBenefitComponent(InsurancePlan.PlanBenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.PlanBenefitComponent tgt = new InsurancePlan.PlanBenefitComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        for (InsurancePlan.PlanBenefitCostComponent t : src.getCost()) {
            tgt.addCost(InsurancePlan40_50.convertPlanBenefitCostComponent(t));
        }
        return tgt;
    }

    public static InsurancePlan.PlanBenefitCostComponent convertPlanBenefitCostComponent(InsurancePlan.PlanBenefitCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.PlanBenefitCostComponent tgt = new InsurancePlan.PlanBenefitCostComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasApplicability()) {
            tgt.setApplicability(InsurancePlan40_50.convertCodeableConcept(src.getApplicability()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getQualifiers()) {
            tgt.addQualifiers(InsurancePlan40_50.convertCodeableConcept(t));
        }
        if (src.hasValue()) {
            tgt.setValue(InsurancePlan40_50.convertQuantity(src.getValue()));
        }
        return tgt;
    }

    public static InsurancePlan.PlanBenefitCostComponent convertPlanBenefitCostComponent(InsurancePlan.PlanBenefitCostComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        InsurancePlan.PlanBenefitCostComponent tgt = new InsurancePlan.PlanBenefitCostComponent();
        InsurancePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(InsurancePlan40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasApplicability()) {
            tgt.setApplicability(InsurancePlan40_50.convertCodeableConcept(src.getApplicability()));
        }
        for (CodeableConcept t : src.getQualifiers()) {
            tgt.addQualifiers(InsurancePlan40_50.convertCodeableConcept(t));
        }
        if (src.hasValue()) {
            tgt.setValue(InsurancePlan40_50.convertQuantity(src.getValue()));
        }
        return tgt;
    }
}

