/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImmunizationRecommendation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;

public class ImmunizationRecommendation40_50
extends VersionConvertor_40_50 {
    public static ImmunizationRecommendation convertImmunizationRecommendation(org.hl7.fhir.r4.model.ImmunizationRecommendation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImmunizationRecommendation tgt = new ImmunizationRecommendation();
        ImmunizationRecommendation40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ImmunizationRecommendation40_50.convertIdentifier(identifier));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ImmunizationRecommendation40_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ImmunizationRecommendation40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthority()) {
            tgt.setAuthority(ImmunizationRecommendation40_50.convertReference(src.getAuthority()));
        }
        for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : src.getRecommendation()) {
            tgt.addRecommendation(ImmunizationRecommendation40_50.convertImmunizationRecommendationRecommendationComponent(immunizationRecommendationRecommendationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ImmunizationRecommendation convertImmunizationRecommendation(ImmunizationRecommendation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ImmunizationRecommendation tgt = new org.hl7.fhir.r4.model.ImmunizationRecommendation();
        ImmunizationRecommendation40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ImmunizationRecommendation40_50.convertIdentifier(identifier));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ImmunizationRecommendation40_50.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ImmunizationRecommendation40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthority()) {
            tgt.setAuthority(ImmunizationRecommendation40_50.convertReference(src.getAuthority()));
        }
        for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent immunizationRecommendationRecommendationComponent : src.getRecommendation()) {
            tgt.addRecommendation(ImmunizationRecommendation40_50.convertImmunizationRecommendationRecommendationComponent(immunizationRecommendationRecommendationComponent));
        }
        return tgt;
    }

    public static ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent convertImmunizationRecommendationRecommendationComponent(ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent tgt = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        ImmunizationRecommendation40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getVaccineCode()) {
            tgt.addVaccineCode(ImmunizationRecommendation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTargetDisease()) {
            tgt.addTargetDisease(ImmunizationRecommendation40_50.convertCodeableConcept(src.getTargetDisease()));
        }
        for (CodeableConcept codeableConcept : src.getContraindicatedVaccineCode()) {
            tgt.addContraindicatedVaccineCode(ImmunizationRecommendation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasForecastStatus()) {
            tgt.setForecastStatus(ImmunizationRecommendation40_50.convertCodeableConcept(src.getForecastStatus()));
        }
        for (CodeableConcept codeableConcept : src.getForecastReason()) {
            tgt.addForecastReason(ImmunizationRecommendation40_50.convertCodeableConcept(codeableConcept));
        }
        for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent : src.getDateCriterion()) {
            tgt.addDateCriterion(ImmunizationRecommendation40_50.convertImmunizationRecommendationRecommendationDateCriterionComponent(immunizationRecommendationRecommendationDateCriterionComponent));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImmunizationRecommendation40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSeries()) {
            tgt.setSeriesElement(ImmunizationRecommendation40_50.convertString(src.getSeriesElement()));
        }
        if (src.hasDoseNumber()) {
            tgt.setDoseNumber(src.getDoseNumber().primitiveValue());
        }
        if (src.hasSeriesDoses()) {
            tgt.setSeriesDoses(src.getSeriesDoses().primitiveValue());
        }
        for (Reference reference : src.getSupportingImmunization()) {
            tgt.addSupportingImmunization(ImmunizationRecommendation40_50.convertReference(reference));
        }
        for (Reference reference : src.getSupportingPatientInformation()) {
            tgt.addSupportingPatientInformation(ImmunizationRecommendation40_50.convertReference(reference));
        }
        return tgt;
    }

    public static ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent convertImmunizationRecommendationRecommendationComponent(ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent tgt = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        ImmunizationRecommendation40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getVaccineCode()) {
            tgt.addVaccineCode(ImmunizationRecommendation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTargetDisease()) {
            tgt.setTargetDisease(ImmunizationRecommendation40_50.convertCodeableConcept(src.getTargetDiseaseFirstRep()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getContraindicatedVaccineCode()) {
            tgt.addContraindicatedVaccineCode(ImmunizationRecommendation40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasForecastStatus()) {
            tgt.setForecastStatus(ImmunizationRecommendation40_50.convertCodeableConcept(src.getForecastStatus()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getForecastReason()) {
            tgt.addForecastReason(ImmunizationRecommendation40_50.convertCodeableConcept(codeableConcept));
        }
        for (ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent immunizationRecommendationRecommendationDateCriterionComponent : src.getDateCriterion()) {
            tgt.addDateCriterion(ImmunizationRecommendation40_50.convertImmunizationRecommendationRecommendationDateCriterionComponent(immunizationRecommendationRecommendationDateCriterionComponent));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ImmunizationRecommendation40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSeries()) {
            tgt.setSeriesElement(ImmunizationRecommendation40_50.convertString(src.getSeriesElement()));
        }
        if (src.hasDoseNumber()) {
            tgt.setDoseNumber(ImmunizationRecommendation40_50.convertType(src.getDoseNumberElement()));
        }
        if (src.hasSeriesDoses()) {
            tgt.setSeriesDoses(ImmunizationRecommendation40_50.convertType(src.getSeriesDosesElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getSupportingImmunization()) {
            tgt.addSupportingImmunization(ImmunizationRecommendation40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getSupportingPatientInformation()) {
            tgt.addSupportingPatientInformation(ImmunizationRecommendation40_50.convertReference(reference));
        }
        return tgt;
    }

    public static ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent convertImmunizationRecommendationRecommendationDateCriterionComponent(ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent tgt = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        ImmunizationRecommendation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(ImmunizationRecommendation40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ImmunizationRecommendation40_50.convertDateTime(src.getValueElement()));
        }
        return tgt;
    }

    public static ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent convertImmunizationRecommendationRecommendationDateCriterionComponent(ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent tgt = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        ImmunizationRecommendation40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(ImmunizationRecommendation40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ImmunizationRecommendation40_50.convertDateTime(src.getValueElement()));
        }
        return tgt;
    }
}

