/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.EnrollmentResponse;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.Enumerations;

public class EnrollmentResponse40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.EnrollmentResponse convertEnrollmentResponse(EnrollmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.EnrollmentResponse tgt = new org.hl7.fhir.r5.model.EnrollmentResponse();
        EnrollmentResponse40_50.copyDomainResource(src, tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(EnrollmentResponse40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EnrollmentResponse40_50.convertEnrollmentResponseStatus(src.getStatusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(EnrollmentResponse40_50.convertReference(src.getRequest()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(EnrollmentResponse40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(EnrollmentResponse40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(EnrollmentResponse40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(EnrollmentResponse40_50.convertReference(src.getOrganization()));
        }
        if (src.hasRequestProvider()) {
            tgt.setRequestProvider(EnrollmentResponse40_50.convertReference(src.getRequestProvider()));
        }
        return tgt;
    }

    public static EnrollmentResponse convertEnrollmentResponse(org.hl7.fhir.r5.model.EnrollmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EnrollmentResponse tgt = new EnrollmentResponse();
        EnrollmentResponse40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(EnrollmentResponse40_50.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(EnrollmentResponse40_50.convertEnrollmentResponseStatus(src.getStatusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(EnrollmentResponse40_50.convertReference(src.getRequest()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(EnrollmentResponse40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(EnrollmentResponse40_50.convertString(src.getDispositionElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(EnrollmentResponse40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(EnrollmentResponse40_50.convertReference(src.getOrganization()));
        }
        if (src.hasRequestProvider()) {
            tgt.setRequestProvider(EnrollmentResponse40_50.convertReference(src.getRequestProvider()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertEnrollmentResponseStatus(Enumeration<EnrollmentResponse.EnrollmentResponseStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((EnrollmentResponse.EnrollmentResponseStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<EnrollmentResponse.EnrollmentResponseStatus> convertEnrollmentResponseStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<EnrollmentResponse.EnrollmentResponseStatus> tgt = new Enumeration<EnrollmentResponse.EnrollmentResponseStatus>(new EnrollmentResponse.EnrollmentResponseStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)EnrollmentResponse.EnrollmentResponseStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)EnrollmentResponse.EnrollmentResponseStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)EnrollmentResponse.EnrollmentResponseStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)EnrollmentResponse.EnrollmentResponseStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)EnrollmentResponse.EnrollmentResponseStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> convertRemittanceOutcome(Enumeration<Enumerations.RemittanceOutcome> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RemittanceOutcome)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.RemittanceOutcome> convertRemittanceOutcome(org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.RemittanceOutcome> tgt = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ClaimProcessingCodes)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RemittanceOutcome.NULL);
            }
        }
        return tgt;
    }
}

