/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.DeviceRequest;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class DeviceRequest40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.DeviceRequest convertDeviceRequest(DeviceRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.DeviceRequest tgt = new org.hl7.fhir.r5.model.DeviceRequest();
        DeviceRequest40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceRequest40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(DeviceRequest40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(DeviceRequest40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(DeviceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPriorRequest()) {
            tgt.addPriorRequest(DeviceRequest40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(DeviceRequest40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DeviceRequest40_50.convertDeviceRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(DeviceRequest40_50.convertRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(DeviceRequest40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.hasCodeCodeableConcept()) {
            tgt.getCode().setConcept(DeviceRequest40_50.convertCodeableConcept(src.getCodeCodeableConcept()));
        } else if (src.hasCodeReference()) {
            tgt.getCode().setReference(DeviceRequest40_50.convertReference(src.getCodeReference()));
        }
        for (DeviceRequest.DeviceRequestParameterComponent deviceRequestParameterComponent : src.getParameter()) {
            tgt.addParameter(DeviceRequest40_50.convertDeviceRequestParameterComponent(deviceRequestParameterComponent));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DeviceRequest40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(DeviceRequest40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(DeviceRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(DeviceRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(DeviceRequest40_50.convertReference(src.getRequester()));
        }
        if (src.hasPerformerType()) {
            tgt.setPerformerType(DeviceRequest40_50.convertCodeableConcept(src.getPerformerType()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(DeviceRequest40_50.convertReference(src.getPerformer()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(DeviceRequest40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(DeviceRequest40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getInsurance()) {
            tgt.addInsurance(DeviceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(DeviceRequest40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(DeviceRequest40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(DeviceRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static DeviceRequest convertDeviceRequest(org.hl7.fhir.r5.model.DeviceRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceRequest tgt = new DeviceRequest();
        DeviceRequest40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceRequest40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(DeviceRequest40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(DeviceRequest40_50.convertUri(uriType));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(DeviceRequest40_50.convertReference(reference));
        }
        for (Reference reference : src.getPriorRequest()) {
            tgt.addPriorRequest(DeviceRequest40_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(DeviceRequest40_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DeviceRequest40_50.convertDeviceRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(DeviceRequest40_50.convertRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(DeviceRequest40_50.convertRequestPriority(src.getPriorityElement()));
        }
        if (src.getCode().hasConcept()) {
            tgt.setCode(DeviceRequest40_50.convertType(src.getCode().getConcept()));
        }
        if (src.getCode().hasReference()) {
            tgt.setCode(DeviceRequest40_50.convertType(src.getCode().getReference()));
        }
        for (DeviceRequest.DeviceRequestParameterComponent deviceRequestParameterComponent : src.getParameter()) {
            tgt.addParameter(DeviceRequest40_50.convertDeviceRequestParameterComponent(deviceRequestParameterComponent));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DeviceRequest40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(DeviceRequest40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(DeviceRequest40_50.convertType(src.getOccurrence()));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(DeviceRequest40_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRequester()) {
            tgt.setRequester(DeviceRequest40_50.convertReference(src.getRequester()));
        }
        if (src.hasPerformerType()) {
            tgt.setPerformerType(DeviceRequest40_50.convertCodeableConcept(src.getPerformerType()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(DeviceRequest40_50.convertReference(src.getPerformer()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(DeviceRequest40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(DeviceRequest40_50.convertReference(codeableReference.getReference()));
        }
        for (Reference reference : src.getInsurance()) {
            tgt.addInsurance(DeviceRequest40_50.convertReference(reference));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(DeviceRequest40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(DeviceRequest40_50.convertAnnotation(annotation));
        }
        for (Reference reference : src.getRelevantHistory()) {
            tgt.addRelevantHistory(DeviceRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertDeviceRequestStatus(Enumeration<DeviceRequest.DeviceRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceRequest.DeviceRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.RequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Enumerations.RequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.RequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.RequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceRequest.DeviceRequestStatus> convertDeviceRequestStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceRequest.DeviceRequestStatus> tgt = new Enumeration<DeviceRequest.DeviceRequestStatus>(new DeviceRequest.DeviceRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceRequest.DeviceRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> convertRequestIntent(Enumeration<DeviceRequest.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent>(new Enumerations.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceRequest.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)Enumerations.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)Enumerations.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)Enumerations.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)Enumerations.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)Enumerations.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceRequest.RequestIntent> convertRequestIntent(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceRequest.RequestIntent> tgt = new Enumeration<DeviceRequest.RequestIntent>(new DeviceRequest.RequestIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.PLAN);
                break;
            }
            case DIRECTIVE: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.DIRECTIVE);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.ORDER);
                break;
            }
            case ORIGINALORDER: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.ORIGINALORDER);
                break;
            }
            case REFLEXORDER: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.REFLEXORDER);
                break;
            }
            case FILLERORDER: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.FILLERORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.INSTANCEORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceRequest.RequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> convertRequestPriority(Enumeration<DeviceRequest.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceRequest.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceRequest.RequestPriority> convertRequestPriority(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceRequest.RequestPriority> tgt = new Enumeration<DeviceRequest.RequestPriority>(new DeviceRequest.RequestPriorityEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)DeviceRequest.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)DeviceRequest.RequestPriority.URGENT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)DeviceRequest.RequestPriority.ASAP);
                break;
            }
            case STAT: {
                tgt.setValue((Object)DeviceRequest.RequestPriority.STAT);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceRequest.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static DeviceRequest.DeviceRequestParameterComponent convertDeviceRequestParameterComponent(DeviceRequest.DeviceRequestParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceRequest.DeviceRequestParameterComponent tgt = new DeviceRequest.DeviceRequestParameterComponent();
        DeviceRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(DeviceRequest40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(DeviceRequest40_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static DeviceRequest.DeviceRequestParameterComponent convertDeviceRequestParameterComponent(DeviceRequest.DeviceRequestParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceRequest.DeviceRequestParameterComponent tgt = new DeviceRequest.DeviceRequestParameterComponent();
        DeviceRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(DeviceRequest40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(DeviceRequest40_50.convertType(src.getValue()));
        }
        return tgt;
    }
}

