/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.DeviceMetric;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.DeviceMetric;

public class DeviceMetric40_50
extends VersionConvertor_40_50 {
    public static DeviceMetric convertDeviceMetric(org.hl7.fhir.r4.model.DeviceMetric src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceMetric tgt = new DeviceMetric();
        DeviceMetric40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceMetric40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setType(DeviceMetric40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(DeviceMetric40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasSource()) {
            tgt.setSource(DeviceMetric40_50.convertReference(src.getSource()));
        }
        if (src.hasParent()) {
            tgt.setParent(DeviceMetric40_50.convertReference(src.getParent()));
        }
        if (src.hasOperationalStatus()) {
            tgt.setOperationalStatusElement(DeviceMetric40_50.convertDeviceMetricOperationalStatus(src.getOperationalStatusElement()));
        }
        if (src.hasColor()) {
            tgt.setColorElement(DeviceMetric40_50.convertDeviceMetricColor(src.getColorElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(DeviceMetric40_50.convertDeviceMetricCategory(src.getCategoryElement()));
        }
        if (src.hasMeasurementPeriod()) {
            tgt.setMeasurementPeriod(DeviceMetric40_50.convertTiming(src.getMeasurementPeriod()));
        }
        for (DeviceMetric.DeviceMetricCalibrationComponent deviceMetricCalibrationComponent : src.getCalibration()) {
            tgt.addCalibration(DeviceMetric40_50.convertDeviceMetricCalibrationComponent(deviceMetricCalibrationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DeviceMetric convertDeviceMetric(DeviceMetric src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.DeviceMetric tgt = new org.hl7.fhir.r4.model.DeviceMetric();
        DeviceMetric40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DeviceMetric40_50.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setType(DeviceMetric40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(DeviceMetric40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasSource()) {
            tgt.setSource(DeviceMetric40_50.convertReference(src.getSource()));
        }
        if (src.hasParent()) {
            tgt.setParent(DeviceMetric40_50.convertReference(src.getParent()));
        }
        if (src.hasOperationalStatus()) {
            tgt.setOperationalStatusElement(DeviceMetric40_50.convertDeviceMetricOperationalStatus(src.getOperationalStatusElement()));
        }
        if (src.hasColor()) {
            tgt.setColorElement(DeviceMetric40_50.convertDeviceMetricColor(src.getColorElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategoryElement(DeviceMetric40_50.convertDeviceMetricCategory(src.getCategoryElement()));
        }
        if (src.hasMeasurementPeriod()) {
            tgt.setMeasurementPeriod(DeviceMetric40_50.convertTiming(src.getMeasurementPeriod()));
        }
        for (DeviceMetric.DeviceMetricCalibrationComponent deviceMetricCalibrationComponent : src.getCalibration()) {
            tgt.addCalibration(DeviceMetric40_50.convertDeviceMetricCalibrationComponent(deviceMetricCalibrationComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricOperationalStatus> convertDeviceMetricOperationalStatus(Enumeration<DeviceMetric.DeviceMetricOperationalStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricOperationalStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricOperationalStatus>(new DeviceMetric.DeviceMetricOperationalStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricOperationalStatus)((Object)src.getValue())) {
            case ON: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.ON);
                break;
            }
            case OFF: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.OFF);
                break;
            }
            case STANDBY: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.STANDBY);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceMetric.DeviceMetricOperationalStatus> convertDeviceMetricOperationalStatus(org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricOperationalStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceMetric.DeviceMetricOperationalStatus> tgt = new Enumeration<DeviceMetric.DeviceMetricOperationalStatus>(new DeviceMetric.DeviceMetricOperationalStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricOperationalStatus)((Object)src.getValue())) {
            case ON: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.ON);
                break;
            }
            case OFF: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.OFF);
                break;
            }
            case STANDBY: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.STANDBY);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricOperationalStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricColor> convertDeviceMetricColor(Enumeration<DeviceMetric.DeviceMetricColor> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricColor> tgt = new org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricColor>(new DeviceMetric.DeviceMetricColorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricColor)((Object)src.getValue())) {
            case BLACK: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.BLACK);
                break;
            }
            case RED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.RED);
                break;
            }
            case GREEN: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.GREEN);
                break;
            }
            case YELLOW: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.YELLOW);
                break;
            }
            case BLUE: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.BLUE);
                break;
            }
            case MAGENTA: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.MAGENTA);
                break;
            }
            case CYAN: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.CYAN);
                break;
            }
            case WHITE: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.WHITE);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceMetric.DeviceMetricColor> convertDeviceMetricColor(org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricColor> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceMetric.DeviceMetricColor> tgt = new Enumeration<DeviceMetric.DeviceMetricColor>(new DeviceMetric.DeviceMetricColorEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricColor)((Object)src.getValue())) {
            case BLACK: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.BLACK);
                break;
            }
            case RED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.RED);
                break;
            }
            case GREEN: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.GREEN);
                break;
            }
            case YELLOW: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.YELLOW);
                break;
            }
            case BLUE: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.BLUE);
                break;
            }
            case MAGENTA: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.MAGENTA);
                break;
            }
            case CYAN: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.CYAN);
                break;
            }
            case WHITE: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.WHITE);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricColor.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCategory> convertDeviceMetricCategory(Enumeration<DeviceMetric.DeviceMetricCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCategory> tgt = new org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCategory>(new DeviceMetric.DeviceMetricCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricCategory)((Object)src.getValue())) {
            case MEASUREMENT: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.MEASUREMENT);
                break;
            }
            case SETTING: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.SETTING);
                break;
            }
            case CALCULATION: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.CALCULATION);
                break;
            }
            case UNSPECIFIED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.UNSPECIFIED);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceMetric.DeviceMetricCategory> convertDeviceMetricCategory(org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceMetric.DeviceMetricCategory> tgt = new Enumeration<DeviceMetric.DeviceMetricCategory>(new DeviceMetric.DeviceMetricCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricCategory)((Object)src.getValue())) {
            case MEASUREMENT: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.MEASUREMENT);
                break;
            }
            case SETTING: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.SETTING);
                break;
            }
            case CALCULATION: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.CALCULATION);
                break;
            }
            case UNSPECIFIED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.UNSPECIFIED);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCategory.NULL);
            }
        }
        return tgt;
    }

    public static DeviceMetric.DeviceMetricCalibrationComponent convertDeviceMetricCalibrationComponent(DeviceMetric.DeviceMetricCalibrationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceMetric.DeviceMetricCalibrationComponent tgt = new DeviceMetric.DeviceMetricCalibrationComponent();
        DeviceMetric40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(DeviceMetric40_50.convertDeviceMetricCalibrationType(src.getTypeElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(DeviceMetric40_50.convertDeviceMetricCalibrationState(src.getStateElement()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(DeviceMetric40_50.convertInstant(src.getTimeElement()));
        }
        return tgt;
    }

    public static DeviceMetric.DeviceMetricCalibrationComponent convertDeviceMetricCalibrationComponent(DeviceMetric.DeviceMetricCalibrationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceMetric.DeviceMetricCalibrationComponent tgt = new DeviceMetric.DeviceMetricCalibrationComponent();
        DeviceMetric40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(DeviceMetric40_50.convertDeviceMetricCalibrationType(src.getTypeElement()));
        }
        if (src.hasState()) {
            tgt.setStateElement(DeviceMetric40_50.convertDeviceMetricCalibrationState(src.getStateElement()));
        }
        if (src.hasTime()) {
            tgt.setTimeElement(DeviceMetric40_50.convertInstant(src.getTimeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationType> convertDeviceMetricCalibrationType(Enumeration<DeviceMetric.DeviceMetricCalibrationType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationType> tgt = new org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationType>(new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricCalibrationType)((Object)src.getValue())) {
            case UNSPECIFIED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.UNSPECIFIED);
                break;
            }
            case OFFSET: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.OFFSET);
                break;
            }
            case GAIN: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.GAIN);
                break;
            }
            case TWOPOINT: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.TWOPOINT);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceMetric.DeviceMetricCalibrationType> convertDeviceMetricCalibrationType(org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceMetric.DeviceMetricCalibrationType> tgt = new Enumeration<DeviceMetric.DeviceMetricCalibrationType>(new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricCalibrationType)((Object)src.getValue())) {
            case UNSPECIFIED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.UNSPECIFIED);
                break;
            }
            case OFFSET: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.OFFSET);
                break;
            }
            case GAIN: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.GAIN);
                break;
            }
            case TWOPOINT: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.TWOPOINT);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationState> convertDeviceMetricCalibrationState(Enumeration<DeviceMetric.DeviceMetricCalibrationState> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationState> tgt = new org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationState>(new DeviceMetric.DeviceMetricCalibrationStateEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricCalibrationState)((Object)src.getValue())) {
            case NOTCALIBRATED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.NOTCALIBRATED);
                break;
            }
            case CALIBRATIONREQUIRED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.CALIBRATIONREQUIRED);
                break;
            }
            case CALIBRATED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.CALIBRATED);
                break;
            }
            case UNSPECIFIED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.UNSPECIFIED);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DeviceMetric.DeviceMetricCalibrationState> convertDeviceMetricCalibrationState(org.hl7.fhir.r5.model.Enumeration<DeviceMetric.DeviceMetricCalibrationState> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DeviceMetric.DeviceMetricCalibrationState> tgt = new Enumeration<DeviceMetric.DeviceMetricCalibrationState>(new DeviceMetric.DeviceMetricCalibrationStateEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DeviceMetric.DeviceMetricCalibrationState)((Object)src.getValue())) {
            case NOTCALIBRATED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.NOTCALIBRATED);
                break;
            }
            case CALIBRATIONREQUIRED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.CALIBRATIONREQUIRED);
                break;
            }
            case CALIBRATED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.CALIBRATED);
                break;
            }
            case UNSPECIFIED: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.UNSPECIFIED);
                break;
            }
            default: {
                tgt.setValue((Object)DeviceMetric.DeviceMetricCalibrationState.NULL);
            }
        }
        return tgt;
    }
}

