/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class CoverageEligibilityRequest40_50
extends VersionConvertor_40_50 {
    public static CoverageEligibilityRequest convertCoverageEligibilityRequest(org.hl7.fhir.r4.model.CoverageEligibilityRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest tgt = new CoverageEligibilityRequest();
        CoverageEligibilityRequest40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CoverageEligibilityRequest40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CoverageEligibilityRequest40_50.convertEligibilityRequestStatus(src.getStatusElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(CoverageEligibilityRequest40_50.convertCodeableConcept(src.getPriority()));
        }
        tgt.setPurpose(src.getPurpose().stream().map(CoverageEligibilityRequest40_50::convertEligibilityRequestPurpose).collect(Collectors.toList()));
        if (src.hasPatient()) {
            tgt.setPatient(CoverageEligibilityRequest40_50.convertReference(src.getPatient()));
        }
        if (src.hasServiced()) {
            tgt.setServiced(CoverageEligibilityRequest40_50.convertType(src.getServiced()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(CoverageEligibilityRequest40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(CoverageEligibilityRequest40_50.convertReference(src.getEnterer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(CoverageEligibilityRequest40_50.convertReference(src.getProvider()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(CoverageEligibilityRequest40_50.convertReference(src.getInsurer()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(CoverageEligibilityRequest40_50.convertReference(src.getFacility()));
        }
        for (CoverageEligibilityRequest.SupportingInformationComponent supportingInformationComponent : src.getSupportingInfo()) {
            tgt.addSupportingInfo(CoverageEligibilityRequest40_50.convertSupportingInformationComponent(supportingInformationComponent));
        }
        for (CoverageEligibilityRequest.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(CoverageEligibilityRequest40_50.convertInsuranceComponent(insuranceComponent));
        }
        for (CoverageEligibilityRequest.DetailsComponent detailsComponent : src.getItem()) {
            tgt.addItem(CoverageEligibilityRequest40_50.convertDetailsComponent(detailsComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CoverageEligibilityRequest convertCoverageEligibilityRequest(CoverageEligibilityRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CoverageEligibilityRequest tgt = new org.hl7.fhir.r4.model.CoverageEligibilityRequest();
        CoverageEligibilityRequest40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CoverageEligibilityRequest40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CoverageEligibilityRequest40_50.convertEligibilityRequestStatus(src.getStatusElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(CoverageEligibilityRequest40_50.convertCodeableConcept(src.getPriority()));
        }
        tgt.setPurpose(src.getPurpose().stream().map(CoverageEligibilityRequest40_50::convertEligibilityRequestPurpose).collect(Collectors.toList()));
        if (src.hasPatient()) {
            tgt.setPatient(CoverageEligibilityRequest40_50.convertReference(src.getPatient()));
        }
        if (src.hasServiced()) {
            tgt.setServiced(CoverageEligibilityRequest40_50.convertType(src.getServiced()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(CoverageEligibilityRequest40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(CoverageEligibilityRequest40_50.convertReference(src.getEnterer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(CoverageEligibilityRequest40_50.convertReference(src.getProvider()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(CoverageEligibilityRequest40_50.convertReference(src.getInsurer()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(CoverageEligibilityRequest40_50.convertReference(src.getFacility()));
        }
        for (CoverageEligibilityRequest.SupportingInformationComponent supportingInformationComponent : src.getSupportingInfo()) {
            tgt.addSupportingInfo(CoverageEligibilityRequest40_50.convertSupportingInformationComponent(supportingInformationComponent));
        }
        for (CoverageEligibilityRequest.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(CoverageEligibilityRequest40_50.convertInsuranceComponent(insuranceComponent));
        }
        for (CoverageEligibilityRequest.DetailsComponent detailsComponent : src.getItem()) {
            tgt.addItem(CoverageEligibilityRequest40_50.convertDetailsComponent(detailsComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertEligibilityRequestStatus(Enumeration<CoverageEligibilityRequest.EligibilityRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CoverageEligibilityRequest.EligibilityRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CoverageEligibilityRequest.EligibilityRequestStatus> convertEligibilityRequestStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CoverageEligibilityRequest.EligibilityRequestStatus> tgt = new Enumeration<CoverageEligibilityRequest.EligibilityRequestStatus>(new CoverageEligibilityRequest.EligibilityRequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose> convertEligibilityRequestPurpose(Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose> tgt = new org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose>(new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CoverageEligibilityRequest.EligibilityRequestPurpose)((Object)src.getValue())) {
            case AUTHREQUIREMENTS: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.AUTHREQUIREMENTS);
                break;
            }
            case BENEFITS: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.BENEFITS);
                break;
            }
            case DISCOVERY: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.DISCOVERY);
                break;
            }
            case VALIDATION: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.VALIDATION);
                break;
            }
            default: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose> convertEligibilityRequestPurpose(org.hl7.fhir.r5.model.Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose> tgt = new Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose>(new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CoverageEligibilityRequest.EligibilityRequestPurpose)((Object)src.getValue())) {
            case AUTHREQUIREMENTS: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.AUTHREQUIREMENTS);
                break;
            }
            case BENEFITS: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.BENEFITS);
                break;
            }
            case DISCOVERY: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.DISCOVERY);
                break;
            }
            case VALIDATION: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.VALIDATION);
                break;
            }
            default: {
                tgt.setValue((Object)CoverageEligibilityRequest.EligibilityRequestPurpose.NULL);
            }
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.SupportingInformationComponent convertSupportingInformationComponent(CoverageEligibilityRequest.SupportingInformationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.SupportingInformationComponent tgt = new CoverageEligibilityRequest.SupportingInformationComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(CoverageEligibilityRequest40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasInformation()) {
            tgt.setInformation(CoverageEligibilityRequest40_50.convertReference(src.getInformation()));
        }
        if (src.hasAppliesToAll()) {
            tgt.setAppliesToAllElement(CoverageEligibilityRequest40_50.convertBoolean(src.getAppliesToAllElement()));
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.SupportingInformationComponent convertSupportingInformationComponent(CoverageEligibilityRequest.SupportingInformationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.SupportingInformationComponent tgt = new CoverageEligibilityRequest.SupportingInformationComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(CoverageEligibilityRequest40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasInformation()) {
            tgt.setInformation(CoverageEligibilityRequest40_50.convertReference(src.getInformation()));
        }
        if (src.hasAppliesToAll()) {
            tgt.setAppliesToAllElement(CoverageEligibilityRequest40_50.convertBoolean(src.getAppliesToAllElement()));
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.InsuranceComponent convertInsuranceComponent(CoverageEligibilityRequest.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.InsuranceComponent tgt = new CoverageEligibilityRequest.InsuranceComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFocal()) {
            tgt.setFocalElement(CoverageEligibilityRequest40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(CoverageEligibilityRequest40_50.convertReference(src.getCoverage()));
        }
        if (src.hasBusinessArrangement()) {
            tgt.setBusinessArrangementElement(CoverageEligibilityRequest40_50.convertString(src.getBusinessArrangementElement()));
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.InsuranceComponent convertInsuranceComponent(CoverageEligibilityRequest.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.InsuranceComponent tgt = new CoverageEligibilityRequest.InsuranceComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFocal()) {
            tgt.setFocalElement(CoverageEligibilityRequest40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(CoverageEligibilityRequest40_50.convertReference(src.getCoverage()));
        }
        if (src.hasBusinessArrangement()) {
            tgt.setBusinessArrangementElement(CoverageEligibilityRequest40_50.convertString(src.getBusinessArrangementElement()));
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.DetailsComponent convertDetailsComponent(CoverageEligibilityRequest.DetailsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.DetailsComponent tgt = new CoverageEligibilityRequest.DetailsComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        for (PositiveIntType positiveIntType : src.getSupportingInfoSequence()) {
            tgt.getSupportingInfoSequence().add(CoverageEligibilityRequest40_50.convertPositiveInt(positiveIntType));
        }
        if (src.hasCategory()) {
            tgt.setCategory(CoverageEligibilityRequest40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(CoverageEligibilityRequest40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(CoverageEligibilityRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasProvider()) {
            tgt.setProvider(CoverageEligibilityRequest40_50.convertReference(src.getProvider()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(CoverageEligibilityRequest40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(CoverageEligibilityRequest40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(CoverageEligibilityRequest40_50.convertReference(src.getFacility()));
        }
        for (CoverageEligibilityRequest.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(CoverageEligibilityRequest40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getDetail()) {
            tgt.addDetail(CoverageEligibilityRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.DetailsComponent convertDetailsComponent(CoverageEligibilityRequest.DetailsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.DetailsComponent tgt = new CoverageEligibilityRequest.DetailsComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getSupportingInfoSequence()) {
            tgt.getSupportingInfoSequence().add(CoverageEligibilityRequest40_50.convertPositiveInt(positiveIntType));
        }
        if (src.hasCategory()) {
            tgt.setCategory(CoverageEligibilityRequest40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(CoverageEligibilityRequest40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(CoverageEligibilityRequest40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasProvider()) {
            tgt.setProvider(CoverageEligibilityRequest40_50.convertReference(src.getProvider()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(CoverageEligibilityRequest40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(CoverageEligibilityRequest40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(CoverageEligibilityRequest40_50.convertReference(src.getFacility()));
        }
        for (CoverageEligibilityRequest.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(CoverageEligibilityRequest40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(CoverageEligibilityRequest40_50.convertReference(reference));
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.DiagnosisComponent convertDiagnosisComponent(CoverageEligibilityRequest.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.DiagnosisComponent tgt = new CoverageEligibilityRequest.DiagnosisComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDiagnosis()) {
            tgt.setDiagnosis(CoverageEligibilityRequest40_50.convertType(src.getDiagnosis()));
        }
        return tgt;
    }

    public static CoverageEligibilityRequest.DiagnosisComponent convertDiagnosisComponent(CoverageEligibilityRequest.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CoverageEligibilityRequest.DiagnosisComponent tgt = new CoverageEligibilityRequest.DiagnosisComponent();
        CoverageEligibilityRequest40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDiagnosis()) {
            tgt.setDiagnosis(CoverageEligibilityRequest40_50.convertType(src.getDiagnosis()));
        }
        return tgt;
    }
}

