/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Reference;

public class Consent40_50
extends VersionConvertor_40_50 {
    public static Consent convertConsent(org.hl7.fhir.r4.model.Consent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent tgt = new Consent();
        Consent40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Consent40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Consent40_50.convertConsentState(src.getStatusElement()));
        }
        if (src.hasScope()) {
            tgt.setScope(Consent40_50.convertCodeableConcept(src.getScope()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Consent40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPatient()) {
            tgt.setSubject(Consent40_50.convertReference(src.getPatient()));
        }
        if (src.hasDateTime()) {
            tgt.setDateTimeElement(Consent40_50.convertDateTime(src.getDateTimeElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(Consent40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getOrganization()) {
            tgt.addOrganization(Consent40_50.convertReference(reference));
        }
        if (src.hasSourceAttachment()) {
            tgt.addSourceAttachment(Consent40_50.convertAttachment(src.getSourceAttachment()));
        }
        if (src.hasSourceReference()) {
            tgt.addSourceReference(Consent40_50.convertReference(src.getSourceReference()));
        }
        for (Consent.ConsentPolicyComponent consentPolicyComponent : src.getPolicy()) {
            tgt.addPolicy(Consent40_50.convertConsentPolicyComponent(consentPolicyComponent));
        }
        if (src.hasPolicyRule()) {
            tgt.setPolicyRule(Consent40_50.convertCodeableConcept(src.getPolicyRule()));
        }
        for (Consent.ConsentVerificationComponent consentVerificationComponent : src.getVerification()) {
            tgt.addVerification(Consent40_50.convertConsentVerificationComponent(consentVerificationComponent));
        }
        if (src.hasProvision()) {
            tgt.setProvision(Consent40_50.convertprovisionComponent(src.getProvision()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Consent convertConsent(Consent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Consent tgt = new org.hl7.fhir.r4.model.Consent();
        Consent40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Consent40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Consent40_50.convertConsentState(src.getStatusElement()));
        }
        if (src.hasScope()) {
            tgt.setScope(Consent40_50.convertCodeableConcept(src.getScope()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Consent40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setPatient(Consent40_50.convertReference(src.getSubject()));
        }
        if (src.hasDateTime()) {
            tgt.setDateTimeElement(Consent40_50.convertDateTime(src.getDateTimeElement()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(Consent40_50.convertReference(reference));
        }
        for (Reference reference : src.getOrganization()) {
            tgt.addOrganization(Consent40_50.convertReference(reference));
        }
        if (src.hasSourceAttachment()) {
            tgt.setSource(Consent40_50.convertType(src.getSourceAttachmentFirstRep()));
        }
        if (src.hasSourceReference()) {
            tgt.setSource(Consent40_50.convertType(src.getSourceReferenceFirstRep()));
        }
        for (Consent.ConsentPolicyComponent consentPolicyComponent : src.getPolicy()) {
            tgt.addPolicy(Consent40_50.convertConsentPolicyComponent(consentPolicyComponent));
        }
        if (src.hasPolicyRule()) {
            tgt.setPolicyRule(Consent40_50.convertCodeableConcept(src.getPolicyRule()));
        }
        for (Consent.ConsentVerificationComponent consentVerificationComponent : src.getVerification()) {
            tgt.addVerification(Consent40_50.convertConsentVerificationComponent(consentVerificationComponent));
        }
        if (src.hasProvision()) {
            tgt.setProvision(Consent40_50.convertprovisionComponent(src.getProvision()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Consent.ConsentState> convertConsentState(Enumeration<Consent.ConsentState> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Consent.ConsentState> tgt = new org.hl7.fhir.r5.model.Enumeration<Consent.ConsentState>(new Consent.ConsentStateEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentState)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Consent.ConsentState.DRAFT);
                break;
            }
            case PROPOSED: {
                tgt.setValue((Object)Consent.ConsentState.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.ACTIVE);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Consent.ConsentState.INACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Consent.ConsentState.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentState.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Consent.ConsentState> convertConsentState(org.hl7.fhir.r5.model.Enumeration<Consent.ConsentState> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Consent.ConsentState> tgt = new Enumeration<Consent.ConsentState>(new Consent.ConsentStateEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentState)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Consent.ConsentState.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Consent.ConsentState.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Consent.ConsentState.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentState.NULL);
            }
        }
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthority()) {
            tgt.setAuthorityElement(Consent40_50.convertUri(src.getAuthorityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(Consent40_50.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthority()) {
            tgt.setAuthorityElement(Consent40_50.convertUri(src.getAuthorityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(Consent40_50.convertUri(src.getUriElement()));
        }
        return tgt;
    }

    public static Consent.ConsentVerificationComponent convertConsentVerificationComponent(Consent.ConsentVerificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentVerificationComponent tgt = new Consent.ConsentVerificationComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVerified()) {
            tgt.setVerifiedElement(Consent40_50.convertBoolean(src.getVerifiedElement()));
        }
        if (src.hasVerifiedWith()) {
            tgt.setVerifiedWith(Consent40_50.convertReference(src.getVerifiedWith()));
        }
        if (src.hasVerificationDate()) {
            tgt.getVerificationDate().add(Consent40_50.convertDateTime(src.getVerificationDateElement()));
        }
        return tgt;
    }

    public static Consent.ConsentVerificationComponent convertConsentVerificationComponent(Consent.ConsentVerificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentVerificationComponent tgt = new Consent.ConsentVerificationComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVerified()) {
            tgt.setVerifiedElement(Consent40_50.convertBoolean(src.getVerifiedElement()));
        }
        if (src.hasVerifiedWith()) {
            tgt.setVerifiedWith(Consent40_50.convertReference(src.getVerifiedWith()));
        }
        if (src.hasVerificationDate()) {
            tgt.setVerificationDateElement(Consent40_50.convertDateTime(src.getVerificationDate().get(0)));
        }
        return tgt;
    }

    public static Consent.ProvisionComponent convertprovisionComponent(Consent.provisionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ProvisionComponent tgt = new Consent.ProvisionComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Consent40_50.convertConsentProvisionType(src.getTypeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Consent40_50.convertPeriod(src.getPeriod()));
        }
        for (Consent.provisionActorComponent provisionActorComponent2 : src.getActor()) {
            tgt.addActor(Consent40_50.convertprovisionActorComponent(provisionActorComponent2));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(Consent40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(Consent40_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getPurpose()) {
            tgt.addPurpose(Consent40_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r4.model.Coding coding : src.getClass_()) {
            tgt.addClass_(Consent40_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(Consent40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDataPeriod()) {
            tgt.setDataPeriod(Consent40_50.convertPeriod(src.getDataPeriod()));
        }
        for (Consent.provisionDataComponent provisionDataComponent2 : src.getData()) {
            tgt.addData(Consent40_50.convertprovisionDataComponent(provisionDataComponent2));
        }
        for (Consent.provisionComponent provisionComponent2 : src.getProvision()) {
            tgt.addProvision(Consent40_50.convertprovisionComponent(provisionComponent2));
        }
        return tgt;
    }

    public static Consent.provisionComponent convertprovisionComponent(Consent.ProvisionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionComponent tgt = new Consent.provisionComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(Consent40_50.convertConsentProvisionType(src.getTypeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Consent40_50.convertPeriod(src.getPeriod()));
        }
        for (Consent.ProvisionActorComponent provisionActorComponent2 : src.getActor()) {
            tgt.addActor(Consent40_50.convertprovisionActorComponent(provisionActorComponent2));
        }
        for (CodeableConcept codeableConcept : src.getAction()) {
            tgt.addAction(Consent40_50.convertCodeableConcept(codeableConcept));
        }
        for (Coding coding : src.getSecurityLabel()) {
            tgt.addSecurityLabel(Consent40_50.convertCoding(coding));
        }
        for (Coding coding : src.getPurpose()) {
            tgt.addPurpose(Consent40_50.convertCoding(coding));
        }
        for (Coding coding : src.getClass_()) {
            tgt.addClass_(Consent40_50.convertCoding(coding));
        }
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(Consent40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDataPeriod()) {
            tgt.setDataPeriod(Consent40_50.convertPeriod(src.getDataPeriod()));
        }
        for (Consent.ProvisionDataComponent provisionDataComponent2 : src.getData()) {
            tgt.addData(Consent40_50.convertprovisionDataComponent(provisionDataComponent2));
        }
        for (Consent.ProvisionComponent provisionComponent2 : src.getProvision()) {
            tgt.addProvision(Consent40_50.convertprovisionComponent(provisionComponent2));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Consent.ConsentProvisionType> convertConsentProvisionType(Enumeration<Consent.ConsentProvisionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Consent.ConsentProvisionType> tgt = new org.hl7.fhir.r5.model.Enumeration<Consent.ConsentProvisionType>(new Consent.ConsentProvisionTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentProvisionType)((Object)src.getValue())) {
            case DENY: {
                tgt.setValue((Object)Consent.ConsentProvisionType.DENY);
                break;
            }
            case PERMIT: {
                tgt.setValue((Object)Consent.ConsentProvisionType.PERMIT);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentProvisionType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Consent.ConsentProvisionType> convertConsentProvisionType(org.hl7.fhir.r5.model.Enumeration<Consent.ConsentProvisionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Consent.ConsentProvisionType> tgt = new Enumeration<Consent.ConsentProvisionType>(new Consent.ConsentProvisionTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentProvisionType)((Object)src.getValue())) {
            case DENY: {
                tgt.setValue((Object)Consent.ConsentProvisionType.DENY);
                break;
            }
            case PERMIT: {
                tgt.setValue((Object)Consent.ConsentProvisionType.PERMIT);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentProvisionType.NULL);
            }
        }
        return tgt;
    }

    public static Consent.ProvisionActorComponent convertprovisionActorComponent(Consent.provisionActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ProvisionActorComponent tgt = new Consent.ProvisionActorComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(Consent40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasReference()) {
            tgt.setReference(Consent40_50.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.provisionActorComponent convertprovisionActorComponent(Consent.ProvisionActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionActorComponent tgt = new Consent.provisionActorComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(Consent40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasReference()) {
            tgt.setReference(Consent40_50.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.ProvisionDataComponent convertprovisionDataComponent(Consent.provisionDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ProvisionDataComponent tgt = new Consent.ProvisionDataComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMeaning()) {
            tgt.setMeaningElement(Consent40_50.convertConsentDataMeaning(src.getMeaningElement()));
        }
        if (src.hasReference()) {
            tgt.setReference(Consent40_50.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static Consent.provisionDataComponent convertprovisionDataComponent(Consent.ProvisionDataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.provisionDataComponent tgt = new Consent.provisionDataComponent();
        Consent40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMeaning()) {
            tgt.setMeaningElement(Consent40_50.convertConsentDataMeaning(src.getMeaningElement()));
        }
        if (src.hasReference()) {
            tgt.setReference(Consent40_50.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning> convertConsentDataMeaning(Enumeration<Consent.ConsentDataMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning> tgt = new org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning>(new Consent.ConsentDataMeaningEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentDataMeaning)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.INSTANCE);
                break;
            }
            case RELATED: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.RELATED);
                break;
            }
            case DEPENDENTS: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.DEPENDENTS);
                break;
            }
            case AUTHOREDBY: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.AUTHOREDBY);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Consent.ConsentDataMeaning> convertConsentDataMeaning(org.hl7.fhir.r5.model.Enumeration<Consent.ConsentDataMeaning> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Consent.ConsentDataMeaning> tgt = new Enumeration<Consent.ConsentDataMeaning>(new Consent.ConsentDataMeaningEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Consent.ConsentDataMeaning)((Object)src.getValue())) {
            case INSTANCE: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.INSTANCE);
                break;
            }
            case RELATED: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.RELATED);
                break;
            }
            case DEPENDENTS: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.DEPENDENTS);
                break;
            }
            case AUTHOREDBY: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.AUTHOREDBY);
                break;
            }
            default: {
                tgt.setValue((Object)Consent.ConsentDataMeaning.NULL);
            }
        }
        return tgt;
    }
}

