/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Condition;

public class Condition40_50
extends VersionConvertor_40_50 {
    public static Condition convertCondition(org.hl7.fhir.r4.model.Condition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition tgt = new Condition();
        Condition40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Condition40_50.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(Condition40_50.convertCodeableConcept(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(Condition40_50.convertCodeableConcept(src.getVerificationStatus()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Condition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(Condition40_50.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(Condition40_50.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(Condition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Condition40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Condition40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(Condition40_50.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(Condition40_50.convertType(src.getAbatement()));
        }
        if (src.hasRecordedDate()) {
            tgt.setRecordedDateElement(Condition40_50.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(Condition40_50.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(Condition40_50.convertReference(src.getAsserter()));
        }
        for (Condition.ConditionStageComponent conditionStageComponent : src.getStage()) {
            tgt.addStage(Condition40_50.convertConditionStageComponent(conditionStageComponent));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition40_50.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Condition40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Condition convertCondition(Condition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Condition tgt = new org.hl7.fhir.r4.model.Condition();
        Condition40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Condition40_50.convertIdentifier(identifier));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(Condition40_50.convertCodeableConcept(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(Condition40_50.convertCodeableConcept(src.getVerificationStatus()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Condition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(Condition40_50.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(Condition40_50.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(Condition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Condition40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(Condition40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(Condition40_50.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(Condition40_50.convertType(src.getAbatement()));
        }
        if (src.hasRecordedDate()) {
            tgt.setRecordedDateElement(Condition40_50.convertDateTime(src.getRecordedDateElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(Condition40_50.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(Condition40_50.convertReference(src.getAsserter()));
        }
        for (Condition.ConditionStageComponent conditionStageComponent : src.getStage()) {
            tgt.addStage(Condition40_50.convertConditionStageComponent(conditionStageComponent));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition40_50.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Condition40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        Condition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSummary()) {
            tgt.setSummary(Condition40_50.convertCodeableConcept(src.getSummary()));
        }
        for (Reference t : src.getAssessment()) {
            tgt.addAssessment(Condition40_50.convertReference(t));
        }
        if (src.hasType()) {
            tgt.setType(Condition40_50.convertCodeableConcept(src.getType()));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        Condition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSummary()) {
            tgt.setSummary(Condition40_50.convertCodeableConcept(src.getSummary()));
        }
        for (org.hl7.fhir.r5.model.Reference t : src.getAssessment()) {
            tgt.addAssessment(Condition40_50.convertReference(t));
        }
        if (src.hasType()) {
            tgt.setType(Condition40_50.convertCodeableConcept(src.getType()));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        Condition40_50.copyElement(src, tgt, new String[0]);
        for (CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(Condition40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getDetail()) {
            tgt.addDetail(Condition40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        Condition40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCode()) {
            tgt.addCode(Condition40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDetail()) {
            tgt.addDetail(Condition40_50.convertReference(reference));
        }
        return tgt;
    }
}

