/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StringType;

public class CompartmentDefinition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.CompartmentDefinition convertCompartmentDefinition(CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.CompartmentDefinition tgt = new org.hl7.fhir.r5.model.CompartmentDefinition();
        CompartmentDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(CompartmentDefinition40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CompartmentDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CompartmentDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(CompartmentDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(CompartmentDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(CompartmentDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CompartmentDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CompartmentDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(CompartmentDefinition40_50.convertUsageContext(usageContext));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(CompartmentDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition40_50.convertCompartmentType(src.getCodeElement()));
        }
        if (src.hasSearch()) {
            tgt.setSearchElement(CompartmentDefinition40_50.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(CompartmentDefinition40_50.convertCompartmentDefinitionResourceComponent(compartmentDefinitionResourceComponent));
        }
        return tgt;
    }

    public static CompartmentDefinition convertCompartmentDefinition(org.hl7.fhir.r5.model.CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition tgt = new CompartmentDefinition();
        CompartmentDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(CompartmentDefinition40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(CompartmentDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(CompartmentDefinition40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(CompartmentDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(CompartmentDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(CompartmentDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r5.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(CompartmentDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CompartmentDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(CompartmentDefinition40_50.convertUsageContext(usageContext));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(CompartmentDefinition40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition40_50.convertCompartmentType(src.getCodeElement()));
        }
        if (src.hasSearch()) {
            tgt.setSearchElement(CompartmentDefinition40_50.convertBoolean(src.getSearchElement()));
        }
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent compartmentDefinitionResourceComponent : src.getResource()) {
            tgt.addResource(CompartmentDefinition40_50.convertCompartmentDefinitionResourceComponent(compartmentDefinitionResourceComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType> convertCompartmentType(Enumeration<CompartmentDefinition.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType>(new Enumerations.CompartmentTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CompartmentDefinition.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)Enumerations.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)Enumerations.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)Enumerations.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Enumerations.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Enumerations.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompartmentType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CompartmentDefinition.CompartmentType> convertCompartmentType(org.hl7.fhir.r5.model.Enumeration<Enumerations.CompartmentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CompartmentDefinition.CompartmentType> tgt = new Enumeration<CompartmentDefinition.CompartmentType>(new CompartmentDefinition.CompartmentTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CompartmentType)((Object)src.getValue())) {
            case PATIENT: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PATIENT);
                break;
            }
            case ENCOUNTER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.ENCOUNTER);
                break;
            }
            case RELATEDPERSON: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.RELATEDPERSON);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.DEVICE);
                break;
            }
            default: {
                tgt.setValue((Object)CompartmentDefinition.CompartmentType.NULL);
            }
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        CompartmentDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition40_50.convertResourceEnum(src.getCodeElement()));
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getParam()) {
            tgt.getParam().add(CompartmentDefinition40_50.convertString(t));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CompartmentDefinition40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        CompartmentDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(CompartmentDefinition40_50.convertResourceEnum(src.getCodeElement()));
        }
        for (StringType t : src.getParam()) {
            tgt.getParam().add(CompartmentDefinition40_50.convertString(t));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(CompartmentDefinition40_50.convertString(src.getDocumentationElement()));
        }
        return tgt;
    }
}

