/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;

public class Claim40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Claim convertClaim(Claim src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Claim tgt = new org.hl7.fhir.r5.model.Claim();
        Claim40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Claim40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Claim40_50.convertClaimStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Claim40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(Claim40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(Claim40_50.convertUse(src.getUseElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Claim40_50.convertReference(src.getPatient()));
        }
        if (src.hasBillablePeriod()) {
            tgt.setBillablePeriod(Claim40_50.convertPeriod(src.getBillablePeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(Claim40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(Claim40_50.convertReference(src.getEnterer()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(Claim40_50.convertReference(src.getInsurer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(Claim40_50.convertReference(src.getProvider()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(Claim40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasFundsReserve()) {
            tgt.setFundsReserve(Claim40_50.convertCodeableConcept(src.getFundsReserve()));
        }
        for (Claim.RelatedClaimComponent relatedClaimComponent : src.getRelated()) {
            tgt.addRelated(Claim40_50.convertRelatedClaimComponent(relatedClaimComponent));
        }
        if (src.hasPrescription()) {
            tgt.setPrescription(Claim40_50.convertReference(src.getPrescription()));
        }
        if (src.hasOriginalPrescription()) {
            tgt.setOriginalPrescription(Claim40_50.convertReference(src.getOriginalPrescription()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(Claim40_50.convertPayeeComponent(src.getPayee()));
        }
        if (src.hasReferral()) {
            tgt.setReferral(Claim40_50.convertReference(src.getReferral()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(Claim40_50.convertReference(src.getFacility()));
        }
        for (Claim.CareTeamComponent careTeamComponent : src.getCareTeam()) {
            tgt.addCareTeam(Claim40_50.convertCareTeamComponent(careTeamComponent));
        }
        for (Claim.SupportingInformationComponent supportingInformationComponent : src.getSupportingInfo()) {
            tgt.addSupportingInfo(Claim40_50.convertSupportingInformationComponent(supportingInformationComponent));
        }
        for (Claim.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(Claim40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (Claim.ProcedureComponent procedureComponent : src.getProcedure()) {
            tgt.addProcedure(Claim40_50.convertProcedureComponent(procedureComponent));
        }
        for (Claim.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(Claim40_50.convertInsuranceComponent(insuranceComponent));
        }
        if (src.hasAccident()) {
            tgt.setAccident(Claim40_50.convertAccidentComponent(src.getAccident()));
        }
        for (Claim.ItemComponent itemComponent : src.getItem()) {
            tgt.addItem(Claim40_50.convertItemComponent(itemComponent));
        }
        if (src.hasTotal()) {
            tgt.setTotal(Claim40_50.convertMoney(src.getTotal()));
        }
        return tgt;
    }

    public static Claim convertClaim(org.hl7.fhir.r5.model.Claim src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim tgt = new Claim();
        Claim40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Claim40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Claim40_50.convertClaimStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(Claim40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(Claim40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(Claim40_50.convertUse(src.getUseElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(Claim40_50.convertReference(src.getPatient()));
        }
        if (src.hasBillablePeriod()) {
            tgt.setBillablePeriod(Claim40_50.convertPeriod(src.getBillablePeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(Claim40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(Claim40_50.convertReference(src.getEnterer()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(Claim40_50.convertReference(src.getInsurer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(Claim40_50.convertReference(src.getProvider()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(Claim40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasFundsReserve()) {
            tgt.setFundsReserve(Claim40_50.convertCodeableConcept(src.getFundsReserve()));
        }
        for (Claim.RelatedClaimComponent relatedClaimComponent : src.getRelated()) {
            tgt.addRelated(Claim40_50.convertRelatedClaimComponent(relatedClaimComponent));
        }
        if (src.hasPrescription()) {
            tgt.setPrescription(Claim40_50.convertReference(src.getPrescription()));
        }
        if (src.hasOriginalPrescription()) {
            tgt.setOriginalPrescription(Claim40_50.convertReference(src.getOriginalPrescription()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(Claim40_50.convertPayeeComponent(src.getPayee()));
        }
        if (src.hasReferral()) {
            tgt.setReferral(Claim40_50.convertReference(src.getReferral()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(Claim40_50.convertReference(src.getFacility()));
        }
        for (Claim.CareTeamComponent careTeamComponent : src.getCareTeam()) {
            tgt.addCareTeam(Claim40_50.convertCareTeamComponent(careTeamComponent));
        }
        for (Claim.SupportingInformationComponent supportingInformationComponent : src.getSupportingInfo()) {
            tgt.addSupportingInfo(Claim40_50.convertSupportingInformationComponent(supportingInformationComponent));
        }
        for (Claim.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(Claim40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (Claim.ProcedureComponent procedureComponent : src.getProcedure()) {
            tgt.addProcedure(Claim40_50.convertProcedureComponent(procedureComponent));
        }
        for (Claim.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(Claim40_50.convertInsuranceComponent(insuranceComponent));
        }
        if (src.hasAccident()) {
            tgt.setAccident(Claim40_50.convertAccidentComponent(src.getAccident()));
        }
        for (Claim.ItemComponent itemComponent : src.getItem()) {
            tgt.addItem(Claim40_50.convertItemComponent(itemComponent));
        }
        if (src.hasTotal()) {
            tgt.setTotal(Claim40_50.convertMoney(src.getTotal()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> convertClaimStatus(Enumeration<Claim.ClaimStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Claim.ClaimStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.FinancialResourceStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Claim.ClaimStatus> convertClaimStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.FinancialResourceStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Claim.ClaimStatus> tgt = new Enumeration<Claim.ClaimStatus>(new Claim.ClaimStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FinancialResourceStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Claim.ClaimStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Claim.ClaimStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)Claim.ClaimStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Claim.ClaimStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Claim.ClaimStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> convertUse(Enumeration<Claim.Use> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.Use>(new Enumerations.UseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Claim.Use)((Object)src.getValue())) {
            case CLAIM: {
                tgt.setValue((Object)Enumerations.Use.CLAIM);
                break;
            }
            case PREAUTHORIZATION: {
                tgt.setValue((Object)Enumerations.Use.PREAUTHORIZATION);
                break;
            }
            case PREDETERMINATION: {
                tgt.setValue((Object)Enumerations.Use.PREDETERMINATION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.Use.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Claim.Use> convertUse(org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Claim.Use> tgt = new Enumeration<Claim.Use>(new Claim.UseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.Use)((Object)src.getValue())) {
            case CLAIM: {
                tgt.setValue((Object)Claim.Use.CLAIM);
                break;
            }
            case PREAUTHORIZATION: {
                tgt.setValue((Object)Claim.Use.PREAUTHORIZATION);
                break;
            }
            case PREDETERMINATION: {
                tgt.setValue((Object)Claim.Use.PREDETERMINATION);
                break;
            }
            default: {
                tgt.setValue((Object)Claim.Use.NULL);
            }
        }
        return tgt;
    }

    public static Claim.RelatedClaimComponent convertRelatedClaimComponent(Claim.RelatedClaimComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.RelatedClaimComponent tgt = new Claim.RelatedClaimComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasClaim()) {
            tgt.setClaim(Claim40_50.convertReference(src.getClaim()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Claim40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasReference()) {
            tgt.setReference(Claim40_50.convertIdentifier(src.getReference()));
        }
        return tgt;
    }

    public static Claim.RelatedClaimComponent convertRelatedClaimComponent(Claim.RelatedClaimComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.RelatedClaimComponent tgt = new Claim.RelatedClaimComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasClaim()) {
            tgt.setClaim(Claim40_50.convertReference(src.getClaim()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(Claim40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasReference()) {
            tgt.setReference(Claim40_50.convertIdentifier(src.getReference()));
        }
        return tgt;
    }

    public static Claim.PayeeComponent convertPayeeComponent(Claim.PayeeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.PayeeComponent tgt = new Claim.PayeeComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Claim40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(Claim40_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Claim.PayeeComponent convertPayeeComponent(Claim.PayeeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.PayeeComponent tgt = new Claim.PayeeComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(Claim40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(Claim40_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Claim.CareTeamComponent convertCareTeamComponent(Claim.CareTeamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.CareTeamComponent tgt = new Claim.CareTeamComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(Claim40_50.convertReference(src.getProvider()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(Claim40_50.convertBoolean(src.getResponsibleElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(Claim40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasQualification()) {
            tgt.setQualification(Claim40_50.convertCodeableConcept(src.getQualification()));
        }
        return tgt;
    }

    public static Claim.CareTeamComponent convertCareTeamComponent(Claim.CareTeamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.CareTeamComponent tgt = new Claim.CareTeamComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(Claim40_50.convertReference(src.getProvider()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(Claim40_50.convertBoolean(src.getResponsibleElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(Claim40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasQualification()) {
            tgt.setQualification(Claim40_50.convertCodeableConcept(src.getQualification()));
        }
        return tgt;
    }

    public static Claim.SupportingInformationComponent convertSupportingInformationComponent(Claim.SupportingInformationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.SupportingInformationComponent tgt = new Claim.SupportingInformationComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(Claim40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(Claim40_50.convertType(src.getTiming()));
        }
        if (src.hasValue()) {
            tgt.setValue(Claim40_50.convertType(src.getValue()));
        }
        if (src.hasReason()) {
            tgt.setReason(Claim40_50.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static Claim.SupportingInformationComponent convertSupportingInformationComponent(Claim.SupportingInformationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.SupportingInformationComponent tgt = new Claim.SupportingInformationComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(Claim40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(Claim40_50.convertType(src.getTiming()));
        }
        if (src.hasValue()) {
            tgt.setValue(Claim40_50.convertType(src.getValue()));
        }
        if (src.hasReason()) {
            tgt.setReason(Claim40_50.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static Claim.DiagnosisComponent convertDiagnosisComponent(Claim.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.DiagnosisComponent tgt = new Claim.DiagnosisComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasDiagnosis()) {
            tgt.setDiagnosis(Claim40_50.convertType(src.getDiagnosis()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(Claim40_50.convertCodeableConcept(t));
        }
        if (src.hasOnAdmission()) {
            tgt.setOnAdmission(Claim40_50.convertCodeableConcept(src.getOnAdmission()));
        }
        if (src.hasPackageCode()) {
            tgt.setPackageCode(Claim40_50.convertCodeableConcept(src.getPackageCode()));
        }
        return tgt;
    }

    public static Claim.DiagnosisComponent convertDiagnosisComponent(Claim.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.DiagnosisComponent tgt = new Claim.DiagnosisComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasDiagnosis()) {
            tgt.setDiagnosis(Claim40_50.convertType(src.getDiagnosis()));
        }
        for (CodeableConcept t : src.getType()) {
            tgt.addType(Claim40_50.convertCodeableConcept(t));
        }
        if (src.hasOnAdmission()) {
            tgt.setOnAdmission(Claim40_50.convertCodeableConcept(src.getOnAdmission()));
        }
        if (src.hasPackageCode()) {
            tgt.setPackageCode(Claim40_50.convertCodeableConcept(src.getPackageCode()));
        }
        return tgt;
    }

    public static Claim.ProcedureComponent convertProcedureComponent(Claim.ProcedureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.ProcedureComponent tgt = new Claim.ProcedureComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Claim40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(Claim40_50.convertType(src.getProcedure()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Claim.ProcedureComponent convertProcedureComponent(Claim.ProcedureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.ProcedureComponent tgt = new Claim.ProcedureComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDate()) {
            tgt.setDateElement(Claim40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(Claim40_50.convertType(src.getProcedure()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Claim.InsuranceComponent convertInsuranceComponent(Claim.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.InsuranceComponent tgt = new Claim.InsuranceComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasFocal()) {
            tgt.setFocalElement(Claim40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Claim40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(Claim40_50.convertReference(src.getCoverage()));
        }
        if (src.hasBusinessArrangement()) {
            tgt.setBusinessArrangementElement(Claim40_50.convertString(src.getBusinessArrangementElement()));
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getPreAuthRef()) {
            tgt.getPreAuthRef().add(Claim40_50.convertString(t));
        }
        if (src.hasClaimResponse()) {
            tgt.setClaimResponse(Claim40_50.convertReference(src.getClaimResponse()));
        }
        return tgt;
    }

    public static Claim.InsuranceComponent convertInsuranceComponent(Claim.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.InsuranceComponent tgt = new Claim.InsuranceComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasFocal()) {
            tgt.setFocalElement(Claim40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(Claim40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(Claim40_50.convertReference(src.getCoverage()));
        }
        if (src.hasBusinessArrangement()) {
            tgt.setBusinessArrangementElement(Claim40_50.convertString(src.getBusinessArrangementElement()));
        }
        for (StringType t : src.getPreAuthRef()) {
            tgt.getPreAuthRef().add(Claim40_50.convertString(t));
        }
        if (src.hasClaimResponse()) {
            tgt.setClaimResponse(Claim40_50.convertReference(src.getClaimResponse()));
        }
        return tgt;
    }

    public static Claim.AccidentComponent convertAccidentComponent(Claim.AccidentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.AccidentComponent tgt = new Claim.AccidentComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDate()) {
            tgt.setDateElement(Claim40_50.convertDate(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(Claim40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Claim40_50.convertType(src.getLocation()));
        }
        return tgt;
    }

    public static Claim.AccidentComponent convertAccidentComponent(Claim.AccidentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.AccidentComponent tgt = new Claim.AccidentComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDate()) {
            tgt.setDateElement(Claim40_50.convertDate(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(Claim40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Claim40_50.convertType(src.getLocation()));
        }
        return tgt;
    }

    public static Claim.ItemComponent convertItemComponent(Claim.ItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.ItemComponent tgt = new Claim.ItemComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (PositiveIntType positiveIntType : src.getCareTeamSequence()) {
            tgt.getCareTeamSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getDiagnosisSequence()) {
            tgt.getDiagnosisSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getProcedureSequence()) {
            tgt.getProcedureSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getInformationSequence()) {
            tgt.getInformationSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(Claim40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(Claim40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(Claim40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Claim40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Claim40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Claim40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Claim40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Claim40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(Claim40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEncounter()) {
            tgt.addEncounter(Claim40_50.convertReference(reference));
        }
        for (Claim.DetailComponent detailComponent : src.getDetail()) {
            tgt.addDetail(Claim40_50.convertDetailComponent(detailComponent));
        }
        return tgt;
    }

    public static Claim.ItemComponent convertItemComponent(Claim.ItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.ItemComponent tgt = new Claim.ItemComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getCareTeamSequence()) {
            tgt.getCareTeamSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getDiagnosisSequence()) {
            tgt.getDiagnosisSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getProcedureSequence()) {
            tgt.getProcedureSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getInformationSequence()) {
            tgt.getInformationSequence().add(Claim40_50.convertPositiveInt(positiveIntType));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(Claim40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(Claim40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(Claim40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(Claim40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Claim40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Claim40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Claim40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Claim40_50.convertMoney(src.getNet()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(Claim40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getEncounter()) {
            tgt.addEncounter(Claim40_50.convertReference(reference));
        }
        for (Claim.DetailComponent detailComponent : src.getDetail()) {
            tgt.addDetail(Claim40_50.convertDetailComponent(detailComponent));
        }
        return tgt;
    }

    public static Claim.DetailComponent convertDetailComponent(Claim.DetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.DetailComponent tgt = new Claim.DetailComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(Claim40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(Claim40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Claim40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Claim40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Claim40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Claim40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        for (Claim.SubDetailComponent subDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(Claim40_50.convertSubDetailComponent(subDetailComponent));
        }
        return tgt;
    }

    public static Claim.DetailComponent convertDetailComponent(Claim.DetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.DetailComponent tgt = new Claim.DetailComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(Claim40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(Claim40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Claim40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Claim40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Claim40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Claim40_50.convertMoney(src.getNet()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        for (Claim.SubDetailComponent subDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(Claim40_50.convertSubDetailComponent(subDetailComponent));
        }
        return tgt;
    }

    public static Claim.SubDetailComponent convertSubDetailComponent(Claim.SubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.SubDetailComponent tgt = new Claim.SubDetailComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(Claim40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(Claim40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Claim40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Claim40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Claim40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Claim40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        return tgt;
    }

    public static Claim.SubDetailComponent convertSubDetailComponent(Claim.SubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Claim.SubDetailComponent tgt = new Claim.SubDetailComponent();
        Claim40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(Claim40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(Claim40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(Claim40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(Claim40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(Claim40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(Claim40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(Claim40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(Claim40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(Claim40_50.convertMoney(src.getNet()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(Claim40_50.convertReference(reference));
        }
        return tgt;
    }
}

