/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ChargeItemDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class ChargeItemDefinition40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ChargeItemDefinition convertChargeItemDefinition(ChargeItemDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ChargeItemDefinition tgt = new org.hl7.fhir.r5.model.ChargeItemDefinition();
        ChargeItemDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ChargeItemDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ChargeItemDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ChargeItemDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ChargeItemDefinition40_50.convertString(src.getTitleElement()));
        }
        for (UriType uriType : src.getDerivedFromUri()) {
            tgt.getDerivedFromUri().add(ChargeItemDefinition40_50.convertUri(uriType));
        }
        for (CanonicalType canonicalType : src.getPartOf()) {
            tgt.getPartOf().add(ChargeItemDefinition40_50.convertCanonical(canonicalType));
        }
        for (CanonicalType canonicalType : src.getReplaces()) {
            tgt.getReplaces().add(ChargeItemDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ChargeItemDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ChargeItemDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ChargeItemDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ChargeItemDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ChargeItemDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ChargeItemDefinition40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ChargeItemDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ChargeItemDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(ChargeItemDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(ChargeItemDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(ChargeItemDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        if (src.hasCode()) {
            tgt.setCode(ChargeItemDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getInstance()) {
            tgt.addInstance(ChargeItemDefinition40_50.convertReference(reference));
        }
        for (ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : src.getApplicability()) {
            tgt.addApplicability(ChargeItemDefinition40_50.convertChargeItemDefinitionApplicabilityComponent(chargeItemDefinitionApplicabilityComponent));
        }
        for (ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent chargeItemDefinitionPropertyGroupComponent : src.getPropertyGroup()) {
            tgt.addPropertyGroup(ChargeItemDefinition40_50.convertChargeItemDefinitionPropertyGroupComponent(chargeItemDefinitionPropertyGroupComponent));
        }
        return tgt;
    }

    public static ChargeItemDefinition convertChargeItemDefinition(org.hl7.fhir.r5.model.ChargeItemDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItemDefinition tgt = new ChargeItemDefinition();
        ChargeItemDefinition40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ChargeItemDefinition40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ChargeItemDefinition40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ChargeItemDefinition40_50.convertString(src.getVersionElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ChargeItemDefinition40_50.convertString(src.getTitleElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getDerivedFromUri()) {
            tgt.getDerivedFromUri().add(ChargeItemDefinition40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getPartOf()) {
            tgt.getPartOf().add(ChargeItemDefinition40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getReplaces()) {
            tgt.getReplaces().add(ChargeItemDefinition40_50.convertCanonical(canonicalType));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ChargeItemDefinition40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ChargeItemDefinition40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ChargeItemDefinition40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ChargeItemDefinition40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ChargeItemDefinition40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ChargeItemDefinition40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ChargeItemDefinition40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ChargeItemDefinition40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDateElement(ChargeItemDefinition40_50.convertDate(src.getApprovalDateElement()));
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDateElement(ChargeItemDefinition40_50.convertDate(src.getLastReviewDateElement()));
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(ChargeItemDefinition40_50.convertPeriod(src.getEffectivePeriod()));
        }
        if (src.hasCode()) {
            tgt.setCode(ChargeItemDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        for (Reference reference : src.getInstance()) {
            tgt.addInstance(ChargeItemDefinition40_50.convertReference(reference));
        }
        for (ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : src.getApplicability()) {
            tgt.addApplicability(ChargeItemDefinition40_50.convertChargeItemDefinitionApplicabilityComponent(chargeItemDefinitionApplicabilityComponent));
        }
        for (ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent chargeItemDefinitionPropertyGroupComponent : src.getPropertyGroup()) {
            tgt.addPropertyGroup(ChargeItemDefinition40_50.convertChargeItemDefinitionPropertyGroupComponent(chargeItemDefinitionPropertyGroupComponent));
        }
        return tgt;
    }

    public static ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent convertChargeItemDefinitionApplicabilityComponent(ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent tgt = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
        ChargeItemDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ChargeItemDefinition40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(ChargeItemDefinition40_50.convertString(src.getLanguageElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(ChargeItemDefinition40_50.convertString(src.getExpressionElement()));
        }
        return tgt;
    }

    public static ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent convertChargeItemDefinitionApplicabilityComponent(ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent tgt = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
        ChargeItemDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ChargeItemDefinition40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguageElement(ChargeItemDefinition40_50.convertString(src.getLanguageElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(ChargeItemDefinition40_50.convertString(src.getExpressionElement()));
        }
        return tgt;
    }

    public static ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent convertChargeItemDefinitionPropertyGroupComponent(ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent tgt = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
        ChargeItemDefinition40_50.copyElement(src, tgt, new String[0]);
        for (ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : src.getApplicability()) {
            tgt.addApplicability(ChargeItemDefinition40_50.convertChargeItemDefinitionApplicabilityComponent(chargeItemDefinitionApplicabilityComponent));
        }
        for (ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent chargeItemDefinitionPropertyGroupPriceComponentComponent : src.getPriceComponent()) {
            tgt.addPriceComponent(ChargeItemDefinition40_50.convertChargeItemDefinitionPropertyGroupPriceComponentComponent(chargeItemDefinitionPropertyGroupPriceComponentComponent));
        }
        return tgt;
    }

    public static ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent convertChargeItemDefinitionPropertyGroupComponent(ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent tgt = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
        ChargeItemDefinition40_50.copyElement(src, tgt, new String[0]);
        for (ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent chargeItemDefinitionApplicabilityComponent : src.getApplicability()) {
            tgt.addApplicability(ChargeItemDefinition40_50.convertChargeItemDefinitionApplicabilityComponent(chargeItemDefinitionApplicabilityComponent));
        }
        for (ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent chargeItemDefinitionPropertyGroupPriceComponentComponent : src.getPriceComponent()) {
            tgt.addPriceComponent(ChargeItemDefinition40_50.convertChargeItemDefinitionPropertyGroupPriceComponentComponent(chargeItemDefinitionPropertyGroupPriceComponentComponent));
        }
        return tgt;
    }

    public static ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent convertChargeItemDefinitionPropertyGroupPriceComponentComponent(ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent tgt = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
        ChargeItemDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ChargeItemDefinition40_50.convertChargeItemDefinitionPriceComponentType(src.getTypeElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ChargeItemDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ChargeItemDefinition40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ChargeItemDefinition40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent convertChargeItemDefinitionPropertyGroupPriceComponentComponent(ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent tgt = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
        ChargeItemDefinition40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setTypeElement(ChargeItemDefinition40_50.convertChargeItemDefinitionPriceComponentType(src.getTypeElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(ChargeItemDefinition40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ChargeItemDefinition40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ChargeItemDefinition40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType> convertChargeItemDefinitionPriceComponentType(Enumeration<ChargeItemDefinition.ChargeItemDefinitionPriceComponentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType>(new Enumerations.InvoicePriceComponentTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ChargeItemDefinition.ChargeItemDefinitionPriceComponentType)((Object)src.getValue())) {
            case BASE: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.BASE);
                break;
            }
            case SURCHARGE: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.SURCHARGE);
                break;
            }
            case DEDUCTION: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.DEDUCTION);
                break;
            }
            case DISCOUNT: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.DISCOUNT);
                break;
            }
            case TAX: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.TAX);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.InvoicePriceComponentType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ChargeItemDefinition.ChargeItemDefinitionPriceComponentType> convertChargeItemDefinitionPriceComponentType(org.hl7.fhir.r5.model.Enumeration<Enumerations.InvoicePriceComponentType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ChargeItemDefinition.ChargeItemDefinitionPriceComponentType> tgt = new Enumeration<ChargeItemDefinition.ChargeItemDefinitionPriceComponentType>(new ChargeItemDefinition.ChargeItemDefinitionPriceComponentTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.InvoicePriceComponentType)((Object)src.getValue())) {
            case BASE: {
                tgt.setValue((Object)ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.BASE);
                break;
            }
            case SURCHARGE: {
                tgt.setValue((Object)ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.SURCHARGE);
                break;
            }
            case DEDUCTION: {
                tgt.setValue((Object)ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.DEDUCTION);
                break;
            }
            case DISCOUNT: {
                tgt.setValue((Object)ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.DISCOUNT);
                break;
            }
            case TAX: {
                tgt.setValue((Object)ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.TAX);
                break;
            }
            case INFORMATIONAL: {
                tgt.setValue((Object)ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.INFORMATIONAL);
                break;
            }
            default: {
                tgt.setValue((Object)ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.NULL);
            }
        }
        return tgt;
    }
}

