/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class CarePlan40_50
extends VersionConvertor_40_50 {
    public static CarePlan convertCarePlan(org.hl7.fhir.r4.model.CarePlan src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan tgt = new CarePlan();
        CarePlan40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CarePlan40_50.convertIdentifier(identifier));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(CarePlan40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(CarePlan40_50.convertUri(uriType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(CarePlan40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReplaces()) {
            tgt.addReplaces(CarePlan40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(CarePlan40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan40_50.convertCarePlanStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(CarePlan40_50.convertCarePlanIntent(src.getIntentElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(CarePlan40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(CarePlan40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CarePlan40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(CarePlan40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(CarePlan40_50.convertReference(src.getEncounter()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(CarePlan40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(CarePlan40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(CarePlan40_50.convertReference(src.getAuthor()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getContributor()) {
            tgt.addContributor(CarePlan40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getCareTeam()) {
            tgt.addCareTeam(CarePlan40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAddresses()) {
            tgt.addAddresses(CarePlan40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(CarePlan40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getGoal()) {
            tgt.addGoal(CarePlan40_50.convertReference(reference));
        }
        for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : src.getActivity()) {
            tgt.addActivity(CarePlan40_50.convertCarePlanActivityComponent(carePlanActivityComponent));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(CarePlan40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CarePlan convertCarePlan(CarePlan src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CarePlan tgt = new org.hl7.fhir.r4.model.CarePlan();
        CarePlan40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(CarePlan40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(CarePlan40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(CarePlan40_50.convertUri(uriType));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(CarePlan40_50.convertReference(reference));
        }
        for (Reference reference : src.getReplaces()) {
            tgt.addReplaces(CarePlan40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(CarePlan40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan40_50.convertCarePlanStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(CarePlan40_50.convertCarePlanIntent(src.getIntentElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(CarePlan40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(CarePlan40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CarePlan40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(CarePlan40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(CarePlan40_50.convertReference(src.getEncounter()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(CarePlan40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(CarePlan40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(CarePlan40_50.convertReference(src.getAuthor()));
        }
        for (Reference reference : src.getContributor()) {
            tgt.addContributor(CarePlan40_50.convertReference(reference));
        }
        for (Reference reference : src.getCareTeam()) {
            tgt.addCareTeam(CarePlan40_50.convertReference(reference));
        }
        for (CodeableReference codeableReference : src.getAddresses()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addAddresses(CarePlan40_50.convertReference(codeableReference.getReference()));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(CarePlan40_50.convertReference(reference));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(CarePlan40_50.convertReference(reference));
        }
        for (CarePlan.CarePlanActivityComponent carePlanActivityComponent : src.getActivity()) {
            tgt.addActivity(CarePlan40_50.convertCarePlanActivityComponent(carePlanActivityComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(CarePlan40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> convertCarePlanStatus(Enumeration<CarePlan.CarePlanStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus>(new Enumerations.RequestStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.RequestStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.RequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Enumerations.RequestStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)Enumerations.RequestStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.RequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.RequestStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.RequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanStatus> convertCarePlanStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.RequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CarePlan.CarePlanStatus> tgt = new Enumeration<CarePlan.CarePlanStatus>(new CarePlan.CarePlanStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ONHOLD);
                break;
            }
            case REVOKED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.REVOKED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanIntent> convertCarePlanIntent(Enumeration<CarePlan.CarePlanIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanIntent> tgt = new org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanIntent>(new CarePlan.CarePlanIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.ORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanIntent> convertCarePlanIntent(org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CarePlan.CarePlanIntent> tgt = new Enumeration<CarePlan.CarePlanIntent>(new CarePlan.CarePlanIntentEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.ORDER);
                break;
            }
            case OPTION: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.OPTION);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanIntent.NULL);
            }
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        CarePlan40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getOutcomeCodeableConcept()) {
            tgt.addOutcome(CarePlan40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getOutcomeReference()) {
            tgt.addOutcome(CarePlan40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getProgress()) {
            tgt.addProgress(CarePlan40_50.convertAnnotation(annotation));
        }
        if (src.hasReference()) {
            tgt.setReference(CarePlan40_50.convertReference(src.getReference()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(CarePlan40_50.convertCarePlanActivityDetailComponent(src.getDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        CarePlan40_50.copyElement(src, tgt, new String[0]);
        for (CodeableReference codeableReference : src.getOutcome()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addOutcomeCodeableConcept(CarePlan40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getOutcome()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addOutcomeReference(CarePlan40_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getProgress()) {
            tgt.addProgress(CarePlan40_50.convertAnnotation(annotation));
        }
        if (src.hasReference()) {
            tgt.setReference(CarePlan40_50.convertReference(src.getReference()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(CarePlan40_50.convertCarePlanActivityDetailComponent(src.getDetail()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        CarePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(CarePlan40_50.convertCarePlanActivityKind(src.getKindElement()));
        }
        for (CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(CarePlan40_50.convertCanonical(canonicalType));
        }
        for (UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(CarePlan40_50.convertUri(uriType));
        }
        if (src.hasCode()) {
            tgt.setCode(CarePlan40_50.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(CarePlan40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getReasonReference()) {
            tgt.addReason(CarePlan40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getGoal()) {
            tgt.addGoal(CarePlan40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan40_50.convertCarePlanActivityStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(CarePlan40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(CarePlan40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasScheduled()) {
            tgt.setScheduled(CarePlan40_50.convertType(src.getScheduled()));
        }
        if (src.hasLocation()) {
            tgt.getLocation().setReference(CarePlan40_50.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(CarePlan40_50.convertReference(reference));
        }
        if (src.hasProduct()) {
            tgt.setProduct(CarePlan40_50.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount()) {
            tgt.setDailyAmount(CarePlan40_50.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(CarePlan40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CarePlan40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        CarePlan40_50.copyElement(src, tgt, new String[0]);
        if (src.hasKind()) {
            tgt.setKindElement(CarePlan40_50.convertCarePlanActivityKind(src.getKindElement()));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getInstantiatesCanonical()) {
            tgt.getInstantiatesCanonical().add(CarePlan40_50.convertCanonical(canonicalType));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getInstantiatesUri()) {
            tgt.getInstantiatesUri().add(CarePlan40_50.convertUri(uriType));
        }
        if (src.hasCode()) {
            tgt.setCode(CarePlan40_50.convertCodeableConcept(src.getCode()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(CarePlan40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(CarePlan40_50.convertReference(codeableReference.getReference()));
        }
        for (Reference reference : src.getGoal()) {
            tgt.addGoal(CarePlan40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CarePlan40_50.convertCarePlanActivityStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(CarePlan40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasDoNotPerform()) {
            tgt.setDoNotPerformElement(CarePlan40_50.convertBoolean(src.getDoNotPerformElement()));
        }
        if (src.hasScheduled()) {
            tgt.setScheduled(CarePlan40_50.convertType(src.getScheduled()));
        }
        if (src.getLocation().hasReference()) {
            tgt.setLocation(CarePlan40_50.convertReference(src.getLocation().getReference()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(CarePlan40_50.convertReference(reference));
        }
        if (src.hasProduct()) {
            tgt.setProduct(CarePlan40_50.convertType(src.getProduct()));
        }
        if (src.hasDailyAmount()) {
            tgt.setDailyAmount(CarePlan40_50.convertSimpleQuantity(src.getDailyAmount()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(CarePlan40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(CarePlan40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityKind> convertCarePlanActivityKind(Enumeration<CarePlan.CarePlanActivityKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityKind> tgt = new org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityKind>(new CarePlan.CarePlanActivityKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityKind)((Object)src.getValue())) {
            case APPOINTMENT: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.APPOINTMENT);
                break;
            }
            case COMMUNICATIONREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.COMMUNICATIONREQUEST);
                break;
            }
            case DEVICEREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.DEVICEREQUEST);
                break;
            }
            case MEDICATIONREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.MEDICATIONREQUEST);
                break;
            }
            case NUTRITIONORDER: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.NUTRITIONORDER);
                break;
            }
            case TASK: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.TASK);
                break;
            }
            case SERVICEREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.SERVICEREQUEST);
                break;
            }
            case VISIONPRESCRIPTION: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.VISIONPRESCRIPTION);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanActivityKind> convertCarePlanActivityKind(org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CarePlan.CarePlanActivityKind> tgt = new Enumeration<CarePlan.CarePlanActivityKind>(new CarePlan.CarePlanActivityKindEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityKind)((Object)src.getValue())) {
            case APPOINTMENT: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.APPOINTMENT);
                break;
            }
            case COMMUNICATIONREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.COMMUNICATIONREQUEST);
                break;
            }
            case DEVICEREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.DEVICEREQUEST);
                break;
            }
            case MEDICATIONREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.MEDICATIONREQUEST);
                break;
            }
            case NUTRITIONORDER: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.NUTRITIONORDER);
                break;
            }
            case TASK: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.TASK);
                break;
            }
            case SERVICEREQUEST: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.SERVICEREQUEST);
                break;
            }
            case VISIONPRESCRIPTION: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.VISIONPRESCRIPTION);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityKind.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus>(new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityStatus)((Object)src.getValue())) {
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.UNKNOWN);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CarePlan.CarePlanActivityStatus> convertCarePlanActivityStatus(org.hl7.fhir.r5.model.Enumeration<CarePlan.CarePlanActivityStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CarePlan.CarePlanActivityStatus> tgt = new Enumeration<CarePlan.CarePlanActivityStatus>(new CarePlan.CarePlanActivityStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((CarePlan.CarePlanActivityStatus)((Object)src.getValue())) {
            case NOTSTARTED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NOTSTARTED);
                break;
            }
            case SCHEDULED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.SCHEDULED);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.CANCELLED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.STOPPED);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.UNKNOWN);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CarePlan.CarePlanActivityStatus.NULL);
            }
        }
        return tgt;
    }
}

