/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.Reference;

public class BiologicallyDerivedProduct40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.BiologicallyDerivedProduct convertBiologicallyDerivedProduct(BiologicallyDerivedProduct src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.BiologicallyDerivedProduct tgt = new org.hl7.fhir.r5.model.BiologicallyDerivedProduct();
        BiologicallyDerivedProduct40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(BiologicallyDerivedProduct40_50.convertIdentifier(identifier));
        }
        if (src.hasProductCategory()) {
            tgt.setProductCategoryElement(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductCategory(src.getProductCategoryElement()));
        }
        if (src.hasProductCode()) {
            tgt.setProductCode(BiologicallyDerivedProduct40_50.convertCodeableConcept(src.getProductCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRequest()) {
            tgt.addRequest(BiologicallyDerivedProduct40_50.convertReference(reference));
        }
        if (src.hasQuantity()) {
            tgt.setQuantityElement(BiologicallyDerivedProduct40_50.convertInteger(src.getQuantityElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getParent()) {
            tgt.addParent(BiologicallyDerivedProduct40_50.convertReference(reference));
        }
        if (src.hasCollection()) {
            tgt.setCollection(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductCollectionComponent(src.getCollection()));
        }
        for (BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent biologicallyDerivedProductProcessingComponent : src.getProcessing()) {
            tgt.addProcessing(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductProcessingComponent(biologicallyDerivedProductProcessingComponent));
        }
        if (src.hasManipulation()) {
            tgt.setManipulation(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductManipulationComponent(src.getManipulation()));
        }
        for (BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent biologicallyDerivedProductStorageComponent : src.getStorage()) {
            tgt.addStorage(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductStorageComponent(biologicallyDerivedProductStorageComponent));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct convertBiologicallyDerivedProduct(org.hl7.fhir.r5.model.BiologicallyDerivedProduct src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct tgt = new BiologicallyDerivedProduct();
        BiologicallyDerivedProduct40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(BiologicallyDerivedProduct40_50.convertIdentifier(identifier));
        }
        if (src.hasProductCategory()) {
            tgt.setProductCategoryElement(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductCategory(src.getProductCategoryElement()));
        }
        if (src.hasProductCode()) {
            tgt.setProductCode(BiologicallyDerivedProduct40_50.convertCodeableConcept(src.getProductCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductStatus(src.getStatusElement()));
        }
        for (Reference reference : src.getRequest()) {
            tgt.addRequest(BiologicallyDerivedProduct40_50.convertReference(reference));
        }
        if (src.hasQuantity()) {
            tgt.setQuantityElement(BiologicallyDerivedProduct40_50.convertInteger(src.getQuantityElement()));
        }
        for (Reference reference : src.getParent()) {
            tgt.addParent(BiologicallyDerivedProduct40_50.convertReference(reference));
        }
        if (src.hasCollection()) {
            tgt.setCollection(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductCollectionComponent(src.getCollection()));
        }
        for (BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent biologicallyDerivedProductProcessingComponent : src.getProcessing()) {
            tgt.addProcessing(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductProcessingComponent(biologicallyDerivedProductProcessingComponent));
        }
        if (src.hasManipulation()) {
            tgt.setManipulation(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductManipulationComponent(src.getManipulation()));
        }
        for (BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent biologicallyDerivedProductStorageComponent : src.getStorage()) {
            tgt.addStorage(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductStorageComponent(biologicallyDerivedProductStorageComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory> convertBiologicallyDerivedProductCategory(Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory> tgt = new org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory>(new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((BiologicallyDerivedProduct.BiologicallyDerivedProductCategory)((Object)src.getValue())) {
            case ORGAN: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.ORGAN);
                break;
            }
            case TISSUE: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.TISSUE);
                break;
            }
            case FLUID: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.FLUID);
                break;
            }
            case CELLS: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.CELLS);
                break;
            }
            case BIOLOGICALAGENT: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.BIOLOGICALAGENT);
                break;
            }
            default: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory> convertBiologicallyDerivedProductCategory(org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory> tgt = new Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductCategory>(new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((BiologicallyDerivedProduct.BiologicallyDerivedProductCategory)((Object)src.getValue())) {
            case ORGAN: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.ORGAN);
                break;
            }
            case TISSUE: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.TISSUE);
                break;
            }
            case FLUID: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.FLUID);
                break;
            }
            case CELLS: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.CELLS);
                break;
            }
            case BIOLOGICALAGENT: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.BIOLOGICALAGENT);
                break;
            }
            default: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus> convertBiologicallyDerivedProductStatus(Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus>(new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((BiologicallyDerivedProduct.BiologicallyDerivedProductStatus)((Object)src.getValue())) {
            case AVAILABLE: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.AVAILABLE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.UNAVAILABLE);
                break;
            }
            default: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus> convertBiologicallyDerivedProductStatus(org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus> tgt = new Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStatus>(new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((BiologicallyDerivedProduct.BiologicallyDerivedProductStatus)((Object)src.getValue())) {
            case AVAILABLE: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.AVAILABLE);
                break;
            }
            case UNAVAILABLE: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.UNAVAILABLE);
                break;
            }
            default: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL);
            }
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent convertBiologicallyDerivedProductCollectionComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCollector()) {
            tgt.setCollector(BiologicallyDerivedProduct40_50.convertReference(src.getCollector()));
        }
        if (src.hasSource()) {
            tgt.setSource(BiologicallyDerivedProduct40_50.convertReference(src.getSource()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(BiologicallyDerivedProduct40_50.convertType(src.getCollected()));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent convertBiologicallyDerivedProductCollectionComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCollector()) {
            tgt.setCollector(BiologicallyDerivedProduct40_50.convertReference(src.getCollector()));
        }
        if (src.hasSource()) {
            tgt.setSource(BiologicallyDerivedProduct40_50.convertReference(src.getSource()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(BiologicallyDerivedProduct40_50.convertType(src.getCollected()));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent convertBiologicallyDerivedProductProcessingComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BiologicallyDerivedProduct40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(BiologicallyDerivedProduct40_50.convertCodeableConcept(src.getProcedure()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(BiologicallyDerivedProduct40_50.convertReference(src.getAdditive()));
        }
        if (src.hasTime()) {
            tgt.setTime(BiologicallyDerivedProduct40_50.convertType(src.getTime()));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent convertBiologicallyDerivedProductProcessingComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BiologicallyDerivedProduct40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(BiologicallyDerivedProduct40_50.convertCodeableConcept(src.getProcedure()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(BiologicallyDerivedProduct40_50.convertReference(src.getAdditive()));
        }
        if (src.hasTime()) {
            tgt.setTime(BiologicallyDerivedProduct40_50.convertType(src.getTime()));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent convertBiologicallyDerivedProductManipulationComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BiologicallyDerivedProduct40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTime()) {
            tgt.setTime(BiologicallyDerivedProduct40_50.convertType(src.getTime()));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent convertBiologicallyDerivedProductManipulationComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BiologicallyDerivedProduct40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTime()) {
            tgt.setTime(BiologicallyDerivedProduct40_50.convertType(src.getTime()));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent convertBiologicallyDerivedProductStorageComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BiologicallyDerivedProduct40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTemperature()) {
            tgt.setTemperatureElement(BiologicallyDerivedProduct40_50.convertDecimal(src.getTemperatureElement()));
        }
        if (src.hasScale()) {
            tgt.setScaleElement(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductStorageScale(src.getScaleElement()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(BiologicallyDerivedProduct40_50.convertPeriod(src.getDuration()));
        }
        return tgt;
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent convertBiologicallyDerivedProductStorageComponent(BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent tgt = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
        BiologicallyDerivedProduct40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDescription()) {
            tgt.setDescriptionElement(BiologicallyDerivedProduct40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasTemperature()) {
            tgt.setTemperatureElement(BiologicallyDerivedProduct40_50.convertDecimal(src.getTemperatureElement()));
        }
        if (src.hasScale()) {
            tgt.setScaleElement(BiologicallyDerivedProduct40_50.convertBiologicallyDerivedProductStorageScale(src.getScaleElement()));
        }
        if (src.hasDuration()) {
            tgt.setDuration(BiologicallyDerivedProduct40_50.convertPeriod(src.getDuration()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale> convertBiologicallyDerivedProductStorageScale(Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale> tgt = new org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale>(new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale)((Object)src.getValue())) {
            case FARENHEIT: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.FARENHEIT);
                break;
            }
            case CELSIUS: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.CELSIUS);
                break;
            }
            case KELVIN: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.KELVIN);
                break;
            }
            default: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale> convertBiologicallyDerivedProductStorageScale(org.hl7.fhir.r5.model.Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale> tgt = new Enumeration<BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale>(new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale)((Object)src.getValue())) {
            case FARENHEIT: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.FARENHEIT);
                break;
            }
            case CELSIUS: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.CELSIUS);
                break;
            }
            case KELVIN: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.KELVIN);
                break;
            }
            default: {
                tgt.setValue((Object)BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL);
            }
        }
        return tgt;
    }
}

