/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ValueSet;

public class ValueSet30_50 {
    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet30_50.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(ValueSet30_50.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_50.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguageElement(VersionConvertor_30_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_50.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet30_50.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet30_50.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        for (UriType uriType : src.getValueSet()) {
            tgt.addValueSet((String)uriType.getValue());
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : src.getConcept()) {
            tgt.addConcept(ValueSet30_50.convertConceptReferenceComponent(conceptReferenceComponent));
        }
        for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : src.getFilter()) {
            tgt.addFilter(ValueSet30_50.convertConceptSetFilterComponent(conceptSetFilterComponent));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getValueSet()) {
            tgt.addValueSet((String)uriType.getValue());
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(VersionConvertor_30_50.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(ValueSet30_50.convertFilterOperator2(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(VersionConvertor_30_50.convertCode(src.getPropertyElement()));
        }
        if (src.hasOp()) {
            tgt.setOpElement(VersionConvertor_30_50.convertFilterOperator(src.getOpElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ValueSet.FilterOperator> convertFilterOperator2(Enumeration<Enumerations.FilterOperator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ValueSet.FilterOperator> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ValueSet.FilterOperator>(new ValueSet.FilterOperatorEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.FilterOperator)((Object)src.getValue())) {
            case EQUAL: {
                tgt.setValue((Object)ValueSet.FilterOperator.EQUAL);
                break;
            }
            case ISA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISA);
                break;
            }
            case DESCENDENTOF: {
                tgt.setValue((Object)ValueSet.FilterOperator.DESCENDENTOF);
                break;
            }
            case ISNOTA: {
                tgt.setValue((Object)ValueSet.FilterOperator.ISNOTA);
                break;
            }
            case REGEX: {
                tgt.setValue((Object)ValueSet.FilterOperator.REGEX);
                break;
            }
            case IN: {
                tgt.setValue((Object)ValueSet.FilterOperator.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)ValueSet.FilterOperator.NOTIN);
                break;
            }
            case GENERALIZES: {
                tgt.setValue((Object)ValueSet.FilterOperator.GENERALIZES);
                break;
            }
            case EXISTS: {
                tgt.setValue((Object)ValueSet.FilterOperator.EXISTS);
                break;
            }
            default: {
                tgt.setValue((Object)ValueSet.FilterOperator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.ValueSet convertValueSet(ValueSet src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ValueSet tgt = new org.hl7.fhir.r5.model.ValueSet();
        VersionConvertor_30_50.copyDomainResource(src, tgt, "http://hl7.org/fhir/StructureDefinition/valueset-extensible");
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasImmutable()) {
            tgt.setImmutableElement(VersionConvertor_30_50.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasExtensible()) {
            tgt.addExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible", new BooleanType(src.getExtensible()));
        }
        if (src.hasCompose()) {
            tgt.setCompose(ValueSet30_50.convertValueSetComposeComponent(src.getCompose()));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet30_50.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static ValueSet convertValueSet(org.hl7.fhir.r5.model.ValueSet src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet tgt = new ValueSet();
        VersionConvertor_30_50.copyDomainResource(src, tgt, "http://hl7.org/fhir/StructureDefinition/valueset-extensible");
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasImmutable()) {
            tgt.setImmutableElement(VersionConvertor_30_50.convertBoolean(src.getImmutableElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible")) {
            tgt.setExtensible(((BooleanType)src.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/valueset-extensible").getValue()).booleanValue());
        }
        if (src.hasCompose()) {
            tgt.setCompose(ValueSet30_50.convertValueSetComposeComponent(src.getCompose()));
        }
        if (src.hasExpansion()) {
            tgt.setExpansion(ValueSet30_50.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLockedDate()) {
            tgt.setLockedDateElement(VersionConvertor_30_50.convertDate(src.getLockedDateElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(VersionConvertor_30_50.convertBoolean(src.getInactiveElement()));
        }
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            tgt.addInclude(ValueSet30_50.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(ValueSet30_50.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLockedDate()) {
            tgt.setLockedDateElement(VersionConvertor_30_50.convertDate(src.getLockedDateElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(VersionConvertor_30_50.convertBoolean(src.getInactiveElement()));
        }
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            tgt.addInclude(ValueSet30_50.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(ValueSet30_50.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(VersionConvertor_30_50.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestamp()) {
            tgt.setTimestampElement(VersionConvertor_30_50.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(VersionConvertor_30_50.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_30_50.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet30_50.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet30_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifierElement(VersionConvertor_30_50.convertUri(src.getIdentifierElement()));
        }
        if (src.hasTimestamp()) {
            tgt.setTimestampElement(VersionConvertor_30_50.convertDateTime(src.getTimestampElement()));
        }
        if (src.hasTotal()) {
            tgt.setTotalElement(VersionConvertor_30_50.convertInteger(src.getTotalElement()));
        }
        if (src.hasOffset()) {
            tgt.setOffsetElement(VersionConvertor_30_50.convertInteger(src.getOffsetElement()));
        }
        for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : src.getParameter()) {
            tgt.addParameter(ValueSet30_50.convertValueSetExpansionParameterComponent(valueSetExpansionParameterComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet30_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(VersionConvertor_30_50.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(VersionConvertor_30_50.convertBoolean(src.getInactiveElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent conceptReferenceDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(ValueSet30_50.convertConceptReferenceDesignationComponent(conceptReferenceDesignationComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet30_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertUri(src.getSystemElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(VersionConvertor_30_50.convertBoolean(src.getAbstractElement()));
        }
        if (src.hasInactive()) {
            tgt.setInactiveElement(VersionConvertor_30_50.convertBoolean(src.getInactiveElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        for (ValueSet.ConceptReferenceDesignationComponent conceptReferenceDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(ValueSet30_50.convertConceptReferenceDesignationComponent(conceptReferenceDesignationComponent));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : src.getContains()) {
            tgt.addContains(ValueSet30_50.convertValueSetExpansionContainsComponent(valueSetExpansionContainsComponent));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_50.convertType(src.getValue()));
        }
        return tgt;
    }
}

