/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Slot;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Slot;

public class Slot30_50 {
    public static org.hl7.fhir.r5.model.Slot convertSlot(Slot src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Slot tgt = new org.hl7.fhir.r5.model.Slot();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasServiceCategory()) {
            tgt.addServiceCategory(VersionConvertor_30_50.convertCodeableConcept(src.getServiceCategory()));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_50.convertCodeableConcept(src.getAppointmentType()));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(VersionConvertor_30_50.convertReference(src.getSchedule()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Slot30_50.convertSlotStatus(src.getStatusElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_50.convertInstant(src.getEndElement()));
        }
        if (src.hasOverbooked()) {
            tgt.setOverbookedElement(VersionConvertor_30_50.convertBoolean(src.getOverbookedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static Slot convertSlot(org.hl7.fhir.r5.model.Slot src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Slot tgt = new Slot();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasServiceCategory()) {
            tgt.setServiceCategory(VersionConvertor_30_50.convertCodeableConcept(src.getServiceCategoryFirstRep()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_50.convertCodeableConcept(src.getAppointmentType()));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(VersionConvertor_30_50.convertReference(src.getSchedule()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Slot30_50.convertSlotStatus(src.getStatusElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(VersionConvertor_30_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(VersionConvertor_30_50.convertInstant(src.getEndElement()));
        }
        if (src.hasOverbooked()) {
            tgt.setOverbookedElement(VersionConvertor_30_50.convertBoolean(src.getOverbookedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Slot.SlotStatus> convertSlotStatus(Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Slot.SlotStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Slot.SlotStatus>(new Slot.SlotStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Slot.SlotStatus)((Object)src.getValue())) {
            case BUSY: {
                tgt.setValue((Object)Slot.SlotStatus.BUSY);
                break;
            }
            case FREE: {
                tgt.setValue((Object)Slot.SlotStatus.FREE);
                break;
            }
            case BUSYUNAVAILABLE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                break;
            }
            case BUSYTENTATIVE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Slot.SlotStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Slot.SlotStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Slot.SlotStatus> convertSlotStatus(org.hl7.fhir.dstu3.model.Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Slot.SlotStatus> tgt = new Enumeration<Slot.SlotStatus>(new Slot.SlotStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Slot.SlotStatus)((Object)src.getValue())) {
            case BUSY: {
                tgt.setValue((Object)Slot.SlotStatus.BUSY);
                break;
            }
            case FREE: {
                tgt.setValue((Object)Slot.SlotStatus.FREE);
                break;
            }
            case BUSYUNAVAILABLE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                break;
            }
            case BUSYTENTATIVE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Slot.SlotStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Slot.SlotStatus.NULL);
            }
        }
        return tgt;
    }
}

