/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.StringType;

public class OperationDefinition30_50 {
    public static org.hl7.fhir.r5.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.OperationDefinition tgt = new org.hl7.fhir.r5.model.OperationDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition30_50.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasIdempotent()) {
            tgt.setAffectsState(!src.getIdempotent());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getBase()));
        }
        for (CodeType codeType : src.getResource()) {
            tgt.addResource((String)codeType.getValue());
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertBoolean(src.getSystemElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertBoolean(src.getTypeElement()));
        }
        if (src.hasInstance()) {
            tgt.setInstanceElement(VersionConvertor_30_50.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition30_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        for (OperationDefinition.OperationDefinitionOverloadComponent operationDefinitionOverloadComponent : src.getOverload()) {
            tgt.addOverload(OperationDefinition30_50.convertOperationDefinitionOverloadComponent(operationDefinitionOverloadComponent));
        }
        return tgt;
    }

    public static OperationDefinition convertOperationDefinition(org.hl7.fhir.r5.model.OperationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(OperationDefinition30_50.convertOperationKind(src.getKindElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasAffectsState()) {
            tgt.setIdempotent(!src.getAffectsState());
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_50.convertCanonicalToReference(src.getBaseElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getResource()) {
            tgt.addResource((String)codeType.getValue());
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_30_50.convertBoolean(src.getSystemElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertBoolean(src.getTypeElement()));
        }
        if (src.hasInstance()) {
            tgt.setInstanceElement(VersionConvertor_30_50.convertBoolean(src.getInstanceElement()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getParameter()) {
            tgt.addParameter(OperationDefinition30_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        for (OperationDefinition.OperationDefinitionOverloadComponent operationDefinitionOverloadComponent : src.getOverload()) {
            tgt.addOverload(OperationDefinition30_50.convertOperationDefinitionOverloadComponent(operationDefinitionOverloadComponent));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionOverloadComponent convertOperationDefinitionOverloadComponent(OperationDefinition.OperationDefinitionOverloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionOverloadComponent tgt = new OperationDefinition.OperationDefinitionOverloadComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (StringType t : src.getParameterName()) {
            tgt.addParameterName((String)t.getValue());
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionOverloadComponent convertOperationDefinitionOverloadComponent(OperationDefinition.OperationDefinitionOverloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionOverloadComponent tgt = new OperationDefinition.OperationDefinitionOverloadComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu3.model.StringType t : src.getParameterName()) {
            tgt.addParameterName((String)t.getValue());
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_30_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            DataType t = VersionConvertor_30_50.convertType(src.getValueSet());
            if (t instanceof org.hl7.fhir.r5.model.Reference) {
                tgt.setValueSet(((org.hl7.fhir.r5.model.Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_30_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet(new UriType(vsr));
            } else {
                tgt.setValueSet(new Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition30_50.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setType(Enumerations.FHIRAllTypes.fromCode(src.getType()));
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(VersionConvertor_30_50.convertSearchParamType(src.getSearchTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.addTargetProfile(src.getProfile().getReference());
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition30_50.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(OperationDefinition30_50.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertCode(src.getNameElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(OperationDefinition30_50.convertOperationParameterUse(src.getUseElement()));
        }
        if (src.hasMin()) {
            tgt.setMinElement(VersionConvertor_30_50.convertInteger(src.getMinElement()));
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_30_50.convertString(src.getMaxElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentationElement(VersionConvertor_30_50.convertString(src.getDocumentationElement()));
        }
        if (src.hasType()) {
            tgt.setType(src.getType().toCode());
        }
        if (src.hasSearchType()) {
            tgt.setSearchTypeElement(VersionConvertor_30_50.convertSearchParamType(src.getSearchTypeElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getTargetProfile()) {
            tgt.setProfile(new Reference((String)uriType.getValue()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(OperationDefinition30_50.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent operationDefinitionParameterComponent : src.getPart()) {
            tgt.addPart(OperationDefinition30_50.convertOperationDefinitionParameterComponent(operationDefinitionParameterComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationKind> convertOperationKind(Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationKind> tgt = new org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<OperationDefinition.OperationKind> convertOperationKind(org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<OperationDefinition.OperationKind> tgt = new Enumeration<OperationDefinition.OperationKind>(new OperationDefinition.OperationKindEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationKind)((Object)src.getValue())) {
            case OPERATION: {
                tgt.setValue((Object)OperationDefinition.OperationKind.OPERATION);
                break;
            }
            case QUERY: {
                tgt.setValue((Object)OperationDefinition.OperationKind.QUERY);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.OperationParameterUse> convertOperationParameterUse(org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.OperationParameterUse> tgt = new Enumeration<Enumerations.OperationParameterUse>(new Enumerations.OperationParameterUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((OperationDefinition.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationParameterUse> convertOperationParameterUse(Enumeration<Enumerations.OperationParameterUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationParameterUse> tgt = new org.hl7.fhir.dstu3.model.Enumeration<OperationDefinition.OperationParameterUse>(new OperationDefinition.OperationParameterUseEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.OperationParameterUse)((Object)src.getValue())) {
            case IN: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.IN);
                break;
            }
            case OUT: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.OUT);
                break;
            }
            default: {
                tgt.setValue((Object)OperationDefinition.OperationParameterUse.NULL);
            }
        }
        return tgt;
    }
}

