/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.MedicationRequest;

public class MedicationRequest30_50 {
    public static org.hl7.fhir.dstu3.model.MedicationRequest convertMedicationRequest(MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.MedicationRequest tgt = new org.hl7.fhir.dstu3.model.MedicationRequest();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(VersionConvertor_30_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationRequest30_50.convertMedicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(MedicationRequest30_50.convertMedicationRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(MedicationRequest30_50.convertMedicationRequestPriority(src.getPriorityElement()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(VersionConvertor_30_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_50.convertReference(src.getRecorder()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (codeableReference.hasConcept()) {
                tgt.addReasonCode(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
            }
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(VersionConvertor_30_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r5.model.Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_50.convertDosage(dosage));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(MedicationRequest30_50.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationRequest30_50.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(VersionConvertor_30_50.convertReference(src.getPriorPrescription()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationRequest convertMedicationRequest(org.hl7.fhir.dstu3.model.MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest tgt = new MedicationRequest();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(VersionConvertor_30_50.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationRequest30_50.convertMedicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasIntent()) {
            tgt.setIntentElement(MedicationRequest30_50.convertMedicationRequestIntent(src.getIntentElement()));
        }
        if (src.hasPriority()) {
            tgt.setPriorityElement(MedicationRequest30_50.convertMedicationRequestPriority(src.getPriorityElement()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(VersionConvertor_30_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(VersionConvertor_30_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getContext()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOnElement(VersionConvertor_30_50.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_50.convertReference(src.getRecorder()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(new CodeableReference().setConcept(VersionConvertor_30_50.convertCodeableConcept(codeableConcept)));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(new CodeableReference().setReference(VersionConvertor_30_50.convertReference(reference)));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_50.convertDosage(dosage));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(MedicationRequest30_50.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationRequest30_50.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(VersionConvertor_30_50.convertReference(src.getPriorPrescription()));
        }
        for (Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_50.convertReference(reference));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(VersionConvertor_30_50.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowed(src.getNumberOfRepeatsAllowed());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(VersionConvertor_30_50.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasPerformer()) {
            tgt.setDispenser(VersionConvertor_30_50.convertReference(src.getPerformer()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(VersionConvertor_30_50.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowed(src.getNumberOfRepeatsAllowed());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(VersionConvertor_30_50.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasDispenser()) {
            tgt.setPerformer(VersionConvertor_30_50.convertReference(src.getDispenser()));
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationRequestIntent> convertMedicationRequestIntent(org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationRequestIntent> tgt = new Enumeration<MedicationRequest.MedicationRequestIntent>(new MedicationRequest.MedicationRequestIntentEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.INSTANCEORDER);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent> convertMedicationRequestIntent(Enumeration<MedicationRequest.MedicationRequestIntent> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestIntent>(new MedicationRequest.MedicationRequestIntentEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestIntent)((Object)src.getValue())) {
            case PROPOSAL: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PROPOSAL);
                break;
            }
            case PLAN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.PLAN);
                break;
            }
            case ORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.ORDER);
                break;
            }
            case INSTANCEORDER: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.INSTANCEORDER);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestIntent.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.RequestPriority> convertMedicationRequestPriority(org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.RequestPriority> tgt = new Enumeration<Enumerations.RequestPriority>(new Enumerations.RequestPriorityEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)Enumerations.RequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)Enumerations.RequestPriority.URGENT);
                break;
            }
            case STAT: {
                tgt.setValue((Object)Enumerations.RequestPriority.STAT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)Enumerations.RequestPriority.ASAP);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.RequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority> convertMedicationRequestPriority(Enumeration<Enumerations.RequestPriority> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestPriority>(new MedicationRequest.MedicationRequestPriorityEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.RequestPriority)((Object)src.getValue())) {
            case ROUTINE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ROUTINE);
                break;
            }
            case URGENT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.URGENT);
                break;
            }
            case STAT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.STAT);
                break;
            }
            case ASAP: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.ASAP);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestPriority.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationRequest.MedicationrequestStatus> convertMedicationRequestStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationRequest.MedicationrequestStatus> tgt = new Enumeration<MedicationRequest.MedicationrequestStatus>(new MedicationRequest.MedicationrequestStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.STOPPED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.DRAFT);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationrequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus> convertMedicationRequestStatus(Enumeration<MedicationRequest.MedicationrequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationRequest.MedicationRequestStatus>(new MedicationRequest.MedicationRequestStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationRequest.MedicationrequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ONHOLD);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.CANCELLED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.STOPPED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.DRAFT);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationRequest.MedicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAllowed()) {
            tgt.setAllowed(VersionConvertor_30_50.convertBoolean(src.getAllowedElement()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_50.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasAllowedBooleanType()) {
            tgt.setAllowedElement(VersionConvertor_30_50.convertBoolean(src.getAllowedBooleanType()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_50.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }
}

