/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.MedicationDispense;

public class MedicationDispense30_50 {
    public static org.hl7.fhir.dstu3.model.MedicationDispense convertMedicationDispense(MedicationDispense src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.MedicationDispense tgt = new org.hl7.fhir.dstu3.model.MedicationDispense();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense30_50.convertMedicationDispenseStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(VersionConvertor_30_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_50.convertReference(src.getEncounter()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_50.convertReference(reference));
        }
        for (MedicationDispense.MedicationDispensePerformerComponent medicationDispensePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationDispense30_50.convertMedicationDispensePerformerComponent(medicationDispensePerformerComponent));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_30_50.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPrepared()) {
            tgt.setWhenPreparedElement(VersionConvertor_30_50.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOver()) {
            tgt.setWhenHandedOverElement(VersionConvertor_30_50.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_50.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r5.model.Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_50.convertDosage(dosage));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense30_50.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationDispense convertMedicationDispense(org.hl7.fhir.dstu3.model.MedicationDispense src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense tgt = new MedicationDispense();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationDispense30_50.convertMedicationDispenseStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(VersionConvertor_30_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(VersionConvertor_30_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_50.convertReference(src.getContext()));
        }
        for (Reference reference : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_50.convertReference(reference));
        }
        for (MedicationDispense.MedicationDispensePerformerComponent medicationDispensePerformerComponent : src.getPerformer()) {
            tgt.addPerformer(MedicationDispense30_50.convertMedicationDispensePerformerComponent(medicationDispensePerformerComponent));
        }
        for (Reference reference : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_30_50.convertReference(reference));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_30_50.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPrepared()) {
            tgt.setWhenPreparedElement(VersionConvertor_30_50.convertDateTime(src.getWhenPreparedElement()));
        }
        if (src.hasWhenHandedOver()) {
            tgt.setWhenHandedOverElement(VersionConvertor_30_50.convertDateTime(src.getWhenHandedOverElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_50.convertReference(src.getDestination()));
        }
        for (Reference reference : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_50.convertDosage(dosage));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(MedicationDispense30_50.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        for (Reference reference : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_50.convertReference(reference));
        }
        for (Reference reference : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispensePerformerComponent convertMedicationDispensePerformerComponent(MedicationDispense.MedicationDispensePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispensePerformerComponent tgt = new MedicationDispense.MedicationDispensePerformerComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispensePerformerComponent convertMedicationDispensePerformerComponent(MedicationDispense.MedicationDispensePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispensePerformerComponent tgt = new MedicationDispense.MedicationDispensePerformerComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_50.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus> convertMedicationDispenseStatus(Enumeration<MedicationDispense.MedicationDispenseStatusCodes> src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus>();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationDispense.MedicationDispenseStatusCodes)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            case DECLINED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.STOPPED);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationDispense.MedicationDispenseStatusCodes> convertMedicationDispenseStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationDispense.MedicationDispenseStatus> src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Enumeration<MedicationDispense.MedicationDispenseStatusCodes> tgt = new Enumeration<MedicationDispense.MedicationDispenseStatusCodes>(new MedicationDispense.MedicationDispenseStatusCodesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationDispense.MedicationDispenseStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.ENTEREDINERROR);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.STOPPED);
                break;
            }
            case NULL: {
                tgt.setValue((Object)MedicationDispense.MedicationDispenseStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasWasSubstituted()) {
            tgt.setWasSubstitutedElement(VersionConvertor_30_50.convertBoolean(src.getWasSubstitutedElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getResponsibleParty()) {
            tgt.setResponsibleParty(VersionConvertor_30_50.convertReference(reference));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasWasSubstituted()) {
            tgt.setWasSubstitutedElement(VersionConvertor_30_50.convertBoolean(src.getWasSubstitutedElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getReason()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConcept(t));
        }
        if (src.hasResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_30_50.convertReference(src.getResponsibleParty()));
        }
        return tgt;
    }
}

